/*
 * Le71HR8821_IB_LITE_profiles.c --
 *
 * This file contains profile data in byte format
 *
 * Project Info --
 *   Type:   Le71HR8821G Line Module Project - Inverting Boost Power Supply and 8.192MHz PCLK
 *   Date:   Thursday, June 02, 2011 13:51:42
 *   Device: VoicePort Le88506
 *
 *   This file was generated with Profile Wizard Version: P2.0.0
 */

typedef unsigned char VpProfileDataType;

/************** Device Parameters **************/

/* Device Configuration Data */
VpProfileDataType DEV_PROFILE[] =
{
  /* Device Profile for VoicePort Device Family */
 0x00, 0xFF, 0x00, 0x1A, /* Profile Type and Length */
 0x05, 0x00, /* Version and MPI Command */
 0x04, 0x00, /* PCLK Frequency */
 0x83, 0x00, /* Device Config 1 and MCLK Correction */
 0x40, 0x02, /* Clock Slot and Max Events */
 0x0A, 0x00, /* Device Tickrate */
 0xE4, 0x00, 0x04, 0x1B, /* Inverting Boost (150V) Switching Regulator Parameters */
 0xB3, 0xFF, 0x94, 0x52, 0xFC, 0x52, /* Regulator Timing Parameters */
 0x20, 0x80, 0x3C, 0x52, 0x3C, 0x52  /* FreeRun Timing Parameters */
};

/* Device Configuration Data */
VpProfileDataType INVERTING_BOOST[] =
{
  /* Device Profile for VoicePort Device Family */
 0x00, 0xFF, 0x00, 0x1A, /* Profile Type and Length */
 0x05, 0x00, /* Version and MPI Command */
 0x20, 0x00, /* PCLK Frequency */
 0x8A, 0x00, /* Device Config 1 and MCLK Correction */
 0x40, 0x02, /* Clock Slot and Max Events */
 0x05, 0x00, /* Device Tickrate */
 0xE4, 0x00, 0x04, 0x1B, /* Inverting Boost (150V) Switching Regulator Parameters */
 0xB3, 0xFF, 0x94, 0x52, 0xFC, 0x52, /* Regulator Timing Parameters */
 0x20, 0x80, 0x3C, 0x52, 0x3C, 0x52  /* FreeRun Timing Parameters */
};

/************** AC Coefficients **************/

/* AC FXS RF14 600 Ohm Coefficients [Default] */
VpProfileDataType AC_600R_FXS[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 600 Ohm Coefficients [Default] */
VpProfileDataType AC_FXS_RF14_DEF[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 900 Ohm Coefficients */
VpProfileDataType AC_FXS_RF14_900[] =
{
  /* AC Profile */
 0xE4, 0x00, 0xF7, 0x4C, 0x01, 0x49, 0xCA, 0x0B, 0x98, 0x34, 0x3B, 0xB2,
 0x2C, 0x9F, 0xA4, 0xD2, 0xA3, 0x22, 0xAC, 0x9A, 0xA4, 0xAA, 0x67, 0x9F,
 0x01, 0x8A, 0xB3, 0xD0, 0xA6, 0x21, 0xAA, 0x34, 0x2B, 0x2F, 0x4A, 0xA6,
 0xAB, 0x2F, 0x4A, 0x37, 0x88, 0x2A, 0xC0, 0x23, 0xAC, 0x2A, 0x26, 0x32,
 0xA5, 0x3C, 0xAD, 0xA4, 0xA7, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xAB, 0x49, 0xF1, 0x2A, 0x0A, 0x43, 0xC9, 0xF3, 0x27, 0xBC,
 0xE2, 0xAF, 0xAD, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Australia 220+820//220nF Coefficients */
VpProfileDataType AC_FXS_RF14_AU[] =
{
  /* AC Profile */
 0xBF, 0x00, 0xAF, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0xBA, 0x41, 0x54,
 0xA2, 0x2A, 0x5B, 0xA4, 0xAA, 0x3A, 0xB3, 0x9A, 0x87, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x23, 0x20, 0x3E, 0xA8, 0x2A, 0x57, 0xCB, 0x34,
 0xBA, 0xAC, 0xBB, 0xA6, 0x88, 0xAA, 0xB0, 0x49, 0xF6, 0x3B, 0x2E, 0x49,
 0xFF, 0xBC, 0xA5, 0x3A, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x34, 0x5C, 0x32, 0x25, 0x1A, 0xA1, 0x3B, 0x23, 0xB3, 0x5B,
 0x4D, 0xB5, 0xDC, 0x60, 0x96, 0x3B, 0xA1, 0x00
};

/* AC FXS RF14 Austria 220+820//115nF Coefficients */
VpProfileDataType AC_FXS_RF14_AT[] =
{
  /* AC Profile */
 0x6D, 0x00, 0xA7, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xFA, 0xE1, 0x23,
 0xA2, 0xEA, 0xCB, 0xB3, 0xAA, 0xA3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xB3, 0x20, 0xAB, 0xA8, 0xCC, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0xD3, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0x22, 0x98, 0x02, 0x42, 0xA2, 0x43, 0xA6, 0xD8,
 0xFA, 0x8F, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Belgium 150+830//72 Coefficients */
VpProfileDataType AC_FXS_RF14_BE[] =
{
  /* AC Profile */
 0x8F, 0x00, 0x2E, 0x4C, 0x01, 0x49, 0xCA, 0xF3, 0x98, 0x2C, 0xA1, 0xB4,
 0xE3, 0x34, 0xCB, 0x2C, 0x2B, 0xA3, 0xA3, 0x9A, 0x87, 0xA6, 0x97, 0x9F,
 0x01, 0x8A, 0x42, 0xD0, 0xBA, 0x30, 0xC2, 0x49, 0xA3, 0x4C, 0xDC, 0xC2,
 0x22, 0x2B, 0xBA, 0xA4, 0x88, 0xB3, 0xB0, 0xA3, 0xA4, 0x4A, 0xDD, 0xCA,
 0xAD, 0x43, 0xA4, 0x22, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x3A, 0x42, 0xA1, 0xA4, 0x19, 0x81, 0x5A, 0x4B, 0x2F, 0xA2,
 0xFB, 0xAF, 0xBA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Brazil 900 Coefficients */
VpProfileDataType AC_FXS_RF14_BR[] =
{
  /* AC Profile */
 0xE4, 0x00, 0xF7, 0x4C, 0x01, 0x49, 0xCA, 0x0B, 0x98, 0x34, 0x3B, 0xB2,
 0x2C, 0x9F, 0xA4, 0xD2, 0xA3, 0x22, 0xAC, 0x9A, 0xA4, 0xAA, 0x67, 0x9F,
 0x01, 0x8A, 0xB3, 0xD0, 0xA6, 0x21, 0xAA, 0x34, 0x2B, 0x2F, 0x4A, 0xA6,
 0xAB, 0x2F, 0x4A, 0x37, 0x88, 0x2A, 0xC0, 0xA2, 0xAC, 0x2A, 0x26, 0x32,
 0xA5, 0x4C, 0xAD, 0xA4, 0xA7, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x3D, 0x53, 0x22, 0x52, 0x1A, 0x22, 0x2B, 0x6A, 0x87, 0x29,
 0xFB, 0x2F, 0xFC, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXA RF14 China 200+680//100nF Coefficients */
VpProfileDataType AC_FXS_RF14_CN[] =
{
  /* AC Profile */
 0xB9, 0x00, 0x1F, 0x4C, 0x01, 0x49, 0xCA, 0xE9, 0x98, 0x5C, 0xB1, 0xAA,
 0x23, 0x43, 0xEB, 0x32, 0xAA, 0x23, 0xB3, 0x9A, 0x98, 0x94, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x30, 0x6A, 0x59, 0x2A, 0xCB, 0xB4, 0xB2,
 0xBF, 0x3B, 0xA3, 0x25, 0x88, 0x43, 0xC0, 0x3A, 0x45, 0x2B, 0xBD, 0x4C,
 0x2E, 0x4C, 0x25, 0x42, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA4, 0x5A, 0x32, 0xB5, 0x12, 0xA1, 0xA2, 0x3A, 0xA4, 0xB5,
 0x64, 0x97, 0xAA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Czech Republic 600 Coefficients */
VpProfileDataType AC_FXS_RF14_CZ[] =
{
  /* AC Profile */
 0x1A, 0x00, 0x03, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x22, 0xBA, 0xA6, 0x9F,
 0x01, 0x8A, 0xAA, 0xC0, 0x97, 0xA0, 0xAA, 0x33, 0xD2, 0xDB, 0x7C, 0x23,
 0x2A, 0xEB, 0x32, 0xB4, 0x88, 0x2A, 0x20, 0x6C, 0xBC, 0xCE, 0xA6, 0x2B,
 0xA5, 0xAA, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5A, 0x22, 0xC7, 0x16, 0xE2, 0x2B, 0x42, 0xC6, 0xC8,
 0xFA, 0x9F, 0x2B, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Denmark 300+1000//220nF Coefficients */
VpProfileDataType AC_FXS_RF14_DK[] =
{
  /* AC Profile */
 0x7D, 0x00, 0x9A, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x22, 0xA1, 0x52,
 0xD2, 0xE7, 0x24, 0xF4, 0xCD, 0xAA, 0x97, 0x9A, 0xCA, 0xB3, 0xA5, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0xAB, 0x20, 0xAA, 0x49, 0x29, 0x7A, 0x32, 0xD6,
 0xA2, 0xED, 0xC5, 0x97, 0x88, 0xBA, 0xC0, 0x22, 0xA7, 0x2C, 0xFE, 0x42,
 0xDE, 0x22, 0xB6, 0xB3, 0x9F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x23, 0x53, 0x32, 0x2C, 0x1B, 0x22, 0xCA, 0x23, 0x63, 0x2A,
 0x33, 0xD4, 0x2A, 0x40, 0x96, 0xA2, 0xA0, 0x00
};

/* AC FXS RF14 ETSI 270+750//150nF Harmonized Coefficients */
VpProfileDataType AC_FXS_RF14_EU[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Finland 270+910//120 Coefficients */
VpProfileDataType AC_FXS_RF14_FI[] =
{
  /* AC Profile */
 0xFF, 0x00, 0x8D, 0x4C, 0x01, 0x49, 0xCA, 0xEF, 0x98, 0x2A, 0xB1, 0x23,
 0x33, 0xB2, 0xAB, 0x44, 0xEB, 0xA4, 0x44, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x24, 0x20, 0x25, 0xB8, 0x2D, 0x42, 0xDB, 0xBA,
 0xE3, 0x43, 0xF2, 0xAC, 0x88, 0xC4, 0xB0, 0xA2, 0xA7, 0x42, 0x3E, 0xA2,
 0x9F, 0x32, 0x26, 0xBE, 0x2F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA2, 0x5C, 0x22, 0xA2, 0x13, 0xC1, 0xB3, 0x22, 0x23, 0x7A,
 0x3D, 0xB4, 0xD4, 0x50, 0x96, 0x3C, 0x41, 0x00
};

/* AC FXS RF14 France 215+1000//137nF Coefficients */
VpProfileDataType AC_FXS_RF14_FR[] =
{
  /* AC Profile */
 0xFC, 0x00, 0xA4, 0x4C, 0x01, 0x49, 0xCA, 0xE7, 0x98, 0xBA, 0x31, 0xA5,
 0x62, 0x35, 0xAB, 0xAA, 0xAA, 0xAC, 0xA3, 0x9A, 0xAA, 0xA2, 0xC7, 0x6F,
 0x01, 0x8A, 0x2D, 0x01, 0xBB, 0x10, 0xC2, 0x38, 0x2A, 0xA1, 0xC2, 0xA9,
 0x23, 0xA2, 0x22, 0x2D, 0x88, 0xA3, 0xB0, 0x53, 0x55, 0x4A, 0xAD, 0xB2,
 0xAD, 0x5A, 0x25, 0x72, 0x5E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x43, 0x22, 0x9F, 0x1A, 0x22, 0x4B, 0x33, 0xD5, 0x2C,
 0x7A, 0x87, 0xA8, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 German 220+820//115nF Coefficients */
VpProfileDataType AC_FXS_RF14_DE[] =
{
  /* AC Profile */
 0xEB, 0x00, 0xDC, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xA2, 0xE1, 0x24,
 0xA2, 0x2A, 0xCB, 0xB3, 0xAA, 0xD3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x24, 0x20, 0x2C, 0xA8, 0xAB, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0x23, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x53, 0x54, 0x32, 0xC4, 0x1A, 0xA1, 0x2B, 0x2A, 0xA3, 0xAA,
 0x4A, 0xA5, 0xBA, 0x60, 0x96, 0xD2, 0xA1, 0x00
};

/* AC FXS RF14 Greece 400+500//50nF Coefficients */
VpProfileDataType AC_FXS_RF14_GR[] =
{
  /* AC Profile */
 0x63, 0x00, 0x7D, 0x4C, 0x01, 0x49, 0xCA, 0x03, 0x98, 0x22, 0xA6, 0x2C,
 0x3E, 0x2B, 0x87, 0x44, 0x36, 0x2A, 0x9F, 0x9A, 0x22, 0xBA, 0xA7, 0x9F,
 0x01, 0x8A, 0x7D, 0xD0, 0xAA, 0xA0, 0x22, 0xAA, 0x98, 0xB4, 0x23, 0xBE,
 0xAB, 0xBF, 0xAA, 0x97, 0x88, 0x3C, 0xC0, 0x3A, 0xBD, 0xED, 0x8F, 0xEB,
 0xA6, 0x3A, 0x8F, 0x2B, 0x6F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xD2, 0x52, 0x22, 0xA2, 0x13, 0xA1, 0x97, 0x32, 0x25, 0xCA,
 0x6B, 0x87, 0x2B, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Hungary 600 Coefficients */
VpProfileDataType AC_FXS_RF14_HU[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 India 600 Coefficients */
VpProfileDataType AC_FXS_RF14_IN[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Italy 180+630//60nF Coefficients */
VpProfileDataType AC_FXS_RF14_IT[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xF3, 0x98, 0x22, 0xD2, 0xBA,
 0x34, 0x22, 0x3C, 0x53, 0xAB, 0xAA, 0xB4, 0x9A, 0x98, 0x1B, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0xBC, 0xD0, 0x2A, 0x2A, 0x3C, 0x4C, 0x4E, 0x23,
 0xD2, 0xBB, 0xDB, 0x55, 0x88, 0xAA, 0xC0, 0x2C, 0xB5, 0x23, 0xAD, 0x4A,
 0x5E, 0xAD, 0xB5, 0x2B, 0x2E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA2, 0x52, 0xA1, 0xA3, 0x1A, 0x32, 0xAA, 0x4A, 0xAF, 0x3B,
 0xF4, 0x9F, 0x3A, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Japan 600+1uF Coefficients */
VpProfileDataType AC_FXS_RF14_JP[] =
{
  /* AC Profile */
 0x0C, 0x00, 0x79, 0x4C, 0x01, 0x49, 0xCA, 0xF9, 0x98, 0xAC, 0xEE, 0x2A,
 0x87, 0x2A, 0x3F, 0xA3, 0x97, 0xE5, 0xC3, 0x9A, 0xAB, 0xA2, 0x24, 0xA6,
 0xD0, 0x8A, 0x42, 0xB0, 0x2A, 0xA0, 0x34, 0xAA, 0x3B, 0xA2, 0xCA, 0xAA,
 0xA4, 0x24, 0x3B, 0x4D, 0x88, 0xBA, 0x30, 0xAC, 0x2D, 0xAA, 0xCE, 0xAA,
 0x25, 0x22, 0x2C, 0xB2, 0x65, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x3B, 0x52, 0xA1, 0xA5, 0x14, 0xA2, 0x23, 0x44, 0x24, 0xA5,
 0x4B, 0xA4, 0xAC, 0x40, 0x96, 0x32, 0xD0, 0x00
};

/* AC FXS RF14 S. Korea 600 Coefficients */
VpProfileDataType AC_FXS_RF14_KR[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Mexico 600 Coefficients */
VpProfileDataType AC_FXS_RF14_MX[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Netherlands 600/340+422//100 Coefficients */
VpProfileDataType AC_FXS_RF14_NL[] =
{
  /* AC Profile */
 0x7D, 0x00, 0x38, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x22, 0xBA, 0xA6, 0x9F,
 0x01, 0x8A, 0x34, 0xD0, 0xCD, 0xA0, 0xAB, 0xD3, 0x22, 0xAB, 0x4A, 0xA3,
 0xA2, 0x2C, 0xAB, 0x45, 0x88, 0x2A, 0x20, 0x6C, 0xBC, 0xCE, 0xA6, 0x2B,
 0xA5, 0xAA, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x62, 0x52, 0x22, 0xCD, 0x12, 0x23, 0x44, 0x7A, 0x87, 0x3B,
 0xFC, 0xBF, 0xBA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 New Zealand 370+620//310nF Coefficients */
VpProfileDataType AC_FXS_RF14_NZ[] =
{
  /* AC Profile */
 0x14, 0x00, 0x00, 0x4C, 0x01, 0x49, 0xCA, 0xE9, 0x98, 0xAA, 0xB3, 0xB2,
 0xA2, 0xDA, 0xA3, 0x2B, 0x36, 0xAA, 0x25, 0x9A, 0x2B, 0xA2, 0x27, 0x6F,
 0x01, 0x8A, 0x1D, 0x01, 0x52, 0x50, 0x2A, 0x3B, 0x45, 0xA9, 0xCA, 0xA3,
 0x2C, 0xAB, 0xAA, 0x27, 0x88, 0xC3, 0x50, 0xBA, 0x8F, 0x37, 0x2F, 0xC2,
 0xBE, 0xEA, 0x87, 0xAA, 0x87, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x53, 0x53, 0x32, 0xCB, 0x1C, 0x42, 0x32, 0x3B, 0xB3, 0xA2,
 0x42, 0xB4, 0x23, 0x50, 0x96, 0x42, 0xA0, 0x00
};

/* AC FXS RF14 Norway 120+820//110nF Coefficients */
VpProfileDataType AC_FXS_RF14_NO[] =
{
  /* AC Profile */
 0x04, 0x00, 0xA8, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0xAA, 0x41, 0x22,
 0xA1, 0xAA, 0x3B, 0x23, 0x2A, 0xD4, 0x23, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0xEA, 0x10, 0x22, 0xB8, 0x22, 0x3B, 0x23, 0xA1,
 0xAA, 0xBA, 0x32, 0xC4, 0x88, 0x25, 0xB0, 0x3B, 0x24, 0x2C, 0x2D, 0xA3,
 0xAC, 0xF4, 0xC4, 0xAB, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xBB, 0x52, 0xE2, 0xBD, 0x1B, 0xA1, 0x3B, 0x2A, 0xA3, 0x3A,
 0x4A, 0x26, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Portugal 600 Coefficients */
VpProfileDataType AC_FXS_RF14_PT[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Slovenia 600/220+820//115 Coefficients */
VpProfileDataType AC_FXS_RF14_SI[] =
{
  /* AC Profile */
 0x00, 0x00, 0x00, 0x4C, 0x00, 0x49, 0xCA, 0xF5, 0x98, 0x2A, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2B, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0x55, 0xA0, 0xA2, 0xA2, 0x57, 0x2B, 0xC6, 0x23,
 0x34, 0xBB, 0x6A, 0xC5, 0x88, 0x2A, 0x20, 0x6C, 0xBC, 0xCE, 0xA6, 0x2B,
 0xA5, 0xAA, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xC8, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5A, 0x22, 0xC7, 0x16, 0xE2, 0x2B, 0x42, 0xC6, 0xC8,
 0xFA, 0x9F, 0x2B, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Spain 220+820//120nF Coefficients */
VpProfileDataType AC_FXS_RF14_ES[] =
{
  /* AC Profile */
 0xBF, 0x00, 0xAF, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0xBA, 0x41, 0x54,
 0xA2, 0x2A, 0x5B, 0xA4, 0xAA, 0x3A, 0xB3, 0x9A, 0x87, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x23, 0x20, 0x3E, 0xA8, 0x2A, 0x57, 0xCB, 0x34,
 0xBA, 0xAC, 0xBB, 0xA6, 0x88, 0xAA, 0xB0, 0x49, 0xF6, 0x3B, 0x2E, 0x49,
 0xFF, 0xBC, 0xA5, 0x3A, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x34, 0x5C, 0x32, 0x25, 0x1A, 0xA1, 0x3B, 0x23, 0xB3, 0x5B,
 0x4D, 0xB5, 0xDC, 0x60, 0x96, 0x3B, 0xA1, 0x00
};

/* AC FXS RF14 Sweden 200+1000//100nF_900//30nF Coefficients */
VpProfileDataType AC_FXS_RF14_SE[] =
{
  /* AC Profile */
 0x0E, 0x00, 0x42, 0x4C, 0x01, 0x49, 0xCA, 0xF0, 0x98, 0x24, 0xF1, 0xB4,
 0xA2, 0xAB, 0x4B, 0x4B, 0xAA, 0xA7, 0xC3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0xB3, 0x20, 0x5B, 0xB8, 0x24, 0xA2, 0x3C, 0xAC,
 0xAA, 0x27, 0x32, 0x9F, 0x88, 0x3A, 0xA0, 0x3A, 0x25, 0x3A, 0xAD, 0x22,
 0xAD, 0xBE, 0x25, 0xA5, 0x2E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x73, 0x52, 0x22, 0xD2, 0x12, 0xB1, 0x4A, 0x23, 0xC4, 0xC3,
 0x6A, 0x97, 0xA8, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 U.K. 300+1000//220_370+620//310nF Coefficients */
VpProfileDataType AC_FXS_RF14_GB[] =
{
  /* AC Profile */
 0x24, 0x00, 0x0A, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x22, 0xA1, 0x52,
 0xD2, 0xE7, 0x24, 0xF4, 0xCD, 0xAA, 0x97, 0x9A, 0x2B, 0xA2, 0x27, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0xCB, 0x20, 0xBB, 0x59, 0x5A, 0x4A, 0xAA, 0xB5,
 0x2C, 0x2D, 0x42, 0xC7, 0x88, 0xAA, 0xC0, 0xA3, 0xA7, 0xBA, 0xDE, 0x5C,
 0xCE, 0xAA, 0xA6, 0xA2, 0x9F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x43, 0x5B, 0x32, 0x2C, 0x1D, 0x22, 0xAA, 0x2B, 0x33, 0xBA,
 0x3C, 0x34, 0xBA, 0x40, 0x96, 0xA2, 0xA0, 0x00
};

/* AC FXS RF14 US 900//2.16uF_1650//(100+5nF) Coefficients */
VpProfileDataType AC_FXS_RF14_US_loaded[] =
{
  /* AC Profile */
 0x01, 0x00, 0x90, 0x4C, 0x01, 0x49, 0xCA, 0x0E, 0x98, 0x32, 0x2B, 0x24,
 0x7C, 0x4A, 0x24, 0x55, 0xA3, 0x3A, 0xBC, 0x9A, 0xBA, 0xB3, 0xF4, 0x2D,
 0x01, 0x8A, 0xEB, 0xC0, 0x26, 0x21, 0xB2, 0x35, 0xB3, 0xA6, 0x2A, 0xAD,
 0xD4, 0xA6, 0x52, 0x4F, 0x88, 0xA3, 0xD0, 0x23, 0xAA, 0xAF, 0x62, 0xEA,
 0xBA, 0x2A, 0xB3, 0x4A, 0x3D, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x4C, 0x21, 0xAC, 0x03, 0xB2, 0xA5, 0x5A, 0xE4, 0x74,
 0xF3, 0xA5, 0xBE, 0x60, 0x96, 0xAA, 0xC0, 0x00
};

/* AC FXS RF14 US 900//2,16uF_800//(100+50nF) Coefficients */
VpProfileDataType AC_FXS_RF14_US_Nonloaded[] =
{
  /* AC Profile */
 0x01, 0x00, 0x90, 0x4C, 0x01, 0x49, 0xCA, 0x0E, 0x98, 0x32, 0x2B, 0x24,
 0x7C, 0x4A, 0x24, 0x55, 0xA3, 0x3A, 0xBC, 0x9A, 0xBA, 0xB3, 0xF4, 0x2D,
 0x01, 0x8A, 0xEB, 0xC0, 0x26, 0x21, 0xB2, 0x35, 0xB3, 0xA6, 0x2A, 0xAD,
 0xD4, 0xA6, 0x52, 0x4F, 0x88, 0xA3, 0xD0, 0x23, 0xAA, 0xAF, 0x62, 0xEA,
 0xBA, 0x2A, 0xB3, 0x4A, 0x3D, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xBD, 0x52, 0xA1, 0x62, 0x1B, 0x22, 0x3A, 0x4B, 0xB5, 0x2A,
 0x65, 0xA7, 0xB6, 0x70, 0x96, 0x23, 0xC0, 0x00
};

/* AC FXS RF14 US 900//2.16uF Coefficients */
VpProfileDataType AC_FXS_RF14_US_SS[] =
{
  /* AC Profile */
 0x01, 0x00, 0x90, 0x4C, 0x01, 0x49, 0xCA, 0x0E, 0x98, 0x32, 0x2B, 0x24,
 0x7C, 0x4A, 0x24, 0x55, 0xA3, 0x3A, 0xBC, 0x9A, 0xBA, 0xB3, 0xF4, 0x2D,
 0x01, 0x8A, 0xEB, 0xC0, 0x26, 0x21, 0xB2, 0x35, 0xB3, 0xA6, 0x2A, 0xAD,
 0xD4, 0xA6, 0x52, 0x4F, 0x88, 0xA3, 0xD0, 0x23, 0xAA, 0xAF, 0x62, 0xEA,
 0xBA, 0x2A, 0xB3, 0x4A, 0x3D, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xDA, 0x4A, 0x41, 0x3A, 0x02, 0x23, 0x3A, 0x42, 0x25, 0xAA,
 0x72, 0xA5, 0x2B, 0x50, 0x96, 0x1D, 0x01, 0x00
};

/************** DC Parameters **************/

/* DC FXS Default 25 mA current feed */
VpProfileDataType DC_25MA_CC[] =
{
 /* DC Profile */
 0x00, 0x01, 0x00, 0x0B, 0x01, 0x08, 0xC2, 0x19, 0x84, 0xC2, 0x07, 0xC6,
 0x33, 0x07, 0x01
};

/* DC FXS Default 25 mA current feed */
VpProfileDataType DC_FXS_DEF[] =
{
 /* DC Profile */
 0x00, 0x01, 0x00, 0x0B, 0x01, 0x08, 0xC2, 0x19, 0x84, 0xC2, 0x07, 0xC6,
 0x33, 0x07, 0x01
};

/************** Ring Parameters **************/

/* US Ringing, 20Hz, Sinewave, 88Vpk + 48VDC */
VpProfileDataType RING_20HZ_SINE[] =
{
  /* Sine, 20 Hz, 1.41 CF, 88.00 Vpk, 48.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x27, 0xCC, 0x00, 0x37,
 0x48, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Default Ringing, 25Hz, Sinewave, 88Vpk + 48VDC */
VpProfileDataType RING_DEF[] =
{
  /* Sine, 25 Hz, 1.41 CF, 88.00 Vpk, 48.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x27, 0xCC, 0x00, 0x44,
 0x48, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* US Ringing, 20Hz, Sinewave, 88Vpk + 48VDC */
VpProfileDataType RING_US[] =
{
  /* Sine, 20 Hz, 1.41 CF, 88.00 Vpk, 48.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x27, 0xCC, 0x00, 0x37,
 0x48, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Canada Ringing 20Hz, Sinewave, 88Vpk + 48VDC */
VpProfileDataType RING_CA[] =
{
  /* Sine, 20 Hz, 1.41 CF, 88.00 Vpk, 48.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x27, 0xCC, 0x00, 0x37,
 0x48, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* France Ringing 50Hz, Sinewave, 80Vpk */
VpProfileDataType RING_FR[] =
{
  /* Sine, 50 Hz, 1.41 CF, 80.00 Vpk, 48.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x27, 0xCC, 0x00, 0x89,
 0x42, 0x55, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Japan Ringing 16Hz, Sinewave, 92Vpk */
VpProfileDataType RING_JP[] =
{
  /* Sine, 16 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x2C,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* S. Korea Ringing 20Hz, Sinewave, 92Vpk */
VpProfileDataType RING_KR[] =
{
  /* Sine, 20 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Taiwan Ringing 20Hz, Sinewave, 92Vpk */
VpProfileDataType RING_TW[] =
{
  /* Sine, 20 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Hong Kong Ringing 20Hz, Sinewave, 92Vpk */
VpProfileDataType RING_HK[] =
{
  /* Sine, 20 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Singapore Rnging, 24Hz, Sinewave, 92Vpk */
VpProfileDataType RING_SG[] =
{
  /* Sine, 24 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x42,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Austria Ringing 50Hz, Sinewave, 92Vpk */
VpProfileDataType RING_AT[] =
{
  /* Sine, 50 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x89,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/* Australia Ringing 20Hz, Sinewave, 92Vpk */
VpProfileDataType RING_AU[] =
{
  /* Sine, 20 Hz, 1.41 CF, 92.00 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x00, 0x0E, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x4C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00
};

/************** Call Progress Tones **************/

/* US Dial Tone */
VpProfileDataType TONE_DIAL[] =
{
 /* 350.09 Hz, -13.00 dBm0, 440.17 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x03, 0xBC, 0x13, 0xF6,
 0x04, 0xB2, 0x13, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Special Information Tone (Called Number Not Connected) */
VpProfileDataType TONE_SIT[] =
{
 /* 949.92 Hz, -8.00 dBm0, 1399.98 Hz, -8.00 dBm0, 1799.87 Hz, -8.00 dBm0, 0.00 Hz, 0.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x0A, 0x22, 0x23, 0x7F,
 0x0E, 0xEF, 0x23, 0x7F, 0x13, 0x33, 0x23, 0x7F, 0x00, 0x00, 0x00, 0x00
};

/* Busy Signal */
VpProfileDataType TONE_BUSY[] =
{
 /* 480.09 Hz, -16.00 dBm0, 619.98 Hz, -16.00 dBm0, 0.00 Hz, -16.00 dBm0, 0.00 Hz, -16.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x05, 0x1F, 0x0E, 0x21,
 0x06, 0x9D, 0x0E, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Standard Ringback */
VpProfileDataType TONE_RINGBACK[] =
{
 /* 440.17 Hz, -13.00 dBm0, 480.09 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x04, 0xB2, 0x13, 0xF6,
 0x05, 0x1F, 0x13, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Call Waiting Beep */
VpProfileDataType TONE_CALLWAIT[] =
{
 /* 440.17 Hz, -13.00 dBm0, 0.00 Hz, 6.02 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x04, 0xB2, 0x13, 0xF6,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* US Reorder tone */
VpProfileDataType TONE_REORDER[] =
{
 /* 480.09 Hz, -16.00 dBm0, 619.98 Hz, -16.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x05, 0x1F, 0x0E, 0x21,
 0x06, 0x9D, 0x0E, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* A 1kHz tone at -10dBm0 */
VpProfileDataType TONE_ONEKHZ_L[] =
{
 /* 1000.09 Hz, -10.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x0A, 0xAB, 0x1C, 0x32,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* A 1kHz tone at 0dBm0 */
VpProfileDataType TONE_ONEKHZ_H[] =
{
 /* 1000.09 Hz, 0.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x0A, 0xAB, 0x59, 0x2A,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Caller ID Alert Tone for UK Cadence */
VpProfileDataType TONE_CLI[] =
{
 /* 2129.82 Hz, -13.00 dBm0, 2750.16 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0, 0.00 Hz, -13.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x16, 0xB8, 0x13, 0xF6,
 0x1D, 0x56, 0x13, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Receiver Off-Hook */
VpProfileDataType TONE_ROH[] =
{
 /* 1399.98 Hz, 0.00 dBm0, 2059.88 Hz, 0.00 dBm0, 2449.88 Hz, 0.00 dBm0, 2600.02 Hz, 0.00 dBm0 */
 /* Tone Profile */
 0x00, 0x02, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x0E, 0xEF, 0x59, 0x2A,
 0x15, 0xF9, 0x59, 0x2A, 0x1A, 0x22, 0x59, 0x2A, 0x1B, 0xBC, 0x59, 0x2A
};

/************** Cadence Definitions **************/

/* Australia Howler Tone Cadence */
VpProfileDataType TONE_CAD_AUS_HWL[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0C, 0x00, 0x08, 0x00, 0x08, 0x00, 0x81, 0x08, 0x00,
 0x20, 0x02, 0x41, 0x00
};

/* UK Howler Tone Cadence */
VpProfileDataType TONE_CAD_UK_HOWL[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0C, 0x00, 0x04, 0x00, 0x08, 0x00, 0x81, 0x08, 0x00,
 0x20, 0x02, 0x41, 0x00
};

/* Standard dial tone cadence */
VpProfileDataType TONE_CAD_DIAL0[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8F, 0x20, 0x00
};

/* Stutter dial tone cadence */
VpProfileDataType TONE_CAD_DIAL1[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x10, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x8F, 0x20, 0x14,
 0x00, 0x80, 0x20, 0x14, 0x40, 0x03, 0x00, 0x8F
};

/* Busy signal cadence (0.5 sec on 0.5 sec off) */
VpProfileDataType TONE_CAD_BUSY0[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x8F, 0x20, 0x64,
 0x00, 0x80, 0x20, 0x64, 0x40, 0x00
};

/* Tone Reorder cadence (0.25 sec on 0.25 sec off) */
VpProfileDataType TONE_CAD_REORDER[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x8F, 0x20, 0x32,
 0x00, 0x80, 0x20, 0x32, 0x40, 0x00
};

/* Standard Ringing Cadence (2 sec on 4 sec off) */
VpProfileDataType RING_CAD_STD[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x1C, 0x00, 0x00, 0x00, 0x18, 0x01, 0x07, 0x21, 0x90,
 0x01, 0x00, 0x20, 0x28, 0x01, 0x05, 0x02, 0x01, 0x22, 0xF8, 0x01, 0x07,
 0x21, 0x90, 0x01, 0x00, 0x23, 0x20, 0x47, 0x00
};

/* Ringback Cadence */
VpProfileDataType TONE_CAD_RNGBACK[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x8F, 0x21, 0x90,
 0x00, 0x80, 0x23, 0x20, 0x40, 0x00
};

/* Ringing Always On */
VpProfileDataType RING_CAD_ON[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8F, 0x20, 0x00
};

/* Receiver Off-Hook */
VpProfileDataType TONE_CAD_ROH[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x8F, 0x20, 0x14,
 0x00, 0x80, 0x20, 0x14, 0x40, 0x00
};

/* SIT Cadence */
VpProfileDataType TONE_CAD_SIT[] =
{
  /* Cadence Profile */
 0x00, 0x03, 0x01, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x81, 0x20, 0x3C,
 0x00, 0x82, 0x20, 0x3C, 0x00, 0x84, 0x20, 0x3C, 0x00, 0x80, 0x20, 0x00
};

/************** Caller ID **************/

/* US Caller ID Type II */
VpProfileDataType CID_TYPE2_US[] =
{
  /* Space=2100Hz, Mark=1300Hz, Amp=-13.50dBm */
  /* Caller ID Profile */
  0x00, 0x05, 0x00, 0x4C, 0x00, 0x00,
  0x09, 0xD4, /* MPI Length and Command */
  0x16, 0x66, 0x12, 0xD8, 0x0D, 0xDD, 0x12, 0xD8, /* MPI Data */
  0x00, 0x01, /* Checksum Computed by device/API */
  0x00, 0x3C, /* Length of Elements Data */
  0x00, 0x02, /* Mute the far end */
  0x00, 0x04, /* Alert Tone */
  /* Call Waiting Beep */
  /* 440.17 Hz, -13.00 dBm0, 0.00 Hz, 6.02 dBm0 */
  0x09, 0xD4, 0x04, 0xB2, 0x13, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x01, 0x2C, /* Alert Tone Part 2 - Tone+Cadence = 300ms */
  0x00, 0x06, 0x00, 0x0A, /* Silence Interval for 10ms */
  0x00, 0x04, /* Alert Tone */
  /* Caller ID Alert Tone for UK Cadence */
  /* 2129.82 Hz, -13.00 dBm0, 2750.16 Hz, -13.00 dBm0 */
  0x09, 0xD4, 0x16, 0xB8, 0x13, 0xF6, 0x1D, 0x56, 0x13, 0xF6,
  0x00, 0x05, 0x00, 0x50, /* Alert Tone Part 2 - Tone+Cadence = 80ms */
  0x00, 0x08, 0x00, 0xA0, 0x00, 0xD0, 0x00, 0x00, /* Detect Tone A | D, Timeout = 160ms */
  0x00, 0x06, 0x00, 0x64, /* Silence Interval for 100ms */
  0x00, 0x0A, 0x00, 0x46, /* Mark Signal for 70ms */
  0x00, 0x0B, /* Message Data (FSK Format) */
  0x00, 0x03, /* Unmute the far end */
  0x00, 0x0D  /* End of Transmission */
};

/* UK Caller ID Type I */
VpProfileDataType CID_TYPE1_UK[] =
{
  /* Space=2100Hz, Mark=1300Hz, Amp=-7.00dBm */
  /* Caller ID Profile */
  0x00, 0x05, 0x00, 0x42, 0x00, 0x00,
  0x09, 0xD4, /* MPI Length and Command */
  0x16, 0x66, 0x27, 0xD4, 0x0D, 0xDD, 0x27, 0xD4, /* MPI Data */
  0x00, 0x01, /* Checksum Computed by device/API */
  0x00, 0x32, /* Length of Elements Data */
  0x00, 0x06, 0x00, 0x32, /* Silence Interval for 50ms */
  0x00, 0x01, /* Line Reversal */
  0x00, 0x06, 0x00, 0x64, /* Silence Interval for 100ms */
  0x00, 0x04, /* Alert Tone */
  /* Caller ID Alert Tone for UK Cadence */
  /* 2129.82 Hz, -13.00 dBm0, 2750.16 Hz, -13.00 dBm0 */
  0x09, 0xD4, 0x16, 0xB8, 0x13, 0xF6, 0x1D, 0x56, 0x13, 0xF6,
  0x00, 0x05, 0x00, 0x64, /* Alert Tone Part 2 - Tone+Cadence = 100ms */
  0x00, 0x07, 0x00, 0x64, 0x00, 0x14, /* Silence Interval for 100ms, Masked-hook Interval for 20ms */
  0x00, 0x09, 0x00, 0x64, /* Channel Seizure for 100ms */
  0x00, 0x0A, 0x00, 0x32, /* Mark Signal for 50ms */
  0x00, 0x0B, /* Message Data (FSK Format) */
  0x00, 0x06, 0x00, 0xC8, /* Silence Interval for 200ms */
  0x00, 0x01, /* Line Reversal */
  0x00, 0x0D  /* End of Transmission */
};

/* US Caller ID (Type 1 - On-Hook) */
VpProfileDataType CLI_TYPE1_US[] =
{
  /* Space=2200Hz, Mark=1200Hz, Amp=-7.00dBm */
  /* Caller ID Profile */
  0x00, 0x05, 0x00, 0x20, 0x00, 0x00,
  0x09, 0xD4, /* MPI Length and Command */
  0x17, 0x77, 0x27, 0xD4, 0x0C, 0xCC, 0x27, 0xD4, /* MPI Data */
  0x00, 0x01, /* Checksum Computed by device/API */
  0x00, 0x10, /* Length of Elements Data */
  0x00, 0x06, 0x02, 0x08, /* Silence Interval for 520ms */
  0x00, 0x09, 0x00, 0xFA, /* Channel Seizure for 250ms */
  0x00, 0x0A, 0x00, 0x96, /* Mark Signal for 150ms */
  0x00, 0x0B, /* Message Data (FSK Format) */
  0x00, 0x0D  /* End of Transmission */
};

/************** Metering Profile **************/

/* Metering */
VpProfileDataType METER_PROFILE[] =
{
  /* Metering Profile */
  0x00, 0x07, 0x00, 0x08, 0x00, 0x05,
  0xD0, 0x01,  /* 12 kHz Tone, MLIM = 20.21 mVpeak */
  0x7E, 0x00,  /* Smooth, MTRSL = 12.16 mArms */
  0x00, 0x00
};

/* end of file Le71HR8821_IB_LITE_profiles.c */
