/*
 * File: sound/soc/cs75xx/cs75xx_snd_sport_reg.h
 * Description: ASoC platform driver for CS75XX - DMA engine
 *
 * Copyright (c) Cortina-Systems Limited 2012. All rights reserved.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __CS755XX_SND_SPORT_REG_H__
#define __CS755XX_SND_SPORT_REG_H__

/* SSP Register Map ***********************************************************/
#define CS75XX_SSP_ID				0x00
#define CS75XX_SSP_CTRL0			0x04
#define CS75XX_SSP_CTRL1			0x08
#define CS75XX_SSP_FRAME_CTRL0			0x0C
#define CS75XX_SSP_FRAME_CTRL1			0x10
#define CS75XX_SSP_BAUD_RATE			0x14
#define CS75XX_SSP_FIFO_CTRL			0x18
#define CS75XX_SSP_FIFO_PTR			0x1C
#define CS75XX_SSP_INTERRUPT			0x20
#define CS75XX_SSP_INTENABLE			0x24
#define CS75XX_SSP_TXSLOT_VLD0			0x28
#define CS75XX_SSP_TXSLOT_VLD1			0x2C
#define CS75XX_SSP_TXSLOT_VLD2			0x30
#define CS75XX_SSP_TXSLOT_VLD3			0x34
#define CS75XX_SSP_RXSLOT_VLD0			0x38
#define CS75XX_SSP_RXSLOT_VLD1			0x3C
#define CS75XX_SSP_RXSLOT_VLD2			0x40
#define CS75XX_SSP_RXSLOT_VLD3			0x44
#define CS75XX_SSP_SLOT_SIZE0			0x48
#define CS75XX_SSP_SLOT_SIZE1			0x4C
#define CS75XX_SSP_SLOT_SIZE2			0x50
#define CS75XX_SSP_SLOT_SIZE3			0x54

#define SSP_DEV_ID(index)	((cs75xx_ssp_reg_read(index, CS75XX_SSP_ID) & 0x00FFFF00) >> 8)
#define SSP_REV_ID(index)       (cs75xx_ssp_reg_read(index, CS75XX_SSP_ID) & 0x000000FF)


/* DMA Register Map ***********************************************************/
#define CS75XX_DMA_SSP_RX_CTRL			0x00
#define CS75XX_DMA_SSP_TX_CTRL			0x04
#define CS75XX_DMA_SSP_RXQ5_CTRL		0x08
#define CS75XX_DMA_SSP_RXQ6_CTRL		0x0C
#define CS75XX_DMA_SSP_RXQ7_CTRL		0x10
#define CS75XX_DMA_SSP_TXQ5_CTRL		0x14
#define CS75XX_DMA_SSP_TXQ6_CTRL		0x18
#define CS75XX_DMA_SSP_TXQ7_CTRL		0x1C
#define CS75XX_DMA_SSP_RXQ5_PKTCNT_READ		0x20
#define CS75XX_DMA_SSP_RXQ6_PKTCNT_READ		0x24
#define CS75XX_DMA_SSP_RXQ7_PKTCNT_READ		0x28
#define CS75XX_DMA_SSP_TXQ5_PKTCNT_READ		0x2C
#define CS75XX_DMA_SSP_TXQ6_PKTCNT_READ		0x30
#define CS75XX_DMA_SSP_TXQ7_PKTCNT_READ		0x34
#define CS75XX_DMA_SSP_RXQ5_BASE_DEPTH		0x38
#define CS75XX_DMA_SSP_RXQ6_BASE_DEPTH		0x3C
#define CS75XX_DMA_SSP_RXQ7_BASE_DEPTH		0x40
#define CS75XX_DMA_SSP_RXQ5_WPTR		0x44
#define CS75XX_DMA_SSP_RXQ5_RPTR		0x48
#define CS75XX_DMA_SSP_RXQ6_WPTR		0x4C
#define CS75XX_DMA_SSP_RXQ6_RPTR		0x50
#define CS75XX_DMA_SSP_RXQ7_WPTR		0x54
#define CS75XX_DMA_SSP_RXQ7_RPTR		0x58
#define CS75XX_DMA_SSP_TXQ5_BASE_DEPTH		0x5C
#define CS75XX_DMA_SSP_TXQ6_BASE_DEPTH		0x60
#define CS75XX_DMA_SSP_TXQ7_BASE_DEPTH		0x64
#define CS75XX_DMA_SSP_TXQ5_WPTR		0x68
#define CS75XX_DMA_SSP_TXQ5_RPTR		0x6C
#define CS75XX_DMA_SSP_TXQ6_WPTR		0x70
#define CS75XX_DMA_SSP_TXQ6_RPTR		0x74
#define CS75XX_DMA_SSP_TXQ7_WPTR		0x78
#define CS75XX_DMA_SSP_TXQ7_RPTR		0x7C
#define CS75XX_DMA_SSP_RXQ5_FULL_THRESHOLD	0x80
#define CS75XX_DMA_SSP_RXQ6_FULL_THRESHOLD	0x84
#define CS75XX_DMA_SSP_RXQ7_FULL_THRESHOLD	0x88
#define CS75XX_DMA_SSP_RXQ5_PKTCNT		0x8C
#define CS75XX_DMA_SSP_RXQ6_PKTCNT		0x90
#define CS75XX_DMA_SSP_RXQ7_PKTCNT		0x94
#define CS75XX_DMA_SSP_RXQ5_FULL_DROP_PKTCNT	0x98
#define CS75XX_DMA_SSP_RXQ6_FULL_DROP_PKTCNT	0x9C
#define CS75XX_DMA_SSP_RXQ7_FULL_DROP_PKTCNT	0xA0
#define CS75XX_DMA_SSP_TXQ5_PKTCNT		0xA4
#define CS75XX_DMA_SSP_TXQ6_PKTCNT		0xA8
#define CS75XX_DMA_SSP_TXQ7_PKTCNT		0xAC
#define CS75XX_DMA_SSP_INTERRUPT_0		0xB0
#define CS75XX_DMA_SSP_INTENABLE_0		0xB4
#define CS75XX_DMA_SSP_INTERRUPT_1		0xB8
#define CS75XX_DMA_SSP_INTENABLE_1		0xBC
#define CS75XX_DMA_SSP_DESC_INTERRUPT		0xC0
#define CS75XX_DMA_SSP_DESC_INTENABLE		0xC4
#define CS75XX_DMA_SSP_RXQ5_INTERRUPT		0xC8
#define CS75XX_DMA_SSP_RXQ5_INTENABLE		0xCC
#define CS75XX_DMA_SSP_RXQ6_INTERRUPT		0xD0
#define CS75XX_DMA_SSP_RXQ6_INTENABLE		0xD4
#define CS75XX_DMA_SSP_RXQ7_INTERRUPT		0xD8
#define CS75XX_DMA_SSP_RXQ7_INTENABLE		0xDC
#define CS75XX_DMA_SSP_TXQ5_INTERRUPT		0xE0
#define CS75XX_DMA_SSP_TXQ5_INTENABLE		0xE4
#define CS75XX_DMA_SSP_TXQ6_INTERRUPT		0xE8
#define CS75XX_DMA_SSP_TXQ6_INTENABLE		0xEC
#define CS75XX_DMA_SSP_TXQ7_INTERRUPT		0xF0
#define CS75XX_DMA_SSP_TXQ7_INTENABLE		0xF4

#define CS75XX_DMA_SSP_DEPTH_MIN		3
#define CS75XX_DMA_SSP_DEPTH_MAX		13
#define CS75XX_DMA_WPTR_RPTR_MASK		0x00001FFF

#endif /* __CS755XX_SND_SPORT_H__ */

