/*
   *
   * Copyright (c) 2010 Cortina Systems, Inc.
   * All Rights Reserved.
   *
   */
#ifndef __CS_FE_HEAD_TABLE_H__
#define __CS_FE_HEAD_TABLE_H__

#include <mach/registers.h>
#include <mach/cs75xx_fe_core_table.h>


/* Low Level HW Table Access */
typedef struct {
	u32	field_type;
	u32	start_reg;
	u16	start_pos;
	u16	total_width;
} cs_reg_access_field_s;

/******************************** FETOP_FE **************************/

/* FE_AN_BNG_MAC_DATA */
typedef enum {
	FE_AN_BNG_MAC_ADDR,
	FE_AN_BNG_MAC_SA_DA,
	FE_AN_BNG_MAC_PSPID,
	FE_AN_BNG_MAC_PSPID_MASK,
	FE_AN_BNG_MAC_VALID,
	FE_AN_BNG_MAC_FIELDS_MAX,
} cs_fe_an_bng_mac_field_e;

static const cs_reg_access_field_s
cs_fe_an_bng_mac_fields[FE_AN_BNG_MAC_FIELDS_MAX] = {
	{FE_AN_BNG_MAC_ADDR,	FETOP_FE_AN_BNG_MAC_DATA0,	0,	48},

	{FE_AN_BNG_MAC_SA_DA,	FETOP_FE_AN_BNG_MAC_DATA1,	16,	1},
	{FE_AN_BNG_MAC_PSPID,	FETOP_FE_AN_BNG_MAC_DATA1,	17,	4},
	{FE_AN_BNG_MAC_PSPID_MASK,	FETOP_FE_AN_BNG_MAC_DATA1,	21,	1},
	{FE_AN_BNG_MAC_VALID,	FETOP_FE_AN_BNG_MAC_DATA1,	22,	1},
};


/* FE_L4_PORT_RNGS_DATA */
typedef enum {
	FE_L4_SP_DP_HIGH,
	FE_L4_SP_DP_LOW,
	FE_L4_SP_DP_VALID,
	FE_L4_PORT_RNGS_MAX
} cs_fe_l4_port_rngs_field_e;

static const cs_reg_access_field_s
cs_fe_l4_port_rngs_fields[FE_L4_PORT_RNGS_MAX] = {
	{FE_L4_SP_DP_HIGH,		FETOP_FE_L4_PORT_RNGS_DATA0,	0,	16},
	{FE_L4_SP_DP_LOW,		FETOP_FE_L4_PORT_RNGS_DATA0,	16,	16},
	{FE_L4_SP_DP_VALID,		FETOP_FE_L4_PORT_RNGS_DATA1,	0,	1},
};


/* FE_ETYPE */
typedef enum {
	FE_ETYPE_ETHERTYPE,
	FE_ETYPE_VALID,
	FE_ETYPE_FIELDS_MAX
} cs_fe_etype_field_e;

static const cs_reg_access_field_s
cs_fe_etype_fields[FE_ETYPE_FIELDS_MAX] = {
	{FE_ETYPE_ETHERTYPE,	FETOP_FE_ETYPE_DATA,	0,	16},
	{FE_ETYPE_VALID,		FETOP_FE_ETYPE_DATA,	16,	1},
};


/* FE_LLC_HDR */
typedef enum {
	FE_LLC_HDR,
	FE_LLC_VALID,
	FE_LLC_FIELDS_MAX
} cs_fe_llc_hdr_field_e;

static const cs_reg_access_field_s
cs_fe_llc_hdr_fields[FE_LLC_FIELDS_MAX] = {
	{FE_LLC_HDR,			FETOP_FE_LLC_HDR_DATA,	0,	24},
	{FE_LLC_VALID,			FETOP_FE_LLC_HDR_DATA,	24,	1},
};


/* FE_CFG_TPID */
typedef enum {
	FE_CFG_TPID_TPID,
	FE_CFG_TPID_FIELD_MAX
} cs_fe_cfg_tpid_field_e;

static const cs_reg_access_field_s
cs_fe_cfg_tpid_fields[FE_CFG_TPID_FIELD_MAX] = {
	{FE_CFG_TPID_TPID,		FETOP_FE_CFG_TPID0,		0,	64}
};


/* FE_PARSER_CFG */
typedef enum {
	FE_PRSR_CFG_PROG_OFFSET,
	FE_PRSR_IPV4_CHKSUM_CHK_ENABLE,
	FE_PRSR_L4_CHKSUM_CHK_ENABLE,
	FE_PRSR_CFG_FIELD_MAX
} cs_fe_parser_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_parser_cfg_fields[FE_PRSR_CFG_FIELD_MAX] = {
	{FE_PRSR_CFG_PROG_OFFSET,			FETOP_FE_PRSR_CFG_0,	0,	7},
	{FE_PRSR_IPV4_CHKSUM_CHK_ENABLE,	FETOP_FE_PRSR_CFG_0,	7,	1},
	{FE_PRSR_L4_CHKSUM_CHK_ENABLE,		FETOP_FE_PRSR_CFG_0,	8,	1},
};


/* FE_PROC_CFG_0 */
typedef enum {
	FE_PROC_CFG_NODROP_L3_CSUM_ERR_BYPASS,
	FE_PROC_CFG_NODROP_L4_CSUM_ERR_BYPASS,
	FE_PROC_CFG_KEEP_TS_FOR_CPU_VOQ,
	FE_PROC_CFG_FIELD_MAX
} cs_fe_proc_cfg_0_field_e;

static const cs_reg_access_field_s
cs_fe_proc_cfg_fields[FE_PROC_CFG_FIELD_MAX] = {
	{FE_PROC_CFG_NODROP_L3_CSUM_ERR_BYPASS,	FETOP_FE_PROC_CFG_0,	0,	1},
	{FE_PROC_CFG_NODROP_L4_CSUM_ERR_BYPASS,	FETOP_FE_PROC_CFG_0,	1,	1},
	{FE_PROC_CFG_KEEP_TS_FOR_CPU_VOQ,		FETOP_FE_PROC_CFG_0,	2,	1},
};


/* FE_LPB */
typedef enum {
	FE_LPB_LSPID,
	FE_LPB_PVID,
	FE_LPB_PVID_TPID_ENC,
	FE_LPB_OLSPID_EN,
	FE_LPB_OLSPID,
	FE_LPB_OLSPID_PRESERVE_EN,
	FE_LPB_MEM_PARITY,
	FE_LPB_FIELD_MAX,
} cs_fe_lpb_field_e;

static const cs_reg_access_field_s
cs_fe_lpb_fields[FE_LPB_FIELD_MAX] = {
	{FE_LPB_LSPID,			FETOP_FE_LPB_DATA,	0,	4},
	{FE_LPB_PVID,			FETOP_FE_LPB_DATA,	4,	12},
	{FE_LPB_PVID_TPID_ENC,	FETOP_FE_LPB_DATA,	16,	2},
	{FE_LPB_OLSPID_EN,		FETOP_FE_LPB_DATA,	18,	1},
	{FE_LPB_OLSPID,			FETOP_FE_LPB_DATA,	19,	4},
	{FE_LPB_OLSPID_PRESERVE_EN,	FETOP_FE_LPB_DATA,	23,	1},
	{FE_LPB_MEM_PARITY,		FETOP_FE_LPB_DATA,	24,	1},
};


/* Classifier */
#define	FE_CLASS_FWDTYPE_NORMAL		0x00
#define	FE_CLASS_FWDTYPE_CPU		0x01
#define FE_CLASS_FWDTYPE_MC		0x04
#define FE_CLASS_FWDTYPE_BC		0x05
#define FE_CLASS_FWDTYPE_UM		0x06
#define	FE_CLASS_FWDTYPE_UU		0x07
#define	FE_CLASS_FWDTYPE_MIRROR		0x08
#define	FE_CLASS_FWDTYPE_BYPASS		0x0c
#define	FE_CLASS_FWDTYPE_DROP		0x0d

/*
 * FE Core Logic of Managing Classification Rules
 *
 * 1. Port (LSPID) Based.
 * 2. Upper layer API, parameters:
 * 		LSPID, Classification fields, and corresponding values.
 * 3. Grouped by Port number.
 */

/* usage? */
typedef enum {
	FE_PARSER_LSPID,
	FE_PARSER_ORIG_LSPID,
	FE_PARSER_DA,
	FE_PARSER_SA,
	FE_PARSER_BC_DA

} cs_fe_parser_fields_e;

typedef enum {
	FE_CLASS_SVIDX,
	FE_CLASS_LSPID,
	FE_CLASS_HDR_A_ORIG_LSPID,
	FE_CLASS_FWDTYPE,
	FE_CLASS_TPID_ENC_1,
	FE_CLASS_VID_1,

	FE_CLASS_8021P_1,
	FE_CLASS_TPID_ENC_2,
	FE_CLASS_VID_2,
	FE_CLASS_8021P_2,
	FE_CLASS_DA_AN_MAC_SEL,
	FE_CLASS_DA_AN_MAC_HIT,
	FE_CLASS_SA_BNG_MAC_SEL,
	FE_CLASS_SA_BNG_MAC_HIT,

	FE_CLASS_DSCP,
	FE_CLASS_ECN,
	FE_CLASS_ETHERTYPE_ENC,
	FE_CLASS_IP_PROT,
	FE_CLASS_L4_SP,

	FE_CLASS_L4_DP,
	FE_CLASS_DA,

	FE_CLASS_SA,

	FE_CLASS_IP_DA,

	FE_CLASS_IP_SA,

	FE_CLASS_IP_VLD,
	FE_CLASS_IP_VER,
	FE_CLASS_IP_FRAGMENT,
	FE_CLASS_L4_VLD,
	FE_CLASS_MC_DA,
	FE_CLASS_BC_DA,
	FE_CLASS_LEN_ENCODED,
	FE_CLASS_HDR_A_FLAGS_CRCERR,
	FE_CLASS_L3_CHKSUM_ERR,
	FE_CLASS_L4_CHKSUM_ERR,

	FE_CLASS_NOT_HDR_A_FLAGS_STSVLD,
	FE_CLASS_LSPID_MASK,
	FE_CLASS_HDR_A_ORIG_LSPID_MASK,
	FE_CLASS_FWDTYPE_MASK,
	FE_CLASS_TPID_ENC_1_MSB_MASK,
	FE_CLASS_TPID_ENC_1_LSB_MASK,
	FE_CLASS_VID_1_MASK,
	FE_CLASS_8021P_1_MASK,
	FE_CLASS_TPID_ENC_2_MSB_MASK,
	FE_CLASS_TPID_ENC_2_LSB_MASK,
	FE_CLASS_VID_2_MASK,
	FE_CLASS_8021P_2_MASK,
	FE_CLASS_DA_AN_MAC_SEL_MASK,
	FE_CLASS_DA_AN_MAC_HIT_MASK,
	FE_CLASS_SA_BNG_MAC_SEL_MASK,
	FE_CLASS_SA_BNG_MAC_HIT_MASK,
	FE_CLASS_DSCP_MASK,
	FE_CLASS_ECN_MASK,
	FE_CLASS_ETHERTYPE_ENC_MASK,
	FE_CLASS_IP_PROT_MASK,
	FE_CLASS_L4_PORT_MASK,

	FE_CLASS_DA_MASK,
	FE_CLASS_SA_MASK,
	FE_CLASS_IP_DA_MASK,
	FE_CLASS_IP_SA_MASK,
	FE_CLASS_IP_VLD_MASK,
	FE_CLASS_IP_VER_MASK,

	FE_CLASS_IP_FRAGMENT_MASK,
	FE_CLASS_L4_VLD_MASK,
	FE_CLASS_MC_DA_MASK,
	FE_CLASS_BC_DA_MASK,
	FE_CLASS_LEN_ENCODED_MASK,
	FE_CLASS_HDR_A_FLAGS_CRCERR_MASK,
	FE_CLASS_L3_CHKSUM_ERR_MASK,
	FE_CLASS_L4_CHKSUM_ERR_MASK,
	FE_CLASS_NOT_HDR_A_FLAGS_STSVLD_MASK,
	FE_CLASS_SPI_VLD,
	FE_CLASS_SPI_VLD_MASK,
	FE_CLASS_SPI,

	FE_CLASS_SPI_MASK,

	FE_CLASS_MCGID,
	FE_CLASS_MCGID_MASK,
	FE_CLASS_RSVD_621_606,

	FE_CLASS_RULE_PRI,
	FE_CLASS_ENTRY_VLD,
	FE_CLASS_MEM_PARITY,

	FE_CLASS_FIELDS_MAX
} cs_fe_class_field_e;


static const cs_reg_access_field_s
cs_fe_class_fields[FE_CLASS_FIELDS_MAX] = {
	{FE_CLASS_SVIDX,			FETOP_FE_CLASS_DATA0,	0,	6},
	{FE_CLASS_LSPID,			FETOP_FE_CLASS_DATA0,	6,	4},
	{FE_CLASS_HDR_A_ORIG_LSPID,		FETOP_FE_CLASS_DATA0,	10,	4},
	{FE_CLASS_FWDTYPE,			FETOP_FE_CLASS_DATA0,	14,	4},
	{FE_CLASS_TPID_ENC_1,			FETOP_FE_CLASS_DATA0,	18,	3},
	{FE_CLASS_VID_1,			FETOP_FE_CLASS_DATA0,	21,	12},

	{FE_CLASS_8021P_1,			FETOP_FE_CLASS_DATA1,	1,	3},
	{FE_CLASS_TPID_ENC_2,			FETOP_FE_CLASS_DATA1,	4,	3},
	{FE_CLASS_VID_2,			FETOP_FE_CLASS_DATA1,	7,	12},
	{FE_CLASS_8021P_2,			FETOP_FE_CLASS_DATA1,	19,	3},
	{FE_CLASS_DA_AN_MAC_SEL,		FETOP_FE_CLASS_DATA1,	22,	4},
	{FE_CLASS_DA_AN_MAC_HIT,		FETOP_FE_CLASS_DATA1,	26,	1},
	{FE_CLASS_SA_BNG_MAC_SEL,		FETOP_FE_CLASS_DATA1,	27,	4},
	{FE_CLASS_SA_BNG_MAC_HIT,		FETOP_FE_CLASS_DATA1,	31,	1},

	{FE_CLASS_DSCP,				FETOP_FE_CLASS_DATA2,	0,	6},
	{FE_CLASS_ECN,				FETOP_FE_CLASS_DATA2,	6,	2},
	{FE_CLASS_ETHERTYPE_ENC,		FETOP_FE_CLASS_DATA2,	8,	6},
	{FE_CLASS_IP_PROT,			FETOP_FE_CLASS_DATA2,	14,	8},
	{FE_CLASS_L4_SP,			FETOP_FE_CLASS_DATA2,	22,	16},

	{FE_CLASS_L4_DP,			FETOP_FE_CLASS_DATA3,	6,	16},
	{FE_CLASS_DA,				FETOP_FE_CLASS_DATA3,	22,	48},

	{FE_CLASS_SA,				FETOP_FE_CLASS_DATA5,	6,	48},

	{FE_CLASS_IP_DA,			FETOP_FE_CLASS_DATA6,	22,	128},

	{FE_CLASS_IP_SA,			FETOP_FE_CLASS_DATA10,	22,	128},

	{FE_CLASS_IP_VLD,			FETOP_FE_CLASS_DATA14,	22,	1},
	{FE_CLASS_IP_VER,			FETOP_FE_CLASS_DATA14,	23,	1},
	{FE_CLASS_IP_FRAGMENT,			FETOP_FE_CLASS_DATA14,	24,	1},
	{FE_CLASS_L4_VLD,			FETOP_FE_CLASS_DATA14,	25,	1},
	{FE_CLASS_MC_DA,			FETOP_FE_CLASS_DATA14,	26,	1},
	{FE_CLASS_BC_DA,			FETOP_FE_CLASS_DATA14,	27,	1},
	{FE_CLASS_LEN_ENCODED,			FETOP_FE_CLASS_DATA14,	28,	1},
	{FE_CLASS_HDR_A_FLAGS_CRCERR,		FETOP_FE_CLASS_DATA14,	29,	1},
	{FE_CLASS_L3_CHKSUM_ERR,		FETOP_FE_CLASS_DATA14,	30,	1},
	{FE_CLASS_L4_CHKSUM_ERR,		FETOP_FE_CLASS_DATA14,	31,	1},

	{FE_CLASS_NOT_HDR_A_FLAGS_STSVLD,	FETOP_FE_CLASS_DATA15,	0,	1},
	{FE_CLASS_LSPID_MASK,			FETOP_FE_CLASS_DATA15,	1,	1},
	{FE_CLASS_HDR_A_ORIG_LSPID_MASK,	FETOP_FE_CLASS_DATA15,	2,	1},
	{FE_CLASS_FWDTYPE_MASK,			FETOP_FE_CLASS_DATA15,	3,	4},
	{FE_CLASS_TPID_ENC_1_MSB_MASK,		FETOP_FE_CLASS_DATA15,	7,	1},
	{FE_CLASS_TPID_ENC_1_LSB_MASK,		FETOP_FE_CLASS_DATA15,	8,	1},
	{FE_CLASS_VID_1_MASK,			FETOP_FE_CLASS_DATA15,	9,	2},
	{FE_CLASS_8021P_1_MASK,			FETOP_FE_CLASS_DATA15,	11,	1},
	{FE_CLASS_TPID_ENC_2_MSB_MASK,		FETOP_FE_CLASS_DATA15,	12,	1},
	{FE_CLASS_TPID_ENC_2_LSB_MASK,		FETOP_FE_CLASS_DATA15,	13,	1},
	{FE_CLASS_VID_2_MASK,			FETOP_FE_CLASS_DATA15,	14,	1},
	{FE_CLASS_8021P_2_MASK,			FETOP_FE_CLASS_DATA15,	15,	1},
	{FE_CLASS_DA_AN_MAC_SEL_MASK,		FETOP_FE_CLASS_DATA15,	16,	1},
	{FE_CLASS_DA_AN_MAC_HIT_MASK,		FETOP_FE_CLASS_DATA15,	17,	1},
	{FE_CLASS_SA_BNG_MAC_SEL_MASK,		FETOP_FE_CLASS_DATA15,	18,	1},
	{FE_CLASS_SA_BNG_MAC_HIT_MASK,		FETOP_FE_CLASS_DATA15,	19,	1},
	{FE_CLASS_DSCP_MASK,			FETOP_FE_CLASS_DATA15,	20,	6},
	{FE_CLASS_ECN_MASK,			FETOP_FE_CLASS_DATA15,	26,	2},
	{FE_CLASS_ETHERTYPE_ENC_MASK,		FETOP_FE_CLASS_DATA15,	28,	1},
	{FE_CLASS_IP_PROT_MASK,			FETOP_FE_CLASS_DATA15,	29,	1},
	{FE_CLASS_L4_PORT_MASK,			FETOP_FE_CLASS_DATA15,	30,	2},

	{FE_CLASS_DA_MASK,			FETOP_FE_CLASS_DATA16,	0,	6},
	{FE_CLASS_SA_MASK,			FETOP_FE_CLASS_DATA16,	6,	6},
	{FE_CLASS_IP_DA_MASK,			FETOP_FE_CLASS_DATA16,	12,	9},
	{FE_CLASS_IP_SA_MASK,			FETOP_FE_CLASS_DATA16,	21,	9},
	{FE_CLASS_IP_VLD_MASK,			FETOP_FE_CLASS_DATA16,	30,	1},
	{FE_CLASS_IP_VER_MASK,			FETOP_FE_CLASS_DATA16,	31,	1},

	{FE_CLASS_IP_FRAGMENT_MASK,		FETOP_FE_CLASS_DATA17,	0,	1},
	{FE_CLASS_L4_VLD_MASK,			FETOP_FE_CLASS_DATA17,	1,	1},
	{FE_CLASS_MC_DA_MASK,			FETOP_FE_CLASS_DATA17,	2,	1},
	{FE_CLASS_BC_DA_MASK,			FETOP_FE_CLASS_DATA17,	3,	1},
	{FE_CLASS_LEN_ENCODED_MASK,		FETOP_FE_CLASS_DATA17,	4,	1},
	{FE_CLASS_HDR_A_FLAGS_CRCERR_MASK,	FETOP_FE_CLASS_DATA17,	5,	1},
	{FE_CLASS_L3_CHKSUM_ERR_MASK,		FETOP_FE_CLASS_DATA17,	6,	1},
	{FE_CLASS_L4_CHKSUM_ERR_MASK,		FETOP_FE_CLASS_DATA17,	7,	1},
	{FE_CLASS_NOT_HDR_A_FLAGS_STSVLD_MASK,	FETOP_FE_CLASS_DATA17,	8,	1},
	{FE_CLASS_SPI_VLD,			FETOP_FE_CLASS_DATA17,	9,	1},
	{FE_CLASS_SPI_VLD_MASK,			FETOP_FE_CLASS_DATA17,	10,	1},
	{FE_CLASS_SPI,				FETOP_FE_CLASS_DATA17,	11,	32},

	{FE_CLASS_SPI_MASK,			FETOP_FE_CLASS_DATA18,	11,	1},

	{FE_CLASS_MCGID,			FETOP_FE_CLASS_DATA18,	12,	9},
	{FE_CLASS_MCGID_MASK,			FETOP_FE_CLASS_DATA18,	21,	9},
	{FE_CLASS_RSVD_621_606,			FETOP_FE_CLASS_DATA18,	30,	16},

	{FE_CLASS_RULE_PRI,			FETOP_FE_CLASS_DATA19,	14,	6},
	{FE_CLASS_ENTRY_VLD,			FETOP_FE_CLASS_DATA19,	20,	1},
	{FE_CLASS_MEM_PARITY,			FETOP_FE_CLASS_DATA19,	21,	1},
};


/* SDB */
typedef enum {
	FE_SDB_HTUPL_EN_0,
	FE_SDB_HTUPL_MASK_PTR_0,
	FE_SDB_HTUPL_PRI_0,
	FE_SDB_HTUPL_EN_1,
	FE_SDB_HTUPL_MASK_PTR_1,
	FE_SDB_HTUPL_PRI_1,
	FE_SDB_HTUPL_EN_2,
	FE_SDB_HTUPL_MASK_PTR_2,
	FE_SDB_HTUPL_PRI_2,

	FE_SDB_HTUPL_EN_3,
	FE_SDB_HTUPL_MASK_PTR_3,
	FE_SDB_HTUPL_PRI_3,
	FE_SDB_HTUPL_EN_4,
	FE_SDB_HTUPL_MASK_PTR_4,
	FE_SDB_HTUPL_PRI_4,
	FE_SDB_HTUPL_EN_5,
	FE_SDB_HTUPL_MASK_PTR_5,
	FE_SDB_HTUPL_PRI_5,

	FE_SDB_HTUPL_EN_6,
	FE_SDB_HTUPL_MASK_PTR_6,
	FE_SDB_HTUPL_PRI_6,
	FE_SDB_HTUPL_EN_7,
	FE_SDB_HTUPL_MASK_PTR_7,
	FE_SDB_HTUPL_PRI_7,
	FE_SDB_LPM_EN,
	FE_SDB_LPM_IPV4_START_PTR0,
	FE_SDB_LPM_IPV4_END_PTR0,

	FE_SDB_LPM_IPV4_START_PTR1,
	FE_SDB_LPM_IPV4_END_PTR1,
	FE_SDB_LPM_IPV6_START_PTR0,
	FE_SDB_LPM_IPV6_END_PTR0,
	FE_SDB_LPM_IPV6_START_PTR1,
	FE_SDB_LPM_IPV6_END_PTR1,

	FE_SDB_LPM_IPV4_PTR0_EN,
	FE_SDB_LPM_IPV4_PTR1_EN,
	FE_SDB_LPM_IPV6_PTR0_EN,
	FE_SDB_LPM_IPV6_PTR1_EN,
	FE_SDB_PVID,
	FE_SDB_PVID_TPID_ENC,
	FE_SDB_PVID_EN,
	FE_SDB_VLAN_INGR_MBRSHP_EN,
	FE_SDB_VLAN_EGR_MBRSHP_EN,
	FE_SDB_VLAN_EGRUNTAG_CHK_EN,
	FE_SDB_USE_EGRLEN_PKTTYPE_POLICER,
	FE_SDB_USE_EGRLEN_SRC_POLICER,
	FE_SDB_USE_EGRLEN_FLOW_POLICER,
	FE_SDB_TTL_HOPLIMIT_ZERO_DISCARD_EN,
	FE_SDB_KEYRULE,

	FE_SDB_UU_FLOWIDX,
	FE_SDB_HTPL_STSUPDT_CNTL,
	FE_SDB_BC_FLOWIDX,
	FE_SDB_UM_FLOWIDX,

	FE_SDB_RSVD_202,
	FE_SDB_DROP,
	FE_SDB_EGRVLN_INGR_MBRSHP_EN,
	FE_SDB_ACL_DISABLE,
	FE_SDB_MEM_PARITY,

	FE_SDB_DATA_FIELD_MAX,
} cs_fe_sdb_data_field_e;

static const cs_reg_access_field_s
cs_fe_sdb_fields[FE_SDB_DATA_FIELD_MAX] = {
	{FE_SDB_HTUPL_EN_0,			FETOP_FE_SDB_DATA0,		0,	1},
	{FE_SDB_HTUPL_MASK_PTR_0,		FETOP_FE_SDB_DATA0,		1,	6},
	{FE_SDB_HTUPL_PRI_0,			FETOP_FE_SDB_DATA0,		7,	4},
	{FE_SDB_HTUPL_EN_1,				FETOP_FE_SDB_DATA0,		11,	1},
	{FE_SDB_HTUPL_MASK_PTR_1,		FETOP_FE_SDB_DATA0,		12,	6},
	{FE_SDB_HTUPL_PRI_1,			FETOP_FE_SDB_DATA0,		18,	4},
	{FE_SDB_HTUPL_EN_2,				FETOP_FE_SDB_DATA0,		22,	1},
	{FE_SDB_HTUPL_MASK_PTR_2,		FETOP_FE_SDB_DATA0,		23,	6},
	{FE_SDB_HTUPL_PRI_2,			FETOP_FE_SDB_DATA0,		29,	4},

	{FE_SDB_HTUPL_EN_3,				FETOP_FE_SDB_DATA1,		1,	1},
	{FE_SDB_HTUPL_MASK_PTR_3,		FETOP_FE_SDB_DATA1,		2,	6},
	{FE_SDB_HTUPL_PRI_3,			FETOP_FE_SDB_DATA1,		8,	4},
	{FE_SDB_HTUPL_EN_4,				FETOP_FE_SDB_DATA1,		12,	1},
	{FE_SDB_HTUPL_MASK_PTR_4,		FETOP_FE_SDB_DATA1,		13,	6},
	{FE_SDB_HTUPL_PRI_4,			FETOP_FE_SDB_DATA1,		19,	4},
	{FE_SDB_HTUPL_EN_5,				FETOP_FE_SDB_DATA1,		23,	1},
	{FE_SDB_HTUPL_MASK_PTR_5,		FETOP_FE_SDB_DATA1,		24,	6},
	{FE_SDB_HTUPL_PRI_5,			FETOP_FE_SDB_DATA1,		30,	4},

	{FE_SDB_HTUPL_EN_6,				FETOP_FE_SDB_DATA2,		2,	1},
	{FE_SDB_HTUPL_MASK_PTR_6,		FETOP_FE_SDB_DATA2,		3,	6},
	{FE_SDB_HTUPL_PRI_6,			FETOP_FE_SDB_DATA2,		9,	4},
	{FE_SDB_HTUPL_EN_7,				FETOP_FE_SDB_DATA2,		13,	1},
	{FE_SDB_HTUPL_MASK_PTR_7,		FETOP_FE_SDB_DATA2,		14,	6},
	{FE_SDB_HTUPL_PRI_7,			FETOP_FE_SDB_DATA2,		20,	4},
	{FE_SDB_LPM_EN,					FETOP_FE_SDB_DATA2,		24,	1},
	{FE_SDB_LPM_IPV4_START_PTR0,	FETOP_FE_SDB_DATA2,		25,	6},
	{FE_SDB_LPM_IPV4_END_PTR0,		FETOP_FE_SDB_DATA2,		31,	6},

	{FE_SDB_LPM_IPV4_START_PTR1,	FETOP_FE_SDB_DATA3,		5,	6},
	{FE_SDB_LPM_IPV4_END_PTR1,		FETOP_FE_SDB_DATA3,		11,	6},
	{FE_SDB_LPM_IPV6_START_PTR0,	FETOP_FE_SDB_DATA3,		17,	4},
	{FE_SDB_LPM_IPV6_END_PTR0,		FETOP_FE_SDB_DATA3,		21,	4},
	{FE_SDB_LPM_IPV6_START_PTR1,	FETOP_FE_SDB_DATA3,		25,	4},
	{FE_SDB_LPM_IPV6_END_PTR1,		FETOP_FE_SDB_DATA3,		29,	4},

	{FE_SDB_LPM_IPV4_PTR0_EN,		FETOP_FE_SDB_DATA4,		1,	1},
	{FE_SDB_LPM_IPV4_PTR1_EN,		FETOP_FE_SDB_DATA4,		2,	1},
	{FE_SDB_LPM_IPV6_PTR0_EN,		FETOP_FE_SDB_DATA4,		3,	1},
	{FE_SDB_LPM_IPV6_PTR1_EN,		FETOP_FE_SDB_DATA4,		4,	1},
	{FE_SDB_PVID,					FETOP_FE_SDB_DATA4,		5,	12},
	{FE_SDB_PVID_TPID_ENC,			FETOP_FE_SDB_DATA4,		17,	2},
	{FE_SDB_PVID_EN,				FETOP_FE_SDB_DATA4,		19,	1},
	{FE_SDB_VLAN_INGR_MBRSHP_EN,	FETOP_FE_SDB_DATA4,		20,	1},
	{FE_SDB_VLAN_EGR_MBRSHP_EN,		FETOP_FE_SDB_DATA4,		21,	1},
	{FE_SDB_VLAN_EGRUNTAG_CHK_EN,	FETOP_FE_SDB_DATA4,		22,	1},
	{FE_SDB_USE_EGRLEN_PKTTYPE_POLICER,	FETOP_FE_SDB_DATA4,	23,	1},
	{FE_SDB_USE_EGRLEN_SRC_POLICER,	FETOP_FE_SDB_DATA4,		24,	1},
	{FE_SDB_USE_EGRLEN_FLOW_POLICER,	FETOP_FE_SDB_DATA4,		25,	1},
	{FE_SDB_TTL_HOPLIMIT_ZERO_DISCARD_EN,	FETOP_FE_SDB_DATA4,	26,	1},
	{FE_SDB_KEYRULE,				FETOP_FE_SDB_DATA4,		27,	6},

	{FE_SDB_UU_FLOWIDX,				FETOP_FE_SDB_DATA5,		1,	13},
	{FE_SDB_HTPL_STSUPDT_CNTL,		FETOP_FE_SDB_DATA5,		14,	2},
	{FE_SDB_BC_FLOWIDX,				FETOP_FE_SDB_DATA5,		16,	13},
	{FE_SDB_UM_FLOWIDX,				FETOP_FE_SDB_DATA5,		29,	13},

	{FE_SDB_RSVD_202,				FETOP_FE_SDB_DATA6,		10,	1},
	{FE_SDB_DROP,					FETOP_FE_SDB_DATA6,		11,	1},
	{FE_SDB_EGRVLN_INGR_MBRSHP_EN,	FETOP_FE_SDB_DATA6,		12,	1},
	{FE_SDB_ACL_DISABLE,			FETOP_FE_SDB_DATA6,		13,	1},
	{FE_SDB_MEM_PARITY,				FETOP_FE_SDB_DATA6,		14,	1},
};


/* FE_VLN */
typedef enum {
	FE_VLN_MEMBER,
	FE_VLN_EGR_UNTAGGED,
	FE_VLN_FID,
	FE_VLN_FIRST_VLAN_CMD,
	FE_VLN_FIRST_VID,
	FE_VLN_FIRST_TPID_ENC,
	FE_VLN_SECOND_VLAN_CMD,
	FE_VLN_SECOND_VID,
	FE_VLN_SECOND_TPID_ENC,
	FE_VLN_MCGID,
	FE_VLN_MEM_PARITY,
	FE_VLN_FIELD_MAX
} cs_fe_vln_field_e;

static const cs_reg_access_field_s
cs_fe_vln_fields[FE_VLN_FIELD_MAX] = {
	{FE_VLN_MEMBER,				FETOP_FE_VLN_DATA0,		0,	6},
	{FE_VLN_EGR_UNTAGGED,		FETOP_FE_VLN_DATA0,		6,	6},
	{FE_VLN_FID,				FETOP_FE_VLN_DATA0,		12,	4},
	{FE_VLN_FIRST_VLAN_CMD,		FETOP_FE_VLN_DATA0,		16,	5},
	{FE_VLN_FIRST_VID,			FETOP_FE_VLN_DATA0,		21,	12},

	{FE_VLN_FIRST_TPID_ENC,		FETOP_FE_VLN_DATA1,		1,	2},
	{FE_VLN_SECOND_VLAN_CMD,	FETOP_FE_VLN_DATA1,		3,	5},
	{FE_VLN_SECOND_VID,			FETOP_FE_VLN_DATA1,		8,	12},
	{FE_VLN_SECOND_TPID_ENC,	FETOP_FE_VLN_DATA1,		20,	2},
	{FE_VLN_MCGID,				FETOP_FE_VLN_DATA1,		22,	9},
	{FE_VLN_MEM_PARITY,			FETOP_FE_VLN_DATA1,		31,	1},
};


/* FE_FWD_RESULT */
typedef enum {
	FWD_VOQ_POLICY,
	FWD_POL_POLICY,
	FWD_VOQ_POL_TBL_IDX,
	FWD_IP_SA_REPLACE_EN,
	FWD_IP_SA_IDX,
	FWD_IP_DA_REPLACE_EN,
	FWD_IP_DA_IDX,

	FWD_L4_SP_REPLACE_EN,
	FWD_L4_SP,
	FWD_L4_DP_REPLACE_EN,
	FWD_L4_DP,

	FWD_MAC_SA_REPLACE_EN,
	FWD_MAC_DA_REPLACE_EN,
	FWD_L2_IDX,
	FWD_MCGID,
	FWD_MCGID_VLD,
	FWD_ACL_DISABLE,
	FWD_FWDTYPE_VLD,
	FWD_FWDTYPE,

	FWD_DECR_TTL_HOPLIMIT,
	FWD_FLOW_VLAN_OP_EN,
	FWD_FLOW_VLANTBL_IDX,
	FWD_DROP,
	FWD_PPPOE_ENCAP_EN,
	FWD_PPPOE_DECAP_EN,
	FWD_MEM_PARITY,
	FWD_FWDRSLT_FIELD_MAX,
} cs_fe_fwdrslt_field_e;

static const cs_reg_access_field_s
cs_fe_fwdrslt_fields[FWD_FWDRSLT_FIELD_MAX] = {
	{FWD_VOQ_POLICY,			FETOP_FE_FWDRSLT_DATA0,		0,	1},
	{FWD_POL_POLICY,			FETOP_FE_FWDRSLT_DATA0,		1,	2},
	{FWD_VOQ_POL_TBL_IDX,		FETOP_FE_FWDRSLT_DATA0,		3,	9},
	{FWD_IP_SA_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA0,		12,	1},
	{FWD_IP_SA_IDX,				FETOP_FE_FWDRSLT_DATA0,		13,	12},
	{FWD_IP_DA_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA0,		25,	1},
	{FWD_IP_DA_IDX,				FETOP_FE_FWDRSLT_DATA0,		26,	12},

	{FWD_L4_SP_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA1,		6,	1},
	{FWD_L4_SP,					FETOP_FE_FWDRSLT_DATA1,		7,	16},
	{FWD_L4_DP_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA1,		23,	1},
	{FWD_L4_DP,					FETOP_FE_FWDRSLT_DATA1,		24,	16},

	{FWD_MAC_SA_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA2,		8,	1},
	{FWD_MAC_DA_REPLACE_EN,		FETOP_FE_FWDRSLT_DATA2,		9,	1},
	{FWD_L2_IDX,				FETOP_FE_FWDRSLT_DATA2,		10,	9},
	{FWD_MCGID,					FETOP_FE_FWDRSLT_DATA2,		19,	9},
	{FWD_MCGID_VLD,				FETOP_FE_FWDRSLT_DATA2,		28,	1},
	{FWD_ACL_DISABLE,			FETOP_FE_FWDRSLT_DATA2,		29,	1},
	{FWD_FWDTYPE_VLD,			FETOP_FE_FWDRSLT_DATA2,		30,	1},
	{FWD_FWDTYPE,				FETOP_FE_FWDRSLT_DATA2,		31,	4},

	{FWD_DECR_TTL_HOPLIMIT,		FETOP_FE_FWDRSLT_DATA3,		3,	1},
	{FWD_FLOW_VLAN_OP_EN,		FETOP_FE_FWDRSLT_DATA3,		4,	1},
	{FWD_FLOW_VLANTBL_IDX,		FETOP_FE_FWDRSLT_DATA3,		5,	9},
	{FWD_DROP,					FETOP_FE_FWDRSLT_DATA3,		14,	1},
	{FWD_PPPOE_ENCAP_EN,		FETOP_FE_FWDRSLT_DATA3,		15,	1},
	{FWD_PPPOE_DECAP_EN,		FETOP_FE_FWDRSLT_DATA3,		16,	1},
	{FWD_MEM_PARITY,			FETOP_FE_FWDRSLT_DATA3,		17,	1},
};


/* FE_QOSRSLT */
typedef enum {
	FWD_QOS_WRED_COS,
	FWD_QOS_VOQ_COS,
	FWD_QOS_POL_COS,
	FWD_QOS_PREMARK,
	FWD_QOS_CHANGE_DSCP_EN,
	FWD_QOS_DSCP,
	FWD_QOS_DSCP_MARKDOWN_EN,
	FWD_QOS_MARKED_DOWN_DSCP,
	FWD_QOS_ECN_ENABLE,
	FWD_QOS_TOP_802_1P,
	FWD_QOS_MARKED_DOWN_TOP_802_1P,
	FWD_QOS_TOP8021P_MARKDOWN_EN,

	FWD_QOS_TOP_DEI,
	FWD_QOS_MARKED_DOWN_TOP_DEI,
	FWD_QOS_INNER_802_1P,
	FWD_QOS_MARKED_DOWN_INNER_802_1P,
	FWD_QOS_INNER_8021P_MARKDOWN_EN,
	FWD_QOS_INNER_DEI,
	FWD_QOS_MARKED_DOWN_INNER_DEI,
	FWD_QOS_CHANGE_8021P_1_EN,
	FWD_QOS_CHANGE_DEI_1_EN,
	FWD_QOS_CHANGE_8021P_2_EN,
	FWD_QOS_CHANGE_DEI_2_EN,
	FWD_QOS_MEM_PARITY,
	FWD_QOSRSLT_FIELD_MAX
} cs_fe_qosrslt_field_e;

static const cs_reg_access_field_s
cs_fe_qosrslt_fields[FWD_QOSRSLT_FIELD_MAX] = {
	{FWD_QOS_WRED_COS,			FETOP_FE_QOSRSLT_DATA0,		0,	3},
	{FWD_QOS_VOQ_COS,			FETOP_FE_QOSRSLT_DATA0,		3,	3},
	{FWD_QOS_POL_COS,			FETOP_FE_QOSRSLT_DATA0,		6,	3},
	{FWD_QOS_PREMARK,			FETOP_FE_QOSRSLT_DATA0,		9,	1},
	{FWD_QOS_CHANGE_DSCP_EN,	FETOP_FE_QOSRSLT_DATA0,		10,	1},
	{FWD_QOS_DSCP,				FETOP_FE_QOSRSLT_DATA0,		11,	6},
	{FWD_QOS_DSCP_MARKDOWN_EN,	FETOP_FE_QOSRSLT_DATA0,		17,	1},
	{FWD_QOS_MARKED_DOWN_DSCP,	FETOP_FE_QOSRSLT_DATA0,		18,	6},
	{FWD_QOS_ECN_ENABLE,		FETOP_FE_QOSRSLT_DATA0,		24,	1},
	{FWD_QOS_TOP_802_1P,		FETOP_FE_QOSRSLT_DATA0,		25,	3},
	{FWD_QOS_MARKED_DOWN_TOP_802_1P,	FETOP_FE_QOSRSLT_DATA0,		28,	3},
	{FWD_QOS_TOP8021P_MARKDOWN_EN,		FETOP_FE_QOSRSLT_DATA0,		31,	1},

	{FWD_QOS_TOP_DEI,			FETOP_FE_QOSRSLT_DATA1,		0,	1},
	{FWD_QOS_MARKED_DOWN_TOP_DEI,		FETOP_FE_QOSRSLT_DATA1,		1,	1},
	{FWD_QOS_INNER_802_1P,		FETOP_FE_QOSRSLT_DATA1,		2,	3},
	{FWD_QOS_MARKED_DOWN_INNER_802_1P,	FETOP_FE_QOSRSLT_DATA1,		5,	3},
	{FWD_QOS_INNER_8021P_MARKDOWN_EN,	FETOP_FE_QOSRSLT_DATA1,		8,	1},
	{FWD_QOS_INNER_DEI,			FETOP_FE_QOSRSLT_DATA1,		9,	1},
	{FWD_QOS_MARKED_DOWN_INNER_DEI,		FETOP_FE_QOSRSLT_DATA1,		10,	1},
	{FWD_QOS_CHANGE_8021P_1_EN,	FETOP_FE_QOSRSLT_DATA1,		11,	1},
	{FWD_QOS_CHANGE_DEI_1_EN,	FETOP_FE_QOSRSLT_DATA1,		12,	1},
	{FWD_QOS_CHANGE_8021P_2_EN,	FETOP_FE_QOSRSLT_DATA1,		13,	1},
	{FWD_QOS_CHANGE_DEI_2_EN,	FETOP_FE_QOSRSLT_DATA1,		14,	1},
	{FWD_QOS_MEM_PARITY,		FETOP_FE_QOSRSLT_DATA1,		15,	1},
};


/* VOQ Policer */
typedef enum {
	FWD_VOQPOL_VOQ_BASE,
	FWD_VOQPOL_POL_BASE,
	FWD_VOQPOL_CPUPID,
	FWD_VOQPOL_LDPID,
	FWD_VOQPOL_PPPOE_SESSION_ID,

	FWD_VOQPOL_COS_NOP,
	FWD_VOQPOL_MEM_PARITY,
	FWD_VOQPOL_FIELDS_MAX
} cs_fe_voqpol_field_e;


static const cs_reg_access_field_s
cs_fe_voqpol_fields[FWD_VOQPOL_FIELDS_MAX] = {
	{FWD_VOQPOL_VOQ_BASE,		FETOP_FE_VOQPOL_DATA0,	0,	8},
	{FWD_VOQPOL_POL_BASE,		FETOP_FE_VOQPOL_DATA0,	8,	8},
	{FWD_VOQPOL_CPUPID,			FETOP_FE_VOQPOL_DATA0,	16,	3},
	{FWD_VOQPOL_LDPID,			FETOP_FE_VOQPOL_DATA0,	19,	4},
	{FWD_VOQPOL_PPPOE_SESSION_ID,	FETOP_FE_VOQPOL_DATA0,	23,	16},
	{FWD_VOQPOL_COS_NOP,		FETOP_FE_VOQPOL_DATA1,	7,	1},
	{FWD_VOQPOL_MEM_PARITY,		FETOP_FE_VOQPOL_DATA1,	8,	1},
};


/* FWD_VLAN */
typedef enum {
	FWD_FVLAN_FIRST_VLAN_CMD,
	FWD_FVLAN_FIRST_VID,
	FWD_FVLAN_FIRST_TPID_ENC,
	FWD_FVLAN_SECOND_VLAN_CMD,
	FWD_FVLAN_SECOND_VID,
	FWD_FVLAN_SECOND_TPID_ENC,
	FWD_FVLAN_MEM_PARITY,
	FWD_FVLAN_FIELD_MAX
} cs_fe_fvlan_field_e;

static const cs_reg_access_field_s
cs_fe_fvlan_fields[FWD_FVLAN_FIELD_MAX] = {
	{FWD_FVLAN_FIRST_VLAN_CMD,		FETOP_FE_FVLAN_DATA0,	0,	5},
	{FWD_FVLAN_FIRST_VID,			FETOP_FE_FVLAN_DATA0,	5,	12},
	{FWD_FVLAN_FIRST_TPID_ENC,		FETOP_FE_FVLAN_DATA0,	17,	2},
	{FWD_FVLAN_SECOND_VLAN_CMD,		FETOP_FE_FVLAN_DATA0,	19,	5},
	{FWD_FVLAN_SECOND_VID,			FETOP_FE_FVLAN_DATA0,	24,	12},

	{FWD_FVLAN_SECOND_TPID_ENC,		FETOP_FE_FVLAN_DATA1,	4,	2},
	{FWD_FVLAN_MEM_PARITY,			FETOP_FE_FVLAN_DATA1,	6,	1},
};


/* L3_TABLE */
typedef enum cs_fe_l3tbl_field {
	FWD_L3_ADDR,
	FWD_L3_MEM_PARITY,
	FWD_L3TBL_FIELD_MAX
} cs_fe_l3tbl_field_e;

static const cs_reg_access_field_s
cs_fe_l3tbl_fields[FWD_L3TBL_FIELD_MAX] = {
	{FWD_L3_ADDR,			FETOP_FE_L3TBL_DATA0,	0,	128},
	{FWD_L3_MEM_PARITY,		FETOP_FE_L3TBL_DATA4,	0,	1}
};


/* L2_TABLE */
typedef enum {
	FWD_L2_MAC_SA,
	FWD_L2_MAC_DA,
	FWD_L2_MEM_PARITY,
	FWD_L2TBL_FIELD_MAX
} cs_fe_l2tbl_field_e;

static const cs_reg_access_field_s
cs_fe_l2tbl_fields[FWD_L2TBL_FIELD_MAX] = {
	{FWD_L2_MAC_SA,			FETOP_FE_L2TBL_DATA0,	0,	48},

	{FWD_L2_MAC_DA,			FETOP_FE_L2TBL_DATA1,	16,	48},

	{FWD_L2_MEM_PARITY,		FETOP_FE_L2TBL_DATA3,	0,	1}
};


/* ACL_RULE */
typedef enum {
	ACL_RULE_L2_MAC_DA,

	ACL_RULE_L2_MAC_SA,

	ACL_RULE_ETHERTYPE,
	ACL_RULE_LEN_ENCODED,
	ACL_RULE_TPID_1_VLD,
	ACL_RULE_TPID_ENC_1,
	ACL_RULE_VID_1,

	ACL_RULE_8021P_1,
	ACL_RULE_DEI_1,
	ACL_RULE_TPID_2_VLD,
	ACL_RULE_TPID_ENC_2,
	ACL_RULE_VID_2,
	ACL_RULE_8021P_2,
	ACL_RULE_DEI_2,
	ACL_RULE_IP_VLD,
	ACL_RULE_IP_VER,
	ACL_RULE_IP_DA,

	ACL_RULE_IP_SA,

	ACL_RULE_DSCP,
	ACL_RULE_ECN,

	ACL_RULE_IP_PROT,
	ACL_RULE_IP_FRAGMENT,
	ACL_RULE_IP_OPTIONS,
	ACL_RULE_IPV6_FLOW_LBL,
	ACL_RULE_TTL_HOPLMT,

	ACL_RULE_L4_VLD,
	ACL_RULE_L4_DPLO,
	ACL_RULE_L4_DPHI,

	ACL_RULE_L4_SPLO,
	ACL_RULE_L4_SPHI,

	ACL_RULE_LSPID,
	ACL_RULE_ORIG_LSPID,
	ACL_RULE_FWDTYPE,
	ACL_RULE_SPL_PKT_VEC,

	ACL_RULE_CLASS_HIT,
	ACL_RULE_CLASS_SVIDX,
	ACL_RULE_LPM_HIT,
	ACL_RULE_LPM_HIT_IDX,
	ACL_RULE_HASH_HIT,
	ACL_RULE_HASH_HIT_IDX,

	ACL_RULE_DA_AN_MAC_HIT,
	ACL_RULE_DA_AN_MAC_HIT_MASK,
	ACL_RULE_L7_FIELD,

	ACL_RULE_L2_MAC_DA_MASK,
	ACL_RULE_L2_MAC_SA_MASK,
	ACL_RULE_ETHERTYPE_MASK,
	ACL_RULE_LEN_ENCODED_MASK,
	ACL_RULE_TPID_1_VLD_MASK,
	ACL_RULE_TPID_ENC_1_MASK,
	ACL_RULE_VID_1_MASK,
	ACL_RULE_8021P_1_MASK,
	ACL_RULE_DEI_1_MASK,
	ACL_RULE_TPID_2_VLD_MASK,
	ACL_RULE_TPID_ENC_2_MASK,
	ACL_RULE_VID_2_MASK,
	ACL_RULE_8021P_2_MASK,
	ACL_RULE_DEI_2_MASK,
	ACL_RULE_IP_VLD_MASK,
	ACL_RULE_IP_VER_MASK,
	ACL_RULE_IP_DA_MASK,

	ACL_RULE_IP_SA_MASK,
	ACL_RULE_DSCP_MASK,
	ACL_RULE_ECN_MASK,
	ACL_RULE_IP_PROT_MASK,
	ACL_RULE_IP_FRAGMENT_MASK,
	ACL_RULE_IP_OPTIONS_MASK,
	ACL_RULE_IPV6_FLOW_LBL_MASK,
	ACL_RULE_TTL_HOPLMT_MASK,
	ACL_RULE_L4_VLD_MASK,
	ACL_RULE_L4_MASK,

	ACL_RULE_LSPID_MASK,
	ACL_RULE_ORIG_LSPID_MASK,
	ACL_RULE_FWDTYPE_MASK,
	ACL_RULE_SPL_PKT_VEC_MASK,
	ACL_RULE_CLASS_HIT_MASK,
	ACL_RULE_CLASS_SVIDX_MASK,
	ACL_RULE_LPM_HIT_MASK,
	ACL_RULE_LPM_HIT_IDX_MASK,
	ACL_RULE_HASH_HIT_MASK,
	ACL_RULE_HASH_HIT_IDX_MASK,
	ACL_RULE_L7_FIELD_MASK,

	ACL_RULE_DA_AN_MAC_SEL,
	ACL_RULE_DA_AN_MAC_SEL_MASK,
	ACL_RULE_SA_BNG_MAC_SEL,
	ACL_RULE_SA_BNG_MAC_SEL_MASK,
	ACL_RULE_SA_BNG_MAC_HIT,
	ACL_RULE_SA_BNG_MAC_HIT_MASK,
	ACL_RULE_FLAGS_VEC,
	ACL_RULE_FLAGS_VEC_MASK,

	ACL_RULE_FLAGS_VEC_OR,
	ACL_RULE_SPL_PKT_VEC_OR,
	ACL_RULE_RECIRC_IDX,
	ACL_RULE_RECIRC_IDX_MASK,
	ACL_RULE_NE_VEC,

	ACL_RULE_MCIDX,
	ACL_RULE_MCIDX_MASK,
	ACL_RULE_SDB_DROP,
	ACL_RULE_SDB_DROP_MASK,
	ACL_RULE_FWD_DROP,
	ACL_RULE_FWD_DROP_MASK,
	ACL_RULE_PPPOE_SESSION_ID_VLD,
	ACL_RULE_PPPOE_SESSION_ID_VLD_MASK,
	ACL_RULE_PPPOE_SESSION_ID,

	ACL_RULE_PPPOE_SESSION_ID_MASK,
	ACL_RULE_SPI_VLD,
	ACL_RULE_SPI_VLD_MASK,
	ACL_RULE_SPI,

	ACL_RULE_SPI_MASK,
	ACL_RULE_PPP_PROTOCOL_VLD,
	ACL_RULE_PPP_PROTOCOL_VLD_MASK,
	ACL_RULE_PPP_PROTOCOL,
	ACL_RULE_PPP_PROTOCOL_MASK,
	ACL_RULE_IPV6_NDP,
	ACL_RULE_IPV6_NDP_MASK,

	ACL_RULE_IPV6_HBH,
	ACL_RULE_IPV6_HBH_MASK,
	ACL_RULE_IPV6_RH,
	ACL_RULE_IPV6_RH_MASK,
	ACL_RULE_IPV6_DOH,
	ACL_RULE_IPV6_DOH_MASK,
	ACL_RULE_PKTLEN_RNG_MATCH_VECTOR,
	ACL_RULE_PKTLEN_RNG_MATCH_VECTOR_MASK,
	ACL_RULE_RSVD_879_878,
	ACL_RULE_VLD,
	ACL_RULE_MEM_PARITY,

	ACL_RULE_FIELDS_MAX
} cs_fe_aclrule_field_e;

static const cs_reg_access_field_s
cs_fe_aclrule_fields[ACL_RULE_FIELDS_MAX] = {
	{ACL_RULE_L2_MAC_DA,			FETOP_FE_ACLRULE_DATA0,	0,	48},

	{ACL_RULE_L2_MAC_SA,			FETOP_FE_ACLRULE_DATA1,	16,	48},

	{ACL_RULE_ETHERTYPE,			FETOP_FE_ACLRULE_DATA3,	0,	16},
	{ACL_RULE_LEN_ENCODED,			FETOP_FE_ACLRULE_DATA3,	16,	1},
	{ACL_RULE_TPID_1_VLD,			FETOP_FE_ACLRULE_DATA3,	17,	1},
	{ACL_RULE_TPID_ENC_1,			FETOP_FE_ACLRULE_DATA3,	18,	2},
	{ACL_RULE_VID_1,				FETOP_FE_ACLRULE_DATA3,	20,	12},

	{ACL_RULE_8021P_1,				FETOP_FE_ACLRULE_DATA4,	0,	3},
	{ACL_RULE_DEI_1,				FETOP_FE_ACLRULE_DATA4,	3,	1},
	{ACL_RULE_TPID_2_VLD,			FETOP_FE_ACLRULE_DATA4,	4,	1},
	{ACL_RULE_TPID_ENC_2,			FETOP_FE_ACLRULE_DATA4,	5,	2},
	{ACL_RULE_VID_2,				FETOP_FE_ACLRULE_DATA4,	7,	12},
	{ACL_RULE_8021P_2,				FETOP_FE_ACLRULE_DATA4,	19,	3},
	{ACL_RULE_DEI_2,				FETOP_FE_ACLRULE_DATA4,	22,	1},
	{ACL_RULE_IP_VLD,				FETOP_FE_ACLRULE_DATA4,	23,	1},
	{ACL_RULE_IP_VER,				FETOP_FE_ACLRULE_DATA4,	24,	1},
	{ACL_RULE_IP_DA,				FETOP_FE_ACLRULE_DATA4,	25,	128},

	{ACL_RULE_IP_SA,				FETOP_FE_ACLRULE_DATA8,	25,	128},

	{ACL_RULE_DSCP,					FETOP_FE_ACLRULE_DATA12,	25,	6},
	{ACL_RULE_ECN,					FETOP_FE_ACLRULE_DATA12,	31,	2},

	{ACL_RULE_IP_PROT,				FETOP_FE_ACLRULE_DATA13,	1,	8},
	{ACL_RULE_IP_FRAGMENT,			FETOP_FE_ACLRULE_DATA13,	9,	1},
	{ACL_RULE_IP_OPTIONS,			FETOP_FE_ACLRULE_DATA13,	10,	1},
	{ACL_RULE_IPV6_FLOW_LBL,		FETOP_FE_ACLRULE_DATA13,	11,	20},
	{ACL_RULE_TTL_HOPLMT,			FETOP_FE_ACLRULE_DATA13,	31,	8},

	{ACL_RULE_L4_VLD,				FETOP_FE_ACLRULE_DATA14,	7,	1},
	{ACL_RULE_L4_DPLO,				FETOP_FE_ACLRULE_DATA14,	8,	16},
	{ACL_RULE_L4_DPHI,				FETOP_FE_ACLRULE_DATA14,	24,	16},

	{ACL_RULE_L4_SPLO,				FETOP_FE_ACLRULE_DATA15,	8,	16},
	{ACL_RULE_L4_SPHI,				FETOP_FE_ACLRULE_DATA15,	24,	16},

	{ACL_RULE_LSPID,				FETOP_FE_ACLRULE_DATA16,	8,	4},
	{ACL_RULE_ORIG_LSPID,			FETOP_FE_ACLRULE_DATA16,	12,	4},
	{ACL_RULE_FWDTYPE,				FETOP_FE_ACLRULE_DATA16,	16,	4},
	{ACL_RULE_SPL_PKT_VEC,			FETOP_FE_ACLRULE_DATA16,	20,	16},

	{ACL_RULE_CLASS_HIT,			FETOP_FE_ACLRULE_DATA17,	4,	1},
	{ACL_RULE_CLASS_SVIDX,			FETOP_FE_ACLRULE_DATA17,	5,	6},
	{ACL_RULE_LPM_HIT,				FETOP_FE_ACLRULE_DATA17,	11,	1},
	{ACL_RULE_LPM_HIT_IDX,			FETOP_FE_ACLRULE_DATA17,	12,	6},
	{ACL_RULE_HASH_HIT,				FETOP_FE_ACLRULE_DATA17,	18,	1},
	{ACL_RULE_HASH_HIT_IDX,			FETOP_FE_ACLRULE_DATA17,	19,	16},

	{ACL_RULE_DA_AN_MAC_HIT,		FETOP_FE_ACLRULE_DATA18,	3,	1},
	{ACL_RULE_DA_AN_MAC_HIT_MASK,	FETOP_FE_ACLRULE_DATA18,	4,	1},
	{ACL_RULE_L7_FIELD,				FETOP_FE_ACLRULE_DATA18,	5,	32},


	{ACL_RULE_L2_MAC_DA_MASK,		FETOP_FE_ACLRULE_DATA19,	5,	6},
	{ACL_RULE_L2_MAC_SA_MASK,		FETOP_FE_ACLRULE_DATA19,	11,	6},
	{ACL_RULE_ETHERTYPE_MASK,		FETOP_FE_ACLRULE_DATA19,	17,	1},
	{ACL_RULE_LEN_ENCODED_MASK,		FETOP_FE_ACLRULE_DATA19,	18,	1},
	{ACL_RULE_TPID_1_VLD_MASK,		FETOP_FE_ACLRULE_DATA19,	19,	1},
	{ACL_RULE_TPID_ENC_1_MASK,		FETOP_FE_ACLRULE_DATA19,	20,	1},
	{ACL_RULE_VID_1_MASK,			FETOP_FE_ACLRULE_DATA19,	21,	1},
	{ACL_RULE_8021P_1_MASK,			FETOP_FE_ACLRULE_DATA19,	22,	1},
	{ACL_RULE_DEI_1_MASK,			FETOP_FE_ACLRULE_DATA19,	23,	1},
	{ACL_RULE_TPID_2_VLD_MASK,		FETOP_FE_ACLRULE_DATA19,	24,	1},
	{ACL_RULE_TPID_ENC_2_MASK,		FETOP_FE_ACLRULE_DATA19,	25,	1},
	{ACL_RULE_VID_2_MASK,			FETOP_FE_ACLRULE_DATA19,	26,	1},
	{ACL_RULE_8021P_2_MASK,			FETOP_FE_ACLRULE_DATA19,	27,	1},
	{ACL_RULE_DEI_2_MASK,			FETOP_FE_ACLRULE_DATA19,	28,	1},
	{ACL_RULE_IP_VLD_MASK,			FETOP_FE_ACLRULE_DATA19,	29,	1},
	{ACL_RULE_IP_VER_MASK,			FETOP_FE_ACLRULE_DATA19,	30,	1},
	{ACL_RULE_IP_DA_MASK,			FETOP_FE_ACLRULE_DATA19,	31,	9},

	{ACL_RULE_IP_SA_MASK,			FETOP_FE_ACLRULE_DATA20,	8,	9},
	{ACL_RULE_DSCP_MASK,			FETOP_FE_ACLRULE_DATA20,	17,	6},
	{ACL_RULE_ECN_MASK,				FETOP_FE_ACLRULE_DATA20,	23,	2},
	{ACL_RULE_IP_PROT_MASK,			FETOP_FE_ACLRULE_DATA20,	25,	1},
	{ACL_RULE_IP_FRAGMENT_MASK,		FETOP_FE_ACLRULE_DATA20,	26,	1},
	{ACL_RULE_IP_OPTIONS_MASK,		FETOP_FE_ACLRULE_DATA20,	27,	1},
	{ACL_RULE_IPV6_FLOW_LBL_MASK,	FETOP_FE_ACLRULE_DATA20,	28,	1},
	{ACL_RULE_TTL_HOPLMT_MASK,		FETOP_FE_ACLRULE_DATA20,	29,	1},
	{ACL_RULE_L4_VLD_MASK,			FETOP_FE_ACLRULE_DATA20,	30,	1},
	{ACL_RULE_L4_MASK,				FETOP_FE_ACLRULE_DATA20,	31,	4},

	{ACL_RULE_LSPID_MASK,			FETOP_FE_ACLRULE_DATA21,	3,	1},
	{ACL_RULE_ORIG_LSPID_MASK,		FETOP_FE_ACLRULE_DATA21,	4,	1},
	{ACL_RULE_FWDTYPE_MASK,			FETOP_FE_ACLRULE_DATA21,	5,	4},
	{ACL_RULE_SPL_PKT_VEC_MASK,		FETOP_FE_ACLRULE_DATA21,	9,	16},
	{ACL_RULE_CLASS_HIT_MASK,		FETOP_FE_ACLRULE_DATA21,	25,	1},
	{ACL_RULE_CLASS_SVIDX_MASK,		FETOP_FE_ACLRULE_DATA21,	26,	1},
	{ACL_RULE_LPM_HIT_MASK,			FETOP_FE_ACLRULE_DATA21,	27,	1},
	{ACL_RULE_LPM_HIT_IDX_MASK,		FETOP_FE_ACLRULE_DATA21,	28,	1},
	{ACL_RULE_HASH_HIT_MASK,		FETOP_FE_ACLRULE_DATA21,	29,	1},
	{ACL_RULE_HASH_HIT_IDX_MASK,	FETOP_FE_ACLRULE_DATA21,	30,	1},
	{ACL_RULE_L7_FIELD_MASK,		FETOP_FE_ACLRULE_DATA21,	31,	3},

	{ACL_RULE_DA_AN_MAC_SEL,		FETOP_FE_ACLRULE_DATA22,	2,	4},
	{ACL_RULE_DA_AN_MAC_SEL_MASK,	FETOP_FE_ACLRULE_DATA22,	6,	1},
	{ACL_RULE_SA_BNG_MAC_SEL,		FETOP_FE_ACLRULE_DATA22,	7,	4},
	{ACL_RULE_SA_BNG_MAC_SEL_MASK,	FETOP_FE_ACLRULE_DATA22,	11,	1},
	{ACL_RULE_SA_BNG_MAC_HIT,		FETOP_FE_ACLRULE_DATA22,	12,	1},
	{ACL_RULE_SA_BNG_MAC_HIT_MASK,	FETOP_FE_ACLRULE_DATA22,	13,	1},
	{ACL_RULE_FLAGS_VEC,			FETOP_FE_ACLRULE_DATA22,	14,	16},
	{ACL_RULE_FLAGS_VEC_MASK,		FETOP_FE_ACLRULE_DATA22,	30,	16},

	{ACL_RULE_FLAGS_VEC_OR,			FETOP_FE_ACLRULE_DATA23,	14,	1},
	{ACL_RULE_SPL_PKT_VEC_OR,		FETOP_FE_ACLRULE_DATA23,	15,	1},
	{ACL_RULE_RECIRC_IDX,			FETOP_FE_ACLRULE_DATA23,	16,	10},
	{ACL_RULE_RECIRC_IDX_MASK,		FETOP_FE_ACLRULE_DATA23,	26,	1},
	{ACL_RULE_NE_VEC,				FETOP_FE_ACLRULE_DATA23,	27,	16},

	{ACL_RULE_MCIDX,				FETOP_FE_ACLRULE_DATA24,	11,	5},
	{ACL_RULE_MCIDX_MASK,			FETOP_FE_ACLRULE_DATA24,	16,	1},
	{ACL_RULE_SDB_DROP,				FETOP_FE_ACLRULE_DATA24,	17,	1},
	{ACL_RULE_SDB_DROP_MASK,		FETOP_FE_ACLRULE_DATA24,	18,	1},
	{ACL_RULE_FWD_DROP,				FETOP_FE_ACLRULE_DATA24,	19,	1},
	{ACL_RULE_FWD_DROP_MASK,		FETOP_FE_ACLRULE_DATA24,	20,	1},
	{ACL_RULE_PPPOE_SESSION_ID_VLD,	FETOP_FE_ACLRULE_DATA24,	21,	1},
	{ACL_RULE_PPPOE_SESSION_ID_VLD_MASK,	FETOP_FE_ACLRULE_DATA24,	22,	1},
	{ACL_RULE_PPPOE_SESSION_ID,		FETOP_FE_ACLRULE_DATA24,	23,	16},

	{ACL_RULE_PPPOE_SESSION_ID_MASK,	FETOP_FE_ACLRULE_DATA25,	7,	1},
	{ACL_RULE_SPI_VLD,				FETOP_FE_ACLRULE_DATA25,	8,	1},
	{ACL_RULE_SPI_VLD_MASK,			FETOP_FE_ACLRULE_DATA25,	9,	1},
	{ACL_RULE_SPI,					FETOP_FE_ACLRULE_DATA25,	10,	32},

	{ACL_RULE_SPI_MASK,				FETOP_FE_ACLRULE_DATA26,	10,	1},
	{ACL_RULE_PPP_PROTOCOL_VLD,		FETOP_FE_ACLRULE_DATA26,	11,	1},
	{ACL_RULE_PPP_PROTOCOL_VLD_MASK,FETOP_FE_ACLRULE_DATA26,	12,	1},
	{ACL_RULE_PPP_PROTOCOL,			FETOP_FE_ACLRULE_DATA26,	13,	16},
	{ACL_RULE_PPP_PROTOCOL_MASK,	FETOP_FE_ACLRULE_DATA26,	29,	1},
	{ACL_RULE_IPV6_NDP,				FETOP_FE_ACLRULE_DATA26,	30,	1},
	{ACL_RULE_IPV6_NDP_MASK,		FETOP_FE_ACLRULE_DATA26,	31,	1},

	{ACL_RULE_IPV6_HBH,				FETOP_FE_ACLRULE_DATA27,	0,	1},
	{ACL_RULE_IPV6_HBH_MASK,		FETOP_FE_ACLRULE_DATA27,	1,	1},
	{ACL_RULE_IPV6_RH,				FETOP_FE_ACLRULE_DATA27,	2,	1},
	{ACL_RULE_IPV6_RH_MASK,			FETOP_FE_ACLRULE_DATA27,	3,	1},
	{ACL_RULE_IPV6_DOH,				FETOP_FE_ACLRULE_DATA27,	4,	1},
	{ACL_RULE_IPV6_DOH_MASK,		FETOP_FE_ACLRULE_DATA27,	5,	1},
	{ACL_RULE_PKTLEN_RNG_MATCH_VECTOR,	FETOP_FE_ACLRULE_DATA27,	6,	4},
	{ACL_RULE_PKTLEN_RNG_MATCH_VECTOR_MASK,	FETOP_FE_ACLRULE_DATA27,	10,	4},
	{ACL_RULE_RSVD_879_878,			FETOP_FE_ACLRULE_DATA27,	14,	2},
	{ACL_RULE_VLD,					FETOP_FE_ACLRULE_DATA27,	16,	1},
	{ACL_RULE_MEM_PARITY,			FETOP_FE_ACLRULE_DATA27,	17,	1},
};


/* ACL_ACTION */
typedef enum {
	ACL_ACTION_VOQ_VLD,
	ACL_ACTION_VOQ_PRI,
	ACL_ACTION_VOQ,
	ACL_ACTION_LDPID,
	ACL_ACTION_CPUCOPY,
	ACL_ACTION_CPUCOPY_VOQ,
	ACL_ACTION_CPUCOPY_PRI,
	ACL_ACTION_MIRROR_VLD,
	ACL_ACTION_MIRROR_ID,

	ACL_ACTION_MIRROR_ID_PRI,
	ACL_ACTION_WRED_COS_VLD,
	ACL_ACTION_WRED_COS,
	ACL_ACTION_WRED_COS_PRI,
	ACL_ACTION_PRE_MARK_VLD,
	ACL_ACTION_PRE_MARK,
	ACL_ACTION_PRE_MARK_PRI,
	ACL_ACTION_POLICER_ID_VLD,
	ACL_ACTION_POLICER_ID,

	ACL_ACTION_POLICER_ID_PRI,
	ACL_ACTION_DROP_PERMIT_VLD,
	ACL_ACTION_DROP,
	ACL_ACTION_PERMIT,
	ACL_ACTION_DROP_PERMIT_PRI,
	ACL_ACTION_8021P_1_VLD,
	ACL_ACTION_8021P_1,
	ACL_ACTION_8021P_1_PRI,
	ACL_ACTION_DEI_1_VLD,
	ACL_ACTION_DEI_1,
	ACL_ACTION_DEI_1_PRI,
	ACL_ACTION_8021P_2_VLD,
	ACL_ACTION_8021P_2,
	ACL_ACTION_KEEP_TS_VLD,
	ACL_ACTION_8021P_2_PRI,

	ACL_ACTION_DEI_2_VLD,
	ACL_ACTION_DEI_2,
	ACL_ACTION_DEI_2_PRI,
	ACL_ACTION_DSCP_VLD,
	ACL_ACTION_DSCP,
	ACL_ACTION_DSCP_PRI,
	ACL_ACTION_FWDTYPE_VLD,
	ACL_ACTION_FWDTYPE,
	ACL_ACTION_FWDTYPE_PRI,
	ACL_ACTION_MCGID_VLD,
	ACL_ACTION_MCGID,

	ACL_ACTION_MCGID_PRI,
	ACL_ACTION_FIRST_VLAN_CMD_VLD,
	ACL_ACTION_FIRST_VLAN_CMD,
	ACL_ACTION_FIRST_VID,
	ACL_ACTION_FIRST_TPID_ENC,
	ACL_ACTION_FIRST_VLAN_CMD_PRI,

	ACL_ACTION_SECOND_VLAN_CMD_VLD,
	ACL_ACTION_SECOND_VLAN_CMD,
	ACL_ACTION_SECOND_VID,
	ACL_ACTION_SECOND_TPID_ENC,
	ACL_ACTION_SECOND_VLAN_CMD_PRI,
	ACL_ACTION_KEEP_TS,
	ACL_ACTION_KEEP_TS_PRI,

	ACL_ACTION_IP_SA_REPLACE_EN_VLD,
	ACL_ACTION_IP_SA_REPLACE_EN,
	ACL_ACTION_IP_SA_REPLACE_EN_PRI,
	ACL_ACTION_IP_DA_REPLACE_EN_VLD,
	ACL_ACTION_IP_DA_REPLACE_EN,
	ACL_ACTION_IP_DA_REPLACE_EN_PRI,
	ACL_ACTION_L4_SP_REPLACE_EN_VLD,
	ACL_ACTION_L4_SP_REPLACE_EN,
	ACL_ACTION_L4_SP,
	ACL_ACTION_L4_SP_REPLACE_EN_PRI,

	ACL_ACTION_L4_DP_REPLACE_EN_VLD,
	ACL_ACTION_L4_DP_REPLACE_EN,
	ACL_ACTION_L4_DP,
	ACL_ACTION_L4_DP_REPLACE_EN_PRI,
	ACL_ACTION_IP_SA_IDX,

	ACL_ACTION_IP_DA_IDX,
	ACL_ACTION_MAC_DA_SA_REPLACE_EN_VLD,
	ACL_ACTION_MAC_DA_REPLACE_EN,
	ACL_ACTION_MAC_SA_REPLACE_EN,
	ACL_ACTION_MAC_DA_SA_REPLACE_EN_PRI,
	ACL_ACTION_L2_IDX,

	ACL_ACTION_CHANGE_DSCP_EN,
	ACL_ACTION_DECR_TTL_HOPLIMIT_VLD,
	ACL_ACTION_DECR_TTL_HOPLIMIT,
	ACL_ACTION_DECR_TTL_HOPLIMIT_PRI,
	ACL_ACTION_VOQ_CPUPID,
	ACL_ACTION_CPUCOPY_CPUPID,
	ACL_ACTION_CHANGE_8021P_1_EN,
	ACL_ACTION_CHANGE_DEI_1_EN,
	ACL_ACTION_CHANGE_8021P_2_EN,
	ACL_ACTION_CHANGE_DEI_2_EN,
	ACL_ACTION_MEM_PARITY,

	ACL_ACTION_FIELDS_MAX
} cs_fe_aclaction_field_e;

static const cs_reg_access_field_s
cs_fe_aclaction_fields[ACL_ACTION_FIELDS_MAX] = {
	{ACL_ACTION_VOQ_VLD,		FETOP_FE_ACLACTION_DATA0,	0,	1},
	{ACL_ACTION_VOQ_PRI,		FETOP_FE_ACLACTION_DATA0,	1,	4},
	{ACL_ACTION_VOQ,			FETOP_FE_ACLACTION_DATA0,	5,	8},
	{ACL_ACTION_LDPID,			FETOP_FE_ACLACTION_DATA0,	13,	4},
	{ACL_ACTION_CPUCOPY,		FETOP_FE_ACLACTION_DATA0,	17,	1},
	{ACL_ACTION_CPUCOPY_VOQ,	FETOP_FE_ACLACTION_DATA0,	18,	6},
	{ACL_ACTION_CPUCOPY_PRI,	FETOP_FE_ACLACTION_DATA0,	24,	4},
	{ACL_ACTION_MIRROR_VLD,		FETOP_FE_ACLACTION_DATA0,	28,	1},
	{ACL_ACTION_MIRROR_ID,		FETOP_FE_ACLACTION_DATA0,	29,	9},

	{ACL_ACTION_MIRROR_ID_PRI,	FETOP_FE_ACLACTION_DATA1,	6,	4},
	{ACL_ACTION_WRED_COS_VLD,	FETOP_FE_ACLACTION_DATA1,	10,	1},
	{ACL_ACTION_WRED_COS,		FETOP_FE_ACLACTION_DATA1,	11,	3},
	{ACL_ACTION_WRED_COS_PRI,	FETOP_FE_ACLACTION_DATA1,	14,	4},
	{ACL_ACTION_PRE_MARK_VLD,	FETOP_FE_ACLACTION_DATA1,	18,	1},
	{ACL_ACTION_PRE_MARK,		FETOP_FE_ACLACTION_DATA1,	19,	1},
	{ACL_ACTION_PRE_MARK_PRI,	FETOP_FE_ACLACTION_DATA1,	20,	4},
	{ACL_ACTION_POLICER_ID_VLD,	FETOP_FE_ACLACTION_DATA1,	24,	1},
	{ACL_ACTION_POLICER_ID,		FETOP_FE_ACLACTION_DATA1,	25,	8},

	{ACL_ACTION_POLICER_ID_PRI,	FETOP_FE_ACLACTION_DATA2,	1,	4},
	{ACL_ACTION_DROP_PERMIT_VLD,	FETOP_FE_ACLACTION_DATA2,	5,	1},
	{ACL_ACTION_DROP,			FETOP_FE_ACLACTION_DATA2,	6,	1},
	{ACL_ACTION_PERMIT,			FETOP_FE_ACLACTION_DATA2,	7,	1},
	{ACL_ACTION_DROP_PERMIT_PRI,	FETOP_FE_ACLACTION_DATA2,	8,	4},
	{ACL_ACTION_8021P_1_VLD,	FETOP_FE_ACLACTION_DATA2,	12,	1},
	{ACL_ACTION_8021P_1,		FETOP_FE_ACLACTION_DATA2,	13,	3},
	{ACL_ACTION_8021P_1_PRI,	FETOP_FE_ACLACTION_DATA2,	16,	4},
	{ACL_ACTION_DEI_1_VLD,		FETOP_FE_ACLACTION_DATA2,	20,	1},
	{ACL_ACTION_DEI_1,			FETOP_FE_ACLACTION_DATA2,	21,	1},
	{ACL_ACTION_DEI_1_PRI,		FETOP_FE_ACLACTION_DATA2,	22,	4},
	{ACL_ACTION_8021P_2_VLD,	FETOP_FE_ACLACTION_DATA2,	26,	1},
	{ACL_ACTION_8021P_2,		FETOP_FE_ACLACTION_DATA2,	27,	3},
	{ACL_ACTION_KEEP_TS_VLD,	FETOP_FE_ACLACTION_DATA2,	30,	1},
	{ACL_ACTION_8021P_2_PRI,	FETOP_FE_ACLACTION_DATA2,	31,	4},

	{ACL_ACTION_DEI_2_VLD,		FETOP_FE_ACLACTION_DATA3,	3,	1},
	{ACL_ACTION_DEI_2,			FETOP_FE_ACLACTION_DATA3,	4,	1},
	{ACL_ACTION_DEI_2_PRI,		FETOP_FE_ACLACTION_DATA3,	5,	4},
	{ACL_ACTION_DSCP_VLD,		FETOP_FE_ACLACTION_DATA3,	9,	1},
	{ACL_ACTION_DSCP,			FETOP_FE_ACLACTION_DATA3,	10,	6},
	{ACL_ACTION_DSCP_PRI,		FETOP_FE_ACLACTION_DATA3,	16,	4},
	{ACL_ACTION_FWDTYPE_VLD,	FETOP_FE_ACLACTION_DATA3,	20,	1},
	{ACL_ACTION_FWDTYPE,		FETOP_FE_ACLACTION_DATA3,	21,	4},
	{ACL_ACTION_FWDTYPE_PRI,	FETOP_FE_ACLACTION_DATA3,	25,	4},
	{ACL_ACTION_MCGID_VLD,		FETOP_FE_ACLACTION_DATA3,	29,	1},
	{ACL_ACTION_MCGID,			FETOP_FE_ACLACTION_DATA3,	30,	9},

	{ACL_ACTION_MCGID_PRI,		FETOP_FE_ACLACTION_DATA4,	7,	4},
	{ACL_ACTION_FIRST_VLAN_CMD_VLD,		FETOP_FE_ACLACTION_DATA4,	11,	1},
	{ACL_ACTION_FIRST_VLAN_CMD,			FETOP_FE_ACLACTION_DATA4,	12,	5},
	{ACL_ACTION_FIRST_VID,				FETOP_FE_ACLACTION_DATA4,	17,	12},
	{ACL_ACTION_FIRST_TPID_ENC,			FETOP_FE_ACLACTION_DATA4,	29,	2},
	{ACL_ACTION_FIRST_VLAN_CMD_PRI,		FETOP_FE_ACLACTION_DATA4,	31,	4},

	{ACL_ACTION_SECOND_VLAN_CMD_VLD,	FETOP_FE_ACLACTION_DATA5,	3,	1},
	{ACL_ACTION_SECOND_VLAN_CMD,		FETOP_FE_ACLACTION_DATA5,	4,	5},
	{ACL_ACTION_SECOND_VID,				FETOP_FE_ACLACTION_DATA5,	9,	12},
	{ACL_ACTION_SECOND_TPID_ENC,		FETOP_FE_ACLACTION_DATA5,	21,	2},
	{ACL_ACTION_SECOND_VLAN_CMD_PRI,	FETOP_FE_ACLACTION_DATA5,	23,	4},
	{ACL_ACTION_KEEP_TS,				FETOP_FE_ACLACTION_DATA5,	27,	1},
	{ACL_ACTION_KEEP_TS_PRI,			FETOP_FE_ACLACTION_DATA5,	28,	4},

	{ACL_ACTION_IP_SA_REPLACE_EN_VLD,	FETOP_FE_ACLACTION_DATA6,	0,	1},
	{ACL_ACTION_IP_SA_REPLACE_EN,		FETOP_FE_ACLACTION_DATA6,	1,	1},
	{ACL_ACTION_IP_SA_REPLACE_EN_PRI,	FETOP_FE_ACLACTION_DATA6,	2,	4},
	{ACL_ACTION_IP_DA_REPLACE_EN_VLD,	FETOP_FE_ACLACTION_DATA6,	6,	1},
	{ACL_ACTION_IP_DA_REPLACE_EN,		FETOP_FE_ACLACTION_DATA6,	7,	1},
	{ACL_ACTION_IP_DA_REPLACE_EN_PRI,	FETOP_FE_ACLACTION_DATA6,	8,	4},
	{ACL_ACTION_L4_SP_REPLACE_EN_VLD,	FETOP_FE_ACLACTION_DATA6,	12,	1},
	{ACL_ACTION_L4_SP_REPLACE_EN,		FETOP_FE_ACLACTION_DATA6,	13,	1},
	{ACL_ACTION_L4_SP,					FETOP_FE_ACLACTION_DATA6,	14,	16},
	{ACL_ACTION_L4_SP_REPLACE_EN_PRI,	FETOP_FE_ACLACTION_DATA6,	30,	4},

	{ACL_ACTION_L4_DP_REPLACE_EN_VLD,	FETOP_FE_ACLACTION_DATA7,	2,	1},
	{ACL_ACTION_L4_DP_REPLACE_EN,		FETOP_FE_ACLACTION_DATA7,	3,	1},
	{ACL_ACTION_L4_DP,					FETOP_FE_ACLACTION_DATA7,	4,	16},
	{ACL_ACTION_L4_DP_REPLACE_EN_PRI,	FETOP_FE_ACLACTION_DATA7,	20,	4},
	{ACL_ACTION_IP_SA_IDX,				FETOP_FE_ACLACTION_DATA7,	24,	12},

	{ACL_ACTION_IP_DA_IDX,				FETOP_FE_ACLACTION_DATA8,	4,	12},
	{ACL_ACTION_MAC_DA_SA_REPLACE_EN_VLD,	FETOP_FE_ACLACTION_DATA8,	16,	1},
	{ACL_ACTION_MAC_DA_REPLACE_EN,		FETOP_FE_ACLACTION_DATA8,	17,	1},
	{ACL_ACTION_MAC_SA_REPLACE_EN,		FETOP_FE_ACLACTION_DATA8,	18,	1},
	{ACL_ACTION_MAC_DA_SA_REPLACE_EN_PRI,	FETOP_FE_ACLACTION_DATA8,	19,	4},
	{ACL_ACTION_L2_IDX,					FETOP_FE_ACLACTION_DATA8,	23,	9},

	{ACL_ACTION_CHANGE_DSCP_EN,			FETOP_FE_ACLACTION_DATA9,	0,	1},
	{ACL_ACTION_DECR_TTL_HOPLIMIT_VLD,	FETOP_FE_ACLACTION_DATA9,	1,	1},
	{ACL_ACTION_DECR_TTL_HOPLIMIT,		FETOP_FE_ACLACTION_DATA9,	2,	1},
	{ACL_ACTION_DECR_TTL_HOPLIMIT_PRI,	FETOP_FE_ACLACTION_DATA9,	3,	4},
	{ACL_ACTION_VOQ_CPUPID,				FETOP_FE_ACLACTION_DATA9,	7,	3},
	{ACL_ACTION_CPUCOPY_CPUPID,			FETOP_FE_ACLACTION_DATA9,	10,	3},
	{ACL_ACTION_CHANGE_8021P_1_EN,		FETOP_FE_ACLACTION_DATA9,	13,	1},
	{ACL_ACTION_CHANGE_DEI_1_EN,		FETOP_FE_ACLACTION_DATA9,	14,	1},
	{ACL_ACTION_CHANGE_8021P_2_EN,		FETOP_FE_ACLACTION_DATA9,	15,	1},
	{ACL_ACTION_CHANGE_DEI_2_EN,		FETOP_FE_ACLACTION_DATA9,	16,	1},
	{ACL_ACTION_MEM_PARITY,				FETOP_FE_ACLACTION_DATA9,	17,	1},
};


/* FE_PE_CONFIG */
typedef enum cs_fe_pe_cfg_field {
	FE_PE_CFG_DATAFF_RDY_THLD,
	FE_PE_CFG_CMDFF_RDY_THLD,
	FE_PE_CFG_RSVD,
	FE_PE_CFG_NI_RDY_FF_THLD,
	FE_PE_CFG_STOMP_CRC,
	FE_PE_CFG_DIS_MIRROR_DROP,
	FE_PE_CFG_PE_FIFO_RESET,
	FE_PE_CFG_PE_STUFF_DIS,
	FE_PE_CFG_PE_CRC_INS_DIS,
	FE_PE_CFG_PE_KEEP_TS_BYP,
	FE_PE_CFG_RSVD2,
	FE_PE_CFG_PECNT_DEBUG_MODE,
	FE_PE_CFG_PECNT_OP_CODE,
	FE_PE_CFG_RSVD3,
	FE_PE_CFG_VLAN_DBG,
	FE_PE_CFG_DSCP_DBG,
	FE_PE_CFG_BYPASS_PE,
	FE_PE_CFG_BYPASS_PR,
	FE_PE_CFG_INS_CPUHDR_VOQ,
	FE_PE_CFG_INS_CPUHDR_CRYPTO,
	FE_PE_CFG_INS_CPUHDR_ENCAP,
	FE_PE_CFG_RSVD4,
	FE_PE_CFG_QM_PKT_CNT_VOQ,
	FE_PE_CFG_PE_CFG_SPARE,
	FE_PE_CFG_RSVD5,
	FE_PE_CFG_FIELD_MAX,
} cs_fe_pe_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_pe_cfg_fields[FE_PE_CFG_FIELD_MAX] = {
	{FE_PE_CFG_DATAFF_RDY_THLD,		FETOP_FE_PE_CONFIG,		0,	8},
	{FE_PE_CFG_CMDFF_RDY_THLD,		FETOP_FE_PE_CONFIG,		8,	5},
	{FE_PE_CFG_RSVD,				FETOP_FE_PE_CONFIG,		13,	2},
	{FE_PE_CFG_NI_RDY_FF_THLD,		FETOP_FE_PE_CONFIG,		15,	1},
	{FE_PE_CFG_STOMP_CRC,			FETOP_FE_PE_CONFIG,		16,	1},
	{FE_PE_CFG_DIS_MIRROR_DROP,		FETOP_FE_PE_CONFIG,		17,	1},
	{FE_PE_CFG_PE_FIFO_RESET,		FETOP_FE_PE_CONFIG,		18,	1},
	{FE_PE_CFG_PE_STUFF_DIS,		FETOP_FE_PE_CONFIG,		19,	1},
	{FE_PE_CFG_PE_CRC_INS_DIS,		FETOP_FE_PE_CONFIG,		20,	1},
	{FE_PE_CFG_PE_KEEP_TS_BYP,		FETOP_FE_PE_CONFIG,		21,	1},
	{FE_PE_CFG_RSVD2,				FETOP_FE_PE_CONFIG,		22,	2},
	{FE_PE_CFG_PECNT_DEBUG_MODE,	FETOP_FE_PE_CONFIG,		24,	1},
	{FE_PE_CFG_PECNT_OP_CODE,		FETOP_FE_PE_CONFIG,		25,	2},
	{FE_PE_CFG_RSVD3,				FETOP_FE_PE_CONFIG,		27,	1},
	{FE_PE_CFG_VLAN_DBG,			FETOP_FE_PE_CONFIG,		28,	1},
	{FE_PE_CFG_DSCP_DBG,			FETOP_FE_PE_CONFIG,		29,	1},
	{FE_PE_CFG_BYPASS_PE,			FETOP_FE_PE_CONFIG,		30,	1},
	{FE_PE_CFG_BYPASS_PR,			FETOP_FE_PE_CONFIG,		31,	1},

	{FE_PE_CFG_INS_CPUHDR_VOQ,		FETOP_FE_PE_CONFIG_1,	0,	8},
	{FE_PE_CFG_INS_CPUHDR_CRYPTO,	FETOP_FE_PE_CONFIG_1,	8,	1},
	{FE_PE_CFG_INS_CPUHDR_ENCAP,	FETOP_FE_PE_CONFIG_1,	9,	1},
	{FE_PE_CFG_RSVD4,				FETOP_FE_PE_CONFIG_1,	10,	6},
	{FE_PE_CFG_QM_PKT_CNT_VOQ,		FETOP_FE_PE_CONFIG_1,	16,	8},
	{FE_PE_CFG_PE_CFG_SPARE,		FETOP_FE_PE_CONFIG_1,	24,	4},
	{FE_PE_CFG_RSVD5,				FETOP_FE_PE_CONFIG_1,	28,	4},
};


/* PE_PPPOE_CFG */
typedef enum {
	FE_PE_PPPOE_CFG_ENCAP_TYPE,
	FE_PE_PPPOE_CFG_ENCAP_VER,
	FE_PE_PPPOE_CFG_ENCAP_CODE,
	FE_PE_PPPOE_CFG_ENCAP_PPPOE_ETHTYPE,
	FE_PE_PPPOE_CFG_IPV4_ETHTYPE,
	FE_PE_PPPOE_CFG_IPV4_PPP_TYPE,
	FE_PE_PPPOE_CFG_IPV6_ETHTYPE,
	FE_PE_PPPOE_CFG_IPV6_PPP_TYPE,
	FE_PE_PPPOE_CFG_DEF_ETHTYPE,
	FE_PE_PPPOE_CFG_DEF_PPP_TYPE,
	FE_PE_PPPOE_CFG_FIELD_MAX,
} cs_fe_pe_pppoe_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_pe_pppoe_cfg_fields[FE_PE_PPPOE_CFG_FIELD_MAX] = {
	{FE_PE_PPPOE_CFG_ENCAP_TYPE,		FETOP_FE_PE_PPPOE_CFG_0,	0,	4},
	{FE_PE_PPPOE_CFG_ENCAP_VER,			FETOP_FE_PE_PPPOE_CFG_0,	4,	4},
	{FE_PE_PPPOE_CFG_ENCAP_CODE,		FETOP_FE_PE_PPPOE_CFG_0,	8,	8},
	{FE_PE_PPPOE_CFG_ENCAP_PPPOE_ETHTYPE,	FETOP_FE_PE_PPPOE_CFG_0,	16,	16},

	{FE_PE_PPPOE_CFG_IPV4_ETHTYPE,		FETOP_FE_PE_PPPOE_CFG_1,	0,	16},
	{FE_PE_PPPOE_CFG_IPV4_PPP_TYPE,		FETOP_FE_PE_PPPOE_CFG_1,	16,	16},

	{FE_PE_PPPOE_CFG_IPV6_ETHTYPE,		FETOP_FE_PE_PPPOE_CFG_2,	0,	16},
	{FE_PE_PPPOE_CFG_IPV6_PPP_TYPE,		FETOP_FE_PE_PPPOE_CFG_2,	16,	16},

	{FE_PE_PPPOE_CFG_DEF_ETHTYPE,		FETOP_FE_PE_PPPOE_CFG_3,	0,	16},
	{FE_PE_PPPOE_CFG_DEF_PPP_TYPE,		FETOP_FE_PE_PPPOE_CFG_3,	16,	16},
};


/* FE_PKTLEN_RNGS_DATA */
typedef enum {
	FE_PKTLEN_LOW,
	FE_PKTLEN_HIGH,
	FE_PKTLEN_VALID,
	FE_PKTLEN_RNGS_MAX
} cs_fe_pktlen_rngs_field_e;

static const cs_reg_access_field_s
cs_fe_pktlen_rngs_fields[FE_PKTLEN_RNGS_MAX] = {
	{FE_PKTLEN_LOW,		FETOP_FE_PKTLEN_RNGS_DATA,	0,	14},
	{FE_PKTLEN_HIGH,	FETOP_FE_PKTLEN_RNGS_DATA,	14,	14},
	{FE_PKTLEN_VALID,	FETOP_FE_PKTLEN_RNGS_DATA,	28,	1},
};

/* FE_PE_VOQ_DRP_DROP_CFG */
typedef enum {
	FE_PE_VOQ_DRP_DROP_CFG_DATA,
	FE_PE_VOQ_DRP_DROP_CFG_FIELD_MAX
} cs_fe_pe_voq_drp_drop_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_pe_voq_drp_fields[FE_PE_VOQ_DRP_DROP_CFG_FIELD_MAX] = {
	{FE_PE_VOQ_DRP_DROP_CFG_DATA,		FETOP_FE_PE_VOQ_DRP_DATA,	0,	4},
};


/******************************* FETOP_LPM **************************/

/* LPM_LPM_CONFIG */
typedef enum {
	FE_LPM_LPM_CFG_ACTIVE_TABLE,
	FE_LPM_LPM_CFG_CLR_READ,
	FE_LPM_LPM_CFG_SDB_EN,
	FE_LPM_LPM_CFG_COL_MASK_SEL,
	FE_LPM_LPM_CFG_FIELD_MAX
} cs_fe_lpm_lpm_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_lpm_cfg_fields[FE_LPM_LPM_CFG_FIELD_MAX] = {
	{FE_LPM_LPM_CFG_ACTIVE_TABLE,	FETOP_LPM_LPM_CONFIG,	0,	2},
	{FE_LPM_LPM_CFG_CLR_READ,		FETOP_LPM_LPM_CONFIG,	2,	1},
	{FE_LPM_LPM_CFG_SDB_EN,			FETOP_LPM_LPM_CONFIG,	3,	1},
	{FE_LPM_LPM_CFG_COL_MASK_SEL,	FETOP_LPM_LPM_CONFIG,	4,	3},
};


/* LPM_TABLE0_UPPER_REGF_ACCESS */
typedef enum {
	FE_LPM_TABLE0_UPPER_CFG_ADDR,
	FE_LPM_TABLE0_UPPER_CFG_RSVD,
	FE_LPM_TABLE0_UPPER_CFG_PARITY_BYPASS,
	FE_LPM_TABLE0_UPPER_CFG_WRDN,
	FE_LPM_TABLE0_UPPER_CFG_ACCESS,
	FE_LPM_TABLE0_UPPER_CFG_FIELD_MAX
} cs_fe_lpm_table0_upper_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table0_upper_cfg_fields[FE_LPM_TABLE0_UPPER_CFG_FIELD_MAX] = {
	{FE_LPM_TABLE0_UPPER_CFG_ADDR,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,	0,	3},
	{FE_LPM_TABLE0_UPPER_CFG_RSVD,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,	3,	26},
	{FE_LPM_TABLE0_UPPER_CFG_PARITY_BYPASS,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,	29,	1},
	{FE_LPM_TABLE0_UPPER_CFG_WRDN,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,	30,	1},
	{FE_LPM_TABLE0_UPPER_CFG_ACCESS,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,	31,	1},
};


/* LPM_TABLE0_UPPDER_REG */
typedef enum {
	FE_LPM_TABLE0_UPPER_NH0,
	FE_LPM_TABLE0_UPPER_NH1,
	FE_LPM_TABLE0_UPPER_NH2,
	FE_LPM_TABLE0_UPPER_NH3,
	FE_LPM_TABLE0_UPPER_MASK0,
	FE_LPM_TABLE0_UPPER_IP0,
	FE_LPM_TABLE0_UPPER_MASK1,
	FE_LPM_TABLE0_UPPER_IP1,
	FE_LPM_TABLE0_UPPER_MASK2,
	FE_LPM_TABLE0_UPPER_IP2,
	FE_LPM_TABLE0_UPPER_MASK3,
	FE_LPM_TABLE0_UPPER_IP3,
	FE_LPM_TABLE0_UPPER_FIELD_MAX
} cs_fe_lpm_table0_upper_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table0_upper_ree_fields[FE_LPM_TABLE0_UPPER_FIELD_MAX] = {
	{FE_LPM_TABLE0_UPPER_NH0,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0,	0,	27},
	{FE_LPM_TABLE0_UPPER_NH1,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0,	27,	27},

	{FE_LPM_TABLE0_UPPER_NH2,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA1,	22,	27},

	{FE_LPM_TABLE0_UPPER_NH3,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA2,	17,	27},

	{FE_LPM_TABLE0_UPPER_MASK0,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3,	12,	6},
	{FE_LPM_TABLE0_UPPER_IP0,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3,	18,	32},

	{FE_LPM_TABLE0_UPPER_MASK1,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4,	18,	6},
	{FE_LPM_TABLE0_UPPER_IP1,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4,	24,	32},

	{FE_LPM_TABLE0_UPPER_MASK2,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5,	24,	6},
	{FE_LPM_TABLE0_UPPER_IP2,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5,	30,	32},

	{FE_LPM_TABLE0_UPPER_MASK3,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA6,	32,	6},

	{FE_LPM_TABLE0_UPPER_IP3,	FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA7,	4,	32},
};


/* LPM_HC_TABLE0_UPPDER_REG */
typedef enum {
	FE_LPM_HC_TABLE0_UPPER_CNT0,
	FE_LPM_HC_TABLE0_UPPER_CNT1,
	FE_LPM_HC_TABLE0_UPPER_CNT2,
	FE_LPM_HC_TABLE0_UPPER_CNT3,
	FE_LPM_HC_TABLE0_UPPER_FIELD_MAX
} cs_fe_lpm_hc_table0_upper_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_hc_table0_upper_reg_fields[FE_LPM_HC_TABLE0_UPPER_FIELD_MAX] = {
	{FE_LPM_HC_TABLE0_UPPER_CNT0,	FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0,	0,	27},
	{FE_LPM_HC_TABLE0_UPPER_CNT1,	FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0,	27,	27},

	{FE_LPM_HC_TABLE0_UPPER_CNT2,	FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA1,	22,	27},

	{FE_LPM_HC_TABLE0_UPPER_CNT3,	FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA2,	17,	27},
};


/* LPM_TABLE0_LOWER_REGF_ACCESS */
typedef enum {
	FE_LPM_TABLE0_LOWER_CFG_ADDR,
	FE_LPM_TABLE0_LOWER_CFG_RSVD,
	FE_LPM_TABLE0_LOWER_CFG_PARITY_BYPASS,
	FE_LPM_TABLE0_LOWER_CFG_WRDN,
	FE_LPM_TABLE0_LOWER_CFG_ACCESS,
	FE_LPM_TABLE0_LOWER_CFG_FIELD_MAX
} cs_fe_lpm_table0_lower_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table0_lower_cfg_fields[FE_LPM_TABLE0_LOWER_CFG_FIELD_MAX] = {
	{FE_LPM_TABLE0_LOWER_CFG_ADDR,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,	0,	3},
	{FE_LPM_TABLE0_LOWER_CFG_RSVD,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,	3,	26},
	{FE_LPM_TABLE0_LOWER_CFG_PARITY_BYPASS,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,	29,	1},
	{FE_LPM_TABLE0_LOWER_CFG_WRDN,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,	30,	1},
	{FE_LPM_TABLE0_LOWER_CFG_ACCESS,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,	31,	1},
};


/* LPM_TABLE0_LOWER_REG */
typedef enum {
	FE_LPM_TABLE0_LOWER_NH0,
	FE_LPM_TABLE0_LOWER_NH1,
	FE_LPM_TABLE0_LOWER_NH2,
	FE_LPM_TABLE0_LOWER_NH3,
	FE_LPM_TABLE0_LOWER_MASK0,
	FE_LPM_TABLE0_LOWER_IP0,
	FE_LPM_TABLE0_LOWER_MASK1,
	FE_LPM_TABLE0_LOWER_IP1,
	FE_LPM_TABLE0_LOWER_MASK2,
	FE_LPM_TABLE0_LOWER_IP2,
	FE_LPM_TABLE0_LOWER_MASK3,
	FE_LPM_TABLE0_LOWER_IP3,
	FE_LPM_TABLE0_LOWER_FIELD_MAX
} cs_fe_lpm_table0_lower_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table0_lower_reg_fields[FE_LPM_TABLE0_LOWER_FIELD_MAX] = {
	{FE_LPM_TABLE0_LOWER_NH0,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0,	0,	27},
	{FE_LPM_TABLE0_LOWER_NH1,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0,	27,	27},

	{FE_LPM_TABLE0_LOWER_NH2,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA1,	22,	27},

	{FE_LPM_TABLE0_LOWER_NH3,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA2,	17,	27},

	{FE_LPM_TABLE0_LOWER_MASK0,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3,	12,	6},
	{FE_LPM_TABLE0_LOWER_IP0,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3,	18,	32},

	{FE_LPM_TABLE0_LOWER_MASK1,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4,	18,	6},
	{FE_LPM_TABLE0_LOWER_IP1,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4,	24,	32},

	{FE_LPM_TABLE0_LOWER_MASK2,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5,	24,	6},
	{FE_LPM_TABLE0_LOWER_IP2,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5,	30,	32},

	{FE_LPM_TABLE0_LOWER_MASK3,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA6,	30,	6},

	{FE_LPM_TABLE0_LOWER_IP3,	FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA7,	4,	32},
};


/* LPM_HC_TABLE0_LOWER_REG */
typedef enum {
	FE_LPM_HC_TABLE0_LOWER_CNT0,
	FE_LPM_HC_TABLE0_LOWER_CNT1,
	FE_LPM_HC_TABLE0_LOWER_CNT2,
	FE_LPM_HC_TABLE0_LOWER_CNT3,
	FE_LPM_HC_TABLE0_LOWER_FIELD_MAX
} cs_fe_lpm_hc_table0_lower_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_hc_table0_lower_reg_fields[FE_LPM_HC_TABLE0_LOWER_FIELD_MAX] = {
	{FE_LPM_HC_TABLE0_LOWER_CNT0,	FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0,	0,	27},
	{FE_LPM_HC_TABLE0_LOWER_CNT1,	FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0,	27,	27},

	{FE_LPM_HC_TABLE0_LOWER_CNT2,	FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA1,	22,	27},

	{FE_LPM_HC_TABLE0_LOWER_CNT3,	FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA2,	17,	27},
};


/* LPM_TABLE1_UPPER_REGF_ACCESS */
typedef enum {
	FE_LPM_TABLE1_UPPER_CFG_ADDR,
	FE_LPM_TABLE1_UPPER_CFG_RSVD,
	FE_LPM_TABLE1_UPPER_CFG_PARITY_BYPASS,
	FE_LPM_TABLE1_UPPER_CFG_WRDN,
	FE_LPM_TABLE1_UPPER_CFG_ACCESS,
	FE_LPM_TABLE1_UPPER_CFG_FIELD_MAX
} cs_fe_lpm_table1_upper_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table1_upper_cfg_fields[FE_LPM_TABLE1_UPPER_CFG_FIELD_MAX] = {
	{FE_LPM_TABLE1_UPPER_CFG_ADDR,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,	0,	3},
	{FE_LPM_TABLE1_UPPER_CFG_RSVD,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,	3,	26},
	{FE_LPM_TABLE1_UPPER_CFG_PARITY_BYPASS,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,	29,	1},
	{FE_LPM_TABLE1_UPPER_CFG_WRDN,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,	30,	1},
	{FE_LPM_TABLE1_UPPER_CFG_ACCESS,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,	31,	1},
};


/* LPM_TABLE1_UPPDER_REG */
typedef enum {
	FE_LPM_TABLE1_UPPER_NH0,
	FE_LPM_TABLE1_UPPER_NH1,
	FE_LPM_TABLE1_UPPER_NH2,
	FE_LPM_TABLE1_UPPER_NH3,
	FE_LPM_TABLE1_UPPER_MASK0,
	FE_LPM_TABLE1_UPPER_IP0,
	FE_LPM_TABLE1_UPPER_MASK1,
	FE_LPM_TABLE1_UPPER_IP1,
	FE_LPM_TABLE1_UPPER_MASK2,
	FE_LPM_TABLE1_UPPER_IP2,
	FE_LPM_TABLE1_UPPER_MASK3,
	FE_LPM_TABLE1_UPPER_IP3,
	FE_LPM_TABLE1_UPPER_FIELD_MAX
} cs_fe_lpm_table1_upper_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table1_upper_ree_fields[FE_LPM_TABLE1_UPPER_FIELD_MAX] = {
	{FE_LPM_TABLE1_UPPER_NH0,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0,	0,	27},
	{FE_LPM_TABLE1_UPPER_NH1,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0,	27,	27},

	{FE_LPM_TABLE1_UPPER_NH2,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA1,	22,	27},

	{FE_LPM_TABLE1_UPPER_NH3,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA2,	17,	27},

	{FE_LPM_TABLE1_UPPER_MASK0,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3,	12,	6},
	{FE_LPM_TABLE1_UPPER_IP0,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3,	18,	32},

	{FE_LPM_TABLE1_UPPER_MASK1,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4,	18,	6},
	{FE_LPM_TABLE1_UPPER_IP1,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4,	24,	32},

	{FE_LPM_TABLE1_UPPER_MASK2,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5,	24,	6},
	{FE_LPM_TABLE1_UPPER_IP2,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5,	30,	32},

	{FE_LPM_TABLE1_UPPER_MASK3,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA6,	32,	6},

	{FE_LPM_TABLE1_UPPER_IP3,	FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA7,	4,	32},
};


/* LPM_HC_TABLE1_UPPDER_REG */
typedef enum cs_fe_lpm_hc_table1_upper_reg_field {
	FE_LPM_HC_TABLE1_UPPER_CNT0,
	FE_LPM_HC_TABLE1_UPPER_CNT1,
	FE_LPM_HC_TABLE1_UPPER_CNT2,
	FE_LPM_HC_TABLE1_UPPER_CNT3,
	FE_LPM_HC_TABLE1_UPPER_FIELD_MAX
} cs_fe_lpm_hc_table1_upper_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_hc_table1_upper_reg_fields[FE_LPM_HC_TABLE1_UPPER_FIELD_MAX] = {
	{FE_LPM_HC_TABLE1_UPPER_CNT0,	FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0,	0,	27},
	{FE_LPM_HC_TABLE1_UPPER_CNT1,	FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0,	27,	27},

	{FE_LPM_HC_TABLE1_UPPER_CNT2,	FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA1,	22,	27},

	{FE_LPM_HC_TABLE1_UPPER_CNT3,	FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA2,	17,	27},
};


/* LPM_TABLE1_LOWER_REGF_ACCESS */
typedef enum {
	FE_LPM_TABLE1_LOWER_CFG_ADDR,
	FE_LPM_TABLE1_LOWER_CFG_RSVD,
	FE_LPM_TABLE1_LOWER_CFG_PARITY_BYPASS,
	FE_LPM_TABLE1_LOWER_CFG_WRDN,
	FE_LPM_TABLE1_LOWER_CFG_ACCESS,
	FE_LPM_TABLE1_LOWER_CFG_FIELD_MAX
} cs_fe_lpm_table1_lower_cfg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table1_lower_cfg_fields[FE_LPM_TABLE1_LOWER_CFG_FIELD_MAX] = {
	{FE_LPM_TABLE1_LOWER_CFG_ADDR,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,	0,	3},
	{FE_LPM_TABLE1_LOWER_CFG_RSVD,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,	3,	26},
	{FE_LPM_TABLE1_LOWER_CFG_PARITY_BYPASS,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,	29,	1},
	{FE_LPM_TABLE1_LOWER_CFG_WRDN,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,	30,	1},
	{FE_LPM_TABLE1_LOWER_CFG_ACCESS,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,	31,	1},
};

/* LPM_TABLE1_LOWER_REG */
typedef enum {
	FE_LPM_TABLE1_LOWER_NH0,
	FE_LPM_TABLE1_LOWER_NH1,
	FE_LPM_TABLE1_LOWER_NH2,
	FE_LPM_TABLE1_LOWER_NH3,
	FE_LPM_TABLE1_LOWER_MASK0,
	FE_LPM_TABLE1_LOWER_IP0,
	FE_LPM_TABLE1_LOWER_MASK1,
	FE_LPM_TABLE1_LOWER_IP1,
	FE_LPM_TABLE1_LOWER_MASK2,
	FE_LPM_TABLE1_LOWER_IP2,
	FE_LPM_TABLE1_LOWER_MASK3,
	FE_LPM_TABLE1_LOWER_IP3,
	FE_LPM_TABLE1_LOWER_FIELD_MAX
} cs_fe_lpm_table1_lower_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_table1_lower_reg_fields[FE_LPM_TABLE1_LOWER_FIELD_MAX] = {
	{FE_LPM_TABLE1_LOWER_NH0,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0,	0,	27},
	{FE_LPM_TABLE1_LOWER_NH1,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0,	27,	27},

	{FE_LPM_TABLE1_LOWER_NH2,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA1,	22,	27},

	{FE_LPM_TABLE1_LOWER_NH3,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA2,	17,	27},

	{FE_LPM_TABLE1_LOWER_MASK0,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3,	12,	6},
	{FE_LPM_TABLE1_LOWER_IP0,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3,	18,	32},

	{FE_LPM_TABLE1_LOWER_MASK1,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4,	18,	6},
	{FE_LPM_TABLE1_LOWER_IP1,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4,	24,	32},

	{FE_LPM_TABLE1_LOWER_MASK2,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5,	24,	6},
	{FE_LPM_TABLE1_LOWER_IP2,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5,	30,	32},

	{FE_LPM_TABLE1_LOWER_MASK3,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA6,	30,	6},

	{FE_LPM_TABLE1_LOWER_IP3,	FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA7,	4,	32},
};


/* LPM_HC_TABLE1_LOWER_REG */
typedef enum {
	FE_LPM_HC_TABLE1_LOWER_CNT0,
	FE_LPM_HC_TABLE1_LOWER_CNT1,
	FE_LPM_HC_TABLE1_LOWER_CNT2,
	FE_LPM_HC_TABLE1_LOWER_CNT3,
	FE_LPM_HC_TABLE1_LOWER_FIELD_MAX
} cs_fe_lpm_hc_table1_lower_reg_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_hc_table1_lower_reg_fields[FE_LPM_HC_TABLE1_LOWER_FIELD_MAX] = {
	{FE_LPM_HC_TABLE1_LOWER_CNT0,	FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0,	0,	27},
	{FE_LPM_HC_TABLE1_LOWER_CNT1,	FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0,	27,	27},

	{FE_LPM_HC_TABLE1_LOWER_CNT2,	FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA1,	22,	27},

	{FE_LPM_HC_TABLE1_LOWER_CNT3,	FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA2,	17,	27},
};


/* LPM_MEM_INIT */
typedef enum {
	FE_LPM0_LOWER_START_INIT,
	FE_LPM0_UPPER_START_INIT,
	FE_LPM1_UPPER_START_INIT,
	FE_LPM1_LOWER_START_INIT,
	FE_HC0_LOWER_START_INIT,
	FE_HC1_LOWER_START_INIT,
	FE_HC0_UPPER_START_INIT,
	FE_HC1_UPPER_START_INIT,
	FE_LPM_MEM_INIT_FIELD_MAX
} cs_fe_lpm_mem_init_field_e;

static const cs_reg_access_field_s
cs_fe_lpm_mem_init_fields[FE_LPM_MEM_INIT_FIELD_MAX] = {
	{FE_LPM0_LOWER_START_INIT,	FETOP_LPM_MEM_INIT,	0,	1},
	{FE_LPM0_UPPER_START_INIT,	FETOP_LPM_MEM_INIT,	1,	1},
	{FE_LPM1_UPPER_START_INIT,	FETOP_LPM_MEM_INIT,	2,	1},
	{FE_LPM1_LOWER_START_INIT,	FETOP_LPM_MEM_INIT,	3,	1},
	{FE_HC0_LOWER_START_INIT,	FETOP_LPM_MEM_INIT,	4,	1},
	{FE_HC1_LOWER_START_INIT,	FETOP_LPM_MEM_INIT,	5,	1},
	{FE_HC0_UPPER_START_INIT,	FETOP_LPM_MEM_INIT,	6,	1},
	{FE_HC1_UPPER_START_INIT,	FETOP_LPM_MEM_INIT,	7,	1},
};


/****************************** FETOP_HASH **************************/

/* HASH_MULT_HIT */
typedef enum {
	FE_HASH_MULT_HIT_HASH_ADDR,
	FE_HASH_MULT_HIT_HASH_OVFW_ADDR,
	FE_HASH_MULT_HIT_FIELD_MAX,
} cs_fe_hash_mult_hit_field_e;

static const cs_reg_access_field_s
cs_fe_hash_mult_hit_fielids[FE_HASH_MULT_HIT_FIELD_MAX] = {
	{FE_HASH_MULT_HIT_HASH_ADDR,		FETOP_HASH_MULT_HIT,	0,	12},
	{FE_HASH_MULT_HIT_HASH_OVFW_ADDR,	FETOP_HASH_MULT_HIT,	12,	6},
};


/* HASH_MEM_DATA */
typedef enum cs_fe_hash_mem_data_field {
	FE_HASH_HASH_CRC32_0,
	FE_HASH_HASH_RSLT_IDX_0,
	FE_HASH_HASH_MASK_PTR_0,
	FE_HASH_HASH_CRC32_1,
	FE_HASH_HASH_RSLT_IDX_1,
	FE_HASH_HASH_MASK_PTR_1,
	FE_HASH_HASH_MEM_DATA_FIELD_MAX,
} cs_fe_hash_mem_data_field_e;

static const cs_reg_access_field_s
cs_fe_hash_mem_data_fields[FE_HASH_HASH_MEM_DATA_FIELD_MAX] = {
	{FE_HASH_HASH_CRC32_0,		FETOP_HASH_HASH_MEM_DATA0,	0,	32},

	{FE_HASH_HASH_RSLT_IDX_0,	FETOP_HASH_HASH_MEM_DATA1,	0,	13},
	{FE_HASH_HASH_MASK_PTR_0,	FETOP_HASH_HASH_MEM_DATA1,	13,	6},
	{FE_HASH_HASH_CRC32_1,		FETOP_HASH_HASH_MEM_DATA1,	19,	32},

	{FE_HASH_HASH_RSLT_IDX_1,	FETOP_HASH_HASH_MEM_DATA2,	19,	13},

	{FE_HASH_HASH_MASK_PTR_1,	FETOP_HASH_HASH_MEM_DATA3,	0,	6},
};


/* HASH_OVERFLOW_MEM_DATA */
typedef enum {
	FE_HASH_OVERFLOW_CRC32,
	FE_HASH_OVERFLOW_CRC16,
	FE_HASH_OVERFLOW_RSLT_IDX,
	FE_HASH_OVERFLOW_MASK_PTR,
	FE_HASH_OVERFLOW_MEM_DATA_FIELD_MAX
} cs_fe_hash_overflow_mem_data_field_e;

static const cs_reg_access_field_s
cs_fe_hash_overflow_mem_data_fields[FE_HASH_OVERFLOW_MEM_DATA_FIELD_MAX] = {
	{FE_HASH_OVERFLOW_CRC32,	FETOP_HASH_OVERFLOW_MEM_DATA0,	0,	32},

	{FE_HASH_OVERFLOW_CRC16,	FETOP_HASH_OVERFLOW_MEM_DATA1,	0,	12},
	{FE_HASH_OVERFLOW_RSLT_IDX,	FETOP_HASH_OVERFLOW_MEM_DATA1,	12,	13},
	{FE_HASH_OVERFLOW_MASK_PTR,	FETOP_HASH_OVERFLOW_MEM_DATA1,	25,	6},
};


/* HASH_STATUS_MEM_DATA */
typedef enum {
	FE_HASH_STATUS_MEM_DATA_DATA,
	FE_HASH_STATUS_MEM_DATA_FIELD_MAX
} cs_fe_hash_status_mem_data_field_e;

static const cs_reg_access_field_s
cs_fe_hash_status_mem_data_fields[FE_HASH_STATUS_MEM_DATA_FIELD_MAX] = {
	{FE_HASH_STATUS_MEM_DATA_DATA,	FETOP_HASH_STATUS_MEM_DATA0,	0,	64},
};


/* HASH_HM_MEM_DATA */
typedef enum cs_fe_hm_mem_data_field {
	FE_HM_MAC_DA_MASK,
	FE_HM_MAC_SA_MASK,
	FE_HM_ETHERTYPE_MASK,
	FE_HM_LLC_TYPE_ENC_MSB_MASK,
	FE_HM_LLC_TYPE_ENC_LSB_MASK,
	FE_HM_TPID_ENC_1_MSB_MASK,
	FE_HM_TPID_ENC_1_LSB_MASK,
	FE_HM_8021P_1_MASK,
	FE_HM_DEI_1_MASK,
	FE_HM_VID_1_MASK,
	FE_HM_TPID_ENC_2_MSB_MASK,
	FE_HM_TPID_ENC_2_LSB_MASK,
	FE_HM_8021P_2_MASK,
	FE_HM_DEI_2_MASK,
	FE_HM_VID_2_MASK,
	FE_HM_IP_DA_MASK,

	FE_HM_IP_SA_MASK,
	FE_HM_IP_PROT_MASK,
	FE_HM_DSCP_MASK,
	FE_HM_ECN_MASK,
	FE_HM_IP_FRAGMENT_MASK,
	FE_HM_KEYGEN_POLY_SEL,
	FE_HM_IPV6_FLOW_LBL_MASK,
	FE_HM_IP_VER_MASK,
	FE_HM_IP_VLD_MASK,
	FE_HM_L4_PORTS_RNGD,
	FE_HM_L4_DP_MASK,

	FE_HM_L4_SP_MASK,
	FE_HM_TCP_CTRL_MASK,

	FE_HM_TCP_ECN_MASK,
	FE_HM_L4_VLD_MASK,
	FE_HM_LSPID_MASK,
	FE_HM_FWDTYPE_MASK,
	FE_HM_PPPOE_SESSION_ID_VLD_MASK,
	FE_HM_PPPOE_SESSION_ID_MASK,
	FE_HM_RSVD_109,
	FE_HM_RECIRC_IDX_MASK,
	FE_HM_MCIDX_MASK,
	FE_HM_MC_DA_MASK,
	FE_HM_BC_DA_MASK,
	FE_HM_DA_AN_MAC_SEL_MASK,
	FE_HM_DA_AN_MAC_HIT_MASK,
	FE_HM_ORIG_LSPID_MASK,
	FE_HM_L7_FIELD_MASK,
	FE_HM_L7_FIELD_VLD_MASK,
	FE_HM_HDR_A_FLAGS_CRCERR_MASK,
	FE_HM_L3_CHKSUM_ERR_MASK,
	FE_HM_L4_CHKSUM_ERR_MASK,
	FE_HM_NOT_HDR_A_FLAGS_STSVLD_MASK,
	FE_HM_HASH_FID_MASK,
	FE_HM_L7_FIELD_SEL,
	FE_HM_SA_BNG_MAC_SEL_MASK,
	FE_HM_SA_BNG_MAC_HIT_MASK,

	FE_HM_SPI_VLD_MASK,
	FE_HM_SPI_MASK,
	FE_HM_IPV6_NDP_MASK,
	FE_HM_IPV6_HBH_MASK,
	FE_HM_IPV6_RH_MASK,
	FE_HM_IPV6_DOH_MASK,
	FE_HM_PPP_PROTOCOL_VLD_MASK,
	FE_HM_PPP_PROTOCOL_MASK,
	FE_HM_PKTLEN_RNG_MATCH_VECTOR_MASK,
	FE_HM_MCGID_MASK,
	FE_HM_PARITY,
	FE_HM_MEM_DATA_FIELD_MAX
} cs_fe_hm_mem_data_field_e;

static const cs_reg_access_field_s
cs_fe_hm_mem_data_fields[FE_HM_MEM_DATA_FIELD_MAX] = {
	{FE_HM_MAC_DA_MASK,				FETOP_HASH_MASK_MEM_DATA0,	0,	6},
	{FE_HM_MAC_SA_MASK,				FETOP_HASH_MASK_MEM_DATA0,	6,	6},
	{FE_HM_ETHERTYPE_MASK,			FETOP_HASH_MASK_MEM_DATA0,	12,	1},
	{FE_HM_LLC_TYPE_ENC_MSB_MASK,	FETOP_HASH_MASK_MEM_DATA0,	13,	1},
	{FE_HM_LLC_TYPE_ENC_LSB_MASK,	FETOP_HASH_MASK_MEM_DATA0,	14,	1},
	{FE_HM_TPID_ENC_1_MSB_MASK,		FETOP_HASH_MASK_MEM_DATA0,	15,	1},
	{FE_HM_TPID_ENC_1_LSB_MASK,		FETOP_HASH_MASK_MEM_DATA0,	16,	1},
	{FE_HM_8021P_1_MASK,			FETOP_HASH_MASK_MEM_DATA0,	17,	1},
	{FE_HM_DEI_1_MASK,				FETOP_HASH_MASK_MEM_DATA0,	18,	1},
	{FE_HM_VID_1_MASK,				FETOP_HASH_MASK_MEM_DATA0,	19,	1},
	{FE_HM_TPID_ENC_2_MSB_MASK,		FETOP_HASH_MASK_MEM_DATA0,	20,	1},
	{FE_HM_TPID_ENC_2_LSB_MASK,		FETOP_HASH_MASK_MEM_DATA0,	21,	1},
	{FE_HM_8021P_2_MASK,			FETOP_HASH_MASK_MEM_DATA0,	22,	1},
	{FE_HM_DEI_2_MASK,				FETOP_HASH_MASK_MEM_DATA0,	23,	1},
	{FE_HM_VID_2_MASK,				FETOP_HASH_MASK_MEM_DATA0,	24,	1},
	{FE_HM_IP_DA_MASK,				FETOP_HASH_MASK_MEM_DATA0,	25,	9},

	{FE_HM_IP_SA_MASK,				FETOP_HASH_MASK_MEM_DATA1,	2,	9},
	{FE_HM_IP_PROT_MASK,			FETOP_HASH_MASK_MEM_DATA1,	11,	1},
	{FE_HM_DSCP_MASK,				FETOP_HASH_MASK_MEM_DATA1,	12,	6},
	{FE_HM_ECN_MASK,				FETOP_HASH_MASK_MEM_DATA1,	18,	2},
	{FE_HM_IP_FRAGMENT_MASK,		FETOP_HASH_MASK_MEM_DATA1,	20,	1},
	{FE_HM_KEYGEN_POLY_SEL,			FETOP_HASH_MASK_MEM_DATA1,	21,	2},
	{FE_HM_IPV6_FLOW_LBL_MASK,		FETOP_HASH_MASK_MEM_DATA1,	23,	1},
	{FE_HM_IP_VER_MASK,				FETOP_HASH_MASK_MEM_DATA1,	24,	1},
	{FE_HM_IP_VLD_MASK,				FETOP_HASH_MASK_MEM_DATA1,	25,	1},
	{FE_HM_L4_PORTS_RNGD,			FETOP_HASH_MASK_MEM_DATA1,	26,	2},
	{FE_HM_L4_DP_MASK,				FETOP_HASH_MASK_MEM_DATA1,	28,	16},

	{FE_HM_L4_SP_MASK,				FETOP_HASH_MASK_MEM_DATA2,	12,	16},
	{FE_HM_TCP_CTRL_MASK,			FETOP_HASH_MASK_MEM_DATA2,	28,	6},

	{FE_HM_TCP_ECN_MASK,			FETOP_HASH_MASK_MEM_DATA3,	2,	3},
	{FE_HM_L4_VLD_MASK,				FETOP_HASH_MASK_MEM_DATA3,	5,	1},
	{FE_HM_LSPID_MASK,				FETOP_HASH_MASK_MEM_DATA3,	6,	1},
	{FE_HM_FWDTYPE_MASK,			FETOP_HASH_MASK_MEM_DATA3,	7,	4},
	{FE_HM_PPPOE_SESSION_ID_VLD_MASK,	FETOP_HASH_MASK_MEM_DATA3,	11,	1},
	{FE_HM_PPPOE_SESSION_ID_MASK,	FETOP_HASH_MASK_MEM_DATA3,	12,	1},
	{FE_HM_RSVD_109,				FETOP_HASH_MASK_MEM_DATA3,	13,	1},
	{FE_HM_RECIRC_IDX_MASK,			FETOP_HASH_MASK_MEM_DATA3,	14,	1},
	{FE_HM_MCIDX_MASK,				FETOP_HASH_MASK_MEM_DATA3,	15,	1},
	{FE_HM_MC_DA_MASK,				FETOP_HASH_MASK_MEM_DATA3,	16,	1},
	{FE_HM_BC_DA_MASK,				FETOP_HASH_MASK_MEM_DATA3,	17,	1},
	{FE_HM_DA_AN_MAC_SEL_MASK,		FETOP_HASH_MASK_MEM_DATA3,	18,	1},
	{FE_HM_DA_AN_MAC_HIT_MASK,		FETOP_HASH_MASK_MEM_DATA3,	19,	1},
	{FE_HM_ORIG_LSPID_MASK,			FETOP_HASH_MASK_MEM_DATA3,	20,	1},
	{FE_HM_L7_FIELD_MASK,			FETOP_HASH_MASK_MEM_DATA3,	21,	1},
	{FE_HM_L7_FIELD_VLD_MASK,		FETOP_HASH_MASK_MEM_DATA3,	22,	1},
	{FE_HM_HDR_A_FLAGS_CRCERR_MASK,	FETOP_HASH_MASK_MEM_DATA3,	23,	1},
	{FE_HM_L3_CHKSUM_ERR_MASK,		FETOP_HASH_MASK_MEM_DATA3,	24,	1},
	{FE_HM_L4_CHKSUM_ERR_MASK,		FETOP_HASH_MASK_MEM_DATA3,	25,	1},
	{FE_HM_NOT_HDR_A_FLAGS_STSVLD_MASK,	FETOP_HASH_MASK_MEM_DATA3,	26,	1},
	{FE_HM_HASH_FID_MASK,			FETOP_HASH_MASK_MEM_DATA3,	27,	1},
	{FE_HM_L7_FIELD_SEL,			FETOP_HASH_MASK_MEM_DATA3,	28,	2},
	{FE_HM_SA_BNG_MAC_SEL_MASK,		FETOP_HASH_MASK_MEM_DATA3,	30,	1},
	{FE_HM_SA_BNG_MAC_HIT_MASK,		FETOP_HASH_MASK_MEM_DATA3,	31,	1},

	{FE_HM_SPI_VLD_MASK,			FETOP_HASH_MASK_MEM_DATA4,	0,	1},
	{FE_HM_SPI_MASK,				FETOP_HASH_MASK_MEM_DATA4,	1,	1},
	{FE_HM_IPV6_NDP_MASK,			FETOP_HASH_MASK_MEM_DATA4,	2,	1},
	{FE_HM_IPV6_HBH_MASK,			FETOP_HASH_MASK_MEM_DATA4,	3,	1},
	{FE_HM_IPV6_RH_MASK,			FETOP_HASH_MASK_MEM_DATA4,	4,	1},
	{FE_HM_IPV6_DOH_MASK,			FETOP_HASH_MASK_MEM_DATA4,	5,	1},
	{FE_HM_PPP_PROTOCOL_VLD_MASK,	FETOP_HASH_MASK_MEM_DATA4,	6,	1},
	{FE_HM_PPP_PROTOCOL_MASK,		FETOP_HASH_MASK_MEM_DATA4,	7,	1},
	{FE_HM_PKTLEN_RNG_MATCH_VECTOR_MASK,	FETOP_HASH_MASK_MEM_DATA4,	8,	4},
	{FE_HM_MCGID_MASK,		        FETOP_HASH_MASK_MEM_DATA4,	12,	9},
	{FE_HM_PARITY,					FETOP_HASH_MASK_MEM_DATA4,	21,	1},
};


/* HASH_DBG_FIFO */
/* access register is FETOP_HASH_DBG_FIFO_ACCESS */
typedef enum {
	FE_HASH_DBG_FIFO_CRC32,

	FE_HASH_DBG_FIFO_CRC16,
	FE_HASH_DBG_FIFO_RESULT_INDEX,
	FE_HASH_DBG_FIFO_MASK_PTR,
	FE_HASH_DBG_FIFO_RESULT_ADDR,

	FE_HASH_DBG_FIFO_TUPLE_PRIORITY,
	FE_HASH_DBG_FIFO_TUPLE_HIT,
	FE_HASH_DBG_FIFO_ACCESS_FIELD_MAX
} cs_fe_hash_dbg_fifo_data_field_e;

static const cs_reg_access_field_s
cs_fe_hash_dbg_fifo_data_fields[FE_HASH_DBG_FIFO_ACCESS_FIELD_MAX] = {
	{FE_HASH_DBG_FIFO_CRC32,		FETOP_HASH_DBG_FIFO_DATA0,	0,	32},

	{FE_HASH_DBG_FIFO_CRC16,		FETOP_HASH_DBG_FIFO_DATA1,	0,	12},
	{FE_HASH_DBG_FIFO_RESULT_INDEX,	FETOP_HASH_DBG_FIFO_DATA1,	12,	13},
	{FE_HASH_DBG_FIFO_MASK_PTR,		FETOP_HASH_DBG_FIFO_DATA1,	25,	6},
	{FE_HASH_DBG_FIFO_RESULT_ADDR,	FETOP_HASH_DBG_FIFO_DATA1,	31,	16},

	{FE_HASH_DBG_FIFO_TUPLE_PRIORITY,	FETOP_HASH_DBG_FIFO_DATA2,	15,	4},
	{FE_HASH_DBG_FIFO_TUPLE_HIT,	FETOP_HASH_DBG_FIFO_DATA2,	19,	1},
};


/* HASH_SUPER_HASH */
typedef enum cs_fe_hash_super_hash_field {
	FE_HASH_SUPER_HASH_MASK_PTR,
	FE_HASH_SUPER_HASH_ENABLE,
	FE_HASH_SUPER_HASH_FIELD_MAX
} cs_fe_hash_super_hash_field_e;

static const cs_reg_access_field_s
cs_fe_hash_super_hash_fields[FE_HASH_SUPER_HASH_FIELD_MAX] = {
	{FE_HASH_SUPER_HASH_MASK_PTR,	FETOP_HASH_SUPER_HASH,	0,	6},
	{FE_HASH_SUPER_HASH_ENABLE,		FETOP_HASH_SUPER_HASH,	6,	1},
};


/* HASH_CHECK_MEM_ACCESS */
typedef enum cs_fe_hash_check_mem_access_field {
	FE_HASH_CHECK_MEM_ADDR,
	FE_HASH_CHECK_MEM_RSVD,
	FE_HASH_CHECK_MEM_RB_W,
	FE_HASH_CHECK_MEM_ACCESS,
	FE_HASH_CHECK_MEM_FIELD_MAX,
} cs_fe_hash_check_mem_access_field_e;

static const cs_reg_access_field_s
cs_fe_hash_check_mem_access_fields[FE_HASH_CHECK_MEM_FIELD_MAX] = {
	{FE_HASH_CHECK_MEM_ADDR,	FETOP_HASH_CHECK_MEM_ACCESS,	0,	13},
	{FE_HASH_CHECK_MEM_RSVD,	FETOP_HASH_CHECK_MEM_ACCESS,	13,	17},
	{FE_HASH_CHECK_MEM_RB_W,	FETOP_HASH_CHECK_MEM_ACCESS,	30,	1},
	{FE_HASH_CHECK_MEM_ACCESS,	FETOP_HASH_CHECK_MEM_ACCESS,	31,	1},
};


/* HASH_CHECK_MEM_DATA */
typedef enum {
	FE_HASH_CHECK_L4_SP_EN,
	FE_HASH_CHECK_L4_DP_EN,
	FE_HASH_CHECK_MAC_SA_EN,
	FE_HASH_CHECK_MAC_DA_EN,
	FE_HASH_CHECK_IP_SA_EN,
	FE_HASH_CHECK_IP_DA_EN,
	FE_HASH_CHECK_L4_SP_TO_BE_CHK,
	FE_HASH_CHECK_L4_DP_TO_BE_CHK,

	FE_HASH_CHECK_L2_CHECK_IDX,
	FE_HASH_CHECK_IP_SA_CHECK_IDX,
	FE_HASH_CHECK_IP_DA_CHECK_IDX,
	FE_HASH_CHECK_PARITY,
	FE_HASH_CHECK_RSVD,
	FE_HASH_CHECK_FIELD_MAX,
} cs_fe_hash_check_mem_data_field_e;

static const cs_reg_access_field_s
cs_fe_hash_check_mem_data_fields[FE_HASH_CHECK_FIELD_MAX] = {
	{FE_HASH_CHECK_L4_SP_EN,		FETOP_HASH_CHECK_MEM_DATA0,	0,	1},
	{FE_HASH_CHECK_L4_DP_EN,		FETOP_HASH_CHECK_MEM_DATA0,	1,	1},
	{FE_HASH_CHECK_MAC_SA_EN,		FETOP_HASH_CHECK_MEM_DATA0,	2,	1},
	{FE_HASH_CHECK_MAC_DA_EN,		FETOP_HASH_CHECK_MEM_DATA0,	3,	1},
	{FE_HASH_CHECK_IP_SA_EN,		FETOP_HASH_CHECK_MEM_DATA0,	4,	1},
	{FE_HASH_CHECK_IP_DA_EN,		FETOP_HASH_CHECK_MEM_DATA0,	5,	1},
	{FE_HASH_CHECK_L4_SP_TO_BE_CHK,	FETOP_HASH_CHECK_MEM_DATA0,	6,	16},
	{FE_HASH_CHECK_L4_DP_TO_BE_CHK,	FETOP_HASH_CHECK_MEM_DATA0,	22,	16},

	{FE_HASH_CHECK_L2_CHECK_IDX,	FETOP_HASH_CHECK_MEM_DATA1,	6,	9},
	{FE_HASH_CHECK_IP_SA_CHECK_IDX,	FETOP_HASH_CHECK_MEM_DATA1,	15,	12},
	{FE_HASH_CHECK_IP_DA_CHECK_IDX,	FETOP_HASH_CHECK_MEM_DATA1,	27,	12},

	{FE_HASH_CHECK_PARITY,			FETOP_HASH_CHECK_MEM_DATA2,	7,	1},
	{FE_HASH_CHECK_RSVD,			FETOP_HASH_CHECK_MEM_DATA2,	8,	24},
};


/*
 *
 * FE CORE LOGIC
 *
 */

/* Packet Editing */


#if 0
/*
 * Format of message that carried by SKB.
 *
 */


#define SW_FWD_TYPE_BRIDGING	0X00000001
#define SW_FWD_TYPE_ARP			0x00000002
#define SW_FWD_TYPE_ICMP		0x00000004
#define SW_FWD_TYPE_IGMP		0x00000008
#define	SW_FWD_TYPE_ESPAH		0x00000010
#define	SW_FWD_TYPE_GRE			0x00000020
#define	SW_FWD_TYPE_ROUTING		0x00000040
#define SW_FWD_TYPE_NAT			0x00000080

typedef struct cs_fe_msg {

	u32	sw_fwd_type;
	/* MAc address of orignal packet */
	u8	orig_mac_sa[6];
	u8	orig_mac_da[6];
	/* MAC address after post-processing */
	u8	post_mac_sa[6];
	u8	post_mac_da[6];
	/* VLAN of orignal packet */
	u16	orig_vlan[2];
	/* VLAN after post_processing */
	u16	post_vlan[2];

	/* */




} cs_fe_msg_s;

#endif

/* FE Table Enumeration Definition */
typedef enum {
	FE_TABLE_AN_BNG_MAC,	/* 0 */
	FE_TABLE_PORT_RANGE,
	FE_TABLE_ETYPE,
	FE_TABLE_LLC_HDR,
	FE_TABLE_LPB,

	FE_TABLE_CLASS,			/* 5 */
	FE_TABLE_SDB,
	FE_TABLE_VLAN,
	FE_TABLE_FWDRSLT,
	FE_TABLE_QOSRSLT,

	FE_TABLE_VOQ_POLICER,	/* 10 */
	FE_TABLE_FVLAN,
	FE_TABLE_L3_IP,
	FE_TABLE_L2_MAC,
	FE_TABLE_ACL_RULE,

	FE_TABLE_ACL_ACTION,	/* 15 */
	FE_TABLE_PE_VOQ_DROP,
	FE_TABLE_LPM_LPMTBL0_UPPER,
	FE_TABLE_LPM_HCTBL0_UPPER,
	FE_TABLE_LPM_LPMTBL0_LOWER,

	FE_TABLE_LPM_HCTBL0_LOWER,	/* 20 */
	FE_TABLE_LPM_LPMTBL1_UPPER,
	FE_TABLE_LPM_HCTBL1_UPPER,
	FE_TABLE_LPM_LPMTBL1_LOWER,
	FE_TABLE_LPM_HCTBL1_LOWER,

	FE_TABLE_HASH_HASH,	/* 25 */
	FE_TABLE_HASH_OVERFLOW,
	FE_TABLE_HASH_STATUS,
	FE_TABLE_HASH_MASK,
	FE_TABLE_HASH_DBG_FIFO,

	FE_TABLE_HASH_CHECK_MEM,	/* 30 */
	FE_TABLE_PKTLEN_RANGE,

	FE_TABLE_MAX,
} cs_fe_hw_table_e;

/* FE table that's not listed in the above enumeration:
 * 1) cs_fe_cfg_tpid
 * 2) cs_fe_parser_cfg
 * 3) cs_fe_proc_cfg
 * 4) cs_fe_pe_cfg
 * 5) cs_fe_pppoe_cfg */

typedef struct {
	const cs_reg_access_field_s	*table_head;
	u16							table_size;
	u8							addr_bit_size;
	u8							data_reg_num;
	u32							access_reg;
	u8							f_ecc_bypass;
} cs_fe_hw_table_info_t;

static const cs_fe_hw_table_info_t
cs_fe_hw_table_info[FE_TABLE_MAX] = {
	/* 0 to 4 */
	{
		cs_fe_an_bng_mac_fields,
		FE_AN_BNG_MAC_ENTRY_MAX,
		4,
		2,
		FETOP_FE_AN_BNG_MAC_ACCESS,
		0
	},
	{
		cs_fe_l4_port_rngs_fields,
		FE_L4_PORT_RNGS_MAX,
		5,
		2,
		FETOP_FE_L4_PORT_RNGS_ACCESS,
		0
	},
	{
		cs_fe_etype_fields,
		FE_ETH_CAM_ENTRY_MAX,
		6,
		1,
		FETOP_FE_ETYPE_ACCESS,
		0
	},
	{
		cs_fe_llc_hdr_fields,
		FE_LLC_ENTRY_MAX,
		2,
		1,
		FETOP_FE_LLC_HDR_ACCESS,
		0
	},
	{
		cs_fe_lpb_fields,
		FE_LPB_ENTRY_MAX,
		3,
		1,
		FETOP_FE_LPB_ACCESS,
		0
	},

	/* 5 to 9 */
	{
		cs_fe_class_fields,
		FE_CLASS_ENTRY_MAX,
		6,
		20,
		FETOP_FE_CLASS_ACCESS,
		0
	},
	{
		cs_fe_sdb_fields,
		FE_SDB_ENTRY_MAX,
		6,
		7,
		FETOP_FE_SDB_ACCESS,
		0
	},
	{
		cs_fe_vln_fields,
		FE_VLAN_ENTRY_MAX,
		12,
		2,
		FETOP_FE_VLN_ACCESS,
		0
	},
	{
		cs_fe_fwdrslt_fields,
		FE_FWD_RESULT_ENTRY_MAX,
		13,
		4,
		FETOP_FE_FWDRSLT_ACCESS,
		0
	},
	{
		cs_fe_qosrslt_fields,
		FE_QOS_RESULT_ENTRY_MAX,
		7,
		2,
		FETOP_FE_QOSRSLT_ACCESS,
		0
	},

	/* 10 to 14 */
	{
		cs_fe_voqpol_fields,
		FE_VOQ_POL_ENTRY_MAX,
		9,
		2,
		FETOP_FE_VOQPOL_ACCESS,
		0
	},
	{
		cs_fe_fvlan_fields,
		FE_FVLAN_ENTRY_MAX,
		9,
		2,
		FETOP_FE_FVLAN_ACCESS,
		0
	},
	{
		cs_fe_l3tbl_fields,
		FE_L3_ADDR_ENTRY_MAX,
		10,
		5,
		FETOP_FE_L3TBL_ACCESS,
		0
	},
	{
		cs_fe_l2tbl_fields,
		FE_L2_ADDR_PAIR_ENTRY_MAX,
		9,
		4,
		FETOP_FE_L2TBL_ACCESS,
		0
	},
	{
		cs_fe_aclrule_fields,
		FE_ACL_ENTRY_MAX,
		7,
		28,
		FETOP_FE_ACLRULE_ACCESS,
		0
	},

	/* 15 to 19 */
	{
		cs_fe_aclaction_fields,
		FE_ACL_ENTRY_MAX,
		7,
		10,
		FETOP_FE_ACLACTION_ACCESS,
		0
	},
	{
		cs_fe_pe_voq_drp_fields,
		FE_PE_VOQ_DROP_ENTRY_MAX,
		5,
		1,
		FETOP_FE_PE_VOQ_DRP_ACCESS,
		0
	},
	{
		cs_fe_lpm_table0_upper_ree_fields,
		FE_LPM_ENTRY_MAX,
		3,
		9,
		FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_hc_table0_upper_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		4,
		FETOP_LPM_HC_TABLE0_UPPER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_table0_lower_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		9,
		FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS,
		1
	},

	/* 20 to 24 */
	{
		cs_fe_lpm_hc_table0_lower_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		4,
		FETOP_LPM_HC_TABLE0_LOWER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_table1_upper_ree_fields,
		FE_LPM_ENTRY_MAX,
		3,
		9,
		FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_hc_table1_upper_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		4,
		FETOP_LPM_HC_TABLE1_UPPER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_table1_lower_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		9,
		FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS,
		1
	},
	{
		cs_fe_lpm_hc_table1_lower_reg_fields,
		FE_LPM_ENTRY_MAX,
		3,
		4,
		FETOP_LPM_HC_TABLE1_LOWER_REGF_ACCESS,
		1
	},

	/* 25 to 29 */
	{
		cs_fe_hash_mem_data_fields,
		FE_HASH_ENTRY_MAX,
		14,
		4,
		FETOP_HASH_HASH_MEM_ACCESS,
		1
	},
	{
		cs_fe_hash_overflow_mem_data_fields,
		FE_HASH_OVERFLOW_ENTRY_MAX,
		6,
		2,
		FETOP_HASH_OVERFLOW_MEM_ACCESS,
		0
	},
	{
		cs_fe_hash_status_mem_data_fields,
		FE_HASH_STATUS_ENTRY_MAX,
		9,
		2,
		FETOP_HASH_STATUS_MEM_ACCESS,
		1
	},
	{
		cs_fe_hm_mem_data_fields,
		FE_HASH_MASK_ENTRY_MAX,
		6,
		5,
		FETOP_HASH_MASK_MEM_ACCESS,
		1
	},
	{
		cs_fe_hash_dbg_fifo_data_fields,
		FE_HASH_DBG_FIFO_ENTRY_MAX,
		5,
		3,
		FETOP_HASH_DBG_FIFO_ACCESS,
		0
	},

	/* 30 to 34 */
	{
		cs_fe_hash_check_mem_data_fields,
		FE_HASH_CHECK_MEM_ENTRY_MAX,
		13,
		3,
		FETOP_HASH_CHECK_MEM_ACCESS,
		0
	},
	{
		cs_fe_pktlen_rngs_fields,
		FE_PKTLEN_RANGE_ENTRY_MAX,
		2,
		1,
		FETOP_FE_PKTLEN_RNGS_ACCESS,
		0
	},

};

typedef struct {
	void            *p_entry;
	atomic_t        users;
	cs_uint32       crc32;      // crc32 value of p_entry
} fe_table_entry_t;


typedef struct fe_core_tables {
        /* Table0 and Table1 are shadow table of each other */
        fe_lpm_entry_t                  fe_lpm_table0_upper[FE_LPM_ENTRY_MAX];
        fe_lpm_entry_t                  fe_lpm_table0_lower[FE_LPM_ENTRY_MAX];
        fe_lpm_entry_t                  fe_lpm_table1_upper[FE_LPM_ENTRY_MAX];
        fe_lpm_entry_t                  fe_lpm_table1_lower[FE_LPM_ENTRY_MAX];
} fe_core_tables_s;


#endif /* __CS_FE_HEAD_TABLE_H */

