/*
 * REGISTERS.h
 */
#ifndef _REGISTERS_H_
#define _REGISTERS_H_

#include "cs_types.h"

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/


/*
 * GLB
 */
  



#define GLOBAL_JTAG_ID                           0xf0000000
#define GLOBAL_JTAG_ID_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 jtag_id              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 jtag_id              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_JTAG_ID_t;





#define GLOBAL_BLOCK_RESET                       0xf0000004
#define GLOBAL_BLOCK_RESET_dft                   0x00600000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 reset_ts             :  1 ; /* bits 31:31 */
    cs_uint32 reset_lcd            :  1 ; /* bits 30:30 */
    cs_uint32 reset_phy            :  1 ; /* bits 29:29 */
    cs_uint32 reset_sd             :  1 ; /* bits 28:28 */
    cs_uint32 reset_rram           :  1 ; /* bits 27:27 */
    cs_uint32 reset_rreg           :  1 ; /* bits 26:26 */
    cs_uint32 reset_rniadapt       :  1 ; /* bits 25:25 */
    cs_uint32 reset_rcrypto        :  1 ; /* bits 24:24 */
    cs_uint32 reset_rdma           :  1 ; /* bits 23:23 */
    cs_uint32 reset_rcpu1          :  1 ; /* bits 22:22 */
    cs_uint32 reset_rcpu0          :  1 ; /* bits 21:21 */
    cs_uint32 reset_pwr            :  1 ; /* bits 20:20 */
    cs_uint32 reset_cir            :  1 ; /* bits 19:19 */
    cs_uint32 reset_rtc            :  1 ; /* bits 18:18 */
    cs_uint32 reset_ni_xram        :  1 ; /* bits 17:17 */
    cs_uint32 reset_dma            :  1 ; /* bits 16:16 */
    cs_uint32 reset_per            :  1 ; /* bits 15:15 */
    cs_uint32 reset_flash          :  1 ; /* bits 14:14 */
    cs_uint32 reset_usb            :  1 ; /* bits 13:13 */
    cs_uint32 reset_sata3          :  1 ; /* bits 12:12 */
    cs_uint32 reset_sata2          :  1 ; /* bits 11:11 */
    cs_uint32 reset_sata1          :  1 ; /* bits 10:10 */
    cs_uint32 reset_sata0          :  1 ; /* bits 9:9 */
    cs_uint32 reset_pcie2          :  1 ; /* bits 8:8 */
    cs_uint32 reset_pcie1          :  1 ; /* bits 7:7 */
    cs_uint32 reset_pcie0          :  1 ; /* bits 6:6 */
    cs_uint32 reset_qm             :  1 ; /* bits 5:5 */
    cs_uint32 reset_sdram          :  1 ; /* bits 4:4 */
    cs_uint32 reset_sch            :  1 ; /* bits 3:3 */
    cs_uint32 reset_tm             :  1 ; /* bits 2:2 */
    cs_uint32 reset_fe             :  1 ; /* bits 1:1 */
    cs_uint32 reset_ni             :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reset_ni             :  1 ; /* bits 0:0 */
    cs_uint32 reset_fe             :  1 ; /* bits 1:1 */
    cs_uint32 reset_tm             :  1 ; /* bits 2:2 */
    cs_uint32 reset_sch            :  1 ; /* bits 3:3 */
    cs_uint32 reset_sdram          :  1 ; /* bits 4:4 */
    cs_uint32 reset_qm             :  1 ; /* bits 5:5 */
    cs_uint32 reset_pcie0          :  1 ; /* bits 6:6 */
    cs_uint32 reset_pcie1          :  1 ; /* bits 7:7 */
    cs_uint32 reset_pcie2          :  1 ; /* bits 8:8 */
    cs_uint32 reset_sata0          :  1 ; /* bits 9:9 */
    cs_uint32 reset_sata1          :  1 ; /* bits 10:10 */
    cs_uint32 reset_sata2          :  1 ; /* bits 11:11 */
    cs_uint32 reset_sata3          :  1 ; /* bits 12:12 */
    cs_uint32 reset_usb            :  1 ; /* bits 13:13 */
    cs_uint32 reset_flash          :  1 ; /* bits 14:14 */
    cs_uint32 reset_per            :  1 ; /* bits 15:15 */
    cs_uint32 reset_dma            :  1 ; /* bits 16:16 */
    cs_uint32 reset_ni_xram        :  1 ; /* bits 17:17 */
    cs_uint32 reset_rtc            :  1 ; /* bits 18:18 */
    cs_uint32 reset_cir            :  1 ; /* bits 19:19 */
    cs_uint32 reset_pwr            :  1 ; /* bits 20:20 */
    cs_uint32 reset_rcpu0          :  1 ; /* bits 21:21 */
    cs_uint32 reset_rcpu1          :  1 ; /* bits 22:22 */
    cs_uint32 reset_rdma           :  1 ; /* bits 23:23 */
    cs_uint32 reset_rcrypto        :  1 ; /* bits 24:24 */
    cs_uint32 reset_rniadapt       :  1 ; /* bits 25:25 */
    cs_uint32 reset_rreg           :  1 ; /* bits 26:26 */
    cs_uint32 reset_rram           :  1 ; /* bits 27:27 */
    cs_uint32 reset_sd             :  1 ; /* bits 28:28 */
    cs_uint32 reset_phy            :  1 ; /* bits 29:29 */
    cs_uint32 reset_lcd            :  1 ; /* bits 30:30 */
    cs_uint32 reset_ts             :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_BLOCK_RESET_t;





#define GLOBAL_ARM_RESET                         0xf0000008
#define GLOBAL_ARM_RESET_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 reset_ptm            :  1 ; /* bits 25:25 */
    cs_uint32 reset_at             :  1 ; /* bits 24:24 */
    cs_uint32 reset_ctm            :  1 ; /* bits 23:23 */
    cs_uint32 reset_trace          :  1 ; /* bits 22:22 */
    cs_uint32 axireset             :  1 ; /* bits 21:21 */
    cs_uint32 l2reset              :  1 ; /* bits 20:20 */
    cs_uint32 dbg1reset            :  1 ; /* bits 19:19 */
    cs_uint32 dbg0reset            :  1 ; /* bits 18:18 */
    cs_uint32 wd1reset             :  1 ; /* bits 17:17 */
    cs_uint32 wd0reset             :  1 ; /* bits 16:16 */
    cs_uint32 de1reset             :  1 ; /* bits 15:15 */
    cs_uint32 de0reset             :  1 ; /* bits 14:14 */
    cs_uint32 cpu1reset            :  1 ; /* bits 13:13 */
    cs_uint32 cpu0reset            :  1 ; /* bits 12:12 */
    cs_uint32 periphreset          :  1 ; /* bits 11:11 */
    cs_uint32 scureset             :  1 ; /* bits 10:10 */
    cs_uint32 prevent_l2_axi_reset :  1 ; /* bits 9:9 */
    cs_uint32 reset_vector         :  8 ; /* bits 8:1 */
    cs_uint32 restart              :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 restart              :  1 ; /* bits 0:0 */
    cs_uint32 reset_vector         :  8 ; /* bits 8:1 */
    cs_uint32 prevent_l2_axi_reset :  1 ; /* bits 9:9 */
    cs_uint32 scureset             :  1 ; /* bits 10:10 */
    cs_uint32 periphreset          :  1 ; /* bits 11:11 */
    cs_uint32 cpu0reset            :  1 ; /* bits 12:12 */
    cs_uint32 cpu1reset            :  1 ; /* bits 13:13 */
    cs_uint32 de0reset             :  1 ; /* bits 14:14 */
    cs_uint32 de1reset             :  1 ; /* bits 15:15 */
    cs_uint32 wd0reset             :  1 ; /* bits 16:16 */
    cs_uint32 wd1reset             :  1 ; /* bits 17:17 */
    cs_uint32 dbg0reset            :  1 ; /* bits 18:18 */
    cs_uint32 dbg1reset            :  1 ; /* bits 19:19 */
    cs_uint32 l2reset              :  1 ; /* bits 20:20 */
    cs_uint32 axireset             :  1 ; /* bits 21:21 */
    cs_uint32 reset_trace          :  1 ; /* bits 22:22 */
    cs_uint32 reset_ctm            :  1 ; /* bits 23:23 */
    cs_uint32 reset_at             :  1 ; /* bits 24:24 */
    cs_uint32 reset_ptm            :  1 ; /* bits 25:25 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_RESET_t;





#define GLOBAL_STRAP                             0xf000000c
#define GLOBAL_STRAP_dft                         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 strap_core           :  1 ; /* bits 31:31 */
    cs_uint32 strap_ssp            :  1 ; /* bits 30:30 */
    cs_uint32 strap_ts             :  1 ; /* bits 29:29 */
    cs_uint32 strap_encr           :  2 ; /* bits 28:27 */
    cs_uint32 strap_package        :  1 ; /* bits 26:26 */
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 nand_ecc             :  2 ; /* bits 15:14 */
    cs_uint32 uart_message         :  1 ; /* bits 13:13 */
    cs_uint32 sata_sel             :  2 ; /* bits 12:11 */
    cs_uint32 flash_pin            :  1 ; /* bits 10:10 */
    cs_uint32 flash_width          :  1 ; /* bits 9:9 */
    cs_uint32 flash_size           :  2 ; /* bits 8:7 */
    cs_uint32 flash_type           :  3 ; /* bits 6:4 */
    cs_uint32 speed                :  3 ; /* bits 3:1 */
    cs_uint32 secure_mode          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 secure_mode          :  1 ; /* bits 0:0 */
    cs_uint32 speed                :  3 ; /* bits 3:1 */
    cs_uint32 flash_type           :  3 ; /* bits 6:4 */
    cs_uint32 flash_size           :  2 ; /* bits 8:7 */
    cs_uint32 flash_width          :  1 ; /* bits 9:9 */
    cs_uint32 flash_pin            :  1 ; /* bits 10:10 */
    cs_uint32 sata_sel             :  2 ; /* bits 12:11 */
    cs_uint32 uart_message         :  1 ; /* bits 13:13 */
    cs_uint32 nand_ecc             :  2 ; /* bits 15:14 */
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 strap_package        :  1 ; /* bits 26:26 */
    cs_uint32 strap_encr           :  2 ; /* bits 28:27 */
    cs_uint32 strap_ts             :  1 ; /* bits 29:29 */
    cs_uint32 strap_ssp            :  1 ; /* bits 30:30 */
    cs_uint32 strap_core           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_STRAP_t;





#define GLOBAL_GLOBAL_CONFIG                     0xf0000010
#define GLOBAL_GLOBAL_CONFIG_dft                 0x0001fc00




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 core_pd              :  1 ; /* bits 31:31 */
    cs_uint32 recirc_pd            :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 refclk_25m           :  1 ; /* bits 18:18 */
    cs_uint32 ext_eth_refclk       :  1 ; /* bits 17:17 */
    cs_uint32 use_usb_osc          :  1 ; /* bits 16:16 */
    cs_uint32 cfg_sata_2_clken     :  1 ; /* bits 15:15 */
    cs_uint32 cfg_pcie_2_clken     :  1 ; /* bits 14:14 */
    cs_uint32 cfg_sata_1_clken     :  1 ; /* bits 13:13 */
    cs_uint32 cfg_pcie_1_clken     :  1 ; /* bits 12:12 */
    cs_uint32 cfg_sata_0_clken     :  1 ; /* bits 11:11 */
    cs_uint32 cfg_pcie_0_clken     :  1 ; /* bits 10:10 */
    cs_uint32 axi_reset_disable    :  1 ; /* bits 9:9 */
    cs_uint32 l2_reset_disable     :  1 ; /* bits 8:8 */
    cs_uint32 wd_reset_remap       :  1 ; /* bits 7:7 */
    cs_uint32 wd_reset_all_blocks  :  1 ; /* bits 6:6 */
    cs_uint32 wd1_reset_subsys_enable :  1 ; /* bits 5:5 */
    cs_uint32 wd0_reset_subsys_enable :  1 ; /* bits 4:4 */
    cs_uint32 wd_both_enable       :  1 ; /* bits 3:3 */
    cs_uint32 wd1_enable           :  1 ; /* bits 2:2 */
    cs_uint32 wd0_enable           :  1 ; /* bits 1:1 */
    cs_uint32 disable_remap        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 disable_remap        :  1 ; /* bits 0:0 */
    cs_uint32 wd0_enable           :  1 ; /* bits 1:1 */
    cs_uint32 wd1_enable           :  1 ; /* bits 2:2 */
    cs_uint32 wd_both_enable       :  1 ; /* bits 3:3 */
    cs_uint32 wd0_reset_subsys_enable :  1 ; /* bits 4:4 */
    cs_uint32 wd1_reset_subsys_enable :  1 ; /* bits 5:5 */
    cs_uint32 wd_reset_all_blocks  :  1 ; /* bits 6:6 */
    cs_uint32 wd_reset_remap       :  1 ; /* bits 7:7 */
    cs_uint32 l2_reset_disable     :  1 ; /* bits 8:8 */
    cs_uint32 axi_reset_disable    :  1 ; /* bits 9:9 */
    cs_uint32 cfg_pcie_0_clken     :  1 ; /* bits 10:10 */
    cs_uint32 cfg_sata_0_clken     :  1 ; /* bits 11:11 */
    cs_uint32 cfg_pcie_1_clken     :  1 ; /* bits 12:12 */
    cs_uint32 cfg_sata_1_clken     :  1 ; /* bits 13:13 */
    cs_uint32 cfg_pcie_2_clken     :  1 ; /* bits 14:14 */
    cs_uint32 cfg_sata_2_clken     :  1 ; /* bits 15:15 */
    cs_uint32 use_usb_osc          :  1 ; /* bits 16:16 */
    cs_uint32 ext_eth_refclk       :  1 ; /* bits 17:17 */
    cs_uint32 refclk_25m           :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 recirc_pd            :  1 ; /* bits 30:30 */
    cs_uint32 core_pd              :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_CONFIG_t;





#define GLOBAL_PHY_CONTROL                       0xf0000014
#define GLOBAL_PHY_CONTROL_dft                   0x00003faa




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 phy_3_por_n_i        :  1 ; /* bits 31:31 */
    cs_uint32 phy_3_fast_sim_i     :  1 ; /* bits 30:30 */
    cs_uint32 phy_3_ln0_resetn_i   :  1 ; /* bits 29:29 */
    cs_uint32 phy_3_cmu_resetn_i   :  1 ; /* bits 28:28 */
    cs_uint32 phy_2_por_n_i        :  1 ; /* bits 27:27 */
    cs_uint32 phy_2_fast_sim_i     :  1 ; /* bits 26:26 */
    cs_uint32 phy_2_ln0_resetn_i   :  1 ; /* bits 25:25 */
    cs_uint32 phy_2_cmu_resetn_i   :  1 ; /* bits 24:24 */
    cs_uint32 phy_1_por_n_i        :  1 ; /* bits 23:23 */
    cs_uint32 phy_1_fast_sim_i     :  1 ; /* bits 22:22 */
    cs_uint32 phy_1_ln0_resetn_i   :  1 ; /* bits 21:21 */
    cs_uint32 phy_1_cmu_resetn_i   :  1 ; /* bits 20:20 */
    cs_uint32 phy_0_por_n_i        :  1 ; /* bits 19:19 */
    cs_uint32 phy_0_fast_sim_i     :  1 ; /* bits 18:18 */
    cs_uint32 phy_0_ln0_resetn_i   :  1 ; /* bits 17:17 */
    cs_uint32 phy_0_cmu_resetn_i   :  1 ; /* bits 16:16 */
    cs_uint32 usb_port_reset_1     :  1 ; /* bits 15:15 */
    cs_uint32 usb_port_reset_0     :  1 ; /* bits 14:14 */
    cs_uint32 usb_phy1_por         :  1 ; /* bits 13:13 */
    cs_uint32 usb_phy0_por         :  1 ; /* bits 12:12 */
    cs_uint32 phy_3_pd             :  1 ; /* bits 11:11 */
    cs_uint32 phy_2_pd             :  1 ; /* bits 10:10 */
    cs_uint32 phy_1_pd             :  1 ; /* bits 9:9 */
    cs_uint32 phy_0_pd             :  1 ; /* bits 8:8 */
    cs_uint32 phy_3_refclksel      :  2 ; /* bits 7:6 */
    cs_uint32 phy_2_refclksel      :  2 ; /* bits 5:4 */
    cs_uint32 phy_1_refclksel      :  2 ; /* bits 3:2 */
    cs_uint32 phy_0_refclksel      :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 phy_0_refclksel      :  2 ; /* bits 1:0 */
    cs_uint32 phy_1_refclksel      :  2 ; /* bits 3:2 */
    cs_uint32 phy_2_refclksel      :  2 ; /* bits 5:4 */
    cs_uint32 phy_3_refclksel      :  2 ; /* bits 7:6 */
    cs_uint32 phy_0_pd             :  1 ; /* bits 8:8 */
    cs_uint32 phy_1_pd             :  1 ; /* bits 9:9 */
    cs_uint32 phy_2_pd             :  1 ; /* bits 10:10 */
    cs_uint32 phy_3_pd             :  1 ; /* bits 11:11 */
    cs_uint32 usb_phy0_por         :  1 ; /* bits 12:12 */
    cs_uint32 usb_phy1_por         :  1 ; /* bits 13:13 */
    cs_uint32 usb_port_reset_0     :  1 ; /* bits 14:14 */
    cs_uint32 usb_port_reset_1     :  1 ; /* bits 15:15 */
    cs_uint32 phy_0_cmu_resetn_i   :  1 ; /* bits 16:16 */
    cs_uint32 phy_0_ln0_resetn_i   :  1 ; /* bits 17:17 */
    cs_uint32 phy_0_fast_sim_i     :  1 ; /* bits 18:18 */
    cs_uint32 phy_0_por_n_i        :  1 ; /* bits 19:19 */
    cs_uint32 phy_1_cmu_resetn_i   :  1 ; /* bits 20:20 */
    cs_uint32 phy_1_ln0_resetn_i   :  1 ; /* bits 21:21 */
    cs_uint32 phy_1_fast_sim_i     :  1 ; /* bits 22:22 */
    cs_uint32 phy_1_por_n_i        :  1 ; /* bits 23:23 */
    cs_uint32 phy_2_cmu_resetn_i   :  1 ; /* bits 24:24 */
    cs_uint32 phy_2_ln0_resetn_i   :  1 ; /* bits 25:25 */
    cs_uint32 phy_2_fast_sim_i     :  1 ; /* bits 26:26 */
    cs_uint32 phy_2_por_n_i        :  1 ; /* bits 27:27 */
    cs_uint32 phy_3_cmu_resetn_i   :  1 ; /* bits 28:28 */
    cs_uint32 phy_3_ln0_resetn_i   :  1 ; /* bits 29:29 */
    cs_uint32 phy_3_fast_sim_i     :  1 ; /* bits 30:30 */
    cs_uint32 phy_3_por_n_i        :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_PHY_CONTROL_t;





#define GLOBAL_PIN_MUX                           0xf0000018
#define GLOBAL_PIN_MUX_dft                       0x80000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 flash_mux_sel        :  1 ; /* bits 31:31 */
    cs_uint32 fmro_enable          :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 pmux_frac_clk_en_gpio1_16 :  1 ; /* bits 26:26 */
    cs_uint32 pmux_frac_clk_en_gpio1_11 :  1 ; /* bits 25:25 */
    cs_uint32 pmux_frac_clk_en_gpio1_10 :  1 ; /* bits 24:24 */
    cs_uint32 pmux_s2_gpio2_8      :  1 ; /* bits 23:23 */
    cs_uint32 pmux_s3_gpio2_9      :  1 ; /* bits 22:22 */
    cs_uint32 pmux_s2_gpio2_10     :  1 ; /* bits 21:21 */
    cs_uint32 pmux_s3_gpio2_11     :  1 ; /* bits 20:20 */
    cs_uint32 pmux_s0_gpio2_26     :  1 ; /* bits 19:19 */
    cs_uint32 pmux_s1_gpio2_27     :  1 ; /* bits 18:18 */
    cs_uint32 pmux_s2_gpio2_28     :  1 ; /* bits 17:17 */
    cs_uint32 pmux_s3_gpio2_29     :  1 ; /* bits 16:16 */
    cs_uint32 pmux_s1_gpio2_12     :  1 ; /* bits 15:15 */
    cs_uint32 pmux_s0_gpio2_13     :  1 ; /* bits 14:14 */
    cs_uint32 pmux_s0_gpio0_26     :  1 ; /* bits 13:13 */
    cs_uint32 pmux_s1_gpio0_25     :  1 ; /* bits 12:12 */
    cs_uint32 pmux_s1_gpio0_22     :  1 ; /* bits 11:11 */
    cs_uint32 pmux_s0_gpio0_21     :  1 ; /* bits 10:10 */
    cs_uint32 pwm_sf               :  1 ; /* bits 9:9 */
    cs_uint32 pwm_pf               :  1 ; /* bits 8:8 */
    cs_uint32 pwm_nf               :  1 ; /* bits 7:7 */
    cs_uint32 uart_0_hwfc_gpio_enable :  1 ; /* bits 6:6 */
    cs_uint32 uart_0_hwfc_spi_enable :  1 ; /* bits 5:5 */
    cs_uint32 uart_1_hwfc_enable   :  1 ; /* bits 4:4 */
    cs_uint32 uart_0_hwfc_enable   :  1 ; /* bits 3:3 */
    cs_uint32 arm_trace_enable     :  1 ; /* bits 2:2 */
    cs_uint32 pmux_flash           :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pmux_flash           :  2 ; /* bits 1:0 */
    cs_uint32 arm_trace_enable     :  1 ; /* bits 2:2 */
    cs_uint32 uart_0_hwfc_enable   :  1 ; /* bits 3:3 */
    cs_uint32 uart_1_hwfc_enable   :  1 ; /* bits 4:4 */
    cs_uint32 uart_0_hwfc_spi_enable :  1 ; /* bits 5:5 */
    cs_uint32 uart_0_hwfc_gpio_enable :  1 ; /* bits 6:6 */
    cs_uint32 pwm_nf               :  1 ; /* bits 7:7 */
    cs_uint32 pwm_pf               :  1 ; /* bits 8:8 */
    cs_uint32 pwm_sf               :  1 ; /* bits 9:9 */
    cs_uint32 pmux_s0_gpio0_21     :  1 ; /* bits 10:10 */
    cs_uint32 pmux_s1_gpio0_22     :  1 ; /* bits 11:11 */
    cs_uint32 pmux_s1_gpio0_25     :  1 ; /* bits 12:12 */
    cs_uint32 pmux_s0_gpio0_26     :  1 ; /* bits 13:13 */
    cs_uint32 pmux_s0_gpio2_13     :  1 ; /* bits 14:14 */
    cs_uint32 pmux_s1_gpio2_12     :  1 ; /* bits 15:15 */
    cs_uint32 pmux_s3_gpio2_29     :  1 ; /* bits 16:16 */
    cs_uint32 pmux_s2_gpio2_28     :  1 ; /* bits 17:17 */
    cs_uint32 pmux_s1_gpio2_27     :  1 ; /* bits 18:18 */
    cs_uint32 pmux_s0_gpio2_26     :  1 ; /* bits 19:19 */
    cs_uint32 pmux_s3_gpio2_11     :  1 ; /* bits 20:20 */
    cs_uint32 pmux_s2_gpio2_10     :  1 ; /* bits 21:21 */
    cs_uint32 pmux_s3_gpio2_9      :  1 ; /* bits 22:22 */
    cs_uint32 pmux_s2_gpio2_8      :  1 ; /* bits 23:23 */
    cs_uint32 pmux_frac_clk_en_gpio1_10 :  1 ; /* bits 24:24 */
    cs_uint32 pmux_frac_clk_en_gpio1_11 :  1 ; /* bits 25:25 */
    cs_uint32 pmux_frac_clk_en_gpio1_16 :  1 ; /* bits 26:26 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 fmro_enable          :  1 ; /* bits 30:30 */
    cs_uint32 flash_mux_sel        :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_PIN_MUX_t;





#define GLOBAL_GPIO_MUX_0                        0xf000001c
#define GLOBAL_GPIO_MUX_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 gpio0en              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gpio0en              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GPIO_MUX_0_t;





#define GLOBAL_GPIO_MUX_1                        0xf0000020
#define GLOBAL_GPIO_MUX_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 gpio1en              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gpio1en              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GPIO_MUX_1_t;





#define GLOBAL_GPIO_MUX_2                        0xf0000024
#define GLOBAL_GPIO_MUX_2_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 gpio2en              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gpio2en              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GPIO_MUX_2_t;





#define GLOBAL_GPIO_MUX_3                        0xf0000028
#define GLOBAL_GPIO_MUX_3_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 gpio3en              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gpio3en              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GPIO_MUX_3_t;





#define GLOBAL_GPIO_MUX_4                        0xf000002c
#define GLOBAL_GPIO_MUX_4_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 gpio4en              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gpio4en              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GPIO_MUX_4_t;





#define GLOBAL_DDR_PLL                           0xf0000030
#define GLOBAL_DDR_PLL_dft                       0x00462be9




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 ddr_phy_reset        :  1 ; /* bits 22:22 */
    cs_uint32 p                    :  6 ; /* bits 21:16 */
    cs_uint32 s                    :  3 ; /* bits 15:13 */
    cs_uint32 enable               :  1 ; /* bits 12:12 */
    cs_uint32 vsel                 :  1 ; /* bits 11:11 */
    cs_uint32 m                    : 10 ; /* bits 10:1 */
    cs_uint32 reset                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reset                :  1 ; /* bits 0:0 */
    cs_uint32 m                    : 10 ; /* bits 10:1 */
    cs_uint32 vsel                 :  1 ; /* bits 11:11 */
    cs_uint32 enable               :  1 ; /* bits 12:12 */
    cs_uint32 s                    :  3 ; /* bits 15:13 */
    cs_uint32 p                    :  6 ; /* bits 21:16 */
    cs_uint32 ddr_phy_reset        :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_DDR_PLL_t;





#define GLOBAL_ARM_POWER_CONTROL                 0xf0000034
#define GLOBAL_ARM_POWER_CONTROL_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 eventi               :  1 ; /* bits 1:1 */
    cs_uint32 scupowerdown         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 scupowerdown         :  1 ; /* bits 0:0 */
    cs_uint32 eventi               :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_POWER_CONTROL_t;





#define GLOBAL_ARM_POWER_CONTROL_CPU0            0xf0000038
#define GLOBAL_ARM_POWER_CONTROL_CPU0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 cpuclamp0            :  1 ; /* bits 2:2 */
    cs_uint32 cpupowerdown0        :  1 ; /* bits 1:1 */
    cs_uint32 poweroff             :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 poweroff             :  1 ; /* bits 0:0 */
    cs_uint32 cpupowerdown0        :  1 ; /* bits 1:1 */
    cs_uint32 cpuclamp0            :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_POWER_CONTROL_CPU0_t;





#define GLOBAL_ARM_POWER_CONTROL_CPU1            0xf000003c
#define GLOBAL_ARM_POWER_CONTROL_CPU1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 cpuclamp1            :  1 ; /* bits 2:2 */
    cs_uint32 cpupowerdown1        :  1 ; /* bits 1:1 */
    cs_uint32 poweroff             :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 poweroff             :  1 ; /* bits 0:0 */
    cs_uint32 cpupowerdown1        :  1 ; /* bits 1:1 */
    cs_uint32 cpuclamp1            :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_POWER_CONTROL_CPU1_t;





#define GLOBAL_ARM_STATE                         0xf0000040
#define GLOBAL_ARM_STATE_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 cpu1_wd_req          :  1 ; /* bits 22:22 */
    cs_uint32 cpu0_wd_req          :  1 ; /* bits 21:21 */
    cs_uint32 pll3_switch_state    :  1 ; /* bits 20:20 */
    cs_uint32 pll2_switch_state    :  1 ; /* bits 19:19 */
    cs_uint32 pll1_switch_state    :  1 ; /* bits 18:18 */
    cs_uint32 pll0_switch_state    :  1 ; /* bits 17:17 */
    cs_uint32 pll3_lock            :  1 ; /* bits 16:16 */
    cs_uint32 pll2_lock            :  1 ; /* bits 15:15 */
    cs_uint32 pll1_lock            :  1 ; /* bits 14:14 */
    cs_uint32 pll0_lock            :  1 ; /* bits 13:13 */
    cs_uint32 l2_clkstopped        :  1 ; /* bits 12:12 */
    cs_uint32 l2_idle              :  1 ; /* bits 11:11 */
    cs_uint32 standbywfe1          :  1 ; /* bits 10:10 */
    cs_uint32 standbywfe0          :  1 ; /* bits 9:9 */
    cs_uint32 standbywfi1          :  1 ; /* bits 8:8 */
    cs_uint32 standbywfi0          :  1 ; /* bits 7:7 */
    cs_uint32 pwrctlo1             :  2 ; /* bits 6:5 */
    cs_uint32 pwrctlo0             :  2 ; /* bits 4:3 */
    cs_uint32 snpnamp1             :  1 ; /* bits 2:2 */
    cs_uint32 snpnamp0             :  1 ; /* bits 1:1 */
    cs_uint32 evento               :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 evento               :  1 ; /* bits 0:0 */
    cs_uint32 snpnamp0             :  1 ; /* bits 1:1 */
    cs_uint32 snpnamp1             :  1 ; /* bits 2:2 */
    cs_uint32 pwrctlo0             :  2 ; /* bits 4:3 */
    cs_uint32 pwrctlo1             :  2 ; /* bits 6:5 */
    cs_uint32 standbywfi0          :  1 ; /* bits 7:7 */
    cs_uint32 standbywfi1          :  1 ; /* bits 8:8 */
    cs_uint32 standbywfe0          :  1 ; /* bits 9:9 */
    cs_uint32 standbywfe1          :  1 ; /* bits 10:10 */
    cs_uint32 l2_idle              :  1 ; /* bits 11:11 */
    cs_uint32 l2_clkstopped        :  1 ; /* bits 12:12 */
    cs_uint32 pll0_lock            :  1 ; /* bits 13:13 */
    cs_uint32 pll1_lock            :  1 ; /* bits 14:14 */
    cs_uint32 pll2_lock            :  1 ; /* bits 15:15 */
    cs_uint32 pll3_lock            :  1 ; /* bits 16:16 */
    cs_uint32 pll0_switch_state    :  1 ; /* bits 17:17 */
    cs_uint32 pll1_switch_state    :  1 ; /* bits 18:18 */
    cs_uint32 pll2_switch_state    :  1 ; /* bits 19:19 */
    cs_uint32 pll3_switch_state    :  1 ; /* bits 20:20 */
    cs_uint32 cpu0_wd_req          :  1 ; /* bits 21:21 */
    cs_uint32 cpu1_wd_req          :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_STATE_t;





#define GLOBAL_ARM_CONFIG_A                      0xf0000044
#define GLOBAL_ARM_CONFIG_A_dft                  0x30000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 arm_clk_off          :  1 ; /* bits 31:31 */
    cs_uint32 arm_per_clk_off      :  1 ; /* bits 30:30 */
    cs_uint32 dbgswenable          :  2 ; /* bits 29:28 */
    cs_uint32 filterstart          : 12 ; /* bits 27:16 */
    cs_uint32 filteren             :  1 ; /* bits 15:15 */
    cs_uint32 declockoff1          :  1 ; /* bits 14:14 */
    cs_uint32 declockoff0          :  1 ; /* bits 13:13 */
    cs_uint32 cp15sdisable1        :  1 ; /* bits 12:12 */
    cs_uint32 cp15sdisable0        :  1 ; /* bits 11:11 */
    cs_uint32 cpuclockoff1         :  1 ; /* bits 10:10 */
    cs_uint32 cpuclockoff0         :  1 ; /* bits 9:9 */
    cs_uint32 clusterid            :  4 ; /* bits 8:5 */
    cs_uint32 cfgsdisable          :  1 ; /* bits 4:4 */
    cs_uint32 cfgnmfi1             :  1 ; /* bits 3:3 */
    cs_uint32 cfgnmfi0             :  1 ; /* bits 2:2 */
    cs_uint32 cfgend1              :  1 ; /* bits 1:1 */
    cs_uint32 cfgend0              :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cfgend0              :  1 ; /* bits 0:0 */
    cs_uint32 cfgend1              :  1 ; /* bits 1:1 */
    cs_uint32 cfgnmfi0             :  1 ; /* bits 2:2 */
    cs_uint32 cfgnmfi1             :  1 ; /* bits 3:3 */
    cs_uint32 cfgsdisable          :  1 ; /* bits 4:4 */
    cs_uint32 clusterid            :  4 ; /* bits 8:5 */
    cs_uint32 cpuclockoff0         :  1 ; /* bits 9:9 */
    cs_uint32 cpuclockoff1         :  1 ; /* bits 10:10 */
    cs_uint32 cp15sdisable0        :  1 ; /* bits 11:11 */
    cs_uint32 cp15sdisable1        :  1 ; /* bits 12:12 */
    cs_uint32 declockoff0          :  1 ; /* bits 13:13 */
    cs_uint32 declockoff1          :  1 ; /* bits 14:14 */
    cs_uint32 filteren             :  1 ; /* bits 15:15 */
    cs_uint32 filterstart          : 12 ; /* bits 27:16 */
    cs_uint32 dbgswenable          :  2 ; /* bits 29:28 */
    cs_uint32 arm_per_clk_off      :  1 ; /* bits 30:30 */
    cs_uint32 arm_clk_off          :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_CONFIG_A_t;





#define GLOBAL_ARM_CONFIG_B                      0xf0000048
#define GLOBAL_ARM_CONFIG_B_dft                  0x00004000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 pwrctrli1            :  2 ; /* bits 22:21 */
    cs_uint32 pwrctrli0            :  2 ; /* bits 20:19 */
    cs_uint32 vinithi1             :  1 ; /* bits 18:18 */
    cs_uint32 vinithi0             :  1 ; /* bits 17:17 */
    cs_uint32 teinit1              :  1 ; /* bits 16:16 */
    cs_uint32 teinit0              :  1 ; /* bits 15:15 */
    cs_uint32 maxclklatency        :  3 ; /* bits 14:12 */
    cs_uint32 filterend            : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 filterend            : 12 ; /* bits 11:0 */
    cs_uint32 maxclklatency        :  3 ; /* bits 14:12 */
    cs_uint32 teinit0              :  1 ; /* bits 15:15 */
    cs_uint32 teinit1              :  1 ; /* bits 16:16 */
    cs_uint32 vinithi0             :  1 ; /* bits 17:17 */
    cs_uint32 vinithi1             :  1 ; /* bits 18:18 */
    cs_uint32 pwrctrli0            :  2 ; /* bits 20:19 */
    cs_uint32 pwrctrli1            :  2 ; /* bits 22:21 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_CONFIG_B_t;





#define GLOBAL_ARM_CONFIG_C                      0xf000004c
#define GLOBAL_ARM_CONFIG_C_dft                  0x0007c000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 trace_clk_sel        :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 periphbase           : 19 ; /* bits 18:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 periphbase           : 19 ; /* bits 18:0 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 trace_clk_sel        :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_CONFIG_C_t;





#define GLOBAL_ARM_CONFIG_D                      0xf0000050
#define GLOBAL_ARM_CONFIG_D_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 recirc1_user         :  5 ; /* bits 26:22 */
    cs_uint32 recirc0_user         :  5 ; /* bits 21:17 */
    cs_uint32 periph_user          :  5 ; /* bits 16:12 */
    cs_uint32 recirc1_cache        :  4 ; /* bits 11:8 */
    cs_uint32 recirc0_cache        :  4 ; /* bits 7:4 */
    cs_uint32 periph_cache         :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 periph_cache         :  4 ; /* bits 3:0 */
    cs_uint32 recirc0_cache        :  4 ; /* bits 7:4 */
    cs_uint32 recirc1_cache        :  4 ; /* bits 11:8 */
    cs_uint32 periph_user          :  5 ; /* bits 16:12 */
    cs_uint32 recirc0_user         :  5 ; /* bits 21:17 */
    cs_uint32 recirc1_user         :  5 ; /* bits 26:22 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_CONFIG_D_t;





#define GLOBAL_ARM_CONFIG_E                      0xf0000054
#define GLOBAL_ARM_CONFIG_E_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 qmacp_user           :  5 ; /* bits 8:4 */
    cs_uint32 qmacp_cache          :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 qmacp_cache          :  4 ; /* bits 3:0 */
    cs_uint32 qmacp_user           :  5 ; /* bits 8:4 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_CONFIG_E_t;





#define GLOBAL_L2_CONFIG_A                       0xf0000058
#define GLOBAL_L2_CONFIG_A_dft                   0x1ff80440




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 cfgaddrfiltend       : 12 ; /* bits 30:19 */
    cs_uint32 cfgaddrfiltstart     : 12 ; /* bits 18:7 */
    cs_uint32 cfgaddrfilten        :  1 ; /* bits 6:6 */
    cs_uint32 cacheid              :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cacheid              :  6 ; /* bits 5:0 */
    cs_uint32 cfgaddrfilten        :  1 ; /* bits 6:6 */
    cs_uint32 cfgaddrfiltstart     : 12 ; /* bits 18:7 */
    cs_uint32 cfgaddrfiltend       : 12 ; /* bits 30:19 */
    cs_uint32 rsrvd1               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_L2_CONFIG_A_t;





#define GLOBAL_L2_CONFIG_B                       0xf000005c
#define GLOBAL_L2_CONFIG_B_dft                   0x005ea020




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 waysize              :  3 ; /* bits 23:21 */
    cs_uint32 regfilebase          : 20 ; /* bits 20:1 */
    cs_uint32 cfgbigend            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cfgbigend            :  1 ; /* bits 0:0 */
    cs_uint32 regfilebase          : 20 ; /* bits 20:1 */
    cs_uint32 waysize              :  3 ; /* bits 23:21 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_L2_CONFIG_B_t;





#define GLOBAL_ARM_PARITY_INTERRUPT              0xf0000060
#define GLOBAL_ARM_PARITY_INTERRUPT_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 PARITYFAIL17i        :  1 ; /* bits 17:17 */
    cs_uint32 PARITYFAIL16i        :  1 ; /* bits 16:16 */
    cs_uint32 PARITYFAIL15i        :  1 ; /* bits 15:15 */
    cs_uint32 PARITYFAIL14i        :  1 ; /* bits 14:14 */
    cs_uint32 PARITYFAIL13i        :  1 ; /* bits 13:13 */
    cs_uint32 PARITYFAIL12i        :  1 ; /* bits 12:12 */
    cs_uint32 PARITYFAIL11i        :  1 ; /* bits 11:11 */
    cs_uint32 PARITYFAIL10i        :  1 ; /* bits 10:10 */
    cs_uint32 PARITYFAIL07i        :  1 ; /* bits 9:9 */
    cs_uint32 PARITYFAIL06i        :  1 ; /* bits 8:8 */
    cs_uint32 PARITYFAIL05i        :  1 ; /* bits 7:7 */
    cs_uint32 PARITYFAIL04i        :  1 ; /* bits 6:6 */
    cs_uint32 PARITYFAIL03i        :  1 ; /* bits 5:5 */
    cs_uint32 PARITYFAIL02i        :  1 ; /* bits 4:4 */
    cs_uint32 PARITYFAIL01i        :  1 ; /* bits 3:3 */
    cs_uint32 PARITYFAIL00i        :  1 ; /* bits 2:2 */
    cs_uint32 PARITYSCU1i          :  1 ; /* bits 1:1 */
    cs_uint32 PARITYSCU0i          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 PARITYSCU0i          :  1 ; /* bits 0:0 */
    cs_uint32 PARITYSCU1i          :  1 ; /* bits 1:1 */
    cs_uint32 PARITYFAIL00i        :  1 ; /* bits 2:2 */
    cs_uint32 PARITYFAIL01i        :  1 ; /* bits 3:3 */
    cs_uint32 PARITYFAIL02i        :  1 ; /* bits 4:4 */
    cs_uint32 PARITYFAIL03i        :  1 ; /* bits 5:5 */
    cs_uint32 PARITYFAIL04i        :  1 ; /* bits 6:6 */
    cs_uint32 PARITYFAIL05i        :  1 ; /* bits 7:7 */
    cs_uint32 PARITYFAIL06i        :  1 ; /* bits 8:8 */
    cs_uint32 PARITYFAIL07i        :  1 ; /* bits 9:9 */
    cs_uint32 PARITYFAIL10i        :  1 ; /* bits 10:10 */
    cs_uint32 PARITYFAIL11i        :  1 ; /* bits 11:11 */
    cs_uint32 PARITYFAIL12i        :  1 ; /* bits 12:12 */
    cs_uint32 PARITYFAIL13i        :  1 ; /* bits 13:13 */
    cs_uint32 PARITYFAIL14i        :  1 ; /* bits 14:14 */
    cs_uint32 PARITYFAIL15i        :  1 ; /* bits 15:15 */
    cs_uint32 PARITYFAIL16i        :  1 ; /* bits 16:16 */
    cs_uint32 PARITYFAIL17i        :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_PARITY_INTERRUPT_t;





#define GLOBAL_ARM_PARITY_INTENABLE              0xf0000064
#define GLOBAL_ARM_PARITY_INTENABLE_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 PARITYFAIL17e        :  1 ; /* bits 17:17 */
    cs_uint32 PARITYFAIL16e        :  1 ; /* bits 16:16 */
    cs_uint32 PARITYFAIL15e        :  1 ; /* bits 15:15 */
    cs_uint32 PARITYFAIL14e        :  1 ; /* bits 14:14 */
    cs_uint32 PARITYFAIL13e        :  1 ; /* bits 13:13 */
    cs_uint32 PARITYFAIL12e        :  1 ; /* bits 12:12 */
    cs_uint32 PARITYFAIL11e        :  1 ; /* bits 11:11 */
    cs_uint32 PARITYFAIL10e        :  1 ; /* bits 10:10 */
    cs_uint32 PARITYFAIL07e        :  1 ; /* bits 9:9 */
    cs_uint32 PARITYFAIL06e        :  1 ; /* bits 8:8 */
    cs_uint32 PARITYFAIL05e        :  1 ; /* bits 7:7 */
    cs_uint32 PARITYFAIL04e        :  1 ; /* bits 6:6 */
    cs_uint32 PARITYFAIL03e        :  1 ; /* bits 5:5 */
    cs_uint32 PARITYFAIL02e        :  1 ; /* bits 4:4 */
    cs_uint32 PARITYFAIL01e        :  1 ; /* bits 3:3 */
    cs_uint32 PARITYFAIL00e        :  1 ; /* bits 2:2 */
    cs_uint32 PARITYSCU1e          :  1 ; /* bits 1:1 */
    cs_uint32 PARITYSCU0e          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 PARITYSCU0e          :  1 ; /* bits 0:0 */
    cs_uint32 PARITYSCU1e          :  1 ; /* bits 1:1 */
    cs_uint32 PARITYFAIL00e        :  1 ; /* bits 2:2 */
    cs_uint32 PARITYFAIL01e        :  1 ; /* bits 3:3 */
    cs_uint32 PARITYFAIL02e        :  1 ; /* bits 4:4 */
    cs_uint32 PARITYFAIL03e        :  1 ; /* bits 5:5 */
    cs_uint32 PARITYFAIL04e        :  1 ; /* bits 6:6 */
    cs_uint32 PARITYFAIL05e        :  1 ; /* bits 7:7 */
    cs_uint32 PARITYFAIL06e        :  1 ; /* bits 8:8 */
    cs_uint32 PARITYFAIL07e        :  1 ; /* bits 9:9 */
    cs_uint32 PARITYFAIL10e        :  1 ; /* bits 10:10 */
    cs_uint32 PARITYFAIL11e        :  1 ; /* bits 11:11 */
    cs_uint32 PARITYFAIL12e        :  1 ; /* bits 12:12 */
    cs_uint32 PARITYFAIL13e        :  1 ; /* bits 13:13 */
    cs_uint32 PARITYFAIL14e        :  1 ; /* bits 14:14 */
    cs_uint32 PARITYFAIL15e        :  1 ; /* bits 15:15 */
    cs_uint32 PARITYFAIL16e        :  1 ; /* bits 16:16 */
    cs_uint32 PARITYFAIL17e        :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_PARITY_INTENABLE_t;





#define GLOBAL_SYSTEM_INTERRUPT                  0xf0000068
#define GLOBAL_SYSTEM_INTERRUPT_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 CPU1_WD_REQi         :  1 ; /* bits 5:5 */
    cs_uint32 CPU0_WD_REQi         :  1 ; /* bits 4:4 */
    cs_uint32 PLL3_LOCKi           :  1 ; /* bits 3:3 */
    cs_uint32 PLL2_LOCKi           :  1 ; /* bits 2:2 */
    cs_uint32 PLL1_LOCKi           :  1 ; /* bits 1:1 */
    cs_uint32 PLL0_LOCKi           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 PLL0_LOCKi           :  1 ; /* bits 0:0 */
    cs_uint32 PLL1_LOCKi           :  1 ; /* bits 1:1 */
    cs_uint32 PLL2_LOCKi           :  1 ; /* bits 2:2 */
    cs_uint32 PLL3_LOCKi           :  1 ; /* bits 3:3 */
    cs_uint32 CPU0_WD_REQi         :  1 ; /* bits 4:4 */
    cs_uint32 CPU1_WD_REQi         :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SYSTEM_INTERRUPT_t;





#define GLOBAL_SYSTEM_INTENABLE                  0xf000006c
#define GLOBAL_SYSTEM_INTENABLE_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 CPU1_WD_REQe         :  1 ; /* bits 5:5 */
    cs_uint32 CPU0_WD_REQe         :  1 ; /* bits 4:4 */
    cs_uint32 PLL3_LOCKe           :  1 ; /* bits 3:3 */
    cs_uint32 PLL2_LOCKe           :  1 ; /* bits 2:2 */
    cs_uint32 PLL1_LOCKe           :  1 ; /* bits 1:1 */
    cs_uint32 PLL0_LOCKe           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 PLL0_LOCKe           :  1 ; /* bits 0:0 */
    cs_uint32 PLL1_LOCKe           :  1 ; /* bits 1:1 */
    cs_uint32 PLL2_LOCKe           :  1 ; /* bits 2:2 */
    cs_uint32 PLL3_LOCKe           :  1 ; /* bits 3:3 */
    cs_uint32 CPU0_WD_REQe         :  1 ; /* bits 4:4 */
    cs_uint32 CPU1_WD_REQe         :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SYSTEM_INTENABLE_t;





#define GLOBAL_NETWORK_ENGINE_INTERRUPT_0        0xf0000070
#define GLOBAL_NETWORK_ENGINE_INTERRUPT_0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 25 ;
    cs_uint32 SCHi                 :  1 ; /* bits 6:6 */
    cs_uint32 QMi                  :  1 ; /* bits 5:5 */
    cs_uint32 TMi                  :  1 ; /* bits 4:4 */
    cs_uint32 FEi                  :  1 ; /* bits 3:3 */
    cs_uint32 NIi                  :  1 ; /* bits 2:2 */
    cs_uint32 NI_XRAM_TXi          :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  1 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 NI_XRAM_TXi          :  1 ; /* bits 1:1 */
    cs_uint32 NIi                  :  1 ; /* bits 2:2 */
    cs_uint32 FEi                  :  1 ; /* bits 3:3 */
    cs_uint32 TMi                  :  1 ; /* bits 4:4 */
    cs_uint32 QMi                  :  1 ; /* bits 5:5 */
    cs_uint32 SCHi                 :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t;





#define GLOBAL_NETWORK_ENGINE_INTENABLE_0        0xf0000074
#define GLOBAL_NETWORK_ENGINE_INTENABLE_0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 25 ;
    cs_uint32 SCHe                 :  1 ; /* bits 6:6 */
    cs_uint32 QMe                  :  1 ; /* bits 5:5 */
    cs_uint32 TMe                  :  1 ; /* bits 4:4 */
    cs_uint32 FEe                  :  1 ; /* bits 3:3 */
    cs_uint32 NIe                  :  1 ; /* bits 2:2 */
    cs_uint32 NI_XRAM_TXe          :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  1 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 NI_XRAM_TXe          :  1 ; /* bits 1:1 */
    cs_uint32 NIe                  :  1 ; /* bits 2:2 */
    cs_uint32 FEe                  :  1 ; /* bits 3:3 */
    cs_uint32 TMe                  :  1 ; /* bits 4:4 */
    cs_uint32 QMe                  :  1 ; /* bits 5:5 */
    cs_uint32 SCHe                 :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_NETWORK_ENGINE_INTENABLE_0_t;





#define GLOBAL_NETWORK_ENGINE_INTERRUPT_1        0xf0000078
#define GLOBAL_NETWORK_ENGINE_INTERRUPT_1_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 25 ;
    cs_uint32 SCHi                 :  1 ; /* bits 6:6 */
    cs_uint32 QMi                  :  1 ; /* bits 5:5 */
    cs_uint32 TMi                  :  1 ; /* bits 4:4 */
    cs_uint32 FEi                  :  1 ; /* bits 3:3 */
    cs_uint32 NIi                  :  1 ; /* bits 2:2 */
    cs_uint32 NI_XRAM_TXi          :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  1 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 NI_XRAM_TXi          :  1 ; /* bits 1:1 */
    cs_uint32 NIi                  :  1 ; /* bits 2:2 */
    cs_uint32 FEi                  :  1 ; /* bits 3:3 */
    cs_uint32 TMi                  :  1 ; /* bits 4:4 */
    cs_uint32 QMi                  :  1 ; /* bits 5:5 */
    cs_uint32 SCHi                 :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t;





#define GLOBAL_NETWORK_ENGINE_INTENABLE_1        0xf000007c
#define GLOBAL_NETWORK_ENGINE_INTENABLE_1_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 25 ;
    cs_uint32 SCHe                 :  1 ; /* bits 6:6 */
    cs_uint32 QMe                  :  1 ; /* bits 5:5 */
    cs_uint32 TMe                  :  1 ; /* bits 4:4 */
    cs_uint32 FEe                  :  1 ; /* bits 3:3 */
    cs_uint32 NIe                  :  1 ; /* bits 2:2 */
    cs_uint32 NI_XRAM_TXe          :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  1 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 NI_XRAM_TXe          :  1 ; /* bits 1:1 */
    cs_uint32 NIe                  :  1 ; /* bits 2:2 */
    cs_uint32 FEe                  :  1 ; /* bits 3:3 */
    cs_uint32 TMe                  :  1 ; /* bits 4:4 */
    cs_uint32 QMe                  :  1 ; /* bits 5:5 */
    cs_uint32 SCHe                 :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_NETWORK_ENGINE_INTENABLE_1_t;





#define GLOBAL_JTAG_TAP_CONTROL                  0xf0000080
#define GLOBAL_JTAG_TAP_CONTROL_dft              0x00000001




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 enable_recirc_1      :  1 ; /* bits 2:2 */
    cs_uint32 enable_recirc_0      :  1 ; /* bits 1:1 */
    cs_uint32 enable_arm           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 enable_arm           :  1 ; /* bits 0:0 */
    cs_uint32 enable_recirc_0      :  1 ; /* bits 1:1 */
    cs_uint32 enable_recirc_1      :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_JTAG_TAP_CONTROL_t;





#define GLOBAL_RECIRC_CPU_CTL                    0xf0000084
#define GLOBAL_RECIRC_CPU_CTL_dft                0x00000021




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 rcpu1_OCDHaltOnReset :  1 ; /* bits 9:9 */
    cs_uint32 rcpu1_RunStall       :  1 ; /* bits 8:8 */
    cs_uint32 rcpu1_StatVectorSel  :  1 ; /* bits 7:7 */
    cs_uint32 rcpu1_TDebugInterrupt :  1 ; /* bits 6:6 */
    cs_uint32 rcpu1_clk_en         :  1 ; /* bits 5:5 */
    cs_uint32 rcpu0_OCDHaltOnReset :  1 ; /* bits 4:4 */
    cs_uint32 rcpu0_RunStall       :  1 ; /* bits 3:3 */
    cs_uint32 rcpu0_StatVectorSel  :  1 ; /* bits 2:2 */
    cs_uint32 rcpu0_TDebugInterrupt :  1 ; /* bits 1:1 */
    cs_uint32 rcpu0_clk_en         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rcpu0_clk_en         :  1 ; /* bits 0:0 */
    cs_uint32 rcpu0_TDebugInterrupt :  1 ; /* bits 1:1 */
    cs_uint32 rcpu0_StatVectorSel  :  1 ; /* bits 2:2 */
    cs_uint32 rcpu0_RunStall       :  1 ; /* bits 3:3 */
    cs_uint32 rcpu0_OCDHaltOnReset :  1 ; /* bits 4:4 */
    cs_uint32 rcpu1_clk_en         :  1 ; /* bits 5:5 */
    cs_uint32 rcpu1_TDebugInterrupt :  1 ; /* bits 6:6 */
    cs_uint32 rcpu1_StatVectorSel  :  1 ; /* bits 7:7 */
    cs_uint32 rcpu1_RunStall       :  1 ; /* bits 8:8 */
    cs_uint32 rcpu1_OCDHaltOnReset :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_RECIRC_CPU_CTL_t;





#define GLOBAL_RECIRC_CPU_STAT                   0xf0000088
#define GLOBAL_RECIRC_CPU_STAT_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rcpu1_PWaitMode      :  1 ; /* bits 5:5 */
    cs_uint32 rcpu1_XOCDMode       :  1 ; /* bits 4:4 */
    cs_uint32 rcpu1_XOCDModePulse  :  1 ; /* bits 3:3 */
    cs_uint32 rcpu0_PWaitMode      :  1 ; /* bits 2:2 */
    cs_uint32 rcpu0_XOCDMode       :  1 ; /* bits 1:1 */
    cs_uint32 rcpu0_XOCDModePulse  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rcpu0_XOCDModePulse  :  1 ; /* bits 0:0 */
    cs_uint32 rcpu0_XOCDMode       :  1 ; /* bits 1:1 */
    cs_uint32 rcpu0_PWaitMode      :  1 ; /* bits 2:2 */
    cs_uint32 rcpu1_XOCDModePulse  :  1 ; /* bits 3:3 */
    cs_uint32 rcpu1_XOCDMode       :  1 ; /* bits 4:4 */
    cs_uint32 rcpu1_PWaitMode      :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_RECIRC_CPU_STAT_t;





#define GLOBAL_GLOBAL_USB_REG0                   0xf000008c
#define GLOBAL_GLOBAL_USB_REG0_dft               0x30104100




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 software_override_sysopmode_en :  1 ; /* bits 31:31 */
    cs_uint32 software_override_sysopmode :  1 ; /* bits 30:30 */
    cs_uint32 Hst_ctrl_perport_reset :  2 ; /* bits 29:28 */
    cs_uint32 Hst_ss_ena_incr16    :  1 ; /* bits 27:27 */
    cs_uint32 Hst_ss_ena_incr8     :  1 ; /* bits 26:26 */
    cs_uint32 Hst_ss_ena_incr4     :  1 ; /* bits 25:25 */
    cs_uint32 Hst_ss_ena_incrx_align :  1 ; /* bits 24:24 */
    cs_uint32 Hst_ohci_cntsel_n    :  1 ; /* bits 23:23 */
    cs_uint32 Hst_ss_simulation_mode_i :  1 ; /* bits 22:22 */
    cs_uint32 Hst_ss_autoppd_on_overcur_en :  1 ; /* bits 21:21 */
    cs_uint32 Hst_ss_fladj_val_host :  6 ; /* bits 20:15 */
    cs_uint32 Hst_ss_fladj_val_port0 :  6 ; /* bits 14:9 */
    cs_uint32 Hst_ss_fladj_val_port1 :  6 ; /* bits 8:3 */
    cs_uint32 Hst_sys_interrupt    :  1 ; /* bits 2:2 */
    cs_uint32 Hst_app_start_clk    :  1 ; /* bits 1:1 */
    cs_uint32 Hst_ohci_susp_lgcy   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 Hst_ohci_susp_lgcy   :  1 ; /* bits 0:0 */
    cs_uint32 Hst_app_start_clk    :  1 ; /* bits 1:1 */
    cs_uint32 Hst_sys_interrupt    :  1 ; /* bits 2:2 */
    cs_uint32 Hst_ss_fladj_val_port1 :  6 ; /* bits 8:3 */
    cs_uint32 Hst_ss_fladj_val_port0 :  6 ; /* bits 14:9 */
    cs_uint32 Hst_ss_fladj_val_host :  6 ; /* bits 20:15 */
    cs_uint32 Hst_ss_autoppd_on_overcur_en :  1 ; /* bits 21:21 */
    cs_uint32 Hst_ss_simulation_mode_i :  1 ; /* bits 22:22 */
    cs_uint32 Hst_ohci_cntsel_n    :  1 ; /* bits 23:23 */
    cs_uint32 Hst_ss_ena_incrx_align :  1 ; /* bits 24:24 */
    cs_uint32 Hst_ss_ena_incr4     :  1 ; /* bits 25:25 */
    cs_uint32 Hst_ss_ena_incr8     :  1 ; /* bits 26:26 */
    cs_uint32 Hst_ss_ena_incr16    :  1 ; /* bits 27:27 */
    cs_uint32 Hst_ctrl_perport_reset :  2 ; /* bits 29:28 */
    cs_uint32 software_override_sysopmode :  1 ; /* bits 30:30 */
    cs_uint32 software_override_sysopmode_en :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USB_REG0_t;





#define GLOBAL_GLOBAL_USB_REG1                   0xf0000090
#define GLOBAL_GLOBAL_USB_REG1_dft               0x20000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 Dev_ss_scaledown_mode :  2 ; /* bits 31:30 */
    cs_uint32 usb_por              :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 29 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 usb_por              :  1 ; /* bits 29:29 */
    cs_uint32 Dev_ss_scaledown_mode :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USB_REG1_t;





#define GLOBAL_USB_GLOBAL_REG0                   0xf0000094
#define GLOBAL_USB_GLOBAL_REG0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 Usb_sys_Otg_miniAB   :  1 ; /* bits 31:31 */
    cs_uint32 Hst_ehci_prt_pwr_port0 :  1 ; /* bits 30:30 */
    cs_uint32 Hst_ehci_prt_pwr_port1 :  1 ; /* bits 29:29 */
    cs_uint32 Hst_ehci_xfer_cnt    : 11 ; /* bits 28:18 */
    cs_uint32 Hst_ehci_xfer_prdc   :  1 ; /* bits 17:17 */
    cs_uint32 Hst_ehci_bufacc      :  1 ; /* bits 16:16 */
    cs_uint32 Hst_ehci_usbstatus   :  6 ; /* bits 15:10 */
    cs_uint32 Hst_ehci_lpsmc_status :  4 ; /* bits 9:6 */
    cs_uint32 Hst_ohci_global_suspend :  1 ; /* bits 5:5 */
    cs_uint32 Hst_ohci_rwe         :  1 ; /* bits 4:4 */
    cs_uint32 Hst_ohci_rmtwkp      :  1 ; /* bits 3:3 */
    cs_uint32 Hst_ohci_drwe        :  1 ; /* bits 2:2 */
    cs_uint32 Hst_ohci_ccs         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 Hst_ohci_ccs         :  2 ; /* bits 1:0 */
    cs_uint32 Hst_ohci_drwe        :  1 ; /* bits 2:2 */
    cs_uint32 Hst_ohci_rmtwkp      :  1 ; /* bits 3:3 */
    cs_uint32 Hst_ohci_rwe         :  1 ; /* bits 4:4 */
    cs_uint32 Hst_ohci_global_suspend :  1 ; /* bits 5:5 */
    cs_uint32 Hst_ehci_lpsmc_status :  4 ; /* bits 9:6 */
    cs_uint32 Hst_ehci_usbstatus   :  6 ; /* bits 15:10 */
    cs_uint32 Hst_ehci_bufacc      :  1 ; /* bits 16:16 */
    cs_uint32 Hst_ehci_xfer_prdc   :  1 ; /* bits 17:17 */
    cs_uint32 Hst_ehci_xfer_cnt    : 11 ; /* bits 28:18 */
    cs_uint32 Hst_ehci_prt_pwr_port1 :  1 ; /* bits 29:29 */
    cs_uint32 Hst_ehci_prt_pwr_port0 :  1 ; /* bits 30:30 */
    cs_uint32 Usb_sys_Otg_miniAB   :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_USB_GLOBAL_REG0_t;





#define GLOBAL_USB_GLOBAL_REG1                   0xf0000098
#define GLOBAL_USB_GLOBAL_REG1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 Hst_ohci_sof         :  1 ; /* bits 31:31 */
    cs_uint32 Hst_ohci_bufacc      :  1 ; /* bits 30:30 */
    cs_uint32 Dev_internal_probe   : 12 ; /* bits 29:18 */
    cs_uint32 Dev_internal_probe_p : 18 ; /* bits 17:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 Dev_internal_probe_p : 18 ; /* bits 17:0 */
    cs_uint32 Dev_internal_probe   : 12 ; /* bits 29:18 */
    cs_uint32 Hst_ohci_bufacc      :  1 ; /* bits 30:30 */
    cs_uint32 Hst_ohci_sof         :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_USB_GLOBAL_REG1_t;





#define GLOBAL_USB_GLOBAL_REG2                   0xf000009c
#define GLOBAL_USB_GLOBAL_REG2_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 Dev_internal_probe_p : 17 ; /* bits 31:15 */
    cs_uint32 Dev_sof_toggle       :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 14 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 Dev_sof_toggle       :  1 ; /* bits 14:14 */
    cs_uint32 Dev_internal_probe_p : 17 ; /* bits 31:15 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_USB_GLOBAL_REG2_t;





#define GLOBAL_GLOBAL_USBPHY0_REG0               0xf00000a0
#define GLOBAL_GLOBAL_USBPHY0_REG0_dft           0x91991cc0




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 COMPDISTUN           :  3 ; /* bits 31:29 */
    cs_uint32 OTGTUNE              :  3 ; /* bits 28:26 */
    cs_uint32 SQRXTUNE             :  3 ; /* bits 25:23 */
    cs_uint32 TXFSLSTUNE           :  4 ; /* bits 22:19 */
    cs_uint32 TXPREEMPHASISTUNE    :  1 ; /* bits 18:18 */
    cs_uint32 TXRISETUNE           :  1 ; /* bits 17:17 */
    cs_uint32 TXVREFTUNE           :  4 ; /* bits 16:13 */
    cs_uint32 TXHSXVTUNE           :  2 ; /* bits 12:11 */
    cs_uint32 REFCLKSEL            :  2 ; /* bits 10:9 */
    cs_uint32 REFCLKDIV            :  2 ; /* bits 8:7 */
    cs_uint32 COMMONONN            :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  6 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 COMMONONN            :  1 ; /* bits 6:6 */
    cs_uint32 REFCLKDIV            :  2 ; /* bits 8:7 */
    cs_uint32 REFCLKSEL            :  2 ; /* bits 10:9 */
    cs_uint32 TXHSXVTUNE           :  2 ; /* bits 12:11 */
    cs_uint32 TXVREFTUNE           :  4 ; /* bits 16:13 */
    cs_uint32 TXRISETUNE           :  1 ; /* bits 17:17 */
    cs_uint32 TXPREEMPHASISTUNE    :  1 ; /* bits 18:18 */
    cs_uint32 TXFSLSTUNE           :  4 ; /* bits 22:19 */
    cs_uint32 SQRXTUNE             :  3 ; /* bits 25:23 */
    cs_uint32 OTGTUNE              :  3 ; /* bits 28:26 */
    cs_uint32 COMPDISTUN           :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USBPHY0_REG0_t;





#define GLOBAL_GLOBAL_USBPHY1_REG0               0xf00000a4
#define GLOBAL_GLOBAL_USBPHY1_REG0_dft           0x91991cc0




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 COMPDISTUN           :  3 ; /* bits 31:29 */
    cs_uint32 OTGTUNE              :  3 ; /* bits 28:26 */
    cs_uint32 SQRXTUNE             :  3 ; /* bits 25:23 */
    cs_uint32 TXFSLSTUNE           :  4 ; /* bits 22:19 */
    cs_uint32 TXPREEMPHASISTUNE    :  1 ; /* bits 18:18 */
    cs_uint32 TXRISETUNE           :  1 ; /* bits 17:17 */
    cs_uint32 TXVREFTUNE           :  4 ; /* bits 16:13 */
    cs_uint32 TXHSXVTUNE           :  2 ; /* bits 12:11 */
    cs_uint32 REFCLKSEL            :  2 ; /* bits 10:9 */
    cs_uint32 REFCLKDIV            :  2 ; /* bits 8:7 */
    cs_uint32 COMMONONN            :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  6 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 COMMONONN            :  1 ; /* bits 6:6 */
    cs_uint32 REFCLKDIV            :  2 ; /* bits 8:7 */
    cs_uint32 REFCLKSEL            :  2 ; /* bits 10:9 */
    cs_uint32 TXHSXVTUNE           :  2 ; /* bits 12:11 */
    cs_uint32 TXVREFTUNE           :  4 ; /* bits 16:13 */
    cs_uint32 TXRISETUNE           :  1 ; /* bits 17:17 */
    cs_uint32 TXPREEMPHASISTUNE    :  1 ; /* bits 18:18 */
    cs_uint32 TXFSLSTUNE           :  4 ; /* bits 22:19 */
    cs_uint32 SQRXTUNE             :  3 ; /* bits 25:23 */
    cs_uint32 OTGTUNE              :  3 ; /* bits 28:26 */
    cs_uint32 COMPDISTUN           :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USBPHY1_REG0_t;





#define GLOBAL_GLOBAL_USBPHY0_REG1               0xf00000a8
#define GLOBAL_GLOBAL_USBPHY0_REG1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 TESTCLK_PRT0         :  1 ; /* bits 16:16 */
    cs_uint32 TESTDATAIN_PRT0      :  8 ; /* bits 15:8 */
    cs_uint32 TESTADDR_PRT0        :  4 ; /* bits 7:4 */
    cs_uint32 TESTDATAOUTSEL_PRT0  :  1 ; /* bits 3:3 */
    cs_uint32 SIDDQ_PRT0           :  1 ; /* bits 2:2 */
    cs_uint32 VATESTENB_PRT0       :  1 ; /* bits 1:1 */
    cs_uint32 LOOPBACKENB_PRT0     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 LOOPBACKENB_PRT0     :  1 ; /* bits 0:0 */
    cs_uint32 VATESTENB_PRT0       :  1 ; /* bits 1:1 */
    cs_uint32 SIDDQ_PRT0           :  1 ; /* bits 2:2 */
    cs_uint32 TESTDATAOUTSEL_PRT0  :  1 ; /* bits 3:3 */
    cs_uint32 TESTADDR_PRT0        :  4 ; /* bits 7:4 */
    cs_uint32 TESTDATAIN_PRT0      :  8 ; /* bits 15:8 */
    cs_uint32 TESTCLK_PRT0         :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 15 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USBPHY0_REG1_t;





#define GLOBAL_GLOBAL_USBPHY1_REG1               0xf00000ac
#define GLOBAL_GLOBAL_USBPHY1_REG1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 TESTCLK_PRT1         :  1 ; /* bits 16:16 */
    cs_uint32 TESTDATAIN_PRT1      :  8 ; /* bits 15:8 */
    cs_uint32 TESTADDR_PRT1        :  4 ; /* bits 7:4 */
    cs_uint32 TESTDATAOUTSEL_PRT1  :  1 ; /* bits 3:3 */
    cs_uint32 SIDDQ_PRT1           :  1 ; /* bits 2:2 */
    cs_uint32 VATESTENB_PRT1       :  1 ; /* bits 1:1 */
    cs_uint32 LOOPBACKENB_PRT1     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 LOOPBACKENB_PRT1     :  1 ; /* bits 0:0 */
    cs_uint32 VATESTENB_PRT1       :  1 ; /* bits 1:1 */
    cs_uint32 SIDDQ_PRT1           :  1 ; /* bits 2:2 */
    cs_uint32 TESTDATAOUTSEL_PRT1  :  1 ; /* bits 3:3 */
    cs_uint32 TESTADDR_PRT1        :  4 ; /* bits 7:4 */
    cs_uint32 TESTDATAIN_PRT1      :  8 ; /* bits 15:8 */
    cs_uint32 TESTCLK_PRT1         :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 15 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_GLOBAL_USBPHY1_REG1_t;





#define GLOBAL_USBPHY_GLOBAL                     0xf00000b0
#define GLOBAL_USBPHY_GLOBAL_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 TESTDATAOUT_PRT0     :  4 ; /* bits 7:4 */
    cs_uint32 TESTDATAOUT_PRT1     :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 TESTDATAOUT_PRT1     :  4 ; /* bits 3:0 */
    cs_uint32 TESTDATAOUT_PRT0     :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_USBPHY_GLOBAL_t;





#define GLOBAL_IO_DRIVE_STRENGTH                 0xf00000b4
#define GLOBAL_IO_DRIVE_STRENGTH_dft             0x00000aaa




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 misc_ds              :  2 ; /* bits 11:10 */
    cs_uint32 lcd_ds               :  2 ; /* bits 9:8 */
    cs_uint32 gpio2_ds             :  2 ; /* bits 7:6 */
    cs_uint32 gpio1_ds             :  2 ; /* bits 5:4 */
    cs_uint32 gpio0_ds             :  2 ; /* bits 3:2 */
    cs_uint32 gmac_ds              :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 gmac_ds              :  2 ; /* bits 1:0 */
    cs_uint32 gpio0_ds             :  2 ; /* bits 3:2 */
    cs_uint32 gpio1_ds             :  2 ; /* bits 5:4 */
    cs_uint32 gpio2_ds             :  2 ; /* bits 7:6 */
    cs_uint32 lcd_ds               :  2 ; /* bits 9:8 */
    cs_uint32 misc_ds              :  2 ; /* bits 11:10 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_IO_DRIVE_STRENGTH_t;





#define GLOBAL_SOFTWARE                          0xf00000b8
#define GLOBAL_SOFTWARE_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 val                  : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 val                  : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SOFTWARE_t;





#define GLOBAL_SOFTWARE2                         0xf00000bc
#define GLOBAL_SOFTWARE2_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 val                  : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 val                  : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SOFTWARE2_t;





#define GLOBAL_SCRATCH                           0xf00000c0
#define GLOBAL_SCRATCH_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 scratch              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 scratch              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SCRATCH_t;





#define GLOBAL_FMRO                              0xf00000c4
#define GLOBAL_FMRO_dft                          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 blk_sel              :  4 ; /* bits 23:20 */
    cs_uint32 clk_sel              :  4 ; /* bits 19:16 */
    cs_uint32 fmro_sel             : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 fmro_sel             : 16 ; /* bits 15:0 */
    cs_uint32 clk_sel              :  4 ; /* bits 19:16 */
    cs_uint32 blk_sel              :  4 ; /* bits 23:20 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_FMRO_t;





#define GLOBAL_SPEED_OVERRIDE                    0xf00000c8
#define GLOBAL_SPEED_OVERRIDE_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ov_enable            : 29 ; /* bits 31:3 */
    cs_uint32 speed                :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 speed                :  3 ; /* bits 2:0 */
    cs_uint32 ov_enable            : 29 ; /* bits 31:3 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SPEED_OVERRIDE_t;





#define GLOBAL_SECURE_MODE_OVERRIDE              0xf00000cc
#define GLOBAL_SECURE_MODE_OVERRIDE_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ov_enable            : 31 ; /* bits 31:1 */
    cs_uint32 secure_mode          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 secure_mode          :  1 ; /* bits 0:0 */
    cs_uint32 ov_enable            : 31 ; /* bits 31:1 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_SECURE_MODE_OVERRIDE_t;





#define GLOBAL_ARM_DEBUG                         0xf00000d0
#define GLOBAL_ARM_DEBUG_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 l2_spniden           :  1 ; /* bits 8:8 */
    cs_uint32 cpu1_dbgen           :  1 ; /* bits 7:7 */
    cs_uint32 cpu0_dbgen           :  1 ; /* bits 6:6 */
    cs_uint32 cpu1_niden           :  1 ; /* bits 5:5 */
    cs_uint32 cpu0_niden           :  1 ; /* bits 4:4 */
    cs_uint32 cpu1_spinden         :  1 ; /* bits 3:3 */
    cs_uint32 cpu0_spinden         :  1 ; /* bits 2:2 */
    cs_uint32 cpu1_spiden          :  1 ; /* bits 1:1 */
    cs_uint32 cpu0_spiden          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu0_spiden          :  1 ; /* bits 0:0 */
    cs_uint32 cpu1_spiden          :  1 ; /* bits 1:1 */
    cs_uint32 cpu0_spinden         :  1 ; /* bits 2:2 */
    cs_uint32 cpu1_spinden         :  1 ; /* bits 3:3 */
    cs_uint32 cpu0_niden           :  1 ; /* bits 4:4 */
    cs_uint32 cpu1_niden           :  1 ; /* bits 5:5 */
    cs_uint32 cpu0_dbgen           :  1 ; /* bits 6:6 */
    cs_uint32 cpu1_dbgen           :  1 ; /* bits 7:7 */
    cs_uint32 l2_spniden           :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_DEBUG_t;





#define GLOBAL_ARM_DEBUG_ENABLE_A                0xf00000d4
#define GLOBAL_ARM_DEBUG_ENABLE_A_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 code                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 code                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_DEBUG_ENABLE_A_t;





#define GLOBAL_ARM_DEBUG_ENABLE_B                0xf00000d8
#define GLOBAL_ARM_DEBUG_ENABLE_B_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 code                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 code                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_ARM_DEBUG_ENABLE_B_t;





#define GLOBAL_L2_EMA                            0xf00000dc
#define GLOBAL_L2_EMA_dft                        0x00000002




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 ema                  :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ema                  :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_L2_EMA_t;





#define GLOBAL_AXI_MUX_TEST                      0xf00000e0
#define GLOBAL_AXI_MUX_TEST_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 test_en              :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 test_en              :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_AXI_MUX_TEST_t;





#define GLOBAL_AXI_MUX_TEST_STATUS               0xf00000e4
#define GLOBAL_AXI_MUX_TEST_STATUS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 result               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 result               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_AXI_MUX_TEST_STATUS_t;





#define GLOBAL_FPGAC_ID                          0xf00000e8
#define GLOBAL_FPGAC_ID_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 id                   : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 id                   : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_FPGAC_ID_t;





#define GLOBAL_EAXICTL0                          0xf00000ec
#define GLOBAL_EAXICTL0_dft                      0x14a00241




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rx2tx                :  1 ; /* bits 31:31 */
    cs_uint32 tx2rx                :  1 ; /* bits 30:30 */
    cs_uint32 txclkdiv             :  4 ; /* bits 29:26 */
    cs_uint32 txclkdivlo           :  4 ; /* bits 25:22 */
    cs_uint32 softreset            :  1 ; /* bits 21:21 */
    cs_uint32 enable               :  1 ; /* bits 20:20 */
    cs_uint32 slavecam             :  1 ; /* bits 19:19 */
    cs_uint32 mastercam            :  1 ; /* bits 18:18 */
    cs_uint32 rxthresh             :  6 ; /* bits 17:12 */
    cs_uint32 chmingap             :  3 ; /* bits 11:9 */
    cs_uint32 mingap               :  3 ; /* bits 8:6 */
    cs_uint32 txqos                :  5 ; /* bits 5:1 */
    cs_uint32 invert               :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 invert               :  1 ; /* bits 0:0 */
    cs_uint32 txqos                :  5 ; /* bits 5:1 */
    cs_uint32 mingap               :  3 ; /* bits 8:6 */
    cs_uint32 chmingap             :  3 ; /* bits 11:9 */
    cs_uint32 rxthresh             :  6 ; /* bits 17:12 */
    cs_uint32 mastercam            :  1 ; /* bits 18:18 */
    cs_uint32 slavecam             :  1 ; /* bits 19:19 */
    cs_uint32 enable               :  1 ; /* bits 20:20 */
    cs_uint32 softreset            :  1 ; /* bits 21:21 */
    cs_uint32 txclkdivlo           :  4 ; /* bits 25:22 */
    cs_uint32 txclkdiv             :  4 ; /* bits 29:26 */
    cs_uint32 tx2rx                :  1 ; /* bits 30:30 */
    cs_uint32 rx2tx                :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_EAXICTL0_t;





#define GLOBAL_EAXI_REMAP0                       0xf00000f0
#define GLOBAL_EAXI_REMAP0_STRIDE                4
#define GLOBAL_EAXI_REMAP0_COUNT                 16
#define GLOBAL_EAXI_REMAP0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 value                : 16 ; /* bits 31:16 */
    cs_uint32 range                : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 range                : 16 ; /* bits 15:0 */
    cs_uint32 value                : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} GLOBAL_EAXI_REMAP0_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */

typedef struct {
  GLOBAL_JTAG_ID_t                         JTAG_ID;                       /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  GLOBAL_BLOCK_RESET_t                     BLOCK_RESET;                   /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  GLOBAL_ARM_RESET_t                       ARM_RESET;                     /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  GLOBAL_STRAP_t                           STRAP;                         /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  GLOBAL_GLOBAL_CONFIG_t                   GLOBAL_CONFIG;                 /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  GLOBAL_PHY_CONTROL_t                     PHY_CONTROL;                   /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  GLOBAL_PIN_MUX_t                         PIN_MUX;                       /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  GLOBAL_GPIO_MUX_0_t                      GPIO_MUX_0;                    /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  GLOBAL_GPIO_MUX_1_t                      GPIO_MUX_1;                    /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  GLOBAL_GPIO_MUX_2_t                      GPIO_MUX_2;                    /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  GLOBAL_GPIO_MUX_3_t                      GPIO_MUX_3;                    /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  GLOBAL_GPIO_MUX_4_t                      GPIO_MUX_4;                    /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  GLOBAL_DDR_PLL_t                         DDR_PLL;                       /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  GLOBAL_ARM_POWER_CONTROL_t               ARM_POWER_CONTROL;             /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  GLOBAL_ARM_POWER_CONTROL_CPU0_t          ARM_POWER_CONTROL_CPU0;        /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  GLOBAL_ARM_POWER_CONTROL_CPU1_t          ARM_POWER_CONTROL_CPU1;        /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  GLOBAL_ARM_STATE_t                       ARM_STATE;                     /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  GLOBAL_ARM_CONFIG_A_t                    ARM_CONFIG_A;                  /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  GLOBAL_ARM_CONFIG_B_t                    ARM_CONFIG_B;                  /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  GLOBAL_ARM_CONFIG_C_t                    ARM_CONFIG_C;                  /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  GLOBAL_ARM_CONFIG_D_t                    ARM_CONFIG_D;                  /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  GLOBAL_ARM_CONFIG_E_t                    ARM_CONFIG_E;                  /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  GLOBAL_L2_CONFIG_A_t                     L2_CONFIG_A;                   /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  GLOBAL_L2_CONFIG_B_t                     L2_CONFIG_B;                   /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  GLOBAL_ARM_PARITY_INTERRUPT_t            ARM_PARITY_INTERRUPT;          /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  GLOBAL_ARM_PARITY_INTENABLE_t            ARM_PARITY_INTENABLE;          /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  GLOBAL_SYSTEM_INTERRUPT_t                SYSTEM_INTERRUPT;              /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  GLOBAL_SYSTEM_INTENABLE_t                SYSTEM_INTENABLE;              /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t      NETWORK_ENGINE_INTERRUPT_0;    /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  GLOBAL_NETWORK_ENGINE_INTENABLE_0_t      NETWORK_ENGINE_INTENABLE_0;    /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t      NETWORK_ENGINE_INTERRUPT_1;    /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  GLOBAL_NETWORK_ENGINE_INTENABLE_1_t      NETWORK_ENGINE_INTENABLE_1;    /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  GLOBAL_JTAG_TAP_CONTROL_t                JTAG_TAP_CONTROL;              /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  GLOBAL_RECIRC_CPU_CTL_t                  RECIRC_CPU_CTL;                /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  GLOBAL_RECIRC_CPU_STAT_t                 RECIRC_CPU_STAT;               /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  GLOBAL_GLOBAL_USB_REG0_t                 GLOBAL_USB_REG0;               /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  GLOBAL_GLOBAL_USB_REG1_t                 GLOBAL_USB_REG1;               /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  GLOBAL_USB_GLOBAL_REG0_t                 USB_GLOBAL_REG0;               /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  GLOBAL_USB_GLOBAL_REG1_t                 USB_GLOBAL_REG1;               /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  GLOBAL_USB_GLOBAL_REG2_t                 USB_GLOBAL_REG2;               /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  GLOBAL_GLOBAL_USBPHY0_REG0_t             GLOBAL_USBPHY0_REG0;           /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  GLOBAL_GLOBAL_USBPHY1_REG0_t             GLOBAL_USBPHY1_REG0;           /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  GLOBAL_GLOBAL_USBPHY0_REG1_t             GLOBAL_USBPHY0_REG1;           /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  GLOBAL_GLOBAL_USBPHY1_REG1_t             GLOBAL_USBPHY1_REG1;           /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  GLOBAL_USBPHY_GLOBAL_t                   USBPHY_GLOBAL;                 /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  GLOBAL_IO_DRIVE_STRENGTH_t               IO_DRIVE_STRENGTH;             /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  GLOBAL_SOFTWARE_t                        SOFTWARE;                      /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  GLOBAL_SOFTWARE2_t                       SOFTWARE2;                     /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  GLOBAL_SCRATCH_t                         SCRATCH;                       /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  GLOBAL_FMRO_t                            FMRO;                          /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  GLOBAL_SPEED_OVERRIDE_t                  SPEED_OVERRIDE;                /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  GLOBAL_SECURE_MODE_OVERRIDE_t            SECURE_MODE_OVERRIDE;          /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  GLOBAL_ARM_DEBUG_t                       ARM_DEBUG;                     /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  GLOBAL_ARM_DEBUG_ENABLE_A_t              ARM_DEBUG_ENABLE_A;            /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  GLOBAL_ARM_DEBUG_ENABLE_B_t              ARM_DEBUG_ENABLE_B;            /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd55[3];                   
  GLOBAL_L2_EMA_t                          L2_EMA;                        /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd56[3];                   
  GLOBAL_AXI_MUX_TEST_t                    AXI_MUX_TEST;                  /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd57[3];                   
  GLOBAL_AXI_MUX_TEST_STATUS_t             AXI_MUX_TEST_STATUS;           /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd58[3];                   
  GLOBAL_FPGAC_ID_t                        FPGAC_ID;                      /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd59[3];                   
  GLOBAL_EAXICTL0_t                        EAXICTL0;                      /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd60[3];                   
  GLOBAL_EAXI_REMAP0_t                     EAXI_REMAP0;                   /* addr: 0x000000f0 */ 
} GLB_t;

  

/*
 * NI_TOP
 */
  



#define NI_TOP_NI_INTF_RST_CONFIG                0xf0010000
#define NI_TOP_NI_INTF_RST_CONFIG_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 intf_rst_ge2         :  1 ; /* bits 2:2 */
    cs_uint32 intf_rst_ge1         :  1 ; /* bits 1:1 */
    cs_uint32 intf_rst_ge0         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 intf_rst_ge0         :  1 ; /* bits 0:0 */
    cs_uint32 intf_rst_ge1         :  1 ; /* bits 1:1 */
    cs_uint32 intf_rst_ge2         :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INTF_RST_CONFIG_t;





#define NI_TOP_NI_ETH_INT_CONFIG1                0xf0010004
#define NI_TOP_NI_ETH_INT_CONFIG1_dft            0x00424242




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd4               :  8 ;
    cs_uint32 inv_clk_out_ge2      :  1 ; /* bits 23:23 */
    cs_uint32 tx_use_gefifo_ge2    :  1 ; /* bits 22:22 */
    cs_uint32 rmii_clksrc_ge2      :  1 ; /* bits 21:21 */
    cs_uint32 phy_mode_ge2         :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 int_cfg_ge2          :  3 ; /* bits 18:16 */
    cs_uint32 inv_clk_out_ge1      :  1 ; /* bits 15:15 */
    cs_uint32 tx_use_gefifo_ge1    :  1 ; /* bits 14:14 */
    cs_uint32 rmii_clksrc_ge1      :  1 ; /* bits 13:13 */
    cs_uint32 phy_mode_ge1         :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 int_cfg_ge1          :  3 ; /* bits 10:8 */
    cs_uint32 inv_clk_out_ge0      :  1 ; /* bits 7:7 */
    cs_uint32 tx_use_gefifo_ge0    :  1 ; /* bits 6:6 */
    cs_uint32 rmii_clksrc_ge0      :  1 ; /* bits 5:5 */
    cs_uint32 phy_mode_ge0         :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 int_cfg_ge0          :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_cfg_ge0          :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 phy_mode_ge0         :  1 ; /* bits 4:4 */
    cs_uint32 rmii_clksrc_ge0      :  1 ; /* bits 5:5 */
    cs_uint32 tx_use_gefifo_ge0    :  1 ; /* bits 6:6 */
    cs_uint32 inv_clk_out_ge0      :  1 ; /* bits 7:7 */
    cs_uint32 int_cfg_ge1          :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 phy_mode_ge1         :  1 ; /* bits 12:12 */
    cs_uint32 rmii_clksrc_ge1      :  1 ; /* bits 13:13 */
    cs_uint32 tx_use_gefifo_ge1    :  1 ; /* bits 14:14 */
    cs_uint32 inv_clk_out_ge1      :  1 ; /* bits 15:15 */
    cs_uint32 int_cfg_ge2          :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 phy_mode_ge2         :  1 ; /* bits 20:20 */
    cs_uint32 rmii_clksrc_ge2      :  1 ; /* bits 21:21 */
    cs_uint32 tx_use_gefifo_ge2    :  1 ; /* bits 22:22 */
    cs_uint32 inv_clk_out_ge2      :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd4               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_INT_CONFIG1_t;





#define NI_TOP_NI_ETH_INT_CONFIG2                0xf0010008
#define NI_TOP_NI_ETH_INT_CONFIG2_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               : 10 ;
    cs_uint32 tx_intf_lp_time_ge2  :  1 ; /* bits 21:21 */
    cs_uint32 power_dwn_tx_ge2     :  1 ; /* bits 20:20 */
    cs_uint32 power_dwn_rx_ge2     :  1 ; /* bits 19:19 */
    cs_uint32 inv_rxclk_out_ge2    :  1 ; /* bits 18:18 */
    cs_uint32 inv_clk_in_ge2       :  1 ; /* bits 17:17 */
    cs_uint32 smii_tx_stat_ge2     :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 tx_intf_lp_time_ge1  :  1 ; /* bits 13:13 */
    cs_uint32 power_dwn_tx_ge1     :  1 ; /* bits 12:12 */
    cs_uint32 power_dwn_rx_ge1     :  1 ; /* bits 11:11 */
    cs_uint32 inv_rxclk_out_ge1    :  1 ; /* bits 10:10 */
    cs_uint32 inv_clk_in_ge1       :  1 ; /* bits 9:9 */
    cs_uint32 smii_tx_stat_ge1     :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 tx_intf_lp_time_ge0  :  1 ; /* bits 5:5 */
    cs_uint32 power_dwn_tx_ge0     :  1 ; /* bits 4:4 */
    cs_uint32 power_dwn_rx_ge0     :  1 ; /* bits 3:3 */
    cs_uint32 inv_rxclk_out_ge0    :  1 ; /* bits 2:2 */
    cs_uint32 inv_clk_in_ge0       :  1 ; /* bits 1:1 */
    cs_uint32 smii_tx_stat_ge0     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 smii_tx_stat_ge0     :  1 ; /* bits 0:0 */
    cs_uint32 inv_clk_in_ge0       :  1 ; /* bits 1:1 */
    cs_uint32 inv_rxclk_out_ge0    :  1 ; /* bits 2:2 */
    cs_uint32 power_dwn_rx_ge0     :  1 ; /* bits 3:3 */
    cs_uint32 power_dwn_tx_ge0     :  1 ; /* bits 4:4 */
    cs_uint32 tx_intf_lp_time_ge0  :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 smii_tx_stat_ge1     :  1 ; /* bits 8:8 */
    cs_uint32 inv_clk_in_ge1       :  1 ; /* bits 9:9 */
    cs_uint32 inv_rxclk_out_ge1    :  1 ; /* bits 10:10 */
    cs_uint32 power_dwn_rx_ge1     :  1 ; /* bits 11:11 */
    cs_uint32 power_dwn_tx_ge1     :  1 ; /* bits 12:12 */
    cs_uint32 tx_intf_lp_time_ge1  :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 smii_tx_stat_ge2     :  1 ; /* bits 16:16 */
    cs_uint32 inv_clk_in_ge2       :  1 ; /* bits 17:17 */
    cs_uint32 inv_rxclk_out_ge2    :  1 ; /* bits 18:18 */
    cs_uint32 power_dwn_rx_ge2     :  1 ; /* bits 19:19 */
    cs_uint32 power_dwn_tx_ge2     :  1 ; /* bits 20:20 */
    cs_uint32 tx_intf_lp_time_ge2  :  1 ; /* bits 21:21 */
    cs_uint32 rsrvd3               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_INT_CONFIG2_t;





#define NI_TOP_NI_ETH_MGMT_PT_CONFIG             0xf001000c
#define NI_TOP_NI_ETH_MGMT_PT_CONFIG_dft         0x00000003




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 mgmt_pt_to_fe_also   :  1 ; /* bits 2:2 */
    cs_uint32 port_to_cpu          :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 port_to_cpu          :  2 ; /* bits 1:0 */
    cs_uint32 mgmt_pt_to_fe_also   :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_MGMT_PT_CONFIG_t;





#define NI_TOP_NI_ETH_MAC_CONFIG0_0              0xf0010010
#define NI_TOP_NI_ETH_MAC_CONFIG0_0_STRIDE       12
#define NI_TOP_NI_ETH_MAC_CONFIG0_0_COUNT        3
#define NI_TOP_NI_ETH_MAC_CONFIG0_0_dft          0x0010080c




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mac_tx_rst           :  1 ; /* bits 31:31 */
    cs_uint32 mac_rx_rst           :  1 ; /* bits 30:30 */
    cs_uint32 send_pg_data         :  1 ; /* bits 29:29 */
    cs_uint32 pass_thru_hdre       :  1 ; /* bits 28:28 */
    cs_uint32 tx_fifo_reset        :  1 ; /* bits 27:27 */
    cs_uint32 tx_auto_xon          :  1 ; /* bits 26:26 */
    cs_uint32 txfifo_thrshld       :  9 ; /* bits 25:17 */
    cs_uint32 txfifo_mode          :  1 ; /* bits 16:16 */
    cs_uint32 lpbk_mode            :  2 ; /* bits 15:14 */
    cs_uint32 tx_drain             :  1 ; /* bits 13:13 */
    cs_uint32 tx_flow_disable      :  1 ; /* bits 12:12 */
    cs_uint32 tx_ipg_sel           :  3 ; /* bits 11:9 */
    cs_uint32 rx_flow_disable      :  1 ; /* bits 8:8 */
    cs_uint32 link_active_mask     :  1 ; /* bits 7:7 */
    cs_uint32 link_stat_mask       :  1 ; /* bits 6:6 */
    cs_uint32 link_status          :  1 ; /* bits 5:5 */
    cs_uint32 crs_polarity         :  1 ; /* bits 4:4 */
    cs_uint32 tx_en                :  1 ; /* bits 3:3 */
    cs_uint32 rx_en                :  1 ; /* bits 2:2 */
    cs_uint32 duplex               :  1 ; /* bits 1:1 */
    cs_uint32 speed                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 speed                :  1 ; /* bits 0:0 */
    cs_uint32 duplex               :  1 ; /* bits 1:1 */
    cs_uint32 rx_en                :  1 ; /* bits 2:2 */
    cs_uint32 tx_en                :  1 ; /* bits 3:3 */
    cs_uint32 crs_polarity         :  1 ; /* bits 4:4 */
    cs_uint32 link_status          :  1 ; /* bits 5:5 */
    cs_uint32 link_stat_mask       :  1 ; /* bits 6:6 */
    cs_uint32 link_active_mask     :  1 ; /* bits 7:7 */
    cs_uint32 rx_flow_disable      :  1 ; /* bits 8:8 */
    cs_uint32 tx_ipg_sel           :  3 ; /* bits 11:9 */
    cs_uint32 tx_flow_disable      :  1 ; /* bits 12:12 */
    cs_uint32 tx_drain             :  1 ; /* bits 13:13 */
    cs_uint32 lpbk_mode            :  2 ; /* bits 15:14 */
    cs_uint32 txfifo_mode          :  1 ; /* bits 16:16 */
    cs_uint32 txfifo_thrshld       :  9 ; /* bits 25:17 */
    cs_uint32 tx_auto_xon          :  1 ; /* bits 26:26 */
    cs_uint32 tx_fifo_reset        :  1 ; /* bits 27:27 */
    cs_uint32 pass_thru_hdre       :  1 ; /* bits 28:28 */
    cs_uint32 send_pg_data         :  1 ; /* bits 29:29 */
    cs_uint32 mac_rx_rst           :  1 ; /* bits 30:30 */
    cs_uint32 mac_tx_rst           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_MAC_CONFIG0_0_t;





#define NI_TOP_NI_ETH_MAC_CONFIG1_0              0xf0010014
#define NI_TOP_NI_ETH_MAC_CONFIG1_0_STRIDE       12
#define NI_TOP_NI_ETH_MAC_CONFIG1_0_COUNT        3
#define NI_TOP_NI_ETH_MAC_CONFIG1_0_dft          0x00000f00




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 wol_passwd6          :  8 ; /* bits 23:16 */
    cs_uint32 ts_add_dis           :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 wol_mac_adr_cnt      :  6 ; /* bits 13:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 wol_passwd_cnt       :  1 ; /* bits 5:5 */
    cs_uint32 wol_secure_on        :  1 ; /* bits 4:4 */
    cs_uint32 wol_ign_err          :  1 ; /* bits 3:3 */
    cs_uint32 wol_chk_da           :  2 ; /* bits 2:1 */
    cs_uint32 wol_pkt_det_en       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wol_pkt_det_en       :  1 ; /* bits 0:0 */
    cs_uint32 wol_chk_da           :  2 ; /* bits 2:1 */
    cs_uint32 wol_ign_err          :  1 ; /* bits 3:3 */
    cs_uint32 wol_secure_on        :  1 ; /* bits 4:4 */
    cs_uint32 wol_passwd_cnt       :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 wol_mac_adr_cnt      :  6 ; /* bits 13:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 ts_add_dis           :  1 ; /* bits 15:15 */
    cs_uint32 wol_passwd6          :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_MAC_CONFIG1_0_t;





#define NI_TOP_NI_ETH_MAC_CONFIG2_0              0xf0010018
#define NI_TOP_NI_ETH_MAC_CONFIG2_0_STRIDE       12
#define NI_TOP_NI_ETH_MAC_CONFIG2_0_COUNT        3
#define NI_TOP_NI_ETH_MAC_CONFIG2_0_dft          0x00ff0000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pause_time           : 16 ; /* bits 31:16 */
    cs_uint32 sup_tx_to_rx_lpbk_data :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 mac_cfg_spare        :  1 ; /* bits 8:8 */
    cs_uint32 mac_addr6            :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mac_addr6            :  8 ; /* bits 7:0 */
    cs_uint32 mac_cfg_spare        :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 sup_tx_to_rx_lpbk_data :  1 ; /* bits 15:15 */
    cs_uint32 pause_time           : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_MAC_CONFIG2_0_t;


    
    
    
    
    
    



#define NI_TOP_NI_ETH_RCV_STAT_0                 0xf0010034
#define NI_TOP_NI_ETH_RCV_STAT_0_STRIDE          4
#define NI_TOP_NI_ETH_RCV_STAT_0_COUNT           3
#define NI_TOP_NI_ETH_RCV_STAT_0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 rcv_lnk_stat         :  1 ; /* bits 3:3 */
    cs_uint32 rcv_duplex           :  1 ; /* bits 2:2 */
    cs_uint32 rcv_speed            :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rcv_speed            :  2 ; /* bits 1:0 */
    cs_uint32 rcv_duplex           :  1 ; /* bits 2:2 */
    cs_uint32 rcv_lnk_stat         :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_ETH_RCV_STAT_0_t;


    
    



#define NI_TOP_NI_MAC_ADDR0                      0xf0010040
#define NI_TOP_NI_MAC_ADDR0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mac_addr0            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mac_addr0            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MAC_ADDR0_t;





#define NI_TOP_NI_MAC_ADDR1                      0xf0010044
#define NI_TOP_NI_MAC_ADDR1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 mac_addr1            :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mac_addr1            :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MAC_ADDR1_t;





#define NI_TOP_NI_WOL_PASSWD_0                   0xf0010048
#define NI_TOP_NI_WOL_PASSWD_0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 wol_passwd0          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wol_passwd0          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_PASSWD_0_t;





#define NI_TOP_NI_WOL_PASSWD_1                   0xf001004c
#define NI_TOP_NI_WOL_PASSWD_1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 wol_passwd1          :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wol_passwd1          :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_PASSWD_1_t;





#define NI_TOP_NI_PKT_LEN_CONFIG                 0xf0010050
#define NI_TOP_NI_PKT_LEN_CONFIG_dft             0x00400600




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 min_pkt_size         : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 max_pkt_size         : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 max_pkt_size         : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 min_pkt_size         : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd2               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PKT_LEN_CONFIG_t;





#define NI_TOP_NI_PKT_STOR_LEN_CONFIG            0xf0010054
#define NI_TOP_NI_PKT_STOR_LEN_CONFIG_dft        0x00002454




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 max_stor_pkt_len     : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 max_stor_pkt_len     : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PKT_STOR_LEN_CONFIG_t;





#define NI_TOP_NI_RX_CNTRL_CONFIG0_0             0xf0010058
#define NI_TOP_NI_RX_CNTRL_CONFIG0_0_STRIDE      8
#define NI_TOP_NI_RX_CNTRL_CONFIG0_0_COUNT       8
#define NI_TOP_NI_RX_CNTRL_CONFIG0_0_dft         0x00400400




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rxctrl_cfg_spare     :  2 ; /* bits 31:30 */
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 buff_use_thrshld     : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 linkstat_drop_dis    :  1 ; /* bits 10:10 */
    cs_uint32 oam_drop_dis         :  1 ; /* bits 9:9 */
    cs_uint32 ukopcode_drop_dis    :  1 ; /* bits 8:8 */
    cs_uint32 flow_drop_dis        :  1 ; /* bits 7:7 */
    cs_uint32 runt_drop_dis        :  1 ; /* bits 6:6 */
    cs_uint32 ovr_drop_dis         :  1 ; /* bits 5:5 */
    cs_uint32 crc_drop_dis         :  1 ; /* bits 4:4 */
    cs_uint32 shrtfrm_mode         :  1 ; /* bits 3:3 */
    cs_uint32 ff_overrun_drop_dis  :  1 ; /* bits 2:2 */
    cs_uint32 rc_fifo_reset        :  1 ; /* bits 1:1 */
    cs_uint32 rxctrl_dis           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxctrl_dis           :  1 ; /* bits 0:0 */
    cs_uint32 rc_fifo_reset        :  1 ; /* bits 1:1 */
    cs_uint32 ff_overrun_drop_dis  :  1 ; /* bits 2:2 */
    cs_uint32 shrtfrm_mode         :  1 ; /* bits 3:3 */
    cs_uint32 crc_drop_dis         :  1 ; /* bits 4:4 */
    cs_uint32 ovr_drop_dis         :  1 ; /* bits 5:5 */
    cs_uint32 runt_drop_dis        :  1 ; /* bits 6:6 */
    cs_uint32 flow_drop_dis        :  1 ; /* bits 7:7 */
    cs_uint32 ukopcode_drop_dis    :  1 ; /* bits 8:8 */
    cs_uint32 oam_drop_dis         :  1 ; /* bits 9:9 */
    cs_uint32 linkstat_drop_dis    :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 buff_use_thrshld     : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 rxctrl_cfg_spare     :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_CNTRL_CONFIG0_0_t;





#define NI_TOP_NI_RX_CNTRL_CONFIG1_0             0xf001005c
#define NI_TOP_NI_RX_CNTRL_CONFIG1_0_STRIDE      8
#define NI_TOP_NI_RX_CNTRL_CONFIG1_0_COUNT       8
#define NI_TOP_NI_RX_CNTRL_CONFIG1_0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 16 ;
    cs_uint32 rxctrl_byp_voq       :  8 ; /* bits 15:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 rxctrl_byp_cpuptp    :  1 ; /* bits 6:6 */
    cs_uint32 rxctrl_byp_nocrc     :  1 ; /* bits 5:5 */
    cs_uint32 rxctrl_byp_nostuff   :  1 ; /* bits 4:4 */
    cs_uint32 rxctrl_byp_cos       :  3 ; /* bits 3:1 */
    cs_uint32 rxctrl_byp_en        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxctrl_byp_en        :  1 ; /* bits 0:0 */
    cs_uint32 rxctrl_byp_cos       :  3 ; /* bits 3:1 */
    cs_uint32 rxctrl_byp_nostuff   :  1 ; /* bits 4:4 */
    cs_uint32 rxctrl_byp_nocrc     :  1 ; /* bits 5:5 */
    cs_uint32 rxctrl_byp_cpuptp    :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 rxctrl_byp_voq       :  8 ; /* bits 15:8 */
    cs_uint32 rsrvd2               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_CNTRL_CONFIG1_0_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_RX_AGG_CONFIG                  0xf0010098
#define NI_TOP_NI_RX_AGG_CONFIG_dft              0x02880029




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  2 ;
    cs_uint32 rxagg_cfg_spare      :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 rx_fifo_full_unset_th :  5 ; /* bits 26:22 */
    cs_uint32 rx_fifo_full_set_th  :  5 ; /* bits 21:17 */
    cs_uint32 rx_fifo_non_correct_err_vlden :  1 ; /* bits 16:16 */
    cs_uint32 rx_fifo_suppkt_less18 :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 rx_fifo_srst         :  1 ; /* bits 8:8 */
    cs_uint32 rx_frm_space         :  6 ; /* bits 7:2 */
    cs_uint32 rx_fifo_dis          :  1 ; /* bits 1:1 */
    cs_uint32 rx_port_cal_dis      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_port_cal_dis      :  1 ; /* bits 0:0 */
    cs_uint32 rx_fifo_dis          :  1 ; /* bits 1:1 */
    cs_uint32 rx_frm_space         :  6 ; /* bits 7:2 */
    cs_uint32 rx_fifo_srst         :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 rx_fifo_suppkt_less18 :  1 ; /* bits 15:15 */
    cs_uint32 rx_fifo_non_correct_err_vlden :  1 ; /* bits 16:16 */
    cs_uint32 rx_fifo_full_set_th  :  5 ; /* bits 21:17 */
    cs_uint32 rx_fifo_full_unset_th :  5 ; /* bits 26:22 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 rxagg_cfg_spare      :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd3               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_AGG_CONFIG_t;





#define NI_TOP_NI_RX_AGGPC_CONFIG                0xf001009c
#define NI_TOP_NI_RX_AGGPC_CONFIG_dft            0x00005f5f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 17 ;
    cs_uint32 pc_ts_wrap_cnt_pg1   :  7 ; /* bits 14:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pc_ts_wrap_cnt_pg0   :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_ts_wrap_cnt_pg0   :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pc_ts_wrap_cnt_pg1   :  7 ; /* bits 14:8 */
    cs_uint32 rsrvd2               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_AGGPC_CONFIG_t;





#define NI_TOP_NI_RX_FIFO_CG_TH                  0xf00100a0
#define NI_TOP_NI_RX_FIFO_CG_TH_dft              0x80c8812c




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rx_fifo_cg_pkt_en    :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rx_fifo_cg_pkt_th    : 10 ; /* bits 25:16 */
    cs_uint32 rx_fifo_cg_free_en   :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_fifo_cg_free_th   : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_fifo_cg_free_th   : 10 ; /* bits 9:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_fifo_cg_free_en   :  1 ; /* bits 15:15 */
    cs_uint32 rx_fifo_cg_pkt_th    : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rx_fifo_cg_pkt_en    :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_FIFO_CG_TH_t;





#define NI_TOP_NI_RX_FIFO_NOCG_TH                0xf00100a4
#define NI_TOP_NI_RX_FIFO_NOCG_TH_dft            0x80328190




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rx_fifo_nocg_pkt_en  :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rx_fifo_nocg_pkt_th  : 10 ; /* bits 25:16 */
    cs_uint32 rx_fifo_nocg_free_en :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_fifo_nocg_free_th : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_fifo_nocg_free_th : 10 ; /* bits 9:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_fifo_nocg_free_en :  1 ; /* bits 15:15 */
    cs_uint32 rx_fifo_nocg_pkt_th  : 10 ; /* bits 25:16 */
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rx_fifo_nocg_pkt_en  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_FIFO_NOCG_TH_t;





#define NI_TOP_NI_RX_FIFO_STAT                   0xf00100a8
#define NI_TOP_NI_RX_FIFO_STAT_dft               0x00040000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rxpc_current_pg      :  1 ; /* bits 31:31 */
    cs_uint32 rxfifo_init_done     :  1 ; /* bits 30:30 */
    cs_uint32 rxfifo_voq_cnt       : 11 ; /* bits 29:19 */
    cs_uint32 rxfifo_fb_cnt        : 11 ; /* bits 18:8 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 rx_fifo_congestion   :  1 ; /* bits 4:4 */
    cs_uint32 rx_rtn_buff_err      :  1 ; /* bits 3:3 */
    cs_uint32 voq_full             :  1 ; /* bits 2:2 */
    cs_uint32 rxfifo_full          :  1 ; /* bits 1:1 */
    cs_uint32 rx_fifo_non_correct_err_state :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_fifo_non_correct_err_state :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_full          :  1 ; /* bits 1:1 */
    cs_uint32 voq_full             :  1 ; /* bits 2:2 */
    cs_uint32 rx_rtn_buff_err      :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_congestion   :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 rxfifo_fb_cnt        : 11 ; /* bits 18:8 */
    cs_uint32 rxfifo_voq_cnt       : 11 ; /* bits 29:19 */
    cs_uint32 rxfifo_init_done     :  1 ; /* bits 30:30 */
    cs_uint32 rxpc_current_pg      :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_FIFO_STAT_t;





#define NI_TOP_NI_RX_PORT_CAL_ACCESS             0xf00100ac
#define NI_TOP_NI_RX_PORT_CAL_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 rxpc_page            :  1 ; /* bits 17:17 */
    cs_uint32 cpu_page             :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 address              :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 cpu_page             :  1 ; /* bits 16:16 */
    cs_uint32 rxpc_page            :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_PORT_CAL_ACCESS_t;





#define NI_TOP_NI_RX_PORT_CAL_DATA               0xf00100b0
#define NI_TOP_NI_RX_PORT_CAL_DATA_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 pspid_ts             :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pspid_ts             :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RX_PORT_CAL_DATA_t;





#define NI_TOP_NI_RXFIFO_DBG_ACCESS              0xf00100b4
#define NI_TOP_NI_RXFIFO_DBG_ACCESS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 debug_mode           :  1 ; /* bits 29:29 */
    cs_uint32 mem_sel              :  2 ; /* bits 28:27 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 address              : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              : 10 ; /* bits 9:0 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 mem_sel              :  2 ; /* bits 28:27 */
    cs_uint32 debug_mode           :  1 ; /* bits 29:29 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_DBG_ACCESS_t;





#define NI_TOP_NI_RXFIFO_DBG_DATA                0xf00100b8
#define NI_TOP_NI_RXFIFO_DBG_DATA_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_rdata            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_rdata            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_DBG_DATA_t;





#define NI_TOP_NI_RXFIFO_DBG1                    0xf00100bc
#define NI_TOP_NI_RXFIFO_DBG1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rxfifo_voqm_eccmask  :  7 ; /* bits 7:1 */
    cs_uint32 rxfifo_voqm_dbg      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxfifo_voqm_dbg      :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_voqm_eccmask  :  7 ; /* bits 7:1 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_DBG1_t;





#define NI_TOP_NI_SCH_BP_THLD_ETH                0xf00100c0
#define NI_TOP_NI_SCH_BP_THLD_ETH_dft            0x082a00f8




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 rdy_low_thld_fe      :  5 ; /* bits 27:23 */
    cs_uint32 rdy_high_thld_fe     :  5 ; /* bits 22:18 */
    cs_uint32 rdy_low_thld_ge      :  9 ; /* bits 17:9 */
    cs_uint32 rdy_high_thld_ge     :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rdy_high_thld_ge     :  9 ; /* bits 8:0 */
    cs_uint32 rdy_low_thld_ge      :  9 ; /* bits 17:9 */
    cs_uint32 rdy_high_thld_fe     :  5 ; /* bits 22:18 */
    cs_uint32 rdy_low_thld_fe      :  5 ; /* bits 27:23 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_SCH_BP_THLD_ETH_t;





#define NI_TOP_NI_SCH_BP_THLD_MC                 0xf00100c4
#define NI_TOP_NI_SCH_BP_THLD_MC_dft             0x047f0472




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rdy_low_thld_mc      : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rdy_high_thld_mc     : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rdy_high_thld_mc     : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rdy_low_thld_mc      : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_SCH_BP_THLD_MC_t;





#define NI_TOP_NI_MISC_CONFIG                    0xf00100c8
#define NI_TOP_NI_MISC_CONFIG_dft                0x00001050




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 txmib_mode           :  1 ; /* bits 17:17 */
    cs_uint32 rxmib_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 mc_accept_all        :  1 ; /* bits 14:14 */
    cs_uint32 ptp_cpu_cache_cnt    :  5 ; /* bits 13:9 */
    cs_uint32 ptp_hw_cnt_rst       :  1 ; /* bits 8:8 */
    cs_uint32 mr_fe_bp_en          :  1 ; /* bits 7:7 */
    cs_uint32 mr_lspid_inst_cp     :  1 ; /* bits 6:6 */
    cs_uint32 mc_source_filter_on  :  1 ; /* bits 5:5 */
    cs_uint32 mc_lspid_inst_cp     :  1 ; /* bits 4:4 */
    cs_uint32 mc_source_filter_on_hdrvec :  1 ; /* bits 3:3 */
    cs_uint32 eth_sch_rdy_pkt      :  1 ; /* bits 2:2 */
    cs_uint32 mc_pkt_rm_crcerr     :  1 ; /* bits 1:1 */
    cs_uint32 tx_em_crc_inv        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 tx_em_crc_inv        :  1 ; /* bits 0:0 */
    cs_uint32 mc_pkt_rm_crcerr     :  1 ; /* bits 1:1 */
    cs_uint32 eth_sch_rdy_pkt      :  1 ; /* bits 2:2 */
    cs_uint32 mc_source_filter_on_hdrvec :  1 ; /* bits 3:3 */
    cs_uint32 mc_lspid_inst_cp     :  1 ; /* bits 4:4 */
    cs_uint32 mc_source_filter_on  :  1 ; /* bits 5:5 */
    cs_uint32 mr_lspid_inst_cp     :  1 ; /* bits 6:6 */
    cs_uint32 mr_fe_bp_en          :  1 ; /* bits 7:7 */
    cs_uint32 ptp_hw_cnt_rst       :  1 ; /* bits 8:8 */
    cs_uint32 ptp_cpu_cache_cnt    :  5 ; /* bits 13:9 */
    cs_uint32 mc_accept_all        :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 rxmib_mode           :  1 ; /* bits 16:16 */
    cs_uint32 txmib_mode           :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MISC_CONFIG_t;





#define NI_TOP_NI_TX_VOQ_LKUP_ACCESS             0xf00100cc
#define NI_TOP_NI_TX_VOQ_LKUP_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 err_parity           :  1 ; /* bits 17:17 */
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 address              :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 err_parity           :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TX_VOQ_LKUP_ACCESS_t;





#define NI_TOP_NI_TX_VOQ_LKUP_DATA1              0xf00100d0
#define NI_TOP_NI_TX_VOQ_LKUP_DATA1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 txem_crcstate        :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_crcstate        :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TX_VOQ_LKUP_DATA1_t;





#define NI_TOP_NI_TX_VOQ_LKUP_DATA0              0xf00100d4
#define NI_TOP_NI_TX_VOQ_LKUP_DATA0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 txem_crcstate        : 27 ; /* bits 31:5 */
    cs_uint32 txem_discrc          :  1 ; /* bits 4:4 */
    cs_uint32 txem_voq_did         :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_voq_did         :  4 ; /* bits 3:0 */
    cs_uint32 txem_discrc          :  1 ; /* bits 4:4 */
    cs_uint32 txem_crcstate        : 27 ; /* bits 31:5 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TX_VOQ_LKUP_DATA0_t;





#define NI_TOP_NI_MC_INDX_LKUP_ACCESS            0xf00100d8
#define NI_TOP_NI_MC_INDX_LKUP_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 err_parity           :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 address              :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_parity           :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MC_INDX_LKUP_ACCESS_t;





#define NI_TOP_NI_MC_INDX_LKUP_DATA              0xf00100dc
#define NI_TOP_NI_MC_INDX_LKUP_DATA_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 mc_vec               : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mc_vec               : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MC_INDX_LKUP_DATA_t;





#define NI_TOP_NI_PG_DA1                         0xf00100e0
#define NI_TOP_NI_PG_DA1_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_da1               :  8 ; /* bits 31:24 */
    cs_uint32 pg_da2               :  8 ; /* bits 23:16 */
    cs_uint32 pg_da3               :  8 ; /* bits 15:8 */
    cs_uint32 pg_da4               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_da4               :  8 ; /* bits 7:0 */
    cs_uint32 pg_da3               :  8 ; /* bits 15:8 */
    cs_uint32 pg_da2               :  8 ; /* bits 23:16 */
    cs_uint32 pg_da1               :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_DA1_t;





#define NI_TOP_NI_PG_DA2                         0xf00100e4
#define NI_TOP_NI_PG_DA2_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pg_da5               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_da5               :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_DA2_t;





#define NI_TOP_NI_PG_SA1                         0xf00100e8
#define NI_TOP_NI_PG_SA1_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_sa1               :  8 ; /* bits 31:24 */
    cs_uint32 pg_sa2               :  8 ; /* bits 23:16 */
    cs_uint32 pg_sa3               :  8 ; /* bits 15:8 */
    cs_uint32 pg_sa4               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_sa4               :  8 ; /* bits 7:0 */
    cs_uint32 pg_sa3               :  8 ; /* bits 15:8 */
    cs_uint32 pg_sa2               :  8 ; /* bits 23:16 */
    cs_uint32 pg_sa1               :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_SA1_t;





#define NI_TOP_NI_PG_SA2                         0xf00100ec
#define NI_TOP_NI_PG_SA2_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pg_sa5               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_sa5               :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_SA2_t;





#define NI_TOP_NI_PG_CFG0                        0xf00100f0
#define NI_TOP_NI_PG_CFG0_dft                    0x00648064




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_frm_cnt           : 16 ; /* bits 31:16 */
    cs_uint32 pg_len_data          :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 pg_len               : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_len               : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 pg_len_data          :  1 ; /* bits 15:15 */
    cs_uint32 pg_frm_cnt           : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_CFG0_t;





#define NI_TOP_NI_PG_CFG1                        0xf00100f4
#define NI_TOP_NI_PG_CFG1_dft                    0x81008100




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_vlan2_tpid        : 16 ; /* bits 31:16 */
    cs_uint32 pg_vlan1_tpid        : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_vlan1_tpid        : 16 ; /* bits 15:0 */
    cs_uint32 pg_vlan2_tpid        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_CFG1_t;





#define NI_TOP_NI_PG_FXPT                        0xf00100f8
#define NI_TOP_NI_PG_FXPT_dft                    0xaaaa5555




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_fxpat             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_fxpat             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG_FXPT_t;





#define NI_TOP_NI_PG0_CFG1                       0xf00100fc
#define NI_TOP_NI_PG0_CFG1_STRIDE                12
#define NI_TOP_NI_PG0_CFG1_COUNT                 3
#define NI_TOP_NI_PG0_CFG1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_type              : 16 ; /* bits 31:16 */
    cs_uint32 pg_sa6               :  8 ; /* bits 15:8 */
    cs_uint32 pg_da6               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_da6               :  8 ; /* bits 7:0 */
    cs_uint32 pg_sa6               :  8 ; /* bits 15:8 */
    cs_uint32 pg_type              : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG0_CFG1_t;





#define NI_TOP_NI_PG0_CFG2                       0xf0010100
#define NI_TOP_NI_PG0_CFG2_STRIDE                12
#define NI_TOP_NI_PG0_CFG2_COUNT                 3
#define NI_TOP_NI_PG0_CFG2_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pg_vlan2             : 16 ; /* bits 31:16 */
    cs_uint32 pg_vlan1             : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_vlan1             : 16 ; /* bits 15:0 */
    cs_uint32 pg_vlan2             : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG0_CFG2_t;





#define NI_TOP_NI_PG0_CNTRL                      0xf0010104
#define NI_TOP_NI_PG0_CNTRL_STRIDE               12
#define NI_TOP_NI_PG0_CNTRL_COUNT                3
#define NI_TOP_NI_PG0_CNTRL_dft                  0x00080000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  8 ;
    cs_uint32 pg_ipg               :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 pg_insfixpattern     :  1 ; /* bits 10:10 */
    cs_uint32 pg_invpat            :  1 ; /* bits 9:9 */
    cs_uint32 pg_insseqnum         :  1 ; /* bits 8:8 */
    cs_uint32 pg_instype           :  1 ; /* bits 7:7 */
    cs_uint32 pg_insvlan1          :  1 ; /* bits 6:6 */
    cs_uint32 pg_insvlan2          :  1 ; /* bits 5:5 */
    cs_uint32 pg_fixedlen          :  1 ; /* bits 4:4 */
    cs_uint32 pg_linerate          :  2 ; /* bits 3:2 */
    cs_uint32 pg_fixedcount        :  1 ; /* bits 1:1 */
    cs_uint32 pg_en                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pg_en                :  1 ; /* bits 0:0 */
    cs_uint32 pg_fixedcount        :  1 ; /* bits 1:1 */
    cs_uint32 pg_linerate          :  2 ; /* bits 3:2 */
    cs_uint32 pg_fixedlen          :  1 ; /* bits 4:4 */
    cs_uint32 pg_insvlan2          :  1 ; /* bits 5:5 */
    cs_uint32 pg_insvlan1          :  1 ; /* bits 6:6 */
    cs_uint32 pg_instype           :  1 ; /* bits 7:7 */
    cs_uint32 pg_insseqnum         :  1 ; /* bits 8:8 */
    cs_uint32 pg_invpat            :  1 ; /* bits 9:9 */
    cs_uint32 pg_insfixpattern     :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 pg_ipg               :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd2               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PG0_CNTRL_t;


    
    
    
    
    
    



#define NI_TOP_NI_PC_DA1                         0xf0010120
#define NI_TOP_NI_PC_DA1_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_da1               :  8 ; /* bits 31:24 */
    cs_uint32 pc_da2               :  8 ; /* bits 23:16 */
    cs_uint32 pc_da3               :  8 ; /* bits 15:8 */
    cs_uint32 pc_da4               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_da4               :  8 ; /* bits 7:0 */
    cs_uint32 pc_da3               :  8 ; /* bits 15:8 */
    cs_uint32 pc_da2               :  8 ; /* bits 23:16 */
    cs_uint32 pc_da1               :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_DA1_t;





#define NI_TOP_NI_PC_DA2                         0xf0010124
#define NI_TOP_NI_PC_DA2_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pc_da5               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_da5               :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_DA2_t;





#define NI_TOP_NI_PC_SA1                         0xf0010128
#define NI_TOP_NI_PC_SA1_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_sa1               :  8 ; /* bits 31:24 */
    cs_uint32 pc_sa2               :  8 ; /* bits 23:16 */
    cs_uint32 pc_sa3               :  8 ; /* bits 15:8 */
    cs_uint32 pc_sa4               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_sa4               :  8 ; /* bits 7:0 */
    cs_uint32 pc_sa3               :  8 ; /* bits 15:8 */
    cs_uint32 pc_sa2               :  8 ; /* bits 23:16 */
    cs_uint32 pc_sa1               :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_SA1_t;





#define NI_TOP_NI_PC_SA2                         0xf001012c
#define NI_TOP_NI_PC_SA2_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pc_sa5               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_sa5               :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_SA2_t;





#define NI_TOP_NI_PC_CFG0                        0xf0010130
#define NI_TOP_NI_PC_CFG0_dft                    0x00000064




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 pc_len               : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_len               : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_CFG0_t;





#define NI_TOP_NI_PC_CFG1                        0xf0010134
#define NI_TOP_NI_PC_CFG1_dft                    0x81008100




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_vlan2_tpid        : 16 ; /* bits 31:16 */
    cs_uint32 pc_vlan1_tpid        : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_vlan1_tpid        : 16 ; /* bits 15:0 */
    cs_uint32 pc_vlan2_tpid        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_CFG1_t;





#define NI_TOP_NI_PC_FXPT                        0xf0010138
#define NI_TOP_NI_PC_FXPT_dft                    0xaaaa5555




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_fxpat             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_fxpat             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC_FXPT_t;





#define NI_TOP_NI_PC0_CFG1                       0xf001013c
#define NI_TOP_NI_PC0_CFG1_STRIDE                16
#define NI_TOP_NI_PC0_CFG1_COUNT                 3
#define NI_TOP_NI_PC0_CFG1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_type              : 16 ; /* bits 31:16 */
    cs_uint32 pc_sa6               :  8 ; /* bits 15:8 */
    cs_uint32 pc_da6               :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_da6               :  8 ; /* bits 7:0 */
    cs_uint32 pc_sa6               :  8 ; /* bits 15:8 */
    cs_uint32 pc_type              : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_CFG1_t;





#define NI_TOP_NI_PC0_CFG2                       0xf0010140
#define NI_TOP_NI_PC0_CFG2_STRIDE                16
#define NI_TOP_NI_PC0_CFG2_COUNT                 3
#define NI_TOP_NI_PC0_CFG2_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pc_vlan2             : 16 ; /* bits 31:16 */
    cs_uint32 pc_vlan1             : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_vlan1             : 16 ; /* bits 15:0 */
    cs_uint32 pc_vlan2             : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_CFG2_t;





#define NI_TOP_NI_PC0_CNTRL                      0xf0010144
#define NI_TOP_NI_PC0_CNTRL_STRIDE               16
#define NI_TOP_NI_PC0_CNTRL_COUNT                3
#define NI_TOP_NI_PC0_CNTRL_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 21 ;
    cs_uint32 pc_expfixpattern     :  1 ; /* bits 10:10 */
    cs_uint32 pc_invpat            :  1 ; /* bits 9:9 */
    cs_uint32 pc_expseqnum         :  1 ; /* bits 8:8 */
    cs_uint32 pc_exptype           :  1 ; /* bits 7:7 */
    cs_uint32 pc_expvlan1          :  1 ; /* bits 6:6 */
    cs_uint32 pc_expvlan2          :  1 ; /* bits 5:5 */
    cs_uint32 pc_fixedlen          :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 pc_en                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_en                :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 pc_fixedlen          :  1 ; /* bits 4:4 */
    cs_uint32 pc_expvlan2          :  1 ; /* bits 5:5 */
    cs_uint32 pc_expvlan1          :  1 ; /* bits 6:6 */
    cs_uint32 pc_exptype           :  1 ; /* bits 7:7 */
    cs_uint32 pc_expseqnum         :  1 ; /* bits 8:8 */
    cs_uint32 pc_invpat            :  1 ; /* bits 9:9 */
    cs_uint32 pc_expfixpattern     :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd2               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_CNTRL_t;





#define NI_TOP_NI_PC0_STAT                       0xf0010148
#define NI_TOP_NI_PC0_STAT_STRIDE                16
#define NI_TOP_NI_PC0_STAT_COUNT                 3
#define NI_TOP_NI_PC0_STAT_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 pc_dchkstatus        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pc_dchkstatus        :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_STAT_t;


    
    
    
    
    
    
    
    



#define NI_TOP_NI_RM_CFG                         0xf001016c
#define NI_TOP_NI_RM_CFG_dft                     0x05000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rm_tbinc             :  8 ; /* bits 31:24 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 debug_mode           :  1 ; /* bits 11:11 */
    cs_uint32 rm_clrtb             :  1 ; /* bits 10:10 */
    cs_uint32 rm_clrcnt            :  1 ; /* bits 9:9 */
    cs_uint32 rm_cntpkts           :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 rm_pid               :  4 ; /* bits 4:1 */
    cs_uint32 rm_en                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rm_en                :  1 ; /* bits 0:0 */
    cs_uint32 rm_pid               :  4 ; /* bits 4:1 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 rm_cntpkts           :  1 ; /* bits 8:8 */
    cs_uint32 rm_clrcnt            :  1 ; /* bits 9:9 */
    cs_uint32 rm_clrtb             :  1 ; /* bits 10:10 */
    cs_uint32 debug_mode           :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 rm_tbinc             :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RM_CFG_t;





#define NI_TOP_NI_RM_TBMAX                       0xf0010170
#define NI_TOP_NI_RM_TBMAX_dft                   0x00ffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rm_tbmax             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rm_tbmax             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RM_TBMAX_t;





#define NI_TOP_NI_RM_CNTR                        0xf0010174
#define NI_TOP_NI_RM_CNTR_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rm_cnt               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rm_cnt               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RM_CNTR_t;





#define NI_TOP_NI_RM_LASTCNTR                    0xf0010178
#define NI_TOP_NI_RM_LASTCNTR_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rm_lastcnt           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rm_lastcnt           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RM_LASTCNTR_t;





#define NI_TOP_NI_PPS_TRIG_HW_TS                 0xf001017c
#define NI_TOP_NI_PPS_TRIG_HW_TS_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pps_trigger_hw_ts    : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pps_trigger_hw_ts    : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PPS_TRIG_HW_TS_t;





#define NI_TOP_NI_INIT_DONE                      0xf0010180
#define NI_TOP_NI_INIT_DONE_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 ni_init_done         :  1 ; /* bits 1:1 */
    cs_uint32 ni_mib_init_done     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ni_mib_init_done     :  1 ; /* bits 0:0 */
    cs_uint32 ni_init_done         :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INIT_DONE_t;





#define NI_TOP_NI_RXMIB_ACCESS                   0xf0010184
#define NI_TOP_NI_RXMIB_ACCESS_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 port_id              :  3 ; /* bits 7:5 */
    cs_uint32 counter_id           :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 counter_id           :  5 ; /* bits 4:0 */
    cs_uint32 port_id              :  3 ; /* bits 7:5 */
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXMIB_ACCESS_t;

#define     counter_id_RxUCPktCnt                         0x0
#define     counter_id_RxMCFrmCnt                         0x1
#define     counter_id_RxBCFrmCnt                         0x2
#define     counter_id_RxOAMFrmCnt                        0x3
#define     counter_id_RxJumboFrmCnt                      0x4
#define     counter_id_RxPauseFrmCnt                      0x5
#define     counter_id_RxUnKnownOCFrmCnt                  0x6
#define     counter_id_RxCrcErrFrmCnt                     0x7
#define     counter_id_RxUndersizeFrmCnt                  0x8
#define     counter_id_RxRuntFrmCnt                       0x9
#define     counter_id_RxOvSizeFrmCnt                     0xa
#define     counter_id_RxJabberFrmCnt                     0xb
#define     counter_id_RxInvalidFrmCnt                    0xc
#define     counter_id_RxStatsFrm64Oct                    0xd
#define     counter_id_RxStatsFrm65to127Oct               0xe
#define     counter_id_RxStatsFrm128to255Oct              0xf
#define     counter_id_RxStatsFrm256to511Oct              0x10
#define     counter_id_RxStatsFrm512to1023Oct             0x11
#define     counter_id_RxStatsFrm1024to1518Oct            0x12
#define     counter_id_RxStatsFrm1519to2100Oct            0x13
#define     counter_id_RxStatsFrm2101to9200Oct            0x14
#define     counter_id_RxStatsFrm9201toMaxOct             0x15
#define     counter_id_RxByteCount_Lo                     0x16
#define     counter_id_RxByteCount_Hi                     0x17




#define NI_TOP_NI_RXMIB_DATA1                    0xf0010188
#define NI_TOP_NI_RXMIB_DATA1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cnt_val_hi           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cnt_val_hi           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXMIB_DATA1_t;





#define NI_TOP_NI_RXMIB_DATA0                    0xf001018c
#define NI_TOP_NI_RXMIB_DATA0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cnt_val_lo           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cnt_val_lo           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXMIB_DATA0_t;





#define NI_TOP_NI_TXMIB_ACCESS                   0xf0010190
#define NI_TOP_NI_TXMIB_ACCESS_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 port_id              :  2 ; /* bits 6:5 */
    cs_uint32 counter_id           :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 counter_id           :  5 ; /* bits 4:0 */
    cs_uint32 port_id              :  2 ; /* bits 6:5 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXMIB_ACCESS_t;

#define     counter_id_TxUCPktCnt                         0x0
#define     counter_id_TxMCFrmCnt                         0x1
#define     counter_id_TxBCFrmCnt                         0x2
#define     counter_id_TxOAMFrmCnt                        0x3
#define     counter_id_TxJumboFrmCnt                      0x4
#define     counter_id_TxPauseFrmCnt                      0x5
#define     counter_id_TxCrcErrFrmCnt                     0x6
#define     counter_id_TxOvSizeFrmCnt                     0x7
#define     counter_id_TxSingleColFrm                     0x8
#define     counter_id_TxMultiColFrm                      0x9
#define     counter_id_TxLateColFrm                       0xa
#define     counter_id_TxExessColFrm                      0xb
#define     counter_id_TxStatsFrm64Oct                    0xd
#define     counter_id_TxStatsFrm65to127Oct               0xe
#define     counter_id_TxStatsFrm128to255Oct              0xf
#define     counter_id_TxStatsFrm256to511Oct              0x10
#define     counter_id_TxStatsFrm512to1023Oct             0x11
#define     counter_id_TxStatsFrm1024to1518Oct            0x12
#define     counter_id_TxStatsFrm1519to2100Oct            0x13
#define     counter_id_TxStatsFrm2101to9200Oct            0x14
#define     counter_id_TxStatsFrm9201toMaxOct             0x15
#define     counter_id_TxByteCount_Lo                     0x16
#define     counter_id_TxByteCount_Hi                     0x17




#define NI_TOP_NI_TXMIB_DATA1                    0xf0010194
#define NI_TOP_NI_TXMIB_DATA1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cnt_val_hi           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cnt_val_hi           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXMIB_DATA1_t;





#define NI_TOP_NI_TXMIB_DATA0                    0xf0010198
#define NI_TOP_NI_TXMIB_DATA0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cnt_val_lo           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cnt_val_lo           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXMIB_DATA0_t;





#define NI_TOP_NI_TXEM_CRCERR_ACCESS             0xf001019c
#define NI_TOP_NI_TXEM_CRCERR_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 port_id              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 port_id              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_CRCERR_ACCESS_t;





#define NI_TOP_NI_TXEM_CRCERR_DATA               0xf00101a0
#define NI_TOP_NI_TXEM_CRCERR_DATA_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 txem_crcerrcnt       : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_crcerrcnt       : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_CRCERR_DATA_t;





#define NI_TOP_NI_MAL_PKT_DROPCNT                0xf00101a4
#define NI_TOP_NI_MAL_PKT_DROPCNT_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mal_packets_dropped  : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mal_packets_dropped  : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MAL_PKT_DROPCNT_t;





#define NI_TOP_NI_MAL_PKT_DROPCNT_CFG            0xf00101a8
#define NI_TOP_NI_MAL_PKT_DROPCNT_CFG_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  2 ;
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 16 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 debug_mode           :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 op_code              :  2 ; /* bits 29:28 */
    cs_uint32 rsrvd3               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_MAL_PKT_DROPCNT_CFG_t;





#define NI_TOP_NI_CPUXRAM_ADRCFG_RX_0            0xf00101ac
#define NI_TOP_NI_CPUXRAM_ADRCFG_RX_0_STRIDE     4
#define NI_TOP_NI_CPUXRAM_ADRCFG_RX_0_COUNT      9
#define NI_TOP_NI_CPUXRAM_ADRCFG_RX_0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 rx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_base_addr         : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_base_addr         : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 rx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ADRCFG_RX_0_t;


    
    
    
    
    
    
    
    



#define NI_TOP_NI_CPUXRAM_ADRCFG_TX_0            0xf00101d0
#define NI_TOP_NI_CPUXRAM_ADRCFG_TX_0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 tx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 tx_base_addr         : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 tx_base_addr         : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 tx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ADRCFG_TX_0_t;





#define NI_TOP_NI_CPUXRAM_ADRCFG_TX_1            0xf00101d4
#define NI_TOP_NI_CPUXRAM_ADRCFG_TX_1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 tx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 tx_base_addr         : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 tx_base_addr         : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 tx_top_addr          : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ADRCFG_TX_1_t;





#define NI_TOP_NI_CPUXRAM_CFG                    0xf00101d8
#define NI_TOP_NI_CPUXRAM_CFG_dft                0x8a00c5ff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 xram_arb_auto_prior  :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 xram_pc_wrapcnt      :  4 ; /* bits 27:24 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_dma_fifo_srst   :  1 ; /* bits 22:22 */
    cs_uint32 xram_rx_mgmtfifo_srst :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_pcachefifo_srst :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_qmfifo_srst  :  1 ; /* bits 19:19 */
    cs_uint32 xram_cntr_op_code    :  2 ; /* bits 18:17 */
    cs_uint32 xram_cntr_debug_mode :  1 ; /* bits 16:16 */
    cs_uint32 xram_mgmt_promisc_mode :  2 ; /* bits 15:14 */
    cs_uint32 xram_mgmt_term_large_pkt :  1 ; /* bits 13:13 */
    cs_uint32 xram_mgmt_dis_drop_ovsz_pkt :  1 ; /* bits 12:12 */
    cs_uint32 rx_x_drop_err_pkt    :  1 ; /* bits 11:11 */
    cs_uint32 tx_1_cpu_pkt_dis     :  1 ; /* bits 10:10 */
    cs_uint32 tx_0_cpu_pkt_dis     :  1 ; /* bits 9:9 */
    cs_uint32 rx_8_cpu_pkt_dis     :  1 ; /* bits 8:8 */
    cs_uint32 rx_7_cpu_pkt_dis     :  1 ; /* bits 7:7 */
    cs_uint32 rx_6_cpu_pkt_dis     :  1 ; /* bits 6:6 */
    cs_uint32 rx_5_cpu_pkt_dis     :  1 ; /* bits 5:5 */
    cs_uint32 rx_4_cpu_pkt_dis     :  1 ; /* bits 4:4 */
    cs_uint32 rx_3_cpu_pkt_dis     :  1 ; /* bits 3:3 */
    cs_uint32 rx_2_cpu_pkt_dis     :  1 ; /* bits 2:2 */
    cs_uint32 rx_1_cpu_pkt_dis     :  1 ; /* bits 1:1 */
    cs_uint32 rx_0_cpu_pkt_dis     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rx_0_cpu_pkt_dis     :  1 ; /* bits 0:0 */
    cs_uint32 rx_1_cpu_pkt_dis     :  1 ; /* bits 1:1 */
    cs_uint32 rx_2_cpu_pkt_dis     :  1 ; /* bits 2:2 */
    cs_uint32 rx_3_cpu_pkt_dis     :  1 ; /* bits 3:3 */
    cs_uint32 rx_4_cpu_pkt_dis     :  1 ; /* bits 4:4 */
    cs_uint32 rx_5_cpu_pkt_dis     :  1 ; /* bits 5:5 */
    cs_uint32 rx_6_cpu_pkt_dis     :  1 ; /* bits 6:6 */
    cs_uint32 rx_7_cpu_pkt_dis     :  1 ; /* bits 7:7 */
    cs_uint32 rx_8_cpu_pkt_dis     :  1 ; /* bits 8:8 */
    cs_uint32 tx_0_cpu_pkt_dis     :  1 ; /* bits 9:9 */
    cs_uint32 tx_1_cpu_pkt_dis     :  1 ; /* bits 10:10 */
    cs_uint32 rx_x_drop_err_pkt    :  1 ; /* bits 11:11 */
    cs_uint32 xram_mgmt_dis_drop_ovsz_pkt :  1 ; /* bits 12:12 */
    cs_uint32 xram_mgmt_term_large_pkt :  1 ; /* bits 13:13 */
    cs_uint32 xram_mgmt_promisc_mode :  2 ; /* bits 15:14 */
    cs_uint32 xram_cntr_debug_mode :  1 ; /* bits 16:16 */
    cs_uint32 xram_cntr_op_code    :  2 ; /* bits 18:17 */
    cs_uint32 xram_rx_qmfifo_srst  :  1 ; /* bits 19:19 */
    cs_uint32 xram_rx_pcachefifo_srst :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_mgmtfifo_srst :  1 ; /* bits 21:21 */
    cs_uint32 xram_dma_fifo_srst   :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_pc_wrapcnt      :  4 ; /* bits 27:24 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 xram_arb_auto_prior  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CFG_t;





#define NI_TOP_NI_CPUXRAM_PTCAL0                 0xf00101dc
#define NI_TOP_NI_CPUXRAM_PTCAL0_dft             0x21043210




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd8               :  1 ;
    cs_uint32 xram_pc_ts7          :  3 ; /* bits 30:28 */
    cs_uint32 rsrvd7               :  1 ;
    cs_uint32 xram_pc_ts6          :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd6               :  1 ;
    cs_uint32 xram_pc_ts5          :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd5               :  1 ;
    cs_uint32 xram_pc_ts4          :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd4               :  1 ;
    cs_uint32 xram_pc_ts3          :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 xram_pc_ts2          :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_pc_ts1          :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_pc_ts0          :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_pc_ts0          :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_pc_ts1          :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_pc_ts2          :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 xram_pc_ts3          :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd4               :  1 ;
    cs_uint32 xram_pc_ts4          :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd5               :  1 ;
    cs_uint32 xram_pc_ts5          :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd6               :  1 ;
    cs_uint32 xram_pc_ts6          :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd7               :  1 ;
    cs_uint32 xram_pc_ts7          :  3 ; /* bits 30:28 */
    cs_uint32 rsrvd8               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PTCAL0_t;





#define NI_TOP_NI_CPUXRAM_PTCAL1                 0xf00101e0
#define NI_TOP_NI_CPUXRAM_PTCAL1_dft             0x00000043




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd8               :  1 ;
    cs_uint32 xram_pc_ts15         :  3 ; /* bits 30:28 */
    cs_uint32 rsrvd7               :  1 ;
    cs_uint32 xram_pc_ts14         :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd6               :  1 ;
    cs_uint32 xram_pc_ts13         :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd5               :  1 ;
    cs_uint32 xram_pc_ts12         :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd4               :  1 ;
    cs_uint32 xram_pc_ts11         :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 xram_pc_ts10         :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_pc_ts9          :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_pc_ts8          :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_pc_ts8          :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_pc_ts9          :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_pc_ts10         :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 xram_pc_ts11         :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd4               :  1 ;
    cs_uint32 xram_pc_ts12         :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd5               :  1 ;
    cs_uint32 xram_pc_ts13         :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd6               :  1 ;
    cs_uint32 xram_pc_ts14         :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd7               :  1 ;
    cs_uint32 xram_pc_ts15         :  3 ; /* bits 30:28 */
    cs_uint32 rsrvd8               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PTCAL1_t;





#define NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0           0xf00101e4
#define NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0_STRIDE    4
#define NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0_COUNT     8
#define NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0_dft       0x000000b4




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 16 ;
    cs_uint32 xram_sch_rdy_mode    :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 xram_sch_rdy_free_thld : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_sch_rdy_free_thld : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 xram_sch_rdy_mode    :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd2               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0_t;


    
    
    
    
    
    
    



#define NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0           0xf0010204
#define NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0_STRIDE    24
#define NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0_COUNT     9
#define NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 pkt_rd_ptr           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_rd_ptr           : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0_t;





#define NI_TOP_NI_CPUXRAM_CPU_STA_RX_0           0xf0010208
#define NI_TOP_NI_CPUXRAM_CPU_STA_RX_0_STRIDE    24
#define NI_TOP_NI_CPUXRAM_CPU_STA_RX_0_COUNT     9
#define NI_TOP_NI_CPUXRAM_CPU_STA_RX_0_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 16 ;
    cs_uint32 int_colsc_thresh_reached :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 pkt_wr_ptr           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_wr_ptr           : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 int_colsc_thresh_reached :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd2               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CPU_STA_RX_0_t;





#define NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0        0xf001020c
#define NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0_STRIDE 24
#define NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0_COUNT  9
#define NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 int_colsc_en         :  1 ; /* bits 31:31 */
    cs_uint32 int_colsc_first_en   :  1 ; /* bits 30:30 */
    cs_uint32 int_colsc_pkt        : 10 ; /* bits 29:20 */
    cs_uint32 int_colsc_dly_time   : 20 ; /* bits 19:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_colsc_dly_time   : 20 ; /* bits 19:0 */
    cs_uint32 int_colsc_pkt        : 10 ; /* bits 29:20 */
    cs_uint32 int_colsc_first_en   :  1 ; /* bits 30:30 */
    cs_uint32 int_colsc_en         :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0_t;





#define NI_TOP_NI_CPUXRAM_PKT_CNT_0              0xf0010210
#define NI_TOP_NI_CPUXRAM_PKT_CNT_0_STRIDE       24
#define NI_TOP_NI_CPUXRAM_PKT_CNT_0_COUNT        9
#define NI_TOP_NI_CPUXRAM_PKT_CNT_0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 pkt_to_xram          : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_to_xram          : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PKT_CNT_0_t;





#define NI_TOP_NI_CPUXRAM_BYT_CNT_0              0xf0010214
#define NI_TOP_NI_CPUXRAM_BYT_CNT_0_STRIDE       24
#define NI_TOP_NI_CPUXRAM_BYT_CNT_0_COUNT        9
#define NI_TOP_NI_CPUXRAM_BYT_CNT_0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 byt_to_xram          : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 byt_to_xram          : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_BYT_CNT_0_t;





#define NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0          0xf0010218
#define NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0_STRIDE   24
#define NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0_COUNT    9
#define NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 pkt_drop_err         : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_err         : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_PTP       0xf00102dc
#define NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_PTP_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 pkt_drop_ovrun_ptp   : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_ovrun_ptp   : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_PTP_t;





#define NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_MGMT      0xf00102e0
#define NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_MGMT_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 pkt_drop_ovrun_mgmt  : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_ovrun_mgmt  : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_MGMT_t;





#define NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0           0xf00102e4
#define NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0_STRIDE    8
#define NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0_COUNT     2
#define NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 pkt_wr_ptr           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_wr_ptr           : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0_t;





#define NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0          0xf00102e8
#define NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0_STRIDE   8
#define NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0_COUNT    2
#define NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 pkt_rd_ptr           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_rd_ptr           : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0_t;


    
    



#define NI_TOP_NI_DMA_PKT_CNT                    0xf00102f4
#define NI_TOP_NI_DMA_PKT_CNT_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 dma_pkt_to_cpu       : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dma_pkt_to_cpu       : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_DMA_PKT_CNT_t;





#define NI_TOP_NI_DMA_BYTE_CNT                   0xf00102f8
#define NI_TOP_NI_DMA_BYTE_CNT_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dma_byte_to_cpu      : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dma_byte_to_cpu      : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_DMA_BYTE_CNT_t;





#define NI_TOP_NI_HW_TS_CNTR                     0xf00102fc
#define NI_TOP_NI_HW_TS_CNTR_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ptp_hw_ts            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ptp_hw_ts            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_HW_TS_CNTR_t;





#define NI_TOP_NI_PTP_SWCFG_ACCESS               0xf0010300
#define NI_TOP_NI_PTP_SWCFG_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PTP_SWCFG_ACCESS_t;

#define     address_PTP_ASYM_CFG_0                        0x0
#define     address_PTP_ASYM_CFG_1                        0x1
#define     address_PTP_ASYM_CFG_2                        0x2
#define     address_PTP_ASYM_CFG_3                        0x3
#define     address_PTP_SWCOR_CFG                         0x4




#define NI_TOP_NI_PTP_SWCFG_DATA1                0xf0010304
#define NI_TOP_NI_PTP_SWCFG_DATA1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cfg_hi               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cfg_hi               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PTP_SWCFG_DATA1_t;





#define NI_TOP_NI_PTP_SWCFG_DATA0                0xf0010308
#define NI_TOP_NI_PTP_SWCFG_DATA0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cfg_lo               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cfg_lo               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PTP_SWCFG_DATA0_t;





#define NI_TOP_NI_DEBUG_1                        0xf001030c
#define NI_TOP_NI_DEBUG_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ptp_hw_cnt_dbg       :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 hd_backoff_dbg       :  1 ; /* bits 10:10 */
    cs_uint32 hd_backoff_cnt       : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hd_backoff_cnt       : 10 ; /* bits 9:0 */
    cs_uint32 hd_backoff_dbg       :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 ptp_hw_cnt_dbg       :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_DEBUG_1_t;





#define NI_TOP_NI_DEBUG_2                        0xf0010310
#define NI_TOP_NI_DEBUG_2_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_ptp_hw_cnt       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_ptp_hw_cnt       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_DEBUG_2_t;





#define NI_TOP_NI_SPARE                          0xf0010314
#define NI_TOP_NI_SPARE_dft                      0x0000ff00




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 VALUE                : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 VALUE                : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_SPARE_t;





#define NI_TOP_NI_SPARESAMPLE                    0xf0010318
#define NI_TOP_NI_SPARESAMPLE_dft                0x0000ff00




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 VALUE                : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 VALUE                : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_SPARESAMPLE_t;





#define NI_TOP_NI_FPGAA_ID                       0xf001031c
#define NI_TOP_NI_FPGAA_ID_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FPGAA_ID             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FPGAA_ID             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_FPGAA_ID_t;





#define NI_TOP_NI_PORT_0_INTERRUPT_0             0xf0010320
#define NI_TOP_NI_PORT_0_INTERRUPT_0_STRIDE      8
#define NI_TOP_NI_PORT_0_INTERRUPT_0_COUNT       8
#define NI_TOP_NI_PORT_0_INTERRUPT_0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rxcntrl_rd_idleI     :  1 ; /* bits 8:8 */
    cs_uint32 txem_crcerr_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    cs_uint32 rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    cs_uint32 rxcntrl_usage_exceedI :  1 ; /* bits 4:4 */
    cs_uint32 rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    cs_uint32 txfifo_overrunI      :  1 ; /* bits 2:2 */
    cs_uint32 txfifo_underrunI     :  1 ; /* bits 1:1 */
    cs_uint32 link_stat_chgI       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 link_stat_chgI       :  1 ; /* bits 0:0 */
    cs_uint32 txfifo_underrunI     :  1 ; /* bits 1:1 */
    cs_uint32 txfifo_overrunI      :  1 ; /* bits 2:2 */
    cs_uint32 rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    cs_uint32 rxcntrl_usage_exceedI :  1 ; /* bits 4:4 */
    cs_uint32 rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    cs_uint32 txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    cs_uint32 txem_crcerr_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 rxcntrl_rd_idleI     :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PORT_0_INTERRUPT_0_t;





#define NI_TOP_NI_PORT_0_INTENABLE_0             0xf0010324
#define NI_TOP_NI_PORT_0_INTENABLE_0_STRIDE      8
#define NI_TOP_NI_PORT_0_INTENABLE_0_COUNT       8
#define NI_TOP_NI_PORT_0_INTENABLE_0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rxcntrl_rd_idleIE    :  1 ; /* bits 8:8 */
    cs_uint32 txem_crcerr_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    cs_uint32 rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    cs_uint32 rxcntrl_usage_exceedIE :  1 ; /* bits 4:4 */
    cs_uint32 rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    cs_uint32 txfifo_overrunIE     :  1 ; /* bits 2:2 */
    cs_uint32 txfifo_underrunIE    :  1 ; /* bits 1:1 */
    cs_uint32 link_stat_chgIE      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 link_stat_chgIE      :  1 ; /* bits 0:0 */
    cs_uint32 txfifo_underrunIE    :  1 ; /* bits 1:1 */
    cs_uint32 txfifo_overrunIE     :  1 ; /* bits 2:2 */
    cs_uint32 rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    cs_uint32 rxcntrl_usage_exceedIE :  1 ; /* bits 4:4 */
    cs_uint32 rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    cs_uint32 txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    cs_uint32 txem_crcerr_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 rxcntrl_rd_idleIE    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PORT_0_INTENABLE_0_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_RXFIFO_INTERRUPT_0             0xf0010360
#define NI_TOP_NI_RXFIFO_INTERRUPT_0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rx_fifo_voq_ecc_corr_errI :  1 ; /* bits 13:13 */
    cs_uint32 rx_fifo_voq_ecc_errI :  1 ; /* bits 12:12 */
    cs_uint32 mcal_pkt_dropI       :  1 ; /* bits 11:11 */
    cs_uint32 mal_drop_pkt_cnt_msb_setI :  1 ; /* bits 10:10 */
    cs_uint32 rx_fifo_ll_ecc_corr_errI :  1 ; /* bits 9:9 */
    cs_uint32 rx_fifo_ll_ecc_errI  :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_eop_bf_flI   :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_noeop_af_flI :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_nosopI       :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeopI       :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_congI        :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_voq_fullI    :  1 ; /* bits 2:2 */
    cs_uint32 rxfifo_overrunI      :  1 ; /* bits 1:1 */
    cs_uint32 rxfifo_fullI         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxfifo_fullI         :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_overrunI      :  1 ; /* bits 1:1 */
    cs_uint32 rx_fifo_voq_fullI    :  1 ; /* bits 2:2 */
    cs_uint32 rx_fifo_congI        :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_noeopI       :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_nosopI       :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeop_af_flI :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_eop_bf_flI   :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_ll_ecc_errI  :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_ll_ecc_corr_errI :  1 ; /* bits 9:9 */
    cs_uint32 mal_drop_pkt_cnt_msb_setI :  1 ; /* bits 10:10 */
    cs_uint32 mcal_pkt_dropI       :  1 ; /* bits 11:11 */
    cs_uint32 rx_fifo_voq_ecc_errI :  1 ; /* bits 12:12 */
    cs_uint32 rx_fifo_voq_ecc_corr_errI :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_INTERRUPT_0_t;





#define NI_TOP_NI_RXFIFO_INTENABLE_0             0xf0010364
#define NI_TOP_NI_RXFIFO_INTENABLE_0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rx_fifo_voq_ecc_corr_errIE :  1 ; /* bits 13:13 */
    cs_uint32 rx_fifo_voq_ecc_errIE :  1 ; /* bits 12:12 */
    cs_uint32 mcal_pkt_dropIE      :  1 ; /* bits 11:11 */
    cs_uint32 mal_drop_pkt_cnt_msb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 rx_fifo_ll_ecc_corr_errIE :  1 ; /* bits 9:9 */
    cs_uint32 rx_fifo_ll_errIE     :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_eop_bf_flIE  :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_noeop_af_flIE :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_nosopIE      :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeopIE      :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_congIE       :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_voq_fullIE   :  1 ; /* bits 2:2 */
    cs_uint32 rxfifo_overrunIE     :  1 ; /* bits 1:1 */
    cs_uint32 rxfifo_fullIE        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxfifo_fullIE        :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_overrunIE     :  1 ; /* bits 1:1 */
    cs_uint32 rx_fifo_voq_fullIE   :  1 ; /* bits 2:2 */
    cs_uint32 rx_fifo_congIE       :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_noeopIE      :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_nosopIE      :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeop_af_flIE :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_eop_bf_flIE  :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_ll_errIE     :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_ll_ecc_corr_errIE :  1 ; /* bits 9:9 */
    cs_uint32 mal_drop_pkt_cnt_msb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 mcal_pkt_dropIE      :  1 ; /* bits 11:11 */
    cs_uint32 rx_fifo_voq_ecc_errIE :  1 ; /* bits 12:12 */
    cs_uint32 rx_fifo_voq_ecc_corr_errIE :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_INTENABLE_0_t;





#define NI_TOP_NI_TXEM_INTERRUPT_0               0xf0010368
#define NI_TOP_NI_TXEM_INTERRUPT_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 txem_ptp_v6csum0_errI :  1 ; /* bits 9:9 */
    cs_uint32 mc_indx_lkup_mem_perrI :  1 ; /* bits 8:8 */
    cs_uint32 tx_voq_lkup_mem_perrI :  1 ; /* bits 7:7 */
    cs_uint32 txem_ptp_cachevoq_errI :  1 ; /* bits 6:6 */
    cs_uint32 txem_ptp_voqchg_errI :  1 ; /* bits 5:5 */
    cs_uint32 rxmib_fifo_ovfI      :  1 ; /* bits 4:4 */
    cs_uint32 txmib_fifo_ovfI      :  1 ; /* bits 3:3 */
    cs_uint32 txrm_cntovfI         :  1 ; /* bits 2:2 */
    cs_uint32 txem_crc_errI        :  1 ; /* bits 1:1 */
    cs_uint32 txem_ififo_ovfI      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_ififo_ovfI      :  1 ; /* bits 0:0 */
    cs_uint32 txem_crc_errI        :  1 ; /* bits 1:1 */
    cs_uint32 txrm_cntovfI         :  1 ; /* bits 2:2 */
    cs_uint32 txmib_fifo_ovfI      :  1 ; /* bits 3:3 */
    cs_uint32 rxmib_fifo_ovfI      :  1 ; /* bits 4:4 */
    cs_uint32 txem_ptp_voqchg_errI :  1 ; /* bits 5:5 */
    cs_uint32 txem_ptp_cachevoq_errI :  1 ; /* bits 6:6 */
    cs_uint32 tx_voq_lkup_mem_perrI :  1 ; /* bits 7:7 */
    cs_uint32 mc_indx_lkup_mem_perrI :  1 ; /* bits 8:8 */
    cs_uint32 txem_ptp_v6csum0_errI :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_INTERRUPT_0_t;





#define NI_TOP_NI_TXEM_INTENABLE_0               0xf001036c
#define NI_TOP_NI_TXEM_INTENABLE_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 txem_ptp_v6csum0_errIE :  1 ; /* bits 9:9 */
    cs_uint32 mc_indx_lkup_mem_perrIE :  1 ; /* bits 8:8 */
    cs_uint32 tx_voq_lkup_mem_perrIE :  1 ; /* bits 7:7 */
    cs_uint32 txem_ptp_cachevoq_errIE :  1 ; /* bits 6:6 */
    cs_uint32 txem_ptp_voqchg_errIE :  1 ; /* bits 5:5 */
    cs_uint32 rxmib_fifo_ovfIE     :  1 ; /* bits 4:4 */
    cs_uint32 txmib_fifo_ovfIE     :  1 ; /* bits 3:3 */
    cs_uint32 txrm_cntovfIE        :  1 ; /* bits 2:2 */
    cs_uint32 txem_crc_errIE       :  1 ; /* bits 1:1 */
    cs_uint32 txem_ififo_ovfIE     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_ififo_ovfIE     :  1 ; /* bits 0:0 */
    cs_uint32 txem_crc_errIE       :  1 ; /* bits 1:1 */
    cs_uint32 txrm_cntovfIE        :  1 ; /* bits 2:2 */
    cs_uint32 txmib_fifo_ovfIE     :  1 ; /* bits 3:3 */
    cs_uint32 rxmib_fifo_ovfIE     :  1 ; /* bits 4:4 */
    cs_uint32 txem_ptp_voqchg_errIE :  1 ; /* bits 5:5 */
    cs_uint32 txem_ptp_cachevoq_errIE :  1 ; /* bits 6:6 */
    cs_uint32 tx_voq_lkup_mem_perrIE :  1 ; /* bits 7:7 */
    cs_uint32 mc_indx_lkup_mem_perrIE :  1 ; /* bits 8:8 */
    cs_uint32 txem_ptp_v6csum0_errIE :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_INTENABLE_0_t;





#define NI_TOP_NI_PC0_INTERRUPT_0                0xf0010370
#define NI_TOP_NI_PC0_INTERRUPT_0_STRIDE         8
#define NI_TOP_NI_PC0_INTERRUPT_0_COUNT          3
#define NI_TOP_NI_PC0_INTERRUPT_0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 framelenmismatchI    :  1 ; /* bits 8:8 */
    cs_uint32 datamismatchI        :  1 ; /* bits 7:7 */
    cs_uint32 seqnummismatchI      :  1 ; /* bits 6:6 */
    cs_uint32 typefieldmismatchI   :  1 ; /* bits 5:5 */
    cs_uint32 vlan2fieldmismatchI  :  1 ; /* bits 4:4 */
    cs_uint32 vlan1fieldmismatchI  :  1 ; /* bits 3:3 */
    cs_uint32 srcaddrmismatchI     :  1 ; /* bits 2:2 */
    cs_uint32 dstaddrmismatchI     :  1 ; /* bits 1:1 */
    cs_uint32 dchkoutofsyncI       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dchkoutofsyncI       :  1 ; /* bits 0:0 */
    cs_uint32 dstaddrmismatchI     :  1 ; /* bits 1:1 */
    cs_uint32 srcaddrmismatchI     :  1 ; /* bits 2:2 */
    cs_uint32 vlan1fieldmismatchI  :  1 ; /* bits 3:3 */
    cs_uint32 vlan2fieldmismatchI  :  1 ; /* bits 4:4 */
    cs_uint32 typefieldmismatchI   :  1 ; /* bits 5:5 */
    cs_uint32 seqnummismatchI      :  1 ; /* bits 6:6 */
    cs_uint32 datamismatchI        :  1 ; /* bits 7:7 */
    cs_uint32 framelenmismatchI    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_INTERRUPT_0_t;





#define NI_TOP_NI_PC0_INTENABLE_0                0xf0010374
#define NI_TOP_NI_PC0_INTENABLE_0_STRIDE         8
#define NI_TOP_NI_PC0_INTENABLE_0_COUNT          3
#define NI_TOP_NI_PC0_INTENABLE_0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 framelenmismatchE    :  1 ; /* bits 8:8 */
    cs_uint32 datamismatchE        :  1 ; /* bits 7:7 */
    cs_uint32 seqnummismatchE      :  1 ; /* bits 6:6 */
    cs_uint32 typefieldmismatchE   :  1 ; /* bits 5:5 */
    cs_uint32 vlan2fieldmismatchE  :  1 ; /* bits 4:4 */
    cs_uint32 vlan1fieldmismatchE  :  1 ; /* bits 3:3 */
    cs_uint32 srcaddrmismatchE     :  1 ; /* bits 2:2 */
    cs_uint32 dstaddrmismatchE     :  1 ; /* bits 1:1 */
    cs_uint32 dchkoutofsyncE       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dchkoutofsyncE       :  1 ; /* bits 0:0 */
    cs_uint32 dstaddrmismatchE     :  1 ; /* bits 1:1 */
    cs_uint32 srcaddrmismatchE     :  1 ; /* bits 2:2 */
    cs_uint32 vlan1fieldmismatchE  :  1 ; /* bits 3:3 */
    cs_uint32 vlan2fieldmismatchE  :  1 ; /* bits 4:4 */
    cs_uint32 typefieldmismatchE   :  1 ; /* bits 5:5 */
    cs_uint32 seqnummismatchE      :  1 ; /* bits 6:6 */
    cs_uint32 datamismatchE        :  1 ; /* bits 7:7 */
    cs_uint32 framelenmismatchE    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_INTENABLE_0_t;


    
    
    
    



#define NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_0       0xf0010388
#define NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setI :  1 ; /* bits 31:31 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setI :  1 ; /* bits 30:30 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setI :  1 ; /* bits 29:29 */
    cs_uint32 byt_to_xram_8_cntmsb_setI :  1 ; /* bits 28:28 */
    cs_uint32 byt_to_xram_7_cntmsb_setI :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_6_cntmsb_setI :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_5_cntmsb_setI :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_4_cntmsb_setI :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_3_cntmsb_setI :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_2_cntmsb_setI :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_1_cntmsb_setI :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_0_cntmsb_setI :  1 ; /* bits 20:20 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setI :  1 ; /* bits 19:19 */
    cs_uint32 pkt_to_xram_8_cntmsb_setI :  1 ; /* bits 18:18 */
    cs_uint32 pkt_to_xram_7_cntmsb_setI :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_6_cntmsb_setI :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_5_cntmsb_setI :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_4_cntmsb_setI :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_3_cntmsb_setI :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_2_cntmsb_setI :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_1_cntmsb_setI :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_0_cntmsb_setI :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_drop_err_8_cntmsb_setI :  1 ; /* bits 8:8 */
    cs_uint32 pkt_drop_err_7_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_6_cntmsb_setI :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_5_cntmsb_setI :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_4_cntmsb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_3_cntmsb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_2_cntmsb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_1_cntmsb_setI :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_0_cntmsb_setI :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_err_0_cntmsb_setI :  1 ; /* bits 0:0 */
    cs_uint32 pkt_drop_err_1_cntmsb_setI :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_2_cntmsb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_3_cntmsb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_4_cntmsb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_5_cntmsb_setI :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_6_cntmsb_setI :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_7_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_8_cntmsb_setI :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_to_xram_0_cntmsb_setI :  1 ; /* bits 10:10 */
    cs_uint32 pkt_to_xram_1_cntmsb_setI :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_2_cntmsb_setI :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_3_cntmsb_setI :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_4_cntmsb_setI :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_5_cntmsb_setI :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_6_cntmsb_setI :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_7_cntmsb_setI :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_8_cntmsb_setI :  1 ; /* bits 18:18 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setI :  1 ; /* bits 19:19 */
    cs_uint32 byt_to_xram_0_cntmsb_setI :  1 ; /* bits 20:20 */
    cs_uint32 byt_to_xram_1_cntmsb_setI :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_2_cntmsb_setI :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_3_cntmsb_setI :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_4_cntmsb_setI :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_5_cntmsb_setI :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_6_cntmsb_setI :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_7_cntmsb_setI :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_8_cntmsb_setI :  1 ; /* bits 28:28 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setI :  1 ; /* bits 29:29 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setI :  1 ; /* bits 30:30 */
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setI :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_0_t;





#define NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_0       0xf001038c
#define NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setIE :  1 ; /* bits 31:31 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setIE :  1 ; /* bits 30:30 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setIE :  1 ; /* bits 29:29 */
    cs_uint32 byt_to_xram_8_cntmsb_setIE :  1 ; /* bits 28:28 */
    cs_uint32 byt_to_xram_7_cntmsb_setIE :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_6_cntmsb_setIE :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_5_cntmsb_setIE :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_4_cntmsb_setIE :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_3_cntmsb_setIE :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_2_cntmsb_setIE :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_1_cntmsb_setIE :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_0_cntmsb_setIE :  1 ; /* bits 20:20 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setIE :  1 ; /* bits 19:19 */
    cs_uint32 pkt_to_xram_8_cntmsb_setIE :  1 ; /* bits 18:18 */
    cs_uint32 pkt_to_xram_7_cntmsb_setIE :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_6_cntmsb_setIE :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_5_cntmsb_setIE :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_4_cntmsb_setIE :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_3_cntmsb_setIE :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_2_cntmsb_setIE :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_1_cntmsb_setIE :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_0_cntmsb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_drop_err_8_cntmsb_setIE :  1 ; /* bits 8:8 */
    cs_uint32 pkt_drop_err_7_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_6_cntmsb_setIE :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_5_cntmsb_setIE :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_4_cntmsb_setIE :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_3_cntmsb_setIE :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_2_cntmsb_setIE :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_1_cntmsb_setIE :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_0_cntmsb_setIE :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_err_0_cntmsb_setIE :  1 ; /* bits 0:0 */
    cs_uint32 pkt_drop_err_1_cntmsb_setIE :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_2_cntmsb_setIE :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_3_cntmsb_setIE :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_4_cntmsb_setIE :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_5_cntmsb_setIE :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_6_cntmsb_setIE :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_7_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_8_cntmsb_setIE :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_to_xram_0_cntmsb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 pkt_to_xram_1_cntmsb_setIE :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_2_cntmsb_setIE :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_3_cntmsb_setIE :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_4_cntmsb_setIE :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_5_cntmsb_setIE :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_6_cntmsb_setIE :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_7_cntmsb_setIE :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_8_cntmsb_setIE :  1 ; /* bits 18:18 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setIE :  1 ; /* bits 19:19 */
    cs_uint32 byt_to_xram_0_cntmsb_setIE :  1 ; /* bits 20:20 */
    cs_uint32 byt_to_xram_1_cntmsb_setIE :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_2_cntmsb_setIE :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_3_cntmsb_setIE :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_4_cntmsb_setIE :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_5_cntmsb_setIE :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_6_cntmsb_setIE :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_7_cntmsb_setIE :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_8_cntmsb_setIE :  1 ; /* bits 28:28 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setIE :  1 ; /* bits 29:29 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setIE :  1 ; /* bits 30:30 */
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setIE :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_0_t;





#define NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_0        0xf0010390
#define NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 dma_fifo_overrunI    :  1 ; /* bits 23:23 */
    cs_uint32 xram_rx_mgmtfifo_overrunI :  1 ; /* bits 22:22 */
    cs_uint32 xram_rx_ptpfifo_overrunI :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_qmfifo_overrunI :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_8_dis_pktI   :  1 ; /* bits 18:18 */
    cs_uint32 xram_rx_7_dis_pktI   :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_6_dis_pktI   :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_5_dis_pktI   :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_4_dis_pktI   :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_3_dis_pktI   :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_2_dis_pktI   :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_1_dis_pktI   :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_0_dis_pktI   :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_8_ptrbkupI   :  1 ; /* bits 8:8 */
    cs_uint32 xram_rx_7_ptrbkupI   :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_6_ptrbkupI   :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_5_ptrbkupI   :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_4_ptrbkupI   :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_3_ptrbkupI   :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_2_ptrbkupI   :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_1_ptrbkupI   :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_0_ptrbkupI   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_0_ptrbkupI   :  1 ; /* bits 0:0 */
    cs_uint32 xram_rx_1_ptrbkupI   :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_2_ptrbkupI   :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_3_ptrbkupI   :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_4_ptrbkupI   :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_5_ptrbkupI   :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_6_ptrbkupI   :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_7_ptrbkupI   :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_8_ptrbkupI   :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_0_dis_pktI   :  1 ; /* bits 10:10 */
    cs_uint32 xram_rx_1_dis_pktI   :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_2_dis_pktI   :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_3_dis_pktI   :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_4_dis_pktI   :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_5_dis_pktI   :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_6_dis_pktI   :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_7_dis_pktI   :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_8_dis_pktI   :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_qmfifo_overrunI :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_ptpfifo_overrunI :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_mgmtfifo_overrunI :  1 ; /* bits 22:22 */
    cs_uint32 dma_fifo_overrunI    :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_0_t;





#define NI_TOP_NI_CPUXRAM_ERR_INTENABLE_0        0xf0010394
#define NI_TOP_NI_CPUXRAM_ERR_INTENABLE_0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 dma_fifo_overrunIE   :  1 ; /* bits 23:23 */
    cs_uint32 xram_rx_mgmtfifo_overrunIE :  1 ; /* bits 22:22 */
    cs_uint32 xram_rx_ptpfifo_overrunIE :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_qmfifo_overrunIE :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_8_dis_pktIE  :  1 ; /* bits 18:18 */
    cs_uint32 xram_rx_7_dis_pktIE  :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_6_dis_pktIE  :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_5_dis_pktIE  :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_4_dis_pktIE  :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_3_dis_pktIE  :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_2_dis_pktIE  :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_1_dis_pktIE  :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_0_dis_pktIE  :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_8_ptrbkupIE  :  1 ; /* bits 8:8 */
    cs_uint32 xram_rx_7_ptrbkupIE  :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_6_ptrbkupIE  :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_5_ptrbkupIE  :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_4_ptrbkupIE  :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_3_ptrbkupIE  :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_2_ptrbkupIE  :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_1_ptrbkupIE  :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_0_ptrbkupIE  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_0_ptrbkupIE  :  1 ; /* bits 0:0 */
    cs_uint32 xram_rx_1_ptrbkupIE  :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_2_ptrbkupIE  :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_3_ptrbkupIE  :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_4_ptrbkupIE  :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_5_ptrbkupIE  :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_6_ptrbkupIE  :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_7_ptrbkupIE  :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_8_ptrbkupIE  :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_0_dis_pktIE  :  1 ; /* bits 10:10 */
    cs_uint32 xram_rx_1_dis_pktIE  :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_2_dis_pktIE  :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_3_dis_pktIE  :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_4_dis_pktIE  :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_5_dis_pktIE  :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_6_dis_pktIE  :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_7_dis_pktIE  :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_8_dis_pktIE  :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_qmfifo_overrunIE :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_ptpfifo_overrunIE :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_mgmtfifo_overrunIE :  1 ; /* bits 22:22 */
    cs_uint32 dma_fifo_overrunIE   :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ERR_INTENABLE_0_t;





#define NI_TOP_NI_INTERRUPT_0                    0xf0010398
#define NI_TOP_NI_INTERRUPT_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 cpuxram_int_stat_err :  1 ; /* bits 14:14 */
    cs_uint32 cpuxram_int_stat_cntr :  1 ; /* bits 13:13 */
    cs_uint32 int_stat_pc2         :  1 ; /* bits 12:12 */
    cs_uint32 int_stat_pc1         :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc0         :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_txem        :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_rxfifo      :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_pspid_7     :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_pspid_6     :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_5     :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_4     :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_3     :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_2     :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_1     :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_0     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_stat_pspid_0     :  1 ; /* bits 0:0 */
    cs_uint32 int_stat_pspid_1     :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_2     :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_3     :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_4     :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_5     :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_6     :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_7     :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_rxfifo      :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_txem        :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_pc0         :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_pc1         :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc2         :  1 ; /* bits 12:12 */
    cs_uint32 cpuxram_int_stat_cntr :  1 ; /* bits 13:13 */
    cs_uint32 cpuxram_int_stat_err :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INTERRUPT_0_t;





#define NI_TOP_NI_INTENABLE_0                    0xf001039c
#define NI_TOP_NI_INTENABLE_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 cpuxram_int_stat_err_en :  1 ; /* bits 14:14 */
    cs_uint32 cpuxram_int_stat_cntr_en :  1 ; /* bits 13:13 */
    cs_uint32 int_stat_pc2_en      :  1 ; /* bits 12:12 */
    cs_uint32 int_stat_pc1_en      :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc0_en      :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_txem_en     :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_rxfifo_en   :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_pspid_7_en  :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_pspid_6_en  :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_5_en  :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_4_en  :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_3_en  :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_2_en  :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_1_en  :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_0_en  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_stat_pspid_0_en  :  1 ; /* bits 0:0 */
    cs_uint32 int_stat_pspid_1_en  :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_2_en  :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_3_en  :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_4_en  :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_5_en  :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_6_en  :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_7_en  :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_rxfifo_en   :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_txem_en     :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_pc0_en      :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_pc1_en      :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc2_en      :  1 ; /* bits 12:12 */
    cs_uint32 cpuxram_int_stat_cntr_en :  1 ; /* bits 13:13 */
    cs_uint32 cpuxram_int_stat_err_en :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INTENABLE_0_t;





#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0    0xf00103a0
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0_STRIDE 8
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0_COUNT 9
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 xram_rx_doneI        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_doneI        :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0_t;





#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0    0xf00103a4
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0_STRIDE 8
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0_COUNT 9
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 xram_rx_doneIE       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_doneIE       :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_0      0xf00103e8
#define NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_0_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 xram_tx_1_doneI      :  1 ; /* bits 1:1 */
    cs_uint32 xram_tx_0_doneI      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_tx_0_doneI      :  1 ; /* bits 0:0 */
    cs_uint32 xram_tx_1_doneI      :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_0_t;





#define NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_0      0xf00103ec
#define NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_0_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 xram_tx_1_doneIE     :  1 ; /* bits 1:1 */
    cs_uint32 xram_tx_0_doneIE     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_tx_0_doneIE     :  1 ; /* bits 0:0 */
    cs_uint32 xram_tx_1_doneIE     :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_0_t;





#define NI_TOP_NI_WOL_STAT_0_INT_0               0xf00103f0
#define NI_TOP_NI_WOL_STAT_0_INT_0_STRIDE        8
#define NI_TOP_NI_WOL_STAT_0_INT_0_COUNT         3
#define NI_TOP_NI_WOL_STAT_0_INT_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 ni_wol_int           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ni_wol_int           :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_STAT_0_INT_0_t;





#define NI_TOP_NI_WOL_STAT_0_INTENABLE_0         0xf00103f4
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_0_STRIDE  8
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_0_COUNT   3
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_0_dft     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 ni_wol_intIE         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ni_wol_intIE         :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_STAT_0_INTENABLE_0_t;


    
    
    
    



#define NI_TOP_NI_PORT_0_INTERRUPT_1             0xf0010408
#define NI_TOP_NI_PORT_0_INTERRUPT_1_STRIDE      8
#define NI_TOP_NI_PORT_0_INTERRUPT_1_COUNT       8
#define NI_TOP_NI_PORT_0_INTERRUPT_1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rxcntrl_rd_idleI     :  1 ; /* bits 8:8 */
    cs_uint32 txem_crcerr_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    cs_uint32 rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    cs_uint32 rxcntrl_usage_exceedI :  1 ; /* bits 4:4 */
    cs_uint32 rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    cs_uint32 txfifo_overrunI      :  1 ; /* bits 2:2 */
    cs_uint32 txfifo_underrunI     :  1 ; /* bits 1:1 */
    cs_uint32 link_stat_chgI       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 link_stat_chgI       :  1 ; /* bits 0:0 */
    cs_uint32 txfifo_underrunI     :  1 ; /* bits 1:1 */
    cs_uint32 txfifo_overrunI      :  1 ; /* bits 2:2 */
    cs_uint32 rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    cs_uint32 rxcntrl_usage_exceedI :  1 ; /* bits 4:4 */
    cs_uint32 rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    cs_uint32 txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    cs_uint32 txem_crcerr_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 rxcntrl_rd_idleI     :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PORT_0_INTERRUPT_1_t;





#define NI_TOP_NI_PORT_0_INTENABLE_1             0xf001040c
#define NI_TOP_NI_PORT_0_INTENABLE_1_STRIDE      8
#define NI_TOP_NI_PORT_0_INTENABLE_1_COUNT       8
#define NI_TOP_NI_PORT_0_INTENABLE_1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rxcntrl_rd_idleIE    :  1 ; /* bits 8:8 */
    cs_uint32 txem_crcerr_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    cs_uint32 rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    cs_uint32 rxcntrl_usage_exceedIE :  1 ; /* bits 4:4 */
    cs_uint32 rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    cs_uint32 txfifo_overrunIE     :  1 ; /* bits 2:2 */
    cs_uint32 txfifo_underrunIE    :  1 ; /* bits 1:1 */
    cs_uint32 link_stat_chgIE      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 link_stat_chgIE      :  1 ; /* bits 0:0 */
    cs_uint32 txfifo_underrunIE    :  1 ; /* bits 1:1 */
    cs_uint32 txfifo_overrunIE     :  1 ; /* bits 2:2 */
    cs_uint32 rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    cs_uint32 rxcntrl_usage_exceedIE :  1 ; /* bits 4:4 */
    cs_uint32 rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    cs_uint32 txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    cs_uint32 txem_crcerr_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 rxcntrl_rd_idleIE    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PORT_0_INTENABLE_1_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_RXFIFO_INTERRUPT_1             0xf0010448
#define NI_TOP_NI_RXFIFO_INTERRUPT_1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rx_fifo_voq_ecc_corr_errI :  1 ; /* bits 13:13 */
    cs_uint32 rx_fifo_voq_ecc_errI :  1 ; /* bits 12:12 */
    cs_uint32 mcal_pkt_dropI       :  1 ; /* bits 11:11 */
    cs_uint32 mal_drop_pkt_cnt_msb_setI :  1 ; /* bits 10:10 */
    cs_uint32 rx_fifo_ll_ecc_corr_errI :  1 ; /* bits 9:9 */
    cs_uint32 rx_fifo_ll_ecc_errI  :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_eop_bf_flI   :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_noeop_af_flI :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_nosopI       :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeopI       :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_congI        :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_voq_fullI    :  1 ; /* bits 2:2 */
    cs_uint32 rxfifo_overrunI      :  1 ; /* bits 1:1 */
    cs_uint32 rxfifo_fullI         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxfifo_fullI         :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_overrunI      :  1 ; /* bits 1:1 */
    cs_uint32 rx_fifo_voq_fullI    :  1 ; /* bits 2:2 */
    cs_uint32 rx_fifo_congI        :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_noeopI       :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_nosopI       :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeop_af_flI :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_eop_bf_flI   :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_ll_ecc_errI  :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_ll_ecc_corr_errI :  1 ; /* bits 9:9 */
    cs_uint32 mal_drop_pkt_cnt_msb_setI :  1 ; /* bits 10:10 */
    cs_uint32 mcal_pkt_dropI       :  1 ; /* bits 11:11 */
    cs_uint32 rx_fifo_voq_ecc_errI :  1 ; /* bits 12:12 */
    cs_uint32 rx_fifo_voq_ecc_corr_errI :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_INTERRUPT_1_t;





#define NI_TOP_NI_RXFIFO_INTENABLE_1             0xf001044c
#define NI_TOP_NI_RXFIFO_INTENABLE_1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rx_fifo_voq_ecc_corr_errIE :  1 ; /* bits 13:13 */
    cs_uint32 rx_fifo_voq_ecc_errIE :  1 ; /* bits 12:12 */
    cs_uint32 mcal_pkt_dropIE      :  1 ; /* bits 11:11 */
    cs_uint32 mal_drop_pkt_cnt_msb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 rx_fifo_ll_ecc_corr_errIE :  1 ; /* bits 9:9 */
    cs_uint32 rx_fifo_ll_errIE     :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_eop_bf_flIE  :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_noeop_af_flIE :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_nosopIE      :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeopIE      :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_congIE       :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_voq_fullIE   :  1 ; /* bits 2:2 */
    cs_uint32 rxfifo_overrunIE     :  1 ; /* bits 1:1 */
    cs_uint32 rxfifo_fullIE        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rxfifo_fullIE        :  1 ; /* bits 0:0 */
    cs_uint32 rxfifo_overrunIE     :  1 ; /* bits 1:1 */
    cs_uint32 rx_fifo_voq_fullIE   :  1 ; /* bits 2:2 */
    cs_uint32 rx_fifo_congIE       :  1 ; /* bits 3:3 */
    cs_uint32 rx_fifo_noeopIE      :  1 ; /* bits 4:4 */
    cs_uint32 rx_fifo_nosopIE      :  1 ; /* bits 5:5 */
    cs_uint32 rx_fifo_noeop_af_flIE :  1 ; /* bits 6:6 */
    cs_uint32 rx_fifo_eop_bf_flIE  :  1 ; /* bits 7:7 */
    cs_uint32 rx_fifo_ll_errIE     :  1 ; /* bits 8:8 */
    cs_uint32 rx_fifo_ll_ecc_corr_errIE :  1 ; /* bits 9:9 */
    cs_uint32 mal_drop_pkt_cnt_msb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 mcal_pkt_dropIE      :  1 ; /* bits 11:11 */
    cs_uint32 rx_fifo_voq_ecc_errIE :  1 ; /* bits 12:12 */
    cs_uint32 rx_fifo_voq_ecc_corr_errIE :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_RXFIFO_INTENABLE_1_t;





#define NI_TOP_NI_TXEM_INTERRUPT_1               0xf0010450
#define NI_TOP_NI_TXEM_INTERRUPT_1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 txem_ptp_v6csum0_errI :  1 ; /* bits 9:9 */
    cs_uint32 mc_indx_lkup_mem_perrI :  1 ; /* bits 8:8 */
    cs_uint32 tx_voq_lkup_mem_perrI :  1 ; /* bits 7:7 */
    cs_uint32 txem_ptp_cachevoq_errI :  1 ; /* bits 6:6 */
    cs_uint32 txem_ptp_voqchg_errI :  1 ; /* bits 5:5 */
    cs_uint32 rxmib_fifo_ovfI      :  1 ; /* bits 4:4 */
    cs_uint32 txmib_fifo_ovfI      :  1 ; /* bits 3:3 */
    cs_uint32 txrm_cntovfI         :  1 ; /* bits 2:2 */
    cs_uint32 txem_crc_errI        :  1 ; /* bits 1:1 */
    cs_uint32 txem_ififo_ovfI      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_ififo_ovfI      :  1 ; /* bits 0:0 */
    cs_uint32 txem_crc_errI        :  1 ; /* bits 1:1 */
    cs_uint32 txrm_cntovfI         :  1 ; /* bits 2:2 */
    cs_uint32 txmib_fifo_ovfI      :  1 ; /* bits 3:3 */
    cs_uint32 rxmib_fifo_ovfI      :  1 ; /* bits 4:4 */
    cs_uint32 txem_ptp_voqchg_errI :  1 ; /* bits 5:5 */
    cs_uint32 txem_ptp_cachevoq_errI :  1 ; /* bits 6:6 */
    cs_uint32 tx_voq_lkup_mem_perrI :  1 ; /* bits 7:7 */
    cs_uint32 mc_indx_lkup_mem_perrI :  1 ; /* bits 8:8 */
    cs_uint32 txem_ptp_v6csum0_errI :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_INTERRUPT_1_t;





#define NI_TOP_NI_TXEM_INTENABLE_1               0xf0010454
#define NI_TOP_NI_TXEM_INTENABLE_1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 txem_ptp_v6csum0_errIE :  1 ; /* bits 9:9 */
    cs_uint32 mc_indx_lkup_mem_perrIE :  1 ; /* bits 8:8 */
    cs_uint32 tx_voq_lkup_mem_perrIE :  1 ; /* bits 7:7 */
    cs_uint32 txem_ptp_cachevoq_errIE :  1 ; /* bits 6:6 */
    cs_uint32 txem_ptp_voqchg_errIE :  1 ; /* bits 5:5 */
    cs_uint32 rxmib_fifo_ovfIE     :  1 ; /* bits 4:4 */
    cs_uint32 txmib_fifo_ovfIE     :  1 ; /* bits 3:3 */
    cs_uint32 txrm_cntovfIE        :  1 ; /* bits 2:2 */
    cs_uint32 txem_crc_errIE       :  1 ; /* bits 1:1 */
    cs_uint32 txem_ififo_ovfIE     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 txem_ififo_ovfIE     :  1 ; /* bits 0:0 */
    cs_uint32 txem_crc_errIE       :  1 ; /* bits 1:1 */
    cs_uint32 txrm_cntovfIE        :  1 ; /* bits 2:2 */
    cs_uint32 txmib_fifo_ovfIE     :  1 ; /* bits 3:3 */
    cs_uint32 rxmib_fifo_ovfIE     :  1 ; /* bits 4:4 */
    cs_uint32 txem_ptp_voqchg_errIE :  1 ; /* bits 5:5 */
    cs_uint32 txem_ptp_cachevoq_errIE :  1 ; /* bits 6:6 */
    cs_uint32 tx_voq_lkup_mem_perrIE :  1 ; /* bits 7:7 */
    cs_uint32 mc_indx_lkup_mem_perrIE :  1 ; /* bits 8:8 */
    cs_uint32 txem_ptp_v6csum0_errIE :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_TXEM_INTENABLE_1_t;





#define NI_TOP_NI_PC0_INTERRUPT_1                0xf0010458
#define NI_TOP_NI_PC0_INTERRUPT_1_STRIDE         8
#define NI_TOP_NI_PC0_INTERRUPT_1_COUNT          3
#define NI_TOP_NI_PC0_INTERRUPT_1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 framelenmismatchI    :  1 ; /* bits 8:8 */
    cs_uint32 datamismatchI        :  1 ; /* bits 7:7 */
    cs_uint32 seqnummismatchI      :  1 ; /* bits 6:6 */
    cs_uint32 typefieldmismatchI   :  1 ; /* bits 5:5 */
    cs_uint32 vlan2fieldmismatchI  :  1 ; /* bits 4:4 */
    cs_uint32 vlan1fieldmismatchI  :  1 ; /* bits 3:3 */
    cs_uint32 srcaddrmismatchI     :  1 ; /* bits 2:2 */
    cs_uint32 dstaddrmismatchI     :  1 ; /* bits 1:1 */
    cs_uint32 dchkoutofsyncI       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dchkoutofsyncI       :  1 ; /* bits 0:0 */
    cs_uint32 dstaddrmismatchI     :  1 ; /* bits 1:1 */
    cs_uint32 srcaddrmismatchI     :  1 ; /* bits 2:2 */
    cs_uint32 vlan1fieldmismatchI  :  1 ; /* bits 3:3 */
    cs_uint32 vlan2fieldmismatchI  :  1 ; /* bits 4:4 */
    cs_uint32 typefieldmismatchI   :  1 ; /* bits 5:5 */
    cs_uint32 seqnummismatchI      :  1 ; /* bits 6:6 */
    cs_uint32 datamismatchI        :  1 ; /* bits 7:7 */
    cs_uint32 framelenmismatchI    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_INTERRUPT_1_t;





#define NI_TOP_NI_PC0_INTENABLE_1                0xf001045c
#define NI_TOP_NI_PC0_INTENABLE_1_STRIDE         8
#define NI_TOP_NI_PC0_INTENABLE_1_COUNT          3
#define NI_TOP_NI_PC0_INTENABLE_1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 framelenmismatchE    :  1 ; /* bits 8:8 */
    cs_uint32 datamismatchE        :  1 ; /* bits 7:7 */
    cs_uint32 seqnummismatchE      :  1 ; /* bits 6:6 */
    cs_uint32 typefieldmismatchE   :  1 ; /* bits 5:5 */
    cs_uint32 vlan2fieldmismatchE  :  1 ; /* bits 4:4 */
    cs_uint32 vlan1fieldmismatchE  :  1 ; /* bits 3:3 */
    cs_uint32 srcaddrmismatchE     :  1 ; /* bits 2:2 */
    cs_uint32 dstaddrmismatchE     :  1 ; /* bits 1:1 */
    cs_uint32 dchkoutofsyncE       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dchkoutofsyncE       :  1 ; /* bits 0:0 */
    cs_uint32 dstaddrmismatchE     :  1 ; /* bits 1:1 */
    cs_uint32 srcaddrmismatchE     :  1 ; /* bits 2:2 */
    cs_uint32 vlan1fieldmismatchE  :  1 ; /* bits 3:3 */
    cs_uint32 vlan2fieldmismatchE  :  1 ; /* bits 4:4 */
    cs_uint32 typefieldmismatchE   :  1 ; /* bits 5:5 */
    cs_uint32 seqnummismatchE      :  1 ; /* bits 6:6 */
    cs_uint32 datamismatchE        :  1 ; /* bits 7:7 */
    cs_uint32 framelenmismatchE    :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_PC0_INTENABLE_1_t;


    
    
    
    



#define NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_1       0xf0010470
#define NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setI :  1 ; /* bits 31:31 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setI :  1 ; /* bits 30:30 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setI :  1 ; /* bits 29:29 */
    cs_uint32 byt_to_xram_8_cntmsb_setI :  1 ; /* bits 28:28 */
    cs_uint32 byt_to_xram_7_cntmsb_setI :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_6_cntmsb_setI :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_5_cntmsb_setI :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_4_cntmsb_setI :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_3_cntmsb_setI :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_2_cntmsb_setI :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_1_cntmsb_setI :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_0_cntmsb_setI :  1 ; /* bits 20:20 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setI :  1 ; /* bits 19:19 */
    cs_uint32 pkt_to_xram_8_cntmsb_setI :  1 ; /* bits 18:18 */
    cs_uint32 pkt_to_xram_7_cntmsb_setI :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_6_cntmsb_setI :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_5_cntmsb_setI :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_4_cntmsb_setI :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_3_cntmsb_setI :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_2_cntmsb_setI :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_1_cntmsb_setI :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_0_cntmsb_setI :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_drop_err_8_cntmsb_setI :  1 ; /* bits 8:8 */
    cs_uint32 pkt_drop_err_7_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_6_cntmsb_setI :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_5_cntmsb_setI :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_4_cntmsb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_3_cntmsb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_2_cntmsb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_1_cntmsb_setI :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_0_cntmsb_setI :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_err_0_cntmsb_setI :  1 ; /* bits 0:0 */
    cs_uint32 pkt_drop_err_1_cntmsb_setI :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_2_cntmsb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_3_cntmsb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_4_cntmsb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_5_cntmsb_setI :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_6_cntmsb_setI :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_7_cntmsb_setI :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_8_cntmsb_setI :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_to_xram_0_cntmsb_setI :  1 ; /* bits 10:10 */
    cs_uint32 pkt_to_xram_1_cntmsb_setI :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_2_cntmsb_setI :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_3_cntmsb_setI :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_4_cntmsb_setI :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_5_cntmsb_setI :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_6_cntmsb_setI :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_7_cntmsb_setI :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_8_cntmsb_setI :  1 ; /* bits 18:18 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setI :  1 ; /* bits 19:19 */
    cs_uint32 byt_to_xram_0_cntmsb_setI :  1 ; /* bits 20:20 */
    cs_uint32 byt_to_xram_1_cntmsb_setI :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_2_cntmsb_setI :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_3_cntmsb_setI :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_4_cntmsb_setI :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_5_cntmsb_setI :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_6_cntmsb_setI :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_7_cntmsb_setI :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_8_cntmsb_setI :  1 ; /* bits 28:28 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setI :  1 ; /* bits 29:29 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setI :  1 ; /* bits 30:30 */
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setI :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_1_t;





#define NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_1       0xf0010474
#define NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setIE :  1 ; /* bits 31:31 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setIE :  1 ; /* bits 30:30 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setIE :  1 ; /* bits 29:29 */
    cs_uint32 byt_to_xram_8_cntmsb_setIE :  1 ; /* bits 28:28 */
    cs_uint32 byt_to_xram_7_cntmsb_setIE :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_6_cntmsb_setIE :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_5_cntmsb_setIE :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_4_cntmsb_setIE :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_3_cntmsb_setIE :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_2_cntmsb_setIE :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_1_cntmsb_setIE :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_0_cntmsb_setIE :  1 ; /* bits 20:20 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setIE :  1 ; /* bits 19:19 */
    cs_uint32 pkt_to_xram_8_cntmsb_setIE :  1 ; /* bits 18:18 */
    cs_uint32 pkt_to_xram_7_cntmsb_setIE :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_6_cntmsb_setIE :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_5_cntmsb_setIE :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_4_cntmsb_setIE :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_3_cntmsb_setIE :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_2_cntmsb_setIE :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_1_cntmsb_setIE :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_0_cntmsb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_drop_err_8_cntmsb_setIE :  1 ; /* bits 8:8 */
    cs_uint32 pkt_drop_err_7_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_6_cntmsb_setIE :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_5_cntmsb_setIE :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_4_cntmsb_setIE :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_3_cntmsb_setIE :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_2_cntmsb_setIE :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_1_cntmsb_setIE :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_0_cntmsb_setIE :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_drop_err_0_cntmsb_setIE :  1 ; /* bits 0:0 */
    cs_uint32 pkt_drop_err_1_cntmsb_setIE :  1 ; /* bits 1:1 */
    cs_uint32 pkt_drop_err_2_cntmsb_setIE :  1 ; /* bits 2:2 */
    cs_uint32 pkt_drop_err_3_cntmsb_setIE :  1 ; /* bits 3:3 */
    cs_uint32 pkt_drop_err_4_cntmsb_setIE :  1 ; /* bits 4:4 */
    cs_uint32 pkt_drop_err_5_cntmsb_setIE :  1 ; /* bits 5:5 */
    cs_uint32 pkt_drop_err_6_cntmsb_setIE :  1 ; /* bits 6:6 */
    cs_uint32 pkt_drop_err_7_cntmsb_setIE :  1 ; /* bits 7:7 */
    cs_uint32 pkt_drop_err_8_cntmsb_setIE :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_to_xram_0_cntmsb_setIE :  1 ; /* bits 10:10 */
    cs_uint32 pkt_to_xram_1_cntmsb_setIE :  1 ; /* bits 11:11 */
    cs_uint32 pkt_to_xram_2_cntmsb_setIE :  1 ; /* bits 12:12 */
    cs_uint32 pkt_to_xram_3_cntmsb_setIE :  1 ; /* bits 13:13 */
    cs_uint32 pkt_to_xram_4_cntmsb_setIE :  1 ; /* bits 14:14 */
    cs_uint32 pkt_to_xram_5_cntmsb_setIE :  1 ; /* bits 15:15 */
    cs_uint32 pkt_to_xram_6_cntmsb_setIE :  1 ; /* bits 16:16 */
    cs_uint32 pkt_to_xram_7_cntmsb_setIE :  1 ; /* bits 17:17 */
    cs_uint32 pkt_to_xram_8_cntmsb_setIE :  1 ; /* bits 18:18 */
    cs_uint32 pkt_drop_ovrun_ptp_cntmsb_setIE :  1 ; /* bits 19:19 */
    cs_uint32 byt_to_xram_0_cntmsb_setIE :  1 ; /* bits 20:20 */
    cs_uint32 byt_to_xram_1_cntmsb_setIE :  1 ; /* bits 21:21 */
    cs_uint32 byt_to_xram_2_cntmsb_setIE :  1 ; /* bits 22:22 */
    cs_uint32 byt_to_xram_3_cntmsb_setIE :  1 ; /* bits 23:23 */
    cs_uint32 byt_to_xram_4_cntmsb_setIE :  1 ; /* bits 24:24 */
    cs_uint32 byt_to_xram_5_cntmsb_setIE :  1 ; /* bits 25:25 */
    cs_uint32 byt_to_xram_6_cntmsb_setIE :  1 ; /* bits 26:26 */
    cs_uint32 byt_to_xram_7_cntmsb_setIE :  1 ; /* bits 27:27 */
    cs_uint32 byt_to_xram_8_cntmsb_setIE :  1 ; /* bits 28:28 */
    cs_uint32 dma_pkt_to_cpu_cntmsb_setIE :  1 ; /* bits 29:29 */
    cs_uint32 dma_byte_to_cpu_cntmsb_setIE :  1 ; /* bits 30:30 */
    cs_uint32 pkt_drop_ovrun_mgmt_cntmsb_setIE :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_1_t;





#define NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_1        0xf0010478
#define NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_1_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 dma_fifo_overrunI    :  1 ; /* bits 23:23 */
    cs_uint32 xram_rx_mgmtfifo_overrunI :  1 ; /* bits 22:22 */
    cs_uint32 xram_rx_ptpfifo_overrunI :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_qmfifo_overrunI :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_8_dis_pktI   :  1 ; /* bits 18:18 */
    cs_uint32 xram_rx_7_dis_pktI   :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_6_dis_pktI   :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_5_dis_pktI   :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_4_dis_pktI   :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_3_dis_pktI   :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_2_dis_pktI   :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_1_dis_pktI   :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_0_dis_pktI   :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_8_ptrbkupI   :  1 ; /* bits 8:8 */
    cs_uint32 xram_rx_7_ptrbkupI   :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_6_ptrbkupI   :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_5_ptrbkupI   :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_4_ptrbkupI   :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_3_ptrbkupI   :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_2_ptrbkupI   :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_1_ptrbkupI   :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_0_ptrbkupI   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_0_ptrbkupI   :  1 ; /* bits 0:0 */
    cs_uint32 xram_rx_1_ptrbkupI   :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_2_ptrbkupI   :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_3_ptrbkupI   :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_4_ptrbkupI   :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_5_ptrbkupI   :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_6_ptrbkupI   :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_7_ptrbkupI   :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_8_ptrbkupI   :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_0_dis_pktI   :  1 ; /* bits 10:10 */
    cs_uint32 xram_rx_1_dis_pktI   :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_2_dis_pktI   :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_3_dis_pktI   :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_4_dis_pktI   :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_5_dis_pktI   :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_6_dis_pktI   :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_7_dis_pktI   :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_8_dis_pktI   :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_qmfifo_overrunI :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_ptpfifo_overrunI :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_mgmtfifo_overrunI :  1 ; /* bits 22:22 */
    cs_uint32 dma_fifo_overrunI    :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_1_t;





#define NI_TOP_NI_CPUXRAM_ERR_INTENABLE_1        0xf001047c
#define NI_TOP_NI_CPUXRAM_ERR_INTENABLE_1_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 dma_fifo_overrunIE   :  1 ; /* bits 23:23 */
    cs_uint32 xram_rx_mgmtfifo_overrunIE :  1 ; /* bits 22:22 */
    cs_uint32 xram_rx_ptpfifo_overrunIE :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_qmfifo_overrunIE :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_8_dis_pktIE  :  1 ; /* bits 18:18 */
    cs_uint32 xram_rx_7_dis_pktIE  :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_6_dis_pktIE  :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_5_dis_pktIE  :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_4_dis_pktIE  :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_3_dis_pktIE  :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_2_dis_pktIE  :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_1_dis_pktIE  :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_0_dis_pktIE  :  1 ; /* bits 10:10 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_8_ptrbkupIE  :  1 ; /* bits 8:8 */
    cs_uint32 xram_rx_7_ptrbkupIE  :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_6_ptrbkupIE  :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_5_ptrbkupIE  :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_4_ptrbkupIE  :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_3_ptrbkupIE  :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_2_ptrbkupIE  :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_1_ptrbkupIE  :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_0_ptrbkupIE  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_0_ptrbkupIE  :  1 ; /* bits 0:0 */
    cs_uint32 xram_rx_1_ptrbkupIE  :  1 ; /* bits 1:1 */
    cs_uint32 xram_rx_2_ptrbkupIE  :  1 ; /* bits 2:2 */
    cs_uint32 xram_rx_3_ptrbkupIE  :  1 ; /* bits 3:3 */
    cs_uint32 xram_rx_4_ptrbkupIE  :  1 ; /* bits 4:4 */
    cs_uint32 xram_rx_5_ptrbkupIE  :  1 ; /* bits 5:5 */
    cs_uint32 xram_rx_6_ptrbkupIE  :  1 ; /* bits 6:6 */
    cs_uint32 xram_rx_7_ptrbkupIE  :  1 ; /* bits 7:7 */
    cs_uint32 xram_rx_8_ptrbkupIE  :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 xram_rx_0_dis_pktIE  :  1 ; /* bits 10:10 */
    cs_uint32 xram_rx_1_dis_pktIE  :  1 ; /* bits 11:11 */
    cs_uint32 xram_rx_2_dis_pktIE  :  1 ; /* bits 12:12 */
    cs_uint32 xram_rx_3_dis_pktIE  :  1 ; /* bits 13:13 */
    cs_uint32 xram_rx_4_dis_pktIE  :  1 ; /* bits 14:14 */
    cs_uint32 xram_rx_5_dis_pktIE  :  1 ; /* bits 15:15 */
    cs_uint32 xram_rx_6_dis_pktIE  :  1 ; /* bits 16:16 */
    cs_uint32 xram_rx_7_dis_pktIE  :  1 ; /* bits 17:17 */
    cs_uint32 xram_rx_8_dis_pktIE  :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 xram_rx_qmfifo_overrunIE :  1 ; /* bits 20:20 */
    cs_uint32 xram_rx_ptpfifo_overrunIE :  1 ; /* bits 21:21 */
    cs_uint32 xram_rx_mgmtfifo_overrunIE :  1 ; /* bits 22:22 */
    cs_uint32 dma_fifo_overrunIE   :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_ERR_INTENABLE_1_t;





#define NI_TOP_NI_INTERRUPT_1                    0xf0010480
#define NI_TOP_NI_INTERRUPT_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 cpuxram_int_stat_err :  1 ; /* bits 14:14 */
    cs_uint32 cpuxram_int_stat_cntr :  1 ; /* bits 13:13 */
    cs_uint32 int_stat_pc2         :  1 ; /* bits 12:12 */
    cs_uint32 int_stat_pc1         :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc0         :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_txem        :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_rxfifo      :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_pspid_7     :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_pspid_6     :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_5     :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_4     :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_3     :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_2     :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_1     :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_0     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_stat_pspid_0     :  1 ; /* bits 0:0 */
    cs_uint32 int_stat_pspid_1     :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_2     :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_3     :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_4     :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_5     :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_6     :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_7     :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_rxfifo      :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_txem        :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_pc0         :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_pc1         :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc2         :  1 ; /* bits 12:12 */
    cs_uint32 cpuxram_int_stat_cntr :  1 ; /* bits 13:13 */
    cs_uint32 cpuxram_int_stat_err :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INTERRUPT_1_t;





#define NI_TOP_NI_INTENABLE_1                    0xf0010484
#define NI_TOP_NI_INTENABLE_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 cpuxram_int_stat_err_en :  1 ; /* bits 14:14 */
    cs_uint32 cpuxram_int_stat_cntr_en :  1 ; /* bits 13:13 */
    cs_uint32 int_stat_pc2_en      :  1 ; /* bits 12:12 */
    cs_uint32 int_stat_pc1_en      :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc0_en      :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_txem_en     :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_rxfifo_en   :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_pspid_7_en  :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_pspid_6_en  :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_5_en  :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_4_en  :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_3_en  :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_2_en  :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_1_en  :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_0_en  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 int_stat_pspid_0_en  :  1 ; /* bits 0:0 */
    cs_uint32 int_stat_pspid_1_en  :  1 ; /* bits 1:1 */
    cs_uint32 int_stat_pspid_2_en  :  1 ; /* bits 2:2 */
    cs_uint32 int_stat_pspid_3_en  :  1 ; /* bits 3:3 */
    cs_uint32 int_stat_pspid_4_en  :  1 ; /* bits 4:4 */
    cs_uint32 int_stat_pspid_5_en  :  1 ; /* bits 5:5 */
    cs_uint32 int_stat_pspid_6_en  :  1 ; /* bits 6:6 */
    cs_uint32 int_stat_pspid_7_en  :  1 ; /* bits 7:7 */
    cs_uint32 int_stat_rxfifo_en   :  1 ; /* bits 8:8 */
    cs_uint32 int_stat_txem_en     :  1 ; /* bits 9:9 */
    cs_uint32 int_stat_pc0_en      :  1 ; /* bits 10:10 */
    cs_uint32 int_stat_pc1_en      :  1 ; /* bits 11:11 */
    cs_uint32 int_stat_pc2_en      :  1 ; /* bits 12:12 */
    cs_uint32 cpuxram_int_stat_cntr_en :  1 ; /* bits 13:13 */
    cs_uint32 cpuxram_int_stat_err_en :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_INTENABLE_1_t;





#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1    0xf0010488
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1_STRIDE 8
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1_COUNT 9
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 xram_rx_doneI        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_doneI        :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1_t;





#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1    0xf001048c
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1_STRIDE 8
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1_COUNT 9
#define NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 xram_rx_doneIE       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_rx_doneIE       :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1_t;


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



#define NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_1      0xf00104d0
#define NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_1_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 xram_tx_1_doneI      :  1 ; /* bits 1:1 */
    cs_uint32 xram_tx_0_doneI      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_tx_0_doneI      :  1 ; /* bits 0:0 */
    cs_uint32 xram_tx_1_doneI      :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_1_t;





#define NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_1      0xf00104d4
#define NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_1_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 xram_tx_1_doneIE     :  1 ; /* bits 1:1 */
    cs_uint32 xram_tx_0_doneIE     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 xram_tx_0_doneIE     :  1 ; /* bits 0:0 */
    cs_uint32 xram_tx_1_doneIE     :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_1_t;





#define NI_TOP_NI_WOL_STAT_0_INT_1               0xf00104d8
#define NI_TOP_NI_WOL_STAT_0_INT_1_STRIDE        8
#define NI_TOP_NI_WOL_STAT_0_INT_1_COUNT         3
#define NI_TOP_NI_WOL_STAT_0_INT_1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 ni_wol_int           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ni_wol_int           :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_STAT_0_INT_1_t;





#define NI_TOP_NI_WOL_STAT_0_INTENABLE_1         0xf00104dc
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_1_STRIDE  8
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_1_COUNT   3
#define NI_TOP_NI_WOL_STAT_0_INTENABLE_1_dft     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 ni_wol_intIE         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ni_wol_intIE         :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} NI_TOP_NI_WOL_STAT_0_INTENABLE_1_t;


    
    
    
    

    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* NI_TOP */

typedef struct {
  NI_TOP_NI_INTF_RST_CONFIG_t              INTF_RST_CONFIG;               /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  NI_TOP_NI_ETH_INT_CONFIG1_t              ETH_INT_CONFIG1;               /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  NI_TOP_NI_ETH_INT_CONFIG2_t              ETH_INT_CONFIG2;               /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  NI_TOP_NI_ETH_MGMT_PT_CONFIG_t           ETH_MGMT_PT_CONFIG;            /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  NI_TOP_NI_ETH_MAC_CONFIG0_0_t            ETH_MAC_CONFIG0_0;             /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  NI_TOP_NI_ETH_MAC_CONFIG1_0_t            ETH_MAC_CONFIG1_0;             /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  NI_TOP_NI_ETH_MAC_CONFIG2_0_t            ETH_MAC_CONFIG2_0;             /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[27];                   
  NI_TOP_NI_ETH_RCV_STAT_0_t               ETH_RCV_STAT_0;                /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd8[11];                   
  NI_TOP_NI_MAC_ADDR0_t                    MAC_ADDR0;                     /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd9[3];                    
  NI_TOP_NI_MAC_ADDR1_t                    MAC_ADDR1;                     /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd10[3];                   
  NI_TOP_NI_WOL_PASSWD_0_t                 WOL_PASSWD_0;                  /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd11[3];                   
  NI_TOP_NI_WOL_PASSWD_1_t                 WOL_PASSWD_1;                  /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd12[3];                   
  NI_TOP_NI_PKT_LEN_CONFIG_t               PKT_LEN_CONFIG;                /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd13[3];                   
  NI_TOP_NI_PKT_STOR_LEN_CONFIG_t          PKT_STOR_LEN_CONFIG;           /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd14[3];                   
  NI_TOP_NI_RX_CNTRL_CONFIG0_0_t           RX_CNTRL_CONFIG0_0;            /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd15[3];                   
  NI_TOP_NI_RX_CNTRL_CONFIG1_0_t           RX_CNTRL_CONFIG1_0;            /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd16[59];                  
  NI_TOP_NI_RX_AGG_CONFIG_t                RX_AGG_CONFIG;                 /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd17[3];                   
  NI_TOP_NI_RX_AGGPC_CONFIG_t              RX_AGGPC_CONFIG;               /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd18[3];                   
  NI_TOP_NI_RX_FIFO_CG_TH_t                RX_FIFO_CG_TH;                 /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd19[3];                   
  NI_TOP_NI_RX_FIFO_NOCG_TH_t              RX_FIFO_NOCG_TH;               /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd20[3];                   
  NI_TOP_NI_RX_FIFO_STAT_t                 RX_FIFO_STAT;                  /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd21[3];                   
  NI_TOP_NI_RX_PORT_CAL_ACCESS_t           RX_PORT_CAL_ACCESS;            /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd22[3];                   
  NI_TOP_NI_RX_PORT_CAL_DATA_t             RX_PORT_CAL_DATA;              /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd23[3];                   
  NI_TOP_NI_RXFIFO_DBG_ACCESS_t            RXFIFO_DBG_ACCESS;             /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd24[3];                   
  NI_TOP_NI_RXFIFO_DBG_DATA_t              RXFIFO_DBG_DATA;               /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd25[3];                   
  NI_TOP_NI_RXFIFO_DBG1_t                  RXFIFO_DBG1;                   /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd26[3];                   
  NI_TOP_NI_SCH_BP_THLD_ETH_t              SCH_BP_THLD_ETH;               /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd27[3];                   
  NI_TOP_NI_SCH_BP_THLD_MC_t               SCH_BP_THLD_MC;                /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd28[3];                   
  NI_TOP_NI_MISC_CONFIG_t                  MISC_CONFIG;                   /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd29[3];                   
  NI_TOP_NI_TX_VOQ_LKUP_ACCESS_t           TX_VOQ_LKUP_ACCESS;            /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd30[3];                   
  NI_TOP_NI_TX_VOQ_LKUP_DATA1_t            TX_VOQ_LKUP_DATA1;             /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd31[3];                   
  NI_TOP_NI_TX_VOQ_LKUP_DATA0_t            TX_VOQ_LKUP_DATA0;             /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd32[3];                   
  NI_TOP_NI_MC_INDX_LKUP_ACCESS_t          MC_INDX_LKUP_ACCESS;           /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd33[3];                   
  NI_TOP_NI_MC_INDX_LKUP_DATA_t            MC_INDX_LKUP_DATA;             /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd34[3];                   
  NI_TOP_NI_PG_DA1_t                       PG_DA1;                        /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd35[3];                   
  NI_TOP_NI_PG_DA2_t                       PG_DA2;                        /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd36[3];                   
  NI_TOP_NI_PG_SA1_t                       PG_SA1;                        /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd37[3];                   
  NI_TOP_NI_PG_SA2_t                       PG_SA2;                        /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd38[3];                   
  NI_TOP_NI_PG_CFG0_t                      PG_CFG0;                       /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd39[3];                   
  NI_TOP_NI_PG_CFG1_t                      PG_CFG1;                       /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd40[3];                   
  NI_TOP_NI_PG_FXPT_t                      PG_FXPT;                       /* addr: 0x000000f8 */ 
  cs_uint32                                rsrvd41[3];                   
  NI_TOP_NI_PG0_CFG1_t                     PG0_CFG1;                      /* addr: 0x000000fc */ 
  cs_uint32                                rsrvd42[3];                   
  NI_TOP_NI_PG0_CFG2_t                     PG0_CFG2;                      /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd43[3];                   
  NI_TOP_NI_PG0_CNTRL_t                    PG0_CNTRL;                     /* addr: 0x00000104 */ 
  cs_uint32                                rsrvd44[27];                  
  NI_TOP_NI_PC_DA1_t                       PC_DA1;                        /* addr: 0x00000120 */ 
  cs_uint32                                rsrvd45[3];                   
  NI_TOP_NI_PC_DA2_t                       PC_DA2;                        /* addr: 0x00000124 */ 
  cs_uint32                                rsrvd46[3];                   
  NI_TOP_NI_PC_SA1_t                       PC_SA1;                        /* addr: 0x00000128 */ 
  cs_uint32                                rsrvd47[3];                   
  NI_TOP_NI_PC_SA2_t                       PC_SA2;                        /* addr: 0x0000012c */ 
  cs_uint32                                rsrvd48[3];                   
  NI_TOP_NI_PC_CFG0_t                      PC_CFG0;                       /* addr: 0x00000130 */ 
  cs_uint32                                rsrvd49[3];                   
  NI_TOP_NI_PC_CFG1_t                      PC_CFG1;                       /* addr: 0x00000134 */ 
  cs_uint32                                rsrvd50[3];                   
  NI_TOP_NI_PC_FXPT_t                      PC_FXPT;                       /* addr: 0x00000138 */ 
  cs_uint32                                rsrvd51[3];                   
  NI_TOP_NI_PC0_CFG1_t                     PC0_CFG1;                      /* addr: 0x0000013c */ 
  cs_uint32                                rsrvd52[3];                   
  NI_TOP_NI_PC0_CFG2_t                     PC0_CFG2;                      /* addr: 0x00000140 */ 
  cs_uint32                                rsrvd53[3];                   
  NI_TOP_NI_PC0_CNTRL_t                    PC0_CNTRL;                     /* addr: 0x00000144 */ 
  cs_uint32                                rsrvd54[3];                   
  NI_TOP_NI_PC0_STAT_t                     PC0_STAT;                      /* addr: 0x00000148 */ 
  cs_uint32                                rsrvd55[35];                  
  NI_TOP_NI_RM_CFG_t                       RM_CFG;                        /* addr: 0x0000016c */ 
  cs_uint32                                rsrvd56[3];                   
  NI_TOP_NI_RM_TBMAX_t                     RM_TBMAX;                      /* addr: 0x00000170 */ 
  cs_uint32                                rsrvd57[3];                   
  NI_TOP_NI_RM_CNTR_t                      RM_CNTR;                       /* addr: 0x00000174 */ 
  cs_uint32                                rsrvd58[3];                   
  NI_TOP_NI_RM_LASTCNTR_t                  RM_LASTCNTR;                   /* addr: 0x00000178 */ 
  cs_uint32                                rsrvd59[3];                   
  NI_TOP_NI_PPS_TRIG_HW_TS_t               PPS_TRIG_HW_TS;                /* addr: 0x0000017c */ 
  cs_uint32                                rsrvd60[3];                   
  NI_TOP_NI_INIT_DONE_t                    INIT_DONE;                     /* addr: 0x00000180 */ 
  cs_uint32                                rsrvd61[3];                   
  NI_TOP_NI_RXMIB_ACCESS_t                 RXMIB_ACCESS;                  /* addr: 0x00000184 */ 
  cs_uint32                                rsrvd62[3];                   
  NI_TOP_NI_RXMIB_DATA1_t                  RXMIB_DATA1;                   /* addr: 0x00000188 */ 
  cs_uint32                                rsrvd63[3];                   
  NI_TOP_NI_RXMIB_DATA0_t                  RXMIB_DATA0;                   /* addr: 0x0000018c */ 
  cs_uint32                                rsrvd64[3];                   
  NI_TOP_NI_TXMIB_ACCESS_t                 TXMIB_ACCESS;                  /* addr: 0x00000190 */ 
  cs_uint32                                rsrvd65[3];                   
  NI_TOP_NI_TXMIB_DATA1_t                  TXMIB_DATA1;                   /* addr: 0x00000194 */ 
  cs_uint32                                rsrvd66[3];                   
  NI_TOP_NI_TXMIB_DATA0_t                  TXMIB_DATA0;                   /* addr: 0x00000198 */ 
  cs_uint32                                rsrvd67[3];                   
  NI_TOP_NI_TXEM_CRCERR_ACCESS_t           TXEM_CRCERR_ACCESS;            /* addr: 0x0000019c */ 
  cs_uint32                                rsrvd68[3];                   
  NI_TOP_NI_TXEM_CRCERR_DATA_t             TXEM_CRCERR_DATA;              /* addr: 0x000001a0 */ 
  cs_uint32                                rsrvd69[3];                   
  NI_TOP_NI_MAL_PKT_DROPCNT_t              MAL_PKT_DROPCNT;               /* addr: 0x000001a4 */ 
  cs_uint32                                rsrvd70[3];                   
  NI_TOP_NI_MAL_PKT_DROPCNT_CFG_t          MAL_PKT_DROPCNT_CFG;           /* addr: 0x000001a8 */ 
  cs_uint32                                rsrvd71[3];                   
  NI_TOP_NI_CPUXRAM_ADRCFG_RX_0_t          CPUXRAM_ADRCFG_RX_0;           /* addr: 0x000001ac */ 
  cs_uint32                                rsrvd72[35];                  
  NI_TOP_NI_CPUXRAM_ADRCFG_TX_0_t          CPUXRAM_ADRCFG_TX_0;           /* addr: 0x000001d0 */ 
  cs_uint32                                rsrvd73[3];                   
  NI_TOP_NI_CPUXRAM_ADRCFG_TX_1_t          CPUXRAM_ADRCFG_TX_1;           /* addr: 0x000001d4 */ 
  cs_uint32                                rsrvd74[3];                   
  NI_TOP_NI_CPUXRAM_CFG_t                  CPUXRAM_CFG;                   /* addr: 0x000001d8 */ 
  cs_uint32                                rsrvd75[3];                   
  NI_TOP_NI_CPUXRAM_PTCAL0_t               CPUXRAM_PTCAL0;                /* addr: 0x000001dc */ 
  cs_uint32                                rsrvd76[3];                   
  NI_TOP_NI_CPUXRAM_PTCAL1_t               CPUXRAM_PTCAL1;                /* addr: 0x000001e0 */ 
  cs_uint32                                rsrvd77[3];                   
  NI_TOP_NI_CPUXRAM_SCH_BP_CFG_0_t         CPUXRAM_SCH_BP_CFG_0;          /* addr: 0x000001e4 */ 
  cs_uint32                                rsrvd78[31];                  
  NI_TOP_NI_CPUXRAM_CPU_CFG_RX_0_t         CPUXRAM_CPU_CFG_RX_0;          /* addr: 0x00000204 */ 
  cs_uint32                                rsrvd79[3];                   
  NI_TOP_NI_CPUXRAM_CPU_STA_RX_0_t         CPUXRAM_CPU_STA_RX_0;          /* addr: 0x00000208 */ 
  cs_uint32                                rsrvd80[3];                   
  NI_TOP_NI_CPUXRAM_INT_COLSC_CFG_0_t      CPUXRAM_INT_COLSC_CFG_0;       /* addr: 0x0000020c */ 
  cs_uint32                                rsrvd81[3];                   
  NI_TOP_NI_CPUXRAM_PKT_CNT_0_t            CPUXRAM_PKT_CNT_0;             /* addr: 0x00000210 */ 
  cs_uint32                                rsrvd82[3];                   
  NI_TOP_NI_CPUXRAM_BYT_CNT_0_t            CPUXRAM_BYT_CNT_0;             /* addr: 0x00000214 */ 
  cs_uint32                                rsrvd83[3];                   
  NI_TOP_NI_CPUXRAM_PKT_ERR_DRP_0_t        CPUXRAM_PKT_ERR_DRP_0;         /* addr: 0x00000218 */ 
  cs_uint32                                rsrvd84[195];                 
  NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_PTP_t     CPUXRAM_PKT_OVRN_DRP_PTP;      /* addr: 0x000002dc */ 
  cs_uint32                                rsrvd85[3];                   
  NI_TOP_NI_CPUXRAM_PKT_OVRN_DRP_MGMT_t    CPUXRAM_PKT_OVRN_DRP_MGMT;     /* addr: 0x000002e0 */ 
  cs_uint32                                rsrvd86[3];                   
  NI_TOP_NI_CPUXRAM_CPU_CFG_TX_0_t         CPUXRAM_CPU_CFG_TX_0;          /* addr: 0x000002e4 */ 
  cs_uint32                                rsrvd87[3];                   
  NI_TOP_NI_CPUXRAM_CPU_STAT_TX_0_t        CPUXRAM_CPU_STAT_TX_0;         /* addr: 0x000002e8 */ 
  cs_uint32                                rsrvd88[11];                  
  NI_TOP_NI_DMA_PKT_CNT_t                  DMA_PKT_CNT;                   /* addr: 0x000002f4 */ 
  cs_uint32                                rsrvd89[3];                   
  NI_TOP_NI_DMA_BYTE_CNT_t                 DMA_BYTE_CNT;                  /* addr: 0x000002f8 */ 
  cs_uint32                                rsrvd90[3];                   
  NI_TOP_NI_HW_TS_CNTR_t                   HW_TS_CNTR;                    /* addr: 0x000002fc */ 
  cs_uint32                                rsrvd91[3];                   
  NI_TOP_NI_PTP_SWCFG_ACCESS_t             PTP_SWCFG_ACCESS;              /* addr: 0x00000300 */ 
  cs_uint32                                rsrvd92[3];                   
  NI_TOP_NI_PTP_SWCFG_DATA1_t              PTP_SWCFG_DATA1;               /* addr: 0x00000304 */ 
  cs_uint32                                rsrvd93[3];                   
  NI_TOP_NI_PTP_SWCFG_DATA0_t              PTP_SWCFG_DATA0;               /* addr: 0x00000308 */ 
  cs_uint32                                rsrvd94[3];                   
  NI_TOP_NI_DEBUG_1_t                      DEBUG_1;                       /* addr: 0x0000030c */ 
  cs_uint32                                rsrvd95[3];                   
  NI_TOP_NI_DEBUG_2_t                      DEBUG_2;                       /* addr: 0x00000310 */ 
  cs_uint32                                rsrvd96[3];                   
  NI_TOP_NI_SPARE_t                        SPARE;                         /* addr: 0x00000314 */ 
  cs_uint32                                rsrvd97[3];                   
  NI_TOP_NI_SPARESAMPLE_t                  SPARESAMPLE;                   /* addr: 0x00000318 */ 
  cs_uint32                                rsrvd98[3];                   
  NI_TOP_NI_FPGAA_ID_t                     FPGAA_ID;                      /* addr: 0x0000031c */ 
  cs_uint32                                rsrvd99[3];                   
  NI_TOP_NI_PORT_0_INTERRUPT_0_t           PORT_0_INTERRUPT_0;            /* addr: 0x00000320 */ 
  cs_uint32                                rsrvd100[3];                  
  NI_TOP_NI_PORT_0_INTENABLE_0_t           PORT_0_INTENABLE_0;            /* addr: 0x00000324 */ 
  cs_uint32                                rsrvd101[59];                 
  NI_TOP_NI_RXFIFO_INTERRUPT_0_t           RXFIFO_INTERRUPT_0;            /* addr: 0x00000360 */ 
  cs_uint32                                rsrvd102[3];                  
  NI_TOP_NI_RXFIFO_INTENABLE_0_t           RXFIFO_INTENABLE_0;            /* addr: 0x00000364 */ 
  cs_uint32                                rsrvd103[3];                  
  NI_TOP_NI_TXEM_INTERRUPT_0_t             TXEM_INTERRUPT_0;              /* addr: 0x00000368 */ 
  cs_uint32                                rsrvd104[3];                  
  NI_TOP_NI_TXEM_INTENABLE_0_t             TXEM_INTENABLE_0;              /* addr: 0x0000036c */ 
  cs_uint32                                rsrvd105[3];                  
  NI_TOP_NI_PC0_INTERRUPT_0_t              PC0_INTERRUPT_0;               /* addr: 0x00000370 */ 
  cs_uint32                                rsrvd106[3];                  
  NI_TOP_NI_PC0_INTENABLE_0_t              PC0_INTENABLE_0;               /* addr: 0x00000374 */ 
  cs_uint32                                rsrvd107[19];                 
  NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_0_t     CPUXRAM_CNTR_INTERRUPT_0;      /* addr: 0x00000388 */ 
  cs_uint32                                rsrvd108[3];                  
  NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_0_t     CPUXRAM_CNTR_INTENABLE_0;      /* addr: 0x0000038c */ 
  cs_uint32                                rsrvd109[3];                  
  NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_0_t      CPUXRAM_ERR_INTERRUPT_0;       /* addr: 0x00000390 */ 
  cs_uint32                                rsrvd110[3];                  
  NI_TOP_NI_CPUXRAM_ERR_INTENABLE_0_t      CPUXRAM_ERR_INTENABLE_0;       /* addr: 0x00000394 */ 
  cs_uint32                                rsrvd111[3];                  
  NI_TOP_NI_INTERRUPT_0_t                  INTERRUPT_0;                   /* addr: 0x00000398 */ 
  cs_uint32                                rsrvd112[3];                  
  NI_TOP_NI_INTENABLE_0_t                  INTENABLE_0;                   /* addr: 0x0000039c */ 
  cs_uint32                                rsrvd113[3];                  
  NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_0_t  CPUXRAM_RXPKT_0_INTERRUPT_0;   /* addr: 0x000003a0 */ 
  cs_uint32                                rsrvd114[3];                  
  NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_0_t  CPUXRAM_RXPKT_0_INTENABLE_0;   /* addr: 0x000003a4 */ 
  cs_uint32                                rsrvd115[67];                 
  NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_0_t    CPUXRAM_TXPKT_INTERRUPT_0;     /* addr: 0x000003e8 */ 
  cs_uint32                                rsrvd116[3];                  
  NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_0_t    CPUXRAM_TXPKT_INTENABLE_0;     /* addr: 0x000003ec */ 
  cs_uint32                                rsrvd117[3];                  
  NI_TOP_NI_WOL_STAT_0_INT_0_t             WOL_STAT_0_INT_0;              /* addr: 0x000003f0 */ 
  cs_uint32                                rsrvd118[3];                  
  NI_TOP_NI_WOL_STAT_0_INTENABLE_0_t       WOL_STAT_0_INTENABLE_0;        /* addr: 0x000003f4 */ 
  cs_uint32                                rsrvd119[19];                 
  NI_TOP_NI_PORT_0_INTERRUPT_1_t           PORT_0_INTERRUPT_1;            /* addr: 0x00000408 */ 
  cs_uint32                                rsrvd120[3];                  
  NI_TOP_NI_PORT_0_INTENABLE_1_t           PORT_0_INTENABLE_1;            /* addr: 0x0000040c */ 
  cs_uint32                                rsrvd121[59];                 
  NI_TOP_NI_RXFIFO_INTERRUPT_1_t           RXFIFO_INTERRUPT_1;            /* addr: 0x00000448 */ 
  cs_uint32                                rsrvd122[3];                  
  NI_TOP_NI_RXFIFO_INTENABLE_1_t           RXFIFO_INTENABLE_1;            /* addr: 0x0000044c */ 
  cs_uint32                                rsrvd123[3];                  
  NI_TOP_NI_TXEM_INTERRUPT_1_t             TXEM_INTERRUPT_1;              /* addr: 0x00000450 */ 
  cs_uint32                                rsrvd124[3];                  
  NI_TOP_NI_TXEM_INTENABLE_1_t             TXEM_INTENABLE_1;              /* addr: 0x00000454 */ 
  cs_uint32                                rsrvd125[3];                  
  NI_TOP_NI_PC0_INTERRUPT_1_t              PC0_INTERRUPT_1;               /* addr: 0x00000458 */ 
  cs_uint32                                rsrvd126[3];                  
  NI_TOP_NI_PC0_INTENABLE_1_t              PC0_INTENABLE_1;               /* addr: 0x0000045c */ 
  cs_uint32                                rsrvd127[19];                 
  NI_TOP_NI_CPUXRAM_CNTR_INTERRUPT_1_t     CPUXRAM_CNTR_INTERRUPT_1;      /* addr: 0x00000470 */ 
  cs_uint32                                rsrvd128[3];                  
  NI_TOP_NI_CPUXRAM_CNTR_INTENABLE_1_t     CPUXRAM_CNTR_INTENABLE_1;      /* addr: 0x00000474 */ 
  cs_uint32                                rsrvd129[3];                  
  NI_TOP_NI_CPUXRAM_ERR_INTERRUPT_1_t      CPUXRAM_ERR_INTERRUPT_1;       /* addr: 0x00000478 */ 
  cs_uint32                                rsrvd130[3];                  
  NI_TOP_NI_CPUXRAM_ERR_INTENABLE_1_t      CPUXRAM_ERR_INTENABLE_1;       /* addr: 0x0000047c */ 
  cs_uint32                                rsrvd131[3];                  
  NI_TOP_NI_INTERRUPT_1_t                  INTERRUPT_1;                   /* addr: 0x00000480 */ 
  cs_uint32                                rsrvd132[3];                  
  NI_TOP_NI_INTENABLE_1_t                  INTENABLE_1;                   /* addr: 0x00000484 */ 
  cs_uint32                                rsrvd133[3];                  
  NI_TOP_NI_CPUXRAM_RXPKT_0_INTERRUPT_1_t  CPUXRAM_RXPKT_0_INTERRUPT_1;   /* addr: 0x00000488 */ 
  cs_uint32                                rsrvd134[3];                  
  NI_TOP_NI_CPUXRAM_RXPKT_0_INTENABLE_1_t  CPUXRAM_RXPKT_0_INTENABLE_1;   /* addr: 0x0000048c */ 
  cs_uint32                                rsrvd135[67];                 
  NI_TOP_NI_CPUXRAM_TXPKT_INTERRUPT_1_t    CPUXRAM_TXPKT_INTERRUPT_1;     /* addr: 0x000004d0 */ 
  cs_uint32                                rsrvd136[3];                  
  NI_TOP_NI_CPUXRAM_TXPKT_INTENABLE_1_t    CPUXRAM_TXPKT_INTENABLE_1;     /* addr: 0x000004d4 */ 
  cs_uint32                                rsrvd137[3];                  
  NI_TOP_NI_WOL_STAT_0_INT_1_t             WOL_STAT_0_INT_1;              /* addr: 0x000004d8 */ 
  cs_uint32                                rsrvd138[3];                  
  NI_TOP_NI_WOL_STAT_0_INTENABLE_1_t       WOL_STAT_0_INTENABLE_1;        /* addr: 0x000004dc */ 
} NI_TOP_t;

  

/*
 * FETOP
 */
  
  
/*
 * FE
 */
  



#define FETOP_FE_SCRATCH                         0xf0020000
#define FETOP_FE_SCRATCH_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 scratch              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 scratch              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SCRATCH_t;





#define FETOP_FE_AN_BNG_MAC_ACCESS               0xf0020004
#define FETOP_FE_AN_BNG_MAC_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 ADDR                 :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_AN_BNG_MAC_ACCESS_t;





#define FETOP_FE_AN_BNG_MAC_DATA1                0xf0020008
#define FETOP_FE_AN_BNG_MAC_DATA1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 valid                :  1 ; /* bits 22:22 */
    cs_uint32 pspid_mask           :  1 ; /* bits 21:21 */
    cs_uint32 pspid                :  4 ; /* bits 20:17 */
    cs_uint32 sa_da                :  1 ; /* bits 16:16 */
    cs_uint32 mac_addr             : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mac_addr             : 16 ; /* bits 15:0 */
    cs_uint32 sa_da                :  1 ; /* bits 16:16 */
    cs_uint32 pspid                :  4 ; /* bits 20:17 */
    cs_uint32 pspid_mask           :  1 ; /* bits 21:21 */
    cs_uint32 valid                :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_AN_BNG_MAC_DATA1_t;





#define FETOP_FE_AN_BNG_MAC_DATA0                0xf002000c
#define FETOP_FE_AN_BNG_MAC_DATA0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mac_addr             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mac_addr             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_AN_BNG_MAC_DATA0_t;





#define FETOP_FE_L4_PORT_RNGS_ACCESS             0xf0020010
#define FETOP_FE_L4_PORT_RNGS_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 ADDR                 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L4_PORT_RNGS_ACCESS_t;





#define FETOP_FE_L4_PORT_RNGS_DATA1              0xf0020014
#define FETOP_FE_L4_PORT_RNGS_DATA1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 valid                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 valid                :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L4_PORT_RNGS_DATA1_t;





#define FETOP_FE_L4_PORT_RNGS_DATA0              0xf0020018
#define FETOP_FE_L4_PORT_RNGS_DATA0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sp_dp_low            : 16 ; /* bits 31:16 */
    cs_uint32 sp_dp_high           : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sp_dp_high           : 16 ; /* bits 15:0 */
    cs_uint32 sp_dp_low            : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L4_PORT_RNGS_DATA0_t;





#define FETOP_FE_ETYPE_ACCESS                    0xf002001c
#define FETOP_FE_ETYPE_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ETYPE_ACCESS_t;





#define FETOP_FE_ETYPE_DATA                      0xf0020020
#define FETOP_FE_ETYPE_DATA_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 valid                :  1 ; /* bits 16:16 */
    cs_uint32 ethertype            : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ethertype            : 16 ; /* bits 15:0 */
    cs_uint32 valid                :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 15 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ETYPE_DATA_t;





#define FETOP_FE_LLC_HDR_ACCESS                  0xf0020024
#define FETOP_FE_LLC_HDR_ACCESS_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 ADDR                 :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LLC_HDR_ACCESS_t;





#define FETOP_FE_LLC_HDR_DATA                    0xf0020028
#define FETOP_FE_LLC_HDR_DATA_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  7 ;
    cs_uint32 valid                :  1 ; /* bits 24:24 */
    cs_uint32 llc_hdr              : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 llc_hdr              : 24 ; /* bits 23:0 */
    cs_uint32 valid                :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd1               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LLC_HDR_DATA_t;





#define FETOP_FE_LLC_OTHER_A                     0xf002002c
#define FETOP_FE_LLC_OTHER_A_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 llc_other_a_mask     :  3 ; /* bits 26:24 */
    cs_uint32 llc_other_a          : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 llc_other_a          : 24 ; /* bits 23:0 */
    cs_uint32 llc_other_a_mask     :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LLC_OTHER_A_t;





#define FETOP_FE_LLC_OTHER_B                     0xf0020030
#define FETOP_FE_LLC_OTHER_B_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 llc_other_b_mask     :  3 ; /* bits 26:24 */
    cs_uint32 llc_other_b          : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 llc_other_b          : 24 ; /* bits 23:0 */
    cs_uint32 llc_other_b_mask     :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LLC_OTHER_B_t;





#define FETOP_FE_CFG_TPID1                       0xf0020034
#define FETOP_FE_CFG_TPID1_dft                   0x920088a8




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 tpid1                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 tpid1                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CFG_TPID1_t;





#define FETOP_FE_CFG_TPID0                       0xf0020038
#define FETOP_FE_CFG_TPID0_dft                   0x91008100




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 tpid0                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 tpid0                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CFG_TPID0_t;





#define FETOP_FE_PRSR_CFG_0                      0xf002003c
#define FETOP_FE_PRSR_CFG_0_dft                  0x60000380




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 parse_limit          :  5 ; /* bits 31:27 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 l4_chksum_rh_chk_disable :  1 ; /* bits 9:9 */
    cs_uint32 l4_chksum_chk_enable :  1 ; /* bits 8:8 */
    cs_uint32 ipv4_chksum_chk_enable :  1 ; /* bits 7:7 */
    cs_uint32 cfg_prog_offset      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cfg_prog_offset      :  7 ; /* bits 6:0 */
    cs_uint32 ipv4_chksum_chk_enable :  1 ; /* bits 7:7 */
    cs_uint32 l4_chksum_chk_enable :  1 ; /* bits 8:8 */
    cs_uint32 l4_chksum_rh_chk_disable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 parse_limit          :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PRSR_CFG_0_t;





#define FETOP_FE_CFG_GLBL                        0xf0020040
#define FETOP_FE_CFG_GLBL_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CFG_GLBL_t;





#define FETOP_FE_STS_GLBL                        0xf0020044
#define FETOP_FE_STS_GLBL_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 mem_init_done        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mem_init_done        :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_STS_GLBL_t;





#define FETOP_FE_PROC_CFG_0                      0xf0020048
#define FETOP_FE_PROC_CFG_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 drop_l4_chksum_err   :  1 ; /* bits 4:4 */
    cs_uint32 drop_l3_chksum_err   :  1 ; /* bits 3:3 */
    cs_uint32 keep_ts_for_cpu_voq  :  1 ; /* bits 2:2 */
    cs_uint32 drop_l4_chksum_err_bypass :  1 ; /* bits 1:1 */
    cs_uint32 drop_l3_chksum_err_bypass :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_l3_chksum_err_bypass :  1 ; /* bits 0:0 */
    cs_uint32 drop_l4_chksum_err_bypass :  1 ; /* bits 1:1 */
    cs_uint32 keep_ts_for_cpu_voq  :  1 ; /* bits 2:2 */
    cs_uint32 drop_l3_chksum_err   :  1 ; /* bits 3:3 */
    cs_uint32 drop_l4_chksum_err   :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PROC_CFG_0_t;





#define FETOP_FE_LPB_ACCESS                      0xf002004c
#define FETOP_FE_LPB_ACCESS_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 ADDR                 :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LPB_ACCESS_t;





#define FETOP_FE_LPB_DATA                        0xf0020050
#define FETOP_FE_LPB_DATA_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  7 ;
    cs_uint32 FE_LPB_MEM_PARITY    :  1 ; /* bits 24:24 */
    cs_uint32 FE_LPB_OLSPID_PRESERVE_EN :  1 ; /* bits 23:23 */
    cs_uint32 FE_LPB_OLSPID        :  4 ; /* bits 22:19 */
    cs_uint32 FE_LPB_OLSPID_EN     :  1 ; /* bits 18:18 */
    cs_uint32 FE_LPB_PVID_TPID_ENC :  2 ; /* bits 17:16 */
    cs_uint32 FE_LPB_PVID          : 12 ; /* bits 15:4 */
    cs_uint32 FE_LPB_LSPID         :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_LPB_LSPID         :  4 ; /* bits 3:0 */
    cs_uint32 FE_LPB_PVID          : 12 ; /* bits 15:4 */
    cs_uint32 FE_LPB_PVID_TPID_ENC :  2 ; /* bits 17:16 */
    cs_uint32 FE_LPB_OLSPID_EN     :  1 ; /* bits 18:18 */
    cs_uint32 FE_LPB_OLSPID        :  4 ; /* bits 22:19 */
    cs_uint32 FE_LPB_OLSPID_PRESERVE_EN :  1 ; /* bits 23:23 */
    cs_uint32 FE_LPB_MEM_PARITY    :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd1               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_LPB_DATA_t;





#define FETOP_FE_CLASS_ACCESS                    0xf0020054
#define FETOP_FE_CLASS_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_ACCESS_t;





#define FETOP_FE_CLASS_DATA19                    0xf0020058
#define FETOP_FE_CLASS_DATA19_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 FE_CLASS_MEM_PARITY  :  1 ; /* bits 21:21 */
    cs_uint32 FE_CLASS_ENTRY_VLD   :  1 ; /* bits 20:20 */
    cs_uint32 FE_CLASS_RULE_PRI    :  6 ; /* bits 19:14 */
    cs_uint32 FE_CLASS_RSVD_621_606 : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_RSVD_621_606 : 14 ; /* bits 13:0 */
    cs_uint32 FE_CLASS_RULE_PRI    :  6 ; /* bits 19:14 */
    cs_uint32 FE_CLASS_ENTRY_VLD   :  1 ; /* bits 20:20 */
    cs_uint32 FE_CLASS_MEM_PARITY  :  1 ; /* bits 21:21 */
    cs_uint32 rsrvd1               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA19_t;





#define FETOP_FE_CLASS_DATA18                    0xf002005c
#define FETOP_FE_CLASS_DATA18_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_RSVD_621_606 :  2 ; /* bits 31:30 */
    cs_uint32 FE_CLASS_MCGID_MASK  :  9 ; /* bits 29:21 */
    cs_uint32 FE_CLASS_MCGID       :  9 ; /* bits 20:12 */
    cs_uint32 FE_CLASS_SPI_MASK    :  1 ; /* bits 11:11 */
    cs_uint32 FE_CLASS_SPI         : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_SPI         : 11 ; /* bits 10:0 */
    cs_uint32 FE_CLASS_SPI_MASK    :  1 ; /* bits 11:11 */
    cs_uint32 FE_CLASS_MCGID       :  9 ; /* bits 20:12 */
    cs_uint32 FE_CLASS_MCGID_MASK  :  9 ; /* bits 29:21 */
    cs_uint32 FE_CLASS_RSVD_621_606 :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA18_t;





#define FETOP_FE_CLASS_DATA17                    0xf0020060
#define FETOP_FE_CLASS_DATA17_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_SPI         : 21 ; /* bits 31:11 */
    cs_uint32 FE_CLASS_SPI_VLD_MASK :  1 ; /* bits 10:10 */
    cs_uint32 FE_CLASS_SPI_VLD     :  1 ; /* bits 9:9 */
    cs_uint32 FE_CLASS_NOT_HDR_A_FLAGS_STSVLD_MASK :  1 ; /* bits 8:8 */
    cs_uint32 FE_CLASS_L4_CHKSUM_ERR_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_CLASS_L3_CHKSUM_ERR_MASK :  1 ; /* bits 6:6 */
    cs_uint32 FE_CLASS_HDR_A_FLAGS_CRCERR_MASK :  1 ; /* bits 5:5 */
    cs_uint32 FE_CLASS_LEN_ENCODED_MASK :  1 ; /* bits 4:4 */
    cs_uint32 FE_CLASS_BC_DA_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 FE_CLASS_MC_DA_MASK  :  1 ; /* bits 2:2 */
    cs_uint32 FE_CLASS_L4_VLD_MASK :  1 ; /* bits 1:1 */
    cs_uint32 FE_CLASS_IP_FRAGMENT_MASK :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_FRAGMENT_MASK :  1 ; /* bits 0:0 */
    cs_uint32 FE_CLASS_L4_VLD_MASK :  1 ; /* bits 1:1 */
    cs_uint32 FE_CLASS_MC_DA_MASK  :  1 ; /* bits 2:2 */
    cs_uint32 FE_CLASS_BC_DA_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 FE_CLASS_LEN_ENCODED_MASK :  1 ; /* bits 4:4 */
    cs_uint32 FE_CLASS_HDR_A_FLAGS_CRCERR_MASK :  1 ; /* bits 5:5 */
    cs_uint32 FE_CLASS_L3_CHKSUM_ERR_MASK :  1 ; /* bits 6:6 */
    cs_uint32 FE_CLASS_L4_CHKSUM_ERR_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_CLASS_NOT_HDR_A_FLAGS_STSVLD_MASK :  1 ; /* bits 8:8 */
    cs_uint32 FE_CLASS_SPI_VLD     :  1 ; /* bits 9:9 */
    cs_uint32 FE_CLASS_SPI_VLD_MASK :  1 ; /* bits 10:10 */
    cs_uint32 FE_CLASS_SPI         : 21 ; /* bits 31:11 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA17_t;





#define FETOP_FE_CLASS_DATA16                    0xf0020064
#define FETOP_FE_CLASS_DATA16_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_VER_MASK :  1 ; /* bits 31:31 */
    cs_uint32 FE_CLASS_IP_VLD_MASK :  1 ; /* bits 30:30 */
    cs_uint32 FE_CLASS_IP_SA_MASK  :  9 ; /* bits 29:21 */
    cs_uint32 FE_CLASS_IP_DA_MASK  :  9 ; /* bits 20:12 */
    cs_uint32 FE_CLASS_SA_MASK     :  6 ; /* bits 11:6 */
    cs_uint32 FE_CLASS_DA_MASK     :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_DA_MASK     :  6 ; /* bits 5:0 */
    cs_uint32 FE_CLASS_SA_MASK     :  6 ; /* bits 11:6 */
    cs_uint32 FE_CLASS_IP_DA_MASK  :  9 ; /* bits 20:12 */
    cs_uint32 FE_CLASS_IP_SA_MASK  :  9 ; /* bits 29:21 */
    cs_uint32 FE_CLASS_IP_VLD_MASK :  1 ; /* bits 30:30 */
    cs_uint32 FE_CLASS_IP_VER_MASK :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA16_t;





#define FETOP_FE_CLASS_DATA15                    0xf0020068
#define FETOP_FE_CLASS_DATA15_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_L4_PORT_MASK :  2 ; /* bits 31:30 */
    cs_uint32 FE_CLASS_IP_PROT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 FE_CLASS_ETHERTYPE_ENC_MASK :  1 ; /* bits 28:28 */
    cs_uint32 FE_CLASS_ECN_MASK    :  2 ; /* bits 27:26 */
    cs_uint32 FE_CLASS_DSCP_MASK   :  6 ; /* bits 25:20 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 19:19 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 18:18 */
    cs_uint32 FE_CLASS_DA_AN_MAC_HIT_MASK :  1 ; /* bits 17:17 */
    cs_uint32 FE_CLASS_DA_AN_MAC_SEL_MASK :  1 ; /* bits 16:16 */
    cs_uint32 FE_CLASS_8021P_2_MASK :  1 ; /* bits 15:15 */
    cs_uint32 FE_CLASS_VID_2_MASK  :  1 ; /* bits 14:14 */
    cs_uint32 FE_CLASS_TPID_ENC_2_LSB_MASK :  1 ; /* bits 13:13 */
    cs_uint32 FE_CLASS_TPID_ENC_2_MSB_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_CLASS_8021P_1_MASK :  1 ; /* bits 11:11 */
    cs_uint32 FE_CLASS_VID_1_MASK  :  2 ; /* bits 10:9 */
    cs_uint32 FE_CLASS_TPID_ENC_1_LSB_MASK :  1 ; /* bits 8:8 */
    cs_uint32 FE_CLASS_TPID_ENC_1_MSB_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_CLASS_FWDTYPE_MASK :  4 ; /* bits 6:3 */
    cs_uint32 FE_CLASS_HDR_A_ORIG_LSPID_MASK :  1 ; /* bits 2:2 */
    cs_uint32 FE_CLASS_LSPID_MASK  :  1 ; /* bits 1:1 */
    cs_uint32 FE_CLASS_NOT_HDR_A_FLAGS_STSVLD :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_NOT_HDR_A_FLAGS_STSVLD :  1 ; /* bits 0:0 */
    cs_uint32 FE_CLASS_LSPID_MASK  :  1 ; /* bits 1:1 */
    cs_uint32 FE_CLASS_HDR_A_ORIG_LSPID_MASK :  1 ; /* bits 2:2 */
    cs_uint32 FE_CLASS_FWDTYPE_MASK :  4 ; /* bits 6:3 */
    cs_uint32 FE_CLASS_TPID_ENC_1_MSB_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_CLASS_TPID_ENC_1_LSB_MASK :  1 ; /* bits 8:8 */
    cs_uint32 FE_CLASS_VID_1_MASK  :  2 ; /* bits 10:9 */
    cs_uint32 FE_CLASS_8021P_1_MASK :  1 ; /* bits 11:11 */
    cs_uint32 FE_CLASS_TPID_ENC_2_MSB_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_CLASS_TPID_ENC_2_LSB_MASK :  1 ; /* bits 13:13 */
    cs_uint32 FE_CLASS_VID_2_MASK  :  1 ; /* bits 14:14 */
    cs_uint32 FE_CLASS_8021P_2_MASK :  1 ; /* bits 15:15 */
    cs_uint32 FE_CLASS_DA_AN_MAC_SEL_MASK :  1 ; /* bits 16:16 */
    cs_uint32 FE_CLASS_DA_AN_MAC_HIT_MASK :  1 ; /* bits 17:17 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 18:18 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 19:19 */
    cs_uint32 FE_CLASS_DSCP_MASK   :  6 ; /* bits 25:20 */
    cs_uint32 FE_CLASS_ECN_MASK    :  2 ; /* bits 27:26 */
    cs_uint32 FE_CLASS_ETHERTYPE_ENC_MASK :  1 ; /* bits 28:28 */
    cs_uint32 FE_CLASS_IP_PROT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 FE_CLASS_L4_PORT_MASK :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA15_t;





#define FETOP_FE_CLASS_DATA14                    0xf002006c
#define FETOP_FE_CLASS_DATA14_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_L4_CHKSUM_ERR :  1 ; /* bits 31:31 */
    cs_uint32 FE_CLASS_L3_CHKSUM_ERR :  1 ; /* bits 30:30 */
    cs_uint32 FE_CLASS_HDR_A_FLAGS_CRCERR :  1 ; /* bits 29:29 */
    cs_uint32 FE_CLASS_LEN_ENCODED :  1 ; /* bits 28:28 */
    cs_uint32 FE_CLASS_BC_DA       :  1 ; /* bits 27:27 */
    cs_uint32 FE_CLASS_MC_DA       :  1 ; /* bits 26:26 */
    cs_uint32 FE_CLASS_L4_VLD      :  1 ; /* bits 25:25 */
    cs_uint32 FE_CLASS_IP_FRAGMENT :  1 ; /* bits 24:24 */
    cs_uint32 FE_CLASS_IP_VER      :  1 ; /* bits 23:23 */
    cs_uint32 FE_CLASS_IP_VLD      :  1 ; /* bits 22:22 */
    cs_uint32 FE_CLASS_IP_SA       : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_SA       : 22 ; /* bits 21:0 */
    cs_uint32 FE_CLASS_IP_VLD      :  1 ; /* bits 22:22 */
    cs_uint32 FE_CLASS_IP_VER      :  1 ; /* bits 23:23 */
    cs_uint32 FE_CLASS_IP_FRAGMENT :  1 ; /* bits 24:24 */
    cs_uint32 FE_CLASS_L4_VLD      :  1 ; /* bits 25:25 */
    cs_uint32 FE_CLASS_MC_DA       :  1 ; /* bits 26:26 */
    cs_uint32 FE_CLASS_BC_DA       :  1 ; /* bits 27:27 */
    cs_uint32 FE_CLASS_LEN_ENCODED :  1 ; /* bits 28:28 */
    cs_uint32 FE_CLASS_HDR_A_FLAGS_CRCERR :  1 ; /* bits 29:29 */
    cs_uint32 FE_CLASS_L3_CHKSUM_ERR :  1 ; /* bits 30:30 */
    cs_uint32 FE_CLASS_L4_CHKSUM_ERR :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA14_t;





#define FETOP_FE_CLASS_DATA13                    0xf0020070
#define FETOP_FE_CLASS_DATA13_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA13_t;





#define FETOP_FE_CLASS_DATA12                    0xf0020074
#define FETOP_FE_CLASS_DATA12_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA12_t;





#define FETOP_FE_CLASS_DATA11                    0xf0020078
#define FETOP_FE_CLASS_DATA11_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA11_t;





#define FETOP_FE_CLASS_DATA10                    0xf002007c
#define FETOP_FE_CLASS_DATA10_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_SA       : 10 ; /* bits 31:22 */
    cs_uint32 FE_CLASS_IP_DA       : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_DA       : 22 ; /* bits 21:0 */
    cs_uint32 FE_CLASS_IP_SA       : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA10_t;





#define FETOP_FE_CLASS_DATA9                     0xf0020080
#define FETOP_FE_CLASS_DATA9_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA9_t;





#define FETOP_FE_CLASS_DATA8                     0xf0020084
#define FETOP_FE_CLASS_DATA8_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA8_t;





#define FETOP_FE_CLASS_DATA7                     0xf0020088
#define FETOP_FE_CLASS_DATA7_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA7_t;





#define FETOP_FE_CLASS_DATA6                     0xf002008c
#define FETOP_FE_CLASS_DATA6_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_IP_DA       : 10 ; /* bits 31:22 */
    cs_uint32 FE_CLASS_SA          : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_SA          : 22 ; /* bits 21:0 */
    cs_uint32 FE_CLASS_IP_DA       : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA6_t;





#define FETOP_FE_CLASS_DATA5                     0xf0020090
#define FETOP_FE_CLASS_DATA5_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_SA          : 26 ; /* bits 31:6 */
    cs_uint32 FE_CLASS_DA          :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_DA          :  6 ; /* bits 5:0 */
    cs_uint32 FE_CLASS_SA          : 26 ; /* bits 31:6 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA5_t;





#define FETOP_FE_CLASS_DATA4                     0xf0020094
#define FETOP_FE_CLASS_DATA4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_DA          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_DA          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA4_t;





#define FETOP_FE_CLASS_DATA3                     0xf0020098
#define FETOP_FE_CLASS_DATA3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_DA          : 10 ; /* bits 31:22 */
    cs_uint32 FE_CLASS_L4_DP       : 16 ; /* bits 21:6 */
    cs_uint32 FE_CLASS_L4_SP       :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_L4_SP       :  6 ; /* bits 5:0 */
    cs_uint32 FE_CLASS_L4_DP       : 16 ; /* bits 21:6 */
    cs_uint32 FE_CLASS_DA          : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA3_t;





#define FETOP_FE_CLASS_DATA2                     0xf002009c
#define FETOP_FE_CLASS_DATA2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_L4_SP       : 10 ; /* bits 31:22 */
    cs_uint32 FE_CLASS_IP_PROT     :  8 ; /* bits 21:14 */
    cs_uint32 FE_CLASS_ETHERTYPE_ENC :  6 ; /* bits 13:8 */
    cs_uint32 FE_CLASS_ECN         :  2 ; /* bits 7:6 */
    cs_uint32 FE_CLASS_DSCP        :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_DSCP        :  6 ; /* bits 5:0 */
    cs_uint32 FE_CLASS_ECN         :  2 ; /* bits 7:6 */
    cs_uint32 FE_CLASS_ETHERTYPE_ENC :  6 ; /* bits 13:8 */
    cs_uint32 FE_CLASS_IP_PROT     :  8 ; /* bits 21:14 */
    cs_uint32 FE_CLASS_L4_SP       : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA2_t;





#define FETOP_FE_CLASS_DATA1                     0xf00200a0
#define FETOP_FE_CLASS_DATA1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_SA_BNG_MAC_HIT :  1 ; /* bits 31:31 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_SEL :  4 ; /* bits 30:27 */
    cs_uint32 FE_CLASS_DA_AN_MAC_HIT :  1 ; /* bits 26:26 */
    cs_uint32 FE_CLASS_DA_AN_MAC_SEL :  4 ; /* bits 25:22 */
    cs_uint32 FE_CLASS_8021P_2     :  3 ; /* bits 21:19 */
    cs_uint32 FE_CLASS_VID_2       : 12 ; /* bits 18:7 */
    cs_uint32 FE_CLASS_TPID_ENC_2  :  3 ; /* bits 6:4 */
    cs_uint32 FE_CLASS_8021P_1     :  3 ; /* bits 3:1 */
    cs_uint32 FE_CLASS_VID_1       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_VID_1       :  1 ; /* bits 0:0 */
    cs_uint32 FE_CLASS_8021P_1     :  3 ; /* bits 3:1 */
    cs_uint32 FE_CLASS_TPID_ENC_2  :  3 ; /* bits 6:4 */
    cs_uint32 FE_CLASS_VID_2       : 12 ; /* bits 18:7 */
    cs_uint32 FE_CLASS_8021P_2     :  3 ; /* bits 21:19 */
    cs_uint32 FE_CLASS_DA_AN_MAC_SEL :  4 ; /* bits 25:22 */
    cs_uint32 FE_CLASS_DA_AN_MAC_HIT :  1 ; /* bits 26:26 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_SEL :  4 ; /* bits 30:27 */
    cs_uint32 FE_CLASS_SA_BNG_MAC_HIT :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA1_t;





#define FETOP_FE_CLASS_DATA0                     0xf00200a4
#define FETOP_FE_CLASS_DATA0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_CLASS_VID_1       : 11 ; /* bits 31:21 */
    cs_uint32 FE_CLASS_TPID_ENC_1  :  3 ; /* bits 20:18 */
    cs_uint32 FE_CLASS_FWDTYPE     :  4 ; /* bits 17:14 */
    cs_uint32 FE_CLASS_HDR_A_ORIG_LSPID :  4 ; /* bits 13:10 */
    cs_uint32 FE_CLASS_LSPID       :  4 ; /* bits 9:6 */
    cs_uint32 FE_CLASS_SVIDX       :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_CLASS_SVIDX       :  6 ; /* bits 5:0 */
    cs_uint32 FE_CLASS_LSPID       :  4 ; /* bits 9:6 */
    cs_uint32 FE_CLASS_HDR_A_ORIG_LSPID :  4 ; /* bits 13:10 */
    cs_uint32 FE_CLASS_FWDTYPE     :  4 ; /* bits 17:14 */
    cs_uint32 FE_CLASS_TPID_ENC_1  :  3 ; /* bits 20:18 */
    cs_uint32 FE_CLASS_VID_1       : 11 ; /* bits 31:21 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_CLASS_DATA0_t;





#define FETOP_FE_SDB_ACCESS                      0xf00200a8
#define FETOP_FE_SDB_ACCESS_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_ACCESS_t;





#define FETOP_FE_SDB_DATA6                       0xf00200ac
#define FETOP_FE_SDB_DATA6_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 FE_SDB_MEM_PARITY    :  1 ; /* bits 14:14 */
    cs_uint32 FE_SDB_ACL_DISABLE   :  1 ; /* bits 13:13 */
    cs_uint32 FE_SDB_EGRVLN_INGR_MBRSHP_EN :  1 ; /* bits 12:12 */
    cs_uint32 FE_SDB_DROP          :  1 ; /* bits 11:11 */
    cs_uint32 FE_SDB_RSVD_202      :  1 ; /* bits 10:10 */
    cs_uint32 FE_SDB_UM_FLOWIDX    : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_UM_FLOWIDX    : 10 ; /* bits 9:0 */
    cs_uint32 FE_SDB_RSVD_202      :  1 ; /* bits 10:10 */
    cs_uint32 FE_SDB_DROP          :  1 ; /* bits 11:11 */
    cs_uint32 FE_SDB_EGRVLN_INGR_MBRSHP_EN :  1 ; /* bits 12:12 */
    cs_uint32 FE_SDB_ACL_DISABLE   :  1 ; /* bits 13:13 */
    cs_uint32 FE_SDB_MEM_PARITY    :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA6_t;





#define FETOP_FE_SDB_DATA5                       0xf00200b0
#define FETOP_FE_SDB_DATA5_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_UM_FLOWIDX    :  3 ; /* bits 31:29 */
    cs_uint32 FE_SDB_BC_FLOWIDX    : 13 ; /* bits 28:16 */
    cs_uint32 FE_SDB_HTPL_STSUPDT_CNTL :  2 ; /* bits 15:14 */
    cs_uint32 FE_SDB_UU_FLOWIDX    : 13 ; /* bits 13:1 */
    cs_uint32 FE_SDB_KEYRULE       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_KEYRULE       :  1 ; /* bits 0:0 */
    cs_uint32 FE_SDB_UU_FLOWIDX    : 13 ; /* bits 13:1 */
    cs_uint32 FE_SDB_HTPL_STSUPDT_CNTL :  2 ; /* bits 15:14 */
    cs_uint32 FE_SDB_BC_FLOWIDX    : 13 ; /* bits 28:16 */
    cs_uint32 FE_SDB_UM_FLOWIDX    :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA5_t;





#define FETOP_FE_SDB_DATA4                       0xf00200b4
#define FETOP_FE_SDB_DATA4_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_KEYRULE       :  5 ; /* bits 31:27 */
    cs_uint32 FE_SDB_TTL_HOPLIMIT_ZERO_DISCARD_EN :  1 ; /* bits 26:26 */
    cs_uint32 FE_SDB_USE_EGRLEN_FLOW_POLICER :  1 ; /* bits 25:25 */
    cs_uint32 FE_SDB_USE_EGRLEN_SRC_POLICER :  1 ; /* bits 24:24 */
    cs_uint32 FE_SDB_USE_EGRLEN_PKTTYPE_POLICER :  1 ; /* bits 23:23 */
    cs_uint32 FE_SDB_VLAN_EGRUNTAG_CHK_EN :  1 ; /* bits 22:22 */
    cs_uint32 FE_SDB_VLAN_EGR_MBRSHP_EN :  1 ; /* bits 21:21 */
    cs_uint32 FE_SDB_VLAN_INGR_MBRSHP_EN :  1 ; /* bits 20:20 */
    cs_uint32 FE_SDB_PVID_EN       :  1 ; /* bits 19:19 */
    cs_uint32 FE_SDB_PVID_TPID_ENC :  2 ; /* bits 18:17 */
    cs_uint32 FE_SDB_PVID          : 12 ; /* bits 16:5 */
    cs_uint32 FE_SDB_LPM_IPV6_PTR1_EN :  1 ; /* bits 4:4 */
    cs_uint32 FE_SDB_LPM_IPV6_PTR0_EN :  1 ; /* bits 3:3 */
    cs_uint32 FE_SDB_LPM_IPV4_PTR1_EN :  1 ; /* bits 2:2 */
    cs_uint32 FE_SDB_LPM_IPV4_PTR0_EN :  1 ; /* bits 1:1 */
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR1 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR1 :  1 ; /* bits 0:0 */
    cs_uint32 FE_SDB_LPM_IPV4_PTR0_EN :  1 ; /* bits 1:1 */
    cs_uint32 FE_SDB_LPM_IPV4_PTR1_EN :  1 ; /* bits 2:2 */
    cs_uint32 FE_SDB_LPM_IPV6_PTR0_EN :  1 ; /* bits 3:3 */
    cs_uint32 FE_SDB_LPM_IPV6_PTR1_EN :  1 ; /* bits 4:4 */
    cs_uint32 FE_SDB_PVID          : 12 ; /* bits 16:5 */
    cs_uint32 FE_SDB_PVID_TPID_ENC :  2 ; /* bits 18:17 */
    cs_uint32 FE_SDB_PVID_EN       :  1 ; /* bits 19:19 */
    cs_uint32 FE_SDB_VLAN_INGR_MBRSHP_EN :  1 ; /* bits 20:20 */
    cs_uint32 FE_SDB_VLAN_EGR_MBRSHP_EN :  1 ; /* bits 21:21 */
    cs_uint32 FE_SDB_VLAN_EGRUNTAG_CHK_EN :  1 ; /* bits 22:22 */
    cs_uint32 FE_SDB_USE_EGRLEN_PKTTYPE_POLICER :  1 ; /* bits 23:23 */
    cs_uint32 FE_SDB_USE_EGRLEN_SRC_POLICER :  1 ; /* bits 24:24 */
    cs_uint32 FE_SDB_USE_EGRLEN_FLOW_POLICER :  1 ; /* bits 25:25 */
    cs_uint32 FE_SDB_TTL_HOPLIMIT_ZERO_DISCARD_EN :  1 ; /* bits 26:26 */
    cs_uint32 FE_SDB_KEYRULE       :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA4_t;





#define FETOP_FE_SDB_DATA3                       0xf00200b8
#define FETOP_FE_SDB_DATA3_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR1 :  3 ; /* bits 31:29 */
    cs_uint32 FE_SDB_LPM_IPV6_START_PTR1 :  4 ; /* bits 28:25 */
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR0 :  4 ; /* bits 24:21 */
    cs_uint32 FE_SDB_LPM_IPV6_START_PTR0 :  4 ; /* bits 20:17 */
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR1 :  6 ; /* bits 16:11 */
    cs_uint32 FE_SDB_LPM_IPV4_START_PTR1 :  6 ; /* bits 10:5 */
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR0 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR0 :  5 ; /* bits 4:0 */
    cs_uint32 FE_SDB_LPM_IPV4_START_PTR1 :  6 ; /* bits 10:5 */
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR1 :  6 ; /* bits 16:11 */
    cs_uint32 FE_SDB_LPM_IPV6_START_PTR0 :  4 ; /* bits 20:17 */
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR0 :  4 ; /* bits 24:21 */
    cs_uint32 FE_SDB_LPM_IPV6_START_PTR1 :  4 ; /* bits 28:25 */
    cs_uint32 FE_SDB_LPM_IPV6_END_PTR1 :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA3_t;





#define FETOP_FE_SDB_DATA2                       0xf00200bc
#define FETOP_FE_SDB_DATA2_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR0 :  1 ; /* bits 31:31 */
    cs_uint32 FE_SDB_LPM_IPV4_START_PTR0 :  6 ; /* bits 30:25 */
    cs_uint32 FE_SDB_LPM_EN        :  1 ; /* bits 24:24 */
    cs_uint32 FE_SDB_HTUPL_PRI_7   :  4 ; /* bits 23:20 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_7 :  6 ; /* bits 19:14 */
    cs_uint32 FE_SDB_HTUPL_EN_7    :  1 ; /* bits 13:13 */
    cs_uint32 FE_SDB_HTUPL_PRI_6   :  4 ; /* bits 12:9 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_6 :  6 ; /* bits 8:3 */
    cs_uint32 FE_SDB_HTUPL_EN_6    :  1 ; /* bits 2:2 */
    cs_uint32 FE_SDB_HTUPL_PRI_5   :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_HTUPL_PRI_5   :  2 ; /* bits 1:0 */
    cs_uint32 FE_SDB_HTUPL_EN_6    :  1 ; /* bits 2:2 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_6 :  6 ; /* bits 8:3 */
    cs_uint32 FE_SDB_HTUPL_PRI_6   :  4 ; /* bits 12:9 */
    cs_uint32 FE_SDB_HTUPL_EN_7    :  1 ; /* bits 13:13 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_7 :  6 ; /* bits 19:14 */
    cs_uint32 FE_SDB_HTUPL_PRI_7   :  4 ; /* bits 23:20 */
    cs_uint32 FE_SDB_LPM_EN        :  1 ; /* bits 24:24 */
    cs_uint32 FE_SDB_LPM_IPV4_START_PTR0 :  6 ; /* bits 30:25 */
    cs_uint32 FE_SDB_LPM_IPV4_END_PTR0 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA2_t;





#define FETOP_FE_SDB_DATA1                       0xf00200c0
#define FETOP_FE_SDB_DATA1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_HTUPL_PRI_5   :  2 ; /* bits 31:30 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_5 :  6 ; /* bits 29:24 */
    cs_uint32 FE_SDB_HTUPL_EN_5    :  1 ; /* bits 23:23 */
    cs_uint32 FE_SDB_HTUPL_PRI_4   :  4 ; /* bits 22:19 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_4 :  6 ; /* bits 18:13 */
    cs_uint32 FE_SDB_HTUPL_EN_4    :  1 ; /* bits 12:12 */
    cs_uint32 FE_SDB_HTUPL_PRI_3   :  4 ; /* bits 11:8 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_3 :  6 ; /* bits 7:2 */
    cs_uint32 FE_SDB_HTUPL_EN_3    :  1 ; /* bits 1:1 */
    cs_uint32 FE_SDB_HTUPL_PRI_2   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_HTUPL_PRI_2   :  1 ; /* bits 0:0 */
    cs_uint32 FE_SDB_HTUPL_EN_3    :  1 ; /* bits 1:1 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_3 :  6 ; /* bits 7:2 */
    cs_uint32 FE_SDB_HTUPL_PRI_3   :  4 ; /* bits 11:8 */
    cs_uint32 FE_SDB_HTUPL_EN_4    :  1 ; /* bits 12:12 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_4 :  6 ; /* bits 18:13 */
    cs_uint32 FE_SDB_HTUPL_PRI_4   :  4 ; /* bits 22:19 */
    cs_uint32 FE_SDB_HTUPL_EN_5    :  1 ; /* bits 23:23 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_5 :  6 ; /* bits 29:24 */
    cs_uint32 FE_SDB_HTUPL_PRI_5   :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA1_t;





#define FETOP_FE_SDB_DATA0                       0xf00200c4
#define FETOP_FE_SDB_DATA0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_SDB_HTUPL_PRI_2   :  3 ; /* bits 31:29 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_2 :  6 ; /* bits 28:23 */
    cs_uint32 FE_SDB_HTUPL_EN_2    :  1 ; /* bits 22:22 */
    cs_uint32 FE_SDB_HTUPL_PRI_1   :  4 ; /* bits 21:18 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_1 :  6 ; /* bits 17:12 */
    cs_uint32 FE_SDB_HTUPL_EN_1    :  1 ; /* bits 11:11 */
    cs_uint32 FE_SDB_HTUPL_PRI_0   :  4 ; /* bits 10:7 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_0 :  6 ; /* bits 6:1 */
    cs_uint32 FE_SDB_HTUPL_EN_0    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_SDB_HTUPL_EN_0    :  1 ; /* bits 0:0 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_0 :  6 ; /* bits 6:1 */
    cs_uint32 FE_SDB_HTUPL_PRI_0   :  4 ; /* bits 10:7 */
    cs_uint32 FE_SDB_HTUPL_EN_1    :  1 ; /* bits 11:11 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_1 :  6 ; /* bits 17:12 */
    cs_uint32 FE_SDB_HTUPL_PRI_1   :  4 ; /* bits 21:18 */
    cs_uint32 FE_SDB_HTUPL_EN_2    :  1 ; /* bits 22:22 */
    cs_uint32 FE_SDB_HTUPL_MASK_PTR_2 :  6 ; /* bits 28:23 */
    cs_uint32 FE_SDB_HTUPL_PRI_2   :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_SDB_DATA0_t;





#define FETOP_FE_VLN_ACCESS                      0xf00200c8
#define FETOP_FE_VLN_ACCESS_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 ADDR                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VLN_ACCESS_t;





#define FETOP_FE_VLN_DATA1                       0xf00200cc
#define FETOP_FE_VLN_DATA1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_VLN_MEM_PARITY    :  1 ; /* bits 31:31 */
    cs_uint32 FE_VLN_MCGID         :  9 ; /* bits 30:22 */
    cs_uint32 FE_VLN_SECOND_TPID_ENC :  2 ; /* bits 21:20 */
    cs_uint32 FE_VLN_SECOND_VID    : 12 ; /* bits 19:8 */
    cs_uint32 FE_VLN_SECOND_VLAN_CMD :  5 ; /* bits 7:3 */
    cs_uint32 FE_VLN_FIRST_TPID_ENC :  2 ; /* bits 2:1 */
    cs_uint32 FE_VLN_FIRST_VID     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_VLN_FIRST_VID     :  1 ; /* bits 0:0 */
    cs_uint32 FE_VLN_FIRST_TPID_ENC :  2 ; /* bits 2:1 */
    cs_uint32 FE_VLN_SECOND_VLAN_CMD :  5 ; /* bits 7:3 */
    cs_uint32 FE_VLN_SECOND_VID    : 12 ; /* bits 19:8 */
    cs_uint32 FE_VLN_SECOND_TPID_ENC :  2 ; /* bits 21:20 */
    cs_uint32 FE_VLN_MCGID         :  9 ; /* bits 30:22 */
    cs_uint32 FE_VLN_MEM_PARITY    :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VLN_DATA1_t;





#define FETOP_FE_VLN_DATA0                       0xf00200d0
#define FETOP_FE_VLN_DATA0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_VLN_FIRST_VID     : 11 ; /* bits 31:21 */
    cs_uint32 FE_VLN_FIRST_VLAN_CMD :  5 ; /* bits 20:16 */
    cs_uint32 FE_VLN_FID           :  4 ; /* bits 15:12 */
    cs_uint32 FE_VLN_EGR_UNTAGGED  :  6 ; /* bits 11:6 */
    cs_uint32 FE_VLN_MEMBER        :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_VLN_MEMBER        :  6 ; /* bits 5:0 */
    cs_uint32 FE_VLN_EGR_UNTAGGED  :  6 ; /* bits 11:6 */
    cs_uint32 FE_VLN_FID           :  4 ; /* bits 15:12 */
    cs_uint32 FE_VLN_FIRST_VLAN_CMD :  5 ; /* bits 20:16 */
    cs_uint32 FE_VLN_FIRST_VID     : 11 ; /* bits 31:21 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VLN_DATA0_t;





#define FETOP_FE_FWDRSLT_ACCESS                  0xf00200d4
#define FETOP_FE_FWDRSLT_ACCESS_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 ADDR                 : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWDRSLT_ACCESS_t;





#define FETOP_FE_FWDRSLT_DATA3                   0xf00200d8
#define FETOP_FE_FWDRSLT_DATA3_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 FWD_MEM_PARITY       :  1 ; /* bits 17:17 */
    cs_uint32 FWD_PPPOE_DECAP_EN   :  1 ; /* bits 16:16 */
    cs_uint32 FWD_PPPOE_ENCAP_EN   :  1 ; /* bits 15:15 */
    cs_uint32 FWD_DROP             :  1 ; /* bits 14:14 */
    cs_uint32 FWD_FLOW_VLANTBL_IDX :  9 ; /* bits 13:5 */
    cs_uint32 FWD_FLOW_VLAN_OP_EN  :  1 ; /* bits 4:4 */
    cs_uint32 FWD_DECR_TTL_HOPLIMIT :  1 ; /* bits 3:3 */
    cs_uint32 FWD_FWDTYPE          :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_FWDTYPE          :  3 ; /* bits 2:0 */
    cs_uint32 FWD_DECR_TTL_HOPLIMIT :  1 ; /* bits 3:3 */
    cs_uint32 FWD_FLOW_VLAN_OP_EN  :  1 ; /* bits 4:4 */
    cs_uint32 FWD_FLOW_VLANTBL_IDX :  9 ; /* bits 13:5 */
    cs_uint32 FWD_DROP             :  1 ; /* bits 14:14 */
    cs_uint32 FWD_PPPOE_ENCAP_EN   :  1 ; /* bits 15:15 */
    cs_uint32 FWD_PPPOE_DECAP_EN   :  1 ; /* bits 16:16 */
    cs_uint32 FWD_MEM_PARITY       :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWDRSLT_DATA3_t;





#define FETOP_FE_FWDRSLT_DATA2                   0xf00200dc
#define FETOP_FE_FWDRSLT_DATA2_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_FWDTYPE          :  1 ; /* bits 31:31 */
    cs_uint32 FWD_FWDTYPE_VLD      :  1 ; /* bits 30:30 */
    cs_uint32 FWD_ACL_DISABLE      :  1 ; /* bits 29:29 */
    cs_uint32 FWD_MCGID_VLD        :  1 ; /* bits 28:28 */
    cs_uint32 FWD_MCGID            :  9 ; /* bits 27:19 */
    cs_uint32 FWD_L2_IDX           :  9 ; /* bits 18:10 */
    cs_uint32 FWD_MAC_DA_REPLACE_EN :  1 ; /* bits 9:9 */
    cs_uint32 FWD_MAC_SA_REPLACE_EN :  1 ; /* bits 8:8 */
    cs_uint32 FWD_L4_DP            :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L4_DP            :  8 ; /* bits 7:0 */
    cs_uint32 FWD_MAC_SA_REPLACE_EN :  1 ; /* bits 8:8 */
    cs_uint32 FWD_MAC_DA_REPLACE_EN :  1 ; /* bits 9:9 */
    cs_uint32 FWD_L2_IDX           :  9 ; /* bits 18:10 */
    cs_uint32 FWD_MCGID            :  9 ; /* bits 27:19 */
    cs_uint32 FWD_MCGID_VLD        :  1 ; /* bits 28:28 */
    cs_uint32 FWD_ACL_DISABLE      :  1 ; /* bits 29:29 */
    cs_uint32 FWD_FWDTYPE_VLD      :  1 ; /* bits 30:30 */
    cs_uint32 FWD_FWDTYPE          :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWDRSLT_DATA2_t;





#define FETOP_FE_FWDRSLT_DATA1                   0xf00200e0
#define FETOP_FE_FWDRSLT_DATA1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L4_DP            :  8 ; /* bits 31:24 */
    cs_uint32 FWD_L4_DP_REPLACE_EN :  1 ; /* bits 23:23 */
    cs_uint32 FWD_L4_SP            : 16 ; /* bits 22:7 */
    cs_uint32 FWD_L4_SP_REPLACE_EN :  1 ; /* bits 6:6 */
    cs_uint32 FWD_IP_DA_IDX        :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_IP_DA_IDX        :  6 ; /* bits 5:0 */
    cs_uint32 FWD_L4_SP_REPLACE_EN :  1 ; /* bits 6:6 */
    cs_uint32 FWD_L4_SP            : 16 ; /* bits 22:7 */
    cs_uint32 FWD_L4_DP_REPLACE_EN :  1 ; /* bits 23:23 */
    cs_uint32 FWD_L4_DP            :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWDRSLT_DATA1_t;





#define FETOP_FE_FWDRSLT_DATA0                   0xf00200e4
#define FETOP_FE_FWDRSLT_DATA0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_IP_DA_IDX        :  6 ; /* bits 31:26 */
    cs_uint32 FWD_IP_DA_REPLACE_EN :  1 ; /* bits 25:25 */
    cs_uint32 FWD_IP_SA_IDX        : 12 ; /* bits 24:13 */
    cs_uint32 FWD_IP_SA_REPLACE_EN :  1 ; /* bits 12:12 */
    cs_uint32 FWD_VOQ_POL_TBL_IDX  :  9 ; /* bits 11:3 */
    cs_uint32 FWD_POL_POLICY       :  2 ; /* bits 2:1 */
    cs_uint32 FWD_VOQ_POLICY       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_VOQ_POLICY       :  1 ; /* bits 0:0 */
    cs_uint32 FWD_POL_POLICY       :  2 ; /* bits 2:1 */
    cs_uint32 FWD_VOQ_POL_TBL_IDX  :  9 ; /* bits 11:3 */
    cs_uint32 FWD_IP_SA_REPLACE_EN :  1 ; /* bits 12:12 */
    cs_uint32 FWD_IP_SA_IDX        : 12 ; /* bits 24:13 */
    cs_uint32 FWD_IP_DA_REPLACE_EN :  1 ; /* bits 25:25 */
    cs_uint32 FWD_IP_DA_IDX        :  6 ; /* bits 31:26 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWDRSLT_DATA0_t;





#define FETOP_FE_QOSRSLT_ACCESS                  0xf00200e8
#define FETOP_FE_QOSRSLT_ACCESS_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 ADDR                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_QOSRSLT_ACCESS_t;





#define FETOP_FE_QOSRSLT_DATA1                   0xf00200ec
#define FETOP_FE_QOSRSLT_DATA1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 FWD_QOS_MEM_PARITY   :  1 ; /* bits 15:15 */
    cs_uint32 FWD_QOS_CHANGE_DEI_2_EN :  1 ; /* bits 14:14 */
    cs_uint32 FWD_QOS_CHANGE_8021P_2_EN :  1 ; /* bits 13:13 */
    cs_uint32 FWD_QOS_CHANGE_DEI_1_EN :  1 ; /* bits 12:12 */
    cs_uint32 FWD_QOS_CHANGE_8021P_1_EN :  1 ; /* bits 11:11 */
    cs_uint32 FWD_QOS_MARKED_DOWN_INNER_DEI :  1 ; /* bits 10:10 */
    cs_uint32 FWD_QOS_INNER_DEI    :  1 ; /* bits 9:9 */
    cs_uint32 FWD_QOS_INNER_8021P_MARKDOWN_EN :  1 ; /* bits 8:8 */
    cs_uint32 FWD_QOS_MARKED_DOWN_INNER_802_1P :  3 ; /* bits 7:5 */
    cs_uint32 FWD_QOS_INNER_802_1P :  3 ; /* bits 4:2 */
    cs_uint32 FWD_QOS_MARKED_DOWN_TOP_DEI :  1 ; /* bits 1:1 */
    cs_uint32 FWD_QOS_TOP_DEI      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_QOS_TOP_DEI      :  1 ; /* bits 0:0 */
    cs_uint32 FWD_QOS_MARKED_DOWN_TOP_DEI :  1 ; /* bits 1:1 */
    cs_uint32 FWD_QOS_INNER_802_1P :  3 ; /* bits 4:2 */
    cs_uint32 FWD_QOS_MARKED_DOWN_INNER_802_1P :  3 ; /* bits 7:5 */
    cs_uint32 FWD_QOS_INNER_8021P_MARKDOWN_EN :  1 ; /* bits 8:8 */
    cs_uint32 FWD_QOS_INNER_DEI    :  1 ; /* bits 9:9 */
    cs_uint32 FWD_QOS_MARKED_DOWN_INNER_DEI :  1 ; /* bits 10:10 */
    cs_uint32 FWD_QOS_CHANGE_8021P_1_EN :  1 ; /* bits 11:11 */
    cs_uint32 FWD_QOS_CHANGE_DEI_1_EN :  1 ; /* bits 12:12 */
    cs_uint32 FWD_QOS_CHANGE_8021P_2_EN :  1 ; /* bits 13:13 */
    cs_uint32 FWD_QOS_CHANGE_DEI_2_EN :  1 ; /* bits 14:14 */
    cs_uint32 FWD_QOS_MEM_PARITY   :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_QOSRSLT_DATA1_t;





#define FETOP_FE_QOSRSLT_DATA0                   0xf00200f0
#define FETOP_FE_QOSRSLT_DATA0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_QOS_TOP_8021P_MARKDOWN_EN :  1 ; /* bits 31:31 */
    cs_uint32 FWD_QOS_MARKED_DOWN_TOP_802_1P :  3 ; /* bits 30:28 */
    cs_uint32 FWD_QOS_TOP_802_1P   :  3 ; /* bits 27:25 */
    cs_uint32 FWD_QOS_ECN_ENABLE   :  1 ; /* bits 24:24 */
    cs_uint32 FWD_QOS_MARKED_DOWN_DSCP :  6 ; /* bits 23:18 */
    cs_uint32 FWD_QOS_DSCP_MARKDOWN_EN :  1 ; /* bits 17:17 */
    cs_uint32 FWD_QOS_DSCP         :  6 ; /* bits 16:11 */
    cs_uint32 FWD_QOS_CHANGE_DSCP_EN :  1 ; /* bits 10:10 */
    cs_uint32 FWD_QOS_PREMARK      :  1 ; /* bits 9:9 */
    cs_uint32 FWD_QOS_POL_COS      :  3 ; /* bits 8:6 */
    cs_uint32 FWD_QOS_VOQ_COS      :  3 ; /* bits 5:3 */
    cs_uint32 FWD_QOS_WRED_COS     :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_QOS_WRED_COS     :  3 ; /* bits 2:0 */
    cs_uint32 FWD_QOS_VOQ_COS      :  3 ; /* bits 5:3 */
    cs_uint32 FWD_QOS_POL_COS      :  3 ; /* bits 8:6 */
    cs_uint32 FWD_QOS_PREMARK      :  1 ; /* bits 9:9 */
    cs_uint32 FWD_QOS_CHANGE_DSCP_EN :  1 ; /* bits 10:10 */
    cs_uint32 FWD_QOS_DSCP         :  6 ; /* bits 16:11 */
    cs_uint32 FWD_QOS_DSCP_MARKDOWN_EN :  1 ; /* bits 17:17 */
    cs_uint32 FWD_QOS_MARKED_DOWN_DSCP :  6 ; /* bits 23:18 */
    cs_uint32 FWD_QOS_ECN_ENABLE   :  1 ; /* bits 24:24 */
    cs_uint32 FWD_QOS_TOP_802_1P   :  3 ; /* bits 27:25 */
    cs_uint32 FWD_QOS_MARKED_DOWN_TOP_802_1P :  3 ; /* bits 30:28 */
    cs_uint32 FWD_QOS_TOP_8021P_MARKDOWN_EN :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_QOSRSLT_DATA0_t;





#define FETOP_FE_VOQPOL_ACCESS                   0xf00200f4
#define FETOP_FE_VOQPOL_ACCESS_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VOQPOL_ACCESS_t;





#define FETOP_FE_VOQPOL_DATA1                    0xf00200f8
#define FETOP_FE_VOQPOL_DATA1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 FWD_VOQPOL_MEM_PARITY :  1 ; /* bits 8:8 */
    cs_uint32 FWD_VOQPOL_COS_NOP   :  1 ; /* bits 7:7 */
    cs_uint32 FWD_VOQPOL_PPPOE_SESSION_ID :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_VOQPOL_PPPOE_SESSION_ID :  7 ; /* bits 6:0 */
    cs_uint32 FWD_VOQPOL_COS_NOP   :  1 ; /* bits 7:7 */
    cs_uint32 FWD_VOQPOL_MEM_PARITY :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VOQPOL_DATA1_t;





#define FETOP_FE_VOQPOL_DATA0                    0xf00200fc
#define FETOP_FE_VOQPOL_DATA0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_VOQPOL_PPPOE_SESSION_ID :  9 ; /* bits 31:23 */
    cs_uint32 FWD_VOQPOL_LDPID     :  4 ; /* bits 22:19 */
    cs_uint32 FWD_VOQPOL_CPUPID    :  3 ; /* bits 18:16 */
    cs_uint32 FWD_VOQPOL_POL_BASE  :  8 ; /* bits 15:8 */
    cs_uint32 FWD_VOQPOL_VOQ_BASE  :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_VOQPOL_VOQ_BASE  :  8 ; /* bits 7:0 */
    cs_uint32 FWD_VOQPOL_POL_BASE  :  8 ; /* bits 15:8 */
    cs_uint32 FWD_VOQPOL_CPUPID    :  3 ; /* bits 18:16 */
    cs_uint32 FWD_VOQPOL_LDPID     :  4 ; /* bits 22:19 */
    cs_uint32 FWD_VOQPOL_PPPOE_SESSION_ID :  9 ; /* bits 31:23 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_VOQPOL_DATA0_t;





#define FETOP_FE_FVLAN_ACCESS                    0xf0020100
#define FETOP_FE_FVLAN_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FVLAN_ACCESS_t;





#define FETOP_FE_FVLAN_DATA1                     0xf0020104
#define FETOP_FE_FVLAN_DATA1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 FWD_FVLAN_MEM_PARITY :  1 ; /* bits 6:6 */
    cs_uint32 FWD_FVLAN_SECOND_TPID_ENC :  2 ; /* bits 5:4 */
    cs_uint32 FWD_FVLAN_SECOND_VID :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_FVLAN_SECOND_VID :  4 ; /* bits 3:0 */
    cs_uint32 FWD_FVLAN_SECOND_TPID_ENC :  2 ; /* bits 5:4 */
    cs_uint32 FWD_FVLAN_MEM_PARITY :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FVLAN_DATA1_t;





#define FETOP_FE_FVLAN_DATA0                     0xf0020108
#define FETOP_FE_FVLAN_DATA0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_FVLAN_SECOND_VID :  8 ; /* bits 31:24 */
    cs_uint32 FWD_FVLAN_SECOND_VLAN_CMD :  5 ; /* bits 23:19 */
    cs_uint32 FWD_FVLAN_FIRST_TPID_ENC :  2 ; /* bits 18:17 */
    cs_uint32 FWD_FVLAN_FIRST_VID  : 12 ; /* bits 16:5 */
    cs_uint32 FWD_FVLAN_FIRST_VLAN_CMD :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_FVLAN_FIRST_VLAN_CMD :  5 ; /* bits 4:0 */
    cs_uint32 FWD_FVLAN_FIRST_VID  : 12 ; /* bits 16:5 */
    cs_uint32 FWD_FVLAN_FIRST_TPID_ENC :  2 ; /* bits 18:17 */
    cs_uint32 FWD_FVLAN_SECOND_VLAN_CMD :  5 ; /* bits 23:19 */
    cs_uint32 FWD_FVLAN_SECOND_VID :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FVLAN_DATA0_t;





#define FETOP_FE_L3TBL_ACCESS                    0xf002010c
#define FETOP_FE_L3TBL_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 ADDR                 : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 : 10 ; /* bits 9:0 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_ACCESS_t;





#define FETOP_FE_L3TBL_DATA4                     0xf0020110
#define FETOP_FE_L3TBL_DATA4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 FWD_L3_MEM_PARITY    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L3_MEM_PARITY    :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_DATA4_t;





#define FETOP_FE_L3TBL_DATA3                     0xf0020114
#define FETOP_FE_L3TBL_DATA3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_DATA3_t;





#define FETOP_FE_L3TBL_DATA2                     0xf0020118
#define FETOP_FE_L3TBL_DATA2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_DATA2_t;





#define FETOP_FE_L3TBL_DATA1                     0xf002011c
#define FETOP_FE_L3TBL_DATA1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_DATA1_t;





#define FETOP_FE_L3TBL_DATA0                     0xf0020120
#define FETOP_FE_L3TBL_DATA0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L3_ADDR          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L3TBL_DATA0_t;





#define FETOP_FE_L2TBL_ACCESS                    0xf0020124
#define FETOP_FE_L2TBL_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L2TBL_ACCESS_t;





#define FETOP_FE_L2TBL_DATA3                     0xf0020128
#define FETOP_FE_L2TBL_DATA3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 FWD_L2_MEM_PARITY    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L2_MEM_PARITY    :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L2TBL_DATA3_t;





#define FETOP_FE_L2TBL_DATA2                     0xf002012c
#define FETOP_FE_L2TBL_DATA2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L2_MAC_DA        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L2_MAC_DA        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L2TBL_DATA2_t;





#define FETOP_FE_L2TBL_DATA1                     0xf0020130
#define FETOP_FE_L2TBL_DATA1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L2_MAC_DA        : 16 ; /* bits 31:16 */
    cs_uint32 FWD_L2_MAC_SA        : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L2_MAC_SA        : 16 ; /* bits 15:0 */
    cs_uint32 FWD_L2_MAC_DA        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L2TBL_DATA1_t;





#define FETOP_FE_L2TBL_DATA0                     0xf0020134
#define FETOP_FE_L2TBL_DATA0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FWD_L2_MAC_SA        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_L2_MAC_SA        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_L2TBL_DATA0_t;





#define FETOP_FE_ACLRULE_ACCESS                  0xf0020138
#define FETOP_FE_ACLRULE_ACCESS_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_ACCESS_t;





#define FETOP_FE_ACLRULE_DATA27                  0xf002013c
#define FETOP_FE_ACLRULE_DATA27_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 ACL_RULE_MEM_PARITY  :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_VLD         :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_RSVD_879_878 :  2 ; /* bits 15:14 */
    cs_uint32 ACL_RULE_PKTLEN_RNG_MATCH_VECTOR_MASK :  4 ; /* bits 13:10 */
    cs_uint32 ACL_RULE_PKTLEN_RNG_MATCH_VECTOR :  4 ; /* bits 9:6 */
    cs_uint32 ACL_RULE_IPV6_DOH_MASK :  1 ; /* bits 5:5 */
    cs_uint32 ACL_RULE_IPV6_DOH    :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_IPV6_RH_MASK :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_IPV6_RH     :  1 ; /* bits 2:2 */
    cs_uint32 ACL_RULE_IPV6_HBH_MASK :  1 ; /* bits 1:1 */
    cs_uint32 ACL_RULE_IPV6_HBH    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IPV6_HBH    :  1 ; /* bits 0:0 */
    cs_uint32 ACL_RULE_IPV6_HBH_MASK :  1 ; /* bits 1:1 */
    cs_uint32 ACL_RULE_IPV6_RH     :  1 ; /* bits 2:2 */
    cs_uint32 ACL_RULE_IPV6_RH_MASK :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_IPV6_DOH    :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_IPV6_DOH_MASK :  1 ; /* bits 5:5 */
    cs_uint32 ACL_RULE_PKTLEN_RNG_MATCH_VECTOR :  4 ; /* bits 9:6 */
    cs_uint32 ACL_RULE_PKTLEN_RNG_MATCH_VECTOR_MASK :  4 ; /* bits 13:10 */
    cs_uint32 ACL_RULE_RSVD_879_878 :  2 ; /* bits 15:14 */
    cs_uint32 ACL_RULE_VLD         :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_MEM_PARITY  :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA27_t;





#define FETOP_FE_ACLRULE_DATA26                  0xf0020140
#define FETOP_FE_ACLRULE_DATA26_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IPV6_NDP_MASK :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_IPV6_NDP    :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL : 16 ; /* bits 28:13 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_VLD_MASK :  1 ; /* bits 12:12 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_VLD :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_SPI_MASK    :  1 ; /* bits 10:10 */
    cs_uint32 ACL_RULE_SPI         : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_SPI         : 10 ; /* bits 9:0 */
    cs_uint32 ACL_RULE_SPI_MASK    :  1 ; /* bits 10:10 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_VLD :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_VLD_MASK :  1 ; /* bits 12:12 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL : 16 ; /* bits 28:13 */
    cs_uint32 ACL_RULE_PPP_PROTOCOL_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_IPV6_NDP    :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_IPV6_NDP_MASK :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA26_t;





#define FETOP_FE_ACLRULE_DATA25                  0xf0020144
#define FETOP_FE_ACLRULE_DATA25_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_SPI         : 22 ; /* bits 31:10 */
    cs_uint32 ACL_RULE_SPI_VLD_MASK :  1 ; /* bits 9:9 */
    cs_uint32 ACL_RULE_SPI_VLD     :  1 ; /* bits 8:8 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_MASK :  1 ; /* bits 7:7 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID :  7 ; /* bits 6:0 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_MASK :  1 ; /* bits 7:7 */
    cs_uint32 ACL_RULE_SPI_VLD     :  1 ; /* bits 8:8 */
    cs_uint32 ACL_RULE_SPI_VLD_MASK :  1 ; /* bits 9:9 */
    cs_uint32 ACL_RULE_SPI         : 22 ; /* bits 31:10 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA25_t;





#define FETOP_FE_ACLRULE_DATA24                  0xf0020148
#define FETOP_FE_ACLRULE_DATA24_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID :  9 ; /* bits 31:23 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_VLD_MASK :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_VLD :  1 ; /* bits 21:21 */
    cs_uint32 ACL_RULE_FWD_DROP_MASK :  1 ; /* bits 20:20 */
    cs_uint32 ACL_RULE_FWD_DROP    :  1 ; /* bits 19:19 */
    cs_uint32 ACL_RULE_SDB_DROP_MASK :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_SDB_DROP    :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_MCIDX_MASK  :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_MCIDX       :  5 ; /* bits 15:11 */
    cs_uint32 ACL_RULE_NE_VEC      : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_NE_VEC      : 11 ; /* bits 10:0 */
    cs_uint32 ACL_RULE_MCIDX       :  5 ; /* bits 15:11 */
    cs_uint32 ACL_RULE_MCIDX_MASK  :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_SDB_DROP    :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_SDB_DROP_MASK :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_FWD_DROP    :  1 ; /* bits 19:19 */
    cs_uint32 ACL_RULE_FWD_DROP_MASK :  1 ; /* bits 20:20 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_VLD :  1 ; /* bits 21:21 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID_VLD_MASK :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_PPPOE_SESSION_ID :  9 ; /* bits 31:23 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA24_t;





#define FETOP_FE_ACLRULE_DATA23                  0xf002014c
#define FETOP_FE_ACLRULE_DATA23_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_NE_VEC      :  5 ; /* bits 31:27 */
    cs_uint32 ACL_RULE_RECIRX_IDX_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_RECIRC_IDX  : 10 ; /* bits 25:16 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC_OR :  1 ; /* bits 15:15 */
    cs_uint32 ACL_RULE_FLAGS_VEC_OR :  1 ; /* bits 14:14 */
    cs_uint32 ACL_RULE_FLAGS_VEC_MASK : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_FLAGS_VEC_MASK : 14 ; /* bits 13:0 */
    cs_uint32 ACL_RULE_FLAGS_VEC_OR :  1 ; /* bits 14:14 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC_OR :  1 ; /* bits 15:15 */
    cs_uint32 ACL_RULE_RECIRC_IDX  : 10 ; /* bits 25:16 */
    cs_uint32 ACL_RULE_RECIRX_IDX_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_NE_VEC      :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA23_t;





#define FETOP_FE_ACLRULE_DATA22                  0xf0020150
#define FETOP_FE_ACLRULE_DATA22_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_FLAGS_VEC_MASK :  2 ; /* bits 31:30 */
    cs_uint32 ACL_RULE_FLAGS_VEC   : 16 ; /* bits 29:14 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 13:13 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_HIT :  1 ; /* bits 12:12 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_SEL :  4 ; /* bits 10:7 */
    cs_uint32 ACL_RULE_DA_AN_MAC_SEL_MASK :  1 ; /* bits 6:6 */
    cs_uint32 ACL_RULE_DA_AN_MAC_SEL :  4 ; /* bits 5:2 */
    cs_uint32 ACL_RULE_L7_FIELD_MASK :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L7_FIELD_MASK :  2 ; /* bits 1:0 */
    cs_uint32 ACL_RULE_DA_AN_MAC_SEL :  4 ; /* bits 5:2 */
    cs_uint32 ACL_RULE_DA_AN_MAC_SEL_MASK :  1 ; /* bits 6:6 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_SEL :  4 ; /* bits 10:7 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_HIT :  1 ; /* bits 12:12 */
    cs_uint32 ACL_RULE_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 13:13 */
    cs_uint32 ACL_RULE_FLAGS_VEC   : 16 ; /* bits 29:14 */
    cs_uint32 ACL_RULE_FLAGS_VEC_MASK :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA22_t;





#define FETOP_FE_ACLRULE_DATA21                  0xf0020154
#define FETOP_FE_ACLRULE_DATA21_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L7_FIELD_MASK :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_HASH_HIT_IDX_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_HASH_HIT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_LPM_HIT_IDX_MASK :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_LPM_HIT_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_CLASS_SVIDX_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_CLASS_HIT_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC_MASK : 16 ; /* bits 24:9 */
    cs_uint32 ACL_RULE_FWDTYPE_MASK :  4 ; /* bits 8:5 */
    cs_uint32 ACL_RULE_ORIG_LSPID_MASK :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_LSPID_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_L4_MASK     :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L4_MASK     :  3 ; /* bits 2:0 */
    cs_uint32 ACL_RULE_LSPID_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_ORIG_LSPID_MASK :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_FWDTYPE_MASK :  4 ; /* bits 8:5 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC_MASK : 16 ; /* bits 24:9 */
    cs_uint32 ACL_RULE_CLASS_HIT_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_CLASS_SVIDX_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_LPM_HIT_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_LPM_HIT_IDX_MASK :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_HASH_HIT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_HASH_HIT_IDX_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_L7_FIELD_MASK :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA21_t;





#define FETOP_FE_ACLRULE_DATA20                  0xf0020158
#define FETOP_FE_ACLRULE_DATA20_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L4_MASK     :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_L4_VLD_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_TTL_HOPLMT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_IPV6_FLOW_LBL_MASK :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_IP_OPTIONS_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_IP_FRAGMENT_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_IP_PROT_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_ECN_MASK    :  2 ; /* bits 24:23 */
    cs_uint32 ACL_RULE_DSCP_MASK   :  6 ; /* bits 22:17 */
    cs_uint32 ACL_RULE_IP_SA_MASK  :  9 ; /* bits 16:8 */
    cs_uint32 ACL_RULE_IP_DA_MASK  :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_DA_MASK  :  8 ; /* bits 7:0 */
    cs_uint32 ACL_RULE_IP_SA_MASK  :  9 ; /* bits 16:8 */
    cs_uint32 ACL_RULE_DSCP_MASK   :  6 ; /* bits 22:17 */
    cs_uint32 ACL_RULE_ECN_MASK    :  2 ; /* bits 24:23 */
    cs_uint32 ACL_RULE_IP_PROT_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_IP_FRAGMENT_MASK :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_IP_OPTIONS_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_IPV6_FLOW_LBL_MASK :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_TTL_HOPLMT_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_L4_VLD_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_L4_MASK     :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA20_t;





#define FETOP_FE_ACLRULE_DATA19                  0xf002015c
#define FETOP_FE_ACLRULE_DATA19_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_DA_MASK  :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_IP_VER_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_IP_VLD_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_DEI_2_MASK  :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_8021P_2_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_VID_2_MASK  :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_TPID_ENC_2_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_TPID_2_VLD_MASK :  1 ; /* bits 24:24 */
    cs_uint32 ACL_RULE_DEI_1_MASK  :  1 ; /* bits 23:23 */
    cs_uint32 ACL_RULE_8021P_1_MASK :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_VID_1_MASK  :  1 ; /* bits 21:21 */
    cs_uint32 ACL_RULE_TPID_ENC_1_MASK :  1 ; /* bits 20:20 */
    cs_uint32 ACL_RULE_TPID_1_VLD_MASK :  1 ; /* bits 19:19 */
    cs_uint32 ACL_RULE_LEN_ENCODED_MASK :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_ETHERTYPE_MASK :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_L2_MAC_SA_MASK :  6 ; /* bits 16:11 */
    cs_uint32 ACL_RULE_L2_MAC_DA_MASK :  6 ; /* bits 10:5 */
    cs_uint32 ACL_RULE_L7_FIELD    :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L7_FIELD    :  5 ; /* bits 4:0 */
    cs_uint32 ACL_RULE_L2_MAC_DA_MASK :  6 ; /* bits 10:5 */
    cs_uint32 ACL_RULE_L2_MAC_SA_MASK :  6 ; /* bits 16:11 */
    cs_uint32 ACL_RULE_ETHERTYPE_MASK :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_LEN_ENCODED_MASK :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_TPID_1_VLD_MASK :  1 ; /* bits 19:19 */
    cs_uint32 ACL_RULE_TPID_ENC_1_MASK :  1 ; /* bits 20:20 */
    cs_uint32 ACL_RULE_VID_1_MASK  :  1 ; /* bits 21:21 */
    cs_uint32 ACL_RULE_8021P_1_MASK :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_DEI_1_MASK  :  1 ; /* bits 23:23 */
    cs_uint32 ACL_RULE_TPID_2_VLD_MASK :  1 ; /* bits 24:24 */
    cs_uint32 ACL_RULE_TPID_ENC_2_MASK :  1 ; /* bits 25:25 */
    cs_uint32 ACL_RULE_VID_2_MASK  :  1 ; /* bits 26:26 */
    cs_uint32 ACL_RULE_8021P_2_MASK :  1 ; /* bits 27:27 */
    cs_uint32 ACL_RULE_DEI_2_MASK  :  1 ; /* bits 28:28 */
    cs_uint32 ACL_RULE_IP_VLD_MASK :  1 ; /* bits 29:29 */
    cs_uint32 ACL_RULE_IP_VER_MASK :  1 ; /* bits 30:30 */
    cs_uint32 ACL_RULE_IP_DA_MASK  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA19_t;





#define FETOP_FE_ACLRULE_DATA18                  0xf0020160
#define FETOP_FE_ACLRULE_DATA18_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L7_FIELD    : 27 ; /* bits 31:5 */
    cs_uint32 ACL_RULE_DA_AN_MAC_HIT_MASK :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_DA_AN_MAC_HIT :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_HASH_HIT_IDX :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_HASH_HIT_IDX :  3 ; /* bits 2:0 */
    cs_uint32 ACL_RULE_DA_AN_MAC_HIT :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_DA_AN_MAC_HIT_MASK :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_L7_FIELD    : 27 ; /* bits 31:5 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA18_t;





#define FETOP_FE_ACLRULE_DATA17                  0xf0020164
#define FETOP_FE_ACLRULE_DATA17_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_HASH_HIT_IDX : 13 ; /* bits 31:19 */
    cs_uint32 ACL_RULE_HASH_HIT    :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_LPM_HIT_IDX :  6 ; /* bits 17:12 */
    cs_uint32 ACL_RULE_LPM_HIT     :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_CLASS_SVIDX :  6 ; /* bits 10:5 */
    cs_uint32 ACL_RULE_CLASS_HIT   :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_SPL_PKT_VEC :  4 ; /* bits 3:0 */
    cs_uint32 ACL_RULE_CLASS_HIT   :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_CLASS_SVIDX :  6 ; /* bits 10:5 */
    cs_uint32 ACL_RULE_LPM_HIT     :  1 ; /* bits 11:11 */
    cs_uint32 ACL_RULE_LPM_HIT_IDX :  6 ; /* bits 17:12 */
    cs_uint32 ACL_RULE_HASH_HIT    :  1 ; /* bits 18:18 */
    cs_uint32 ACL_RULE_HASH_HIT_IDX : 13 ; /* bits 31:19 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA17_t;





#define FETOP_FE_ACLRULE_DATA16                  0xf0020168
#define FETOP_FE_ACLRULE_DATA16_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_SPL_PKT_VEC : 12 ; /* bits 31:20 */
    cs_uint32 ACL_RULE_FWDTYPE     :  4 ; /* bits 19:16 */
    cs_uint32 ACL_RULE_ORIG_LSPID  :  4 ; /* bits 15:12 */
    cs_uint32 ACL_RULE_LSPID       :  4 ; /* bits 11:8 */
    cs_uint32 ACL_RULE_L4_SPHI     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L4_SPHI     :  8 ; /* bits 7:0 */
    cs_uint32 ACL_RULE_LSPID       :  4 ; /* bits 11:8 */
    cs_uint32 ACL_RULE_ORIG_LSPID  :  4 ; /* bits 15:12 */
    cs_uint32 ACL_RULE_FWDTYPE     :  4 ; /* bits 19:16 */
    cs_uint32 ACL_RULE_SPL_PKT_VEC : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA16_t;





#define FETOP_FE_ACLRULE_DATA15                  0xf002016c
#define FETOP_FE_ACLRULE_DATA15_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L4_SPHI     :  8 ; /* bits 31:24 */
    cs_uint32 ACL_RULE_L4_SPLO     : 16 ; /* bits 23:8 */
    cs_uint32 ACL_RULE_L4_DPHI     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L4_DPHI     :  8 ; /* bits 7:0 */
    cs_uint32 ACL_RULE_L4_SPLO     : 16 ; /* bits 23:8 */
    cs_uint32 ACL_RULE_L4_SPHI     :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA15_t;





#define FETOP_FE_ACLRULE_DATA14                  0xf0020170
#define FETOP_FE_ACLRULE_DATA14_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L4_DPHI     :  8 ; /* bits 31:24 */
    cs_uint32 ACL_RULE_L4_DPLO     : 16 ; /* bits 23:8 */
    cs_uint32 ACL_RULE_L4_VLD      :  1 ; /* bits 7:7 */
    cs_uint32 ACL_RULE_TTL_HOPLMT  :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_TTL_HOPLMT  :  7 ; /* bits 6:0 */
    cs_uint32 ACL_RULE_L4_VLD      :  1 ; /* bits 7:7 */
    cs_uint32 ACL_RULE_L4_DPLO     : 16 ; /* bits 23:8 */
    cs_uint32 ACL_RULE_L4_DPHI     :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA14_t;





#define FETOP_FE_ACLRULE_DATA13                  0xf0020174
#define FETOP_FE_ACLRULE_DATA13_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_TTL_HOPLMT  :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_IPV6_FLOW_LBL : 20 ; /* bits 30:11 */
    cs_uint32 ACL_RULE_IP_OPTIONS  :  1 ; /* bits 10:10 */
    cs_uint32 ACL_RULE_IP_FRAGMENT :  1 ; /* bits 9:9 */
    cs_uint32 ACL_RULE_IP_PROT     :  8 ; /* bits 8:1 */
    cs_uint32 ACL_RULE_ECN         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_ECN         :  1 ; /* bits 0:0 */
    cs_uint32 ACL_RULE_IP_PROT     :  8 ; /* bits 8:1 */
    cs_uint32 ACL_RULE_IP_FRAGMENT :  1 ; /* bits 9:9 */
    cs_uint32 ACL_RULE_IP_OPTIONS  :  1 ; /* bits 10:10 */
    cs_uint32 ACL_RULE_IPV6_FLOW_LBL : 20 ; /* bits 30:11 */
    cs_uint32 ACL_RULE_TTL_HOPLMT  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA13_t;





#define FETOP_FE_ACLRULE_DATA12                  0xf0020178
#define FETOP_FE_ACLRULE_DATA12_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_ECN         :  1 ; /* bits 31:31 */
    cs_uint32 ACL_RULE_DSCP        :  6 ; /* bits 30:25 */
    cs_uint32 ACL_RULE_IP_SA       : 25 ; /* bits 24:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_SA       : 25 ; /* bits 24:0 */
    cs_uint32 ACL_RULE_DSCP        :  6 ; /* bits 30:25 */
    cs_uint32 ACL_RULE_ECN         :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA12_t;





#define FETOP_FE_ACLRULE_DATA11                  0xf002017c
#define FETOP_FE_ACLRULE_DATA11_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA11_t;





#define FETOP_FE_ACLRULE_DATA10                  0xf0020180
#define FETOP_FE_ACLRULE_DATA10_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA10_t;





#define FETOP_FE_ACLRULE_DATA9                   0xf0020184
#define FETOP_FE_ACLRULE_DATA9_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_SA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA9_t;





#define FETOP_FE_ACLRULE_DATA8                   0xf0020188
#define FETOP_FE_ACLRULE_DATA8_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_SA       :  7 ; /* bits 31:25 */
    cs_uint32 ACL_RULE_IP_DA       : 25 ; /* bits 24:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_DA       : 25 ; /* bits 24:0 */
    cs_uint32 ACL_RULE_IP_SA       :  7 ; /* bits 31:25 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA8_t;





#define FETOP_FE_ACLRULE_DATA7                   0xf002018c
#define FETOP_FE_ACLRULE_DATA7_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA7_t;





#define FETOP_FE_ACLRULE_DATA6                   0xf0020190
#define FETOP_FE_ACLRULE_DATA6_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA6_t;





#define FETOP_FE_ACLRULE_DATA5                   0xf0020194
#define FETOP_FE_ACLRULE_DATA5_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_IP_DA       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA5_t;





#define FETOP_FE_ACLRULE_DATA4                   0xf0020198
#define FETOP_FE_ACLRULE_DATA4_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_IP_DA       :  7 ; /* bits 31:25 */
    cs_uint32 ACL_RULE_IP_VER      :  1 ; /* bits 24:24 */
    cs_uint32 ACL_RULE_IP_VLD      :  1 ; /* bits 23:23 */
    cs_uint32 ACL_RULE_DEI_2       :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_8021P_2     :  3 ; /* bits 21:19 */
    cs_uint32 ACL_RULE_VID_2       : 12 ; /* bits 18:7 */
    cs_uint32 ACL_RULE_TPID_ENC_2  :  2 ; /* bits 6:5 */
    cs_uint32 ACL_RULE_TPID_2_VLD  :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_DEI_1       :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_8021P_1     :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_8021P_1     :  3 ; /* bits 2:0 */
    cs_uint32 ACL_RULE_DEI_1       :  1 ; /* bits 3:3 */
    cs_uint32 ACL_RULE_TPID_2_VLD  :  1 ; /* bits 4:4 */
    cs_uint32 ACL_RULE_TPID_ENC_2  :  2 ; /* bits 6:5 */
    cs_uint32 ACL_RULE_VID_2       : 12 ; /* bits 18:7 */
    cs_uint32 ACL_RULE_8021P_2     :  3 ; /* bits 21:19 */
    cs_uint32 ACL_RULE_DEI_2       :  1 ; /* bits 22:22 */
    cs_uint32 ACL_RULE_IP_VLD      :  1 ; /* bits 23:23 */
    cs_uint32 ACL_RULE_IP_VER      :  1 ; /* bits 24:24 */
    cs_uint32 ACL_RULE_IP_DA       :  7 ; /* bits 31:25 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA4_t;





#define FETOP_FE_ACLRULE_DATA3                   0xf002019c
#define FETOP_FE_ACLRULE_DATA3_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_VID_1       : 12 ; /* bits 31:20 */
    cs_uint32 ACL_RULE_TPID_ENC_1  :  2 ; /* bits 19:18 */
    cs_uint32 ACL_RULE_TPID_1_VLD  :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_LEN_ENCODED :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_ETHERTYPE   : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_ETHERTYPE   : 16 ; /* bits 15:0 */
    cs_uint32 ACL_RULE_LEN_ENCODED :  1 ; /* bits 16:16 */
    cs_uint32 ACL_RULE_TPID_1_VLD  :  1 ; /* bits 17:17 */
    cs_uint32 ACL_RULE_TPID_ENC_1  :  2 ; /* bits 19:18 */
    cs_uint32 ACL_RULE_VID_1       : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA3_t;





#define FETOP_FE_ACLRULE_DATA2                   0xf00201a0
#define FETOP_FE_ACLRULE_DATA2_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L2_MAC_SA   : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L2_MAC_SA   : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA2_t;





#define FETOP_FE_ACLRULE_DATA1                   0xf00201a4
#define FETOP_FE_ACLRULE_DATA1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L2_MAC_SA   : 16 ; /* bits 31:16 */
    cs_uint32 ACL_RULE_L2_MAC_DA   : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L2_MAC_DA   : 16 ; /* bits 15:0 */
    cs_uint32 ACL_RULE_L2_MAC_SA   : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA1_t;





#define FETOP_FE_ACLRULE_DATA0                   0xf00201a8
#define FETOP_FE_ACLRULE_DATA0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_RULE_L2_MAC_DA   : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_RULE_L2_MAC_DA   : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLRULE_DATA0_t;





#define FETOP_FE_ACLACTION_ACCESS                0xf00201ac
#define FETOP_FE_ACLACTION_ACCESS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_ACCESS_t;





#define FETOP_FE_ACLACTION_DATA9                 0xf00201b0
#define FETOP_FE_ACLACTION_DATA9_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 ACL_ACTION_MEM_PARITY :  1 ; /* bits 17:17 */
    cs_uint32 ACL_ACTION_CHANGE_DEI_2_EN :  1 ; /* bits 16:16 */
    cs_uint32 ACL_ACTION_CHANGE_8021P_2_EN :  1 ; /* bits 15:15 */
    cs_uint32 ACL_ACTION_CHANGE_DEI_1_EN :  1 ; /* bits 14:14 */
    cs_uint32 ACL_ACTION_CHANGE_8021P_1_EN :  1 ; /* bits 13:13 */
    cs_uint32 ACL_ACTION_CPUCOPY_CPUPID :  3 ; /* bits 12:10 */
    cs_uint32 ACL_ACTION_VOQ_CPUPID :  3 ; /* bits 9:7 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT_PRI :  4 ; /* bits 6:3 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT :  1 ; /* bits 2:2 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT_VLD :  1 ; /* bits 1:1 */
    cs_uint32 ACL_ACTION_CHANGE_DSCP_EN :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_CHANGE_DSCP_EN :  1 ; /* bits 0:0 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT_VLD :  1 ; /* bits 1:1 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT :  1 ; /* bits 2:2 */
    cs_uint32 ACL_ACTION_DECR_TTL_HOPLIMIT_PRI :  4 ; /* bits 6:3 */
    cs_uint32 ACL_ACTION_VOQ_CPUPID :  3 ; /* bits 9:7 */
    cs_uint32 ACL_ACTION_CPUCOPY_CPUPID :  3 ; /* bits 12:10 */
    cs_uint32 ACL_ACTION_CHANGE_8021P_1_EN :  1 ; /* bits 13:13 */
    cs_uint32 ACL_ACTION_CHANGE_DEI_1_EN :  1 ; /* bits 14:14 */
    cs_uint32 ACL_ACTION_CHANGE_8021P_2_EN :  1 ; /* bits 15:15 */
    cs_uint32 ACL_ACTION_CHANGE_DEI_2_EN :  1 ; /* bits 16:16 */
    cs_uint32 ACL_ACTION_MEM_PARITY :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA9_t;





#define FETOP_FE_ACLACTION_DATA8                 0xf00201b4
#define FETOP_FE_ACLACTION_DATA8_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_L2_IDX    :  9 ; /* bits 31:23 */
    cs_uint32 ACL_ACTION_MAC_DA_SA_REPLACE_EN_PRI :  4 ; /* bits 22:19 */
    cs_uint32 ACL_ACTION_MAC_SA_REPLACE_EN :  1 ; /* bits 18:18 */
    cs_uint32 ACL_ACTION_MAC_DA_REPLACE_EN :  1 ; /* bits 17:17 */
    cs_uint32 ACL_ACTION_MAC_DA_SA_REPLACE_EN_VLD :  1 ; /* bits 16:16 */
    cs_uint32 ACL_ACTION_IP_DA_IDX : 12 ; /* bits 15:4 */
    cs_uint32 ACL_ACTION_IP_SA_IDX :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_IP_SA_IDX :  4 ; /* bits 3:0 */
    cs_uint32 ACL_ACTION_IP_DA_IDX : 12 ; /* bits 15:4 */
    cs_uint32 ACL_ACTION_MAC_DA_SA_REPLACE_EN_VLD :  1 ; /* bits 16:16 */
    cs_uint32 ACL_ACTION_MAC_DA_REPLACE_EN :  1 ; /* bits 17:17 */
    cs_uint32 ACL_ACTION_MAC_SA_REPLACE_EN :  1 ; /* bits 18:18 */
    cs_uint32 ACL_ACTION_MAC_DA_SA_REPLACE_EN_PRI :  4 ; /* bits 22:19 */
    cs_uint32 ACL_ACTION_L2_IDX    :  9 ; /* bits 31:23 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA8_t;





#define FETOP_FE_ACLACTION_DATA7                 0xf00201b8
#define FETOP_FE_ACLACTION_DATA7_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_IP_SA_IDX :  8 ; /* bits 31:24 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN_PRI :  4 ; /* bits 23:20 */
    cs_uint32 ACL_ACTION_L4_DP     : 16 ; /* bits 19:4 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN_VLD :  1 ; /* bits 2:2 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_PRI :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_PRI :  2 ; /* bits 1:0 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN_VLD :  1 ; /* bits 2:2 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_L4_DP     : 16 ; /* bits 19:4 */
    cs_uint32 ACL_ACTION_L4_DP_REPLACE_EN_PRI :  4 ; /* bits 23:20 */
    cs_uint32 ACL_ACTION_IP_SA_IDX :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA7_t;





#define FETOP_FE_ACLACTION_DATA6                 0xf00201bc
#define FETOP_FE_ACLACTION_DATA6_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_PRI :  2 ; /* bits 31:30 */
    cs_uint32 ACL_ACTION_L4_SP     : 16 ; /* bits 29:14 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN :  1 ; /* bits 13:13 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_VLD :  1 ; /* bits 12:12 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN_PRI :  4 ; /* bits 11:8 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN :  1 ; /* bits 7:7 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN_VLD :  1 ; /* bits 6:6 */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN_PRI :  4 ; /* bits 5:2 */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN :  1 ; /* bits 1:1 */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN_VLD :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN_VLD :  1 ; /* bits 0:0 */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN :  1 ; /* bits 1:1 */
    cs_uint32 ACL_ACTION_IP_SA_REPLACE_EN_PRI :  4 ; /* bits 5:2 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN_VLD :  1 ; /* bits 6:6 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN :  1 ; /* bits 7:7 */
    cs_uint32 ACL_ACTION_IP_DA_REPLACE_EN_PRI :  4 ; /* bits 11:8 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_VLD :  1 ; /* bits 12:12 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN :  1 ; /* bits 13:13 */
    cs_uint32 ACL_ACTION_L4_SP     : 16 ; /* bits 29:14 */
    cs_uint32 ACL_ACTION_L4_SP_REPLACE_EN_PRI :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA6_t;





#define FETOP_FE_ACLACTION_DATA5                 0xf00201c0
#define FETOP_FE_ACLACTION_DATA5_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_KEEP_TS_PRI :  4 ; /* bits 31:28 */
    cs_uint32 ACL_ACTION_KEEP_TS   :  1 ; /* bits 27:27 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD_PRI :  4 ; /* bits 26:23 */
    cs_uint32 ACL_ACTION_SECOND_TPID_ENC :  2 ; /* bits 22:21 */
    cs_uint32 ACL_ACTION_SECOND_VID : 12 ; /* bits 20:9 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD :  5 ; /* bits 8:4 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD_VLD :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_PRI :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_PRI :  3 ; /* bits 2:0 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD_VLD :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD :  5 ; /* bits 8:4 */
    cs_uint32 ACL_ACTION_SECOND_VID : 12 ; /* bits 20:9 */
    cs_uint32 ACL_ACTION_SECOND_TPID_ENC :  2 ; /* bits 22:21 */
    cs_uint32 ACL_ACTION_SECOND_VLAN_CMD_PRI :  4 ; /* bits 26:23 */
    cs_uint32 ACL_ACTION_KEEP_TS   :  1 ; /* bits 27:27 */
    cs_uint32 ACL_ACTION_KEEP_TS_PRI :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA5_t;





#define FETOP_FE_ACLACTION_DATA4                 0xf00201c4
#define FETOP_FE_ACLACTION_DATA4_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_PRI :  1 ; /* bits 31:31 */
    cs_uint32 ACL_ACTION_FIRST_TPID_ENC :  2 ; /* bits 30:29 */
    cs_uint32 ACL_ACTION_FIRST_VID : 12 ; /* bits 28:17 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD :  5 ; /* bits 16:12 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_VLD :  1 ; /* bits 11:11 */
    cs_uint32 ACL_ACTION_MCGID_PRI :  4 ; /* bits 10:7 */
    cs_uint32 ACL_ACTION_MCGID     :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_MCGID     :  7 ; /* bits 6:0 */
    cs_uint32 ACL_ACTION_MCGID_PRI :  4 ; /* bits 10:7 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_VLD :  1 ; /* bits 11:11 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD :  5 ; /* bits 16:12 */
    cs_uint32 ACL_ACTION_FIRST_VID : 12 ; /* bits 28:17 */
    cs_uint32 ACL_ACTION_FIRST_TPID_ENC :  2 ; /* bits 30:29 */
    cs_uint32 ACL_ACTION_FIRST_VLAN_CMD_PRI :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA4_t;





#define FETOP_FE_ACLACTION_DATA3                 0xf00201c8
#define FETOP_FE_ACLACTION_DATA3_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_MCGID     :  2 ; /* bits 31:30 */
    cs_uint32 ACL_ACTION_MCGID_VLD :  1 ; /* bits 29:29 */
    cs_uint32 ACL_ACTION_FWDTYPE_PRI :  4 ; /* bits 28:25 */
    cs_uint32 ACL_ACTION_FWDTYPE   :  4 ; /* bits 24:21 */
    cs_uint32 ACL_ACTION_FWDTYPE_VLD :  1 ; /* bits 20:20 */
    cs_uint32 ACL_ACTION_DSCP_PRI  :  4 ; /* bits 19:16 */
    cs_uint32 ACL_ACTION_DSCP      :  6 ; /* bits 15:10 */
    cs_uint32 ACL_ACTION_DSCP_VLD  :  1 ; /* bits 9:9 */
    cs_uint32 ACL_ACTION_DEI_2_PRI :  4 ; /* bits 8:5 */
    cs_uint32 ACL_ACTION_DEI_2     :  1 ; /* bits 4:4 */
    cs_uint32 ACL_ACTION_DEI_2_VLD :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_8021P_2_PRI :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_8021P_2_PRI :  3 ; /* bits 2:0 */
    cs_uint32 ACL_ACTION_DEI_2_VLD :  1 ; /* bits 3:3 */
    cs_uint32 ACL_ACTION_DEI_2     :  1 ; /* bits 4:4 */
    cs_uint32 ACL_ACTION_DEI_2_PRI :  4 ; /* bits 8:5 */
    cs_uint32 ACL_ACTION_DSCP_VLD  :  1 ; /* bits 9:9 */
    cs_uint32 ACL_ACTION_DSCP      :  6 ; /* bits 15:10 */
    cs_uint32 ACL_ACTION_DSCP_PRI  :  4 ; /* bits 19:16 */
    cs_uint32 ACL_ACTION_FWDTYPE_VLD :  1 ; /* bits 20:20 */
    cs_uint32 ACL_ACTION_FWDTYPE   :  4 ; /* bits 24:21 */
    cs_uint32 ACL_ACTION_FWDTYPE_PRI :  4 ; /* bits 28:25 */
    cs_uint32 ACL_ACTION_MCGID_VLD :  1 ; /* bits 29:29 */
    cs_uint32 ACL_ACTION_MCGID     :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA3_t;





#define FETOP_FE_ACLACTION_DATA2                 0xf00201cc
#define FETOP_FE_ACLACTION_DATA2_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_8021P_2_PRI :  1 ; /* bits 31:31 */
    cs_uint32 ACL_ACTION_KEEP_TS_VLD :  1 ; /* bits 30:30 */
    cs_uint32 ACL_ACTION_8021P_2   :  3 ; /* bits 29:27 */
    cs_uint32 ACL_ACTION_8021P_2_VLD :  1 ; /* bits 26:26 */
    cs_uint32 ACL_ACTION_DEI_1_PRI :  4 ; /* bits 25:22 */
    cs_uint32 ACL_ACTION_DEI_1     :  1 ; /* bits 21:21 */
    cs_uint32 ACL_ACTION_DEI_1_VLD :  1 ; /* bits 20:20 */
    cs_uint32 ACL_ACTION_8021P_1_PRI :  4 ; /* bits 19:16 */
    cs_uint32 ACL_ACTION_8021P_1   :  3 ; /* bits 15:13 */
    cs_uint32 ACL_ACTION_8021P_1_VLD :  1 ; /* bits 12:12 */
    cs_uint32 ACL_ACTION_DROP_PERMIT_PRI :  4 ; /* bits 11:8 */
    cs_uint32 ACL_ACTION_PERMIT    :  1 ; /* bits 7:7 */
    cs_uint32 ACL_ACTION_DROP      :  1 ; /* bits 6:6 */
    cs_uint32 ACL_ACTION_DROP_PERMIT_VLD :  1 ; /* bits 5:5 */
    cs_uint32 ACL_ACTION_POLICER_ID_PRI :  4 ; /* bits 4:1 */
    cs_uint32 ACL_ACTION_POLICER_ID :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_POLICER_ID :  1 ; /* bits 0:0 */
    cs_uint32 ACL_ACTION_POLICER_ID_PRI :  4 ; /* bits 4:1 */
    cs_uint32 ACL_ACTION_DROP_PERMIT_VLD :  1 ; /* bits 5:5 */
    cs_uint32 ACL_ACTION_DROP      :  1 ; /* bits 6:6 */
    cs_uint32 ACL_ACTION_PERMIT    :  1 ; /* bits 7:7 */
    cs_uint32 ACL_ACTION_DROP_PERMIT_PRI :  4 ; /* bits 11:8 */
    cs_uint32 ACL_ACTION_8021P_1_VLD :  1 ; /* bits 12:12 */
    cs_uint32 ACL_ACTION_8021P_1   :  3 ; /* bits 15:13 */
    cs_uint32 ACL_ACTION_8021P_1_PRI :  4 ; /* bits 19:16 */
    cs_uint32 ACL_ACTION_DEI_1_VLD :  1 ; /* bits 20:20 */
    cs_uint32 ACL_ACTION_DEI_1     :  1 ; /* bits 21:21 */
    cs_uint32 ACL_ACTION_DEI_1_PRI :  4 ; /* bits 25:22 */
    cs_uint32 ACL_ACTION_8021P_2_VLD :  1 ; /* bits 26:26 */
    cs_uint32 ACL_ACTION_8021P_2   :  3 ; /* bits 29:27 */
    cs_uint32 ACL_ACTION_KEEP_TS_VLD :  1 ; /* bits 30:30 */
    cs_uint32 ACL_ACTION_8021P_2_PRI :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA2_t;





#define FETOP_FE_ACLACTION_DATA1                 0xf00201d0
#define FETOP_FE_ACLACTION_DATA1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_POLICER_ID :  7 ; /* bits 31:25 */
    cs_uint32 ACL_ACTION_POLICER_ID_VLD :  1 ; /* bits 24:24 */
    cs_uint32 ACL_ACTION_PRE_MARK_PRI :  4 ; /* bits 23:20 */
    cs_uint32 ACL_ACTION_PRE_MARK  :  1 ; /* bits 19:19 */
    cs_uint32 ACL_ACTION_PRE_MARK_VLD :  1 ; /* bits 18:18 */
    cs_uint32 ACL_ACTION_WRED_COS_PRI :  4 ; /* bits 17:14 */
    cs_uint32 ACL_ACTION_WRED_COS  :  3 ; /* bits 13:11 */
    cs_uint32 ACL_ACTION_WRED_COS_VLD :  1 ; /* bits 10:10 */
    cs_uint32 ACL_ACTION_MIRROR_ID_PRI :  4 ; /* bits 9:6 */
    cs_uint32 ACL_ACTION_MIRROR_ID :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_MIRROR_ID :  6 ; /* bits 5:0 */
    cs_uint32 ACL_ACTION_MIRROR_ID_PRI :  4 ; /* bits 9:6 */
    cs_uint32 ACL_ACTION_WRED_COS_VLD :  1 ; /* bits 10:10 */
    cs_uint32 ACL_ACTION_WRED_COS  :  3 ; /* bits 13:11 */
    cs_uint32 ACL_ACTION_WRED_COS_PRI :  4 ; /* bits 17:14 */
    cs_uint32 ACL_ACTION_PRE_MARK_VLD :  1 ; /* bits 18:18 */
    cs_uint32 ACL_ACTION_PRE_MARK  :  1 ; /* bits 19:19 */
    cs_uint32 ACL_ACTION_PRE_MARK_PRI :  4 ; /* bits 23:20 */
    cs_uint32 ACL_ACTION_POLICER_ID_VLD :  1 ; /* bits 24:24 */
    cs_uint32 ACL_ACTION_POLICER_ID :  7 ; /* bits 31:25 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA1_t;





#define FETOP_FE_ACLACTION_DATA0                 0xf00201d4
#define FETOP_FE_ACLACTION_DATA0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACL_ACTION_MIRROR_ID :  3 ; /* bits 31:29 */
    cs_uint32 ACL_ACTION_MIRROR_VLD :  1 ; /* bits 28:28 */
    cs_uint32 ACL_ACTION_CPUCOPY_PRI :  4 ; /* bits 27:24 */
    cs_uint32 ACL_ACTION_CPUCOPY_VOQ :  6 ; /* bits 23:18 */
    cs_uint32 ACL_ACTION_CPUCOPY   :  1 ; /* bits 17:17 */
    cs_uint32 ACL_ACTION_LDPID     :  4 ; /* bits 16:13 */
    cs_uint32 ACL_ACTION_VOQ       :  8 ; /* bits 12:5 */
    cs_uint32 ACL_ACTION_VOQ_PRI   :  4 ; /* bits 4:1 */
    cs_uint32 ACL_ACTION_VOQ_VLD   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ACL_ACTION_VOQ_VLD   :  1 ; /* bits 0:0 */
    cs_uint32 ACL_ACTION_VOQ_PRI   :  4 ; /* bits 4:1 */
    cs_uint32 ACL_ACTION_VOQ       :  8 ; /* bits 12:5 */
    cs_uint32 ACL_ACTION_LDPID     :  4 ; /* bits 16:13 */
    cs_uint32 ACL_ACTION_CPUCOPY   :  1 ; /* bits 17:17 */
    cs_uint32 ACL_ACTION_CPUCOPY_VOQ :  6 ; /* bits 23:18 */
    cs_uint32 ACL_ACTION_CPUCOPY_PRI :  4 ; /* bits 27:24 */
    cs_uint32 ACL_ACTION_MIRROR_VLD :  1 ; /* bits 28:28 */
    cs_uint32 ACL_ACTION_MIRROR_ID :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_ACLACTION_DATA0_t;





#define FETOP_FE_INTERRUPT_0                     0xf00201d8
#define FETOP_FE_INTERRUPT_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 DBG_INTi_0           :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 PE_INTi_0            :  1 ; /* bits 3:3 */
    cs_uint32 HASH_INTi_0          :  1 ; /* bits 2:2 */
    cs_uint32 LPM_INTi_0           :  1 ; /* bits 1:1 */
    cs_uint32 FWD_INTi_0           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_INTi_0           :  1 ; /* bits 0:0 */
    cs_uint32 LPM_INTi_0           :  1 ; /* bits 1:1 */
    cs_uint32 HASH_INTi_0          :  1 ; /* bits 2:2 */
    cs_uint32 PE_INTi_0            :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 DBG_INTi_0           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_INTERRUPT_0_t;





#define FETOP_FE_INTENABLE_0                     0xf00201dc
#define FETOP_FE_INTENABLE_0_dft                 0x80000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 DBG_INTe_0           :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 PE_INTe_0            :  1 ; /* bits 3:3 */
    cs_uint32 HASH_INTe_0          :  1 ; /* bits 2:2 */
    cs_uint32 LPM_INTe_0           :  1 ; /* bits 1:1 */
    cs_uint32 FWD_INTe_0           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_INTe_0           :  1 ; /* bits 0:0 */
    cs_uint32 LPM_INTe_0           :  1 ; /* bits 1:1 */
    cs_uint32 HASH_INTe_0          :  1 ; /* bits 2:2 */
    cs_uint32 PE_INTe_0            :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 DBG_INTe_0           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_INTENABLE_0_t;





#define FETOP_FE_INTERRUPT_1                     0xf00201e0
#define FETOP_FE_INTERRUPT_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 DBG_INTi_1           :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 PE_INTi_1            :  1 ; /* bits 3:3 */
    cs_uint32 HASH_INTi_1          :  1 ; /* bits 2:2 */
    cs_uint32 LPM_INTi_1           :  1 ; /* bits 1:1 */
    cs_uint32 FWD_INTi_1           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_INTi_1           :  1 ; /* bits 0:0 */
    cs_uint32 LPM_INTi_1           :  1 ; /* bits 1:1 */
    cs_uint32 HASH_INTi_1          :  1 ; /* bits 2:2 */
    cs_uint32 PE_INTi_1            :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 DBG_INTi_1           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_INTERRUPT_1_t;





#define FETOP_FE_INTENABLE_1                     0xf00201e4
#define FETOP_FE_INTENABLE_1_dft                 0x80000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 DBG_INTe_1           :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 PE_INTe_1            :  1 ; /* bits 3:3 */
    cs_uint32 HASH_INTe_1          :  1 ; /* bits 2:2 */
    cs_uint32 LPM_INTe_1           :  1 ; /* bits 1:1 */
    cs_uint32 FWD_INTe_1           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FWD_INTe_1           :  1 ; /* bits 0:0 */
    cs_uint32 LPM_INTe_1           :  1 ; /* bits 1:1 */
    cs_uint32 HASH_INTe_1          :  1 ; /* bits 2:2 */
    cs_uint32 PE_INTe_1            :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 DBG_INTe_1           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_INTENABLE_1_t;





#define FETOP_FE_FWD_INTERRUPT_0                 0xf00201e8
#define FETOP_FE_FWD_INTERRUPT_0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 mem_sdb_prtchkfail_intI :  1 ; /* bits 24:24 */
    cs_uint32 mem_vlntbl_prtchkfail_intI :  1 ; /* bits 23:23 */
    cs_uint32 mem_flowvln_prtchkfail_intI :  1 ; /* bits 22:22 */
    cs_uint32 mem_voqpol_prtchkfail_intI :  1 ; /* bits 21:21 */
    cs_uint32 mem_l3tbl_prtchkfail_intI :  1 ; /* bits 20:20 */
    cs_uint32 mem_l2tbl_prtchkfail_intI :  1 ; /* bits 19:19 */
    cs_uint32 mem_qosrslt_prtchkfail_intI :  1 ; /* bits 18:18 */
    cs_uint32 mem_fwdrslt_prtchkfail_intI :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_aclaction_3_prtchkfail_intI :  1 ; /* bits 14:14 */
    cs_uint32 mem_aclaction_2_prtchkfail_intI :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_1_prtchkfail_intI :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_0_prtchkfail_intI :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclrule_3_prtchkfail_intI :  1 ; /* bits 8:8 */
    cs_uint32 mem_aclrule_2_prtchkfail_intI :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_1_prtchkfail_intI :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_0_prtchkfail_intI :  1 ; /* bits 5:5 */
    cs_uint32 mem_class_3_prtchkfail_intI :  1 ; /* bits 4:4 */
    cs_uint32 mem_class_2_prtchkfail_intI :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_1_prtchkfail_intI :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_0_prtchkfail_intI :  1 ; /* bits 1:1 */
    cs_uint32 drop_intI            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_intI            :  1 ; /* bits 0:0 */
    cs_uint32 mem_class_0_prtchkfail_intI :  1 ; /* bits 1:1 */
    cs_uint32 mem_class_1_prtchkfail_intI :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_2_prtchkfail_intI :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_3_prtchkfail_intI :  1 ; /* bits 4:4 */
    cs_uint32 mem_aclrule_0_prtchkfail_intI :  1 ; /* bits 5:5 */
    cs_uint32 mem_aclrule_1_prtchkfail_intI :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_2_prtchkfail_intI :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_3_prtchkfail_intI :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclaction_0_prtchkfail_intI :  1 ; /* bits 11:11 */
    cs_uint32 mem_aclaction_1_prtchkfail_intI :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_2_prtchkfail_intI :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_3_prtchkfail_intI :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_fwdrslt_prtchkfail_intI :  1 ; /* bits 17:17 */
    cs_uint32 mem_qosrslt_prtchkfail_intI :  1 ; /* bits 18:18 */
    cs_uint32 mem_l2tbl_prtchkfail_intI :  1 ; /* bits 19:19 */
    cs_uint32 mem_l3tbl_prtchkfail_intI :  1 ; /* bits 20:20 */
    cs_uint32 mem_voqpol_prtchkfail_intI :  1 ; /* bits 21:21 */
    cs_uint32 mem_flowvln_prtchkfail_intI :  1 ; /* bits 22:22 */
    cs_uint32 mem_vlntbl_prtchkfail_intI :  1 ; /* bits 23:23 */
    cs_uint32 mem_sdb_prtchkfail_intI :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWD_INTERRUPT_0_t;





#define FETOP_FE_FWD_INTENABLE_0                 0xf00201ec
#define FETOP_FE_FWD_INTENABLE_0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 mem_sdb_prtchkfail_intE :  1 ; /* bits 24:24 */
    cs_uint32 mem_vlntbl_prtchkfail_intE :  1 ; /* bits 23:23 */
    cs_uint32 mem_flowvln_prtchkfail_intE :  1 ; /* bits 22:22 */
    cs_uint32 mem_voqpol_prtchkfail_intE :  1 ; /* bits 21:21 */
    cs_uint32 mem_l3tbl_prtchkfail_intE :  1 ; /* bits 20:20 */
    cs_uint32 mem_l2tbl_prtchkfail_intE :  1 ; /* bits 19:19 */
    cs_uint32 mem_qosrslt_prtchkfail_intE :  1 ; /* bits 18:18 */
    cs_uint32 mem_fwdrslt_prtchkfail_intE :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_aclaction_3_prtchkfail_intE :  1 ; /* bits 14:14 */
    cs_uint32 mem_aclaction_2_prtchkfail_intE :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_1_prtchkfail_intE :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_0_prtchkfail_intE :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclrule_3_prtchkfail_intE :  1 ; /* bits 8:8 */
    cs_uint32 mem_aclrule_2_prtchkfail_intE :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_1_prtchkfail_intE :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_0_prtchkfail_intE :  1 ; /* bits 5:5 */
    cs_uint32 mem_class_3_prtchkfail_intE :  1 ; /* bits 4:4 */
    cs_uint32 mem_class_2_prtchkfail_intE :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_1_prtchkfail_intE :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_0_prtchkfail_intE :  1 ; /* bits 1:1 */
    cs_uint32 drop_intE            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_intE            :  1 ; /* bits 0:0 */
    cs_uint32 mem_class_0_prtchkfail_intE :  1 ; /* bits 1:1 */
    cs_uint32 mem_class_1_prtchkfail_intE :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_2_prtchkfail_intE :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_3_prtchkfail_intE :  1 ; /* bits 4:4 */
    cs_uint32 mem_aclrule_0_prtchkfail_intE :  1 ; /* bits 5:5 */
    cs_uint32 mem_aclrule_1_prtchkfail_intE :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_2_prtchkfail_intE :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_3_prtchkfail_intE :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclaction_0_prtchkfail_intE :  1 ; /* bits 11:11 */
    cs_uint32 mem_aclaction_1_prtchkfail_intE :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_2_prtchkfail_intE :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_3_prtchkfail_intE :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_fwdrslt_prtchkfail_intE :  1 ; /* bits 17:17 */
    cs_uint32 mem_qosrslt_prtchkfail_intE :  1 ; /* bits 18:18 */
    cs_uint32 mem_l2tbl_prtchkfail_intE :  1 ; /* bits 19:19 */
    cs_uint32 mem_l3tbl_prtchkfail_intE :  1 ; /* bits 20:20 */
    cs_uint32 mem_voqpol_prtchkfail_intE :  1 ; /* bits 21:21 */
    cs_uint32 mem_flowvln_prtchkfail_intE :  1 ; /* bits 22:22 */
    cs_uint32 mem_vlntbl_prtchkfail_intE :  1 ; /* bits 23:23 */
    cs_uint32 mem_sdb_prtchkfail_intE :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWD_INTENABLE_0_t;





#define FETOP_FE_FWD_INTERRUPT_1                 0xf00201f0
#define FETOP_FE_FWD_INTERRUPT_1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 mem_sdb_prtchkfail_intI :  1 ; /* bits 24:24 */
    cs_uint32 mem_vlntbl_prtchkfail_intI :  1 ; /* bits 23:23 */
    cs_uint32 mem_flowvln_prtchkfail_intI :  1 ; /* bits 22:22 */
    cs_uint32 mem_voqpol_prtchkfail_intI :  1 ; /* bits 21:21 */
    cs_uint32 mem_l3tbl_prtchkfail_intI :  1 ; /* bits 20:20 */
    cs_uint32 mem_l2tbl_prtchkfail_intI :  1 ; /* bits 19:19 */
    cs_uint32 mem_qosrslt_prtchkfail_intI :  1 ; /* bits 18:18 */
    cs_uint32 mem_fwdrslt_prtchkfail_intI :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_aclaction_3_prtchkfail_intI :  1 ; /* bits 14:14 */
    cs_uint32 mem_aclaction_2_prtchkfail_intI :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_1_prtchkfail_intI :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_0_prtchkfail_intI :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclrule_3_prtchkfail_intI :  1 ; /* bits 8:8 */
    cs_uint32 mem_aclrule_2_prtchkfail_intI :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_1_prtchkfail_intI :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_0_prtchkfail_intI :  1 ; /* bits 5:5 */
    cs_uint32 mem_class_3_prtchkfail_intI :  1 ; /* bits 4:4 */
    cs_uint32 mem_class_2_prtchkfail_intI :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_1_prtchkfail_intI :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_0_prtchkfail_intI :  1 ; /* bits 1:1 */
    cs_uint32 drop_intI            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_intI            :  1 ; /* bits 0:0 */
    cs_uint32 mem_class_0_prtchkfail_intI :  1 ; /* bits 1:1 */
    cs_uint32 mem_class_1_prtchkfail_intI :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_2_prtchkfail_intI :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_3_prtchkfail_intI :  1 ; /* bits 4:4 */
    cs_uint32 mem_aclrule_0_prtchkfail_intI :  1 ; /* bits 5:5 */
    cs_uint32 mem_aclrule_1_prtchkfail_intI :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_2_prtchkfail_intI :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_3_prtchkfail_intI :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclaction_0_prtchkfail_intI :  1 ; /* bits 11:11 */
    cs_uint32 mem_aclaction_1_prtchkfail_intI :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_2_prtchkfail_intI :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_3_prtchkfail_intI :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_fwdrslt_prtchkfail_intI :  1 ; /* bits 17:17 */
    cs_uint32 mem_qosrslt_prtchkfail_intI :  1 ; /* bits 18:18 */
    cs_uint32 mem_l2tbl_prtchkfail_intI :  1 ; /* bits 19:19 */
    cs_uint32 mem_l3tbl_prtchkfail_intI :  1 ; /* bits 20:20 */
    cs_uint32 mem_voqpol_prtchkfail_intI :  1 ; /* bits 21:21 */
    cs_uint32 mem_flowvln_prtchkfail_intI :  1 ; /* bits 22:22 */
    cs_uint32 mem_vlntbl_prtchkfail_intI :  1 ; /* bits 23:23 */
    cs_uint32 mem_sdb_prtchkfail_intI :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWD_INTERRUPT_1_t;





#define FETOP_FE_FWD_INTENABLE_1                 0xf00201f4
#define FETOP_FE_FWD_INTENABLE_1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 mem_sdb_prtchkfail_intE :  1 ; /* bits 24:24 */
    cs_uint32 mem_vlntbl_prtchkfail_intE :  1 ; /* bits 23:23 */
    cs_uint32 mem_flowvln_prtchkfail_intE :  1 ; /* bits 22:22 */
    cs_uint32 mem_voqpol_prtchkfail_intE :  1 ; /* bits 21:21 */
    cs_uint32 mem_l3tbl_prtchkfail_intE :  1 ; /* bits 20:20 */
    cs_uint32 mem_l2tbl_prtchkfail_intE :  1 ; /* bits 19:19 */
    cs_uint32 mem_qosrslt_prtchkfail_intE :  1 ; /* bits 18:18 */
    cs_uint32 mem_fwdrslt_prtchkfail_intE :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_aclaction_3_prtchkfail_intE :  1 ; /* bits 14:14 */
    cs_uint32 mem_aclaction_2_prtchkfail_intE :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_1_prtchkfail_intE :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_0_prtchkfail_intE :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclrule_3_prtchkfail_intE :  1 ; /* bits 8:8 */
    cs_uint32 mem_aclrule_2_prtchkfail_intE :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_1_prtchkfail_intE :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_0_prtchkfail_intE :  1 ; /* bits 5:5 */
    cs_uint32 mem_class_3_prtchkfail_intE :  1 ; /* bits 4:4 */
    cs_uint32 mem_class_2_prtchkfail_intE :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_1_prtchkfail_intE :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_0_prtchkfail_intE :  1 ; /* bits 1:1 */
    cs_uint32 drop_intE            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_intE            :  1 ; /* bits 0:0 */
    cs_uint32 mem_class_0_prtchkfail_intE :  1 ; /* bits 1:1 */
    cs_uint32 mem_class_1_prtchkfail_intE :  1 ; /* bits 2:2 */
    cs_uint32 mem_class_2_prtchkfail_intE :  1 ; /* bits 3:3 */
    cs_uint32 mem_class_3_prtchkfail_intE :  1 ; /* bits 4:4 */
    cs_uint32 mem_aclrule_0_prtchkfail_intE :  1 ; /* bits 5:5 */
    cs_uint32 mem_aclrule_1_prtchkfail_intE :  1 ; /* bits 6:6 */
    cs_uint32 mem_aclrule_2_prtchkfail_intE :  1 ; /* bits 7:7 */
    cs_uint32 mem_aclrule_3_prtchkfail_intE :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_aclaction_0_prtchkfail_intE :  1 ; /* bits 11:11 */
    cs_uint32 mem_aclaction_1_prtchkfail_intE :  1 ; /* bits 12:12 */
    cs_uint32 mem_aclaction_2_prtchkfail_intE :  1 ; /* bits 13:13 */
    cs_uint32 mem_aclaction_3_prtchkfail_intE :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 mem_fwdrslt_prtchkfail_intE :  1 ; /* bits 17:17 */
    cs_uint32 mem_qosrslt_prtchkfail_intE :  1 ; /* bits 18:18 */
    cs_uint32 mem_l2tbl_prtchkfail_intE :  1 ; /* bits 19:19 */
    cs_uint32 mem_l3tbl_prtchkfail_intE :  1 ; /* bits 20:20 */
    cs_uint32 mem_voqpol_prtchkfail_intE :  1 ; /* bits 21:21 */
    cs_uint32 mem_flowvln_prtchkfail_intE :  1 ; /* bits 22:22 */
    cs_uint32 mem_vlntbl_prtchkfail_intE :  1 ; /* bits 23:23 */
    cs_uint32 mem_sdb_prtchkfail_intE :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_FWD_INTENABLE_1_t;





#define FETOP_FE_DBG_INTERRUPT_0                 0xf00201f8
#define FETOP_FE_DBG_INTERRUPT_0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_class_hit_intI   :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 tm_buf_ovf_intI      :  1 ; /* bits 12:12 */
    cs_uint32 inbuf_ovf_intI       :  1 ; /* bits 11:11 */
    cs_uint32 qos_rslt_buf_ovf_intI :  1 ; /* bits 10:10 */
    cs_uint32 qos_rslt_buf_int_ovf_intI :  1 ; /* bits 9:9 */
    cs_uint32 fwd_rslt_buf_ovf_intI :  1 ; /* bits 8:8 */
    cs_uint32 fwd_rslt_buf_int_ovf_intI :  1 ; /* bits 7:7 */
    cs_uint32 lpm_rslt_buf_ovf_intI :  1 ; /* bits 6:6 */
    cs_uint32 lpm_rslt_buf_int_ovf_intI :  1 ; /* bits 5:5 */
    cs_uint32 hlkp_rslt_buf_ovf_intI :  1 ; /* bits 4:4 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intI :  1 ; /* bits 3:3 */
    cs_uint32 class_rslt_buf_ovf_intI :  1 ; /* bits 2:2 */
    cs_uint32 class_rslt_buf_int_ovf_intI :  1 ; /* bits 1:1 */
    cs_uint32 hdr_d_buf_ovf_intI   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hdr_d_buf_ovf_intI   :  1 ; /* bits 0:0 */
    cs_uint32 class_rslt_buf_int_ovf_intI :  1 ; /* bits 1:1 */
    cs_uint32 class_rslt_buf_ovf_intI :  1 ; /* bits 2:2 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intI :  1 ; /* bits 3:3 */
    cs_uint32 hlkp_rslt_buf_ovf_intI :  1 ; /* bits 4:4 */
    cs_uint32 lpm_rslt_buf_int_ovf_intI :  1 ; /* bits 5:5 */
    cs_uint32 lpm_rslt_buf_ovf_intI :  1 ; /* bits 6:6 */
    cs_uint32 fwd_rslt_buf_int_ovf_intI :  1 ; /* bits 7:7 */
    cs_uint32 fwd_rslt_buf_ovf_intI :  1 ; /* bits 8:8 */
    cs_uint32 qos_rslt_buf_int_ovf_intI :  1 ; /* bits 9:9 */
    cs_uint32 qos_rslt_buf_ovf_intI :  1 ; /* bits 10:10 */
    cs_uint32 inbuf_ovf_intI       :  1 ; /* bits 11:11 */
    cs_uint32 tm_buf_ovf_intI      :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 dbg_class_hit_intI   :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_INTERRUPT_0_t;





#define FETOP_FE_DBG_INTENABLE_0                 0xf00201fc
#define FETOP_FE_DBG_INTENABLE_0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_class_hit_intE   :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 tm_buf_ovf_intE      :  1 ; /* bits 12:12 */
    cs_uint32 inbuf_ovf_intE       :  1 ; /* bits 11:11 */
    cs_uint32 qos_rslt_buf_ovf_intE :  1 ; /* bits 10:10 */
    cs_uint32 qos_rslt_buf_int_ovf_intE :  1 ; /* bits 9:9 */
    cs_uint32 fwd_rslt_buf_ovf_intE :  1 ; /* bits 8:8 */
    cs_uint32 fwd_rslt_buf_int_ovf_intE :  1 ; /* bits 7:7 */
    cs_uint32 lpm_rslt_buf_ovf_intE :  1 ; /* bits 6:6 */
    cs_uint32 lpm_rslt_buf_int_ovf_intE :  1 ; /* bits 5:5 */
    cs_uint32 hlkp_rslt_buf_ovf_intE :  1 ; /* bits 4:4 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intE :  1 ; /* bits 3:3 */
    cs_uint32 class_rslt_buf_ovf_intE :  1 ; /* bits 2:2 */
    cs_uint32 class_rslt_buf_int_ovf_intE :  1 ; /* bits 1:1 */
    cs_uint32 hdr_d_buf_ovf_intE   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hdr_d_buf_ovf_intE   :  1 ; /* bits 0:0 */
    cs_uint32 class_rslt_buf_int_ovf_intE :  1 ; /* bits 1:1 */
    cs_uint32 class_rslt_buf_ovf_intE :  1 ; /* bits 2:2 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intE :  1 ; /* bits 3:3 */
    cs_uint32 hlkp_rslt_buf_ovf_intE :  1 ; /* bits 4:4 */
    cs_uint32 lpm_rslt_buf_int_ovf_intE :  1 ; /* bits 5:5 */
    cs_uint32 lpm_rslt_buf_ovf_intE :  1 ; /* bits 6:6 */
    cs_uint32 fwd_rslt_buf_int_ovf_intE :  1 ; /* bits 7:7 */
    cs_uint32 fwd_rslt_buf_ovf_intE :  1 ; /* bits 8:8 */
    cs_uint32 qos_rslt_buf_int_ovf_intE :  1 ; /* bits 9:9 */
    cs_uint32 qos_rslt_buf_ovf_intE :  1 ; /* bits 10:10 */
    cs_uint32 inbuf_ovf_intE       :  1 ; /* bits 11:11 */
    cs_uint32 tm_buf_ovf_intE      :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 dbg_class_hit_intE   :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_INTENABLE_0_t;





#define FETOP_FE_DBG_INTERRUPT_1                 0xf0020200
#define FETOP_FE_DBG_INTERRUPT_1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_class_hit_intI   :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 tm_buf_ovf_intI      :  1 ; /* bits 12:12 */
    cs_uint32 inbuf_ovf_intI       :  1 ; /* bits 11:11 */
    cs_uint32 qos_rslt_buf_ovf_intI :  1 ; /* bits 10:10 */
    cs_uint32 qos_rslt_buf_int_ovf_intI :  1 ; /* bits 9:9 */
    cs_uint32 fwd_rslt_buf_ovf_intI :  1 ; /* bits 8:8 */
    cs_uint32 fwd_rslt_buf_int_ovf_intI :  1 ; /* bits 7:7 */
    cs_uint32 lpm_rslt_buf_ovf_intI :  1 ; /* bits 6:6 */
    cs_uint32 lpm_rslt_buf_int_ovf_intI :  1 ; /* bits 5:5 */
    cs_uint32 hlkp_rslt_buf_ovf_intI :  1 ; /* bits 4:4 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intI :  1 ; /* bits 3:3 */
    cs_uint32 class_rslt_buf_ovf_intI :  1 ; /* bits 2:2 */
    cs_uint32 class_rslt_buf_int_ovf_intI :  1 ; /* bits 1:1 */
    cs_uint32 hdr_d_buf_ovf_intI   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hdr_d_buf_ovf_intI   :  1 ; /* bits 0:0 */
    cs_uint32 class_rslt_buf_int_ovf_intI :  1 ; /* bits 1:1 */
    cs_uint32 class_rslt_buf_ovf_intI :  1 ; /* bits 2:2 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intI :  1 ; /* bits 3:3 */
    cs_uint32 hlkp_rslt_buf_ovf_intI :  1 ; /* bits 4:4 */
    cs_uint32 lpm_rslt_buf_int_ovf_intI :  1 ; /* bits 5:5 */
    cs_uint32 lpm_rslt_buf_ovf_intI :  1 ; /* bits 6:6 */
    cs_uint32 fwd_rslt_buf_int_ovf_intI :  1 ; /* bits 7:7 */
    cs_uint32 fwd_rslt_buf_ovf_intI :  1 ; /* bits 8:8 */
    cs_uint32 qos_rslt_buf_int_ovf_intI :  1 ; /* bits 9:9 */
    cs_uint32 qos_rslt_buf_ovf_intI :  1 ; /* bits 10:10 */
    cs_uint32 inbuf_ovf_intI       :  1 ; /* bits 11:11 */
    cs_uint32 tm_buf_ovf_intI      :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 dbg_class_hit_intI   :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_INTERRUPT_1_t;





#define FETOP_FE_DBG_INTENABLE_1                 0xf0020204
#define FETOP_FE_DBG_INTENABLE_1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_class_hit_intE   :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 tm_buf_ovf_intE      :  1 ; /* bits 12:12 */
    cs_uint32 inbuf_ovf_intE       :  1 ; /* bits 11:11 */
    cs_uint32 qos_rslt_buf_ovf_intE :  1 ; /* bits 10:10 */
    cs_uint32 qos_rslt_buf_int_ovf_intE :  1 ; /* bits 9:9 */
    cs_uint32 fwd_rslt_buf_ovf_intE :  1 ; /* bits 8:8 */
    cs_uint32 fwd_rslt_buf_int_ovf_intE :  1 ; /* bits 7:7 */
    cs_uint32 lpm_rslt_buf_ovf_intE :  1 ; /* bits 6:6 */
    cs_uint32 lpm_rslt_buf_int_ovf_intE :  1 ; /* bits 5:5 */
    cs_uint32 hlkp_rslt_buf_ovf_intE :  1 ; /* bits 4:4 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intE :  1 ; /* bits 3:3 */
    cs_uint32 class_rslt_buf_ovf_intE :  1 ; /* bits 2:2 */
    cs_uint32 class_rslt_buf_int_ovf_intE :  1 ; /* bits 1:1 */
    cs_uint32 hdr_d_buf_ovf_intE   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hdr_d_buf_ovf_intE   :  1 ; /* bits 0:0 */
    cs_uint32 class_rslt_buf_int_ovf_intE :  1 ; /* bits 1:1 */
    cs_uint32 class_rslt_buf_ovf_intE :  1 ; /* bits 2:2 */
    cs_uint32 hlkp_rslt_buf_int_ovf_intE :  1 ; /* bits 3:3 */
    cs_uint32 hlkp_rslt_buf_ovf_intE :  1 ; /* bits 4:4 */
    cs_uint32 lpm_rslt_buf_int_ovf_intE :  1 ; /* bits 5:5 */
    cs_uint32 lpm_rslt_buf_ovf_intE :  1 ; /* bits 6:6 */
    cs_uint32 fwd_rslt_buf_int_ovf_intE :  1 ; /* bits 7:7 */
    cs_uint32 fwd_rslt_buf_ovf_intE :  1 ; /* bits 8:8 */
    cs_uint32 qos_rslt_buf_int_ovf_intE :  1 ; /* bits 9:9 */
    cs_uint32 qos_rslt_buf_ovf_intE :  1 ; /* bits 10:10 */
    cs_uint32 inbuf_ovf_intE       :  1 ; /* bits 11:11 */
    cs_uint32 tm_buf_ovf_intE      :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 dbg_class_hit_intE   :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_INTENABLE_1_t;





#define FETOP_FE_PE_INTERRUPT_0                  0xf0020208
#define FETOP_FE_PE_INTERRUPT_0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 pe_ipv6_udpcsum_0_detI :  1 ; /* bits 6:6 */
    cs_uint32 pe_runt_pkt_detI     :  1 ; /* bits 5:5 */
    cs_uint32 pe_hdra_pkt_drop_msb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pe_fe_pkt_drop_msb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pe_fe_pkt_cnt_msb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pe_cmd_fifo_overflow_intI :  1 ; /* bits 1:1 */
    cs_uint32 pe_data_fifo_overflow_intI :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pe_data_fifo_overflow_intI :  1 ; /* bits 0:0 */
    cs_uint32 pe_cmd_fifo_overflow_intI :  1 ; /* bits 1:1 */
    cs_uint32 pe_fe_pkt_cnt_msb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pe_fe_pkt_drop_msb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pe_hdra_pkt_drop_msb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pe_runt_pkt_detI     :  1 ; /* bits 5:5 */
    cs_uint32 pe_ipv6_udpcsum_0_detI :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_INTERRUPT_0_t;





#define FETOP_FE_PE_INTENABLE_0                  0xf002020c
#define FETOP_FE_PE_INTENABLE_0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 pe_ipv6_udpcsum_0_detE :  1 ; /* bits 6:6 */
    cs_uint32 pe_runt_pkt_detE     :  1 ; /* bits 5:5 */
    cs_uint32 pe_hdra_pkt_drop_msb_setE :  1 ; /* bits 4:4 */
    cs_uint32 pe_fe_pkt_drop_msb_setE :  1 ; /* bits 3:3 */
    cs_uint32 pe_fe_pkt_cnt_msb_setE :  1 ; /* bits 2:2 */
    cs_uint32 pe_cmd_fifo_overflow_intE :  1 ; /* bits 1:1 */
    cs_uint32 pe_data_fifo_overflow_intE :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pe_data_fifo_overflow_intE :  1 ; /* bits 0:0 */
    cs_uint32 pe_cmd_fifo_overflow_intE :  1 ; /* bits 1:1 */
    cs_uint32 pe_fe_pkt_cnt_msb_setE :  1 ; /* bits 2:2 */
    cs_uint32 pe_fe_pkt_drop_msb_setE :  1 ; /* bits 3:3 */
    cs_uint32 pe_hdra_pkt_drop_msb_setE :  1 ; /* bits 4:4 */
    cs_uint32 pe_runt_pkt_detE     :  1 ; /* bits 5:5 */
    cs_uint32 pe_ipv6_udpcsum_0_detE :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_INTENABLE_0_t;





#define FETOP_FE_PE_INTERRUPT_1                  0xf0020210
#define FETOP_FE_PE_INTERRUPT_1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 pe_ipv6_udpcsum_0_detI :  1 ; /* bits 6:6 */
    cs_uint32 pe_runt_pkt_detI     :  1 ; /* bits 5:5 */
    cs_uint32 pe_hdra_pkt_drop_msb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pe_fe_pkt_drop_msb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pe_fe_pkt_cnt_msb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pe_cmd_fifo_overflow_intI :  1 ; /* bits 1:1 */
    cs_uint32 pe_data_fifo_overflow_intI :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pe_data_fifo_overflow_intI :  1 ; /* bits 0:0 */
    cs_uint32 pe_cmd_fifo_overflow_intI :  1 ; /* bits 1:1 */
    cs_uint32 pe_fe_pkt_cnt_msb_setI :  1 ; /* bits 2:2 */
    cs_uint32 pe_fe_pkt_drop_msb_setI :  1 ; /* bits 3:3 */
    cs_uint32 pe_hdra_pkt_drop_msb_setI :  1 ; /* bits 4:4 */
    cs_uint32 pe_runt_pkt_detI     :  1 ; /* bits 5:5 */
    cs_uint32 pe_ipv6_udpcsum_0_detI :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_INTERRUPT_1_t;





#define FETOP_FE_PE_INTENABLE_1                  0xf0020214
#define FETOP_FE_PE_INTENABLE_1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 pe_ipv6_udpcsum_0_detE :  1 ; /* bits 6:6 */
    cs_uint32 pe_runt_pkt_detE     :  1 ; /* bits 5:5 */
    cs_uint32 pe_hdra_pkt_drop_msb_setE :  1 ; /* bits 4:4 */
    cs_uint32 pe_fe_pkt_drop_msb_setE :  1 ; /* bits 3:3 */
    cs_uint32 pe_fe_pkt_cnt_msb_setE :  1 ; /* bits 2:2 */
    cs_uint32 pe_cmd_fifo_overflow_intE :  1 ; /* bits 1:1 */
    cs_uint32 pe_data_fifo_overflow_intE :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pe_data_fifo_overflow_intE :  1 ; /* bits 0:0 */
    cs_uint32 pe_cmd_fifo_overflow_intE :  1 ; /* bits 1:1 */
    cs_uint32 pe_fe_pkt_cnt_msb_setE :  1 ; /* bits 2:2 */
    cs_uint32 pe_fe_pkt_drop_msb_setE :  1 ; /* bits 3:3 */
    cs_uint32 pe_hdra_pkt_drop_msb_setE :  1 ; /* bits 4:4 */
    cs_uint32 pe_runt_pkt_detE     :  1 ; /* bits 5:5 */
    cs_uint32 pe_ipv6_udpcsum_0_detE :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_INTENABLE_1_t;





#define FETOP_FE_DBG_FE_PP                       0xf0020218
#define FETOP_FE_DBG_FE_PP_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 state                :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 state                :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_FE_PP_t;





#define FETOP_FE_DBG_FE_PP_CNTR                  0xf002021c
#define FETOP_FE_DBG_FE_PP_CNTR_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 cntr                 : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cntr                 : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_FE_PP_CNTR_t;





#define FETOP_FE_PE_CONFIG                       0xf0020220
#define FETOP_FE_PE_CONFIG_dft                   0x000010d8




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bypass_pr            :  1 ; /* bits 31:31 */
    cs_uint32 bypass_pe            :  1 ; /* bits 30:30 */
    cs_uint32 dscp_dbg             :  1 ; /* bits 29:29 */
    cs_uint32 vlan_dbg             :  1 ; /* bits 28:28 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 pecnt_op_code        :  2 ; /* bits 26:25 */
    cs_uint32 pecnt_debug_mode     :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 pe_keep_ts_byp       :  1 ; /* bits 21:21 */
    cs_uint32 pe_crc_ins_dis       :  1 ; /* bits 20:20 */
    cs_uint32 pe_stuff_dis         :  1 ; /* bits 19:19 */
    cs_uint32 pe_fifo_reset        :  1 ; /* bits 18:18 */
    cs_uint32 dis_mirror_drop      :  1 ; /* bits 17:17 */
    cs_uint32 stomp_crc            :  1 ; /* bits 16:16 */
    cs_uint32 ni_rdy_ff_thld       :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 cmdff_rdy_thld       :  5 ; /* bits 12:8 */
    cs_uint32 dataff_rdy_thld      :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dataff_rdy_thld      :  8 ; /* bits 7:0 */
    cs_uint32 cmdff_rdy_thld       :  5 ; /* bits 12:8 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 ni_rdy_ff_thld       :  1 ; /* bits 15:15 */
    cs_uint32 stomp_crc            :  1 ; /* bits 16:16 */
    cs_uint32 dis_mirror_drop      :  1 ; /* bits 17:17 */
    cs_uint32 pe_fifo_reset        :  1 ; /* bits 18:18 */
    cs_uint32 pe_stuff_dis         :  1 ; /* bits 19:19 */
    cs_uint32 pe_crc_ins_dis       :  1 ; /* bits 20:20 */
    cs_uint32 pe_keep_ts_byp       :  1 ; /* bits 21:21 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 pecnt_debug_mode     :  1 ; /* bits 24:24 */
    cs_uint32 pecnt_op_code        :  2 ; /* bits 26:25 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 vlan_dbg             :  1 ; /* bits 28:28 */
    cs_uint32 dscp_dbg             :  1 ; /* bits 29:29 */
    cs_uint32 bypass_pe            :  1 ; /* bits 30:30 */
    cs_uint32 bypass_pr            :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_CONFIG_t;





#define FETOP_FE_PE_CONFIG_1                     0xf0020224
#define FETOP_FE_PE_CONFIG_1_dft                 0x00006000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 pe_cfg_spare         :  4 ; /* bits 27:24 */
    cs_uint32 qm_pkt_cnt_voq       :  8 ; /* bits 23:16 */
    cs_uint32 parse_limit          :  5 ; /* bits 15:11 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 ins_cpuhdr_encap     :  1 ; /* bits 9:9 */
    cs_uint32 ins_cpuhdr_crypto    :  1 ; /* bits 8:8 */
    cs_uint32 ins_cpuhdr_voq       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ins_cpuhdr_voq       :  8 ; /* bits 7:0 */
    cs_uint32 ins_cpuhdr_crypto    :  1 ; /* bits 8:8 */
    cs_uint32 ins_cpuhdr_encap     :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 parse_limit          :  5 ; /* bits 15:11 */
    cs_uint32 qm_pkt_cnt_voq       :  8 ; /* bits 23:16 */
    cs_uint32 pe_cfg_spare         :  4 ; /* bits 27:24 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_CONFIG_1_t;





#define FETOP_FE_PE_PPPOE_CFG_0                  0xf0020228
#define FETOP_FE_PE_PPPOE_CFG_0_dft              0x88640011




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 encap_pppoe_ethtype  : 16 ; /* bits 31:16 */
    cs_uint32 encap_code           :  8 ; /* bits 15:8 */
    cs_uint32 encap_ver            :  4 ; /* bits 7:4 */
    cs_uint32 encap_type           :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 encap_type           :  4 ; /* bits 3:0 */
    cs_uint32 encap_ver            :  4 ; /* bits 7:4 */
    cs_uint32 encap_code           :  8 ; /* bits 15:8 */
    cs_uint32 encap_pppoe_ethtype  : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_PPPOE_CFG_0_t;





#define FETOP_FE_PE_PPPOE_CFG_1                  0xf002022c
#define FETOP_FE_PE_PPPOE_CFG_1_dft              0x00210800




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv4_ppp_type        : 16 ; /* bits 31:16 */
    cs_uint32 ipv4_ethtype         : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_ethtype         : 16 ; /* bits 15:0 */
    cs_uint32 ipv4_ppp_type        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_PPPOE_CFG_1_t;





#define FETOP_FE_PE_PPPOE_CFG_2                  0xf0020230
#define FETOP_FE_PE_PPPOE_CFG_2_dft              0x005786dd




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv6_ppp_type        : 16 ; /* bits 31:16 */
    cs_uint32 ipv6_ethtype         : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_ethtype         : 16 ; /* bits 15:0 */
    cs_uint32 ipv6_ppp_type        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_PPPOE_CFG_2_t;





#define FETOP_FE_PE_PPPOE_CFG_3                  0xf0020234
#define FETOP_FE_PE_PPPOE_CFG_3_dft              0x00378000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 def_ppp_type         : 16 ; /* bits 31:16 */
    cs_uint32 def_ethtype          : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 def_ethtype          : 16 ; /* bits 15:0 */
    cs_uint32 def_ppp_type         : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_PPPOE_CFG_3_t;





#define FETOP_FE_PROC_DROP_STS                   0xf0020238
#define FETOP_FE_PROC_DROP_STS_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 vec                  : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 vec                  : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PROC_DROP_STS_t;





#define FETOP_FE_PE_VOQ_DRP_ACCESS               0xf002023c
#define FETOP_FE_PE_VOQ_DRP_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 address              :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_VOQ_DRP_ACCESS_t;





#define FETOP_FE_PE_VOQ_DRP_DATA                 0xf0020240
#define FETOP_FE_PE_VOQ_DRP_DATA_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 drop_cfg             :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_cfg             :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_VOQ_DRP_DATA_t;





#define FETOP_FE_PE_PKT_CNT                      0xf0020244
#define FETOP_FE_PE_PKT_CNT_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 fe_pkt_cnt           : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 fe_pkt_cnt           : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_PKT_CNT_t;





#define FETOP_FE_PE_HDRA_PKT_DROPCNT             0xf0020248
#define FETOP_FE_PE_HDRA_PKT_DROPCNT_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 hdra_pkt_drop        : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hdra_pkt_drop        : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_HDRA_PKT_DROPCNT_t;





#define FETOP_FE_PE_FE_PKT_DROPCNT               0xf002024c
#define FETOP_FE_PE_FE_PKT_DROPCNT_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 fe_pkt_drop          : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 fe_pkt_drop          : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_FE_PKT_DROPCNT_t;





#define FETOP_FE_PE_DEBUG                        0xf0020250
#define FETOP_FE_PE_DEBUG_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pe_cf_op_ccnt        :  8 ; /* bits 31:24 */
    cs_uint32 pe_cf_ip_ccnt        :  8 ; /* bits 23:16 */
    cs_uint32 pe_df_op_scnt        :  8 ; /* bits 15:8 */
    cs_uint32 pe_df_ip_scnt        :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pe_df_ip_scnt        :  8 ; /* bits 7:0 */
    cs_uint32 pe_df_op_scnt        :  8 ; /* bits 15:8 */
    cs_uint32 pe_cf_ip_ccnt        :  8 ; /* bits 23:16 */
    cs_uint32 pe_cf_op_ccnt        :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PE_DEBUG_t;





#define FETOP_FE_DBG_CLASS_MON_CMD               0xf0020254
#define FETOP_FE_DBG_CLASS_MON_CMD_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 trigger              :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 bank                 :  2 ; /* bits 5:4 */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
    cs_uint32 bank                 :  2 ; /* bits 5:4 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 trigger              :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_CLASS_MON_CMD_t;





#define FETOP_FE_DBG_CLASS_MON_STS               0xf0020258
#define FETOP_FE_DBG_CLASS_MON_STS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 hit                  :  1 ; /* bits 31:31 */
    cs_uint32 match                :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 svidx                :  6 ; /* bits 11:6 */
    cs_uint32 bank                 :  2 ; /* bits 5:4 */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
    cs_uint32 bank                 :  2 ; /* bits 5:4 */
    cs_uint32 svidx                :  6 ; /* bits 11:6 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 match                :  1 ; /* bits 30:30 */
    cs_uint32 hit                  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_DBG_CLASS_MON_STS_t;





#define FETOP_FE_MEM_CLASS_PRTCHKFAIL_STS        0xf002025c
#define FETOP_FE_MEM_CLASS_PRTCHKFAIL_STS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_CLASS_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_ACLRULE_PRTCHKFAIL_STS      0xf0020260
#define FETOP_FE_MEM_ACLRULE_PRTCHKFAIL_STS_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_ACLRULE_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_ACLACTION_PRTCHKFAIL_STS    0xf0020264
#define FETOP_FE_MEM_ACLACTION_PRTCHKFAIL_STS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bank_0               :  4 ; /* bits 3:0 */
    cs_uint32 bank_1               :  4 ; /* bits 7:4 */
    cs_uint32 bank_2               :  4 ; /* bits 11:8 */
    cs_uint32 bank_3               :  4 ; /* bits 15:12 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_ACLACTION_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_FWDRSLT_PRTCHKFAIL_STS      0xf0020268
#define FETOP_FE_MEM_FWDRSLT_PRTCHKFAIL_STS_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 addr                 : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 19 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_FWDRSLT_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_QOSRSLT_PRTCHKFAIL_STS      0xf002026c
#define FETOP_FE_MEM_QOSRSLT_PRTCHKFAIL_STS_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_QOSRSLT_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_L2TBL_PRTCHKFAIL_STS        0xf0020270
#define FETOP_FE_MEM_L2TBL_PRTCHKFAIL_STS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_L2TBL_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_L3TBL_PRTCHKFAIL_STS        0xf0020274
#define FETOP_FE_MEM_L3TBL_PRTCHKFAIL_STS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 addr                 : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 10 ; /* bits 9:0 */
    cs_uint32 rsrvd1               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_L3TBL_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_FLOWVLN_PRTCHKFAIL_STS      0xf0020278
#define FETOP_FE_MEM_FLOWVLN_PRTCHKFAIL_STS_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_FLOWVLN_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_VOQPOL_PRTCHKFAIL_STS       0xf002027c
#define FETOP_FE_MEM_VOQPOL_PRTCHKFAIL_STS_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_VOQPOL_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_VLNTBL_PRTCHKFAIL_STS       0xf0020280
#define FETOP_FE_MEM_VLNTBL_PRTCHKFAIL_STS_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_VLNTBL_PRTCHKFAIL_STS_t;





#define FETOP_FE_MEM_SDB_PRTCHKFAIL_STS          0xf0020284
#define FETOP_FE_MEM_SDB_PRTCHKFAIL_STS_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 addr                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_MEM_SDB_PRTCHKFAIL_STS_t;





#define FETOP_FE_PKTLEN_RNGS_ACCESS              0xf0020288
#define FETOP_FE_PKTLEN_RNGS_ACCESS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 ADDR                 :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ADDR                 :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PKTLEN_RNGS_ACCESS_t;





#define FETOP_FE_PKTLEN_RNGS_DATA                0xf002028c
#define FETOP_FE_PKTLEN_RNGS_DATA_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 valid                :  1 ; /* bits 28:28 */
    cs_uint32 pktlen_high          : 14 ; /* bits 27:14 */
    cs_uint32 pktlen_low           : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pktlen_low           : 14 ; /* bits 13:0 */
    cs_uint32 pktlen_high          : 14 ; /* bits 27:14 */
    cs_uint32 valid                :  1 ; /* bits 28:28 */
    cs_uint32 rsrvd1               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_FE_PKTLEN_RNGS_DATA_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE */

typedef struct {
  FETOP_FE_SCRATCH_t                       SCRATCH;                       /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  FETOP_FE_AN_BNG_MAC_ACCESS_t             AN_BNG_MAC_ACCESS;             /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  FETOP_FE_AN_BNG_MAC_DATA1_t              AN_BNG_MAC_DATA1;              /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  FETOP_FE_AN_BNG_MAC_DATA0_t              AN_BNG_MAC_DATA0;              /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  FETOP_FE_L4_PORT_RNGS_ACCESS_t           L4_PORT_RNGS_ACCESS;           /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  FETOP_FE_L4_PORT_RNGS_DATA1_t            L4_PORT_RNGS_DATA1;            /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  FETOP_FE_L4_PORT_RNGS_DATA0_t            L4_PORT_RNGS_DATA0;            /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  FETOP_FE_ETYPE_ACCESS_t                  ETYPE_ACCESS;                  /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  FETOP_FE_ETYPE_DATA_t                    ETYPE_DATA;                    /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  FETOP_FE_LLC_HDR_ACCESS_t                LLC_HDR_ACCESS;                /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  FETOP_FE_LLC_HDR_DATA_t                  LLC_HDR_DATA;                  /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  FETOP_FE_LLC_OTHER_A_t                   LLC_OTHER_A;                   /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  FETOP_FE_LLC_OTHER_B_t                   LLC_OTHER_B;                   /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  FETOP_FE_CFG_TPID1_t                     CFG_TPID1;                     /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  FETOP_FE_CFG_TPID0_t                     CFG_TPID0;                     /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  FETOP_FE_PRSR_CFG_0_t                    PRSR_CFG_0;                    /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  FETOP_FE_CFG_GLBL_t                      CFG_GLBL;                      /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  FETOP_FE_STS_GLBL_t                      STS_GLBL;                      /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  FETOP_FE_PROC_CFG_0_t                    PROC_CFG_0;                    /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  FETOP_FE_LPB_ACCESS_t                    LPB_ACCESS;                    /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  FETOP_FE_LPB_DATA_t                      LPB_DATA;                      /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  FETOP_FE_CLASS_ACCESS_t                  CLASS_ACCESS;                  /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  FETOP_FE_CLASS_DATA19_t                  CLASS_DATA19;                  /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  FETOP_FE_CLASS_DATA18_t                  CLASS_DATA18;                  /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  FETOP_FE_CLASS_DATA17_t                  CLASS_DATA17;                  /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  FETOP_FE_CLASS_DATA16_t                  CLASS_DATA16;                  /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  FETOP_FE_CLASS_DATA15_t                  CLASS_DATA15;                  /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  FETOP_FE_CLASS_DATA14_t                  CLASS_DATA14;                  /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  FETOP_FE_CLASS_DATA13_t                  CLASS_DATA13;                  /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  FETOP_FE_CLASS_DATA12_t                  CLASS_DATA12;                  /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  FETOP_FE_CLASS_DATA11_t                  CLASS_DATA11;                  /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  FETOP_FE_CLASS_DATA10_t                  CLASS_DATA10;                  /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  FETOP_FE_CLASS_DATA9_t                   CLASS_DATA9;                   /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  FETOP_FE_CLASS_DATA8_t                   CLASS_DATA8;                   /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  FETOP_FE_CLASS_DATA7_t                   CLASS_DATA7;                   /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  FETOP_FE_CLASS_DATA6_t                   CLASS_DATA6;                   /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  FETOP_FE_CLASS_DATA5_t                   CLASS_DATA5;                   /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  FETOP_FE_CLASS_DATA4_t                   CLASS_DATA4;                   /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  FETOP_FE_CLASS_DATA3_t                   CLASS_DATA3;                   /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  FETOP_FE_CLASS_DATA2_t                   CLASS_DATA2;                   /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  FETOP_FE_CLASS_DATA1_t                   CLASS_DATA1;                   /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  FETOP_FE_CLASS_DATA0_t                   CLASS_DATA0;                   /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  FETOP_FE_SDB_ACCESS_t                    SDB_ACCESS;                    /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  FETOP_FE_SDB_DATA6_t                     SDB_DATA6;                     /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  FETOP_FE_SDB_DATA5_t                     SDB_DATA5;                     /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  FETOP_FE_SDB_DATA4_t                     SDB_DATA4;                     /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  FETOP_FE_SDB_DATA3_t                     SDB_DATA3;                     /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  FETOP_FE_SDB_DATA2_t                     SDB_DATA2;                     /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  FETOP_FE_SDB_DATA1_t                     SDB_DATA1;                     /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  FETOP_FE_SDB_DATA0_t                     SDB_DATA0;                     /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  FETOP_FE_VLN_ACCESS_t                    VLN_ACCESS;                    /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  FETOP_FE_VLN_DATA1_t                     VLN_DATA1;                     /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  FETOP_FE_VLN_DATA0_t                     VLN_DATA0;                     /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  FETOP_FE_FWDRSLT_ACCESS_t                FWDRSLT_ACCESS;                /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  FETOP_FE_FWDRSLT_DATA3_t                 FWDRSLT_DATA3;                 /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd55[3];                   
  FETOP_FE_FWDRSLT_DATA2_t                 FWDRSLT_DATA2;                 /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd56[3];                   
  FETOP_FE_FWDRSLT_DATA1_t                 FWDRSLT_DATA1;                 /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd57[3];                   
  FETOP_FE_FWDRSLT_DATA0_t                 FWDRSLT_DATA0;                 /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd58[3];                   
  FETOP_FE_QOSRSLT_ACCESS_t                QOSRSLT_ACCESS;                /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd59[3];                   
  FETOP_FE_QOSRSLT_DATA1_t                 QOSRSLT_DATA1;                 /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd60[3];                   
  FETOP_FE_QOSRSLT_DATA0_t                 QOSRSLT_DATA0;                 /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd61[3];                   
  FETOP_FE_VOQPOL_ACCESS_t                 VOQPOL_ACCESS;                 /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd62[3];                   
  FETOP_FE_VOQPOL_DATA1_t                  VOQPOL_DATA1;                  /* addr: 0x000000f8 */ 
  cs_uint32                                rsrvd63[3];                   
  FETOP_FE_VOQPOL_DATA0_t                  VOQPOL_DATA0;                  /* addr: 0x000000fc */ 
  cs_uint32                                rsrvd64[3];                   
  FETOP_FE_FVLAN_ACCESS_t                  FVLAN_ACCESS;                  /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd65[3];                   
  FETOP_FE_FVLAN_DATA1_t                   FVLAN_DATA1;                   /* addr: 0x00000104 */ 
  cs_uint32                                rsrvd66[3];                   
  FETOP_FE_FVLAN_DATA0_t                   FVLAN_DATA0;                   /* addr: 0x00000108 */ 
  cs_uint32                                rsrvd67[3];                   
  FETOP_FE_L3TBL_ACCESS_t                  L3TBL_ACCESS;                  /* addr: 0x0000010c */ 
  cs_uint32                                rsrvd68[3];                   
  FETOP_FE_L3TBL_DATA4_t                   L3TBL_DATA4;                   /* addr: 0x00000110 */ 
  cs_uint32                                rsrvd69[3];                   
  FETOP_FE_L3TBL_DATA3_t                   L3TBL_DATA3;                   /* addr: 0x00000114 */ 
  cs_uint32                                rsrvd70[3];                   
  FETOP_FE_L3TBL_DATA2_t                   L3TBL_DATA2;                   /* addr: 0x00000118 */ 
  cs_uint32                                rsrvd71[3];                   
  FETOP_FE_L3TBL_DATA1_t                   L3TBL_DATA1;                   /* addr: 0x0000011c */ 
  cs_uint32                                rsrvd72[3];                   
  FETOP_FE_L3TBL_DATA0_t                   L3TBL_DATA0;                   /* addr: 0x00000120 */ 
  cs_uint32                                rsrvd73[3];                   
  FETOP_FE_L2TBL_ACCESS_t                  L2TBL_ACCESS;                  /* addr: 0x00000124 */ 
  cs_uint32                                rsrvd74[3];                   
  FETOP_FE_L2TBL_DATA3_t                   L2TBL_DATA3;                   /* addr: 0x00000128 */ 
  cs_uint32                                rsrvd75[3];                   
  FETOP_FE_L2TBL_DATA2_t                   L2TBL_DATA2;                   /* addr: 0x0000012c */ 
  cs_uint32                                rsrvd76[3];                   
  FETOP_FE_L2TBL_DATA1_t                   L2TBL_DATA1;                   /* addr: 0x00000130 */ 
  cs_uint32                                rsrvd77[3];                   
  FETOP_FE_L2TBL_DATA0_t                   L2TBL_DATA0;                   /* addr: 0x00000134 */ 
  cs_uint32                                rsrvd78[3];                   
  FETOP_FE_ACLRULE_ACCESS_t                ACLRULE_ACCESS;                /* addr: 0x00000138 */ 
  cs_uint32                                rsrvd79[3];                   
  FETOP_FE_ACLRULE_DATA27_t                ACLRULE_DATA27;                /* addr: 0x0000013c */ 
  cs_uint32                                rsrvd80[3];                   
  FETOP_FE_ACLRULE_DATA26_t                ACLRULE_DATA26;                /* addr: 0x00000140 */ 
  cs_uint32                                rsrvd81[3];                   
  FETOP_FE_ACLRULE_DATA25_t                ACLRULE_DATA25;                /* addr: 0x00000144 */ 
  cs_uint32                                rsrvd82[3];                   
  FETOP_FE_ACLRULE_DATA24_t                ACLRULE_DATA24;                /* addr: 0x00000148 */ 
  cs_uint32                                rsrvd83[3];                   
  FETOP_FE_ACLRULE_DATA23_t                ACLRULE_DATA23;                /* addr: 0x0000014c */ 
  cs_uint32                                rsrvd84[3];                   
  FETOP_FE_ACLRULE_DATA22_t                ACLRULE_DATA22;                /* addr: 0x00000150 */ 
  cs_uint32                                rsrvd85[3];                   
  FETOP_FE_ACLRULE_DATA21_t                ACLRULE_DATA21;                /* addr: 0x00000154 */ 
  cs_uint32                                rsrvd86[3];                   
  FETOP_FE_ACLRULE_DATA20_t                ACLRULE_DATA20;                /* addr: 0x00000158 */ 
  cs_uint32                                rsrvd87[3];                   
  FETOP_FE_ACLRULE_DATA19_t                ACLRULE_DATA19;                /* addr: 0x0000015c */ 
  cs_uint32                                rsrvd88[3];                   
  FETOP_FE_ACLRULE_DATA18_t                ACLRULE_DATA18;                /* addr: 0x00000160 */ 
  cs_uint32                                rsrvd89[3];                   
  FETOP_FE_ACLRULE_DATA17_t                ACLRULE_DATA17;                /* addr: 0x00000164 */ 
  cs_uint32                                rsrvd90[3];                   
  FETOP_FE_ACLRULE_DATA16_t                ACLRULE_DATA16;                /* addr: 0x00000168 */ 
  cs_uint32                                rsrvd91[3];                   
  FETOP_FE_ACLRULE_DATA15_t                ACLRULE_DATA15;                /* addr: 0x0000016c */ 
  cs_uint32                                rsrvd92[3];                   
  FETOP_FE_ACLRULE_DATA14_t                ACLRULE_DATA14;                /* addr: 0x00000170 */ 
  cs_uint32                                rsrvd93[3];                   
  FETOP_FE_ACLRULE_DATA13_t                ACLRULE_DATA13;                /* addr: 0x00000174 */ 
  cs_uint32                                rsrvd94[3];                   
  FETOP_FE_ACLRULE_DATA12_t                ACLRULE_DATA12;                /* addr: 0x00000178 */ 
  cs_uint32                                rsrvd95[3];                   
  FETOP_FE_ACLRULE_DATA11_t                ACLRULE_DATA11;                /* addr: 0x0000017c */ 
  cs_uint32                                rsrvd96[3];                   
  FETOP_FE_ACLRULE_DATA10_t                ACLRULE_DATA10;                /* addr: 0x00000180 */ 
  cs_uint32                                rsrvd97[3];                   
  FETOP_FE_ACLRULE_DATA9_t                 ACLRULE_DATA9;                 /* addr: 0x00000184 */ 
  cs_uint32                                rsrvd98[3];                   
  FETOP_FE_ACLRULE_DATA8_t                 ACLRULE_DATA8;                 /* addr: 0x00000188 */ 
  cs_uint32                                rsrvd99[3];                   
  FETOP_FE_ACLRULE_DATA7_t                 ACLRULE_DATA7;                 /* addr: 0x0000018c */ 
  cs_uint32                                rsrvd100[3];                  
  FETOP_FE_ACLRULE_DATA6_t                 ACLRULE_DATA6;                 /* addr: 0x00000190 */ 
  cs_uint32                                rsrvd101[3];                  
  FETOP_FE_ACLRULE_DATA5_t                 ACLRULE_DATA5;                 /* addr: 0x00000194 */ 
  cs_uint32                                rsrvd102[3];                  
  FETOP_FE_ACLRULE_DATA4_t                 ACLRULE_DATA4;                 /* addr: 0x00000198 */ 
  cs_uint32                                rsrvd103[3];                  
  FETOP_FE_ACLRULE_DATA3_t                 ACLRULE_DATA3;                 /* addr: 0x0000019c */ 
  cs_uint32                                rsrvd104[3];                  
  FETOP_FE_ACLRULE_DATA2_t                 ACLRULE_DATA2;                 /* addr: 0x000001a0 */ 
  cs_uint32                                rsrvd105[3];                  
  FETOP_FE_ACLRULE_DATA1_t                 ACLRULE_DATA1;                 /* addr: 0x000001a4 */ 
  cs_uint32                                rsrvd106[3];                  
  FETOP_FE_ACLRULE_DATA0_t                 ACLRULE_DATA0;                 /* addr: 0x000001a8 */ 
  cs_uint32                                rsrvd107[3];                  
  FETOP_FE_ACLACTION_ACCESS_t              ACLACTION_ACCESS;              /* addr: 0x000001ac */ 
  cs_uint32                                rsrvd108[3];                  
  FETOP_FE_ACLACTION_DATA9_t               ACLACTION_DATA9;               /* addr: 0x000001b0 */ 
  cs_uint32                                rsrvd109[3];                  
  FETOP_FE_ACLACTION_DATA8_t               ACLACTION_DATA8;               /* addr: 0x000001b4 */ 
  cs_uint32                                rsrvd110[3];                  
  FETOP_FE_ACLACTION_DATA7_t               ACLACTION_DATA7;               /* addr: 0x000001b8 */ 
  cs_uint32                                rsrvd111[3];                  
  FETOP_FE_ACLACTION_DATA6_t               ACLACTION_DATA6;               /* addr: 0x000001bc */ 
  cs_uint32                                rsrvd112[3];                  
  FETOP_FE_ACLACTION_DATA5_t               ACLACTION_DATA5;               /* addr: 0x000001c0 */ 
  cs_uint32                                rsrvd113[3];                  
  FETOP_FE_ACLACTION_DATA4_t               ACLACTION_DATA4;               /* addr: 0x000001c4 */ 
  cs_uint32                                rsrvd114[3];                  
  FETOP_FE_ACLACTION_DATA3_t               ACLACTION_DATA3;               /* addr: 0x000001c8 */ 
  cs_uint32                                rsrvd115[3];                  
  FETOP_FE_ACLACTION_DATA2_t               ACLACTION_DATA2;               /* addr: 0x000001cc */ 
  cs_uint32                                rsrvd116[3];                  
  FETOP_FE_ACLACTION_DATA1_t               ACLACTION_DATA1;               /* addr: 0x000001d0 */ 
  cs_uint32                                rsrvd117[3];                  
  FETOP_FE_ACLACTION_DATA0_t               ACLACTION_DATA0;               /* addr: 0x000001d4 */ 
  cs_uint32                                rsrvd118[3];                  
  FETOP_FE_INTERRUPT_0_t                   INTERRUPT_0;                   /* addr: 0x000001d8 */ 
  cs_uint32                                rsrvd119[3];                  
  FETOP_FE_INTENABLE_0_t                   INTENABLE_0;                   /* addr: 0x000001dc */ 
  cs_uint32                                rsrvd120[3];                  
  FETOP_FE_INTERRUPT_1_t                   INTERRUPT_1;                   /* addr: 0x000001e0 */ 
  cs_uint32                                rsrvd121[3];                  
  FETOP_FE_INTENABLE_1_t                   INTENABLE_1;                   /* addr: 0x000001e4 */ 
  cs_uint32                                rsrvd122[3];                  
  FETOP_FE_FWD_INTERRUPT_0_t               FWD_INTERRUPT_0;               /* addr: 0x000001e8 */ 
  cs_uint32                                rsrvd123[3];                  
  FETOP_FE_FWD_INTENABLE_0_t               FWD_INTENABLE_0;               /* addr: 0x000001ec */ 
  cs_uint32                                rsrvd124[3];                  
  FETOP_FE_FWD_INTERRUPT_1_t               FWD_INTERRUPT_1;               /* addr: 0x000001f0 */ 
  cs_uint32                                rsrvd125[3];                  
  FETOP_FE_FWD_INTENABLE_1_t               FWD_INTENABLE_1;               /* addr: 0x000001f4 */ 
  cs_uint32                                rsrvd126[3];                  
  FETOP_FE_DBG_INTERRUPT_0_t               DBG_INTERRUPT_0;               /* addr: 0x000001f8 */ 
  cs_uint32                                rsrvd127[3];                  
  FETOP_FE_DBG_INTENABLE_0_t               DBG_INTENABLE_0;               /* addr: 0x000001fc */ 
  cs_uint32                                rsrvd128[3];                  
  FETOP_FE_DBG_INTERRUPT_1_t               DBG_INTERRUPT_1;               /* addr: 0x00000200 */ 
  cs_uint32                                rsrvd129[3];                  
  FETOP_FE_DBG_INTENABLE_1_t               DBG_INTENABLE_1;               /* addr: 0x00000204 */ 
  cs_uint32                                rsrvd130[3];                  
  FETOP_FE_PE_INTERRUPT_0_t                PE_INTERRUPT_0;                /* addr: 0x00000208 */ 
  cs_uint32                                rsrvd131[3];                  
  FETOP_FE_PE_INTENABLE_0_t                PE_INTENABLE_0;                /* addr: 0x0000020c */ 
  cs_uint32                                rsrvd132[3];                  
  FETOP_FE_PE_INTERRUPT_1_t                PE_INTERRUPT_1;                /* addr: 0x00000210 */ 
  cs_uint32                                rsrvd133[3];                  
  FETOP_FE_PE_INTENABLE_1_t                PE_INTENABLE_1;                /* addr: 0x00000214 */ 
  cs_uint32                                rsrvd134[3];                  
  FETOP_FE_DBG_FE_PP_t                     DBG_FE_PP;                     /* addr: 0x00000218 */ 
  cs_uint32                                rsrvd135[3];                  
  FETOP_FE_DBG_FE_PP_CNTR_t                DBG_FE_PP_CNTR;                /* addr: 0x0000021c */ 
  cs_uint32                                rsrvd136[3];                  
  FETOP_FE_PE_CONFIG_t                     PE_CONFIG;                     /* addr: 0x00000220 */ 
  cs_uint32                                rsrvd137[3];                  
  FETOP_FE_PE_CONFIG_1_t                   PE_CONFIG_1;                   /* addr: 0x00000224 */ 
  cs_uint32                                rsrvd138[3];                  
  FETOP_FE_PE_PPPOE_CFG_0_t                PE_PPPOE_CFG_0;                /* addr: 0x00000228 */ 
  cs_uint32                                rsrvd139[3];                  
  FETOP_FE_PE_PPPOE_CFG_1_t                PE_PPPOE_CFG_1;                /* addr: 0x0000022c */ 
  cs_uint32                                rsrvd140[3];                  
  FETOP_FE_PE_PPPOE_CFG_2_t                PE_PPPOE_CFG_2;                /* addr: 0x00000230 */ 
  cs_uint32                                rsrvd141[3];                  
  FETOP_FE_PE_PPPOE_CFG_3_t                PE_PPPOE_CFG_3;                /* addr: 0x00000234 */ 
  cs_uint32                                rsrvd142[3];                  
  FETOP_FE_PROC_DROP_STS_t                 PROC_DROP_STS;                 /* addr: 0x00000238 */ 
  cs_uint32                                rsrvd143[3];                  
  FETOP_FE_PE_VOQ_DRP_ACCESS_t             PE_VOQ_DRP_ACCESS;             /* addr: 0x0000023c */ 
  cs_uint32                                rsrvd144[3];                  
  FETOP_FE_PE_VOQ_DRP_DATA_t               PE_VOQ_DRP_DATA;               /* addr: 0x00000240 */ 
  cs_uint32                                rsrvd145[3];                  
  FETOP_FE_PE_PKT_CNT_t                    PE_PKT_CNT;                    /* addr: 0x00000244 */ 
  cs_uint32                                rsrvd146[3];                  
  FETOP_FE_PE_HDRA_PKT_DROPCNT_t           PE_HDRA_PKT_DROPCNT;           /* addr: 0x00000248 */ 
  cs_uint32                                rsrvd147[3];                  
  FETOP_FE_PE_FE_PKT_DROPCNT_t             PE_FE_PKT_DROPCNT;             /* addr: 0x0000024c */ 
  cs_uint32                                rsrvd148[3];                  
  FETOP_FE_PE_DEBUG_t                      PE_DEBUG;                      /* addr: 0x00000250 */ 
  cs_uint32                                rsrvd149[3];                  
  FETOP_FE_DBG_CLASS_MON_CMD_t             DBG_CLASS_MON_CMD;             /* addr: 0x00000254 */ 
  cs_uint32                                rsrvd150[3];                  
  FETOP_FE_DBG_CLASS_MON_STS_t             DBG_CLASS_MON_STS;             /* addr: 0x00000258 */ 
  cs_uint32                                rsrvd151[3];                  
  FETOP_FE_MEM_CLASS_PRTCHKFAIL_STS_t      MEM_CLASS_PRTCHKFAIL_STS;      /* addr: 0x0000025c */ 
  cs_uint32                                rsrvd152[3];                  
  FETOP_FE_MEM_ACLRULE_PRTCHKFAIL_STS_t    MEM_ACLRULE_PRTCHKFAIL_STS;    /* addr: 0x00000260 */ 
  cs_uint32                                rsrvd153[3];                  
  FETOP_FE_MEM_ACLACTION_PRTCHKFAIL_STS_t  MEM_ACLACTION_PRTCHKFAIL_STS;  /* addr: 0x00000264 */ 
  cs_uint32                                rsrvd154[3];                  
  FETOP_FE_MEM_FWDRSLT_PRTCHKFAIL_STS_t    MEM_FWDRSLT_PRTCHKFAIL_STS;    /* addr: 0x00000268 */ 
  cs_uint32                                rsrvd155[3];                  
  FETOP_FE_MEM_QOSRSLT_PRTCHKFAIL_STS_t    MEM_QOSRSLT_PRTCHKFAIL_STS;    /* addr: 0x0000026c */ 
  cs_uint32                                rsrvd156[3];                  
  FETOP_FE_MEM_L2TBL_PRTCHKFAIL_STS_t      MEM_L2TBL_PRTCHKFAIL_STS;      /* addr: 0x00000270 */ 
  cs_uint32                                rsrvd157[3];                  
  FETOP_FE_MEM_L3TBL_PRTCHKFAIL_STS_t      MEM_L3TBL_PRTCHKFAIL_STS;      /* addr: 0x00000274 */ 
  cs_uint32                                rsrvd158[3];                  
  FETOP_FE_MEM_FLOWVLN_PRTCHKFAIL_STS_t    MEM_FLOWVLN_PRTCHKFAIL_STS;    /* addr: 0x00000278 */ 
  cs_uint32                                rsrvd159[3];                  
  FETOP_FE_MEM_VOQPOL_PRTCHKFAIL_STS_t     MEM_VOQPOL_PRTCHKFAIL_STS;     /* addr: 0x0000027c */ 
  cs_uint32                                rsrvd160[3];                  
  FETOP_FE_MEM_VLNTBL_PRTCHKFAIL_STS_t     MEM_VLNTBL_PRTCHKFAIL_STS;     /* addr: 0x00000280 */ 
  cs_uint32                                rsrvd161[3];                  
  FETOP_FE_MEM_SDB_PRTCHKFAIL_STS_t        MEM_SDB_PRTCHKFAIL_STS;        /* addr: 0x00000284 */ 
  cs_uint32                                rsrvd162[3];                  
  FETOP_FE_PKTLEN_RNGS_ACCESS_t            PKTLEN_RNGS_ACCESS;            /* addr: 0x00000288 */ 
  cs_uint32                                rsrvd163[3];                  
  FETOP_FE_PKTLEN_RNGS_DATA_t              PKTLEN_RNGS_DATA;              /* addr: 0x0000028c */ 
} FETOP_FE_t;

  

/*
 * LPM
 */
  



#define FETOP_LPM_INTERRUPT_0                    0xf0021000
#define FETOP_LPM_INTERRUPT_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 hc1_full_roll_int    :  1 ; /* bits 11:11 */
    cs_uint32 hc1_half_roll_int    :  1 ; /* bits 10:10 */
    cs_uint32 hc0_full_roll_int    :  1 ; /* bits 9:9 */
    cs_uint32 hc0_half_roll_int    :  1 ; /* bits 8:8 */
    cs_uint32 hc_table1_lower_par_err_int :  1 ; /* bits 7:7 */
    cs_uint32 hc_table1_upper_par_err_int :  1 ; /* bits 6:6 */
    cs_uint32 hc_table0_lower_par_err_int :  1 ; /* bits 5:5 */
    cs_uint32 hc_table0_upper_par_err_int :  1 ; /* bits 4:4 */
    cs_uint32 lpm_table1_lower_par_err_int :  1 ; /* bits 3:3 */
    cs_uint32 lpm_table1_upper_par_err_int :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table0_lower_par_err_int :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table0_upper_par_err_int :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_upper_par_err_int :  1 ; /* bits 0:0 */
    cs_uint32 lpm_table0_lower_par_err_int :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table1_upper_par_err_int :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table1_lower_par_err_int :  1 ; /* bits 3:3 */
    cs_uint32 hc_table0_upper_par_err_int :  1 ; /* bits 4:4 */
    cs_uint32 hc_table0_lower_par_err_int :  1 ; /* bits 5:5 */
    cs_uint32 hc_table1_upper_par_err_int :  1 ; /* bits 6:6 */
    cs_uint32 hc_table1_lower_par_err_int :  1 ; /* bits 7:7 */
    cs_uint32 hc0_half_roll_int    :  1 ; /* bits 8:8 */
    cs_uint32 hc0_full_roll_int    :  1 ; /* bits 9:9 */
    cs_uint32 hc1_half_roll_int    :  1 ; /* bits 10:10 */
    cs_uint32 hc1_full_roll_int    :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_INTERRUPT_0_t;





#define FETOP_LPM_INTENABLE_0                    0xf0021004
#define FETOP_LPM_INTENABLE_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 hc1_full_roll_int_en :  1 ; /* bits 11:11 */
    cs_uint32 hc1_half_roll_int_en :  1 ; /* bits 10:10 */
    cs_uint32 hc0_full_roll_int_en :  1 ; /* bits 9:9 */
    cs_uint32 hc0_half_roll_int_en :  1 ; /* bits 8:8 */
    cs_uint32 hc_table1_lower_par_err_int_en :  1 ; /* bits 7:7 */
    cs_uint32 hc_table1_upper_par_err_int_en :  1 ; /* bits 6:6 */
    cs_uint32 hc_table0_lower_par_err_int_en :  1 ; /* bits 5:5 */
    cs_uint32 hc_table0_upper_par_err_int_en :  1 ; /* bits 4:4 */
    cs_uint32 lpm_table1_lower_par_err_int_en :  1 ; /* bits 3:3 */
    cs_uint32 lpm_table1_upper_par_err_int_en :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table0_lower_par_err_int_en :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table0_upper_par_err_int_en :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_upper_par_err_int_en :  1 ; /* bits 0:0 */
    cs_uint32 lpm_table0_lower_par_err_int_en :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table1_upper_par_err_int_en :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table1_lower_par_err_int_en :  1 ; /* bits 3:3 */
    cs_uint32 hc_table0_upper_par_err_int_en :  1 ; /* bits 4:4 */
    cs_uint32 hc_table0_lower_par_err_int_en :  1 ; /* bits 5:5 */
    cs_uint32 hc_table1_upper_par_err_int_en :  1 ; /* bits 6:6 */
    cs_uint32 hc_table1_lower_par_err_int_en :  1 ; /* bits 7:7 */
    cs_uint32 hc0_half_roll_int_en :  1 ; /* bits 8:8 */
    cs_uint32 hc0_full_roll_int_en :  1 ; /* bits 9:9 */
    cs_uint32 hc1_half_roll_int_en :  1 ; /* bits 10:10 */
    cs_uint32 hc1_full_roll_int_en :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_INTENABLE_0_t;





#define FETOP_LPM_INTERRUPT_1                    0xf0021008
#define FETOP_LPM_INTERRUPT_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 hc1_full_roll_int    :  1 ; /* bits 11:11 */
    cs_uint32 hc1_half_roll_int    :  1 ; /* bits 10:10 */
    cs_uint32 hc0_full_roll_int    :  1 ; /* bits 9:9 */
    cs_uint32 hc0_half_roll_int    :  1 ; /* bits 8:8 */
    cs_uint32 hc_table1_lower_par_err_int :  1 ; /* bits 7:7 */
    cs_uint32 hc_table1_upper_par_err_int :  1 ; /* bits 6:6 */
    cs_uint32 hc_table0_lower_par_err_int :  1 ; /* bits 5:5 */
    cs_uint32 hc_table0_upper_par_err_int :  1 ; /* bits 4:4 */
    cs_uint32 lpm_table1_lower_par_err_int :  1 ; /* bits 3:3 */
    cs_uint32 lpm_table1_upper_par_err_int :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table0_lower_par_err_int :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table0_upper_par_err_int :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_upper_par_err_int :  1 ; /* bits 0:0 */
    cs_uint32 lpm_table0_lower_par_err_int :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table1_upper_par_err_int :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table1_lower_par_err_int :  1 ; /* bits 3:3 */
    cs_uint32 hc_table0_upper_par_err_int :  1 ; /* bits 4:4 */
    cs_uint32 hc_table0_lower_par_err_int :  1 ; /* bits 5:5 */
    cs_uint32 hc_table1_upper_par_err_int :  1 ; /* bits 6:6 */
    cs_uint32 hc_table1_lower_par_err_int :  1 ; /* bits 7:7 */
    cs_uint32 hc0_half_roll_int    :  1 ; /* bits 8:8 */
    cs_uint32 hc0_full_roll_int    :  1 ; /* bits 9:9 */
    cs_uint32 hc1_half_roll_int    :  1 ; /* bits 10:10 */
    cs_uint32 hc1_full_roll_int    :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_INTERRUPT_1_t;





#define FETOP_LPM_INTENABLE_1                    0xf002100c
#define FETOP_LPM_INTENABLE_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 hc1_full_roll_int_en :  1 ; /* bits 11:11 */
    cs_uint32 hc1_half_roll_int_en :  1 ; /* bits 10:10 */
    cs_uint32 hc0_full_roll_int_en :  1 ; /* bits 9:9 */
    cs_uint32 hc0_half_roll_int_en :  1 ; /* bits 8:8 */
    cs_uint32 hc_table1_lower_par_err_int_en :  1 ; /* bits 7:7 */
    cs_uint32 hc_table1_upper_par_err_int_en :  1 ; /* bits 6:6 */
    cs_uint32 hc_table0_lower_par_err_int_en :  1 ; /* bits 5:5 */
    cs_uint32 hc_table0_upper_par_err_int_en :  1 ; /* bits 4:4 */
    cs_uint32 lpm_table1_lower_par_err_int_en :  1 ; /* bits 3:3 */
    cs_uint32 lpm_table1_upper_par_err_int_en :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table0_lower_par_err_int_en :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table0_upper_par_err_int_en :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_upper_par_err_int_en :  1 ; /* bits 0:0 */
    cs_uint32 lpm_table0_lower_par_err_int_en :  1 ; /* bits 1:1 */
    cs_uint32 lpm_table1_upper_par_err_int_en :  1 ; /* bits 2:2 */
    cs_uint32 lpm_table1_lower_par_err_int_en :  1 ; /* bits 3:3 */
    cs_uint32 hc_table0_upper_par_err_int_en :  1 ; /* bits 4:4 */
    cs_uint32 hc_table0_lower_par_err_int_en :  1 ; /* bits 5:5 */
    cs_uint32 hc_table1_upper_par_err_int_en :  1 ; /* bits 6:6 */
    cs_uint32 hc_table1_lower_par_err_int_en :  1 ; /* bits 7:7 */
    cs_uint32 hc0_half_roll_int_en :  1 ; /* bits 8:8 */
    cs_uint32 hc0_full_roll_int_en :  1 ; /* bits 9:9 */
    cs_uint32 hc1_half_roll_int_en :  1 ; /* bits 10:10 */
    cs_uint32 hc1_full_roll_int_en :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_INTENABLE_1_t;





#define FETOP_LPM_LPM_CONFIG                     0xf0021010
#define FETOP_LPM_LPM_CONFIG_dft                 0x00000008




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 col_msk_sel          :  3 ; /* bits 6:4 */
    cs_uint32 sdb_en               :  1 ; /* bits 3:3 */
    cs_uint32 clr_read             :  1 ; /* bits 2:2 */
    cs_uint32 active_table         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 active_table         :  2 ; /* bits 1:0 */
    cs_uint32 clr_read             :  1 ; /* bits 2:2 */
    cs_uint32 sdb_en               :  1 ; /* bits 3:3 */
    cs_uint32 col_msk_sel          :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_CONFIG_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_PARITY   0xf0021014
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 lpm_table0_upper_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_upper_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_PARITY_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_PARITY   0xf0021018
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 lpm_table0_lower_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table0_lower_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_PARITY_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_PARITY   0xf002101c
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 lpm_table1_upper_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table1_upper_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_PARITY_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_PARITY   0xf0021020
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 lpm_table1_lower_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_table1_lower_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_PARITY_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_PARITY    0xf0021024
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 hc_table0_upper_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hc_table0_upper_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_PARITY_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_PARITY    0xf0021028
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 hc_table0_lower_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hc_table0_lower_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_PARITY_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_PARITY    0xf002102c
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 hc_table1_upper_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hc_table1_upper_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_PARITY_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_PARITY    0xf0021030
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_PARITY_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 hc_table1_lower_regf_parity :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hc_table1_lower_regf_parity :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_PARITY_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS   0xf0021034
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA8    0xf0021038
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA8_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 up_ip03              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip03              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA8_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA7    0xf002103c
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA7_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip03              : 28 ; /* bits 31:4 */
    cs_uint32 up_mask03            :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_mask03            :  4 ; /* bits 3:0 */
    cs_uint32 up_ip03              : 28 ; /* bits 31:4 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA7_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA6    0xf0021040
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA6_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_mask03            :  2 ; /* bits 31:30 */
    cs_uint32 up_ip02              : 30 ; /* bits 29:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip02              : 30 ; /* bits 29:0 */
    cs_uint32 up_mask03            :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA6_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5    0xf0021044
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip02              :  2 ; /* bits 31:30 */
    cs_uint32 up_mask02            :  6 ; /* bits 29:24 */
    cs_uint32 up_ip01              : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip01              : 24 ; /* bits 23:0 */
    cs_uint32 up_mask02            :  6 ; /* bits 29:24 */
    cs_uint32 up_ip02              :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4    0xf0021048
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip01              :  8 ; /* bits 31:24 */
    cs_uint32 up_mask01            :  6 ; /* bits 23:18 */
    cs_uint32 up_ip00              : 18 ; /* bits 17:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip00              : 18 ; /* bits 17:0 */
    cs_uint32 up_mask01            :  6 ; /* bits 23:18 */
    cs_uint32 up_ip01              :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3    0xf002104c
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip00              : 14 ; /* bits 31:18 */
    cs_uint32 up_mask00            :  6 ; /* bits 17:12 */
    cs_uint32 up_nh03              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh03              : 12 ; /* bits 11:0 */
    cs_uint32 up_mask00            :  6 ; /* bits 17:12 */
    cs_uint32 up_ip00              : 14 ; /* bits 31:18 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA2    0xf0021050
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh03              : 15 ; /* bits 31:17 */
    cs_uint32 up_nh02              : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh02              : 17 ; /* bits 16:0 */
    cs_uint32 up_nh03              : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA2_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA1    0xf0021054
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh02              : 10 ; /* bits 31:22 */
    cs_uint32 up_nh01              : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh01              : 22 ; /* bits 21:0 */
    cs_uint32 up_nh02              : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA1_t;





#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0    0xf0021058
#define FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh01              :  5 ; /* bits 31:27 */
    cs_uint32 up_nh00              : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh00              : 27 ; /* bits 26:0 */
    cs_uint32 up_nh01              :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_ACCESS    0xf002105c
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_ACCESS_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA3     0xf0021060
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 up_hit_cnt03         : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt03         : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA3_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA2     0xf0021064
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt03         : 15 ; /* bits 31:17 */
    cs_uint32 up_hit_cnt02         : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt02         : 17 ; /* bits 16:0 */
    cs_uint32 up_hit_cnt03         : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA2_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA1     0xf0021068
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt02         : 10 ; /* bits 31:22 */
    cs_uint32 up_hit_cnt01         : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt01         : 22 ; /* bits 21:0 */
    cs_uint32 up_hit_cnt02         : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA1_t;





#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0     0xf002106c
#define FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt01         :  5 ; /* bits 31:27 */
    cs_uint32 up_hit_cnt00         : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt00         : 27 ; /* bits 26:0 */
    cs_uint32 up_hit_cnt01         :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS   0xf0021070
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA8    0xf0021074
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA8_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 lo_ip03              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip03              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA8_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA7    0xf0021078
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA7_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip03              : 28 ; /* bits 31:4 */
    cs_uint32 lo_mask03            :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_mask03            :  4 ; /* bits 3:0 */
    cs_uint32 lo_ip03              : 28 ; /* bits 31:4 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA7_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA6    0xf002107c
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA6_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_mask03            :  2 ; /* bits 31:30 */
    cs_uint32 lo_ip02              : 30 ; /* bits 29:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip02              : 30 ; /* bits 29:0 */
    cs_uint32 lo_mask03            :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA6_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5    0xf0021080
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip02              :  2 ; /* bits 31:30 */
    cs_uint32 lo_mask02            :  6 ; /* bits 29:24 */
    cs_uint32 lo_ip01              : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip01              : 24 ; /* bits 23:0 */
    cs_uint32 lo_mask02            :  6 ; /* bits 29:24 */
    cs_uint32 lo_ip02              :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4    0xf0021084
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip01              :  8 ; /* bits 31:24 */
    cs_uint32 lo_mask01            :  6 ; /* bits 23:18 */
    cs_uint32 lo_ip00              : 18 ; /* bits 17:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip00              : 18 ; /* bits 17:0 */
    cs_uint32 lo_mask01            :  6 ; /* bits 23:18 */
    cs_uint32 lo_ip01              :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3    0xf0021088
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip00              : 14 ; /* bits 31:18 */
    cs_uint32 lo_mask00            :  6 ; /* bits 17:12 */
    cs_uint32 lo_nh03              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh03              : 12 ; /* bits 11:0 */
    cs_uint32 lo_mask00            :  6 ; /* bits 17:12 */
    cs_uint32 lo_ip00              : 14 ; /* bits 31:18 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA2    0xf002108c
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh03              : 15 ; /* bits 31:17 */
    cs_uint32 lo_nh02              : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh02              : 17 ; /* bits 16:0 */
    cs_uint32 lo_nh03              : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA2_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA1    0xf0021090
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh02              : 10 ; /* bits 31:22 */
    cs_uint32 lo_nh01              : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh01              : 22 ; /* bits 21:0 */
    cs_uint32 lo_nh02              : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA1_t;





#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0    0xf0021094
#define FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh01              :  5 ; /* bits 31:27 */
    cs_uint32 lo_nh00              : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh00              : 27 ; /* bits 26:0 */
    cs_uint32 lo_nh01              :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_ACCESS    0xf0021098
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_ACCESS_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA3     0xf002109c
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 lo_hit_cnt03         : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt03         : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA3_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA2     0xf00210a0
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt03         : 15 ; /* bits 31:17 */
    cs_uint32 lo_hit_cnt02         : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt02         : 17 ; /* bits 16:0 */
    cs_uint32 lo_hit_cnt03         : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA2_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA1     0xf00210a4
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt02         : 10 ; /* bits 31:22 */
    cs_uint32 lo_hit_cnt01         : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt01         : 22 ; /* bits 21:0 */
    cs_uint32 lo_hit_cnt02         : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA1_t;





#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0     0xf00210a8
#define FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt01         :  5 ; /* bits 31:27 */
    cs_uint32 lo_hit_cnt00         : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt00         : 27 ; /* bits 26:0 */
    cs_uint32 lo_hit_cnt01         :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS   0xf00210ac
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA8    0xf00210b0
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA8_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 up_ip13              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip13              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA8_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA7    0xf00210b4
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA7_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip13              : 28 ; /* bits 31:4 */
    cs_uint32 up_mask13            :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_mask13            :  4 ; /* bits 3:0 */
    cs_uint32 up_ip13              : 28 ; /* bits 31:4 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA7_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA6    0xf00210b8
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA6_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_mask13            :  2 ; /* bits 31:30 */
    cs_uint32 up_ip12              : 30 ; /* bits 29:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip12              : 30 ; /* bits 29:0 */
    cs_uint32 up_mask13            :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA6_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5    0xf00210bc
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip12              :  2 ; /* bits 31:30 */
    cs_uint32 up_mask12            :  6 ; /* bits 29:24 */
    cs_uint32 up_ip11              : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip11              : 24 ; /* bits 23:0 */
    cs_uint32 up_mask12            :  6 ; /* bits 29:24 */
    cs_uint32 up_ip12              :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4    0xf00210c0
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip11              :  8 ; /* bits 31:24 */
    cs_uint32 up_mask11            :  6 ; /* bits 23:18 */
    cs_uint32 up_ip10              : 18 ; /* bits 17:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_ip10              : 18 ; /* bits 17:0 */
    cs_uint32 up_mask11            :  6 ; /* bits 23:18 */
    cs_uint32 up_ip11              :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3    0xf00210c4
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_ip10              : 14 ; /* bits 31:18 */
    cs_uint32 up_mask10            :  6 ; /* bits 17:12 */
    cs_uint32 up_nh13              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh13              : 12 ; /* bits 11:0 */
    cs_uint32 up_mask10            :  6 ; /* bits 17:12 */
    cs_uint32 up_ip10              : 14 ; /* bits 31:18 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA2    0xf00210c8
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh13              : 15 ; /* bits 31:17 */
    cs_uint32 up_nh12              : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh12              : 17 ; /* bits 16:0 */
    cs_uint32 up_nh13              : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA2_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA1    0xf00210cc
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh12              : 10 ; /* bits 31:22 */
    cs_uint32 up_nh11              : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh11              : 22 ; /* bits 21:0 */
    cs_uint32 up_nh12              : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA1_t;





#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0    0xf00210d0
#define FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_nh11              :  5 ; /* bits 31:27 */
    cs_uint32 up_nh10              : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_nh10              : 27 ; /* bits 26:0 */
    cs_uint32 up_nh11              :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_ACCESS    0xf00210d4
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_ACCESS_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA3     0xf00210d8
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 up_hit_cnt13         : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt13         : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA3_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA2     0xf00210dc
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt13         : 15 ; /* bits 31:17 */
    cs_uint32 up_hit_cnt12         : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt12         : 17 ; /* bits 16:0 */
    cs_uint32 up_hit_cnt13         : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA2_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA1     0xf00210e0
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt12         : 10 ; /* bits 31:22 */
    cs_uint32 up_hit_cnt11         : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt11         : 22 ; /* bits 21:0 */
    cs_uint32 up_hit_cnt12         : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA1_t;





#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0     0xf00210e4
#define FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 up_hit_cnt11         :  5 ; /* bits 31:27 */
    cs_uint32 up_hit_cnt10         : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 up_hit_cnt10         : 27 ; /* bits 26:0 */
    cs_uint32 up_hit_cnt11         :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS   0xf00210e8
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA8    0xf00210ec
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA8_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 lo_ip13              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip13              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA8_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA7    0xf00210f0
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA7_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip13              : 28 ; /* bits 31:4 */
    cs_uint32 lo_mask13            :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_mask13            :  4 ; /* bits 3:0 */
    cs_uint32 lo_ip13              : 28 ; /* bits 31:4 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA7_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA6    0xf00210f4
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA6_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_mask13            :  2 ; /* bits 31:30 */
    cs_uint32 lo_ip12              : 30 ; /* bits 29:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip12              : 30 ; /* bits 29:0 */
    cs_uint32 lo_mask13            :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA6_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5    0xf00210f8
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip12              :  2 ; /* bits 31:30 */
    cs_uint32 lo_mask12            :  6 ; /* bits 29:24 */
    cs_uint32 lo_ip11              : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip11              : 24 ; /* bits 23:0 */
    cs_uint32 lo_mask12            :  6 ; /* bits 29:24 */
    cs_uint32 lo_ip12              :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4    0xf00210fc
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip11              :  8 ; /* bits 31:24 */
    cs_uint32 lo_mask11            :  6 ; /* bits 23:18 */
    cs_uint32 lo_ip10              : 18 ; /* bits 17:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_ip10              : 18 ; /* bits 17:0 */
    cs_uint32 lo_mask11            :  6 ; /* bits 23:18 */
    cs_uint32 lo_ip11              :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3    0xf0021100
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_ip10              : 14 ; /* bits 31:18 */
    cs_uint32 lo_mask10            :  6 ; /* bits 17:12 */
    cs_uint32 lo_nh13              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh13              : 12 ; /* bits 11:0 */
    cs_uint32 lo_mask10            :  6 ; /* bits 17:12 */
    cs_uint32 lo_ip10              : 14 ; /* bits 31:18 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA2    0xf0021104
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh13              : 15 ; /* bits 31:17 */
    cs_uint32 lo_nh12              : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh12              : 17 ; /* bits 16:0 */
    cs_uint32 lo_nh13              : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA2_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA1    0xf0021108
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh12              : 10 ; /* bits 31:22 */
    cs_uint32 lo_nh11              : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh11              : 22 ; /* bits 21:0 */
    cs_uint32 lo_nh12              : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA1_t;





#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0    0xf002110c
#define FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_nh11              :  5 ; /* bits 31:27 */
    cs_uint32 lo_nh10              : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_nh10              : 27 ; /* bits 26:0 */
    cs_uint32 lo_nh11              :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_ACCESS    0xf0021110
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 parity_bypass        :  1 ; /* bits 29:29 */
    cs_uint32 w_rdn                :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_ACCESS_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA3     0xf0021114
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA3_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 lo_hit_cnt13         : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt13         : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA3_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA2     0xf0021118
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA2_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt13         : 15 ; /* bits 31:17 */
    cs_uint32 lo_hit_cnt12         : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt12         : 17 ; /* bits 16:0 */
    cs_uint32 lo_hit_cnt13         : 15 ; /* bits 31:17 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA2_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA1     0xf002111c
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA1_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt12         : 10 ; /* bits 31:22 */
    cs_uint32 lo_hit_cnt11         : 22 ; /* bits 21:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt11         : 22 ; /* bits 21:0 */
    cs_uint32 lo_hit_cnt12         : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA1_t;





#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0     0xf0021120
#define FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lo_hit_cnt11         :  5 ; /* bits 31:27 */
    cs_uint32 lo_hit_cnt10         : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lo_hit_cnt10         : 27 ; /* bits 26:0 */
    cs_uint32 lo_hit_cnt11         :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0_t;





#define FETOP_LPM_IPV4_START_PTR0                0xf0021124
#define FETOP_LPM_IPV4_START_PTR0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 ipv4_start_ptr0      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_start_ptr0      :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_START_PTR0_t;





#define FETOP_LPM_IPV4_START_PTR1                0xf0021128
#define FETOP_LPM_IPV4_START_PTR1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 ipv4_start_ptr1      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_start_ptr1      :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_START_PTR1_t;





#define FETOP_LPM_IPV6_START_PTR0                0xf002112c
#define FETOP_LPM_IPV6_START_PTR0_dft            0x0000000f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 ipv6_start_ptr0      :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_start_ptr0      :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_START_PTR0_t;





#define FETOP_LPM_IPV6_START_PTR1                0xf0021130
#define FETOP_LPM_IPV6_START_PTR1_dft            0x0000000f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 ipv6_start_ptr1      :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_start_ptr1      :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_START_PTR1_t;





#define FETOP_LPM_IPV4_END_PTR0                  0xf0021134
#define FETOP_LPM_IPV4_END_PTR0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 ipv4_end_ptr0        :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_end_ptr0        :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_END_PTR0_t;





#define FETOP_LPM_IPV4_END_PTR1                  0xf0021138
#define FETOP_LPM_IPV4_END_PTR1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 ipv4_end_ptr1        :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_end_ptr1        :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_END_PTR1_t;





#define FETOP_LPM_IPV6_END_PTR0                  0xf002113c
#define FETOP_LPM_IPV6_END_PTR0_dft              0x0000000f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 ipv6_end_ptr0        :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_end_ptr0        :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_END_PTR0_t;





#define FETOP_LPM_IPV6_END_PTR1                  0xf0021140
#define FETOP_LPM_IPV6_END_PTR1_dft              0x0000000f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 ipv6_end_ptr1        :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_end_ptr1        :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_END_PTR1_t;





#define FETOP_LPM_INACTIVE_DROP_COUNT            0xf0021144
#define FETOP_LPM_INACTIVE_DROP_COUNT_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 inactive_drop_count  : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 inactive_drop_count  : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_INACTIVE_DROP_COUNT_t;





#define FETOP_LPM_IPV4_MISS_COUNT0               0xf0021148
#define FETOP_LPM_IPV4_MISS_COUNT0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv4_miss_count0     : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_miss_count0     : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_MISS_COUNT0_t;





#define FETOP_LPM_IPV4_MISS_COUNT1               0xf002114c
#define FETOP_LPM_IPV4_MISS_COUNT1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv4_miss_count1     : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv4_miss_count1     : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV4_MISS_COUNT1_t;





#define FETOP_LPM_IPV6_MISS_COUNT0               0xf0021150
#define FETOP_LPM_IPV6_MISS_COUNT0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv6_miss_count0     : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_miss_count0     : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_MISS_COUNT0_t;





#define FETOP_LPM_IPV6_MISS_COUNT1               0xf0021154
#define FETOP_LPM_IPV6_MISS_COUNT1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ipv6_miss_count1     : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipv6_miss_count1     : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_IPV6_MISS_COUNT1_t;





#define FETOP_LPM_LPM_STATUS                     0xf0021158
#define FETOP_LPM_LPM_STATUS_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 lpm_status           :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm_status           :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_LPM_STATUS_t;





#define FETOP_LPM_MEM_INIT                       0xf002115c
#define FETOP_LPM_MEM_INIT_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 hc1_upper_start_init :  1 ; /* bits 7:7 */
    cs_uint32 hc0_upper_start_init :  1 ; /* bits 6:6 */
    cs_uint32 hc1_lower_start_init :  1 ; /* bits 5:5 */
    cs_uint32 hc0_lower_start_init :  1 ; /* bits 4:4 */
    cs_uint32 lpm1_lower_start_init :  1 ; /* bits 3:3 */
    cs_uint32 lpm1_upper_start_init :  1 ; /* bits 2:2 */
    cs_uint32 lpm0_upper_start_init :  1 ; /* bits 1:1 */
    cs_uint32 lpm0_lower_start_init :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm0_lower_start_init :  1 ; /* bits 0:0 */
    cs_uint32 lpm0_upper_start_init :  1 ; /* bits 1:1 */
    cs_uint32 lpm1_upper_start_init :  1 ; /* bits 2:2 */
    cs_uint32 lpm1_lower_start_init :  1 ; /* bits 3:3 */
    cs_uint32 hc0_lower_start_init :  1 ; /* bits 4:4 */
    cs_uint32 hc1_lower_start_init :  1 ; /* bits 5:5 */
    cs_uint32 hc0_upper_start_init :  1 ; /* bits 6:6 */
    cs_uint32 hc1_upper_start_init :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_MEM_INIT_t;





#define FETOP_LPM_MEM_STATUS                     0xf0021160
#define FETOP_LPM_MEM_STATUS_dft                 0x000000ff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 hc1_upper_init_in_progress :  1 ; /* bits 15:15 */
    cs_uint32 hc0_upper_init_in_progress :  1 ; /* bits 14:14 */
    cs_uint32 hc1_lower_init_in_progress :  1 ; /* bits 13:13 */
    cs_uint32 hc0_lower_init_in_progress :  1 ; /* bits 12:12 */
    cs_uint32 lpm1_lower_init_in_progress :  1 ; /* bits 11:11 */
    cs_uint32 lpm1_upper_init_in_progress :  1 ; /* bits 10:10 */
    cs_uint32 lpm0_upper_init_in_progress :  1 ; /* bits 9:9 */
    cs_uint32 lpm0_lower_init_in_progress :  1 ; /* bits 8:8 */
    cs_uint32 hc1_upper_ready_for_init :  1 ; /* bits 7:7 */
    cs_uint32 hc0_upper_ready_for_init :  1 ; /* bits 6:6 */
    cs_uint32 hc1_lower_ready_for_init :  1 ; /* bits 5:5 */
    cs_uint32 hc0_lower_ready_for_init :  1 ; /* bits 4:4 */
    cs_uint32 lpm1_lower_ready_for_init :  1 ; /* bits 3:3 */
    cs_uint32 lpm1_upper_ready_for_init :  1 ; /* bits 2:2 */
    cs_uint32 lpm0_upper_ready_for_init :  1 ; /* bits 1:1 */
    cs_uint32 lpm0_lower_ready_for_init :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 lpm0_lower_ready_for_init :  1 ; /* bits 0:0 */
    cs_uint32 lpm0_upper_ready_for_init :  1 ; /* bits 1:1 */
    cs_uint32 lpm1_upper_ready_for_init :  1 ; /* bits 2:2 */
    cs_uint32 lpm1_lower_ready_for_init :  1 ; /* bits 3:3 */
    cs_uint32 hc0_lower_ready_for_init :  1 ; /* bits 4:4 */
    cs_uint32 hc1_lower_ready_for_init :  1 ; /* bits 5:5 */
    cs_uint32 hc0_upper_ready_for_init :  1 ; /* bits 6:6 */
    cs_uint32 hc1_upper_ready_for_init :  1 ; /* bits 7:7 */
    cs_uint32 lpm0_lower_init_in_progress :  1 ; /* bits 8:8 */
    cs_uint32 lpm0_upper_init_in_progress :  1 ; /* bits 9:9 */
    cs_uint32 lpm1_upper_init_in_progress :  1 ; /* bits 10:10 */
    cs_uint32 lpm1_lower_init_in_progress :  1 ; /* bits 11:11 */
    cs_uint32 hc0_lower_init_in_progress :  1 ; /* bits 12:12 */
    cs_uint32 hc1_lower_init_in_progress :  1 ; /* bits 13:13 */
    cs_uint32 hc0_upper_init_in_progress :  1 ; /* bits 14:14 */
    cs_uint32 hc1_upper_init_in_progress :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_MEM_STATUS_t;





#define FETOP_LPM_DBG_CNTR                       0xf0021164
#define FETOP_LPM_DBG_CNTR_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 dbg_cntr             : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_cntr             : 16 ; /* bits 15:0 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_CNTR_t;





#define FETOP_LPM_DBG_LOAD_INC_DEC_PTR           0xf0021168
#define FETOP_LPM_DBG_LOAD_INC_DEC_PTR_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_load_inc_dec_ptr : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_load_inc_dec_ptr : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_LOAD_INC_DEC_PTR_t;





#define FETOP_LPM_DBG_COLUMN_MASK                0xf002116c
#define FETOP_LPM_DBG_COLUMN_MASK_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 dbg_column_mask      : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_column_mask      : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_COLUMN_MASK_t;





#define FETOP_LPM_DBG_RSLT                       0xf0021170
#define FETOP_LPM_DBG_RSLT_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  7 ;
    cs_uint32 dbg_rslt             : 25 ; /* bits 24:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dbg_rslt             : 25 ; /* bits 24:0 */
    cs_uint32 rsrvd1               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_RSLT_t;





#define FETOP_LPM_DBG_SPTR_EPTR4                 0xf0021174
#define FETOP_LPM_DBG_SPTR_EPTR4_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_SPTR_EPTR4_t;





#define FETOP_LPM_DBG_SPTR_EPTR6                 0xf0021178
#define FETOP_LPM_DBG_SPTR_EPTR6_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_SPTR_EPTR6_t;





#define FETOP_LPM_DBG_SRCH_ADDR                  0xf002117c
#define FETOP_LPM_DBG_SRCH_ADDR_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sptr_eptr            : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_DBG_SRCH_ADDR_t;





#define FETOP_LPM_SPARE_REG0                     0xf0021180
#define FETOP_LPM_SPARE_REG0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 spare_reg0           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 spare_reg0           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_SPARE_REG0_t;





#define FETOP_LPM_SPARE_REG1                     0xf0021184
#define FETOP_LPM_SPARE_REG1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 spare_reg1           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 spare_reg1           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_LPM_SPARE_REG1_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LPM */

typedef struct {
  FETOP_LPM_INTERRUPT_0_t                  INTERRUPT_0;                   /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  FETOP_LPM_INTENABLE_0_t                  INTENABLE_0;                   /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  FETOP_LPM_INTERRUPT_1_t                  INTERRUPT_1;                   /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  FETOP_LPM_INTENABLE_1_t                  INTENABLE_1;                   /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  FETOP_LPM_LPM_CONFIG_t                   LPM_CONFIG;                    /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_PARITY_t LPM_TABLE0_UPPER_REGF_PARITY;  /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_PARITY_t LPM_TABLE0_LOWER_REGF_PARITY;  /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_PARITY_t LPM_TABLE1_UPPER_REGF_PARITY;  /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_PARITY_t LPM_TABLE1_LOWER_REGF_PARITY;  /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  FETOP_LPM_HC_TABLE0_UPPER_REGF_PARITY_t  HC_TABLE0_UPPER_REGF_PARITY;   /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_PARITY_t  HC_TABLE0_LOWER_REGF_PARITY;   /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_PARITY_t  HC_TABLE1_UPPER_REGF_PARITY;   /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_PARITY_t  HC_TABLE1_LOWER_REGF_PARITY;   /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_ACCESS_t LPM_TABLE0_UPPER_REGF_ACCESS;  /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA8_t  LPM_TABLE0_UPPER_REGF_DATA8;   /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA7_t  LPM_TABLE0_UPPER_REGF_DATA7;   /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA6_t  LPM_TABLE0_UPPER_REGF_DATA6;   /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA5_t  LPM_TABLE0_UPPER_REGF_DATA5;   /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA4_t  LPM_TABLE0_UPPER_REGF_DATA4;   /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA3_t  LPM_TABLE0_UPPER_REGF_DATA3;   /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA2_t  LPM_TABLE0_UPPER_REGF_DATA2;   /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA1_t  LPM_TABLE0_UPPER_REGF_DATA1;   /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  FETOP_LPM_LPM_TABLE0_UPPER_REGF_DATA0_t  LPM_TABLE0_UPPER_REGF_DATA0;   /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  FETOP_LPM_HC_TABLE0_UPPER_REGF_ACCESS_t  HC_TABLE0_UPPER_REGF_ACCESS;   /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA3_t   HC_TABLE0_UPPER_REGF_DATA3;    /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA2_t   HC_TABLE0_UPPER_REGF_DATA2;    /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA1_t   HC_TABLE0_UPPER_REGF_DATA1;    /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  FETOP_LPM_HC_TABLE0_UPPER_REGF_DATA0_t   HC_TABLE0_UPPER_REGF_DATA0;    /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_ACCESS_t LPM_TABLE0_LOWER_REGF_ACCESS;  /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA8_t  LPM_TABLE0_LOWER_REGF_DATA8;   /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA7_t  LPM_TABLE0_LOWER_REGF_DATA7;   /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA6_t  LPM_TABLE0_LOWER_REGF_DATA6;   /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA5_t  LPM_TABLE0_LOWER_REGF_DATA5;   /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA4_t  LPM_TABLE0_LOWER_REGF_DATA4;   /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA3_t  LPM_TABLE0_LOWER_REGF_DATA3;   /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA2_t  LPM_TABLE0_LOWER_REGF_DATA2;   /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA1_t  LPM_TABLE0_LOWER_REGF_DATA1;   /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  FETOP_LPM_LPM_TABLE0_LOWER_REGF_DATA0_t  LPM_TABLE0_LOWER_REGF_DATA0;   /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_ACCESS_t  HC_TABLE0_LOWER_REGF_ACCESS;   /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA3_t   HC_TABLE0_LOWER_REGF_DATA3;    /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA2_t   HC_TABLE0_LOWER_REGF_DATA2;    /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA1_t   HC_TABLE0_LOWER_REGF_DATA1;    /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  FETOP_LPM_HC_TABLE0_LOWER_REGF_DATA0_t   HC_TABLE0_LOWER_REGF_DATA0;    /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_ACCESS_t LPM_TABLE1_UPPER_REGF_ACCESS;  /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA8_t  LPM_TABLE1_UPPER_REGF_DATA8;   /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA7_t  LPM_TABLE1_UPPER_REGF_DATA7;   /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA6_t  LPM_TABLE1_UPPER_REGF_DATA6;   /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA5_t  LPM_TABLE1_UPPER_REGF_DATA5;   /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA4_t  LPM_TABLE1_UPPER_REGF_DATA4;   /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA3_t  LPM_TABLE1_UPPER_REGF_DATA3;   /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA2_t  LPM_TABLE1_UPPER_REGF_DATA2;   /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA1_t  LPM_TABLE1_UPPER_REGF_DATA1;   /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  FETOP_LPM_LPM_TABLE1_UPPER_REGF_DATA0_t  LPM_TABLE1_UPPER_REGF_DATA0;   /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_ACCESS_t  HC_TABLE1_UPPER_REGF_ACCESS;   /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA3_t   HC_TABLE1_UPPER_REGF_DATA3;    /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd55[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA2_t   HC_TABLE1_UPPER_REGF_DATA2;    /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd56[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA1_t   HC_TABLE1_UPPER_REGF_DATA1;    /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd57[3];                   
  FETOP_LPM_HC_TABLE1_UPPER_REGF_DATA0_t   HC_TABLE1_UPPER_REGF_DATA0;    /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd58[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_ACCESS_t LPM_TABLE1_LOWER_REGF_ACCESS;  /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd59[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA8_t  LPM_TABLE1_LOWER_REGF_DATA8;   /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd60[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA7_t  LPM_TABLE1_LOWER_REGF_DATA7;   /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd61[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA6_t  LPM_TABLE1_LOWER_REGF_DATA6;   /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd62[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA5_t  LPM_TABLE1_LOWER_REGF_DATA5;   /* addr: 0x000000f8 */ 
  cs_uint32                                rsrvd63[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA4_t  LPM_TABLE1_LOWER_REGF_DATA4;   /* addr: 0x000000fc */ 
  cs_uint32                                rsrvd64[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA3_t  LPM_TABLE1_LOWER_REGF_DATA3;   /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd65[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA2_t  LPM_TABLE1_LOWER_REGF_DATA2;   /* addr: 0x00000104 */ 
  cs_uint32                                rsrvd66[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA1_t  LPM_TABLE1_LOWER_REGF_DATA1;   /* addr: 0x00000108 */ 
  cs_uint32                                rsrvd67[3];                   
  FETOP_LPM_LPM_TABLE1_LOWER_REGF_DATA0_t  LPM_TABLE1_LOWER_REGF_DATA0;   /* addr: 0x0000010c */ 
  cs_uint32                                rsrvd68[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_ACCESS_t  HC_TABLE1_LOWER_REGF_ACCESS;   /* addr: 0x00000110 */ 
  cs_uint32                                rsrvd69[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA3_t   HC_TABLE1_LOWER_REGF_DATA3;    /* addr: 0x00000114 */ 
  cs_uint32                                rsrvd70[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA2_t   HC_TABLE1_LOWER_REGF_DATA2;    /* addr: 0x00000118 */ 
  cs_uint32                                rsrvd71[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA1_t   HC_TABLE1_LOWER_REGF_DATA1;    /* addr: 0x0000011c */ 
  cs_uint32                                rsrvd72[3];                   
  FETOP_LPM_HC_TABLE1_LOWER_REGF_DATA0_t   HC_TABLE1_LOWER_REGF_DATA0;    /* addr: 0x00000120 */ 
  cs_uint32                                rsrvd73[3];                   
  FETOP_LPM_IPV4_START_PTR0_t              IPV4_START_PTR0;               /* addr: 0x00000124 */ 
  cs_uint32                                rsrvd74[3];                   
  FETOP_LPM_IPV4_START_PTR1_t              IPV4_START_PTR1;               /* addr: 0x00000128 */ 
  cs_uint32                                rsrvd75[3];                   
  FETOP_LPM_IPV6_START_PTR0_t              IPV6_START_PTR0;               /* addr: 0x0000012c */ 
  cs_uint32                                rsrvd76[3];                   
  FETOP_LPM_IPV6_START_PTR1_t              IPV6_START_PTR1;               /* addr: 0x00000130 */ 
  cs_uint32                                rsrvd77[3];                   
  FETOP_LPM_IPV4_END_PTR0_t                IPV4_END_PTR0;                 /* addr: 0x00000134 */ 
  cs_uint32                                rsrvd78[3];                   
  FETOP_LPM_IPV4_END_PTR1_t                IPV4_END_PTR1;                 /* addr: 0x00000138 */ 
  cs_uint32                                rsrvd79[3];                   
  FETOP_LPM_IPV6_END_PTR0_t                IPV6_END_PTR0;                 /* addr: 0x0000013c */ 
  cs_uint32                                rsrvd80[3];                   
  FETOP_LPM_IPV6_END_PTR1_t                IPV6_END_PTR1;                 /* addr: 0x00000140 */ 
  cs_uint32                                rsrvd81[3];                   
  FETOP_LPM_INACTIVE_DROP_COUNT_t          INACTIVE_DROP_COUNT;           /* addr: 0x00000144 */ 
  cs_uint32                                rsrvd82[3];                   
  FETOP_LPM_IPV4_MISS_COUNT0_t             IPV4_MISS_COUNT0;              /* addr: 0x00000148 */ 
  cs_uint32                                rsrvd83[3];                   
  FETOP_LPM_IPV4_MISS_COUNT1_t             IPV4_MISS_COUNT1;              /* addr: 0x0000014c */ 
  cs_uint32                                rsrvd84[3];                   
  FETOP_LPM_IPV6_MISS_COUNT0_t             IPV6_MISS_COUNT0;              /* addr: 0x00000150 */ 
  cs_uint32                                rsrvd85[3];                   
  FETOP_LPM_IPV6_MISS_COUNT1_t             IPV6_MISS_COUNT1;              /* addr: 0x00000154 */ 
  cs_uint32                                rsrvd86[3];                   
  FETOP_LPM_LPM_STATUS_t                   LPM_STATUS;                    /* addr: 0x00000158 */ 
  cs_uint32                                rsrvd87[3];                   
  FETOP_LPM_MEM_INIT_t                     MEM_INIT;                      /* addr: 0x0000015c */ 
  cs_uint32                                rsrvd88[3];                   
  FETOP_LPM_MEM_STATUS_t                   MEM_STATUS;                    /* addr: 0x00000160 */ 
  cs_uint32                                rsrvd89[3];                   
  FETOP_LPM_DBG_CNTR_t                     DBG_CNTR;                      /* addr: 0x00000164 */ 
  cs_uint32                                rsrvd90[3];                   
  FETOP_LPM_DBG_LOAD_INC_DEC_PTR_t         DBG_LOAD_INC_DEC_PTR;          /* addr: 0x00000168 */ 
  cs_uint32                                rsrvd91[3];                   
  FETOP_LPM_DBG_COLUMN_MASK_t              DBG_COLUMN_MASK;               /* addr: 0x0000016c */ 
  cs_uint32                                rsrvd92[3];                   
  FETOP_LPM_DBG_RSLT_t                     DBG_RSLT;                      /* addr: 0x00000170 */ 
  cs_uint32                                rsrvd93[3];                   
  FETOP_LPM_DBG_SPTR_EPTR4_t               DBG_SPTR_EPTR4;                /* addr: 0x00000174 */ 
  cs_uint32                                rsrvd94[3];                   
  FETOP_LPM_DBG_SPTR_EPTR6_t               DBG_SPTR_EPTR6;                /* addr: 0x00000178 */ 
  cs_uint32                                rsrvd95[3];                   
  FETOP_LPM_DBG_SRCH_ADDR_t                DBG_SRCH_ADDR;                 /* addr: 0x0000017c */ 
  cs_uint32                                rsrvd96[3];                   
  FETOP_LPM_SPARE_REG0_t                   SPARE_REG0;                    /* addr: 0x00000180 */ 
  cs_uint32                                rsrvd97[3];                   
  FETOP_LPM_SPARE_REG1_t                   SPARE_REG1;                    /* addr: 0x00000184 */ 
} FETOP_LPM_t;

  

/*
 * HASH
 */
  



#define FETOP_HASH_STATUS                        0xf0022000
#define FETOP_HASH_STATUS_dft                    0x00000003




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 30 ;
    cs_uint32 ready_for_init       :  1 ; /* bits 1:1 */
    cs_uint32 init_in_progress     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init_in_progress     :  1 ; /* bits 0:0 */
    cs_uint32 ready_for_init       :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               : 30 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_t;





#define FETOP_HASH_INIT                          0xf0022004
#define FETOP_HASH_INIT_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 init                 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_INIT_t;





#define FETOP_HASH_INTERRUPT_0                   0xf0022008
#define FETOP_HASH_INTERRUPT_0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 checkmem_parity_fail :  1 ; /* bits 7:7 */
    cs_uint32 hash_overflow_mult_hit :  1 ; /* bits 6:6 */
    cs_uint32 hashmem_mult_hit     :  1 ; /* bits 5:5 */
    cs_uint32 statusmem_uncorr_ecc_err :  1 ; /* bits 4:4 */
    cs_uint32 statusmem_corr_ecc_err :  1 ; /* bits 3:3 */
    cs_uint32 maskmem_parity_fail  :  1 ; /* bits 2:2 */
    cs_uint32 hashmem_uncorr_ecc_err :  1 ; /* bits 1:1 */
    cs_uint32 hashmem_corr_ecc_err :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hashmem_corr_ecc_err :  1 ; /* bits 0:0 */
    cs_uint32 hashmem_uncorr_ecc_err :  1 ; /* bits 1:1 */
    cs_uint32 maskmem_parity_fail  :  1 ; /* bits 2:2 */
    cs_uint32 statusmem_corr_ecc_err :  1 ; /* bits 3:3 */
    cs_uint32 statusmem_uncorr_ecc_err :  1 ; /* bits 4:4 */
    cs_uint32 hashmem_mult_hit     :  1 ; /* bits 5:5 */
    cs_uint32 hash_overflow_mult_hit :  1 ; /* bits 6:6 */
    cs_uint32 checkmem_parity_fail :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_INTERRUPT_0_t;





#define FETOP_HASH_INTENABLE_0                   0xf002200c
#define FETOP_HASH_INTENABLE_0_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 checkmem_parity_fail_E :  1 ; /* bits 7:7 */
    cs_uint32 hash_overflow_mult_hit_E :  1 ; /* bits 6:6 */
    cs_uint32 hashmem_mult_hit_E   :  1 ; /* bits 5:5 */
    cs_uint32 statusmem_uncorr_ecc_err_E :  1 ; /* bits 4:4 */
    cs_uint32 statusmem_corr_ecc_err_E :  1 ; /* bits 3:3 */
    cs_uint32 maskmem_parity_fail_E :  1 ; /* bits 2:2 */
    cs_uint32 hashmem_uncorr_ecc_err_E :  1 ; /* bits 1:1 */
    cs_uint32 hashmem_corr_ecc_err_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hashmem_corr_ecc_err_E :  1 ; /* bits 0:0 */
    cs_uint32 hashmem_uncorr_ecc_err_E :  1 ; /* bits 1:1 */
    cs_uint32 maskmem_parity_fail_E :  1 ; /* bits 2:2 */
    cs_uint32 statusmem_corr_ecc_err_E :  1 ; /* bits 3:3 */
    cs_uint32 statusmem_uncorr_ecc_err_E :  1 ; /* bits 4:4 */
    cs_uint32 hashmem_mult_hit_E   :  1 ; /* bits 5:5 */
    cs_uint32 hash_overflow_mult_hit_E :  1 ; /* bits 6:6 */
    cs_uint32 checkmem_parity_fail_E :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_INTENABLE_0_t;





#define FETOP_HASH_INTERRUPT_1                   0xf0022010
#define FETOP_HASH_INTERRUPT_1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 checkmem_parity_fail :  1 ; /* bits 7:7 */
    cs_uint32 hash_overflow_mult_hit :  1 ; /* bits 6:6 */
    cs_uint32 hashmem_mult_hit     :  1 ; /* bits 5:5 */
    cs_uint32 statusmem_uncorr_ecc_err :  1 ; /* bits 4:4 */
    cs_uint32 statusmem_corr_ecc_err :  1 ; /* bits 3:3 */
    cs_uint32 maskmem_parity_fail  :  1 ; /* bits 2:2 */
    cs_uint32 hashmem_uncorr_ecc_err :  1 ; /* bits 1:1 */
    cs_uint32 hashmem_corr_ecc_err :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hashmem_corr_ecc_err :  1 ; /* bits 0:0 */
    cs_uint32 hashmem_uncorr_ecc_err :  1 ; /* bits 1:1 */
    cs_uint32 maskmem_parity_fail  :  1 ; /* bits 2:2 */
    cs_uint32 statusmem_corr_ecc_err :  1 ; /* bits 3:3 */
    cs_uint32 statusmem_uncorr_ecc_err :  1 ; /* bits 4:4 */
    cs_uint32 hashmem_mult_hit     :  1 ; /* bits 5:5 */
    cs_uint32 hash_overflow_mult_hit :  1 ; /* bits 6:6 */
    cs_uint32 checkmem_parity_fail :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_INTERRUPT_1_t;





#define FETOP_HASH_INTENABLE_1                   0xf0022014
#define FETOP_HASH_INTENABLE_1_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 checkmem_parity_fail_E :  1 ; /* bits 7:7 */
    cs_uint32 hash_overflow_mult_hit_E :  1 ; /* bits 6:6 */
    cs_uint32 hashmem_mult_hit_E   :  1 ; /* bits 5:5 */
    cs_uint32 statusmem_uncorr_ecc_err_E :  1 ; /* bits 4:4 */
    cs_uint32 statusmem_corr_ecc_err_E :  1 ; /* bits 3:3 */
    cs_uint32 maskmem_parity_fail_E :  1 ; /* bits 2:2 */
    cs_uint32 hashmem_uncorr_ecc_err_E :  1 ; /* bits 1:1 */
    cs_uint32 hashmem_corr_ecc_err_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hashmem_corr_ecc_err_E :  1 ; /* bits 0:0 */
    cs_uint32 hashmem_uncorr_ecc_err_E :  1 ; /* bits 1:1 */
    cs_uint32 maskmem_parity_fail_E :  1 ; /* bits 2:2 */
    cs_uint32 statusmem_corr_ecc_err_E :  1 ; /* bits 3:3 */
    cs_uint32 statusmem_uncorr_ecc_err_E :  1 ; /* bits 4:4 */
    cs_uint32 hashmem_mult_hit_E   :  1 ; /* bits 5:5 */
    cs_uint32 hash_overflow_mult_hit_E :  1 ; /* bits 6:6 */
    cs_uint32 checkmem_parity_fail_E :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_INTENABLE_1_t;





#define FETOP_HASH_MULT_HIT                      0xf0022018
#define FETOP_HASH_MULT_HIT_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 hash_ovfw_addr       :  6 ; /* bits 17:12 */
    cs_uint32 hash_addr            : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 hash_addr            : 12 ; /* bits 11:0 */
    cs_uint32 hash_ovfw_addr       :  6 ; /* bits 17:12 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MULT_HIT_t;





#define FETOP_HASH_HASH_MEM_ACCESS               0xf002201c
#define FETOP_HASH_HASH_MEM_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ecc_bypass           :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 address              : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 ecc_bypass           :  1 ; /* bits 29:29 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_ACCESS_t;





#define FETOP_HASH_HASH_MEM_DATA3                0xf0022020
#define FETOP_HASH_HASH_MEM_DATA3_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 mask_ptr_1           :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mask_ptr_1           :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_DATA3_t;





#define FETOP_HASH_HASH_MEM_DATA2                0xf0022024
#define FETOP_HASH_HASH_MEM_DATA2_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 result_index_1       : 13 ; /* bits 31:19 */
    cs_uint32 crc32_1              : 19 ; /* bits 18:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc32_1              : 19 ; /* bits 18:0 */
    cs_uint32 result_index_1       : 13 ; /* bits 31:19 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_DATA2_t;





#define FETOP_HASH_HASH_MEM_DATA1                0xf0022028
#define FETOP_HASH_HASH_MEM_DATA1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 crc32_1              : 13 ; /* bits 31:19 */
    cs_uint32 mask_ptr_0           :  6 ; /* bits 18:13 */
    cs_uint32 result_index_0       : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 result_index_0       : 13 ; /* bits 12:0 */
    cs_uint32 mask_ptr_0           :  6 ; /* bits 18:13 */
    cs_uint32 crc32_1              : 13 ; /* bits 31:19 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_DATA1_t;





#define FETOP_HASH_HASH_MEM_DATA0                0xf002202c
#define FETOP_HASH_HASH_MEM_DATA0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 crc32_0              : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc32_0              : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_DATA0_t;





#define FETOP_HASH_HASH_MEM_ECC                  0xf0022030
#define FETOP_HASH_HASH_MEM_ECC_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ecc                  :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ecc                  :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_HASH_MEM_ECC_t;





#define FETOP_HASH_UN_CORR_ECC_ADDR_HASH_MEM     0xf0022034
#define FETOP_HASH_UN_CORR_ECC_ADDR_HASH_MEM_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 addr                 : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_UN_CORR_ECC_ADDR_HASH_MEM_t;





#define FETOP_HASH_CORR_ECC_ADDR_HASH_MEM        0xf0022038
#define FETOP_HASH_CORR_ECC_ADDR_HASH_MEM_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 addr                 : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CORR_ECC_ADDR_HASH_MEM_t;





#define FETOP_HASH_OVERFLOW_MEM_ACCESS           0xf002203c
#define FETOP_HASH_OVERFLOW_MEM_ACCESS_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 address              :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_OVERFLOW_MEM_ACCESS_t;





#define FETOP_HASH_OVERFLOW_MEM_DATA1            0xf0022040
#define FETOP_HASH_OVERFLOW_MEM_DATA1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 mask_ptr             :  6 ; /* bits 30:25 */
    cs_uint32 result_index         : 13 ; /* bits 24:12 */
    cs_uint32 crc16                : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc16                : 12 ; /* bits 11:0 */
    cs_uint32 result_index         : 13 ; /* bits 24:12 */
    cs_uint32 mask_ptr             :  6 ; /* bits 30:25 */
    cs_uint32 rsrvd1               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_OVERFLOW_MEM_DATA1_t;





#define FETOP_HASH_OVERFLOW_MEM_DATA0            0xf0022044
#define FETOP_HASH_OVERFLOW_MEM_DATA0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 crc32                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc32                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_OVERFLOW_MEM_DATA0_t;





#define FETOP_HASH_STATUS_MEM_ACCESS             0xf0022048
#define FETOP_HASH_STATUS_MEM_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ecc_bypass           :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 address              :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 ecc_bypass           :  1 ; /* bits 29:29 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_ACCESS_t;





#define FETOP_HASH_STATUS_MEM_DATA1              0xf002204c
#define FETOP_HASH_STATUS_MEM_DATA1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 status               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 status               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_DATA1_t;





#define FETOP_HASH_STATUS_MEM_DATA0              0xf0022050
#define FETOP_HASH_STATUS_MEM_DATA0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 status               : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 status               : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_DATA0_t;





#define FETOP_HASH_STATUS_MEM_ECC                0xf0022054
#define FETOP_HASH_STATUS_MEM_ECC_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 ecc                  :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ecc                  :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_ECC_t;





#define FETOP_HASH_UN_CORR_ECC_ADDR_STATUS_MEM   0xf0022058
#define FETOP_HASH_UN_CORR_ECC_ADDR_STATUS_MEM_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_UN_CORR_ECC_ADDR_STATUS_MEM_t;





#define FETOP_HASH_CORR_ECC_ADDR_STATUS_MEM      0xf002205c
#define FETOP_HASH_CORR_ECC_ADDR_STATUS_MEM_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CORR_ECC_ADDR_STATUS_MEM_t;





#define FETOP_HASH_STATUS_MEM_MASK1              0xf0022060
#define FETOP_HASH_STATUS_MEM_MASK1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mask1                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mask1                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_MASK1_t;





#define FETOP_HASH_STATUS_MEM_MASK0              0xf0022064
#define FETOP_HASH_STATUS_MEM_MASK0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 mask0                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mask0                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_STATUS_MEM_MASK0_t;





#define FETOP_HASH_MASK_MEM_ACCESS               0xf0022068
#define FETOP_HASH_MASK_MEM_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 address              :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_ACCESS_t;





#define FETOP_HASH_MASK_MEM_DATA4                0xf002206c
#define FETOP_HASH_MASK_MEM_DATA4_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 FE_HM_PARITY         :  1 ; /* bits 21:21 */
    cs_uint32 FE_HM_MCGID_MASK     :  9 ; /* bits 20:12 */
    cs_uint32 FE_HM_PKTLEN_RNG_MATCH_VECTOR_MASK :  4 ; /* bits 11:8 */
    cs_uint32 FE_HM_PPP_PROTOCOL_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_HM_PPP_PROTOCOL_VLD_MASK :  1 ; /* bits 6:6 */
    cs_uint32 FE_HM_IPV6_DOH_MASK  :  1 ; /* bits 5:5 */
    cs_uint32 FE_HM_IPV6_RH_MASK   :  1 ; /* bits 4:4 */
    cs_uint32 FE_HM_IPV6_HBH_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 FE_HM_IPV6_NDP_MASK  :  1 ; /* bits 2:2 */
    cs_uint32 FE_HM_SPI_MASK       :  1 ; /* bits 1:1 */
    cs_uint32 FE_HM_SPI_VLD_MASK   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_HM_SPI_VLD_MASK   :  1 ; /* bits 0:0 */
    cs_uint32 FE_HM_SPI_MASK       :  1 ; /* bits 1:1 */
    cs_uint32 FE_HM_IPV6_NDP_MASK  :  1 ; /* bits 2:2 */
    cs_uint32 FE_HM_IPV6_HBH_MASK  :  1 ; /* bits 3:3 */
    cs_uint32 FE_HM_IPV6_RH_MASK   :  1 ; /* bits 4:4 */
    cs_uint32 FE_HM_IPV6_DOH_MASK  :  1 ; /* bits 5:5 */
    cs_uint32 FE_HM_PPP_PROTOCOL_VLD_MASK :  1 ; /* bits 6:6 */
    cs_uint32 FE_HM_PPP_PROTOCOL_MASK :  1 ; /* bits 7:7 */
    cs_uint32 FE_HM_PKTLEN_RNG_MATCH_VECTOR_MASK :  4 ; /* bits 11:8 */
    cs_uint32 FE_HM_MCGID_MASK     :  9 ; /* bits 20:12 */
    cs_uint32 FE_HM_PARITY         :  1 ; /* bits 21:21 */
    cs_uint32 rsrvd1               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_DATA4_t;





#define FETOP_HASH_MASK_MEM_DATA3                0xf0022070
#define FETOP_HASH_MASK_MEM_DATA3_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_HM_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 31:31 */
    cs_uint32 FE_HM_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 30:30 */
    cs_uint32 FE_HM_L7_FIELD_SEL   :  2 ; /* bits 29:28 */
    cs_uint32 FE_HM_HASH_FID_MASK  :  1 ; /* bits 27:27 */
    cs_uint32 FE_HM_NOT_HDR_A_FLAGS_STSVLD_MASK :  1 ; /* bits 26:26 */
    cs_uint32 FE_HM_L4_CHKSUM_ERR_MASK :  1 ; /* bits 25:25 */
    cs_uint32 FE_HM_L3_CHKSUM_ERR_MASK :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_HDR_A_FLAGS_CRCERR_MASK :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_L7_FIELD_VLD_MASK :  1 ; /* bits 22:22 */
    cs_uint32 FE_HM_L7_FIELD_MASK  :  1 ; /* bits 21:21 */
    cs_uint32 FE_HM_ORIG_LSPID_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_DA_AN_MAC_HIT_MASK :  1 ; /* bits 19:19 */
    cs_uint32 FE_HM_DA_AN_MAC_SEL_MASK :  1 ; /* bits 18:18 */
    cs_uint32 FE_HM_BC_DA_MASK     :  1 ; /* bits 17:17 */
    cs_uint32 FE_HM_MC_DA_MASK     :  1 ; /* bits 16:16 */
    cs_uint32 FE_HM_MCIDX_MASK     :  1 ; /* bits 15:15 */
    cs_uint32 FE_HM_RECIRC_IDX_MASK :  1 ; /* bits 14:14 */
    cs_uint32 FE_HM_RSVD_109       :  1 ; /* bits 13:13 */
    cs_uint32 FE_HM_PPPOE_SESSION_ID_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_HM_PPPOE_SESSION_ID_VLD_MASK :  1 ; /* bits 11:11 */
    cs_uint32 FE_HM_FWDTYPE_MASK   :  4 ; /* bits 10:7 */
    cs_uint32 FE_HM_LSPID_MASK     :  1 ; /* bits 6:6 */
    cs_uint32 FE_HM_L4_VLD_MASK    :  1 ; /* bits 5:5 */
    cs_uint32 FE_HM_TCP_ECN_MASK   :  3 ; /* bits 4:2 */
    cs_uint32 FE_HM_TCP_CTRL_MASK  :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_HM_TCP_CTRL_MASK  :  2 ; /* bits 1:0 */
    cs_uint32 FE_HM_TCP_ECN_MASK   :  3 ; /* bits 4:2 */
    cs_uint32 FE_HM_L4_VLD_MASK    :  1 ; /* bits 5:5 */
    cs_uint32 FE_HM_LSPID_MASK     :  1 ; /* bits 6:6 */
    cs_uint32 FE_HM_FWDTYPE_MASK   :  4 ; /* bits 10:7 */
    cs_uint32 FE_HM_PPPOE_SESSION_ID_VLD_MASK :  1 ; /* bits 11:11 */
    cs_uint32 FE_HM_PPPOE_SESSION_ID_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_HM_RSVD_109       :  1 ; /* bits 13:13 */
    cs_uint32 FE_HM_RECIRC_IDX_MASK :  1 ; /* bits 14:14 */
    cs_uint32 FE_HM_MCIDX_MASK     :  1 ; /* bits 15:15 */
    cs_uint32 FE_HM_MC_DA_MASK     :  1 ; /* bits 16:16 */
    cs_uint32 FE_HM_BC_DA_MASK     :  1 ; /* bits 17:17 */
    cs_uint32 FE_HM_DA_AN_MAC_SEL_MASK :  1 ; /* bits 18:18 */
    cs_uint32 FE_HM_DA_AN_MAC_HIT_MASK :  1 ; /* bits 19:19 */
    cs_uint32 FE_HM_ORIG_LSPID_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_L7_FIELD_MASK  :  1 ; /* bits 21:21 */
    cs_uint32 FE_HM_L7_FIELD_VLD_MASK :  1 ; /* bits 22:22 */
    cs_uint32 FE_HM_HDR_A_FLAGS_CRCERR_MASK :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_L3_CHKSUM_ERR_MASK :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_L4_CHKSUM_ERR_MASK :  1 ; /* bits 25:25 */
    cs_uint32 FE_HM_NOT_HDR_A_FLAGS_STSVLD_MASK :  1 ; /* bits 26:26 */
    cs_uint32 FE_HM_HASH_FID_MASK  :  1 ; /* bits 27:27 */
    cs_uint32 FE_HM_L7_FIELD_SEL   :  2 ; /* bits 29:28 */
    cs_uint32 FE_HM_SA_BNG_MAC_SEL_MASK :  1 ; /* bits 30:30 */
    cs_uint32 FE_HM_SA_BNG_MAC_HIT_MASK :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_DATA3_t;





#define FETOP_HASH_MASK_MEM_DATA2                0xf0022074
#define FETOP_HASH_MASK_MEM_DATA2_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_HM_TCP_CTRL_MASK  :  4 ; /* bits 31:28 */
    cs_uint32 FE_HM_L4_SP_MASK     : 16 ; /* bits 27:12 */
    cs_uint32 FE_HM_L4_DP_MASK     : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_HM_L4_DP_MASK     : 12 ; /* bits 11:0 */
    cs_uint32 FE_HM_L4_SP_MASK     : 16 ; /* bits 27:12 */
    cs_uint32 FE_HM_TCP_CTRL_MASK  :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_DATA2_t;





#define FETOP_HASH_MASK_MEM_DATA1                0xf0022078
#define FETOP_HASH_MASK_MEM_DATA1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_HM_L4_DP_MASK     :  4 ; /* bits 31:28 */
    cs_uint32 FE_HM_L4_PORTS_RNGD  :  2 ; /* bits 27:26 */
    cs_uint32 FE_HM_IP_VLD_MASK    :  1 ; /* bits 25:25 */
    cs_uint32 FE_HM_IP_VER_MASK    :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_IPV6_FLOW_LBL_MASK :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_KEYGEN_POLY_SEL :  2 ; /* bits 22:21 */
    cs_uint32 FE_HM_IP_FRAGMENT_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_ECN_MASK       :  2 ; /* bits 19:18 */
    cs_uint32 FE_HM_DSCP_MASK      :  6 ; /* bits 17:12 */
    cs_uint32 FE_HM_IP_PROT_MASK   :  1 ; /* bits 11:11 */
    cs_uint32 FE_HM_IP_SA_MASK     :  9 ; /* bits 10:2 */
    cs_uint32 FE_HM_IP_DA_MASK     :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_HM_IP_DA_MASK     :  2 ; /* bits 1:0 */
    cs_uint32 FE_HM_IP_SA_MASK     :  9 ; /* bits 10:2 */
    cs_uint32 FE_HM_IP_PROT_MASK   :  1 ; /* bits 11:11 */
    cs_uint32 FE_HM_DSCP_MASK      :  6 ; /* bits 17:12 */
    cs_uint32 FE_HM_ECN_MASK       :  2 ; /* bits 19:18 */
    cs_uint32 FE_HM_IP_FRAGMENT_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_KEYGEN_POLY_SEL :  2 ; /* bits 22:21 */
    cs_uint32 FE_HM_IPV6_FLOW_LBL_MASK :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_IP_VER_MASK    :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_IP_VLD_MASK    :  1 ; /* bits 25:25 */
    cs_uint32 FE_HM_L4_PORTS_RNGD  :  2 ; /* bits 27:26 */
    cs_uint32 FE_HM_L4_DP_MASK     :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_DATA1_t;





#define FETOP_HASH_MASK_MEM_DATA0                0xf002207c
#define FETOP_HASH_MASK_MEM_DATA0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 FE_HM_IP_DA_MASK     :  7 ; /* bits 31:25 */
    cs_uint32 FE_HM_VID_2_MASK     :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_DEI_2_MASK     :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_8021P_2_MASK   :  1 ; /* bits 22:22 */
    cs_uint32 FE_HM_TPID_ENC_2_LSB_MASK :  1 ; /* bits 21:21 */
    cs_uint32 FE_HM_TPID_ENC_2_MSB_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_VID_1_MASK     :  1 ; /* bits 19:19 */
    cs_uint32 FE_HM_DEI_1_MASK     :  1 ; /* bits 18:18 */
    cs_uint32 FE_HM_8021P_1_MASK   :  1 ; /* bits 17:17 */
    cs_uint32 FE_HM_TPID_ENC_1_LSB_MASK :  1 ; /* bits 16:16 */
    cs_uint32 FE_HM_TPID_ENC_1_MSB_MASK :  1 ; /* bits 15:15 */
    cs_uint32 FE_HM_LLC_TYPE_ENC_LSB_MASK :  1 ; /* bits 14:14 */
    cs_uint32 FE_HM_LLC_TYPE_ENC_MSB_MASK :  1 ; /* bits 13:13 */
    cs_uint32 FE_HM_ETHERTYPE_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_HM_MAC_SA_MASK    :  6 ; /* bits 11:6 */
    cs_uint32 FE_HM_MAC_DA_MASK    :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 FE_HM_MAC_DA_MASK    :  6 ; /* bits 5:0 */
    cs_uint32 FE_HM_MAC_SA_MASK    :  6 ; /* bits 11:6 */
    cs_uint32 FE_HM_ETHERTYPE_MASK :  1 ; /* bits 12:12 */
    cs_uint32 FE_HM_LLC_TYPE_ENC_MSB_MASK :  1 ; /* bits 13:13 */
    cs_uint32 FE_HM_LLC_TYPE_ENC_LSB_MASK :  1 ; /* bits 14:14 */
    cs_uint32 FE_HM_TPID_ENC_1_MSB_MASK :  1 ; /* bits 15:15 */
    cs_uint32 FE_HM_TPID_ENC_1_LSB_MASK :  1 ; /* bits 16:16 */
    cs_uint32 FE_HM_8021P_1_MASK   :  1 ; /* bits 17:17 */
    cs_uint32 FE_HM_DEI_1_MASK     :  1 ; /* bits 18:18 */
    cs_uint32 FE_HM_VID_1_MASK     :  1 ; /* bits 19:19 */
    cs_uint32 FE_HM_TPID_ENC_2_MSB_MASK :  1 ; /* bits 20:20 */
    cs_uint32 FE_HM_TPID_ENC_2_LSB_MASK :  1 ; /* bits 21:21 */
    cs_uint32 FE_HM_8021P_2_MASK   :  1 ; /* bits 22:22 */
    cs_uint32 FE_HM_DEI_2_MASK     :  1 ; /* bits 23:23 */
    cs_uint32 FE_HM_VID_2_MASK     :  1 ; /* bits 24:24 */
    cs_uint32 FE_HM_IP_DA_MASK     :  7 ; /* bits 31:25 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_MASK_MEM_DATA0_t;





#define FETOP_HASH_PARITY_ERR_ADDR_MASK_MEM      0xf0022080
#define FETOP_HASH_PARITY_ERR_ADDR_MASK_MEM_dft  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 addr                 :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 26 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_PARITY_ERR_ADDR_MASK_MEM_t;





#define FETOP_HASH_DBG_FIFO_ACCESS               0xf0022084
#define FETOP_HASH_DBG_FIFO_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 address              :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_DBG_FIFO_ACCESS_t;





#define FETOP_HASH_DBG_FIFO_DATA2                0xf0022088
#define FETOP_HASH_DBG_FIFO_DATA2_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 tuple_hit            :  1 ; /* bits 19:19 */
    cs_uint32 tuple_priority       :  4 ; /* bits 18:15 */
    cs_uint32 result_addr          : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 result_addr          : 15 ; /* bits 14:0 */
    cs_uint32 tuple_priority       :  4 ; /* bits 18:15 */
    cs_uint32 tuple_hit            :  1 ; /* bits 19:19 */
    cs_uint32 rsrvd1               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_DBG_FIFO_DATA2_t;





#define FETOP_HASH_DBG_FIFO_DATA1                0xf002208c
#define FETOP_HASH_DBG_FIFO_DATA1_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 result_addr          :  1 ; /* bits 31:31 */
    cs_uint32 mask_ptr             :  6 ; /* bits 30:25 */
    cs_uint32 result_index         : 13 ; /* bits 24:12 */
    cs_uint32 crc16                : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc16                : 12 ; /* bits 11:0 */
    cs_uint32 result_index         : 13 ; /* bits 24:12 */
    cs_uint32 mask_ptr             :  6 ; /* bits 30:25 */
    cs_uint32 result_addr          :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_DBG_FIFO_DATA1_t;





#define FETOP_HASH_DBG_FIFO_DATA0                0xf0022090
#define FETOP_HASH_DBG_FIFO_DATA0_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 crc32                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 crc32                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_DBG_FIFO_DATA0_t;





#define FETOP_HASH_SUPER_HASH                    0xf0022094
#define FETOP_HASH_SUPER_HASH_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 enable               :  1 ; /* bits 6:6 */
    cs_uint32 mask_ptr             :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mask_ptr             :  6 ; /* bits 5:0 */
    cs_uint32 enable               :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_SUPER_HASH_t;





#define FETOP_HASH_CHECK_MEM_ACCESS              0xf0022098
#define FETOP_HASH_CHECK_MEM_ACCESS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 address              : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 rb_w                 :  1 ; /* bits 30:30 */
    cs_uint32 ACCESS               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CHECK_MEM_ACCESS_t;





#define FETOP_HASH_CHECK_MEM_DATA2               0xf002209c
#define FETOP_HASH_CHECK_MEM_DATA2_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 parity               :  1 ; /* bits 7:7 */
    cs_uint32 ip_da_check_idx      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ip_da_check_idx      :  7 ; /* bits 6:0 */
    cs_uint32 parity               :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CHECK_MEM_DATA2_t;





#define FETOP_HASH_CHECK_MEM_DATA1               0xf00220a0
#define FETOP_HASH_CHECK_MEM_DATA1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 ip_da_check_idx      :  5 ; /* bits 31:27 */
    cs_uint32 ip_sa_check_idx      : 12 ; /* bits 26:15 */
    cs_uint32 l2_check_idx         :  9 ; /* bits 14:6 */
    cs_uint32 l4_dp_to_be_checked  :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 l4_dp_to_be_checked  :  6 ; /* bits 5:0 */
    cs_uint32 l2_check_idx         :  9 ; /* bits 14:6 */
    cs_uint32 ip_sa_check_idx      : 12 ; /* bits 26:15 */
    cs_uint32 ip_da_check_idx      :  5 ; /* bits 31:27 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CHECK_MEM_DATA1_t;





#define FETOP_HASH_CHECK_MEM_DATA0               0xf00220a4
#define FETOP_HASH_CHECK_MEM_DATA0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 l4_dp_to_be_checked  : 10 ; /* bits 31:22 */
    cs_uint32 l4_sp_to_be_checked  : 16 ; /* bits 21:6 */
    cs_uint32 check_ip_da_en       :  1 ; /* bits 5:5 */
    cs_uint32 check_ip_sa_en       :  1 ; /* bits 4:4 */
    cs_uint32 check_mac_da_en      :  1 ; /* bits 3:3 */
    cs_uint32 check_mac_sa_en      :  1 ; /* bits 2:2 */
    cs_uint32 check_l4_dp_en       :  1 ; /* bits 1:1 */
    cs_uint32 check_l4_sp_en       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 check_l4_sp_en       :  1 ; /* bits 0:0 */
    cs_uint32 check_l4_dp_en       :  1 ; /* bits 1:1 */
    cs_uint32 check_mac_sa_en      :  1 ; /* bits 2:2 */
    cs_uint32 check_mac_da_en      :  1 ; /* bits 3:3 */
    cs_uint32 check_ip_sa_en       :  1 ; /* bits 4:4 */
    cs_uint32 check_ip_da_en       :  1 ; /* bits 5:5 */
    cs_uint32 l4_sp_to_be_checked  : 16 ; /* bits 21:6 */
    cs_uint32 l4_dp_to_be_checked  : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_CHECK_MEM_DATA0_t;





#define FETOP_HASH_PARITY_ERR_ADDR_CHECK_MEM     0xf00220a8
#define FETOP_HASH_PARITY_ERR_ADDR_CHECK_MEM_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 addr                 : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 19 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FETOP_HASH_PARITY_ERR_ADDR_CHECK_MEM_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* HASH */

typedef struct {
  FETOP_HASH_STATUS_t                      STATUS;                        /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  FETOP_HASH_INIT_t                        INIT;                          /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  FETOP_HASH_INTERRUPT_0_t                 INTERRUPT_0;                   /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  FETOP_HASH_INTENABLE_0_t                 INTENABLE_0;                   /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  FETOP_HASH_INTERRUPT_1_t                 INTERRUPT_1;                   /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  FETOP_HASH_INTENABLE_1_t                 INTENABLE_1;                   /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  FETOP_HASH_MULT_HIT_t                    MULT_HIT;                      /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  FETOP_HASH_HASH_MEM_ACCESS_t             HASH_MEM_ACCESS;               /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  FETOP_HASH_HASH_MEM_DATA3_t              HASH_MEM_DATA3;                /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  FETOP_HASH_HASH_MEM_DATA2_t              HASH_MEM_DATA2;                /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  FETOP_HASH_HASH_MEM_DATA1_t              HASH_MEM_DATA1;                /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  FETOP_HASH_HASH_MEM_DATA0_t              HASH_MEM_DATA0;                /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  FETOP_HASH_HASH_MEM_ECC_t                HASH_MEM_ECC;                  /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  FETOP_HASH_UN_CORR_ECC_ADDR_HASH_MEM_t   UN_CORR_ECC_ADDR_HASH_MEM;     /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  FETOP_HASH_CORR_ECC_ADDR_HASH_MEM_t      CORR_ECC_ADDR_HASH_MEM;        /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  FETOP_HASH_OVERFLOW_MEM_ACCESS_t         OVERFLOW_MEM_ACCESS;           /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  FETOP_HASH_OVERFLOW_MEM_DATA1_t          OVERFLOW_MEM_DATA1;            /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  FETOP_HASH_OVERFLOW_MEM_DATA0_t          OVERFLOW_MEM_DATA0;            /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  FETOP_HASH_STATUS_MEM_ACCESS_t           STATUS_MEM_ACCESS;             /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  FETOP_HASH_STATUS_MEM_DATA1_t            STATUS_MEM_DATA1;              /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  FETOP_HASH_STATUS_MEM_DATA0_t            STATUS_MEM_DATA0;              /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  FETOP_HASH_STATUS_MEM_ECC_t              STATUS_MEM_ECC;                /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  FETOP_HASH_UN_CORR_ECC_ADDR_STATUS_MEM_t UN_CORR_ECC_ADDR_STATUS_MEM;   /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  FETOP_HASH_CORR_ECC_ADDR_STATUS_MEM_t    CORR_ECC_ADDR_STATUS_MEM;      /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  FETOP_HASH_STATUS_MEM_MASK1_t            STATUS_MEM_MASK1;              /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  FETOP_HASH_STATUS_MEM_MASK0_t            STATUS_MEM_MASK0;              /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  FETOP_HASH_MASK_MEM_ACCESS_t             MASK_MEM_ACCESS;               /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  FETOP_HASH_MASK_MEM_DATA4_t              MASK_MEM_DATA4;                /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  FETOP_HASH_MASK_MEM_DATA3_t              MASK_MEM_DATA3;                /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  FETOP_HASH_MASK_MEM_DATA2_t              MASK_MEM_DATA2;                /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  FETOP_HASH_MASK_MEM_DATA1_t              MASK_MEM_DATA1;                /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  FETOP_HASH_MASK_MEM_DATA0_t              MASK_MEM_DATA0;                /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  FETOP_HASH_PARITY_ERR_ADDR_MASK_MEM_t    PARITY_ERR_ADDR_MASK_MEM;      /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  FETOP_HASH_DBG_FIFO_ACCESS_t             DBG_FIFO_ACCESS;               /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  FETOP_HASH_DBG_FIFO_DATA2_t              DBG_FIFO_DATA2;                /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  FETOP_HASH_DBG_FIFO_DATA1_t              DBG_FIFO_DATA1;                /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  FETOP_HASH_DBG_FIFO_DATA0_t              DBG_FIFO_DATA0;                /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  FETOP_HASH_SUPER_HASH_t                  SUPER_HASH;                    /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  FETOP_HASH_CHECK_MEM_ACCESS_t            CHECK_MEM_ACCESS;              /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  FETOP_HASH_CHECK_MEM_DATA2_t             CHECK_MEM_DATA2;               /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  FETOP_HASH_CHECK_MEM_DATA1_t             CHECK_MEM_DATA1;               /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  FETOP_HASH_CHECK_MEM_DATA0_t             CHECK_MEM_DATA0;               /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  FETOP_HASH_PARITY_ERR_ADDR_CHECK_MEM_t   PARITY_ERR_ADDR_CHECK_MEM;     /* addr: 0x000000a8 */ 
} FETOP_HASH_t;

  

  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FETOP */

typedef struct {
  FETOP_FE_t                               FE;                            /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3769];                 
  FETOP_LPM_t                              LPM;                           /* addr: 0x00001000 */ 
  cs_uint32                                rsrvd2[3901];                 
  FETOP_HASH_t                             HASH;                          /* addr: 0x00002000 */ 
} FETOP_t;


/*
 * QM
 */
  



#define QM_CONFIG_0                              0xf0030000
#define QM_CONFIG_0_dft                          0x23282001




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 max_pkt_len          : 14 ; /* bits 29:16 */
    cs_uint32 mtu                  :  8 ; /* bits 15:8 */
    cs_uint32 egress_flow_cntl_mode :  2 ; /* bits 7:6 */
    cs_uint32 egress_flow_cntl_int_threshold :  2 ; /* bits 5:4 */
    cs_uint32 voq_disable_active   :  1 ; /* bits 3:3 */
    cs_uint32 que_age_test_enable  :  1 ; /* bits 2:2 */
    cs_uint32 pkt_age_test_enable  :  1 ; /* bits 1:1 */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
    cs_uint32 pkt_age_test_enable  :  1 ; /* bits 1:1 */
    cs_uint32 que_age_test_enable  :  1 ; /* bits 2:2 */
    cs_uint32 voq_disable_active   :  1 ; /* bits 3:3 */
    cs_uint32 egress_flow_cntl_int_threshold :  2 ; /* bits 5:4 */
    cs_uint32 egress_flow_cntl_mode :  2 ; /* bits 7:6 */
    cs_uint32 mtu                  :  8 ; /* bits 15:8 */
    cs_uint32 max_pkt_len          : 14 ; /* bits 29:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CONFIG_0_t;





#define QM_CONFIG_1                              0xf0030004
#define QM_CONFIG_1_dft                          0x00000220




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 config_spare         :  8 ; /* bits 31:24 */
    cs_uint32 rsrvd3               : 14 ;
    cs_uint32 paging_size          :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 cpu_banks            :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 mem_config           :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 mem_config           :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 cpu_banks            :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 paging_size          :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd3               : 14 ;
    cs_uint32 config_spare         :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CONFIG_1_t;





#define QM_CONFIG_2                              0xf0030008
#define QM_CONFIG_2_dft                          0x001f011f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 egress_gige_thresh   :  2 ; /* bits 20:19 */
    cs_uint32 egress_gige_mask     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd1               :  7 ;
    cs_uint32 ingress_write_timeout_control :  1 ; /* bits 8:8 */
    cs_uint32 ingress_write_timeout :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ingress_write_timeout :  8 ; /* bits 7:0 */
    cs_uint32 ingress_write_timeout_control :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd1               :  7 ;
    cs_uint32 egress_gige_mask     :  3 ; /* bits 18:16 */
    cs_uint32 egress_gige_thresh   :  2 ; /* bits 20:19 */
    cs_uint32 rsrvd2               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CONFIG_2_t;





#define QM_CONFIG_3                              0xf003000c
#define QM_CONFIG_3_dft                          0xb4cf6080




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 wready_coeff4        :  4 ; /* bits 31:28 */
    cs_uint32 wready_coeff3        :  4 ; /* bits 27:24 */
    cs_uint32 wready_coeff2        :  4 ; /* bits 23:20 */
    cs_uint32 wready_coeff1        :  4 ; /* bits 19:16 */
    cs_uint32 wready_thresh        :  8 ; /* bits 15:8 */
    cs_uint32 wready_period        :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wready_period        :  8 ; /* bits 7:0 */
    cs_uint32 wready_thresh        :  8 ; /* bits 15:8 */
    cs_uint32 wready_coeff1        :  4 ; /* bits 19:16 */
    cs_uint32 wready_coeff2        :  4 ; /* bits 23:20 */
    cs_uint32 wready_coeff3        :  4 ; /* bits 27:24 */
    cs_uint32 wready_coeff4        :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CONFIG_3_t;





#define QM_CONFIG_4                              0xf0030010
#define QM_CONFIG_4_dft                          0xb4cf6080




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 wready_coeff4        :  4 ; /* bits 31:28 */
    cs_uint32 wready_coeff3        :  4 ; /* bits 27:24 */
    cs_uint32 wready_coeff2        :  4 ; /* bits 23:20 */
    cs_uint32 wready_coeff1        :  4 ; /* bits 19:16 */
    cs_uint32 wready_thresh        :  8 ; /* bits 15:8 */
    cs_uint32 wready_period        :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wready_period        :  8 ; /* bits 7:0 */
    cs_uint32 wready_thresh        :  8 ; /* bits 15:8 */
    cs_uint32 wready_coeff1        :  4 ; /* bits 19:16 */
    cs_uint32 wready_coeff2        :  4 ; /* bits 23:20 */
    cs_uint32 wready_coeff3        :  4 ; /* bits 27:24 */
    cs_uint32 wready_coeff4        :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CONFIG_4_t;





#define QM_STATUS_0                              0xf0030014
#define QM_STATUS_0_dft                          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 buffers              :  4 ; /* bits 15:12 */
    cs_uint32 cpu_banks            :  4 ; /* bits 11:8 */
    cs_uint32 pkt_banks            :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 pkt_banks            :  4 ; /* bits 7:4 */
    cs_uint32 cpu_banks            :  4 ; /* bits 11:8 */
    cs_uint32 buffers              :  4 ; /* bits 15:12 */
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_STATUS_0_t;





#define QM_STATUS_1                              0xf0030018
#define QM_STATUS_1_dft                          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 pkt_buffer0_addr     :  7 ; /* bits 18:12 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 bytes_per_buffer     :  7 ; /* bits 10:4 */
    cs_uint32 buffers_per_bank     :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 buffers_per_bank     :  4 ; /* bits 3:0 */
    cs_uint32 bytes_per_buffer     :  7 ; /* bits 10:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pkt_buffer0_addr     :  7 ; /* bits 18:12 */
    cs_uint32 rsrvd2               : 13 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_STATUS_1_t;





#define QM_FLUSH_STATUS                          0xf003001c
#define QM_FLUSH_STATUS_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 24 ;
    cs_uint32 flush_fifo_cnt       :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 flush_active         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flush_active         :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 flush_fifo_cnt       :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd2               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_FLUSH_STATUS_t;





#define QM_INGRESS_STATUS_PRIMARY_PATH0          0xf0030020
#define QM_INGRESS_STATUS_PRIMARY_PATH0_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 drop_pkt_write_timeout_err_cnt :  4 ; /* bits 31:28 */
    cs_uint32 drop_pkt_voq_id_err_cnt :  4 ; /* bits 27:24 */
    cs_uint32 drop_pkt_no_free_buf_err_cnt :  4 ; /* bits 23:20 */
    cs_uint32 drop_pkt_buf_max_err_cnt :  4 ; /* bits 19:16 */
    cs_uint32 drop_pkt_len_max_err_cnt :  4 ; /* bits 15:12 */
    cs_uint32 drop_pkt_len_zero_err_cnt :  4 ; /* bits 11:8 */
    cs_uint32 drop_pkt_len_err_cnt :  4 ; /* bits 7:4 */
    cs_uint32 drop_pkt_eop_missing_err_cnt :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_pkt_eop_missing_err_cnt :  4 ; /* bits 3:0 */
    cs_uint32 drop_pkt_len_err_cnt :  4 ; /* bits 7:4 */
    cs_uint32 drop_pkt_len_zero_err_cnt :  4 ; /* bits 11:8 */
    cs_uint32 drop_pkt_len_max_err_cnt :  4 ; /* bits 15:12 */
    cs_uint32 drop_pkt_buf_max_err_cnt :  4 ; /* bits 19:16 */
    cs_uint32 drop_pkt_no_free_buf_err_cnt :  4 ; /* bits 23:20 */
    cs_uint32 drop_pkt_voq_id_err_cnt :  4 ; /* bits 27:24 */
    cs_uint32 drop_pkt_write_timeout_err_cnt :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INGRESS_STATUS_PRIMARY_PATH0_t;





#define QM_INGRESS_STATUS_PRIMARY_PATH1          0xf0030024
#define QM_INGRESS_STATUS_PRIMARY_PATH1_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 drop_pkt_voq_disable_id :  7 ; /* bits 22:16 */
    cs_uint32 drop_pkt_voq_disable_cnt :  8 ; /* bits 15:8 */
    cs_uint32 drop_pkt_flush_active_cnt :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_pkt_flush_active_cnt :  8 ; /* bits 7:0 */
    cs_uint32 drop_pkt_voq_disable_cnt :  8 ; /* bits 15:8 */
    cs_uint32 drop_pkt_voq_disable_id :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INGRESS_STATUS_PRIMARY_PATH1_t;





#define QM_INGRESS_STATUS_CPU_PATH0              0xf0030028
#define QM_INGRESS_STATUS_CPU_PATH0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 drop_pkt_write_timeout_err_cnt :  4 ; /* bits 31:28 */
    cs_uint32 drop_pkt_voq_id_err_cnt :  4 ; /* bits 27:24 */
    cs_uint32 drop_pkt_no_free_buf_err_cnt :  4 ; /* bits 23:20 */
    cs_uint32 drop_pkt_buf_max_err_cnt :  4 ; /* bits 19:16 */
    cs_uint32 drop_pkt_len_max_err_cnt :  4 ; /* bits 15:12 */
    cs_uint32 drop_pkt_len_zero_err_cnt :  4 ; /* bits 11:8 */
    cs_uint32 drop_pkt_len_err_cnt :  4 ; /* bits 7:4 */
    cs_uint32 drop_pkt_eop_missing_err_cnt :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_pkt_eop_missing_err_cnt :  4 ; /* bits 3:0 */
    cs_uint32 drop_pkt_len_err_cnt :  4 ; /* bits 7:4 */
    cs_uint32 drop_pkt_len_zero_err_cnt :  4 ; /* bits 11:8 */
    cs_uint32 drop_pkt_len_max_err_cnt :  4 ; /* bits 15:12 */
    cs_uint32 drop_pkt_buf_max_err_cnt :  4 ; /* bits 19:16 */
    cs_uint32 drop_pkt_no_free_buf_err_cnt :  4 ; /* bits 23:20 */
    cs_uint32 drop_pkt_voq_id_err_cnt :  4 ; /* bits 27:24 */
    cs_uint32 drop_pkt_write_timeout_err_cnt :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INGRESS_STATUS_CPU_PATH0_t;





#define QM_INGRESS_STATUS_CPU_PATH1              0xf003002c
#define QM_INGRESS_STATUS_CPU_PATH1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 drop_pkt_voq_disable_id :  7 ; /* bits 22:16 */
    cs_uint32 drop_pkt_voq_disable_cnt :  8 ; /* bits 15:8 */
    cs_uint32 drop_pkt_flush_active_cnt :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 drop_pkt_flush_active_cnt :  8 ; /* bits 7:0 */
    cs_uint32 drop_pkt_voq_disable_cnt :  8 ; /* bits 15:8 */
    cs_uint32 drop_pkt_voq_disable_id :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INGRESS_STATUS_CPU_PATH1_t;





#define QM_EGRESS_STATUS_0                       0xf0030030
#define QM_EGRESS_STATUS_0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_hdr_uncorrected_errs : 16 ; /* bits 31:16 */
    cs_uint32 pkt_hdr_corrected_errs : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_hdr_corrected_errs : 16 ; /* bits 15:0 */
    cs_uint32 pkt_hdr_uncorrected_errs : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_EGRESS_STATUS_0_t;





#define QM_EGRESS_STATUS_1                       0xf0030034
#define QM_EGRESS_STATUS_1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 egress_flush_cnt     : 16 ; /* bits 31:16 */
    cs_uint32 pkt_age_old_drop_cnt : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_age_old_drop_cnt : 16 ; /* bits 15:0 */
    cs_uint32 egress_flush_cnt     : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_EGRESS_STATUS_1_t;





#define QM_CPU_PATH_CONFIG_0                     0xf0030038
#define QM_CPU_PATH_CONFIG_0_dft                 0x23281000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 max_cpu_pkt_len      : 14 ; /* bits 29:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_buffers          : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_buffers          : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 max_cpu_pkt_len      : 14 ; /* bits 29:16 */
    cs_uint32 rsrvd2               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_CONFIG_0_t;





#define QM_CPU_PATH_CONFIG_1                     0xf003003c
#define QM_CPU_PATH_CONFIG_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 linux_2byte_align_enable :  1 ; /* bits 2:2 */
    cs_uint32 linux_mode_sch_rpt_size :  1 ; /* bits 1:1 */
    cs_uint32 linux_mode           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_mode           :  1 ; /* bits 0:0 */
    cs_uint32 linux_mode_sch_rpt_size :  1 ; /* bits 1:1 */
    cs_uint32 linux_2byte_align_enable :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_CONFIG_1_t;





#define QM_CPU_PATH_VOQ_MAP_0                    0xf0030040
#define QM_CPU_PATH_VOQ_MAP_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_0_t;





#define QM_CPU_PATH_VOQ_MAP_1                    0xf0030044
#define QM_CPU_PATH_VOQ_MAP_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_1_t;





#define QM_CPU_PATH_VOQ_MAP_2                    0xf0030048
#define QM_CPU_PATH_VOQ_MAP_2_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_2_t;





#define QM_CPU_PATH_VOQ_MAP_3                    0xf003004c
#define QM_CPU_PATH_VOQ_MAP_3_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_3_t;





#define QM_CPU_PATH_VOQ_MAP_4                    0xf0030050
#define QM_CPU_PATH_VOQ_MAP_4_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_4_t;





#define QM_CPU_PATH_VOQ_MAP_5                    0xf0030054
#define QM_CPU_PATH_VOQ_MAP_5_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_5_t;





#define QM_CPU_PATH_VOQ_MAP_6                    0xf0030058
#define QM_CPU_PATH_VOQ_MAP_6_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_6_t;





#define QM_CPU_PATH_VOQ_MAP_7                    0xf003005c
#define QM_CPU_PATH_VOQ_MAP_7_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 linux_voq_map        : 24 ; /* bits 23:0 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_VOQ_MAP_7_t;





#define QM_CPU_PATH_LINUX0_SDRAM_ADDR            0xf0030060
#define QM_CPU_PATH_LINUX0_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX0_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX1_SDRAM_ADDR            0xf0030064
#define QM_CPU_PATH_LINUX1_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX1_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX2_SDRAM_ADDR            0xf0030068
#define QM_CPU_PATH_LINUX2_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX2_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX3_SDRAM_ADDR            0xf003006c
#define QM_CPU_PATH_LINUX3_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX3_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX4_SDRAM_ADDR            0xf0030070
#define QM_CPU_PATH_LINUX4_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX4_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX5_SDRAM_ADDR            0xf0030074
#define QM_CPU_PATH_LINUX5_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX5_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX6_SDRAM_ADDR            0xf0030078
#define QM_CPU_PATH_LINUX6_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX6_SDRAM_ADDR_t;





#define QM_CPU_PATH_LINUX7_SDRAM_ADDR            0xf003007c
#define QM_CPU_PATH_LINUX7_SDRAM_ADDR_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_LINUX7_SDRAM_ADDR_t;





#define QM_CPU_PATH_STATUS_0                     0xf0030080
#define QM_CPU_PATH_STATUS_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 free_cpu_buffers     : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 sdram_addr_fifo_wr_cnt :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sdram_addr_fifo_wr_cnt :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 free_cpu_buffers     : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_STATUS_0_t;





#define QM_CPU_PATH_FREE_BUFFERS_0               0xf0030084
#define QM_CPU_PATH_FREE_BUFFERS_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux1_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux0_free_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux0_free_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux1_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_FREE_BUFFERS_0_t;





#define QM_CPU_PATH_FREE_BUFFERS_1               0xf0030088
#define QM_CPU_PATH_FREE_BUFFERS_1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux3_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux2_free_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux2_free_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux3_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_FREE_BUFFERS_1_t;





#define QM_CPU_PATH_FREE_BUFFERS_2               0xf003008c
#define QM_CPU_PATH_FREE_BUFFERS_2_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux5_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux4_free_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux4_free_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux5_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_FREE_BUFFERS_2_t;





#define QM_CPU_PATH_FREE_BUFFERS_3               0xf0030090
#define QM_CPU_PATH_FREE_BUFFERS_3_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux7_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux6_free_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux6_free_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux7_free_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_FREE_BUFFERS_3_t;





#define QM_CPU_PATH_BUFFERS_0                    0xf0030094
#define QM_CPU_PATH_BUFFERS_0_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux1_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux0_buffers   : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux0_buffers   : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux1_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_BUFFERS_0_t;





#define QM_CPU_PATH_BUFFERS_1                    0xf0030098
#define QM_CPU_PATH_BUFFERS_1_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux3_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux2_buffers   : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux2_buffers   : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux3_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_BUFFERS_1_t;





#define QM_CPU_PATH_BUFFERS_2                    0xf003009c
#define QM_CPU_PATH_BUFFERS_2_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux5_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux4_buffers   : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux4_buffers   : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux5_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_BUFFERS_2_t;





#define QM_CPU_PATH_BUFFERS_3                    0xf00300a0
#define QM_CPU_PATH_BUFFERS_3_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 cpu_linux7_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux6_buffers   : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_linux6_buffers   : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 cpu_linux7_buffers   : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_PATH_BUFFERS_3_t;





#define QM_FLUSH_VOQ                             0xf00300a4
#define QM_FLUSH_VOQ_dft                         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 pkt_hdr_err_flush_voq_id :  7 ; /* bits 22:16 */
    cs_uint32 flush_immediate      :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 flush_voq_id         :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flush_voq_id         :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 flush_immediate      :  1 ; /* bits 15:15 */
    cs_uint32 pkt_hdr_err_flush_voq_id :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_FLUSH_VOQ_t;





#define QM_RDCOM_LP_FB_TH                        0xf00300a8
#define QM_RDCOM_LP_FB_TH_dft                    0x00b4006e




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 t_high               : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 t_low                : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 t_low                : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 t_high               : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_FB_TH_t;





#define QM_RDCOM_LP_S_SAT                        0xf00300ac
#define QM_RDCOM_LP_S_SAT_dft                    0x0c1c766e




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 s_max                : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 s_min                : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 s_min                : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 s_max                : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd2               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_S_SAT_t;





#define QM_RDCOM_LP_O_SAT                        0xf00300b0
#define QM_RDCOM_LP_O_SAT_dft                    0x099273e4




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 o_mpos               : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 o_mneg               : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 o_mneg               : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 o_mpos               : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd2               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_O_SAT_t;





#define QM_RDCOM_LP_LD_TH                        0xf00300b4
#define QM_RDCOM_LP_LD_TH_dft                    0x00007e0c




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 load_thld            : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 load_thld            : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_LD_TH_t;





#define QM_RDCOM_LP_CONFIG                       0xf00300b8
#define QM_RDCOM_LP_CONFIG_dft                   0x0043533f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 s_bucket_load        :  1 ; /* bits 31:31 */
    cs_uint32 ob_bucket_load       :  1 ; /* bits 30:30 */
    cs_uint32 reset                :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd4               :  6 ;
    cs_uint32 decay_beta           :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 decay_alpha          :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 attack_beta          :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 attack_alpha         :  3 ; /* bits 10:8 */
    cs_uint32 loop_time_k          :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 loop_time_k          :  8 ; /* bits 7:0 */
    cs_uint32 attack_alpha         :  3 ; /* bits 10:8 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 attack_beta          :  3 ; /* bits 14:12 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 decay_alpha          :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 decay_beta           :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd4               :  6 ;
    cs_uint32 reset                :  1 ; /* bits 29:29 */
    cs_uint32 ob_bucket_load       :  1 ; /* bits 30:30 */
    cs_uint32 s_bucket_load        :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_CONFIG_t;





#define QM_RDCOM_LP_SO_BK                        0xf00300bc
#define QM_RDCOM_LP_SO_BK_dft                    0x00001b58




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 o_bucket             : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 s_bucket             : 15 ; /* bits 14:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 s_bucket             : 15 ; /* bits 14:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 o_bucket             : 15 ; /* bits 30:16 */
    cs_uint32 rsrvd2               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_SO_BK_t;





#define QM_RDCOM_LP_OBBK_TAV                     0xf00300c0
#define QM_RDCOM_LP_OBBK_TAV_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 t_avg                : 14 ; /* bits 31:18 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 ob_bucket            : 17 ; /* bits 16:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ob_bucket            : 17 ; /* bits 16:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 t_avg                : 14 ; /* bits 31:18 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_RDCOM_LP_OBBK_TAV_t;





#define QM_BUFFER_LIST_MEM_STATUS                0xf00300c4
#define QM_BUFFER_LIST_MEM_STATUS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 err_correct_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 err_addr             : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 err_correct_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_BUFFER_LIST_MEM_STATUS_t;





#define QM_CPU_BUFFER_LIST_MEM_STATUS            0xf00300c8
#define QM_CPU_BUFFER_LIST_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 err_correct_addr     : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 err_addr             : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 err_correct_addr     : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_BUFFER_LIST_MEM_STATUS_t;





#define QM_PROFILE_MEM_STATUS                    0xf00300cc
#define QM_PROFILE_MEM_STATUS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_PROFILE_MEM_STATUS_t;





#define QM_STATUS_MEM_STATUS                     0xf00300d0
#define QM_STATUS_MEM_STATUS_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_STATUS_MEM_STATUS_t;





#define QM_STATUS_SDRAM_ADDR_MEM_STATUS          0xf00300d4
#define QM_STATUS_SDRAM_ADDR_MEM_STATUS_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 10 ;
    cs_uint32 err_correct_addr     :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 err_addr             :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  6 ; /* bits 5:0 */
    cs_uint32 rsrvd1               : 10 ;
    cs_uint32 err_correct_addr     :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd2               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_STATUS_SDRAM_ADDR_MEM_STATUS_t;





#define QM_INT_BUFFER_LIST_MEM_STATUS            0xf00300d8
#define QM_INT_BUFFER_LIST_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 err_correct_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 err_addr             : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 err_correct_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUFFER_LIST_MEM_STATUS_t;





#define QM_PKT_AGE_OLD                           0xf00300dc
#define QM_PKT_AGE_OLD_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pkt_age_old_cnt      : 16 ; /* bits 31:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 pkt_age_old_voq      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pkt_age_old_voq      :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 pkt_age_old_cnt      : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_PKT_AGE_OLD_t;





#define QM_QUE_AGE_OLD                           0xf00300e0
#define QM_QUE_AGE_OLD_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 que_age_old_cnt      : 16 ; /* bits 31:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 que_age_old_voq      :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 que_age_old_voq      :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 que_age_old_cnt      : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_AGE_OLD_t;





#define QM_INTERRUPT_0                           0xf00300e4
#define QM_INTERRUPT_0_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 err_axi_qmcpu_write  :  1 ; /* bits 31:31 */
    cs_uint32 err_axi_qmcpu_read   :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qm_write     :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qm_read      :  1 ; /* bits 28:28 */
    cs_uint32 err_sch_intf         :  1 ; /* bits 27:27 */
    cs_uint32 err_pkt_header       :  1 ; /* bits 26:26 */
    cs_uint32 que_age_old          :  1 ; /* bits 25:25 */
    cs_uint32 pkt_age_old          :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 err_cpu_pkt_enqueue  :  1 ; /* bits 22:22 */
    cs_uint32 cpu_voq_disable      :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_buffer_underrun :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_pkt_enqueue      :  1 ; /* bits 18:18 */
    cs_uint32 voq_disable          :  1 ; /* bits 17:17 */
    cs_uint32 err_buffer_underrun  :  1 ; /* bits 16:16 */
    cs_uint32 err_axi_intmem_write :  1 ; /* bits 15:15 */
    cs_uint32 err_axi_intmem_read  :  1 ; /* bits 14:14 */
    cs_uint32 flush_complete       :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 err_correct_int_buffer_list_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_int_buffer_list_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_status_sdram_addr_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_status_sdram_addr_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_status_mem       :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_profile_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_profile_mem      :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_cpu_buffer_list_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_cpu_buffer_list_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_buffer_list_mem :  1 ; /* bits 1:1 */
    cs_uint32 err_buffer_list_mem  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_buffer_list_mem  :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_buffer_list_mem :  1 ; /* bits 1:1 */
    cs_uint32 err_cpu_buffer_list_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_cpu_buffer_list_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_profile_mem      :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_profile_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_status_mem       :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_status_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_status_sdram_addr_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_sdram_addr_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_int_buffer_list_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_int_buffer_list_mem :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 flush_complete       :  1 ; /* bits 13:13 */
    cs_uint32 err_axi_intmem_read  :  1 ; /* bits 14:14 */
    cs_uint32 err_axi_intmem_write :  1 ; /* bits 15:15 */
    cs_uint32 err_buffer_underrun  :  1 ; /* bits 16:16 */
    cs_uint32 voq_disable          :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_enqueue      :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_cpu_buffer_underrun :  1 ; /* bits 20:20 */
    cs_uint32 cpu_voq_disable      :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_pkt_enqueue  :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 pkt_age_old          :  1 ; /* bits 24:24 */
    cs_uint32 que_age_old          :  1 ; /* bits 25:25 */
    cs_uint32 err_pkt_header       :  1 ; /* bits 26:26 */
    cs_uint32 err_sch_intf         :  1 ; /* bits 27:27 */
    cs_uint32 err_axi_qm_read      :  1 ; /* bits 28:28 */
    cs_uint32 err_axi_qm_write     :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qmcpu_read   :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qmcpu_write  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INTERRUPT_0_t;





#define QM_INTENABLE_0                           0xf00300e8
#define QM_INTENABLE_0_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 err_axi_qmcpu_write_en :  1 ; /* bits 31:31 */
    cs_uint32 err_axi_qmcpu_read_en :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qm_write_en  :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qm_read_en   :  1 ; /* bits 28:28 */
    cs_uint32 err_sch_intf_en      :  1 ; /* bits 27:27 */
    cs_uint32 err_pkt_header_en    :  1 ; /* bits 26:26 */
    cs_uint32 que_age_old_en       :  1 ; /* bits 25:25 */
    cs_uint32 pkt_age_old_en       :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 err_cpu_pkt_enqueue_en :  1 ; /* bits 22:22 */
    cs_uint32 cpu_voq_disable_en   :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_buffer_underrun_en :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_pkt_enqueue_en   :  1 ; /* bits 18:18 */
    cs_uint32 voq_disable_en       :  1 ; /* bits 17:17 */
    cs_uint32 err_buffer_underrun_en :  1 ; /* bits 16:16 */
    cs_uint32 err_axi_intmem_write_en :  1 ; /* bits 15:15 */
    cs_uint32 err_axi_intmem_read_en :  1 ; /* bits 14:14 */
    cs_uint32 flush_complete_en    :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 err_correct_int_buffer_list_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_int_buffer_list_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_status_sdram_addr_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_status_sdram_addr_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_status_mem_en    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_profile_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_profile_mem_en   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_cpu_buffer_list_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_cpu_buffer_list_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_buffer_list_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_buffer_list_mem_en :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_buffer_list_mem_en :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_buffer_list_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_cpu_buffer_list_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_cpu_buffer_list_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_profile_mem_en   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_profile_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_status_mem_en    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_status_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_status_sdram_addr_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_sdram_addr_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_int_buffer_list_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_int_buffer_list_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 flush_complete_en    :  1 ; /* bits 13:13 */
    cs_uint32 err_axi_intmem_read_en :  1 ; /* bits 14:14 */
    cs_uint32 err_axi_intmem_write_en :  1 ; /* bits 15:15 */
    cs_uint32 err_buffer_underrun_en :  1 ; /* bits 16:16 */
    cs_uint32 voq_disable_en       :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_enqueue_en   :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_cpu_buffer_underrun_en :  1 ; /* bits 20:20 */
    cs_uint32 cpu_voq_disable_en   :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_pkt_enqueue_en :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 pkt_age_old_en       :  1 ; /* bits 24:24 */
    cs_uint32 que_age_old_en       :  1 ; /* bits 25:25 */
    cs_uint32 err_pkt_header_en    :  1 ; /* bits 26:26 */
    cs_uint32 err_sch_intf_en      :  1 ; /* bits 27:27 */
    cs_uint32 err_axi_qm_read_en   :  1 ; /* bits 28:28 */
    cs_uint32 err_axi_qm_write_en  :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qmcpu_read_en :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qmcpu_write_en :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INTENABLE_0_t;





#define QM_INTERRUPT_1                           0xf00300ec
#define QM_INTERRUPT_1_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 err_axi_qmcpu_write  :  1 ; /* bits 31:31 */
    cs_uint32 err_axi_qmcpu_read   :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qm_write     :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qm_read      :  1 ; /* bits 28:28 */
    cs_uint32 err_sch_intf         :  1 ; /* bits 27:27 */
    cs_uint32 err_pkt_header       :  1 ; /* bits 26:26 */
    cs_uint32 que_age_old          :  1 ; /* bits 25:25 */
    cs_uint32 pkt_age_old          :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 err_cpu_pkt_enqueue  :  1 ; /* bits 22:22 */
    cs_uint32 cpu_voq_disable      :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_buffer_underrun :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_pkt_enqueue      :  1 ; /* bits 18:18 */
    cs_uint32 voq_disable          :  1 ; /* bits 17:17 */
    cs_uint32 err_buffer_underrun  :  1 ; /* bits 16:16 */
    cs_uint32 err_axi_intmem_write :  1 ; /* bits 15:15 */
    cs_uint32 err_axi_intmem_read  :  1 ; /* bits 14:14 */
    cs_uint32 flush_complete       :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 err_correct_int_buffer_list_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_int_buffer_list_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_status_sdram_addr_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_status_sdram_addr_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_status_mem       :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_profile_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_profile_mem      :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_cpu_buffer_list_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_cpu_buffer_list_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_buffer_list_mem :  1 ; /* bits 1:1 */
    cs_uint32 err_buffer_list_mem  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_buffer_list_mem  :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_buffer_list_mem :  1 ; /* bits 1:1 */
    cs_uint32 err_cpu_buffer_list_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_cpu_buffer_list_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_profile_mem      :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_profile_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_status_mem       :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_status_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_status_sdram_addr_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_sdram_addr_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_int_buffer_list_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_int_buffer_list_mem :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 flush_complete       :  1 ; /* bits 13:13 */
    cs_uint32 err_axi_intmem_read  :  1 ; /* bits 14:14 */
    cs_uint32 err_axi_intmem_write :  1 ; /* bits 15:15 */
    cs_uint32 err_buffer_underrun  :  1 ; /* bits 16:16 */
    cs_uint32 voq_disable          :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_enqueue      :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_cpu_buffer_underrun :  1 ; /* bits 20:20 */
    cs_uint32 cpu_voq_disable      :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_pkt_enqueue  :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 pkt_age_old          :  1 ; /* bits 24:24 */
    cs_uint32 que_age_old          :  1 ; /* bits 25:25 */
    cs_uint32 err_pkt_header       :  1 ; /* bits 26:26 */
    cs_uint32 err_sch_intf         :  1 ; /* bits 27:27 */
    cs_uint32 err_axi_qm_read      :  1 ; /* bits 28:28 */
    cs_uint32 err_axi_qm_write     :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qmcpu_read   :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qmcpu_write  :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INTERRUPT_1_t;





#define QM_INTENABLE_1                           0xf00300f0
#define QM_INTENABLE_1_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 err_axi_qmcpu_write_en :  1 ; /* bits 31:31 */
    cs_uint32 err_axi_qmcpu_read_en :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qm_write_en  :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qm_read_en   :  1 ; /* bits 28:28 */
    cs_uint32 err_sch_intf_en      :  1 ; /* bits 27:27 */
    cs_uint32 err_pkt_header_en    :  1 ; /* bits 26:26 */
    cs_uint32 que_age_old_en       :  1 ; /* bits 25:25 */
    cs_uint32 pkt_age_old_en       :  1 ; /* bits 24:24 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 err_cpu_pkt_enqueue_en :  1 ; /* bits 22:22 */
    cs_uint32 cpu_voq_disable_en   :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_buffer_underrun_en :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_pkt_enqueue_en   :  1 ; /* bits 18:18 */
    cs_uint32 voq_disable_en       :  1 ; /* bits 17:17 */
    cs_uint32 err_buffer_underrun_en :  1 ; /* bits 16:16 */
    cs_uint32 err_axi_intmem_write_en :  1 ; /* bits 15:15 */
    cs_uint32 err_axi_intmem_read_en :  1 ; /* bits 14:14 */
    cs_uint32 flush_complete_en    :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 err_correct_int_buffer_list_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_int_buffer_list_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_status_sdram_addr_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_status_sdram_addr_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_status_mem_en    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_profile_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_profile_mem_en   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_cpu_buffer_list_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_cpu_buffer_list_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_buffer_list_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_buffer_list_mem_en :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_buffer_list_mem_en :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_buffer_list_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_cpu_buffer_list_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_cpu_buffer_list_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_profile_mem_en   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_profile_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_status_mem_en    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_status_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_status_sdram_addr_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_status_sdram_addr_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_int_buffer_list_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_int_buffer_list_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 flush_complete_en    :  1 ; /* bits 13:13 */
    cs_uint32 err_axi_intmem_read_en :  1 ; /* bits 14:14 */
    cs_uint32 err_axi_intmem_write_en :  1 ; /* bits 15:15 */
    cs_uint32 err_buffer_underrun_en :  1 ; /* bits 16:16 */
    cs_uint32 voq_disable_en       :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_enqueue_en   :  1 ; /* bits 18:18 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 err_cpu_buffer_underrun_en :  1 ; /* bits 20:20 */
    cs_uint32 cpu_voq_disable_en   :  1 ; /* bits 21:21 */
    cs_uint32 err_cpu_pkt_enqueue_en :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 pkt_age_old_en       :  1 ; /* bits 24:24 */
    cs_uint32 que_age_old_en       :  1 ; /* bits 25:25 */
    cs_uint32 err_pkt_header_en    :  1 ; /* bits 26:26 */
    cs_uint32 err_sch_intf_en      :  1 ; /* bits 27:27 */
    cs_uint32 err_axi_qm_read_en   :  1 ; /* bits 28:28 */
    cs_uint32 err_axi_qm_write_en  :  1 ; /* bits 29:29 */
    cs_uint32 err_axi_qmcpu_read_en :  1 ; /* bits 30:30 */
    cs_uint32 err_axi_qmcpu_write_en :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INTENABLE_1_t;





#define QM_DV_CNTL                               0xf00300f4
#define QM_DV_CNTL_dft                           0x00000542




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 19 ;
    cs_uint32 burst_size_2x        :  1 ; /* bits 12:12 */
    cs_uint32 oversize_burst_size_gte_128 :  2 ; /* bits 11:10 */
    cs_uint32 oversize_burst_size_le_128 :  2 ; /* bits 9:8 */
    cs_uint32 oversize_burst_enable :  1 ; /* bits 7:7 */
    cs_uint32 small_packet_burst_alert_enable :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 hdr_err_gen_active   :  1 ; /* bits 4:4 */
    cs_uint32 age_time_warp        :  1 ; /* bits 3:3 */
    cs_uint32 ingress_disable_fifo_read :  1 ; /* bits 2:2 */
    cs_uint32 cpu_path_enable      :  1 ; /* bits 1:1 */
    cs_uint32 egress_cntl_hold_idle :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 egress_cntl_hold_idle :  1 ; /* bits 0:0 */
    cs_uint32 cpu_path_enable      :  1 ; /* bits 1:1 */
    cs_uint32 ingress_disable_fifo_read :  1 ; /* bits 2:2 */
    cs_uint32 age_time_warp        :  1 ; /* bits 3:3 */
    cs_uint32 hdr_err_gen_active   :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 small_packet_burst_alert_enable :  1 ; /* bits 6:6 */
    cs_uint32 oversize_burst_enable :  1 ; /* bits 7:7 */
    cs_uint32 oversize_burst_size_le_128 :  2 ; /* bits 9:8 */
    cs_uint32 oversize_burst_size_gte_128 :  2 ; /* bits 11:10 */
    cs_uint32 burst_size_2x        :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd2               : 19 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_DV_CNTL_t;





#define QM_INT_BUF_CONFIG_0                      0xf00300f8
#define QM_INT_BUF_CONFIG_0_dft                  0x03ff0001




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  5 ;
    cs_uint32 last_buffer_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 first_buffer_addr    : 11 ; /* bits 14:4 */
    cs_uint32 use_internal_voq_enable :  1 ; /* bits 3:3 */
    cs_uint32 use_internal_for_recirc :  1 ; /* bits 2:2 */
    cs_uint32 use_internal         :  1 ; /* bits 1:1 */
    cs_uint32 buffer_size          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 buffer_size          :  1 ; /* bits 0:0 */
    cs_uint32 use_internal         :  1 ; /* bits 1:1 */
    cs_uint32 use_internal_for_recirc :  1 ; /* bits 2:2 */
    cs_uint32 use_internal_voq_enable :  1 ; /* bits 3:3 */
    cs_uint32 first_buffer_addr    : 11 ; /* bits 14:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 last_buffer_addr     : 11 ; /* bits 26:16 */
    cs_uint32 rsrvd2               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUF_CONFIG_0_t;





#define QM_INT_BUF_CONFIG_1                      0xf00300fc
#define QM_INT_BUF_CONFIG_1_dft                  0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 intmem_sel_root      :  8 ; /* bits 31:24 */
    cs_uint32 intmem_sel_uni2      :  8 ; /* bits 23:16 */
    cs_uint32 intmem_sel_uni1      :  8 ; /* bits 15:8 */
    cs_uint32 intmem_sel_uni0      :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 intmem_sel_uni0      :  8 ; /* bits 7:0 */
    cs_uint32 intmem_sel_uni1      :  8 ; /* bits 15:8 */
    cs_uint32 intmem_sel_uni2      :  8 ; /* bits 23:16 */
    cs_uint32 intmem_sel_root      :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUF_CONFIG_1_t;





#define QM_INT_BUF_STATUS_0                      0xf0030100
#define QM_INT_BUF_STATUS_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               : 16 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUF_STATUS_0_t;





#define QM_SCH_INTF_STATUS                       0xf0030104
#define QM_SCH_INTF_STATUS_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 error_voq            :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 deque_pending_err    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 deque_pending_err    :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 15 ;
    cs_uint32 error_voq            :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_SCH_INTF_STATUS_t;





#define QM_INT_BUFFER_LIST_MEM_ACCESS            0xf0030190
#define QM_INT_BUFFER_LIST_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 addr                 : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUFFER_LIST_MEM_ACCESS_t;





#define QM_INT_BUFFER_LIST_MEM_DATA              0xf0030194
#define QM_INT_BUFFER_LIST_MEM_DATA_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 data                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_INT_BUFFER_LIST_MEM_DATA_t;





#define QM_BUFFER_LIST_MEM_ACCESS                0xf00301a0
#define QM_BUFFER_LIST_MEM_ACCESS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 addr                 : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_BUFFER_LIST_MEM_ACCESS_t;





#define QM_BUFFER_LIST_MEM_DATA                  0xf00301a4
#define QM_BUFFER_LIST_MEM_DATA_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 data                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_BUFFER_LIST_MEM_DATA_t;





#define QM_CPU_BUFFER_LIST_MEM_ACCESS            0xf00301b0
#define QM_CPU_BUFFER_LIST_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_BUFFER_LIST_MEM_ACCESS_t;





#define QM_CPU_BUFFER_LIST_MEM_DATA1             0xf00301b4
#define QM_CPU_BUFFER_LIST_MEM_DATA1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 data                 : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 11 ; /* bits 10:0 */
    cs_uint32 rsrvd1               : 21 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_BUFFER_LIST_MEM_DATA1_t;





#define QM_CPU_BUFFER_LIST_MEM_DATA0             0xf00301b8
#define QM_CPU_BUFFER_LIST_MEM_DATA0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_CPU_BUFFER_LIST_MEM_DATA0_t;





#define QM_QUE_PROFILE_MEM_ACCESS                0xf00301c0
#define QM_QUE_PROFILE_MEM_ACCESS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_PROFILE_MEM_ACCESS_t;





#define QM_QUE_PROFILE_MEM_DATA                  0xf00301c4
#define QM_QUE_PROFILE_MEM_DATA_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 data                 : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_PROFILE_MEM_DATA_t;





#define QM_QUE_STATUS_MEM_ACCESS                 0xf00301d0
#define QM_QUE_STATUS_MEM_ACCESS_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_STATUS_MEM_ACCESS_t;





#define QM_QUE_STATUS_MEM_DATA3                  0xf00301d4
#define QM_QUE_STATUS_MEM_DATA3_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 data                 : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 27 ; /* bits 26:0 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_STATUS_MEM_DATA3_t;





#define QM_QUE_STATUS_MEM_DATA2                  0xf00301d8
#define QM_QUE_STATUS_MEM_DATA2_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_STATUS_MEM_DATA2_t;





#define QM_QUE_STATUS_MEM_DATA1                  0xf00301dc
#define QM_QUE_STATUS_MEM_DATA1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_STATUS_MEM_DATA1_t;





#define QM_QUE_STATUS_MEM_DATA0                  0xf00301e0
#define QM_QUE_STATUS_MEM_DATA0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_QUE_STATUS_MEM_DATA0_t;





#define QM_DV_REGS_ACCESS                        0xf00301f0
#define QM_DV_REGS_ACCESS_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  9 ; /* bits 8:0 */
    cs_uint32 rsrvd1               : 21 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_DV_REGS_ACCESS_t;





#define QM_DV_REGS_DATA                          0xf00301f4
#define QM_DV_REGS_DATA_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_DV_REGS_DATA_t;





#define QM_SPARE                                 0xf00301f8
#define QM_SPARE_dft                             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 spare                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 spare                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} QM_SPARE_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* QM */

typedef struct {
  QM_CONFIG_0_t                            CONFIG_0;                      /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  QM_CONFIG_1_t                            CONFIG_1;                      /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  QM_CONFIG_2_t                            CONFIG_2;                      /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  QM_CONFIG_3_t                            CONFIG_3;                      /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  QM_CONFIG_4_t                            CONFIG_4;                      /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  QM_STATUS_0_t                            STATUS_0;                      /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  QM_STATUS_1_t                            STATUS_1;                      /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  QM_FLUSH_STATUS_t                        FLUSH_STATUS;                  /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  QM_INGRESS_STATUS_PRIMARY_PATH0_t        INGRESS_STATUS_PRIMARY_PATH0;  /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  QM_INGRESS_STATUS_PRIMARY_PATH1_t        INGRESS_STATUS_PRIMARY_PATH1;  /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  QM_INGRESS_STATUS_CPU_PATH0_t            INGRESS_STATUS_CPU_PATH0;      /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  QM_INGRESS_STATUS_CPU_PATH1_t            INGRESS_STATUS_CPU_PATH1;      /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  QM_EGRESS_STATUS_0_t                     EGRESS_STATUS_0;               /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  QM_EGRESS_STATUS_1_t                     EGRESS_STATUS_1;               /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  QM_CPU_PATH_CONFIG_0_t                   CPU_PATH_CONFIG_0;             /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  QM_CPU_PATH_CONFIG_1_t                   CPU_PATH_CONFIG_1;             /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  QM_CPU_PATH_VOQ_MAP_0_t                  CPU_PATH_VOQ_MAP_0;            /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  QM_CPU_PATH_VOQ_MAP_1_t                  CPU_PATH_VOQ_MAP_1;            /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  QM_CPU_PATH_VOQ_MAP_2_t                  CPU_PATH_VOQ_MAP_2;            /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  QM_CPU_PATH_VOQ_MAP_3_t                  CPU_PATH_VOQ_MAP_3;            /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  QM_CPU_PATH_VOQ_MAP_4_t                  CPU_PATH_VOQ_MAP_4;            /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  QM_CPU_PATH_VOQ_MAP_5_t                  CPU_PATH_VOQ_MAP_5;            /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  QM_CPU_PATH_VOQ_MAP_6_t                  CPU_PATH_VOQ_MAP_6;            /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  QM_CPU_PATH_VOQ_MAP_7_t                  CPU_PATH_VOQ_MAP_7;            /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  QM_CPU_PATH_LINUX0_SDRAM_ADDR_t          CPU_PATH_LINUX0_SDRAM_ADDR;    /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  QM_CPU_PATH_LINUX1_SDRAM_ADDR_t          CPU_PATH_LINUX1_SDRAM_ADDR;    /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  QM_CPU_PATH_LINUX2_SDRAM_ADDR_t          CPU_PATH_LINUX2_SDRAM_ADDR;    /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  QM_CPU_PATH_LINUX3_SDRAM_ADDR_t          CPU_PATH_LINUX3_SDRAM_ADDR;    /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  QM_CPU_PATH_LINUX4_SDRAM_ADDR_t          CPU_PATH_LINUX4_SDRAM_ADDR;    /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  QM_CPU_PATH_LINUX5_SDRAM_ADDR_t          CPU_PATH_LINUX5_SDRAM_ADDR;    /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  QM_CPU_PATH_LINUX6_SDRAM_ADDR_t          CPU_PATH_LINUX6_SDRAM_ADDR;    /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  QM_CPU_PATH_LINUX7_SDRAM_ADDR_t          CPU_PATH_LINUX7_SDRAM_ADDR;    /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  QM_CPU_PATH_STATUS_0_t                   CPU_PATH_STATUS_0;             /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  QM_CPU_PATH_FREE_BUFFERS_0_t             CPU_PATH_FREE_BUFFERS_0;       /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  QM_CPU_PATH_FREE_BUFFERS_1_t             CPU_PATH_FREE_BUFFERS_1;       /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  QM_CPU_PATH_FREE_BUFFERS_2_t             CPU_PATH_FREE_BUFFERS_2;       /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  QM_CPU_PATH_FREE_BUFFERS_3_t             CPU_PATH_FREE_BUFFERS_3;       /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  QM_CPU_PATH_BUFFERS_0_t                  CPU_PATH_BUFFERS_0;            /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  QM_CPU_PATH_BUFFERS_1_t                  CPU_PATH_BUFFERS_1;            /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  QM_CPU_PATH_BUFFERS_2_t                  CPU_PATH_BUFFERS_2;            /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  QM_CPU_PATH_BUFFERS_3_t                  CPU_PATH_BUFFERS_3;            /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  QM_FLUSH_VOQ_t                           FLUSH_VOQ;                     /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  QM_RDCOM_LP_FB_TH_t                      RDCOM_LP_FB_TH;                /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  QM_RDCOM_LP_S_SAT_t                      RDCOM_LP_S_SAT;                /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  QM_RDCOM_LP_O_SAT_t                      RDCOM_LP_O_SAT;                /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  QM_RDCOM_LP_LD_TH_t                      RDCOM_LP_LD_TH;                /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  QM_RDCOM_LP_CONFIG_t                     RDCOM_LP_CONFIG;               /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  QM_RDCOM_LP_SO_BK_t                      RDCOM_LP_SO_BK;                /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  QM_RDCOM_LP_OBBK_TAV_t                   RDCOM_LP_OBBK_TAV;             /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  QM_BUFFER_LIST_MEM_STATUS_t              BUFFER_LIST_MEM_STATUS;        /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  QM_CPU_BUFFER_LIST_MEM_STATUS_t          CPU_BUFFER_LIST_MEM_STATUS;    /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  QM_PROFILE_MEM_STATUS_t                  PROFILE_MEM_STATUS;            /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  QM_STATUS_MEM_STATUS_t                   STATUS_MEM_STATUS;             /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  QM_STATUS_SDRAM_ADDR_MEM_STATUS_t        STATUS_SDRAM_ADDR_MEM_STATUS;  /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  QM_INT_BUFFER_LIST_MEM_STATUS_t          INT_BUFFER_LIST_MEM_STATUS;    /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd55[3];                   
  QM_PKT_AGE_OLD_t                         PKT_AGE_OLD;                   /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd56[3];                   
  QM_QUE_AGE_OLD_t                         QUE_AGE_OLD;                   /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd57[3];                   
  QM_INTERRUPT_0_t                         INTERRUPT_0;                   /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd58[3];                   
  QM_INTENABLE_0_t                         INTENABLE_0;                   /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd59[3];                   
  QM_INTERRUPT_1_t                         INTERRUPT_1;                   /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd60[3];                   
  QM_INTENABLE_1_t                         INTENABLE_1;                   /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd61[3];                   
  QM_DV_CNTL_t                             DV_CNTL;                       /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd62[3];                   
  QM_INT_BUF_CONFIG_0_t                    INT_BUF_CONFIG_0;              /* addr: 0x000000f8 */ 
  cs_uint32                                rsrvd63[3];                   
  QM_INT_BUF_CONFIG_1_t                    INT_BUF_CONFIG_1;              /* addr: 0x000000fc */ 
  cs_uint32                                rsrvd64[3];                   
  QM_INT_BUF_STATUS_0_t                    INT_BUF_STATUS_0;              /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd65[3];                   
  QM_SCH_INTF_STATUS_t                     SCH_INTF_STATUS;               /* addr: 0x00000104 */ 
  cs_uint32                                rsrvd66[139];                 
  QM_INT_BUFFER_LIST_MEM_ACCESS_t          INT_BUFFER_LIST_MEM_ACCESS;    /* addr: 0x00000190 */ 
  cs_uint32                                rsrvd67[3];                   
  QM_INT_BUFFER_LIST_MEM_DATA_t            INT_BUFFER_LIST_MEM_DATA;      /* addr: 0x00000194 */ 
  cs_uint32                                rsrvd68[11];                  
  QM_BUFFER_LIST_MEM_ACCESS_t              BUFFER_LIST_MEM_ACCESS;        /* addr: 0x000001a0 */ 
  cs_uint32                                rsrvd69[3];                   
  QM_BUFFER_LIST_MEM_DATA_t                BUFFER_LIST_MEM_DATA;          /* addr: 0x000001a4 */ 
  cs_uint32                                rsrvd70[11];                  
  QM_CPU_BUFFER_LIST_MEM_ACCESS_t          CPU_BUFFER_LIST_MEM_ACCESS;    /* addr: 0x000001b0 */ 
  cs_uint32                                rsrvd71[3];                   
  QM_CPU_BUFFER_LIST_MEM_DATA1_t           CPU_BUFFER_LIST_MEM_DATA1;     /* addr: 0x000001b4 */ 
  cs_uint32                                rsrvd72[3];                   
  QM_CPU_BUFFER_LIST_MEM_DATA0_t           CPU_BUFFER_LIST_MEM_DATA0;     /* addr: 0x000001b8 */ 
  cs_uint32                                rsrvd73[7];                   
  QM_QUE_PROFILE_MEM_ACCESS_t              QUE_PROFILE_MEM_ACCESS;        /* addr: 0x000001c0 */ 
  cs_uint32                                rsrvd74[3];                   
  QM_QUE_PROFILE_MEM_DATA_t                QUE_PROFILE_MEM_DATA;          /* addr: 0x000001c4 */ 
  cs_uint32                                rsrvd75[11];                  
  QM_QUE_STATUS_MEM_ACCESS_t               QUE_STATUS_MEM_ACCESS;         /* addr: 0x000001d0 */ 
  cs_uint32                                rsrvd76[3];                   
  QM_QUE_STATUS_MEM_DATA3_t                QUE_STATUS_MEM_DATA3;          /* addr: 0x000001d4 */ 
  cs_uint32                                rsrvd77[3];                   
  QM_QUE_STATUS_MEM_DATA2_t                QUE_STATUS_MEM_DATA2;          /* addr: 0x000001d8 */ 
  cs_uint32                                rsrvd78[3];                   
  QM_QUE_STATUS_MEM_DATA1_t                QUE_STATUS_MEM_DATA1;          /* addr: 0x000001dc */ 
  cs_uint32                                rsrvd79[3];                   
  QM_QUE_STATUS_MEM_DATA0_t                QUE_STATUS_MEM_DATA0;          /* addr: 0x000001e0 */ 
  cs_uint32                                rsrvd80[15];                  
  QM_DV_REGS_ACCESS_t                      DV_REGS_ACCESS;                /* addr: 0x000001f0 */ 
  cs_uint32                                rsrvd81[3];                   
  QM_DV_REGS_DATA_t                        DV_REGS_DATA;                  /* addr: 0x000001f4 */ 
  cs_uint32                                rsrvd82[3];                   
  QM_SPARE_t                               SPARE;                         /* addr: 0x000001f8 */ 
} QM_t;

  

/*
 * TM
 */
  
  
/*
 * BM
 */
  



#define TM_BM_CONFIG_0                           0xf0040000
#define TM_BM_CONFIG_0_dft                       0x00000341




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
    cs_uint32 disable              :  1 ; /* bits 30:30 */
    cs_uint32 recalculate_global_buffers_used :  1 ; /* bits 29:29 */
    cs_uint32 config_spare         : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd3               :  3 ;
    cs_uint32 recirc_buffer_disable :  1 ; /* bits 12:12 */
    cs_uint32 recirc_disable       :  1 ; /* bits 11:11 */
    cs_uint32 bm2_bypass_ca_process :  1 ; /* bits 10:10 */
    cs_uint32 bm2_bypass_dest_port_process :  1 ; /* bits 9:9 */
    cs_uint32 bm2_bypass_voq_process :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 bm1_bypass_ca_process :  1 ; /* bits 6:6 */
    cs_uint32 bm1_bypass_dest_port_process :  1 ; /* bits 5:5 */
    cs_uint32 bm1_bypass_voq_process :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 enque_hdr_adjust     :  1 ; /* bits 1:1 */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
    cs_uint32 enque_hdr_adjust     :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 bm1_bypass_voq_process :  1 ; /* bits 4:4 */
    cs_uint32 bm1_bypass_dest_port_process :  1 ; /* bits 5:5 */
    cs_uint32 bm1_bypass_ca_process :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 bm2_bypass_voq_process :  1 ; /* bits 8:8 */
    cs_uint32 bm2_bypass_dest_port_process :  1 ; /* bits 9:9 */
    cs_uint32 bm2_bypass_ca_process :  1 ; /* bits 10:10 */
    cs_uint32 recirc_disable       :  1 ; /* bits 11:11 */
    cs_uint32 recirc_buffer_disable :  1 ; /* bits 12:12 */
    cs_uint32 rsrvd3               :  3 ;
    cs_uint32 config_spare         : 13 ; /* bits 28:16 */
    cs_uint32 recalculate_global_buffers_used :  1 ; /* bits 29:29 */
    cs_uint32 disable              :  1 ; /* bits 30:30 */
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_CONFIG_0_t;





#define TM_BM_STATUS_0                           0xf0040004
#define TM_BM_STATUS_0_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 recalculate_global_buffers_used_active :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 recalculate_global_buffers_used_active :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd2               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_STATUS_0_t;





#define TM_BM_STATUS_1                           0xf0040008
#define TM_BM_STATUS_1_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 buffers              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 buffers              : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_STATUS_1_t;





#define TM_BM_STATUS_2                           0xf004000c
#define TM_BM_STATUS_2_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_global_buffers  : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 global_buffers       : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 global_buffers       : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 free_global_buffers  : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_STATUS_2_t;





#define TM_BM_RESERVE_BUFFERS                    0xf0040010
#define TM_BM_RESERVE_BUFFERS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 10 ;
    cs_uint32 reserve_buffers_inflight_pkts :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 reserve_buffers      : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_buffers      : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 reserve_buffers_inflight_pkts :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd2               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_BUFFERS_t;





#define TM_BM_RESERVE_CPU_BUFFERS                0xf0040014
#define TM_BM_RESERVE_CPU_BUFFERS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 reserve_cpu_buffers  : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_cpu_buffers  : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 19 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_CPU_BUFFERS_t;





#define TM_BM_RESERVE_LINUX_BUFFERS_0            0xf0040018
#define TM_BM_RESERVE_LINUX_BUFFERS_0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 reserve_linux1_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux0_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_linux0_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux1_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_LINUX_BUFFERS_0_t;





#define TM_BM_RESERVE_LINUX_BUFFERS_1            0xf004001c
#define TM_BM_RESERVE_LINUX_BUFFERS_1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 reserve_linux3_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux2_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_linux2_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux3_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_LINUX_BUFFERS_1_t;





#define TM_BM_RESERVE_LINUX_BUFFERS_2            0xf0040020
#define TM_BM_RESERVE_LINUX_BUFFERS_2_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 reserve_linux5_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux4_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_linux4_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux5_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_LINUX_BUFFERS_2_t;





#define TM_BM_RESERVE_LINUX_BUFFERS_3            0xf0040024
#define TM_BM_RESERVE_LINUX_BUFFERS_3_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 reserve_linux7_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux6_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_linux6_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 reserve_linux7_buffers : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_LINUX_BUFFERS_3_t;





#define TM_BM_WRED_CONFIG_0                      0xf0040028
#define TM_BM_WRED_CONFIG_0_dft                  0x00004000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 wred_ad_update_period : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wred_ad_update_period : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_WRED_CONFIG_0_t;





#define TM_BM_WRED_CONFIG_1                      0xf004002c
#define TM_BM_WRED_CONFIG_1_dft                  0x00000010




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 16 ;
    cs_uint32 wred_profile_select_mode :  2 ; /* bits 15:14 */
    cs_uint32 wred_ad_grt_ad_max_mode :  1 ; /* bits 13:13 */
    cs_uint32 wred_buffer_alloc_only :  1 ; /* bits 12:12 */
    cs_uint32 wred_agbd_weight     :  4 ; /* bits 11:8 */
    cs_uint32 wred_drop_mark_mode  :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 wred_ad_update_mode  :  1 ; /* bits 5:5 */
    cs_uint32 wred_mode            :  2 ; /* bits 4:3 */
    cs_uint32 wred_adjust_range_index :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wred_adjust_range_index :  3 ; /* bits 2:0 */
    cs_uint32 wred_mode            :  2 ; /* bits 4:3 */
    cs_uint32 wred_ad_update_mode  :  1 ; /* bits 5:5 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 wred_drop_mark_mode  :  1 ; /* bits 7:7 */
    cs_uint32 wred_agbd_weight     :  4 ; /* bits 11:8 */
    cs_uint32 wred_buffer_alloc_only :  1 ; /* bits 12:12 */
    cs_uint32 wred_ad_grt_ad_max_mode :  1 ; /* bits 13:13 */
    cs_uint32 wred_profile_select_mode :  2 ; /* bits 15:14 */
    cs_uint32 rsrvd2               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_WRED_CONFIG_1_t;





#define TM_BM_COPY_WRED_PROFILE                  0xf0040030
#define TM_BM_COPY_WRED_PROFILE_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 wred_aqd_max_drop_probability :  3 ; /* bits 22:20 */
    cs_uint32 wred_aqd_max_pct_buffers0 :  5 ; /* bits 19:15 */
    cs_uint32 wred_aqd_min_pct_buffers0 :  5 ; /* bits 14:10 */
    cs_uint32 wred_aqd_max_pct_baseline :  5 ; /* bits 9:5 */
    cs_uint32 wred_aqd_min_pct_baseline :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wred_aqd_min_pct_baseline :  5 ; /* bits 4:0 */
    cs_uint32 wred_aqd_max_pct_baseline :  5 ; /* bits 9:5 */
    cs_uint32 wred_aqd_min_pct_buffers0 :  5 ; /* bits 14:10 */
    cs_uint32 wred_aqd_max_pct_buffers0 :  5 ; /* bits 19:15 */
    cs_uint32 wred_aqd_max_drop_probability :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_COPY_WRED_PROFILE_t;





#define TM_BM_COPY_DEST_PORT                     0xf0040034
#define TM_BM_COPY_DEST_PORT_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 dest_port_addr       :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dest_port_addr       :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_COPY_DEST_PORT_t;





#define TM_BM_TRAFFIC_CONTROL_0                  0xf0040038
#define TM_BM_TRAFFIC_CONTROL_0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 warning_threshold    : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 warning_threshold    : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_TRAFFIC_CONTROL_0_t;





#define TM_BM_TRAFFIC_CONTROL_1                  0xf004003c
#define TM_BM_TRAFFIC_CONTROL_1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 dying_gasp_threshold : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 living_threshold     : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 living_threshold     : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 dying_gasp_threshold : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_TRAFFIC_CONTROL_1_t;





#define TM_BM_VOQ_MEM_STATUS                     0xf0040040
#define TM_BM_VOQ_MEM_STATUS_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_MEM_STATUS_t;





#define TM_BM_VOQ_STATUS_MEM_STATUS              0xf0040044
#define TM_BM_VOQ_STATUS_MEM_STATUS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_STATUS_MEM_STATUS_t;





#define TM_BM_DEST_PORT_MEM_STATUS               0xf0040048
#define TM_BM_DEST_PORT_MEM_STATUS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd2               : 13 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_MEM_STATUS_t;





#define TM_BM_DEST_PORT_STATUS_MEM_STATUS        0xf004004c
#define TM_BM_DEST_PORT_STATUS_MEM_STATUS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd2               : 13 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_STATUS_MEM_STATUS_t;





#define TM_BM_VOQ_PROFILE_MEM_STATUS             0xf0040050
#define TM_BM_VOQ_PROFILE_MEM_STATUS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd2               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_PROFILE_MEM_STATUS_t;





#define TM_BM_WRED_PROFILE_MEM_STATUS            0xf0040054
#define TM_BM_WRED_PROFILE_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_WRED_PROFILE_MEM_STATUS_t;





#define TM_BM_INTERRUPT_0                        0xf0040058
#define TM_BM_INTERRUPT_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_global_int_buffers_used :  1 ; /* bits 22:22 */
    cs_uint32 err_global_linux7_buffers_used :  1 ; /* bits 21:21 */
    cs_uint32 err_global_linux6_buffers_used :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux5_buffers_used :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux4_buffers_used :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux3_buffers_used :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux2_buffers_used :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux1_buffers_used :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux0_buffers_used :  1 ; /* bits 14:14 */
    cs_uint32 err_global_cpu_buffers_used :  1 ; /* bits 13:13 */
    cs_uint32 err_global_buffers_used :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_wred_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_wred_profile_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_dest_port_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_dest_port_status_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_mem    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_voq_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_voq_status_mem   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_profile_mem  :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_mem  :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_mem          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_voq_mem          :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_voq_mem  :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_profile_mem  :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_status_mem   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_dest_port_mem    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_dest_port_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_status_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_wred_profile_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_wred_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_global_buffers_used :  1 ; /* bits 12:12 */
    cs_uint32 err_global_cpu_buffers_used :  1 ; /* bits 13:13 */
    cs_uint32 err_global_linux0_buffers_used :  1 ; /* bits 14:14 */
    cs_uint32 err_global_linux1_buffers_used :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux2_buffers_used :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux3_buffers_used :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux4_buffers_used :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux5_buffers_used :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux6_buffers_used :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux7_buffers_used :  1 ; /* bits 21:21 */
    cs_uint32 err_global_int_buffers_used :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INTERRUPT_0_t;





#define TM_BM_INTENABLE_0                        0xf004005c
#define TM_BM_INTENABLE_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_global_int_buffers_used_en :  1 ; /* bits 22:22 */
    cs_uint32 err_global_linux7_buffers_used_en :  1 ; /* bits 21:21 */
    cs_uint32 err_global_linux6_buffers_used_en :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux5_buffers_used_en :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux4_buffers_used_en :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux3_buffers_used_en :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux2_buffers_used_en :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux1_buffers_used_en :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux0_buffers_used_en :  1 ; /* bits 14:14 */
    cs_uint32 err_global_cpu_buffers_used_en :  1 ; /* bits 13:13 */
    cs_uint32 err_global_buffers_used_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_wred_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_wred_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_dest_port_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_dest_port_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_voq_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_voq_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_mem_en       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_voq_mem_en       :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_voq_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_dest_port_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_dest_port_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_wred_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_wred_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_global_buffers_used_en :  1 ; /* bits 12:12 */
    cs_uint32 err_global_cpu_buffers_used_en :  1 ; /* bits 13:13 */
    cs_uint32 err_global_linux0_buffers_used_en :  1 ; /* bits 14:14 */
    cs_uint32 err_global_linux1_buffers_used_en :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux2_buffers_used_en :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux3_buffers_used_en :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux4_buffers_used_en :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux5_buffers_used_en :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux6_buffers_used_en :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux7_buffers_used_en :  1 ; /* bits 21:21 */
    cs_uint32 err_global_int_buffers_used_en :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INTENABLE_0_t;





#define TM_BM_INTERRUPT_1                        0xf0040060
#define TM_BM_INTERRUPT_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_global_int_buffers_used :  1 ; /* bits 22:22 */
    cs_uint32 err_global_linux7_buffers_used :  1 ; /* bits 21:21 */
    cs_uint32 err_global_linux6_buffers_used :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux5_buffers_used :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux4_buffers_used :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux3_buffers_used :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux2_buffers_used :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux1_buffers_used :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux0_buffers_used :  1 ; /* bits 14:14 */
    cs_uint32 err_global_cpu_buffers_used :  1 ; /* bits 13:13 */
    cs_uint32 err_global_buffers_used :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_wred_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_wred_profile_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_dest_port_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_dest_port_status_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_mem    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_voq_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_voq_status_mem   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_profile_mem  :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_mem  :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_mem          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_voq_mem          :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_voq_mem  :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_profile_mem  :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_status_mem   :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_dest_port_mem    :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_dest_port_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_status_mem :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_wred_profile_mem :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_wred_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_global_buffers_used :  1 ; /* bits 12:12 */
    cs_uint32 err_global_cpu_buffers_used :  1 ; /* bits 13:13 */
    cs_uint32 err_global_linux0_buffers_used :  1 ; /* bits 14:14 */
    cs_uint32 err_global_linux1_buffers_used :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux2_buffers_used :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux3_buffers_used :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux4_buffers_used :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux5_buffers_used :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux6_buffers_used :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux7_buffers_used :  1 ; /* bits 21:21 */
    cs_uint32 err_global_int_buffers_used :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INTERRUPT_1_t;





#define TM_BM_INTENABLE_1                        0xf0040064
#define TM_BM_INTENABLE_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_global_int_buffers_used_en :  1 ; /* bits 22:22 */
    cs_uint32 err_global_linux7_buffers_used_en :  1 ; /* bits 21:21 */
    cs_uint32 err_global_linux6_buffers_used_en :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux5_buffers_used_en :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux4_buffers_used_en :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux3_buffers_used_en :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux2_buffers_used_en :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux1_buffers_used_en :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux0_buffers_used_en :  1 ; /* bits 14:14 */
    cs_uint32 err_global_cpu_buffers_used_en :  1 ; /* bits 13:13 */
    cs_uint32 err_global_buffers_used_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_wred_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_wred_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_dest_port_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_dest_port_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_voq_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_voq_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_mem_en       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_voq_mem_en       :  1 ; /* bits 0:0 */
    cs_uint32 err_correct_voq_mem_en :  1 ; /* bits 1:1 */
    cs_uint32 err_voq_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_voq_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_voq_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_voq_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_dest_port_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_dest_port_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_dest_port_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_dest_port_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_wred_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_wred_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_global_buffers_used_en :  1 ; /* bits 12:12 */
    cs_uint32 err_global_cpu_buffers_used_en :  1 ; /* bits 13:13 */
    cs_uint32 err_global_linux0_buffers_used_en :  1 ; /* bits 14:14 */
    cs_uint32 err_global_linux1_buffers_used_en :  1 ; /* bits 15:15 */
    cs_uint32 err_global_linux2_buffers_used_en :  1 ; /* bits 16:16 */
    cs_uint32 err_global_linux3_buffers_used_en :  1 ; /* bits 17:17 */
    cs_uint32 err_global_linux4_buffers_used_en :  1 ; /* bits 18:18 */
    cs_uint32 err_global_linux5_buffers_used_en :  1 ; /* bits 19:19 */
    cs_uint32 err_global_linux6_buffers_used_en :  1 ; /* bits 20:20 */
    cs_uint32 err_global_linux7_buffers_used_en :  1 ; /* bits 21:21 */
    cs_uint32 err_global_int_buffers_used_en :  1 ; /* bits 22:22 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INTENABLE_1_t;





#define TM_BM_INT_STATUS_1                       0xf0040068
#define TM_BM_INT_STATUS_1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 buffers              : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 buffers              : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 free_buffers         : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INT_STATUS_1_t;





#define TM_BM_INT_STATUS_2                       0xf004006c
#define TM_BM_INT_STATUS_2_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 free_global_buffers  : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 global_buffers       : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 global_buffers       : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 free_global_buffers  : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_INT_STATUS_2_t;





#define TM_BM_RESERVE_INT_BUFFERS                0xf0040070
#define TM_BM_RESERVE_INT_BUFFERS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  8 ;
    cs_uint32 reserve_buffers_inflight_pkts :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 reserve_int_buffers  : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 reserve_int_buffers  : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 reserve_buffers_inflight_pkts :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd2               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_RESERVE_INT_BUFFERS_t;





#define TM_BM_TRAFFIC_CONTROL_2                  0xf0040074
#define TM_BM_TRAFFIC_CONTROL_2_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 warning_threshold_int : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 warning_threshold_int : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_TRAFFIC_CONTROL_2_t;





#define TM_BM_TRAFFIC_CONTROL_3                  0xf0040078
#define TM_BM_TRAFFIC_CONTROL_3_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  4 ;
    cs_uint32 dying_gasp_threshold_int : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 living_threshold_int : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 living_threshold_int : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 dying_gasp_threshold_int : 12 ; /* bits 27:16 */
    cs_uint32 rsrvd2               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_TRAFFIC_CONTROL_3_t;





#define TM_BM_VOQ_MEM_ACCESS                     0xf0040080
#define TM_BM_VOQ_MEM_ACCESS_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_MEM_ACCESS_t;





#define TM_BM_VOQ_MEM_DATA                       0xf0040084
#define TM_BM_VOQ_MEM_DATA_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 wred_enable          :  1 ; /* bits 19:19 */
    cs_uint32 voq_cntr             :  5 ; /* bits 18:14 */
    cs_uint32 voq_cntr_enable      :  1 ; /* bits 13:13 */
    cs_uint32 dest_port            :  3 ; /* bits 12:10 */
    cs_uint32 wred_profile         :  5 ; /* bits 9:5 */
    cs_uint32 voq_profile          :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 voq_profile          :  5 ; /* bits 4:0 */
    cs_uint32 wred_profile         :  5 ; /* bits 9:5 */
    cs_uint32 dest_port            :  3 ; /* bits 12:10 */
    cs_uint32 voq_cntr_enable      :  1 ; /* bits 13:13 */
    cs_uint32 voq_cntr             :  5 ; /* bits 18:14 */
    cs_uint32 wred_enable          :  1 ; /* bits 19:19 */
    cs_uint32 rsrvd1               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_MEM_DATA_t;





#define TM_BM_VOQ_STATUS_MEM_ACCESS              0xf0040090
#define TM_BM_VOQ_STATUS_MEM_ACCESS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_STATUS_MEM_ACCESS_t;





#define TM_BM_VOQ_STATUS_MEM_DATA1               0xf0040094
#define TM_BM_VOQ_STATUS_MEM_DATA1_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 voq_aqd              : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 voq_aqd              : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_STATUS_MEM_DATA1_t;





#define TM_BM_VOQ_STATUS_MEM_DATA0               0xf0040098
#define TM_BM_VOQ_STATUS_MEM_DATA0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 voq_aqd              :  2 ; /* bits 31:30 */
    cs_uint32 voq_depth            : 16 ; /* bits 29:14 */
    cs_uint32 voq_write_ptr        : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 voq_write_ptr        : 14 ; /* bits 13:0 */
    cs_uint32 voq_depth            : 16 ; /* bits 29:14 */
    cs_uint32 voq_aqd              :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_STATUS_MEM_DATA0_t;





#define TM_BM_DEST_PORT_MEM_ACCESS               0xf00400a0
#define TM_BM_DEST_PORT_MEM_ACCESS_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_MEM_ACCESS_t;





#define TM_BM_DEST_PORT_MEM_DATA                 0xf00400a4
#define TM_BM_DEST_PORT_MEM_DATA_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 dest_port_max_global_buffers : 13 ; /* bits 25:13 */
    cs_uint32 dest_port_min_global_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dest_port_min_global_buffers : 13 ; /* bits 12:0 */
    cs_uint32 dest_port_max_global_buffers : 13 ; /* bits 25:13 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_MEM_DATA_t;





#define TM_BM_DEST_PORT_STATUS_MEM_ACCESS        0xf00400b0
#define TM_BM_DEST_PORT_STATUS_MEM_ACCESS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_STATUS_MEM_ACCESS_t;





#define TM_BM_DEST_PORT_STATUS_MEM_DATA          0xf00400b4
#define TM_BM_DEST_PORT_STATUS_MEM_DATA_dft      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 19 ;
    cs_uint32 dest_port_global_buffers : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 dest_port_global_buffers : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               : 19 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_DEST_PORT_STATUS_MEM_DATA_t;





#define TM_BM_VOQ_PROFILE_MEM_ACCESS             0xf00400c0
#define TM_BM_VOQ_PROFILE_MEM_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_PROFILE_MEM_ACCESS_t;





#define TM_BM_VOQ_PROFILE_MEM_DATA1              0xf00400c4
#define TM_BM_VOQ_PROFILE_MEM_DATA1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 wred_aqd_weight      :  4 ; /* bits 6:3 */
    cs_uint32 wred_adjust_range_index :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wred_adjust_range_index :  3 ; /* bits 2:0 */
    cs_uint32 wred_aqd_weight      :  4 ; /* bits 6:3 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_PROFILE_MEM_DATA1_t;





#define TM_BM_VOQ_PROFILE_MEM_DATA0              0xf00400c8
#define TM_BM_VOQ_PROFILE_MEM_DATA0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 voq_max_depth        : 16 ; /* bits 31:16 */
    cs_uint32 voq_min_depth        : 16 ; /* bits 15:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 voq_min_depth        : 16 ; /* bits 15:0 */
    cs_uint32 voq_max_depth        : 16 ; /* bits 31:16 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_VOQ_PROFILE_MEM_DATA0_t;





#define TM_BM_WRED_PROFILE_MEM_ACCESS            0xf00400d0
#define TM_BM_WRED_PROFILE_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_WRED_PROFILE_MEM_ACCESS_t;





#define TM_BM_WRED_PROFILE_MEM_DATA              0xf00400d4
#define TM_BM_WRED_PROFILE_MEM_DATA_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 wred_aqd_max_drop_probability :  3 ; /* bits 22:20 */
    cs_uint32 wred_aqd_max_pct_buffers0 :  5 ; /* bits 19:15 */
    cs_uint32 wred_aqd_min_pct_buffers0 :  5 ; /* bits 14:10 */
    cs_uint32 wred_aqd_max_pct_baseline :  5 ; /* bits 9:5 */
    cs_uint32 wred_aqd_min_pct_baseline :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 wred_aqd_min_pct_baseline :  5 ; /* bits 4:0 */
    cs_uint32 wred_aqd_max_pct_baseline :  5 ; /* bits 9:5 */
    cs_uint32 wred_aqd_min_pct_buffers0 :  5 ; /* bits 14:10 */
    cs_uint32 wred_aqd_max_pct_buffers0 :  5 ; /* bits 19:15 */
    cs_uint32 wred_aqd_max_drop_probability :  3 ; /* bits 22:20 */
    cs_uint32 rsrvd1               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_BM_WRED_PROFILE_MEM_DATA_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* BM */

typedef struct {
  TM_BM_CONFIG_0_t                         CONFIG_0;                      /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  TM_BM_STATUS_0_t                         STATUS_0;                      /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  TM_BM_STATUS_1_t                         STATUS_1;                      /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  TM_BM_STATUS_2_t                         STATUS_2;                      /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  TM_BM_RESERVE_BUFFERS_t                  RESERVE_BUFFERS;               /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  TM_BM_RESERVE_CPU_BUFFERS_t              RESERVE_CPU_BUFFERS;           /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  TM_BM_RESERVE_LINUX_BUFFERS_0_t          RESERVE_LINUX_BUFFERS_0;       /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  TM_BM_RESERVE_LINUX_BUFFERS_1_t          RESERVE_LINUX_BUFFERS_1;       /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  TM_BM_RESERVE_LINUX_BUFFERS_2_t          RESERVE_LINUX_BUFFERS_2;       /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  TM_BM_RESERVE_LINUX_BUFFERS_3_t          RESERVE_LINUX_BUFFERS_3;       /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  TM_BM_WRED_CONFIG_0_t                    WRED_CONFIG_0;                 /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  TM_BM_WRED_CONFIG_1_t                    WRED_CONFIG_1;                 /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  TM_BM_COPY_WRED_PROFILE_t                COPY_WRED_PROFILE;             /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  TM_BM_COPY_DEST_PORT_t                   COPY_DEST_PORT;                /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  TM_BM_TRAFFIC_CONTROL_0_t                TRAFFIC_CONTROL_0;             /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  TM_BM_TRAFFIC_CONTROL_1_t                TRAFFIC_CONTROL_1;             /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  TM_BM_VOQ_MEM_STATUS_t                   VOQ_MEM_STATUS;                /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  TM_BM_VOQ_STATUS_MEM_STATUS_t            VOQ_STATUS_MEM_STATUS;         /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  TM_BM_DEST_PORT_MEM_STATUS_t             DEST_PORT_MEM_STATUS;          /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  TM_BM_DEST_PORT_STATUS_MEM_STATUS_t      DEST_PORT_STATUS_MEM_STATUS;   /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  TM_BM_VOQ_PROFILE_MEM_STATUS_t           VOQ_PROFILE_MEM_STATUS;        /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  TM_BM_WRED_PROFILE_MEM_STATUS_t          WRED_PROFILE_MEM_STATUS;       /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  TM_BM_INTERRUPT_0_t                      INTERRUPT_0;                   /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  TM_BM_INTENABLE_0_t                      INTENABLE_0;                   /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  TM_BM_INTERRUPT_1_t                      INTERRUPT_1;                   /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  TM_BM_INTENABLE_1_t                      INTENABLE_1;                   /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  TM_BM_INT_STATUS_1_t                     INT_STATUS_1;                  /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  TM_BM_INT_STATUS_2_t                     INT_STATUS_2;                  /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  TM_BM_RESERVE_INT_BUFFERS_t              RESERVE_INT_BUFFERS;           /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  TM_BM_TRAFFIC_CONTROL_2_t                TRAFFIC_CONTROL_2;             /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  TM_BM_TRAFFIC_CONTROL_3_t                TRAFFIC_CONTROL_3;             /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[7];                   
  TM_BM_VOQ_MEM_ACCESS_t                   VOQ_MEM_ACCESS;                /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd32[3];                   
  TM_BM_VOQ_MEM_DATA_t                     VOQ_MEM_DATA;                  /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd33[11];                  
  TM_BM_VOQ_STATUS_MEM_ACCESS_t            VOQ_STATUS_MEM_ACCESS;         /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd34[3];                   
  TM_BM_VOQ_STATUS_MEM_DATA1_t             VOQ_STATUS_MEM_DATA1;          /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd35[3];                   
  TM_BM_VOQ_STATUS_MEM_DATA0_t             VOQ_STATUS_MEM_DATA0;          /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd36[7];                   
  TM_BM_DEST_PORT_MEM_ACCESS_t             DEST_PORT_MEM_ACCESS;          /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd37[3];                   
  TM_BM_DEST_PORT_MEM_DATA_t               DEST_PORT_MEM_DATA;            /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd38[11];                  
  TM_BM_DEST_PORT_STATUS_MEM_ACCESS_t      DEST_PORT_STATUS_MEM_ACCESS;   /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd39[3];                   
  TM_BM_DEST_PORT_STATUS_MEM_DATA_t        DEST_PORT_STATUS_MEM_DATA;     /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd40[11];                  
  TM_BM_VOQ_PROFILE_MEM_ACCESS_t           VOQ_PROFILE_MEM_ACCESS;        /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd41[3];                   
  TM_BM_VOQ_PROFILE_MEM_DATA1_t            VOQ_PROFILE_MEM_DATA1;         /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd42[3];                   
  TM_BM_VOQ_PROFILE_MEM_DATA0_t            VOQ_PROFILE_MEM_DATA0;         /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd43[7];                   
  TM_BM_WRED_PROFILE_MEM_ACCESS_t          WRED_PROFILE_MEM_ACCESS;       /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd44[3];                   
  TM_BM_WRED_PROFILE_MEM_DATA_t            WRED_PROFILE_MEM_DATA;         /* addr: 0x000000d4 */ 
} TM_BM_t;

  

/*
 * POL
 */
  



#define TM_POL_CONFIG_0                          0xf0040100
#define TM_POL_CONFIG_0_dft                      0x00000001




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
    cs_uint32 pol_disable          :  1 ; /* bits 30:30 */
    cs_uint32 config_spare         : 14 ; /* bits 29:16 */
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 pol_bypass_red       :  1 ; /* bits 6:6 */
    cs_uint32 pol_bypass_yellow    :  1 ; /* bits 5:5 */
    cs_uint32 pol_color_blind      :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 init                 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 pol_color_blind      :  1 ; /* bits 4:4 */
    cs_uint32 pol_bypass_yellow    :  1 ; /* bits 5:5 */
    cs_uint32 pol_bypass_red       :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 config_spare         : 14 ; /* bits 29:16 */
    cs_uint32 pol_disable          :  1 ; /* bits 30:30 */
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CONFIG_0_t;





#define TM_POL_CONFIG_SPID                       0xf0040104
#define TM_POL_CONFIG_SPID_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 22 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CONFIG_SPID_t;





#define TM_POL_CONFIG_FLOW                       0xf0040108
#define TM_POL_CONFIG_FLOW_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 22 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               : 22 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CONFIG_FLOW_t;





#define TM_POL_CONFIG_PKT_TYPE                   0xf004010c
#define TM_POL_CONFIG_PKT_TYPE_dft               0xffff0000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 lspid3               :  4 ; /* bits 31:28 */
    cs_uint32 lspid2               :  4 ; /* bits 27:24 */
    cs_uint32 lspid1               :  4 ; /* bits 23:20 */
    cs_uint32 lspid0               :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 lspid0               :  4 ; /* bits 19:16 */
    cs_uint32 lspid1               :  4 ; /* bits 23:20 */
    cs_uint32 lspid2               :  4 ; /* bits 27:24 */
    cs_uint32 lspid3               :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CONFIG_PKT_TYPE_t;





#define TM_POL_CONFIG_CPU                        0xf0040110
#define TM_POL_CONFIG_CPU_dft                    0x7f7f0000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd4               :  1 ;
    cs_uint32 voq1                 :  7 ; /* bits 30:24 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 voq0                 :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bypass_yellow        :  1 ; /* bits 0:0 */
    cs_uint32 bypass_red           :  1 ; /* bits 1:1 */
    cs_uint32 disable              :  1 ; /* bits 2:2 */
    cs_uint32 color_blind          :  1 ; /* bits 3:3 */
    cs_uint32 bypass_yellow_define :  1 ; /* bits 4:4 */
    cs_uint32 update_mode          :  1 ; /* bits 5:5 */
    cs_uint32 nest_level           :  2 ; /* bits 7:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 commit_override_enable :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 voq0                 :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd3               :  1 ;
    cs_uint32 voq1                 :  7 ; /* bits 30:24 */
    cs_uint32 rsrvd4               :  1 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CONFIG_CPU_t;





#define TM_POL_IPG_DEST                          0xf0040114
#define TM_POL_IPG_DEST_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 ipg_dest6            :  5 ; /* bits 29:25 */
    cs_uint32 ipg_dest5            :  5 ; /* bits 24:20 */
    cs_uint32 ipg_dest4            :  5 ; /* bits 19:15 */
    cs_uint32 ipg_dest3            :  5 ; /* bits 14:10 */
    cs_uint32 ipg_dest2            :  5 ; /* bits 9:5 */
    cs_uint32 ipg_dest1            :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipg_dest1            :  5 ; /* bits 4:0 */
    cs_uint32 ipg_dest2            :  5 ; /* bits 9:5 */
    cs_uint32 ipg_dest3            :  5 ; /* bits 14:10 */
    cs_uint32 ipg_dest4            :  5 ; /* bits 19:15 */
    cs_uint32 ipg_dest5            :  5 ; /* bits 24:20 */
    cs_uint32 ipg_dest6            :  5 ; /* bits 29:25 */
    cs_uint32 rsrvd1               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_IPG_DEST_t;





#define TM_POL_IPG_DEST_MAP                      0xf0040118
#define TM_POL_IPG_DEST_MAP_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 ipg_ldpid7           :  3 ; /* bits 23:21 */
    cs_uint32 ipg_ldpid6           :  3 ; /* bits 20:18 */
    cs_uint32 ipg_ldpid5           :  3 ; /* bits 17:15 */
    cs_uint32 ipg_ldpid4           :  3 ; /* bits 14:12 */
    cs_uint32 ipg_ldpid3           :  3 ; /* bits 11:9 */
    cs_uint32 ipg_ldpid2           :  3 ; /* bits 8:6 */
    cs_uint32 ipg_ldpid1           :  3 ; /* bits 5:3 */
    cs_uint32 ipg_ldpid0           :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipg_ldpid0           :  3 ; /* bits 2:0 */
    cs_uint32 ipg_ldpid1           :  3 ; /* bits 5:3 */
    cs_uint32 ipg_ldpid2           :  3 ; /* bits 8:6 */
    cs_uint32 ipg_ldpid3           :  3 ; /* bits 11:9 */
    cs_uint32 ipg_ldpid4           :  3 ; /* bits 14:12 */
    cs_uint32 ipg_ldpid5           :  3 ; /* bits 17:15 */
    cs_uint32 ipg_ldpid6           :  3 ; /* bits 20:18 */
    cs_uint32 ipg_ldpid7           :  3 ; /* bits 23:21 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_IPG_DEST_MAP_t;





#define TM_POL_IPG_SRC                           0xf004011c
#define TM_POL_IPG_SRC_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 ipg_src6             :  5 ; /* bits 29:25 */
    cs_uint32 ipg_src5             :  5 ; /* bits 24:20 */
    cs_uint32 ipg_src4             :  5 ; /* bits 19:15 */
    cs_uint32 ipg_src3             :  5 ; /* bits 14:10 */
    cs_uint32 ipg_src2             :  5 ; /* bits 9:5 */
    cs_uint32 ipg_src1             :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipg_src1             :  5 ; /* bits 4:0 */
    cs_uint32 ipg_src2             :  5 ; /* bits 9:5 */
    cs_uint32 ipg_src3             :  5 ; /* bits 14:10 */
    cs_uint32 ipg_src4             :  5 ; /* bits 19:15 */
    cs_uint32 ipg_src5             :  5 ; /* bits 24:20 */
    cs_uint32 ipg_src6             :  5 ; /* bits 29:25 */
    cs_uint32 rsrvd1               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_IPG_SRC_t;





#define TM_POL_IPG_SRC_MAP                       0xf0040120
#define TM_POL_IPG_SRC_MAP_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 ipg_lspid7           :  3 ; /* bits 23:21 */
    cs_uint32 ipg_lspid6           :  3 ; /* bits 20:18 */
    cs_uint32 ipg_lspid5           :  3 ; /* bits 17:15 */
    cs_uint32 ipg_lspid4           :  3 ; /* bits 14:12 */
    cs_uint32 ipg_lspid3           :  3 ; /* bits 11:9 */
    cs_uint32 ipg_lspid2           :  3 ; /* bits 8:6 */
    cs_uint32 ipg_lspid1           :  3 ; /* bits 5:3 */
    cs_uint32 ipg_lspid0           :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ipg_lspid0           :  3 ; /* bits 2:0 */
    cs_uint32 ipg_lspid1           :  3 ; /* bits 5:3 */
    cs_uint32 ipg_lspid2           :  3 ; /* bits 8:6 */
    cs_uint32 ipg_lspid3           :  3 ; /* bits 11:9 */
    cs_uint32 ipg_lspid4           :  3 ; /* bits 14:12 */
    cs_uint32 ipg_lspid5           :  3 ; /* bits 17:15 */
    cs_uint32 ipg_lspid6           :  3 ; /* bits 20:18 */
    cs_uint32 ipg_lspid7           :  3 ; /* bits 23:21 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_IPG_SRC_MAP_t;





#define TM_POL_STATUS_0                          0xf0040124
#define TM_POL_STATUS_0_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_STATUS_0_t;





#define TM_POL_FLOW_PROFILE_MEM_STATUS           0xf0040128
#define TM_POL_FLOW_PROFILE_MEM_STATUS_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_PROFILE_MEM_STATUS_t;





#define TM_POL_FLOW_STATUS_MEM_STATUS            0xf004012c
#define TM_POL_FLOW_STATUS_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 err_correct_addr     :  7 ; /* bits 22:16 */
    cs_uint32 rsrvd2               :  9 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_STATUS_MEM_STATUS_t;





#define TM_POL_SPID_PROFILE_MEM_STATUS           0xf0040130
#define TM_POL_SPID_PROFILE_MEM_STATUS_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd2               : 13 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_PROFILE_MEM_STATUS_t;





#define TM_POL_SPID_STATUS_MEM_STATUS            0xf0040134
#define TM_POL_SPID_STATUS_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 13 ;
    cs_uint32 err_correct_addr     :  3 ; /* bits 18:16 */
    cs_uint32 rsrvd2               : 13 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_STATUS_MEM_STATUS_t;





#define TM_POL_CPU_PROFILE_MEM_STATUS            0xf0040138
#define TM_POL_CPU_PROFILE_MEM_STATUS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 err_correct_addr     :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 err_addr             :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 err_correct_addr     :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd2               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_PROFILE_MEM_STATUS_t;





#define TM_POL_CPU_STATUS_MEM_STATUS             0xf004013c
#define TM_POL_CPU_STATUS_MEM_STATUS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 12 ;
    cs_uint32 err_correct_addr     :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 err_addr             :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 err_correct_addr     :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd2               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_STATUS_MEM_STATUS_t;





#define TM_POL_PKT_TYPE_PROFILE_MEM_STATUS       0xf0040140
#define TM_POL_PKT_TYPE_PROFILE_MEM_STATUS_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd2               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_PROFILE_MEM_STATUS_t;





#define TM_POL_PKT_TYPE_STATUS_MEM_STATUS        0xf0040144
#define TM_POL_PKT_TYPE_STATUS_MEM_STATUS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_correct_addr     :  5 ; /* bits 20:16 */
    cs_uint32 rsrvd2               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_STATUS_MEM_STATUS_t;





#define TM_POL_INTERRUPT_0                       0xf0040148
#define TM_POL_INTERRUPT_0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 err_correct_pkt_type_status_mem :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_type_status_mem :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_profile_mem :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_profile_mem :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_cpu_status_mem :  1 ; /* bits 13:13 */
    cs_uint32 err_cpu_status_mem   :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_profile_mem  :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_spid_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_spid_status_mem  :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_profile_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_profile_mem :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_flow_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_flow_status_mem  :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_profile_mem :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               :  2 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 err_flow_profile_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_flow_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_status_mem  :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_spid_profile_mem :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_spid_profile_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_status_mem  :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_cpu_profile_mem  :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_cpu_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_status_mem   :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_status_mem :  1 ; /* bits 13:13 */
    cs_uint32 err_pkt_type_profile_mem :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_pkt_type_profile_mem :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_status_mem :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_status_mem :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_INTERRUPT_0_t;





#define TM_POL_INTENABLE_0                       0xf004014c
#define TM_POL_INTENABLE_0_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 err_correct_pkt_type_status_mem_en :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_type_status_mem_en :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_profile_mem_en :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_profile_mem_en :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_cpu_status_mem_en :  1 ; /* bits 13:13 */
    cs_uint32 err_cpu_status_mem_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_spid_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_spid_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_profile_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_profile_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_flow_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_flow_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               :  2 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 err_flow_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_flow_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_spid_profile_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_spid_profile_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_cpu_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_cpu_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_status_mem_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_status_mem_en :  1 ; /* bits 13:13 */
    cs_uint32 err_pkt_type_profile_mem_en :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_pkt_type_profile_mem_en :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_status_mem_en :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_status_mem_en :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_INTENABLE_0_t;





#define TM_POL_INTERRUPT_1                       0xf0040150
#define TM_POL_INTERRUPT_1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 err_correct_pkt_type_status_mem :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_type_status_mem :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_profile_mem :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_profile_mem :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_cpu_status_mem :  1 ; /* bits 13:13 */
    cs_uint32 err_cpu_status_mem   :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_profile_mem  :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_spid_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_spid_status_mem  :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_profile_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_profile_mem :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_flow_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_flow_status_mem  :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_profile_mem :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               :  2 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 err_flow_profile_mem :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_flow_profile_mem :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_status_mem  :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_status_mem :  1 ; /* bits 5:5 */
    cs_uint32 err_spid_profile_mem :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_spid_profile_mem :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_status_mem  :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_status_mem :  1 ; /* bits 9:9 */
    cs_uint32 err_cpu_profile_mem  :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_cpu_profile_mem :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_status_mem   :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_status_mem :  1 ; /* bits 13:13 */
    cs_uint32 err_pkt_type_profile_mem :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_pkt_type_profile_mem :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_status_mem :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_status_mem :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_INTERRUPT_1_t;





#define TM_POL_INTENABLE_1                       0xf0040154
#define TM_POL_INTENABLE_1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 err_correct_pkt_type_status_mem_en :  1 ; /* bits 17:17 */
    cs_uint32 err_pkt_type_status_mem_en :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_profile_mem_en :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_profile_mem_en :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_cpu_status_mem_en :  1 ; /* bits 13:13 */
    cs_uint32 err_cpu_status_mem_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_spid_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_spid_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_profile_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_profile_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_flow_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_flow_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               :  2 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 err_flow_profile_mem_en :  1 ; /* bits 2:2 */
    cs_uint32 err_correct_flow_profile_mem_en :  1 ; /* bits 3:3 */
    cs_uint32 err_flow_status_mem_en :  1 ; /* bits 4:4 */
    cs_uint32 err_correct_flow_status_mem_en :  1 ; /* bits 5:5 */
    cs_uint32 err_spid_profile_mem_en :  1 ; /* bits 6:6 */
    cs_uint32 err_correct_spid_profile_mem_en :  1 ; /* bits 7:7 */
    cs_uint32 err_spid_status_mem_en :  1 ; /* bits 8:8 */
    cs_uint32 err_correct_spid_status_mem_en :  1 ; /* bits 9:9 */
    cs_uint32 err_cpu_profile_mem_en :  1 ; /* bits 10:10 */
    cs_uint32 err_correct_cpu_profile_mem_en :  1 ; /* bits 11:11 */
    cs_uint32 err_cpu_status_mem_en :  1 ; /* bits 12:12 */
    cs_uint32 err_correct_cpu_status_mem_en :  1 ; /* bits 13:13 */
    cs_uint32 err_pkt_type_profile_mem_en :  1 ; /* bits 14:14 */
    cs_uint32 err_correct_pkt_type_profile_mem_en :  1 ; /* bits 15:15 */
    cs_uint32 err_pkt_type_status_mem_en :  1 ; /* bits 16:16 */
    cs_uint32 err_correct_pkt_type_status_mem_en :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_INTENABLE_1_t;





#define TM_POL_FLOW_STATUS_MEM_ACCESS            0xf0040180
#define TM_POL_FLOW_STATUS_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_STATUS_MEM_ACCESS_t;





#define TM_POL_FLOW_STATUS_MEM_DATA1             0xf0040184
#define TM_POL_FLOW_STATUS_MEM_DATA1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_STATUS_MEM_DATA1_t;





#define TM_POL_FLOW_STATUS_MEM_DATA0             0xf0040188
#define TM_POL_FLOW_STATUS_MEM_DATA0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_STATUS_MEM_DATA0_t;





#define TM_POL_FLOW_PROFILE_MEM_ACCESS           0xf0040190
#define TM_POL_FLOW_PROFILE_MEM_ACCESS_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_PROFILE_MEM_ACCESS_t;





#define TM_POL_FLOW_PROFILE_MEM_DATA1            0xf0040194
#define TM_POL_FLOW_PROFILE_MEM_DATA1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_PROFILE_MEM_DATA1_t;





#define TM_POL_FLOW_PROFILE_MEM_DATA0            0xf0040198
#define TM_POL_FLOW_PROFILE_MEM_DATA0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_FLOW_PROFILE_MEM_DATA0_t;





#define TM_POL_SPID_STATUS_MEM_ACCESS            0xf00401a0
#define TM_POL_SPID_STATUS_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_STATUS_MEM_ACCESS_t;





#define TM_POL_SPID_STATUS_MEM_DATA1             0xf00401a4
#define TM_POL_SPID_STATUS_MEM_DATA1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_STATUS_MEM_DATA1_t;





#define TM_POL_SPID_STATUS_MEM_DATA0             0xf00401a8
#define TM_POL_SPID_STATUS_MEM_DATA0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_STATUS_MEM_DATA0_t;





#define TM_POL_SPID_PROFILE_MEM_ACCESS           0xf00401b0
#define TM_POL_SPID_PROFILE_MEM_ACCESS_dft       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_PROFILE_MEM_ACCESS_t;





#define TM_POL_SPID_PROFILE_MEM_DATA1            0xf00401b4
#define TM_POL_SPID_PROFILE_MEM_DATA1_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 bypass_red           :  1 ; /* bits 11:11 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 10:10 */
    cs_uint32 pir_max_credit       : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_max_credit       : 10 ; /* bits 9:0 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 10:10 */
    cs_uint32 bypass_red           :  1 ; /* bits 11:11 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_PROFILE_MEM_DATA1_t;





#define TM_POL_SPID_PROFILE_MEM_DATA0            0xf00401b8
#define TM_POL_SPID_PROFILE_MEM_DATA0_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_max_credit       :  3 ; /* bits 31:29 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 28:16 */
    cs_uint32 cir_credit           : 13 ; /* bits 15:3 */
    cs_uint32 range                :  1 ; /* bits 2:2 */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
    cs_uint32 range                :  1 ; /* bits 2:2 */
    cs_uint32 cir_credit           : 13 ; /* bits 15:3 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 28:16 */
    cs_uint32 pir_max_credit       :  3 ; /* bits 31:29 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_SPID_PROFILE_MEM_DATA0_t;





#define TM_POL_CPU_STATUS_MEM_ACCESS             0xf00401c0
#define TM_POL_CPU_STATUS_MEM_ACCESS_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_STATUS_MEM_ACCESS_t;





#define TM_POL_CPU_STATUS_MEM_DATA1              0xf00401c4
#define TM_POL_CPU_STATUS_MEM_DATA1_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_STATUS_MEM_DATA1_t;





#define TM_POL_CPU_STATUS_MEM_DATA0              0xf00401c8
#define TM_POL_CPU_STATUS_MEM_DATA0_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_STATUS_MEM_DATA0_t;





#define TM_POL_CPU_PROFILE_MEM_ACCESS            0xf00401d0
#define TM_POL_CPU_PROFILE_MEM_ACCESS_dft        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_PROFILE_MEM_ACCESS_t;





#define TM_POL_CPU_PROFILE_MEM_DATA1             0xf00401d4
#define TM_POL_CPU_PROFILE_MEM_DATA1_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_PROFILE_MEM_DATA1_t;





#define TM_POL_CPU_PROFILE_MEM_DATA0             0xf00401d8
#define TM_POL_CPU_PROFILE_MEM_DATA0_dft         0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_CPU_PROFILE_MEM_DATA0_t;





#define TM_POL_PKT_TYPE_STATUS_MEM_ACCESS        0xf00401e0
#define TM_POL_PKT_TYPE_STATUS_MEM_ACCESS_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_STATUS_MEM_ACCESS_t;





#define TM_POL_PKT_TYPE_STATUS_MEM_DATA1         0xf00401e4
#define TM_POL_PKT_TYPE_STATUS_MEM_DATA1_dft     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_token_bucket     :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_STATUS_MEM_DATA1_t;





#define TM_POL_PKT_TYPE_STATUS_MEM_DATA0         0xf00401e8
#define TM_POL_PKT_TYPE_STATUS_MEM_DATA0_dft     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cir_token_bucket     : 20 ; /* bits 19:0 */
    cs_uint32 pir_token_bucket     : 12 ; /* bits 31:20 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_STATUS_MEM_DATA0_t;





#define TM_POL_PKT_TYPE_PROFILE_MEM_ACCESS       0xf00401f0
#define TM_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;





#define TM_POL_PKT_TYPE_PROFILE_MEM_DATA1        0xf00401f4
#define TM_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pir_credit           : 11 ; /* bits 10:0 */
    cs_uint32 pir_max_credit       : 13 ; /* bits 23:11 */
    cs_uint32 bypass_yellow        :  1 ; /* bits 24:24 */
    cs_uint32 bypass_red           :  1 ; /* bits 25:25 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;





#define TM_POL_PKT_TYPE_PROFILE_MEM_DATA0        0xf00401f8
#define TM_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 policer_type         :  2 ; /* bits 1:0 */
    cs_uint32 range                :  2 ; /* bits 3:2 */
    cs_uint32 cir_credit           : 13 ; /* bits 16:4 */
    cs_uint32 cir_max_credit       : 13 ; /* bits 29:17 */
    cs_uint32 pir_credit           :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* POL */

typedef struct {
  TM_POL_CONFIG_0_t                        CONFIG_0;                      /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  TM_POL_CONFIG_SPID_t                     CONFIG_SPID;                   /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  TM_POL_CONFIG_FLOW_t                     CONFIG_FLOW;                   /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  TM_POL_CONFIG_PKT_TYPE_t                 CONFIG_PKT_TYPE;               /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  TM_POL_CONFIG_CPU_t                      CONFIG_CPU;                    /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  TM_POL_IPG_DEST_t                        IPG_DEST;                      /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  TM_POL_IPG_DEST_MAP_t                    IPG_DEST_MAP;                  /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  TM_POL_IPG_SRC_t                         IPG_SRC;                       /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  TM_POL_IPG_SRC_MAP_t                     IPG_SRC_MAP;                   /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  TM_POL_STATUS_0_t                        STATUS_0;                      /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  TM_POL_FLOW_PROFILE_MEM_STATUS_t         FLOW_PROFILE_MEM_STATUS;       /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  TM_POL_FLOW_STATUS_MEM_STATUS_t          FLOW_STATUS_MEM_STATUS;        /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  TM_POL_SPID_PROFILE_MEM_STATUS_t         SPID_PROFILE_MEM_STATUS;       /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  TM_POL_SPID_STATUS_MEM_STATUS_t          SPID_STATUS_MEM_STATUS;        /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  TM_POL_CPU_PROFILE_MEM_STATUS_t          CPU_PROFILE_MEM_STATUS;        /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  TM_POL_CPU_STATUS_MEM_STATUS_t           CPU_STATUS_MEM_STATUS;         /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  TM_POL_PKT_TYPE_PROFILE_MEM_STATUS_t     PKT_TYPE_PROFILE_MEM_STATUS;   /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  TM_POL_PKT_TYPE_STATUS_MEM_STATUS_t      PKT_TYPE_STATUS_MEM_STATUS;    /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  TM_POL_INTERRUPT_0_t                     INTERRUPT_0;                   /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  TM_POL_INTENABLE_0_t                     INTENABLE_0;                   /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  TM_POL_INTERRUPT_1_t                     INTERRUPT_1;                   /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  TM_POL_INTENABLE_1_t                     INTENABLE_1;                   /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[43];                  
  TM_POL_FLOW_STATUS_MEM_ACCESS_t          FLOW_STATUS_MEM_ACCESS;        /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd23[3];                   
  TM_POL_FLOW_STATUS_MEM_DATA1_t           FLOW_STATUS_MEM_DATA1;         /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd24[3];                   
  TM_POL_FLOW_STATUS_MEM_DATA0_t           FLOW_STATUS_MEM_DATA0;         /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd25[7];                   
  TM_POL_FLOW_PROFILE_MEM_ACCESS_t         FLOW_PROFILE_MEM_ACCESS;       /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd26[3];                   
  TM_POL_FLOW_PROFILE_MEM_DATA1_t          FLOW_PROFILE_MEM_DATA1;        /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd27[3];                   
  TM_POL_FLOW_PROFILE_MEM_DATA0_t          FLOW_PROFILE_MEM_DATA0;        /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd28[7];                   
  TM_POL_SPID_STATUS_MEM_ACCESS_t          SPID_STATUS_MEM_ACCESS;        /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd29[3];                   
  TM_POL_SPID_STATUS_MEM_DATA1_t           SPID_STATUS_MEM_DATA1;         /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd30[3];                   
  TM_POL_SPID_STATUS_MEM_DATA0_t           SPID_STATUS_MEM_DATA0;         /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd31[7];                   
  TM_POL_SPID_PROFILE_MEM_ACCESS_t         SPID_PROFILE_MEM_ACCESS;       /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd32[3];                   
  TM_POL_SPID_PROFILE_MEM_DATA1_t          SPID_PROFILE_MEM_DATA1;        /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd33[3];                   
  TM_POL_SPID_PROFILE_MEM_DATA0_t          SPID_PROFILE_MEM_DATA0;        /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd34[7];                   
  TM_POL_CPU_STATUS_MEM_ACCESS_t           CPU_STATUS_MEM_ACCESS;         /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd35[3];                   
  TM_POL_CPU_STATUS_MEM_DATA1_t            CPU_STATUS_MEM_DATA1;          /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd36[3];                   
  TM_POL_CPU_STATUS_MEM_DATA0_t            CPU_STATUS_MEM_DATA0;          /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd37[7];                   
  TM_POL_CPU_PROFILE_MEM_ACCESS_t          CPU_PROFILE_MEM_ACCESS;        /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd38[3];                   
  TM_POL_CPU_PROFILE_MEM_DATA1_t           CPU_PROFILE_MEM_DATA1;         /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd39[3];                   
  TM_POL_CPU_PROFILE_MEM_DATA0_t           CPU_PROFILE_MEM_DATA0;         /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd40[7];                   
  TM_POL_PKT_TYPE_STATUS_MEM_ACCESS_t      PKT_TYPE_STATUS_MEM_ACCESS;    /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd41[3];                   
  TM_POL_PKT_TYPE_STATUS_MEM_DATA1_t       PKT_TYPE_STATUS_MEM_DATA1;     /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd42[3];                   
  TM_POL_PKT_TYPE_STATUS_MEM_DATA0_t       PKT_TYPE_STATUS_MEM_DATA0;     /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd43[7];                   
  TM_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t     PKT_TYPE_PROFILE_MEM_ACCESS;   /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd44[3];                   
  TM_POL_PKT_TYPE_PROFILE_MEM_DATA1_t      PKT_TYPE_PROFILE_MEM_DATA1;    /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd45[3];                   
  TM_POL_PKT_TYPE_PROFILE_MEM_DATA0_t      PKT_TYPE_PROFILE_MEM_DATA0;    /* addr: 0x000000f8 */ 
} TM_POL_t;

  

/*
 * TC
 */
  



#define TM_TC_INTERRUPT_0                        0xf0040200
#define TM_TC_INTERRUPT_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 PMi                  :  1 ; /* bits 2:2 */
    cs_uint32 POLi                 :  1 ; /* bits 1:1 */
    cs_uint32 BMi                  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 BMi                  :  1 ; /* bits 0:0 */
    cs_uint32 POLi                 :  1 ; /* bits 1:1 */
    cs_uint32 PMi                  :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_TC_INTERRUPT_0_t;





#define TM_TC_INTENABLE_0                        0xf0040204
#define TM_TC_INTENABLE_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 PMe                  :  1 ; /* bits 2:2 */
    cs_uint32 POLe                 :  1 ; /* bits 1:1 */
    cs_uint32 BMe                  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 BMe                  :  1 ; /* bits 0:0 */
    cs_uint32 POLe                 :  1 ; /* bits 1:1 */
    cs_uint32 PMe                  :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_TC_INTENABLE_0_t;





#define TM_TC_INTERRUPT_1                        0xf0040208
#define TM_TC_INTERRUPT_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 PMi                  :  1 ; /* bits 2:2 */
    cs_uint32 POLi                 :  1 ; /* bits 1:1 */
    cs_uint32 BMi                  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 BMi                  :  1 ; /* bits 0:0 */
    cs_uint32 POLi                 :  1 ; /* bits 1:1 */
    cs_uint32 PMi                  :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_TC_INTERRUPT_1_t;





#define TM_TC_INTENABLE_1                        0xf004020c
#define TM_TC_INTENABLE_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 PMe                  :  1 ; /* bits 2:2 */
    cs_uint32 POLe                 :  1 ; /* bits 1:1 */
    cs_uint32 BMe                  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 BMe                  :  1 ; /* bits 0:0 */
    cs_uint32 POLe                 :  1 ; /* bits 1:1 */
    cs_uint32 PMe                  :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_TC_INTENABLE_1_t;





#define TM_TC_PAUSE_FRAME_PORT                   0xf0040210
#define TM_TC_PAUSE_FRAME_PORT_STRIDE            4
#define TM_TC_PAUSE_FRAME_PORT_COUNT             3
#define TM_TC_PAUSE_FRAME_PORT_dft               0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bm_pause_cnt         :  8 ; /* bits 31:24 */
    cs_uint32 bm_status            :  1 ; /* bits 23:23 */
    cs_uint32 bm_dying_gasp_enable :  1 ; /* bits 22:22 */
    cs_uint32 bm_warning_enable    :  1 ; /* bits 21:21 */
    cs_uint32 pol_pause_cnt        :  8 ; /* bits 20:13 */
    cs_uint32 pol_status           :  1 ; /* bits 12:12 */
    cs_uint32 pol_mode             :  1 ; /* bits 11:11 */
    cs_uint32 pol_enable           :  1 ; /* bits 10:10 */
    cs_uint32 clear_cnt_on_read    :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 logical_spid         :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 logical_spid         :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 clear_cnt_on_read    :  1 ; /* bits 9:9 */
    cs_uint32 pol_enable           :  1 ; /* bits 10:10 */
    cs_uint32 pol_mode             :  1 ; /* bits 11:11 */
    cs_uint32 pol_status           :  1 ; /* bits 12:12 */
    cs_uint32 pol_pause_cnt        :  8 ; /* bits 20:13 */
    cs_uint32 bm_warning_enable    :  1 ; /* bits 21:21 */
    cs_uint32 bm_dying_gasp_enable :  1 ; /* bits 22:22 */
    cs_uint32 bm_status            :  1 ; /* bits 23:23 */
    cs_uint32 bm_pause_cnt         :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_TC_PAUSE_FRAME_PORT_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TC */

typedef struct {
  TM_TC_INTERRUPT_0_t                      INTERRUPT_0;                   /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  TM_TC_INTENABLE_0_t                      INTENABLE_0;                   /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  TM_TC_INTERRUPT_1_t                      INTERRUPT_1;                   /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  TM_TC_INTENABLE_1_t                      INTENABLE_1;                   /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  TM_TC_PAUSE_FRAME_PORT_t                 PAUSE_FRAME_PORT;              /* addr: 0x00000010 */ 
} TM_TC_t;

  

/*
 * PM
 */
  



#define TM_PM_CONFIG_0                           0xf0040400
#define TM_PM_CONFIG_0_dft                       0x600000d1




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
    cs_uint32 disable              :  1 ; /* bits 30:30 */
    cs_uint32 bypass_disable_byte_cntrs :  1 ; /* bits 29:29 */
    cs_uint32 rsrvd2               : 21 ;
    cs_uint32 mark_mode            :  1 ; /* bits 7:7 */
    cs_uint32 cnt_mode             :  1 ; /* bits 6:6 */
    cs_uint32 auto_clear_on_read_mode :  2 ; /* bits 5:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 init                 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init                 :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 auto_clear_on_read_mode :  2 ; /* bits 5:4 */
    cs_uint32 cnt_mode             :  1 ; /* bits 6:6 */
    cs_uint32 mark_mode            :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd2               : 21 ;
    cs_uint32 bypass_disable_byte_cntrs :  1 ; /* bits 29:29 */
    cs_uint32 disable              :  1 ; /* bits 30:30 */
    cs_uint32 cpu_full_access      :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CONFIG_0_t;





#define TM_PM_CONFIG_SPARE                       0xf0040404
#define TM_PM_CONFIG_SPARE_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 config_spare         :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 config_spare         :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CONFIG_SPARE_t;





#define TM_PM_STATUS_0                           0xf0040408
#define TM_PM_STATUS_0_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 init_done            :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_STATUS_0_t;





#define TM_PM_CNTR_MEM_STATUS                    0xf004040c
#define TM_PM_CNTR_MEM_STATUS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 10 ;
    cs_uint32 err_cntr             :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 err_addr             : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 err_cntr             :  6 ; /* bits 21:16 */
    cs_uint32 rsrvd2               : 10 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_STATUS_t;





#define TM_PM_GLB_CNTR_MEM_STATUS                0xf0040410
#define TM_PM_GLB_CNTR_MEM_STATUS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 err_addr             : 30 ; /* bits 29:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 err_addr             : 30 ; /* bits 29:0 */
    cs_uint32 rsrvd1               :  2 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_GLB_CNTR_MEM_STATUS_t;





#define TM_PM_INTERRUPT_0                        0xf0040414
#define TM_PM_INTERRUPT_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_glb_cntr_mem     :  1 ; /* bits 20:20 */
    cs_uint32 err_cntr_mem         :  1 ; /* bits 19:19 */
    cs_uint32 glb_cntr_msb0        :  1 ; /* bits 18:18 */
    cs_uint32 cpu_copy_cntr_msb3   :  1 ; /* bits 17:17 */
    cs_uint32 cpu_copy_cntr_msb2   :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb1   :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb0   :  1 ; /* bits 14:14 */
    cs_uint32 pkt_type_cntr_msb1   :  1 ; /* bits 13:13 */
    cs_uint32 pkt_type_cntr_msb0   :  1 ; /* bits 12:12 */
    cs_uint32 cpu_cntr_msb0        :  1 ; /* bits 11:11 */
    cs_uint32 voq_cntr_msb1        :  1 ; /* bits 10:10 */
    cs_uint32 voq_cntr_msb0        :  1 ; /* bits 9:9 */
    cs_uint32 spid_cntr_msb0       :  1 ; /* bits 8:8 */
    cs_uint32 flow_cntr_msb7       :  1 ; /* bits 7:7 */
    cs_uint32 flow_cntr_msb6       :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb5       :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb4       :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb3       :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb2       :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb1       :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb0       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flow_cntr_msb0       :  1 ; /* bits 0:0 */
    cs_uint32 flow_cntr_msb1       :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb2       :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb3       :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb4       :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb5       :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb6       :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb7       :  1 ; /* bits 7:7 */
    cs_uint32 spid_cntr_msb0       :  1 ; /* bits 8:8 */
    cs_uint32 voq_cntr_msb0        :  1 ; /* bits 9:9 */
    cs_uint32 voq_cntr_msb1        :  1 ; /* bits 10:10 */
    cs_uint32 cpu_cntr_msb0        :  1 ; /* bits 11:11 */
    cs_uint32 pkt_type_cntr_msb0   :  1 ; /* bits 12:12 */
    cs_uint32 pkt_type_cntr_msb1   :  1 ; /* bits 13:13 */
    cs_uint32 cpu_copy_cntr_msb0   :  1 ; /* bits 14:14 */
    cs_uint32 cpu_copy_cntr_msb1   :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb2   :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb3   :  1 ; /* bits 17:17 */
    cs_uint32 glb_cntr_msb0        :  1 ; /* bits 18:18 */
    cs_uint32 err_cntr_mem         :  1 ; /* bits 19:19 */
    cs_uint32 err_glb_cntr_mem     :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd1               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_INTERRUPT_0_t;





#define TM_PM_INTENABLE_0                        0xf0040418
#define TM_PM_INTENABLE_0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_glb_cntr_mem_en  :  1 ; /* bits 20:20 */
    cs_uint32 err_cntr_mem_en      :  1 ; /* bits 19:19 */
    cs_uint32 glb_cntr_msb0_en     :  1 ; /* bits 18:18 */
    cs_uint32 cpu_copy_cntr_msb3_en :  1 ; /* bits 17:17 */
    cs_uint32 cpu_copy_cntr_msb2_en :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb1_en :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb0_en :  1 ; /* bits 14:14 */
    cs_uint32 pkt_type_cntr_msb1_en :  1 ; /* bits 13:13 */
    cs_uint32 pkt_type_cntr_msb0_en :  1 ; /* bits 12:12 */
    cs_uint32 cpu_cntr_msb0_en     :  1 ; /* bits 11:11 */
    cs_uint32 voq_cntr_msb1_en     :  1 ; /* bits 10:10 */
    cs_uint32 voq_cntr_msb0_en     :  1 ; /* bits 9:9 */
    cs_uint32 spid_cntr_msb0_en    :  1 ; /* bits 8:8 */
    cs_uint32 flow_cntr_msb7_en    :  1 ; /* bits 7:7 */
    cs_uint32 flow_cntr_msb6_en    :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb5_en    :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb4_en    :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb3_en    :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb2_en    :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb1_en    :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb0_en    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flow_cntr_msb0_en    :  1 ; /* bits 0:0 */
    cs_uint32 flow_cntr_msb1_en    :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb2_en    :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb3_en    :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb4_en    :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb5_en    :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb6_en    :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb7_en    :  1 ; /* bits 7:7 */
    cs_uint32 spid_cntr_msb0_en    :  1 ; /* bits 8:8 */
    cs_uint32 voq_cntr_msb0_en     :  1 ; /* bits 9:9 */
    cs_uint32 voq_cntr_msb1_en     :  1 ; /* bits 10:10 */
    cs_uint32 cpu_cntr_msb0_en     :  1 ; /* bits 11:11 */
    cs_uint32 pkt_type_cntr_msb0_en :  1 ; /* bits 12:12 */
    cs_uint32 pkt_type_cntr_msb1_en :  1 ; /* bits 13:13 */
    cs_uint32 cpu_copy_cntr_msb0_en :  1 ; /* bits 14:14 */
    cs_uint32 cpu_copy_cntr_msb1_en :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb2_en :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb3_en :  1 ; /* bits 17:17 */
    cs_uint32 glb_cntr_msb0_en     :  1 ; /* bits 18:18 */
    cs_uint32 err_cntr_mem_en      :  1 ; /* bits 19:19 */
    cs_uint32 err_glb_cntr_mem_en  :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd1               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_INTENABLE_0_t;





#define TM_PM_INTERRUPT_1                        0xf004041c
#define TM_PM_INTERRUPT_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_glb_cntr_mem     :  1 ; /* bits 20:20 */
    cs_uint32 err_cntr_mem         :  1 ; /* bits 19:19 */
    cs_uint32 glb_cntr_msb0        :  1 ; /* bits 18:18 */
    cs_uint32 cpu_copy_cntr_msb3   :  1 ; /* bits 17:17 */
    cs_uint32 cpu_copy_cntr_msb2   :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb1   :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb0   :  1 ; /* bits 14:14 */
    cs_uint32 pkt_type_cntr_msb1   :  1 ; /* bits 13:13 */
    cs_uint32 pkt_type_cntr_msb0   :  1 ; /* bits 12:12 */
    cs_uint32 cpu_cntr_msb0        :  1 ; /* bits 11:11 */
    cs_uint32 voq_cntr_msb1        :  1 ; /* bits 10:10 */
    cs_uint32 voq_cntr_msb0        :  1 ; /* bits 9:9 */
    cs_uint32 spid_cntr_msb0       :  1 ; /* bits 8:8 */
    cs_uint32 flow_cntr_msb7       :  1 ; /* bits 7:7 */
    cs_uint32 flow_cntr_msb6       :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb5       :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb4       :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb3       :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb2       :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb1       :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb0       :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flow_cntr_msb0       :  1 ; /* bits 0:0 */
    cs_uint32 flow_cntr_msb1       :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb2       :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb3       :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb4       :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb5       :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb6       :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb7       :  1 ; /* bits 7:7 */
    cs_uint32 spid_cntr_msb0       :  1 ; /* bits 8:8 */
    cs_uint32 voq_cntr_msb0        :  1 ; /* bits 9:9 */
    cs_uint32 voq_cntr_msb1        :  1 ; /* bits 10:10 */
    cs_uint32 cpu_cntr_msb0        :  1 ; /* bits 11:11 */
    cs_uint32 pkt_type_cntr_msb0   :  1 ; /* bits 12:12 */
    cs_uint32 pkt_type_cntr_msb1   :  1 ; /* bits 13:13 */
    cs_uint32 cpu_copy_cntr_msb0   :  1 ; /* bits 14:14 */
    cs_uint32 cpu_copy_cntr_msb1   :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb2   :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb3   :  1 ; /* bits 17:17 */
    cs_uint32 glb_cntr_msb0        :  1 ; /* bits 18:18 */
    cs_uint32 err_cntr_mem         :  1 ; /* bits 19:19 */
    cs_uint32 err_glb_cntr_mem     :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd1               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_INTERRUPT_1_t;





#define TM_PM_INTENABLE_1                        0xf0040420
#define TM_PM_INTENABLE_1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 err_glb_cntr_mem_en  :  1 ; /* bits 20:20 */
    cs_uint32 err_cntr_mem_en      :  1 ; /* bits 19:19 */
    cs_uint32 glb_cntr_msb0_en     :  1 ; /* bits 18:18 */
    cs_uint32 cpu_copy_cntr_msb3_en :  1 ; /* bits 17:17 */
    cs_uint32 cpu_copy_cntr_msb2_en :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb1_en :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb0_en :  1 ; /* bits 14:14 */
    cs_uint32 pkt_type_cntr_msb1_en :  1 ; /* bits 13:13 */
    cs_uint32 pkt_type_cntr_msb0_en :  1 ; /* bits 12:12 */
    cs_uint32 cpu_cntr_msb0_en     :  1 ; /* bits 11:11 */
    cs_uint32 voq_cntr_msb1_en     :  1 ; /* bits 10:10 */
    cs_uint32 voq_cntr_msb0_en     :  1 ; /* bits 9:9 */
    cs_uint32 spid_cntr_msb0_en    :  1 ; /* bits 8:8 */
    cs_uint32 flow_cntr_msb7_en    :  1 ; /* bits 7:7 */
    cs_uint32 flow_cntr_msb6_en    :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb5_en    :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb4_en    :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb3_en    :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb2_en    :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb1_en    :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb0_en    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flow_cntr_msb0_en    :  1 ; /* bits 0:0 */
    cs_uint32 flow_cntr_msb1_en    :  1 ; /* bits 1:1 */
    cs_uint32 flow_cntr_msb2_en    :  1 ; /* bits 2:2 */
    cs_uint32 flow_cntr_msb3_en    :  1 ; /* bits 3:3 */
    cs_uint32 flow_cntr_msb4_en    :  1 ; /* bits 4:4 */
    cs_uint32 flow_cntr_msb5_en    :  1 ; /* bits 5:5 */
    cs_uint32 flow_cntr_msb6_en    :  1 ; /* bits 6:6 */
    cs_uint32 flow_cntr_msb7_en    :  1 ; /* bits 7:7 */
    cs_uint32 spid_cntr_msb0_en    :  1 ; /* bits 8:8 */
    cs_uint32 voq_cntr_msb0_en     :  1 ; /* bits 9:9 */
    cs_uint32 voq_cntr_msb1_en     :  1 ; /* bits 10:10 */
    cs_uint32 cpu_cntr_msb0_en     :  1 ; /* bits 11:11 */
    cs_uint32 pkt_type_cntr_msb0_en :  1 ; /* bits 12:12 */
    cs_uint32 pkt_type_cntr_msb1_en :  1 ; /* bits 13:13 */
    cs_uint32 cpu_copy_cntr_msb0_en :  1 ; /* bits 14:14 */
    cs_uint32 cpu_copy_cntr_msb1_en :  1 ; /* bits 15:15 */
    cs_uint32 cpu_copy_cntr_msb2_en :  1 ; /* bits 16:16 */
    cs_uint32 cpu_copy_cntr_msb3_en :  1 ; /* bits 17:17 */
    cs_uint32 glb_cntr_msb0_en     :  1 ; /* bits 18:18 */
    cs_uint32 err_cntr_mem_en      :  1 ; /* bits 19:19 */
    cs_uint32 err_glb_cntr_mem_en  :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd1               : 11 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_INTENABLE_1_t;





#define TM_PM_CNTR_MEM_ACCESS                    0xf0040480
#define TM_PM_CNTR_MEM_ACCESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_ACCESS_t;





#define TM_PM_CNTR_MEM_DATA6                     0xf0040484
#define TM_PM_CNTR_MEM_DATA6_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 20 ;
    cs_uint32 data                 : 12 ; /* bits 11:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 12 ; /* bits 11:0 */
    cs_uint32 rsrvd1               : 20 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA6_t;





#define TM_PM_CNTR_MEM_DATA5                     0xf0040488
#define TM_PM_CNTR_MEM_DATA5_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA5_t;





#define TM_PM_CNTR_MEM_DATA4                     0xf004048c
#define TM_PM_CNTR_MEM_DATA4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA4_t;





#define TM_PM_CNTR_MEM_DATA3                     0xf0040490
#define TM_PM_CNTR_MEM_DATA3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA3_t;





#define TM_PM_CNTR_MEM_DATA2                     0xf0040494
#define TM_PM_CNTR_MEM_DATA2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA2_t;





#define TM_PM_CNTR_MEM_DATA1                     0xf0040498
#define TM_PM_CNTR_MEM_DATA1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA1_t;





#define TM_PM_CNTR_MEM_DATA0                     0xf004049c
#define TM_PM_CNTR_MEM_DATA0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_CNTR_MEM_DATA0_t;





#define TM_PM_GLB_CNTR_MEM_ACCESS                0xf00404a0
#define TM_PM_GLB_CNTR_MEM_ACCESS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 addr                 :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_GLB_CNTR_MEM_ACCESS_t;





#define TM_PM_GLB_CNTR_MEM_DATA2                 0xf00404a4
#define TM_PM_GLB_CNTR_MEM_DATA2_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 data                 :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_GLB_CNTR_MEM_DATA2_t;





#define TM_PM_GLB_CNTR_MEM_DATA1                 0xf00404a8
#define TM_PM_GLB_CNTR_MEM_DATA1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_GLB_CNTR_MEM_DATA1_t;





#define TM_PM_GLB_CNTR_MEM_DATA0                 0xf00404ac
#define TM_PM_GLB_CNTR_MEM_DATA0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} TM_PM_GLB_CNTR_MEM_DATA0_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PM */

typedef struct {
  TM_PM_CONFIG_0_t                         CONFIG_0;                      /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  TM_PM_CONFIG_SPARE_t                     CONFIG_SPARE;                  /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  TM_PM_STATUS_0_t                         STATUS_0;                      /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  TM_PM_CNTR_MEM_STATUS_t                  CNTR_MEM_STATUS;               /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  TM_PM_GLB_CNTR_MEM_STATUS_t              GLB_CNTR_MEM_STATUS;           /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  TM_PM_INTERRUPT_0_t                      INTERRUPT_0;                   /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  TM_PM_INTENABLE_0_t                      INTENABLE_0;                   /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  TM_PM_INTERRUPT_1_t                      INTERRUPT_1;                   /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  TM_PM_INTENABLE_1_t                      INTENABLE_1;                   /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[95];                   
  TM_PM_CNTR_MEM_ACCESS_t                  CNTR_MEM_ACCESS;               /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd10[3];                   
  TM_PM_CNTR_MEM_DATA6_t                   CNTR_MEM_DATA6;                /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd11[3];                   
  TM_PM_CNTR_MEM_DATA5_t                   CNTR_MEM_DATA5;                /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd12[3];                   
  TM_PM_CNTR_MEM_DATA4_t                   CNTR_MEM_DATA4;                /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd13[3];                   
  TM_PM_CNTR_MEM_DATA3_t                   CNTR_MEM_DATA3;                /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd14[3];                   
  TM_PM_CNTR_MEM_DATA2_t                   CNTR_MEM_DATA2;                /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd15[3];                   
  TM_PM_CNTR_MEM_DATA1_t                   CNTR_MEM_DATA1;                /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd16[3];                   
  TM_PM_CNTR_MEM_DATA0_t                   CNTR_MEM_DATA0;                /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd17[3];                   
  TM_PM_GLB_CNTR_MEM_ACCESS_t              GLB_CNTR_MEM_ACCESS;           /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd18[3];                   
  TM_PM_GLB_CNTR_MEM_DATA2_t               GLB_CNTR_MEM_DATA2;            /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd19[3];                   
  TM_PM_GLB_CNTR_MEM_DATA1_t               GLB_CNTR_MEM_DATA1;            /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd20[3];                   
  TM_PM_GLB_CNTR_MEM_DATA0_t               GLB_CNTR_MEM_DATA0;            /* addr: 0x000000ac */ 
} TM_PM_t;

  

  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TM */

typedef struct {
  TM_BM_t                                  BM;                            /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[149];                  
  TM_POL_t                                 POL;                           /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd2[131];                  
  TM_TC_t                                  TC;                            /* addr: 0x00000200 */ 
  cs_uint32                                rsrvd3[503];                  
  TM_PM_t                                  PM;                            /* addr: 0x00000400 */ 
} TM_t;


/*
 * FLASH_axi
 */
  



#define FLASH_ID                                 0xf0050000
#define FLASH_ID_dft                             0x00000101




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 flashDevID           : 24 ; /* bits 31:8 */
    cs_uint32 flashRevID           :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flashRevID           :  8 ; /* bits 7:0 */
    cs_uint32 flashDevID           : 24 ; /* bits 31:8 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_ID_t;





#define FLASH_TIMEOUT                            0xf0050004
#define FLASH_TIMEOUT_dft                        0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 timeout_load         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 timeout_load         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_TIMEOUT_t;





#define FLASH_STATUS                             0xf0050008
#define FLASH_STATUS_dft                         0x06000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  5 ;
    cs_uint32 nflash_rbIn_d        :  1 ; /* bits 26:26 */
    cs_uint32 pflash_rbIn_d        :  1 ; /* bits 25:25 */
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 nState               :  4 ; /* bits 11:8 */
    cs_uint32 pState               :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 sState               :  3 ; /* bits 2:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sState               :  3 ; /* bits 2:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 pState               :  4 ; /* bits 7:4 */
    cs_uint32 nState               :  4 ; /* bits 11:8 */
    cs_uint32 rsrvd2               : 13 ;
    cs_uint32 pflash_rbIn_d        :  1 ; /* bits 25:25 */
    cs_uint32 nflash_rbIn_d        :  1 ; /* bits 26:26 */
    cs_uint32 rsrvd3               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_STATUS_t;





#define FLASH_TYPE                               0xf005000c
#define FLASH_TYPE_dft                           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 16 ;
    cs_uint32 flashPin             :  1 ; /* bits 15:15 */
    cs_uint32 flashType            :  3 ; /* bits 14:12 */
    cs_uint32 flashWidth           :  1 ; /* bits 11:11 */
    cs_uint32 flashSize            :  2 ; /* bits 10:9 */
    cs_uint32 rsrvd1               :  9 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 flashSize            :  2 ; /* bits 10:9 */
    cs_uint32 flashWidth           :  1 ; /* bits 11:11 */
    cs_uint32 flashType            :  3 ; /* bits 14:12 */
    cs_uint32 flashPin             :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd2               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_TYPE_t;





#define FLASH_SF_ACCESS                          0xf0050010
#define FLASH_SF_ACCESS_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 14 ;
    cs_uint32 sflashHSRd           :  1 ; /* bits 17:17 */
    cs_uint32 sflashCeAlt          :  1 ; /* bits 16:16 */
    cs_uint32 sflashCnMode         :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 sflashForceBurst     :  1 ; /* bits 13:13 */
    cs_uint32 sflashForceTerm      :  1 ; /* bits 12:12 */
    cs_uint32 sflashAcCode         :  4 ; /* bits 11:8 */
    cs_uint32 sflashOpCode         :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sflashOpCode         :  8 ; /* bits 7:0 */
    cs_uint32 sflashAcCode         :  4 ; /* bits 11:8 */
    cs_uint32 sflashForceTerm      :  1 ; /* bits 12:12 */
    cs_uint32 sflashForceBurst     :  1 ; /* bits 13:13 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 sflashCnMode         :  1 ; /* bits 15:15 */
    cs_uint32 sflashCeAlt          :  1 ; /* bits 16:16 */
    cs_uint32 sflashHSRd           :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd2               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_SF_ACCESS_t;





#define FLASH_SF_ADDRESS                         0xf0050014
#define FLASH_SF_ADDRESS_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sflashRegAddr        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sflashRegAddr        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_SF_ADDRESS_t;





#define FLASH_SF_DATA                            0xf0050018
#define FLASH_SF_DATA_dft                        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 sflashRegWData       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sflashRegWData       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_SF_DATA_t;





#define FLASH_SF_TIMING                          0xf005001c
#define FLASH_SF_TIMING_dft                      0x00373737




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 sflashClkWidth       :  2 ; /* bits 25:24 */
    cs_uint32 sflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 sflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 sflashIdleTime       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sflashIdleTime       :  8 ; /* bits 7:0 */
    cs_uint32 sflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 sflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 sflashClkWidth       :  2 ; /* bits 25:24 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_SF_TIMING_t;





#define FLASH_PF_ACCESS                          0xf0050020
#define FLASH_PF_ACCESS_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               :  8 ;
    cs_uint32 pflashWrPol          :  1 ; /* bits 23:23 */
    cs_uint32 pflashRdPol          :  1 ; /* bits 22:22 */
    cs_uint32 pflashBzPol          :  1 ; /* bits 21:21 */
    cs_uint32 pflashBzChk          :  1 ; /* bits 20:20 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 pflashCeAlt          :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 pflashExtAddr        :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pflashExtAddr        :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 11 ;
    cs_uint32 pflashCeAlt          :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 pflashBzChk          :  1 ; /* bits 20:20 */
    cs_uint32 pflashBzPol          :  1 ; /* bits 21:21 */
    cs_uint32 pflashRdPol          :  1 ; /* bits 22:22 */
    cs_uint32 pflashWrPol          :  1 ; /* bits 23:23 */
    cs_uint32 rsrvd3               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_PF_ACCESS_t;





#define FLASH_PF_TIMING                          0xf0050024
#define FLASH_PF_TIMING_dft                      0x000f0f07




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  6 ;
    cs_uint32 pflashClkWidth       :  2 ; /* bits 25:24 */
    cs_uint32 pflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 pflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 pflashIdleTime       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 pflashIdleTime       :  8 ; /* bits 7:0 */
    cs_uint32 pflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 pflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 pflashClkWidth       :  2 ; /* bits 25:24 */
    cs_uint32 rsrvd1               :  6 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_PF_TIMING_t;





#define FLASH_NF_ACCESS                          0xf0050028
#define FLASH_NF_ACCESS_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd4               :  4 ;
    cs_uint32 FIFO_WRTH            :  2 ; /* bits 27:26 */
    cs_uint32 FIFO_RDTH            :  2 ; /* bits 25:24 */
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 autoReset            :  1 ; /* bits 16:16 */
    cs_uint32 nflashCeAlt          :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 nflashRegWidth       :  2 ; /* bits 11:10 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 nflashExtAddr        :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashExtAddr        :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 nflashRegWidth       :  2 ; /* bits 11:10 */
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 nflashCeAlt          :  1 ; /* bits 15:15 */
    cs_uint32 autoReset            :  1 ; /* bits 16:16 */
    cs_uint32 rsrvd3               :  7 ;
    cs_uint32 FIFO_RDTH            :  2 ; /* bits 25:24 */
    cs_uint32 FIFO_WRTH            :  2 ; /* bits 27:26 */
    cs_uint32 rsrvd4               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ACCESS_t;





#define FLASH_NF_COUNT                           0xf005002c
#define FLASH_NF_COUNT_dft                       0xffffff00




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 nflashRegOobCount    : 10 ; /* bits 31:22 */
    cs_uint32 nflashRegDataCount   : 14 ; /* bits 21:8 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 nflashRegAddrCount   :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 nflashRegCmdCount    :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegCmdCount    :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 nflashRegAddrCount   :  3 ; /* bits 6:4 */
    cs_uint32 rsrvd2               :  1 ;
    cs_uint32 nflashRegDataCount   : 14 ; /* bits 21:8 */
    cs_uint32 nflashRegOobCount    : 10 ; /* bits 31:22 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_COUNT_t;





#define FLASH_NF_COMMAND                         0xf0050030
#define FLASH_NF_COMMAND_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  8 ;
    cs_uint32 nflashRegCmd2        :  8 ; /* bits 23:16 */
    cs_uint32 nflashRegCmd1        :  8 ; /* bits 15:8 */
    cs_uint32 nflashRegCmd0        :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegCmd0        :  8 ; /* bits 7:0 */
    cs_uint32 nflashRegCmd1        :  8 ; /* bits 15:8 */
    cs_uint32 nflashRegCmd2        :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd1               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_COMMAND_t;





#define FLASH_NF_ADDRESS_1                       0xf0050034
#define FLASH_NF_ADDRESS_1_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 nflashRegAddr3       :  8 ; /* bits 31:24 */
    cs_uint32 nflashRegAddr2       :  8 ; /* bits 23:16 */
    cs_uint32 nflashRegAddr1       :  8 ; /* bits 15:8 */
    cs_uint32 nflashRegAddr0       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegAddr0       :  8 ; /* bits 7:0 */
    cs_uint32 nflashRegAddr1       :  8 ; /* bits 15:8 */
    cs_uint32 nflashRegAddr2       :  8 ; /* bits 23:16 */
    cs_uint32 nflashRegAddr3       :  8 ; /* bits 31:24 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ADDRESS_1_t;





#define FLASH_NF_ADDRESS_2                       0xf0050038
#define FLASH_NF_ADDRESS_2_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 nflashRegAddr4       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegAddr4       :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ADDRESS_2_t;





#define FLASH_NF_DATA                            0xf005003c
#define FLASH_NF_DATA_dft                        0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 nflashRegWData       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegWData       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_DATA_t;





#define FLASH_NF_TIMING                          0xf0050040
#define FLASH_NF_TIMING_dft                      0x00041703




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 nflashClkWidth       :  3 ; /* bits 26:24 */
    cs_uint32 nflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 nflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 nflashIdleTime       :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashIdleTime       :  8 ; /* bits 7:0 */
    cs_uint32 nflashHoldTime       :  8 ; /* bits 15:8 */
    cs_uint32 nflashSetupTime      :  8 ; /* bits 23:16 */
    cs_uint32 nflashClkWidth       :  3 ; /* bits 26:24 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_TIMING_t;





#define FLASH_NF_ECC_STATUS                      0xf0050044
#define FLASH_NF_ECC_STATUS_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccDone              :  1 ; /* bits 31:31 */
    cs_uint32 rsrvd2               :  7 ;
    cs_uint32 eccErrWord           :  8 ; /* bits 23:16 */
    cs_uint32 eccErrByte           :  9 ; /* bits 15:7 */
    cs_uint32 eccErrBit            :  4 ; /* bits 6:3 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 eccStatus            :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccStatus            :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 eccErrBit            :  4 ; /* bits 6:3 */
    cs_uint32 eccErrByte           :  9 ; /* bits 15:7 */
    cs_uint32 eccErrWord           :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd2               :  7 ;
    cs_uint32 eccDone              :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_STATUS_t;





#define FLASH_NF_ECC_CONTROL                     0xf0050048
#define FLASH_NF_ECC_CONTROL_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               : 23 ;
    cs_uint32 eccEn                :  1 ; /* bits 8:8 */
    cs_uint32 eccCodeSel           :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 eccGenMode           :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  1 ;
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 eccGenMode           :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd2               :  2 ;
    cs_uint32 eccCodeSel           :  4 ; /* bits 7:4 */
    cs_uint32 eccEn                :  1 ; /* bits 8:8 */
    cs_uint32 rsrvd3               : 23 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_CONTROL_t;





#define FLASH_NF_ECC_OOB                         0xf005004c
#define FLASH_NF_ECC_OOB_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeOob           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeOob           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_OOB_t;





#define FLASH_NF_ECC_GEN0                        0xf0050050
#define FLASH_NF_ECC_GEN0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen0          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen0          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN0_t;





#define FLASH_NF_ECC_GEN1                        0xf0050054
#define FLASH_NF_ECC_GEN1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen1          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen1          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN1_t;





#define FLASH_NF_ECC_GEN2                        0xf0050058
#define FLASH_NF_ECC_GEN2_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen2          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen2          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN2_t;





#define FLASH_NF_ECC_GEN3                        0xf005005c
#define FLASH_NF_ECC_GEN3_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen3          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen3          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN3_t;





#define FLASH_NF_ECC_GEN4                        0xf0050060
#define FLASH_NF_ECC_GEN4_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen4          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen4          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN4_t;





#define FLASH_NF_ECC_GEN5                        0xf0050064
#define FLASH_NF_ECC_GEN5_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen5          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen5          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN5_t;





#define FLASH_NF_ECC_GEN6                        0xf0050068
#define FLASH_NF_ECC_GEN6_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen6          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen6          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN6_t;





#define FLASH_NF_ECC_GEN7                        0xf005006c
#define FLASH_NF_ECC_GEN7_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen7          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen7          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN7_t;





#define FLASH_NF_ECC_GEN8                        0xf0050070
#define FLASH_NF_ECC_GEN8_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen8          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen8          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN8_t;





#define FLASH_NF_ECC_GEN9                        0xf0050074
#define FLASH_NF_ECC_GEN9_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen9          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen9          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN9_t;





#define FLASH_NF_ECC_GEN10                       0xf0050078
#define FLASH_NF_ECC_GEN10_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen10         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen10         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN10_t;





#define FLASH_NF_ECC_GEN11                       0xf005007c
#define FLASH_NF_ECC_GEN11_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen11         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen11         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN11_t;





#define FLASH_NF_ECC_GEN12                       0xf0050080
#define FLASH_NF_ECC_GEN12_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen12         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen12         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN12_t;





#define FLASH_NF_ECC_GEN13                       0xf0050084
#define FLASH_NF_ECC_GEN13_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen13         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen13         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN13_t;





#define FLASH_NF_ECC_GEN14                       0xf0050088
#define FLASH_NF_ECC_GEN14_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen14         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen14         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN14_t;





#define FLASH_NF_ECC_GEN15                       0xf005008c
#define FLASH_NF_ECC_GEN15_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 eccCodeGen15         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccCodeGen15         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_GEN15_t;





#define FLASH_NF_FIFO_CONTROL                    0xf0050090
#define FLASH_NF_FIFO_CONTROL_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 24 ;
    cs_uint32 fifoDbgSel           :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 fifoCmd              :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 fifoCmd              :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 fifoDbgSel           :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd2               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_FIFO_CONTROL_t;





#define FLASH_NF_FIFO_STATUS                     0xf0050094
#define FLASH_NF_FIFO_STATUS_dft                 0x00000004




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  8 ;
    cs_uint32 f_addr_count         :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 f_ptr_wr             :  5 ; /* bits 13:9 */
    cs_uint32 f_ptr_rd             :  5 ; /* bits 8:4 */
    cs_uint32 f_full               :  1 ; /* bits 3:3 */
    cs_uint32 f_empty              :  1 ; /* bits 2:2 */
    cs_uint32 f_state              :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 f_state              :  2 ; /* bits 1:0 */
    cs_uint32 f_empty              :  1 ; /* bits 2:2 */
    cs_uint32 f_full               :  1 ; /* bits 3:3 */
    cs_uint32 f_ptr_rd             :  5 ; /* bits 8:4 */
    cs_uint32 f_ptr_wr             :  5 ; /* bits 13:9 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 f_addr_count         :  8 ; /* bits 23:16 */
    cs_uint32 rsrvd2               :  8 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_FIFO_STATUS_t;





#define FLASH_NF_FIFO_ADDRESS                    0xf0050098
#define FLASH_NF_FIFO_ADDRESS_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 f_AXADDR             : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 f_AXADDR             : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_FIFO_ADDRESS_t;





#define FLASH_NF_FIFO_MATCH_ADDRESS              0xf005009c
#define FLASH_NF_FIFO_MATCH_ADDRESS_dft          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 f_AXADDR_compare     : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 f_AXADDR_compare     : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_FIFO_MATCH_ADDRESS_t;





#define FLASH_NF_FIFO_DATA                       0xf00500a0
#define FLASH_NF_FIFO_DATA_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 f_ebuf_mem1          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 f_ebuf_mem1          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_FIFO_DATA_t;





#define FLASH_FLASH_ACCESS_START                 0xf00500a4
#define FLASH_FLASH_ACCESS_START_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 18 ;
    cs_uint32 nflashRegCmd         :  2 ; /* bits 13:12 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 fifoReq              :  1 ; /* bits 2:2 */
    cs_uint32 sflashRegReq         :  1 ; /* bits 1:1 */
    cs_uint32 nflashRegReq         :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 nflashRegReq         :  1 ; /* bits 0:0 */
    cs_uint32 sflashRegReq         :  1 ; /* bits 1:1 */
    cs_uint32 fifoReq              :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               :  9 ;
    cs_uint32 nflashRegCmd         :  2 ; /* bits 13:12 */
    cs_uint32 rsrvd2               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_FLASH_ACCESS_START_t;





#define FLASH_NF_ECC_RESET                       0xf00500a8
#define FLASH_NF_ECC_RESET_dft                   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 29 ;
    cs_uint32 nflash_reset         :  1 ; /* bits 2:2 */
    cs_uint32 fifoClear            :  1 ; /* bits 1:1 */
    cs_uint32 eccClear             :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 eccClear             :  1 ; /* bits 0:0 */
    cs_uint32 fifoClear            :  1 ; /* bits 1:1 */
    cs_uint32 nflash_reset         :  1 ; /* bits 2:2 */
    cs_uint32 rsrvd1               : 29 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_ECC_RESET_t;





#define FLASH_FLASH_INTERRUPT                    0xf00500ac
#define FLASH_FLASH_INTERRUPT_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 24 ;
    cs_uint32 bchDecIrq            :  1 ; /* bits 7:7 */
    cs_uint32 bchGenIrq            :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nfWdtIrq             :  1 ; /* bits 4:4 */
    cs_uint32 eccIrq               :  1 ; /* bits 3:3 */
    cs_uint32 f_addr_err           :  1 ; /* bits 2:2 */
    cs_uint32 fifoIrq              :  1 ; /* bits 1:1 */
    cs_uint32 regIrq               :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 regIrq               :  1 ; /* bits 0:0 */
    cs_uint32 fifoIrq              :  1 ; /* bits 1:1 */
    cs_uint32 f_addr_err           :  1 ; /* bits 2:2 */
    cs_uint32 eccIrq               :  1 ; /* bits 3:3 */
    cs_uint32 nfWdtIrq             :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 bchGenIrq            :  1 ; /* bits 6:6 */
    cs_uint32 bchDecIrq            :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd2               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_FLASH_INTERRUPT_t;





#define FLASH_FLASH_MASK                         0xf00500b0
#define FLASH_FLASH_MASK_dft                     0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               : 24 ;
    cs_uint32 bchDecIrqMask        :  1 ; /* bits 7:7 */
    cs_uint32 bchGenIrqMask        :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 nfWdtIrqMask         :  1 ; /* bits 4:4 */
    cs_uint32 eccIrqMask           :  1 ; /* bits 3:3 */
    cs_uint32 f_addr_IrqMask       :  1 ; /* bits 2:2 */
    cs_uint32 fifoIrqMask          :  1 ; /* bits 1:1 */
    cs_uint32 flashRegIrqMask      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flashRegIrqMask      :  1 ; /* bits 0:0 */
    cs_uint32 fifoIrqMask          :  1 ; /* bits 1:1 */
    cs_uint32 f_addr_IrqMask       :  1 ; /* bits 2:2 */
    cs_uint32 eccIrqMask           :  1 ; /* bits 3:3 */
    cs_uint32 nfWdtIrqMask         :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  1 ;
    cs_uint32 bchGenIrqMask        :  1 ; /* bits 6:6 */
    cs_uint32 bchDecIrqMask        :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd2               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_FLASH_MASK_t;





#define FLASH_NF_BCH_STATUS                      0xf00500b4
#define FLASH_NF_BCH_STATUS_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchGenDone           :  1 ; /* bits 31:31 */
    cs_uint32 bchDecDone           :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd2               : 22 ;
    cs_uint32 bchErrNum            :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 bchDecStatus         :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchDecStatus         :  2 ; /* bits 1:0 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 bchErrNum            :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd2               : 22 ;
    cs_uint32 bchDecDone           :  1 ; /* bits 30:30 */
    cs_uint32 bchGenDone           :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_STATUS_t;





#define FLASH_NF_BCH_ERROR_LOC01                 0xf00500b8
#define FLASH_NF_BCH_ERROR_LOC01_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc1           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc0           : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc0           : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc1           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC01_t;





#define FLASH_NF_BCH_ERROR_LOC23                 0xf00500bc
#define FLASH_NF_BCH_ERROR_LOC23_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc3           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc2           : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc2           : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc3           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC23_t;





#define FLASH_NF_BCH_ERROR_LOC45                 0xf00500c0
#define FLASH_NF_BCH_ERROR_LOC45_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc5           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc4           : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc4           : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc5           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC45_t;





#define FLASH_NF_BCH_ERROR_LOC67                 0xf00500c4
#define FLASH_NF_BCH_ERROR_LOC67_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc7           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc6           : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc6           : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc7           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC67_t;





#define FLASH_NF_BCH_ERROR_LOC89                 0xf00500c8
#define FLASH_NF_BCH_ERROR_LOC89_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc9           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc8           : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc8           : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc9           : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC89_t;





#define FLASH_NF_BCH_ERROR_LOC1011               0xf00500cc
#define FLASH_NF_BCH_ERROR_LOC1011_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  3 ;
    cs_uint32 bchErrLoc11          : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc10          : 13 ; /* bits 12:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchErrLoc10          : 13 ; /* bits 12:0 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 bchErrLoc11          : 13 ; /* bits 28:16 */
    cs_uint32 rsrvd2               :  3 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_ERROR_LOC1011_t;





#define FLASH_NF_BCH_CONTROL                     0xf00500d0
#define FLASH_NF_BCH_CONTROL_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd3               : 12 ;
    cs_uint32 bchTestCtrl          :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 bchErrCap            :  1 ; /* bits 9:9 */
    cs_uint32 bchEn                :  1 ; /* bits 8:8 */
    cs_uint32 bchCodeSel           :  4 ; /* bits 7:4 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 bchOpcode            :  1 ; /* bits 1:1 */
    cs_uint32 bchCompare           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCompare           :  1 ; /* bits 0:0 */
    cs_uint32 bchOpcode            :  1 ; /* bits 1:1 */
    cs_uint32 rsrvd1               :  2 ;
    cs_uint32 bchCodeSel           :  4 ; /* bits 7:4 */
    cs_uint32 bchEn                :  1 ; /* bits 8:8 */
    cs_uint32 bchErrCap            :  1 ; /* bits 9:9 */
    cs_uint32 rsrvd2               :  6 ;
    cs_uint32 bchTestCtrl          :  4 ; /* bits 19:16 */
    cs_uint32 rsrvd3               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_CONTROL_t;





#define FLASH_NF_BCH_OOB0                        0xf00500d4
#define FLASH_NF_BCH_OOB0_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeOob0          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeOob0          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_OOB0_t;





#define FLASH_NF_BCH_OOB1                        0xf00500d8
#define FLASH_NF_BCH_OOB1_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeOob1          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeOob1          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_OOB1_t;





#define FLASH_NF_BCH_OOB2                        0xf00500dc
#define FLASH_NF_BCH_OOB2_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeOob2          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeOob2          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_OOB2_t;





#define FLASH_NF_BCH_OOB3                        0xf00500e0
#define FLASH_NF_BCH_OOB3_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeOob3          : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeOob3          : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_OOB3_t;





#define FLASH_NF_BCH_OOB4                        0xf00500e4
#define FLASH_NF_BCH_OOB4_dft                    0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeOob4          : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeOob4          : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_OOB4_t;





#define FLASH_NF_BCH_GEN0_0                      0xf00500e8
#define FLASH_NF_BCH_GEN0_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen0_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen0_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN0_0_t;





#define FLASH_NF_BCH_GEN0_1                      0xf00500ec
#define FLASH_NF_BCH_GEN0_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen0_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen0_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN0_1_t;





#define FLASH_NF_BCH_GEN0_2                      0xf00500f0
#define FLASH_NF_BCH_GEN0_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen0_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen0_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN0_2_t;





#define FLASH_NF_BCH_GEN0_3                      0xf00500f4
#define FLASH_NF_BCH_GEN0_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen0_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen0_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN0_3_t;





#define FLASH_NF_BCH_GEN0_4                      0xf00500f8
#define FLASH_NF_BCH_GEN0_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen0_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen0_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN0_4_t;





#define FLASH_NF_BCH_GEN1_0                      0xf00500fc
#define FLASH_NF_BCH_GEN1_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen1_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen1_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN1_0_t;





#define FLASH_NF_BCH_GEN1_1                      0xf0050100
#define FLASH_NF_BCH_GEN1_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen1_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen1_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN1_1_t;





#define FLASH_NF_BCH_GEN1_2                      0xf0050104
#define FLASH_NF_BCH_GEN1_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen1_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen1_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN1_2_t;





#define FLASH_NF_BCH_GEN1_3                      0xf0050108
#define FLASH_NF_BCH_GEN1_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen1_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen1_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN1_3_t;





#define FLASH_NF_BCH_GEN1_4                      0xf005010c
#define FLASH_NF_BCH_GEN1_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen1_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen1_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN1_4_t;





#define FLASH_NF_BCH_GEN2_0                      0xf0050110
#define FLASH_NF_BCH_GEN2_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen2_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen2_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN2_0_t;





#define FLASH_NF_BCH_GEN2_1                      0xf0050114
#define FLASH_NF_BCH_GEN2_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen2_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen2_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN2_1_t;





#define FLASH_NF_BCH_GEN2_2                      0xf0050118
#define FLASH_NF_BCH_GEN2_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen2_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen2_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN2_2_t;





#define FLASH_NF_BCH_GEN2_3                      0xf005011c
#define FLASH_NF_BCH_GEN2_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen2_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen2_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN2_3_t;





#define FLASH_NF_BCH_GEN2_4                      0xf0050120
#define FLASH_NF_BCH_GEN2_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen2_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen2_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN2_4_t;





#define FLASH_NF_BCH_GEN3_0                      0xf0050124
#define FLASH_NF_BCH_GEN3_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen3_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen3_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN3_0_t;





#define FLASH_NF_BCH_GEN3_1                      0xf0050128
#define FLASH_NF_BCH_GEN3_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen3_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen3_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN3_1_t;





#define FLASH_NF_BCH_GEN3_2                      0xf005012c
#define FLASH_NF_BCH_GEN3_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen3_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen3_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN3_2_t;





#define FLASH_NF_BCH_GEN3_3                      0xf0050130
#define FLASH_NF_BCH_GEN3_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen3_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen3_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN3_3_t;





#define FLASH_NF_BCH_GEN3_4                      0xf0050134
#define FLASH_NF_BCH_GEN3_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen3_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen3_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN3_4_t;





#define FLASH_NF_BCH_GEN4_0                      0xf0050138
#define FLASH_NF_BCH_GEN4_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen4_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen4_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN4_0_t;





#define FLASH_NF_BCH_GEN4_1                      0xf005013c
#define FLASH_NF_BCH_GEN4_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen4_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen4_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN4_1_t;





#define FLASH_NF_BCH_GEN4_2                      0xf0050140
#define FLASH_NF_BCH_GEN4_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen4_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen4_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN4_2_t;





#define FLASH_NF_BCH_GEN4_3                      0xf0050144
#define FLASH_NF_BCH_GEN4_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen4_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen4_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN4_3_t;





#define FLASH_NF_BCH_GEN4_4                      0xf0050148
#define FLASH_NF_BCH_GEN4_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen4_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen4_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN4_4_t;





#define FLASH_NF_BCH_GEN5_0                      0xf005014c
#define FLASH_NF_BCH_GEN5_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen5_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen5_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN5_0_t;





#define FLASH_NF_BCH_GEN5_1                      0xf0050150
#define FLASH_NF_BCH_GEN5_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen5_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen5_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN5_1_t;





#define FLASH_NF_BCH_GEN5_2                      0xf0050154
#define FLASH_NF_BCH_GEN5_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen5_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen5_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN5_2_t;





#define FLASH_NF_BCH_GEN5_3                      0xf0050158
#define FLASH_NF_BCH_GEN5_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen5_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen5_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN5_3_t;





#define FLASH_NF_BCH_GEN5_4                      0xf005015c
#define FLASH_NF_BCH_GEN5_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen5_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen5_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN5_4_t;





#define FLASH_NF_BCH_GEN6_0                      0xf0050160
#define FLASH_NF_BCH_GEN6_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen6_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen6_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN6_0_t;





#define FLASH_NF_BCH_GEN6_1                      0xf0050164
#define FLASH_NF_BCH_GEN6_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen6_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen6_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN6_1_t;





#define FLASH_NF_BCH_GEN6_2                      0xf0050168
#define FLASH_NF_BCH_GEN6_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen6_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen6_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN6_2_t;





#define FLASH_NF_BCH_GEN6_3                      0xf005016c
#define FLASH_NF_BCH_GEN6_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen6_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen6_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN6_3_t;





#define FLASH_NF_BCH_GEN6_4                      0xf0050170
#define FLASH_NF_BCH_GEN6_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen6_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen6_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN6_4_t;





#define FLASH_NF_BCH_GEN7_0                      0xf0050174
#define FLASH_NF_BCH_GEN7_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen7_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen7_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN7_0_t;





#define FLASH_NF_BCH_GEN7_1                      0xf0050178
#define FLASH_NF_BCH_GEN7_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen7_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen7_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN7_1_t;





#define FLASH_NF_BCH_GEN7_2                      0xf005017c
#define FLASH_NF_BCH_GEN7_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen7_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen7_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN7_2_t;





#define FLASH_NF_BCH_GEN7_3                      0xf0050180
#define FLASH_NF_BCH_GEN7_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen7_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen7_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN7_3_t;





#define FLASH_NF_BCH_GEN7_4                      0xf0050184
#define FLASH_NF_BCH_GEN7_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen7_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen7_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN7_4_t;





#define FLASH_NF_BCH_GEN8_0                      0xf0050188
#define FLASH_NF_BCH_GEN8_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen8_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen8_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN8_0_t;





#define FLASH_NF_BCH_GEN8_1                      0xf005018c
#define FLASH_NF_BCH_GEN8_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen8_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen8_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN8_1_t;





#define FLASH_NF_BCH_GEN8_2                      0xf0050190
#define FLASH_NF_BCH_GEN8_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen8_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen8_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN8_2_t;





#define FLASH_NF_BCH_GEN8_3                      0xf0050194
#define FLASH_NF_BCH_GEN8_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen8_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen8_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN8_3_t;





#define FLASH_NF_BCH_GEN8_4                      0xf0050198
#define FLASH_NF_BCH_GEN8_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen8_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen8_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN8_4_t;





#define FLASH_NF_BCH_GEN9_0                      0xf005019c
#define FLASH_NF_BCH_GEN9_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen9_0        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen9_0        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN9_0_t;





#define FLASH_NF_BCH_GEN9_1                      0xf00501a0
#define FLASH_NF_BCH_GEN9_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen9_1        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen9_1        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN9_1_t;





#define FLASH_NF_BCH_GEN9_2                      0xf00501a4
#define FLASH_NF_BCH_GEN9_2_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen9_2        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen9_2        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN9_2_t;





#define FLASH_NF_BCH_GEN9_3                      0xf00501a8
#define FLASH_NF_BCH_GEN9_3_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen9_3        : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen9_3        : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN9_3_t;





#define FLASH_NF_BCH_GEN9_4                      0xf00501ac
#define FLASH_NF_BCH_GEN9_4_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen9_4        : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen9_4        : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN9_4_t;





#define FLASH_NF_BCH_GEN10_0                     0xf00501b0
#define FLASH_NF_BCH_GEN10_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen10_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen10_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN10_0_t;





#define FLASH_NF_BCH_GEN10_1                     0xf00501b4
#define FLASH_NF_BCH_GEN10_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen10_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen10_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN10_1_t;





#define FLASH_NF_BCH_GEN10_2                     0xf00501b8
#define FLASH_NF_BCH_GEN10_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen10_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen10_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN10_2_t;





#define FLASH_NF_BCH_GEN10_3                     0xf00501bc
#define FLASH_NF_BCH_GEN10_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen10_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen10_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN10_3_t;





#define FLASH_NF_BCH_GEN10_4                     0xf00501c0
#define FLASH_NF_BCH_GEN10_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen10_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen10_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN10_4_t;





#define FLASH_NF_BCH_GEN11_0                     0xf00501c4
#define FLASH_NF_BCH_GEN11_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen11_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen11_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN11_0_t;





#define FLASH_NF_BCH_GEN11_1                     0xf00501c8
#define FLASH_NF_BCH_GEN11_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen11_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen11_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN11_1_t;





#define FLASH_NF_BCH_GEN11_2                     0xf00501cc
#define FLASH_NF_BCH_GEN11_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen11_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen11_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN11_2_t;





#define FLASH_NF_BCH_GEN11_3                     0xf00501d0
#define FLASH_NF_BCH_GEN11_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen11_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen11_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN11_3_t;





#define FLASH_NF_BCH_GEN11_4                     0xf00501d4
#define FLASH_NF_BCH_GEN11_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen11_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen11_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN11_4_t;





#define FLASH_NF_BCH_GEN12_0                     0xf00501d8
#define FLASH_NF_BCH_GEN12_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen12_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen12_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN12_0_t;





#define FLASH_NF_BCH_GEN12_1                     0xf00501dc
#define FLASH_NF_BCH_GEN12_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen12_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen12_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN12_1_t;





#define FLASH_NF_BCH_GEN12_2                     0xf00501e0
#define FLASH_NF_BCH_GEN12_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen12_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen12_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN12_2_t;





#define FLASH_NF_BCH_GEN12_3                     0xf00501e4
#define FLASH_NF_BCH_GEN12_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen12_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen12_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN12_3_t;





#define FLASH_NF_BCH_GEN12_4                     0xf00501e8
#define FLASH_NF_BCH_GEN12_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen12_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen12_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN12_4_t;





#define FLASH_NF_BCH_GEN13_0                     0xf00501ec
#define FLASH_NF_BCH_GEN13_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen13_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen13_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN13_0_t;





#define FLASH_NF_BCH_GEN13_1                     0xf00501f0
#define FLASH_NF_BCH_GEN13_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen13_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen13_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN13_1_t;





#define FLASH_NF_BCH_GEN13_2                     0xf00501f4
#define FLASH_NF_BCH_GEN13_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen13_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen13_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN13_2_t;





#define FLASH_NF_BCH_GEN13_3                     0xf00501f8
#define FLASH_NF_BCH_GEN13_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen13_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen13_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN13_3_t;





#define FLASH_NF_BCH_GEN13_4                     0xf00501fc
#define FLASH_NF_BCH_GEN13_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen13_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen13_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN13_4_t;





#define FLASH_NF_BCH_GEN14_0                     0xf0050200
#define FLASH_NF_BCH_GEN14_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen14_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen14_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN14_0_t;





#define FLASH_NF_BCH_GEN14_1                     0xf0050204
#define FLASH_NF_BCH_GEN14_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen14_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen14_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN14_1_t;





#define FLASH_NF_BCH_GEN14_2                     0xf0050208
#define FLASH_NF_BCH_GEN14_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen14_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen14_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN14_2_t;





#define FLASH_NF_BCH_GEN14_3                     0xf005020c
#define FLASH_NF_BCH_GEN14_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen14_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen14_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN14_3_t;





#define FLASH_NF_BCH_GEN14_4                     0xf0050210
#define FLASH_NF_BCH_GEN14_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen14_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen14_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN14_4_t;





#define FLASH_NF_BCH_GEN15_0                     0xf0050214
#define FLASH_NF_BCH_GEN15_0_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen15_0       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen15_0       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN15_0_t;





#define FLASH_NF_BCH_GEN15_1                     0xf0050218
#define FLASH_NF_BCH_GEN15_1_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen15_1       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen15_1       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN15_1_t;





#define FLASH_NF_BCH_GEN15_2                     0xf005021c
#define FLASH_NF_BCH_GEN15_2_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen15_2       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen15_2       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN15_2_t;





#define FLASH_NF_BCH_GEN15_3                     0xf0050220
#define FLASH_NF_BCH_GEN15_3_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 bchCodeGen15_3       : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen15_3       : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN15_3_t;





#define FLASH_NF_BCH_GEN15_4                     0xf0050224
#define FLASH_NF_BCH_GEN15_4_dft                 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 bchCodeGen15_4       : 28 ; /* bits 27:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 bchCodeGen15_4       : 28 ; /* bits 27:0 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_NF_BCH_GEN15_4_t;





#define FLASH_FLASH_SPARE_0                      0xf0050228
#define FLASH_FLASH_SPARE_0_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 flash_spare0         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flash_spare0         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_FLASH_SPARE_0_t;





#define FLASH_FLASH_SPARE_1                      0xf005022c
#define FLASH_FLASH_SPARE_1_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 flash_spare1         : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 flash_spare1         : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} FLASH_FLASH_SPARE_1_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FLASH_axi */

typedef struct {
  FLASH_ID_t                               ID;                            /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  FLASH_TIMEOUT_t                          TIMEOUT;                       /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  FLASH_STATUS_t                           STATUS;                        /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  FLASH_TYPE_t                             TYPE;                          /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  FLASH_SF_ACCESS_t                        SF_ACCESS;                     /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  FLASH_SF_ADDRESS_t                       SF_ADDRESS;                    /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  FLASH_SF_DATA_t                          SF_DATA;                       /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  FLASH_SF_TIMING_t                        SF_TIMING;                     /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  FLASH_PF_ACCESS_t                        PF_ACCESS;                     /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  FLASH_PF_TIMING_t                        PF_TIMING;                     /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  FLASH_NF_ACCESS_t                        NF_ACCESS;                     /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  FLASH_NF_COUNT_t                         NF_COUNT;                      /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  FLASH_NF_COMMAND_t                       NF_COMMAND;                    /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  FLASH_NF_ADDRESS_1_t                     NF_ADDRESS_1;                  /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  FLASH_NF_ADDRESS_2_t                     NF_ADDRESS_2;                  /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  FLASH_NF_DATA_t                          NF_DATA;                       /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  FLASH_NF_TIMING_t                        NF_TIMING;                     /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  FLASH_NF_ECC_STATUS_t                    NF_ECC_STATUS;                 /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  FLASH_NF_ECC_CONTROL_t                   NF_ECC_CONTROL;                /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  FLASH_NF_ECC_OOB_t                       NF_ECC_OOB;                    /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  FLASH_NF_ECC_GEN0_t                      NF_ECC_GEN0;                   /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  FLASH_NF_ECC_GEN1_t                      NF_ECC_GEN1;                   /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  FLASH_NF_ECC_GEN2_t                      NF_ECC_GEN2;                   /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  FLASH_NF_ECC_GEN3_t                      NF_ECC_GEN3;                   /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  FLASH_NF_ECC_GEN4_t                      NF_ECC_GEN4;                   /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  FLASH_NF_ECC_GEN5_t                      NF_ECC_GEN5;                   /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  FLASH_NF_ECC_GEN6_t                      NF_ECC_GEN6;                   /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  FLASH_NF_ECC_GEN7_t                      NF_ECC_GEN7;                   /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  FLASH_NF_ECC_GEN8_t                      NF_ECC_GEN8;                   /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  FLASH_NF_ECC_GEN9_t                      NF_ECC_GEN9;                   /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  FLASH_NF_ECC_GEN10_t                     NF_ECC_GEN10;                  /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  FLASH_NF_ECC_GEN11_t                     NF_ECC_GEN11;                  /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  FLASH_NF_ECC_GEN12_t                     NF_ECC_GEN12;                  /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  FLASH_NF_ECC_GEN13_t                     NF_ECC_GEN13;                  /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  FLASH_NF_ECC_GEN14_t                     NF_ECC_GEN14;                  /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  FLASH_NF_ECC_GEN15_t                     NF_ECC_GEN15;                  /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  FLASH_NF_FIFO_CONTROL_t                  NF_FIFO_CONTROL;               /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  FLASH_NF_FIFO_STATUS_t                   NF_FIFO_STATUS;                /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  FLASH_NF_FIFO_ADDRESS_t                  NF_FIFO_ADDRESS;               /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  FLASH_NF_FIFO_MATCH_ADDRESS_t            NF_FIFO_MATCH_ADDRESS;         /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  FLASH_NF_FIFO_DATA_t                     NF_FIFO_DATA;                  /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  FLASH_FLASH_ACCESS_START_t               FLASH_ACCESS_START;            /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  FLASH_NF_ECC_RESET_t                     NF_ECC_RESET;                  /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  FLASH_FLASH_INTERRUPT_t                  FLASH_INTERRUPT;               /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  FLASH_FLASH_MASK_t                       FLASH_MASK;                    /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  FLASH_NF_BCH_STATUS_t                    NF_BCH_STATUS;                 /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  FLASH_NF_BCH_ERROR_LOC01_t               NF_BCH_ERROR_LOC01;            /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  FLASH_NF_BCH_ERROR_LOC23_t               NF_BCH_ERROR_LOC23;            /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  FLASH_NF_BCH_ERROR_LOC45_t               NF_BCH_ERROR_LOC45;            /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  FLASH_NF_BCH_ERROR_LOC67_t               NF_BCH_ERROR_LOC67;            /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  FLASH_NF_BCH_ERROR_LOC89_t               NF_BCH_ERROR_LOC89;            /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  FLASH_NF_BCH_ERROR_LOC1011_t             NF_BCH_ERROR_LOC1011;          /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  FLASH_NF_BCH_CONTROL_t                   NF_BCH_CONTROL;                /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  FLASH_NF_BCH_OOB0_t                      NF_BCH_OOB0;                   /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  FLASH_NF_BCH_OOB1_t                      NF_BCH_OOB1;                   /* addr: 0x000000d8 */ 
  cs_uint32                                rsrvd55[3];                   
  FLASH_NF_BCH_OOB2_t                      NF_BCH_OOB2;                   /* addr: 0x000000dc */ 
  cs_uint32                                rsrvd56[3];                   
  FLASH_NF_BCH_OOB3_t                      NF_BCH_OOB3;                   /* addr: 0x000000e0 */ 
  cs_uint32                                rsrvd57[3];                   
  FLASH_NF_BCH_OOB4_t                      NF_BCH_OOB4;                   /* addr: 0x000000e4 */ 
  cs_uint32                                rsrvd58[3];                   
  FLASH_NF_BCH_GEN0_0_t                    NF_BCH_GEN0_0;                 /* addr: 0x000000e8 */ 
  cs_uint32                                rsrvd59[3];                   
  FLASH_NF_BCH_GEN0_1_t                    NF_BCH_GEN0_1;                 /* addr: 0x000000ec */ 
  cs_uint32                                rsrvd60[3];                   
  FLASH_NF_BCH_GEN0_2_t                    NF_BCH_GEN0_2;                 /* addr: 0x000000f0 */ 
  cs_uint32                                rsrvd61[3];                   
  FLASH_NF_BCH_GEN0_3_t                    NF_BCH_GEN0_3;                 /* addr: 0x000000f4 */ 
  cs_uint32                                rsrvd62[3];                   
  FLASH_NF_BCH_GEN0_4_t                    NF_BCH_GEN0_4;                 /* addr: 0x000000f8 */ 
  cs_uint32                                rsrvd63[3];                   
  FLASH_NF_BCH_GEN1_0_t                    NF_BCH_GEN1_0;                 /* addr: 0x000000fc */ 
  cs_uint32                                rsrvd64[3];                   
  FLASH_NF_BCH_GEN1_1_t                    NF_BCH_GEN1_1;                 /* addr: 0x00000100 */ 
  cs_uint32                                rsrvd65[3];                   
  FLASH_NF_BCH_GEN1_2_t                    NF_BCH_GEN1_2;                 /* addr: 0x00000104 */ 
  cs_uint32                                rsrvd66[3];                   
  FLASH_NF_BCH_GEN1_3_t                    NF_BCH_GEN1_3;                 /* addr: 0x00000108 */ 
  cs_uint32                                rsrvd67[3];                   
  FLASH_NF_BCH_GEN1_4_t                    NF_BCH_GEN1_4;                 /* addr: 0x0000010c */ 
  cs_uint32                                rsrvd68[3];                   
  FLASH_NF_BCH_GEN2_0_t                    NF_BCH_GEN2_0;                 /* addr: 0x00000110 */ 
  cs_uint32                                rsrvd69[3];                   
  FLASH_NF_BCH_GEN2_1_t                    NF_BCH_GEN2_1;                 /* addr: 0x00000114 */ 
  cs_uint32                                rsrvd70[3];                   
  FLASH_NF_BCH_GEN2_2_t                    NF_BCH_GEN2_2;                 /* addr: 0x00000118 */ 
  cs_uint32                                rsrvd71[3];                   
  FLASH_NF_BCH_GEN2_3_t                    NF_BCH_GEN2_3;                 /* addr: 0x0000011c */ 
  cs_uint32                                rsrvd72[3];                   
  FLASH_NF_BCH_GEN2_4_t                    NF_BCH_GEN2_4;                 /* addr: 0x00000120 */ 
  cs_uint32                                rsrvd73[3];                   
  FLASH_NF_BCH_GEN3_0_t                    NF_BCH_GEN3_0;                 /* addr: 0x00000124 */ 
  cs_uint32                                rsrvd74[3];                   
  FLASH_NF_BCH_GEN3_1_t                    NF_BCH_GEN3_1;                 /* addr: 0x00000128 */ 
  cs_uint32                                rsrvd75[3];                   
  FLASH_NF_BCH_GEN3_2_t                    NF_BCH_GEN3_2;                 /* addr: 0x0000012c */ 
  cs_uint32                                rsrvd76[3];                   
  FLASH_NF_BCH_GEN3_3_t                    NF_BCH_GEN3_3;                 /* addr: 0x00000130 */ 
  cs_uint32                                rsrvd77[3];                   
  FLASH_NF_BCH_GEN3_4_t                    NF_BCH_GEN3_4;                 /* addr: 0x00000134 */ 
  cs_uint32                                rsrvd78[3];                   
  FLASH_NF_BCH_GEN4_0_t                    NF_BCH_GEN4_0;                 /* addr: 0x00000138 */ 
  cs_uint32                                rsrvd79[3];                   
  FLASH_NF_BCH_GEN4_1_t                    NF_BCH_GEN4_1;                 /* addr: 0x0000013c */ 
  cs_uint32                                rsrvd80[3];                   
  FLASH_NF_BCH_GEN4_2_t                    NF_BCH_GEN4_2;                 /* addr: 0x00000140 */ 
  cs_uint32                                rsrvd81[3];                   
  FLASH_NF_BCH_GEN4_3_t                    NF_BCH_GEN4_3;                 /* addr: 0x00000144 */ 
  cs_uint32                                rsrvd82[3];                   
  FLASH_NF_BCH_GEN4_4_t                    NF_BCH_GEN4_4;                 /* addr: 0x00000148 */ 
  cs_uint32                                rsrvd83[3];                   
  FLASH_NF_BCH_GEN5_0_t                    NF_BCH_GEN5_0;                 /* addr: 0x0000014c */ 
  cs_uint32                                rsrvd84[3];                   
  FLASH_NF_BCH_GEN5_1_t                    NF_BCH_GEN5_1;                 /* addr: 0x00000150 */ 
  cs_uint32                                rsrvd85[3];                   
  FLASH_NF_BCH_GEN5_2_t                    NF_BCH_GEN5_2;                 /* addr: 0x00000154 */ 
  cs_uint32                                rsrvd86[3];                   
  FLASH_NF_BCH_GEN5_3_t                    NF_BCH_GEN5_3;                 /* addr: 0x00000158 */ 
  cs_uint32                                rsrvd87[3];                   
  FLASH_NF_BCH_GEN5_4_t                    NF_BCH_GEN5_4;                 /* addr: 0x0000015c */ 
  cs_uint32                                rsrvd88[3];                   
  FLASH_NF_BCH_GEN6_0_t                    NF_BCH_GEN6_0;                 /* addr: 0x00000160 */ 
  cs_uint32                                rsrvd89[3];                   
  FLASH_NF_BCH_GEN6_1_t                    NF_BCH_GEN6_1;                 /* addr: 0x00000164 */ 
  cs_uint32                                rsrvd90[3];                   
  FLASH_NF_BCH_GEN6_2_t                    NF_BCH_GEN6_2;                 /* addr: 0x00000168 */ 
  cs_uint32                                rsrvd91[3];                   
  FLASH_NF_BCH_GEN6_3_t                    NF_BCH_GEN6_3;                 /* addr: 0x0000016c */ 
  cs_uint32                                rsrvd92[3];                   
  FLASH_NF_BCH_GEN6_4_t                    NF_BCH_GEN6_4;                 /* addr: 0x00000170 */ 
  cs_uint32                                rsrvd93[3];                   
  FLASH_NF_BCH_GEN7_0_t                    NF_BCH_GEN7_0;                 /* addr: 0x00000174 */ 
  cs_uint32                                rsrvd94[3];                   
  FLASH_NF_BCH_GEN7_1_t                    NF_BCH_GEN7_1;                 /* addr: 0x00000178 */ 
  cs_uint32                                rsrvd95[3];                   
  FLASH_NF_BCH_GEN7_2_t                    NF_BCH_GEN7_2;                 /* addr: 0x0000017c */ 
  cs_uint32                                rsrvd96[3];                   
  FLASH_NF_BCH_GEN7_3_t                    NF_BCH_GEN7_3;                 /* addr: 0x00000180 */ 
  cs_uint32                                rsrvd97[3];                   
  FLASH_NF_BCH_GEN7_4_t                    NF_BCH_GEN7_4;                 /* addr: 0x00000184 */ 
  cs_uint32                                rsrvd98[3];                   
  FLASH_NF_BCH_GEN8_0_t                    NF_BCH_GEN8_0;                 /* addr: 0x00000188 */ 
  cs_uint32                                rsrvd99[3];                   
  FLASH_NF_BCH_GEN8_1_t                    NF_BCH_GEN8_1;                 /* addr: 0x0000018c */ 
  cs_uint32                                rsrvd100[3];                  
  FLASH_NF_BCH_GEN8_2_t                    NF_BCH_GEN8_2;                 /* addr: 0x00000190 */ 
  cs_uint32                                rsrvd101[3];                  
  FLASH_NF_BCH_GEN8_3_t                    NF_BCH_GEN8_3;                 /* addr: 0x00000194 */ 
  cs_uint32                                rsrvd102[3];                  
  FLASH_NF_BCH_GEN8_4_t                    NF_BCH_GEN8_4;                 /* addr: 0x00000198 */ 
  cs_uint32                                rsrvd103[3];                  
  FLASH_NF_BCH_GEN9_0_t                    NF_BCH_GEN9_0;                 /* addr: 0x0000019c */ 
  cs_uint32                                rsrvd104[3];                  
  FLASH_NF_BCH_GEN9_1_t                    NF_BCH_GEN9_1;                 /* addr: 0x000001a0 */ 
  cs_uint32                                rsrvd105[3];                  
  FLASH_NF_BCH_GEN9_2_t                    NF_BCH_GEN9_2;                 /* addr: 0x000001a4 */ 
  cs_uint32                                rsrvd106[3];                  
  FLASH_NF_BCH_GEN9_3_t                    NF_BCH_GEN9_3;                 /* addr: 0x000001a8 */ 
  cs_uint32                                rsrvd107[3];                  
  FLASH_NF_BCH_GEN9_4_t                    NF_BCH_GEN9_4;                 /* addr: 0x000001ac */ 
  cs_uint32                                rsrvd108[3];                  
  FLASH_NF_BCH_GEN10_0_t                   NF_BCH_GEN10_0;                /* addr: 0x000001b0 */ 
  cs_uint32                                rsrvd109[3];                  
  FLASH_NF_BCH_GEN10_1_t                   NF_BCH_GEN10_1;                /* addr: 0x000001b4 */ 
  cs_uint32                                rsrvd110[3];                  
  FLASH_NF_BCH_GEN10_2_t                   NF_BCH_GEN10_2;                /* addr: 0x000001b8 */ 
  cs_uint32                                rsrvd111[3];                  
  FLASH_NF_BCH_GEN10_3_t                   NF_BCH_GEN10_3;                /* addr: 0x000001bc */ 
  cs_uint32                                rsrvd112[3];                  
  FLASH_NF_BCH_GEN10_4_t                   NF_BCH_GEN10_4;                /* addr: 0x000001c0 */ 
  cs_uint32                                rsrvd113[3];                  
  FLASH_NF_BCH_GEN11_0_t                   NF_BCH_GEN11_0;                /* addr: 0x000001c4 */ 
  cs_uint32                                rsrvd114[3];                  
  FLASH_NF_BCH_GEN11_1_t                   NF_BCH_GEN11_1;                /* addr: 0x000001c8 */ 
  cs_uint32                                rsrvd115[3];                  
  FLASH_NF_BCH_GEN11_2_t                   NF_BCH_GEN11_2;                /* addr: 0x000001cc */ 
  cs_uint32                                rsrvd116[3];                  
  FLASH_NF_BCH_GEN11_3_t                   NF_BCH_GEN11_3;                /* addr: 0x000001d0 */ 
  cs_uint32                                rsrvd117[3];                  
  FLASH_NF_BCH_GEN11_4_t                   NF_BCH_GEN11_4;                /* addr: 0x000001d4 */ 
  cs_uint32                                rsrvd118[3];                  
  FLASH_NF_BCH_GEN12_0_t                   NF_BCH_GEN12_0;                /* addr: 0x000001d8 */ 
  cs_uint32                                rsrvd119[3];                  
  FLASH_NF_BCH_GEN12_1_t                   NF_BCH_GEN12_1;                /* addr: 0x000001dc */ 
  cs_uint32                                rsrvd120[3];                  
  FLASH_NF_BCH_GEN12_2_t                   NF_BCH_GEN12_2;                /* addr: 0x000001e0 */ 
  cs_uint32                                rsrvd121[3];                  
  FLASH_NF_BCH_GEN12_3_t                   NF_BCH_GEN12_3;                /* addr: 0x000001e4 */ 
  cs_uint32                                rsrvd122[3];                  
  FLASH_NF_BCH_GEN12_4_t                   NF_BCH_GEN12_4;                /* addr: 0x000001e8 */ 
  cs_uint32                                rsrvd123[3];                  
  FLASH_NF_BCH_GEN13_0_t                   NF_BCH_GEN13_0;                /* addr: 0x000001ec */ 
  cs_uint32                                rsrvd124[3];                  
  FLASH_NF_BCH_GEN13_1_t                   NF_BCH_GEN13_1;                /* addr: 0x000001f0 */ 
  cs_uint32                                rsrvd125[3];                  
  FLASH_NF_BCH_GEN13_2_t                   NF_BCH_GEN13_2;                /* addr: 0x000001f4 */ 
  cs_uint32                                rsrvd126[3];                  
  FLASH_NF_BCH_GEN13_3_t                   NF_BCH_GEN13_3;                /* addr: 0x000001f8 */ 
  cs_uint32                                rsrvd127[3];                  
  FLASH_NF_BCH_GEN13_4_t                   NF_BCH_GEN13_4;                /* addr: 0x000001fc */ 
  cs_uint32                                rsrvd128[3];                  
  FLASH_NF_BCH_GEN14_0_t                   NF_BCH_GEN14_0;                /* addr: 0x00000200 */ 
  cs_uint32                                rsrvd129[3];                  
  FLASH_NF_BCH_GEN14_1_t                   NF_BCH_GEN14_1;                /* addr: 0x00000204 */ 
  cs_uint32                                rsrvd130[3];                  
  FLASH_NF_BCH_GEN14_2_t                   NF_BCH_GEN14_2;                /* addr: 0x00000208 */ 
  cs_uint32                                rsrvd131[3];                  
  FLASH_NF_BCH_GEN14_3_t                   NF_BCH_GEN14_3;                /* addr: 0x0000020c */ 
  cs_uint32                                rsrvd132[3];                  
  FLASH_NF_BCH_GEN14_4_t                   NF_BCH_GEN14_4;                /* addr: 0x00000210 */ 
  cs_uint32                                rsrvd133[3];                  
  FLASH_NF_BCH_GEN15_0_t                   NF_BCH_GEN15_0;                /* addr: 0x00000214 */ 
  cs_uint32                                rsrvd134[3];                  
  FLASH_NF_BCH_GEN15_1_t                   NF_BCH_GEN15_1;                /* addr: 0x00000218 */ 
  cs_uint32                                rsrvd135[3];                  
  FLASH_NF_BCH_GEN15_2_t                   NF_BCH_GEN15_2;                /* addr: 0x0000021c */ 
  cs_uint32                                rsrvd136[3];                  
  FLASH_NF_BCH_GEN15_3_t                   NF_BCH_GEN15_3;                /* addr: 0x00000220 */ 
  cs_uint32                                rsrvd137[3];                  
  FLASH_NF_BCH_GEN15_4_t                   NF_BCH_GEN15_4;                /* addr: 0x00000224 */ 
  cs_uint32                                rsrvd138[3];                  
  FLASH_FLASH_SPARE_0_t                    FLASH_SPARE_0;                 /* addr: 0x00000228 */ 
  cs_uint32                                rsrvd139[3];                  
  FLASH_FLASH_SPARE_1_t                    FLASH_SPARE_1;                 /* addr: 0x0000022c */ 
} FLASH_AXI_t;

  

/*
 * SCH
 */
  



#define SCH_CONTROL                              0xf0060000
#define SCH_CONTROL_dft                          0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 28 ;
    cs_uint32 ptp_enable_port2     :  1 ; /* bits 3:3 */
    cs_uint32 ptp_enable_port1     :  1 ; /* bits 2:2 */
    cs_uint32 ptp_enable_port0     :  1 ; /* bits 1:1 */
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
    cs_uint32 ptp_enable_port0     :  1 ; /* bits 1:1 */
    cs_uint32 ptp_enable_port1     :  1 ; /* bits 2:2 */
    cs_uint32 ptp_enable_port2     :  1 ; /* bits 3:3 */
    cs_uint32 rsrvd1               : 28 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTROL_t;





#define SCH_STATUS                               0xf0060004
#define SCH_STATUS_dft                           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 cpu_cmd_status       :  3 ; /* bits 4:2 */
    cs_uint32 current_set_tdm_control :  1 ; /* bits 1:1 */
    cs_uint32 sch_mem_init_done    :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 sch_mem_init_done    :  1 ; /* bits 0:0 */
    cs_uint32 current_set_tdm_control :  1 ; /* bits 1:1 */
    cs_uint32 cpu_cmd_status       :  3 ; /* bits 4:2 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_STATUS_t;





#define SCH_SWITCH_TDM_CONTROL_SET               0xf0060008
#define SCH_SWITCH_TDM_CONTROL_SET_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 switch_tdm_control_set :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 switch_tdm_control_set :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SWITCH_TDM_CONTROL_SET_t;





#define SCH_MAIN_TDM_CONTROL_SETA                0xf006000c
#define SCH_MAIN_TDM_CONTROL_SETA_dft            0x0000001f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 calendar_return_seta :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 calendar_return_seta :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_CONTROL_SETA_t;





#define SCH_MAIN_TDM_CONTROL_SETB                0xf0060010
#define SCH_MAIN_TDM_CONTROL_SETB_dft            0x0000001f




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 27 ;
    cs_uint32 calendar_return_setb :  5 ; /* bits 4:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 calendar_return_setb :  5 ; /* bits 4:0 */
    cs_uint32 rsrvd1               : 27 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_CONTROL_SETB_t;





#define SCH_MAIN_TDM_PORT_CALENDAR0_SETA         0xf0060014
#define SCH_MAIN_TDM_PORT_CALENDAR0_SETA_dft     0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 slot15               :  2 ; /* bits 31:30 */
    cs_uint32 slot14               :  2 ; /* bits 29:28 */
    cs_uint32 slot13               :  2 ; /* bits 27:26 */
    cs_uint32 slot12               :  2 ; /* bits 25:24 */
    cs_uint32 slot11               :  2 ; /* bits 23:22 */
    cs_uint32 slot10               :  2 ; /* bits 21:20 */
    cs_uint32 slot9                :  2 ; /* bits 19:18 */
    cs_uint32 slot8                :  2 ; /* bits 17:16 */
    cs_uint32 slot7                :  2 ; /* bits 15:14 */
    cs_uint32 slot6                :  2 ; /* bits 13:12 */
    cs_uint32 slot5                :  2 ; /* bits 11:10 */
    cs_uint32 slot4                :  2 ; /* bits 9:8 */
    cs_uint32 slot3                :  2 ; /* bits 7:6 */
    cs_uint32 slot2                :  2 ; /* bits 5:4 */
    cs_uint32 slot1                :  2 ; /* bits 3:2 */
    cs_uint32 slot0                :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 slot0                :  2 ; /* bits 1:0 */
    cs_uint32 slot1                :  2 ; /* bits 3:2 */
    cs_uint32 slot2                :  2 ; /* bits 5:4 */
    cs_uint32 slot3                :  2 ; /* bits 7:6 */
    cs_uint32 slot4                :  2 ; /* bits 9:8 */
    cs_uint32 slot5                :  2 ; /* bits 11:10 */
    cs_uint32 slot6                :  2 ; /* bits 13:12 */
    cs_uint32 slot7                :  2 ; /* bits 15:14 */
    cs_uint32 slot8                :  2 ; /* bits 17:16 */
    cs_uint32 slot9                :  2 ; /* bits 19:18 */
    cs_uint32 slot10               :  2 ; /* bits 21:20 */
    cs_uint32 slot11               :  2 ; /* bits 23:22 */
    cs_uint32 slot12               :  2 ; /* bits 25:24 */
    cs_uint32 slot13               :  2 ; /* bits 27:26 */
    cs_uint32 slot14               :  2 ; /* bits 29:28 */
    cs_uint32 slot15               :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_PORT_CALENDAR0_SETA_t;





#define SCH_MAIN_TDM_PORT_CALENDAR1_SETA         0xf0060018
#define SCH_MAIN_TDM_PORT_CALENDAR1_SETA_dft     0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 slot31               :  2 ; /* bits 31:30 */
    cs_uint32 slot30               :  2 ; /* bits 29:28 */
    cs_uint32 slot29               :  2 ; /* bits 27:26 */
    cs_uint32 slot28               :  2 ; /* bits 25:24 */
    cs_uint32 slot27               :  2 ; /* bits 23:22 */
    cs_uint32 slot26               :  2 ; /* bits 21:20 */
    cs_uint32 slot25               :  2 ; /* bits 19:18 */
    cs_uint32 slot24               :  2 ; /* bits 17:16 */
    cs_uint32 slot23               :  2 ; /* bits 15:14 */
    cs_uint32 slot22               :  2 ; /* bits 13:12 */
    cs_uint32 slot21               :  2 ; /* bits 11:10 */
    cs_uint32 slot20               :  2 ; /* bits 9:8 */
    cs_uint32 slot19               :  2 ; /* bits 7:6 */
    cs_uint32 slot18               :  2 ; /* bits 5:4 */
    cs_uint32 slot17               :  2 ; /* bits 3:2 */
    cs_uint32 slot16               :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 slot16               :  2 ; /* bits 1:0 */
    cs_uint32 slot17               :  2 ; /* bits 3:2 */
    cs_uint32 slot18               :  2 ; /* bits 5:4 */
    cs_uint32 slot19               :  2 ; /* bits 7:6 */
    cs_uint32 slot20               :  2 ; /* bits 9:8 */
    cs_uint32 slot21               :  2 ; /* bits 11:10 */
    cs_uint32 slot22               :  2 ; /* bits 13:12 */
    cs_uint32 slot23               :  2 ; /* bits 15:14 */
    cs_uint32 slot24               :  2 ; /* bits 17:16 */
    cs_uint32 slot25               :  2 ; /* bits 19:18 */
    cs_uint32 slot26               :  2 ; /* bits 21:20 */
    cs_uint32 slot27               :  2 ; /* bits 23:22 */
    cs_uint32 slot28               :  2 ; /* bits 25:24 */
    cs_uint32 slot29               :  2 ; /* bits 27:26 */
    cs_uint32 slot30               :  2 ; /* bits 29:28 */
    cs_uint32 slot31               :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_PORT_CALENDAR1_SETA_t;





#define SCH_MAIN_TDM_PORT_CALENDAR0_SETB         0xf006001c
#define SCH_MAIN_TDM_PORT_CALENDAR0_SETB_dft     0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 slot15               :  2 ; /* bits 31:30 */
    cs_uint32 slot14               :  2 ; /* bits 29:28 */
    cs_uint32 slot13               :  2 ; /* bits 27:26 */
    cs_uint32 slot12               :  2 ; /* bits 25:24 */
    cs_uint32 slot11               :  2 ; /* bits 23:22 */
    cs_uint32 slot10               :  2 ; /* bits 21:20 */
    cs_uint32 slot9                :  2 ; /* bits 19:18 */
    cs_uint32 slot8                :  2 ; /* bits 17:16 */
    cs_uint32 slot7                :  2 ; /* bits 15:14 */
    cs_uint32 slot6                :  2 ; /* bits 13:12 */
    cs_uint32 slot5                :  2 ; /* bits 11:10 */
    cs_uint32 slot4                :  2 ; /* bits 9:8 */
    cs_uint32 slot3                :  2 ; /* bits 7:6 */
    cs_uint32 slot2                :  2 ; /* bits 5:4 */
    cs_uint32 slot1                :  2 ; /* bits 3:2 */
    cs_uint32 slot0                :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 slot0                :  2 ; /* bits 1:0 */
    cs_uint32 slot1                :  2 ; /* bits 3:2 */
    cs_uint32 slot2                :  2 ; /* bits 5:4 */
    cs_uint32 slot3                :  2 ; /* bits 7:6 */
    cs_uint32 slot4                :  2 ; /* bits 9:8 */
    cs_uint32 slot5                :  2 ; /* bits 11:10 */
    cs_uint32 slot6                :  2 ; /* bits 13:12 */
    cs_uint32 slot7                :  2 ; /* bits 15:14 */
    cs_uint32 slot8                :  2 ; /* bits 17:16 */
    cs_uint32 slot9                :  2 ; /* bits 19:18 */
    cs_uint32 slot10               :  2 ; /* bits 21:20 */
    cs_uint32 slot11               :  2 ; /* bits 23:22 */
    cs_uint32 slot12               :  2 ; /* bits 25:24 */
    cs_uint32 slot13               :  2 ; /* bits 27:26 */
    cs_uint32 slot14               :  2 ; /* bits 29:28 */
    cs_uint32 slot15               :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_PORT_CALENDAR0_SETB_t;





#define SCH_MAIN_TDM_PORT_CALENDAR1_SETB         0xf0060020
#define SCH_MAIN_TDM_PORT_CALENDAR1_SETB_dft     0xffffffff




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 slot31               :  2 ; /* bits 31:30 */
    cs_uint32 slot30               :  2 ; /* bits 29:28 */
    cs_uint32 slot29               :  2 ; /* bits 27:26 */
    cs_uint32 slot28               :  2 ; /* bits 25:24 */
    cs_uint32 slot27               :  2 ; /* bits 23:22 */
    cs_uint32 slot26               :  2 ; /* bits 21:20 */
    cs_uint32 slot25               :  2 ; /* bits 19:18 */
    cs_uint32 slot24               :  2 ; /* bits 17:16 */
    cs_uint32 slot23               :  2 ; /* bits 15:14 */
    cs_uint32 slot22               :  2 ; /* bits 13:12 */
    cs_uint32 slot21               :  2 ; /* bits 11:10 */
    cs_uint32 slot20               :  2 ; /* bits 9:8 */
    cs_uint32 slot19               :  2 ; /* bits 7:6 */
    cs_uint32 slot18               :  2 ; /* bits 5:4 */
    cs_uint32 slot17               :  2 ; /* bits 3:2 */
    cs_uint32 slot16               :  2 ; /* bits 1:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 slot16               :  2 ; /* bits 1:0 */
    cs_uint32 slot17               :  2 ; /* bits 3:2 */
    cs_uint32 slot18               :  2 ; /* bits 5:4 */
    cs_uint32 slot19               :  2 ; /* bits 7:6 */
    cs_uint32 slot20               :  2 ; /* bits 9:8 */
    cs_uint32 slot21               :  2 ; /* bits 11:10 */
    cs_uint32 slot22               :  2 ; /* bits 13:12 */
    cs_uint32 slot23               :  2 ; /* bits 15:14 */
    cs_uint32 slot24               :  2 ; /* bits 17:16 */
    cs_uint32 slot25               :  2 ; /* bits 19:18 */
    cs_uint32 slot26               :  2 ; /* bits 21:20 */
    cs_uint32 slot27               :  2 ; /* bits 23:22 */
    cs_uint32 slot28               :  2 ; /* bits 25:24 */
    cs_uint32 slot29               :  2 ; /* bits 27:26 */
    cs_uint32 slot30               :  2 ; /* bits 29:28 */
    cs_uint32 slot31               :  2 ; /* bits 31:30 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_MAIN_TDM_PORT_CALENDAR1_SETB_t;





#define SCH_SHAPER_CONFIGURATION                 0xf0060024
#define SCH_SHAPER_CONFIGURATION_dft             0x01f40200




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  4 ;
    cs_uint32 global_scrub_enable  :  1 ; /* bits 27:27 */
    cs_uint32 clocks_per_round_lt  : 17 ; /* bits 26:10 */
    cs_uint32 clocks_per_round_st  : 10 ; /* bits 9:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 clocks_per_round_st  : 10 ; /* bits 9:0 */
    cs_uint32 clocks_per_round_lt  : 17 ; /* bits 26:10 */
    cs_uint32 global_scrub_enable  :  1 ; /* bits 27:27 */
    cs_uint32 rsrvd1               :  4 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_CONFIGURATION_t;





#define SCH_ATOMIC_COMMAND_CONTROL               0xf0060028
#define SCH_ATOMIC_COMMAND_CONTROL_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 start_write          :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 start_write          :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_ATOMIC_COMMAND_CONTROL_t;





#define SCH_ATOMIC_COMMAND_DATA1                 0xf006002c
#define SCH_ATOMIC_COMMAND_DATA1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               :  5 ;
    cs_uint32 data1                : 27 ; /* bits 26:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data1                : 27 ; /* bits 26:0 */
    cs_uint32 rsrvd1               :  5 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_ATOMIC_COMMAND_DATA1_t;





#define SCH_ATOMIC_COMMAND_DATA0                 0xf0060030
#define SCH_ATOMIC_COMMAND_DATA0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data0                : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data0                : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_ATOMIC_COMMAND_DATA0_t;





#define SCH_INTERRUPT_0                          0xf0060034
#define SCH_INTERRUPT_0_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 sch_emyvoq_reqgvn    :  1 ; /* bits 7:7 */
    cs_uint32 express_mode_off     :  1 ; /* bits 6:6 */
    cs_uint32 express_mode_on      :  1 ; /* bits 5:5 */
    cs_uint32 Shp_par_err_3_Int    :  1 ; /* bits 4:4 */
    cs_uint32 Shp_par_err_2_Int    :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_1_Int    :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_0_Int    :  1 ; /* bits 1:1 */
    cs_uint32 cpu_cmd_executed     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_cmd_executed     :  1 ; /* bits 0:0 */
    cs_uint32 Shp_par_err_0_Int    :  1 ; /* bits 1:1 */
    cs_uint32 Shp_par_err_1_Int    :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_2_Int    :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_3_Int    :  1 ; /* bits 4:4 */
    cs_uint32 express_mode_on      :  1 ; /* bits 5:5 */
    cs_uint32 express_mode_off     :  1 ; /* bits 6:6 */
    cs_uint32 sch_emyvoq_reqgvn    :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_INTERRUPT_0_t;





#define SCH_INTENABLE_0                          0xf0060038
#define SCH_INTENABLE_0_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 sch_emyvoq_reqgvn_E  :  1 ; /* bits 7:7 */
    cs_uint32 express_mode_off_E   :  1 ; /* bits 6:6 */
    cs_uint32 express_mode_on_E    :  1 ; /* bits 5:5 */
    cs_uint32 Shp_par_err_3_Int_E  :  1 ; /* bits 4:4 */
    cs_uint32 Shp_par_err_2_Int_E  :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_1_Int_E  :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_0_Int_E  :  1 ; /* bits 1:1 */
    cs_uint32 cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    cs_uint32 Shp_par_err_0_Int_E  :  1 ; /* bits 1:1 */
    cs_uint32 Shp_par_err_1_Int_E  :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_2_Int_E  :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_3_Int_E  :  1 ; /* bits 4:4 */
    cs_uint32 express_mode_on_E    :  1 ; /* bits 5:5 */
    cs_uint32 express_mode_off_E   :  1 ; /* bits 6:6 */
    cs_uint32 sch_emyvoq_reqgvn_E  :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_INTENABLE_0_t;





#define SCH_INTERRUPT_1                          0xf006003c
#define SCH_INTERRUPT_1_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 sch_emyvoq_reqgvn    :  1 ; /* bits 7:7 */
    cs_uint32 express_mode_off     :  1 ; /* bits 6:6 */
    cs_uint32 express_mode_on      :  1 ; /* bits 5:5 */
    cs_uint32 Shp_par_err_3_Int    :  1 ; /* bits 4:4 */
    cs_uint32 Shp_par_err_2_Int    :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_1_Int    :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_0_Int    :  1 ; /* bits 1:1 */
    cs_uint32 cpu_cmd_executed     :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_cmd_executed     :  1 ; /* bits 0:0 */
    cs_uint32 Shp_par_err_0_Int    :  1 ; /* bits 1:1 */
    cs_uint32 Shp_par_err_1_Int    :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_2_Int    :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_3_Int    :  1 ; /* bits 4:4 */
    cs_uint32 express_mode_on      :  1 ; /* bits 5:5 */
    cs_uint32 express_mode_off     :  1 ; /* bits 6:6 */
    cs_uint32 sch_emyvoq_reqgvn    :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_INTERRUPT_1_t;





#define SCH_INTENABLE_1                          0xf0060040
#define SCH_INTENABLE_1_dft                      0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 24 ;
    cs_uint32 sch_emyvoq_reqgvn_E  :  1 ; /* bits 7:7 */
    cs_uint32 express_mode_off_E   :  1 ; /* bits 6:6 */
    cs_uint32 express_mode_on_E    :  1 ; /* bits 5:5 */
    cs_uint32 Shp_par_err_3_Int_E  :  1 ; /* bits 4:4 */
    cs_uint32 Shp_par_err_2_Int_E  :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_1_Int_E  :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_0_Int_E  :  1 ; /* bits 1:1 */
    cs_uint32 cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    cs_uint32 Shp_par_err_0_Int_E  :  1 ; /* bits 1:1 */
    cs_uint32 Shp_par_err_1_Int_E  :  1 ; /* bits 2:2 */
    cs_uint32 Shp_par_err_2_Int_E  :  1 ; /* bits 3:3 */
    cs_uint32 Shp_par_err_3_Int_E  :  1 ; /* bits 4:4 */
    cs_uint32 express_mode_on_E    :  1 ; /* bits 5:5 */
    cs_uint32 express_mode_off_E   :  1 ; /* bits 6:6 */
    cs_uint32 sch_emyvoq_reqgvn_E  :  1 ; /* bits 7:7 */
    cs_uint32 rsrvd1               : 24 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_INTENABLE_1_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT0_0       0xf0060044
#define SCH_SHAPER_PARITY_ERR_INTERRUPT0_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq31 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq30 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq29 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq28 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq27 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq26 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq25 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq24 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq23 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq22 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq21 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq20 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq19 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq18 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq17 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq16 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq15 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq14 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq13 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq12 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq11 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq10 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq9 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq8 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq7 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq6 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq5 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq4 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq3 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq2 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq1 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq0 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq0 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq1 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq2 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq3 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq4 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq5 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq6 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq7 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq8 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq9 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq10 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq11 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq12 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq13 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq14 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq15 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq16 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq17 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq18 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq19 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq20 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq21 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq22 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq23 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq24 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq25 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq26 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq27 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq28 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq29 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq30 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq31 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT0_0_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE0_0       0xf0060048
#define SCH_SHAPER_PARITY_ERR_INTENABLE0_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq31_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq30_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq29_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq28_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq27_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq26_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq25_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq24_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq23_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq22_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq21_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq20_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq19_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq18_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq17_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq16_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq15_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq14_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq13_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq12_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq11_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq10_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq9_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq8_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq7_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq6_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq5_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq4_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq3_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq2_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq1_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq0_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq0_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq1_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq2_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq3_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq4_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq5_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq6_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq7_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq8_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq9_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq10_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq11_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq12_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq13_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq14_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq15_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq16_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq17_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq18_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq19_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq20_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq21_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq22_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq23_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq24_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq25_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq26_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq27_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq28_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq29_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq30_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq31_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE0_0_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT0_1       0xf006004c
#define SCH_SHAPER_PARITY_ERR_INTERRUPT0_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq31 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq30 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq29 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq28 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq27 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq26 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq25 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq24 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq23 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq22 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq21 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq20 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq19 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq18 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq17 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq16 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq15 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq14 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq13 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq12 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq11 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq10 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq9 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq8 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq7 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq6 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq5 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq4 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq3 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq2 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq1 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq0 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq0 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq1 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq2 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq3 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq4 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq5 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq6 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq7 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq8 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq9 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq10 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq11 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq12 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq13 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq14 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq15 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq16 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq17 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq18 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq19 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq20 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq21 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq22 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq23 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq24 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq25 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq26 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq27 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq28 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq29 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq30 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq31 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT0_1_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE0_1       0xf0060050
#define SCH_SHAPER_PARITY_ERR_INTENABLE0_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq31_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq30_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq29_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq28_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq27_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq26_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq25_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq24_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq23_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq22_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq21_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq20_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq19_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq18_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq17_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq16_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq15_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq14_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq13_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq12_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq11_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq10_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq9_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq8_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq7_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq6_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq5_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq4_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq3_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq2_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq1_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq0_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq0_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq1_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq2_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq3_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq4_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq5_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq6_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq7_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq8_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq9_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq10_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq11_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq12_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq13_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq14_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq15_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq16_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq17_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq18_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq19_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq20_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq21_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq22_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq23_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq24_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq25_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq26_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq27_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq28_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq29_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq30_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq31_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE0_1_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT1_0       0xf0060054
#define SCH_SHAPER_PARITY_ERR_INTERRUPT1_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq63 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq62 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq61 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq60 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq59 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq58 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq57 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq56 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq55 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq54 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq53 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq52 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq51 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq50 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq49 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq48 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq47 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq46 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq45 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq44 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq43 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq42 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq41 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq40 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq39 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq38 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq37 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq36 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq35 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq34 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq33 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq32 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq32 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq33 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq34 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq35 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq36 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq37 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq38 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq39 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq40 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq41 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq42 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq43 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq44 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq45 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq46 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq47 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq48 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq49 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq50 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq51 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq52 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq53 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq54 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq55 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq56 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq57 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq58 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq59 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq60 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq61 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq62 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq63 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT1_0_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE1_0       0xf0060058
#define SCH_SHAPER_PARITY_ERR_INTENABLE1_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq63_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq62_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq61_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq60_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq59_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq58_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq57_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq56_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq55_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq54_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq53_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq52_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq51_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq50_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq49_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq48_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq47_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq46_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq45_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq44_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq43_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq42_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq41_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq40_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq39_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq38_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq37_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq36_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq35_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq34_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq33_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq32_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq32_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq33_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq34_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq35_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq36_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq37_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq38_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq39_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq40_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq41_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq42_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq43_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq44_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq45_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq46_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq47_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq48_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq49_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq50_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq51_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq52_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq53_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq54_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq55_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq56_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq57_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq58_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq59_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq60_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq61_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq62_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq63_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE1_0_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT1_1       0xf006005c
#define SCH_SHAPER_PARITY_ERR_INTERRUPT1_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq63 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq62 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq61 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq60 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq59 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq58 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq57 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq56 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq55 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq54 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq53 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq52 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq51 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq50 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq49 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq48 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq47 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq46 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq45 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq44 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq43 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq42 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq41 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq40 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq39 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq38 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq37 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq36 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq35 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq34 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq33 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq32 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq32 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq33 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq34 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq35 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq36 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq37 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq38 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq39 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq40 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq41 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq42 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq43 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq44 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq45 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq46 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq47 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq48 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq49 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq50 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq51 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq52 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq53 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq54 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq55 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq56 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq57 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq58 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq59 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq60 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq61 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq62 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq63 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT1_1_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE1_1       0xf0060060
#define SCH_SHAPER_PARITY_ERR_INTENABLE1_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq63_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq62_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq61_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq60_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq59_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq58_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq57_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq56_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq55_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq54_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq53_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq52_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq51_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq50_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq49_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq48_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq47_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq46_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq45_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq44_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq43_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq42_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq41_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq40_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq39_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq38_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq37_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq36_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq35_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq34_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq33_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq32_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq32_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq33_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq34_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq35_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq36_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq37_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq38_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq39_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq40_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq41_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq42_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq43_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq44_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq45_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq46_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq47_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq48_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq49_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq50_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq51_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq52_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq53_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq54_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq55_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq56_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq57_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq58_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq59_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq60_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq61_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq62_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq63_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE1_1_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT2_0       0xf0060064
#define SCH_SHAPER_PARITY_ERR_INTERRUPT2_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq95 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq94 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq93 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq92 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq91 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq90 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq89 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq88 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq87 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq86 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq85 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq84 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq83 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq82 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq81 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq80 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq79 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq78 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq77 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq76 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq75 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq74 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq73 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq72 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq71 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq70 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq69 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq68 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq67 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq66 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq65 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq64 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq64 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq65 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq66 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq67 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq68 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq69 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq70 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq71 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq72 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq73 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq74 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq75 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq76 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq77 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq78 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq79 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq80 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq81 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq82 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq83 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq84 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq85 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq86 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq87 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq88 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq89 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq90 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq91 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq92 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq93 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq94 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq95 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT2_0_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE2_0       0xf0060068
#define SCH_SHAPER_PARITY_ERR_INTENABLE2_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq95_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq94_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq93_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq92_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq91_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq90_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq89_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq88_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq87_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq86_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq85_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq84_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq83_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq82_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq81_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq80_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq79_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq78_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq77_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq76_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq75_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq74_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq73_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq72_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq71_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq70_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq69_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq68_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq67_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq66_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq65_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq64_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq64_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq65_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq66_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq67_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq68_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq69_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq70_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq71_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq72_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq73_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq74_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq75_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq76_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq77_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq78_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq79_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq80_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq81_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq82_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq83_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq84_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq85_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq86_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq87_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq88_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq89_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq90_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq91_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq92_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq93_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq94_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq95_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE2_0_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT2_1       0xf006006c
#define SCH_SHAPER_PARITY_ERR_INTERRUPT2_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq95 :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq94 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq93 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq92 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq91 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq90 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq89 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq88 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq87 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq86 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq85 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq84 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq83 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq82 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq81 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq80 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq79 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq78 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq77 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq76 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq75 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq74 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq73 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq72 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq71 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq70 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq69 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq68 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq67 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq66 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq65 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq64 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq64 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq65 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq66 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq67 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq68 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq69 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq70 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq71 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq72 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq73 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq74 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq75 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq76 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq77 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq78 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq79 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq80 :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq81 :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq82 :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq83 :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq84 :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq85 :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq86 :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq87 :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq88 :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq89 :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq90 :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq91 :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq92 :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq93 :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq94 :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq95 :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT2_1_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE2_1       0xf0060070
#define SCH_SHAPER_PARITY_ERR_INTENABLE2_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 shp_cnfg_parerr_voq95_E :  1 ; /* bits 31:31 */
    cs_uint32 shp_cnfg_parerr_voq94_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq93_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq92_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq91_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq90_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq89_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq88_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq87_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq86_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq85_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq84_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq83_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq82_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq81_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq80_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq79_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq78_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq77_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq76_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq75_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq74_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq73_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq72_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq71_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq70_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq69_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq68_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq67_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq66_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq65_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq64_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq64_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq65_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq66_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq67_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq68_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq69_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq70_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq71_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq72_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq73_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq74_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq75_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq76_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq77_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq78_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq79_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq80_E :  1 ; /* bits 16:16 */
    cs_uint32 shp_cnfg_parerr_voq81_E :  1 ; /* bits 17:17 */
    cs_uint32 shp_cnfg_parerr_voq82_E :  1 ; /* bits 18:18 */
    cs_uint32 shp_cnfg_parerr_voq83_E :  1 ; /* bits 19:19 */
    cs_uint32 shp_cnfg_parerr_voq84_E :  1 ; /* bits 20:20 */
    cs_uint32 shp_cnfg_parerr_voq85_E :  1 ; /* bits 21:21 */
    cs_uint32 shp_cnfg_parerr_voq86_E :  1 ; /* bits 22:22 */
    cs_uint32 shp_cnfg_parerr_voq87_E :  1 ; /* bits 23:23 */
    cs_uint32 shp_cnfg_parerr_voq88_E :  1 ; /* bits 24:24 */
    cs_uint32 shp_cnfg_parerr_voq89_E :  1 ; /* bits 25:25 */
    cs_uint32 shp_cnfg_parerr_voq90_E :  1 ; /* bits 26:26 */
    cs_uint32 shp_cnfg_parerr_voq91_E :  1 ; /* bits 27:27 */
    cs_uint32 shp_cnfg_parerr_voq92_E :  1 ; /* bits 28:28 */
    cs_uint32 shp_cnfg_parerr_voq93_E :  1 ; /* bits 29:29 */
    cs_uint32 shp_cnfg_parerr_voq94_E :  1 ; /* bits 30:30 */
    cs_uint32 shp_cnfg_parerr_voq95_E :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE2_1_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT3_0       0xf0060074
#define SCH_SHAPER_PARITY_ERR_INTERRUPT3_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 shp_cnfg_parerr_voq111 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq110 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq109 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq108 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq107 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq106 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq105 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq104 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq103 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq102 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq101 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq100 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq99 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq98 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq97 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq96 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq96 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq97 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq98 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq99 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq100 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq101 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq102 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq103 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq104 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq105 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq106 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq107 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq108 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq109 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq110 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq111 :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT3_0_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE3_0       0xf0060078
#define SCH_SHAPER_PARITY_ERR_INTENABLE3_0_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 shp_cnfg_parerr_voq111_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq110_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq109_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq108_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq107_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq106_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq105_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq104_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq103_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq102_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq101_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq100_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq99_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq98_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq97_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq96_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq96_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq97_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq98_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq99_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq100_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq101_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq102_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq103_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq104_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq105_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq106_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq107_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq108_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq109_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq110_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq111_E :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE3_0_t;





#define SCH_SHAPER_PARITY_ERR_INTERRUPT3_1       0xf006007c
#define SCH_SHAPER_PARITY_ERR_INTERRUPT3_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 shp_cnfg_parerr_voq111 :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq110 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq109 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq108 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq107 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq106 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq105 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq104 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq103 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq102 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq101 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq100 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq99 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq98 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq97 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq96 :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq96 :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq97 :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq98 :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq99 :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq100 :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq101 :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq102 :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq103 :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq104 :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq105 :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq106 :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq107 :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq108 :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq109 :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq110 :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq111 :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTERRUPT3_1_t;





#define SCH_SHAPER_PARITY_ERR_INTENABLE3_1       0xf0060080
#define SCH_SHAPER_PARITY_ERR_INTENABLE3_1_dft   0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 16 ;
    cs_uint32 shp_cnfg_parerr_voq111_E :  1 ; /* bits 15:15 */
    cs_uint32 shp_cnfg_parerr_voq110_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq109_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq108_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq107_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq106_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq105_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq104_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq103_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq102_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq101_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq100_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq99_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq98_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq97_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq96_E :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shp_cnfg_parerr_voq96_E :  1 ; /* bits 0:0 */
    cs_uint32 shp_cnfg_parerr_voq97_E :  1 ; /* bits 1:1 */
    cs_uint32 shp_cnfg_parerr_voq98_E :  1 ; /* bits 2:2 */
    cs_uint32 shp_cnfg_parerr_voq99_E :  1 ; /* bits 3:3 */
    cs_uint32 shp_cnfg_parerr_voq100_E :  1 ; /* bits 4:4 */
    cs_uint32 shp_cnfg_parerr_voq101_E :  1 ; /* bits 5:5 */
    cs_uint32 shp_cnfg_parerr_voq102_E :  1 ; /* bits 6:6 */
    cs_uint32 shp_cnfg_parerr_voq103_E :  1 ; /* bits 7:7 */
    cs_uint32 shp_cnfg_parerr_voq104_E :  1 ; /* bits 8:8 */
    cs_uint32 shp_cnfg_parerr_voq105_E :  1 ; /* bits 9:9 */
    cs_uint32 shp_cnfg_parerr_voq106_E :  1 ; /* bits 10:10 */
    cs_uint32 shp_cnfg_parerr_voq107_E :  1 ; /* bits 11:11 */
    cs_uint32 shp_cnfg_parerr_voq108_E :  1 ; /* bits 12:12 */
    cs_uint32 shp_cnfg_parerr_voq109_E :  1 ; /* bits 13:13 */
    cs_uint32 shp_cnfg_parerr_voq110_E :  1 ; /* bits 14:14 */
    cs_uint32 shp_cnfg_parerr_voq111_E :  1 ; /* bits 15:15 */
    cs_uint32 rsrvd1               : 16 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_PARITY_ERR_INTENABLE3_1_t;





#define SCH_DEBUG_CONTROL                        0xf0060084
#define SCH_DEBUG_CONTROL_dft                    0x00328000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd2               :  7 ;
    cs_uint32 switch_expr_mode_lowlvl :  5 ; /* bits 24:20 */
    cs_uint32 switch_expr_mode_uplvl :  5 ; /* bits 19:15 */
    cs_uint32 debug_counter_voqid  :  7 ; /* bits 14:8 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 stop_scrub           :  1 ; /* bits 4:4 */
    cs_uint32 stop_processing_enq_shp_cpu_update :  1 ; /* bits 3:3 */
    cs_uint32 stop_processing_enq_qm_update :  1 ; /* bits 2:2 */
    cs_uint32 stop_processing_deq_update :  1 ; /* bits 1:1 */
    cs_uint32 ignore_qm_sch_ready  :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 ignore_qm_sch_ready  :  1 ; /* bits 0:0 */
    cs_uint32 stop_processing_deq_update :  1 ; /* bits 1:1 */
    cs_uint32 stop_processing_enq_qm_update :  1 ; /* bits 2:2 */
    cs_uint32 stop_processing_enq_shp_cpu_update :  1 ; /* bits 3:3 */
    cs_uint32 stop_scrub           :  1 ; /* bits 4:4 */
    cs_uint32 rsrvd1               :  3 ;
    cs_uint32 debug_counter_voqid  :  7 ; /* bits 14:8 */
    cs_uint32 switch_expr_mode_uplvl :  5 ; /* bits 19:15 */
    cs_uint32 switch_expr_mode_lowlvl :  5 ; /* bits 24:20 */
    cs_uint32 rsrvd2               :  7 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_DEBUG_CONTROL_t;





#define SCH_DEBUG_FORCE_CONTROL                  0xf0060088
#define SCH_DEBUG_FORCE_CONTROL_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 force_sch_qm_ready   :  1 ; /* bits 17:17 */
    cs_uint32 force_port2_destination_empty :  1 ; /* bits 16:16 */
    cs_uint32 force_port1_destination_empty :  1 ; /* bits 15:15 */
    cs_uint32 force_port0_destination_empty :  1 ; /* bits 14:14 */
    cs_uint32 force_port13_destination_ready :  1 ; /* bits 13:13 */
    cs_uint32 force_port12_destination_ready :  1 ; /* bits 12:12 */
    cs_uint32 force_port11_destination_ready :  1 ; /* bits 11:11 */
    cs_uint32 force_port10_destination_ready :  1 ; /* bits 10:10 */
    cs_uint32 force_port9_destination_ready :  1 ; /* bits 9:9 */
    cs_uint32 force_port8_destination_ready :  1 ; /* bits 8:8 */
    cs_uint32 force_port7_destination_ready :  1 ; /* bits 7:7 */
    cs_uint32 force_port6_destination_ready :  1 ; /* bits 6:6 */
    cs_uint32 force_port5_destination_ready :  1 ; /* bits 5:5 */
    cs_uint32 force_port4_destination_ready :  1 ; /* bits 4:4 */
    cs_uint32 force_port3_destination_ready :  1 ; /* bits 3:3 */
    cs_uint32 force_port2_destination_ready :  1 ; /* bits 2:2 */
    cs_uint32 force_port1_destination_ready :  1 ; /* bits 1:1 */
    cs_uint32 force_port0_destination_ready :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 force_port0_destination_ready :  1 ; /* bits 0:0 */
    cs_uint32 force_port1_destination_ready :  1 ; /* bits 1:1 */
    cs_uint32 force_port2_destination_ready :  1 ; /* bits 2:2 */
    cs_uint32 force_port3_destination_ready :  1 ; /* bits 3:3 */
    cs_uint32 force_port4_destination_ready :  1 ; /* bits 4:4 */
    cs_uint32 force_port5_destination_ready :  1 ; /* bits 5:5 */
    cs_uint32 force_port6_destination_ready :  1 ; /* bits 6:6 */
    cs_uint32 force_port7_destination_ready :  1 ; /* bits 7:7 */
    cs_uint32 force_port8_destination_ready :  1 ; /* bits 8:8 */
    cs_uint32 force_port9_destination_ready :  1 ; /* bits 9:9 */
    cs_uint32 force_port10_destination_ready :  1 ; /* bits 10:10 */
    cs_uint32 force_port11_destination_ready :  1 ; /* bits 11:11 */
    cs_uint32 force_port12_destination_ready :  1 ; /* bits 12:12 */
    cs_uint32 force_port13_destination_ready :  1 ; /* bits 13:13 */
    cs_uint32 force_port0_destination_empty :  1 ; /* bits 14:14 */
    cs_uint32 force_port1_destination_empty :  1 ; /* bits 15:15 */
    cs_uint32 force_port2_destination_empty :  1 ; /* bits 16:16 */
    cs_uint32 force_sch_qm_ready   :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_DEBUG_FORCE_CONTROL_t;





#define SCH_DEBUG_FORCE_VALUE                    0xf006008c
#define SCH_DEBUG_FORCE_VALUE_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 14 ;
    cs_uint32 value_sch_qm_ready   :  1 ; /* bits 17:17 */
    cs_uint32 value_port2_destination_empty :  1 ; /* bits 16:16 */
    cs_uint32 value_port1_destination_empty :  1 ; /* bits 15:15 */
    cs_uint32 value_port0_destination_empty :  1 ; /* bits 14:14 */
    cs_uint32 value_port13_destination_ready :  1 ; /* bits 13:13 */
    cs_uint32 value_port12_destination_ready :  1 ; /* bits 12:12 */
    cs_uint32 value_port11_destination_ready :  1 ; /* bits 11:11 */
    cs_uint32 value_port10_destination_ready :  1 ; /* bits 10:10 */
    cs_uint32 value_port9_destination_ready :  1 ; /* bits 9:9 */
    cs_uint32 value_port8_destination_ready :  1 ; /* bits 8:8 */
    cs_uint32 value_port7_destination_ready :  1 ; /* bits 7:7 */
    cs_uint32 value_port6_destination_ready :  1 ; /* bits 6:6 */
    cs_uint32 value_port5_destination_ready :  1 ; /* bits 5:5 */
    cs_uint32 value_port4_destination_ready :  1 ; /* bits 4:4 */
    cs_uint32 value_port3_destination_ready :  1 ; /* bits 3:3 */
    cs_uint32 value_port2_destination_ready :  1 ; /* bits 2:2 */
    cs_uint32 value_port1_destination_ready :  1 ; /* bits 1:1 */
    cs_uint32 value_port0_destination_ready :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 value_port0_destination_ready :  1 ; /* bits 0:0 */
    cs_uint32 value_port1_destination_ready :  1 ; /* bits 1:1 */
    cs_uint32 value_port2_destination_ready :  1 ; /* bits 2:2 */
    cs_uint32 value_port3_destination_ready :  1 ; /* bits 3:3 */
    cs_uint32 value_port4_destination_ready :  1 ; /* bits 4:4 */
    cs_uint32 value_port5_destination_ready :  1 ; /* bits 5:5 */
    cs_uint32 value_port6_destination_ready :  1 ; /* bits 6:6 */
    cs_uint32 value_port7_destination_ready :  1 ; /* bits 7:7 */
    cs_uint32 value_port8_destination_ready :  1 ; /* bits 8:8 */
    cs_uint32 value_port9_destination_ready :  1 ; /* bits 9:9 */
    cs_uint32 value_port10_destination_ready :  1 ; /* bits 10:10 */
    cs_uint32 value_port11_destination_ready :  1 ; /* bits 11:11 */
    cs_uint32 value_port12_destination_ready :  1 ; /* bits 12:12 */
    cs_uint32 value_port13_destination_ready :  1 ; /* bits 13:13 */
    cs_uint32 value_port0_destination_empty :  1 ; /* bits 14:14 */
    cs_uint32 value_port1_destination_empty :  1 ; /* bits 15:15 */
    cs_uint32 value_port2_destination_empty :  1 ; /* bits 16:16 */
    cs_uint32 value_sch_qm_ready   :  1 ; /* bits 17:17 */
    cs_uint32 rsrvd1               : 14 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_DEBUG_FORCE_VALUE_t;





#define SCH_CONTEXT_MEMORY_ACCESS                0xf0060090
#define SCH_CONTEXT_MEMORY_ACCESS_dft            0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 address              :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 address              :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_ACCESS_t;





#define SCH_CONTEXT_MEMORY_DATA5                 0xf0060094
#define SCH_CONTEXT_MEMORY_DATA5_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 18 ;
    cs_uint32 data                 : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 14 ; /* bits 13:0 */
    cs_uint32 rsrvd1               : 18 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA5_t;





#define SCH_CONTEXT_MEMORY_DATA4                 0xf0060098
#define SCH_CONTEXT_MEMORY_DATA4_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA4_t;





#define SCH_CONTEXT_MEMORY_DATA3                 0xf006009c
#define SCH_CONTEXT_MEMORY_DATA3_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA3_t;





#define SCH_CONTEXT_MEMORY_DATA2                 0xf00600a0
#define SCH_CONTEXT_MEMORY_DATA2_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA2_t;





#define SCH_CONTEXT_MEMORY_DATA1                 0xf00600a4
#define SCH_CONTEXT_MEMORY_DATA1_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA1_t;





#define SCH_CONTEXT_MEMORY_DATA0                 0xf00600a8
#define SCH_CONTEXT_MEMORY_DATA0_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 data                 : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_CONTEXT_MEMORY_DATA0_t;





#define SCH_OUTPUT_LATCH_ACCESS                  0xf00600ac
#define SCH_OUTPUT_LATCH_ACCESS_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 port_num             :  4 ; /* bits 3:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 port_num             :  4 ; /* bits 3:0 */
    cs_uint32 rsrvd1               : 26 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_OUTPUT_LATCH_ACCESS_t;





#define SCH_OUTPUT_LATCH_DATA                    0xf00600b0
#define SCH_OUTPUT_LATCH_DATA_dft                0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 12 ;
    cs_uint32 winner_valid         :  1 ; /* bits 19:19 */
    cs_uint32 sch_lock             :  1 ; /* bits 18:18 */
    cs_uint32 read_update_pending  :  1 ; /* bits 17:17 */
    cs_uint32 winner_ptp_enable    :  1 ; /* bits 16:16 */
    cs_uint32 winner_spdrr         :  1 ; /* bits 15:15 */
    cs_uint32 winner_voqid         :  7 ; /* bits 14:8 */
    cs_uint32 winner_bsize         :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 winner_bsize         :  8 ; /* bits 7:0 */
    cs_uint32 winner_voqid         :  7 ; /* bits 14:8 */
    cs_uint32 winner_spdrr         :  1 ; /* bits 15:15 */
    cs_uint32 winner_ptp_enable    :  1 ; /* bits 16:16 */
    cs_uint32 read_update_pending  :  1 ; /* bits 17:17 */
    cs_uint32 sch_lock             :  1 ; /* bits 18:18 */
    cs_uint32 winner_valid         :  1 ; /* bits 19:19 */
    cs_uint32 rsrvd1               : 12 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_OUTPUT_LATCH_DATA_t;





#define SCH_SHAPER_MEMORY_ACCESS                 0xf00600b4
#define SCH_SHAPER_MEMORY_ACCESS_dft             0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 shaper_num           :  8 ; /* bits 7:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 shaper_num           :  8 ; /* bits 7:0 */
    cs_uint32 rsrvd1               : 22 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_MEMORY_ACCESS_t;





#define SCH_SHAPER_MEMORY_DATA2                  0xf00600b8
#define SCH_SHAPER_MEMORY_DATA2_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 25 ;
    cs_uint32 var_parity           :  1 ; /* bits 6:6 */
    cs_uint32 var_tbc              :  6 ; /* bits 5:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 var_tbc              :  6 ; /* bits 5:0 */
    cs_uint32 var_parity           :  1 ; /* bits 6:6 */
    cs_uint32 rsrvd1               : 25 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_MEMORY_DATA2_t;





#define SCH_SHAPER_MEMORY_DATA1                  0xf00600bc
#define SCH_SHAPER_MEMORY_DATA1_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 var_tbc              : 13 ; /* bits 31:19 */
    cs_uint32 var_rpt              :  5 ; /* bits 18:14 */
    cs_uint32 config_tbc           : 14 ; /* bits 13:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 config_tbc           : 14 ; /* bits 13:0 */
    cs_uint32 var_rpt              :  5 ; /* bits 18:14 */
    cs_uint32 var_tbc              : 13 ; /* bits 31:19 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_MEMORY_DATA1_t;





#define SCH_SHAPER_MEMORY_DATA0                  0xf00600c0
#define SCH_SHAPER_MEMORY_DATA0_dft              0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 config_tbc           :  4 ; /* bits 31:28 */
    cs_uint32 config_tsize         : 18 ; /* bits 27:10 */
    cs_uint32 config_rpt           :  5 ; /* bits 9:5 */
    cs_uint32 config_cpu_port      :  3 ; /* bits 4:2 */
    cs_uint32 config_mode          :  1 ; /* bits 1:1 */
    cs_uint32 config_enb           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 config_enb           :  1 ; /* bits 0:0 */
    cs_uint32 config_mode          :  1 ; /* bits 1:1 */
    cs_uint32 config_cpu_port      :  3 ; /* bits 4:2 */
    cs_uint32 config_rpt           :  5 ; /* bits 9:5 */
    cs_uint32 config_tsize         : 18 ; /* bits 27:10 */
    cs_uint32 config_tbc           :  4 ; /* bits 31:28 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_SHAPER_MEMORY_DATA0_t;





#define SCH_VOQ_NON_EMPTY_STATUS_MEMORY_ACCESS   0xf00600c4
#define SCH_VOQ_NON_EMPTY_STATUS_MEMORY_ACCESS_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 access               :  1 ; /* bits 31:31 */
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 voq_num              :  7 ; /* bits 6:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 voq_num              :  7 ; /* bits 6:0 */
    cs_uint32 rsrvd1               : 23 ;
    cs_uint32 rbw                  :  1 ; /* bits 30:30 */
    cs_uint32 access               :  1 ; /* bits 31:31 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_VOQ_NON_EMPTY_STATUS_MEMORY_ACCESS_t;





#define SCH_VOQ_NON_EMPTY_STATUS_MEMORY_DATA     0xf00600c8
#define SCH_VOQ_NON_EMPTY_STATUS_MEMORY_DATA_dft 0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 non_empty_value      :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 non_empty_value      :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_VOQ_NON_EMPTY_STATUS_MEMORY_DATA_t;





#define SCH_NUM_SCHREQ                           0xf00600cc
#define SCH_NUM_SCHREQ_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 num_schreq           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 num_schreq           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_NUM_SCHREQ_t;





#define SCH_NUM_ENQUPD                           0xf00600d0
#define SCH_NUM_ENQUPD_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 num_enqupd           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 num_enqupd           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_NUM_ENQUPD_t;





#define SCH_NUM_DEQUPD                           0xf00600d4
#define SCH_NUM_DEQUPD_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 num_dequpd           : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 num_dequpd           : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_NUM_DEQUPD_t;





#define SCH_NUM_DEQUPD_ZERO                      0xf00600d8
#define SCH_NUM_DEQUPD_ZERO_dft                  0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 num_dequpd_zero      : 32 ; /* bits 31:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 num_dequpd_zero      : 32 ; /* bits 31:0 */
#   endif
  } bf ;
  cs_uint32     wrd ;
} SCH_NUM_DEQUPD_ZERO_t;



    
  
  
  
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* SCH */

typedef struct {
  SCH_CONTROL_t                            CONTROL;                       /* addr: 0x00000000 */ 
  cs_uint32                                rsrvd1[3];                    
  SCH_STATUS_t                             STATUS;                        /* addr: 0x00000004 */ 
  cs_uint32                                rsrvd2[3];                    
  SCH_SWITCH_TDM_CONTROL_SET_t             SWITCH_TDM_CONTROL_SET;        /* addr: 0x00000008 */ 
  cs_uint32                                rsrvd3[3];                    
  SCH_MAIN_TDM_CONTROL_SETA_t              MAIN_TDM_CONTROL_SETA;         /* addr: 0x0000000c */ 
  cs_uint32                                rsrvd4[3];                    
  SCH_MAIN_TDM_CONTROL_SETB_t              MAIN_TDM_CONTROL_SETB;         /* addr: 0x00000010 */ 
  cs_uint32                                rsrvd5[3];                    
  SCH_MAIN_TDM_PORT_CALENDAR0_SETA_t       MAIN_TDM_PORT_CALENDAR0_SETA;  /* addr: 0x00000014 */ 
  cs_uint32                                rsrvd6[3];                    
  SCH_MAIN_TDM_PORT_CALENDAR1_SETA_t       MAIN_TDM_PORT_CALENDAR1_SETA;  /* addr: 0x00000018 */ 
  cs_uint32                                rsrvd7[3];                    
  SCH_MAIN_TDM_PORT_CALENDAR0_SETB_t       MAIN_TDM_PORT_CALENDAR0_SETB;  /* addr: 0x0000001c */ 
  cs_uint32                                rsrvd8[3];                    
  SCH_MAIN_TDM_PORT_CALENDAR1_SETB_t       MAIN_TDM_PORT_CALENDAR1_SETB;  /* addr: 0x00000020 */ 
  cs_uint32                                rsrvd9[3];                    
  SCH_SHAPER_CONFIGURATION_t               SHAPER_CONFIGURATION;          /* addr: 0x00000024 */ 
  cs_uint32                                rsrvd10[3];                   
  SCH_ATOMIC_COMMAND_CONTROL_t             ATOMIC_COMMAND_CONTROL;        /* addr: 0x00000028 */ 
  cs_uint32                                rsrvd11[3];                   
  SCH_ATOMIC_COMMAND_DATA1_t               ATOMIC_COMMAND_DATA1;          /* addr: 0x0000002c */ 
  cs_uint32                                rsrvd12[3];                   
  SCH_ATOMIC_COMMAND_DATA0_t               ATOMIC_COMMAND_DATA0;          /* addr: 0x00000030 */ 
  cs_uint32                                rsrvd13[3];                   
  SCH_INTERRUPT_0_t                        INTERRUPT_0;                   /* addr: 0x00000034 */ 
  cs_uint32                                rsrvd14[3];                   
  SCH_INTENABLE_0_t                        INTENABLE_0;                   /* addr: 0x00000038 */ 
  cs_uint32                                rsrvd15[3];                   
  SCH_INTERRUPT_1_t                        INTERRUPT_1;                   /* addr: 0x0000003c */ 
  cs_uint32                                rsrvd16[3];                   
  SCH_INTENABLE_1_t                        INTENABLE_1;                   /* addr: 0x00000040 */ 
  cs_uint32                                rsrvd17[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT0_0_t     SHAPER_PARITY_ERR_INTERRUPT0_0; /* addr: 0x00000044 */ 
  cs_uint32                                rsrvd18[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE0_0_t     SHAPER_PARITY_ERR_INTENABLE0_0; /* addr: 0x00000048 */ 
  cs_uint32                                rsrvd19[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT0_1_t     SHAPER_PARITY_ERR_INTERRUPT0_1; /* addr: 0x0000004c */ 
  cs_uint32                                rsrvd20[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE0_1_t     SHAPER_PARITY_ERR_INTENABLE0_1; /* addr: 0x00000050 */ 
  cs_uint32                                rsrvd21[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT1_0_t     SHAPER_PARITY_ERR_INTERRUPT1_0; /* addr: 0x00000054 */ 
  cs_uint32                                rsrvd22[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE1_0_t     SHAPER_PARITY_ERR_INTENABLE1_0; /* addr: 0x00000058 */ 
  cs_uint32                                rsrvd23[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT1_1_t     SHAPER_PARITY_ERR_INTERRUPT1_1; /* addr: 0x0000005c */ 
  cs_uint32                                rsrvd24[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE1_1_t     SHAPER_PARITY_ERR_INTENABLE1_1; /* addr: 0x00000060 */ 
  cs_uint32                                rsrvd25[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT2_0_t     SHAPER_PARITY_ERR_INTERRUPT2_0; /* addr: 0x00000064 */ 
  cs_uint32                                rsrvd26[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE2_0_t     SHAPER_PARITY_ERR_INTENABLE2_0; /* addr: 0x00000068 */ 
  cs_uint32                                rsrvd27[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT2_1_t     SHAPER_PARITY_ERR_INTERRUPT2_1; /* addr: 0x0000006c */ 
  cs_uint32                                rsrvd28[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE2_1_t     SHAPER_PARITY_ERR_INTENABLE2_1; /* addr: 0x00000070 */ 
  cs_uint32                                rsrvd29[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT3_0_t     SHAPER_PARITY_ERR_INTERRUPT3_0; /* addr: 0x00000074 */ 
  cs_uint32                                rsrvd30[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE3_0_t     SHAPER_PARITY_ERR_INTENABLE3_0; /* addr: 0x00000078 */ 
  cs_uint32                                rsrvd31[3];                   
  SCH_SHAPER_PARITY_ERR_INTERRUPT3_1_t     SHAPER_PARITY_ERR_INTERRUPT3_1; /* addr: 0x0000007c */ 
  cs_uint32                                rsrvd32[3];                   
  SCH_SHAPER_PARITY_ERR_INTENABLE3_1_t     SHAPER_PARITY_ERR_INTENABLE3_1; /* addr: 0x00000080 */ 
  cs_uint32                                rsrvd33[3];                   
  SCH_DEBUG_CONTROL_t                      DEBUG_CONTROL;                 /* addr: 0x00000084 */ 
  cs_uint32                                rsrvd34[3];                   
  SCH_DEBUG_FORCE_CONTROL_t                DEBUG_FORCE_CONTROL;           /* addr: 0x00000088 */ 
  cs_uint32                                rsrvd35[3];                   
  SCH_DEBUG_FORCE_VALUE_t                  DEBUG_FORCE_VALUE;             /* addr: 0x0000008c */ 
  cs_uint32                                rsrvd36[3];                   
  SCH_CONTEXT_MEMORY_ACCESS_t              CONTEXT_MEMORY_ACCESS;         /* addr: 0x00000090 */ 
  cs_uint32                                rsrvd37[3];                   
  SCH_CONTEXT_MEMORY_DATA5_t               CONTEXT_MEMORY_DATA5;          /* addr: 0x00000094 */ 
  cs_uint32                                rsrvd38[3];                   
  SCH_CONTEXT_MEMORY_DATA4_t               CONTEXT_MEMORY_DATA4;          /* addr: 0x00000098 */ 
  cs_uint32                                rsrvd39[3];                   
  SCH_CONTEXT_MEMORY_DATA3_t               CONTEXT_MEMORY_DATA3;          /* addr: 0x0000009c */ 
  cs_uint32                                rsrvd40[3];                   
  SCH_CONTEXT_MEMORY_DATA2_t               CONTEXT_MEMORY_DATA2;          /* addr: 0x000000a0 */ 
  cs_uint32                                rsrvd41[3];                   
  SCH_CONTEXT_MEMORY_DATA1_t               CONTEXT_MEMORY_DATA1;          /* addr: 0x000000a4 */ 
  cs_uint32                                rsrvd42[3];                   
  SCH_CONTEXT_MEMORY_DATA0_t               CONTEXT_MEMORY_DATA0;          /* addr: 0x000000a8 */ 
  cs_uint32                                rsrvd43[3];                   
  SCH_OUTPUT_LATCH_ACCESS_t                OUTPUT_LATCH_ACCESS;           /* addr: 0x000000ac */ 
  cs_uint32                                rsrvd44[3];                   
  SCH_OUTPUT_LATCH_DATA_t                  OUTPUT_LATCH_DATA;             /* addr: 0x000000b0 */ 
  cs_uint32                                rsrvd45[3];                   
  SCH_SHAPER_MEMORY_ACCESS_t               SHAPER_MEMORY_ACCESS;          /* addr: 0x000000b4 */ 
  cs_uint32                                rsrvd46[3];                   
  SCH_SHAPER_MEMORY_DATA2_t                SHAPER_MEMORY_DATA2;           /* addr: 0x000000b8 */ 
  cs_uint32                                rsrvd47[3];                   
  SCH_SHAPER_MEMORY_DATA1_t                SHAPER_MEMORY_DATA1;           /* addr: 0x000000bc */ 
  cs_uint32                                rsrvd48[3];                   
  SCH_SHAPER_MEMORY_DATA0_t                SHAPER_MEMORY_DATA0;           /* addr: 0x000000c0 */ 
  cs_uint32                                rsrvd49[3];                   
  SCH_VOQ_NON_EMPTY_STATUS_MEMORY_ACCESS_t VOQ_NON_EMPTY_STATUS_MEMORY_ACCESS; /* addr: 0x000000c4 */ 
  cs_uint32                                rsrvd50[3];                   
  SCH_VOQ_NON_EMPTY_STATUS_MEMORY_DATA_t   VOQ_NON_EMPTY_STATUS_MEMORY_DATA; /* addr: 0x000000c8 */ 
  cs_uint32                                rsrvd51[3];                   
  SCH_NUM_SCHREQ_t                         NUM_SCHREQ;                    /* addr: 0x000000cc */ 
  cs_uint32                                rsrvd52[3];                   
  SCH_NUM_ENQUPD_t                         NUM_ENQUPD;                    /* addr: 0x000000d0 */ 
  cs_uint32                                rsrvd53[3];                   
  SCH_NUM_DEQUPD_t                         NUM_DEQUPD;                    /* addr: 0x000000d4 */ 
  cs_uint32                                rsrvd54[3];                   
  SCH_NUM_DEQUPD_ZERO_t                    NUM_DEQUPD_ZERO;               /* addr: 0x000000d8 */ 
} SCH_t;

  

/*
 * PER
 */
  



#define PER_SOFT_RESET                           0xf0070000
#define PER_SOFT_RESET_dft                       0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 31 ;
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 soft_reset           :  1 ; /* bits 0:0 */
    cs_uint32 rsrvd1               : 31 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} PER_SOFT_RESET_t;





#define PER_PERIPHERAL_INTERRUPT_0               0xf0070004
#define PER_PERIPHERAL_INTERRUPT_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 trngi                :  1 ; /* bits 14:14 */
    cs_uint32 sspi                 :  1 ; /* bits 13:13 */
    cs_uint32 mdioi                :  1 ; /* bits 12:12 */
    cs_uint32 biwi                 :  1 ; /* bits 11:11 */
    cs_uint32 gpio4i               :  1 ; /* bits 10:10 */
    cs_uint32 gpio3i               :  1 ; /* bits 9:9 */
    cs_uint32 gpio2i               :  1 ; /* bits 8:8 */
    cs_uint32 gpio1i               :  1 ; /* bits 7:7 */
    cs_uint32 gpio0i               :  1 ; /* bits 6:6 */
    cs_uint32 spii                 :  1 ; /* bits 5:5 */
    cs_uint32 axii                 :  1 ; /* bits 4:4 */
    cs_uint32 tmr2i                :  1 ; /* bits 3:3 */
    cs_uint32 tmr1i                :  1 ; /* bits 2:2 */
    cs_uint32 soft1i               :  1 ; /* bits 1:1 */
    cs_uint32 soft0i               :  1 ; /* bits 0:0 */
#   else /* CS_LITTLE_ENDIAN */
    cs_uint32 soft0i               :  1 ; /* bits 0:0 */
    cs_uint32 soft1i               :  1 ; /* bits 1:1 */
    cs_uint32 tmr1i                :  1 ; /* bits 2:2 */
    cs_uint32 tmr2i                :  1 ; /* bits 3:3 */
    cs_uint32 axii                 :  1 ; /* bits 4:4 */
    cs_uint32 spii                 :  1 ; /* bits 5:5 */
    cs_uint32 gpio0i               :  1 ; /* bits 6:6 */
    cs_uint32 gpio1i               :  1 ; /* bits 7:7 */
    cs_uint32 gpio2i               :  1 ; /* bits 8:8 */
    cs_uint32 gpio3i               :  1 ; /* bits 9:9 */
    cs_uint32 gpio4i               :  1 ; /* bits 10:10 */
    cs_uint32 biwi                 :  1 ; /* bits 11:11 */
    cs_uint32 mdioi                :  1 ; /* bits 12:12 */
    cs_uint32 sspi                 :  1 ; /* bits 13:13 */
    cs_uint32 trngi                :  1 ; /* bits 14:14 */
    cs_uint32 rsrvd1               : 17 ;
#   endif
  } bf ;
  cs_uint32     wrd ;
} PER_PERIPHERAL_INTERRUPT_0_t;





#define PER_PERIPHERAL_INTENABLE_0               0xf0070008
#define PER_PERIPHERAL_INTENABLE_0_dft           0x00000000




typedef volatile union {
  struct {
#   ifdef CS_BIG_ENDIAN 
    cs_uint32 rsrvd1               : 17 ;
    cs_uint32 trnge                :  1 ; /* bits 14:14 */
    cs_uint32 sspe                 :  1 ; /* bits 13:13 */
    cs_uint32 mdioe                :  1 ; /* bits 12:12 */
    cs_uint32 biwe                 :  1 ; /* bits 11:11 */
    cs_uint32 gpio4e               :  1 ; /* bits 10:10 */
    cs_uint32 gpio3e               :  1 ; /* bits 9:9 */
    cs_uint32 gpio2e               :  1 ; /* bits 8:8 */
    cs_uint32 gpio1e               :  1 ; /* bits 7:7 */
    cs_uint32 gpio0e               :  1 ; /* bits 