/* arch/arm/mach-goldengate/include/mach/gpio.h
 *
 * Copyright (c) 2010 Cortina-Systems <linux@cortina-systems.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * GoldenGate GPIO definition
*/

#ifndef __MACH_GPIO_H__
#define __MACH_GPIO_H__

#include <mach/irqs.h>
#include <asm-generic/gpio.h>

#define gpio_get_value	__gpio_get_value
#define gpio_set_value	__gpio_set_value
#define gpio_cansleep	__gpio_cansleep

#define gpio_to_irq(x)	((x) + GPIO_IRQ_BASE)
#define irq_to_gpio(x)	((x) - GPIO_IRQ_BASE)

#define GPIO_BANK_NUM	5
#define GPIO_BANK_SIZE	32

#define CS75XX_GPIO_CTLR_NAME	"cs75xx_gpio"

#define GPIO0_BIT0	(0 * GPIO_BANK_SIZE + 0)
#define GPIO0_BIT1	(0 * GPIO_BANK_SIZE + 1)
#define GPIO0_BIT2	(0 * GPIO_BANK_SIZE + 2)
#define GPIO0_BIT3	(0 * GPIO_BANK_SIZE + 3)
#define GPIO0_BIT4	(0 * GPIO_BANK_SIZE + 4)
#define GPIO0_BIT5	(0 * GPIO_BANK_SIZE + 5)
#define GPIO0_BIT6	(0 * GPIO_BANK_SIZE + 6)
#define GPIO0_BIT7	(0 * GPIO_BANK_SIZE + 7)
#define GPIO0_BIT8	(0 * GPIO_BANK_SIZE + 8)
#define GPIO0_BIT9	(0 * GPIO_BANK_SIZE + 9)
#define GPIO0_BIT10	(0 * GPIO_BANK_SIZE + 10)
#define GPIO0_BIT11	(0 * GPIO_BANK_SIZE + 11)
#define GPIO0_BIT12	(0 * GPIO_BANK_SIZE + 12)
#define GPIO0_BIT13	(0 * GPIO_BANK_SIZE + 13)
#define GPIO0_BIT14	(0 * GPIO_BANK_SIZE + 14)
#define GPIO0_BIT15	(0 * GPIO_BANK_SIZE + 15)
#define GPIO0_BIT16	(0 * GPIO_BANK_SIZE + 16)
#define GPIO0_BIT17	(0 * GPIO_BANK_SIZE + 17)
#define GPIO0_BIT18	(0 * GPIO_BANK_SIZE + 18)
#define GPIO0_BIT19	(0 * GPIO_BANK_SIZE + 19)
#define GPIO0_BIT20	(0 * GPIO_BANK_SIZE + 20)
#define GPIO0_BIT21	(0 * GPIO_BANK_SIZE + 21)
#define GPIO0_BIT22	(0 * GPIO_BANK_SIZE + 22)
#define GPIO0_BIT23	(0 * GPIO_BANK_SIZE + 23)
#define GPIO0_BIT24	(0 * GPIO_BANK_SIZE + 24)
#define GPIO0_BIT25	(0 * GPIO_BANK_SIZE + 25)
#define GPIO0_BIT26	(0 * GPIO_BANK_SIZE + 26)
#define GPIO0_BIT27	(0 * GPIO_BANK_SIZE + 27)
#define GPIO0_BIT28	(0 * GPIO_BANK_SIZE + 28)
#define GPIO0_BIT29	(0 * GPIO_BANK_SIZE + 29)
#define GPIO0_BIT30	(0 * GPIO_BANK_SIZE + 30)
#define GPIO0_BIT31	(0 * GPIO_BANK_SIZE + 31)

#define GPIO1_BIT0	(1 * GPIO_BANK_SIZE + 0)
#define GPIO1_BIT1	(1 * GPIO_BANK_SIZE + 1)
#define GPIO1_BIT2	(1 * GPIO_BANK_SIZE + 2)
#define GPIO1_BIT3	(1 * GPIO_BANK_SIZE + 3)
#define GPIO1_BIT4	(1 * GPIO_BANK_SIZE + 4)
#define GPIO1_BIT5	(1 * GPIO_BANK_SIZE + 5)
#define GPIO1_BIT6	(1 * GPIO_BANK_SIZE + 6)
#define GPIO1_BIT7	(1 * GPIO_BANK_SIZE + 7)
#define GPIO1_BIT8	(1 * GPIO_BANK_SIZE + 8)
#define GPIO1_BIT9	(1 * GPIO_BANK_SIZE + 9)
#define GPIO1_BIT10	(1 * GPIO_BANK_SIZE + 10)
#define GPIO1_BIT11	(1 * GPIO_BANK_SIZE + 11)
#define GPIO1_BIT12	(1 * GPIO_BANK_SIZE + 12)
#define GPIO1_BIT13	(1 * GPIO_BANK_SIZE + 13)
#define GPIO1_BIT14	(1 * GPIO_BANK_SIZE + 14)
#define GPIO1_BIT15	(1 * GPIO_BANK_SIZE + 15)
#define GPIO1_BIT16	(1 * GPIO_BANK_SIZE + 16)
#define GPIO1_BIT17	(1 * GPIO_BANK_SIZE + 17)
#define GPIO1_BIT18	(1 * GPIO_BANK_SIZE + 18)
#define GPIO1_BIT19	(1 * GPIO_BANK_SIZE + 19)
#define GPIO1_BIT20	(1 * GPIO_BANK_SIZE + 20)
#define GPIO1_BIT21	(1 * GPIO_BANK_SIZE + 21)
#define GPIO1_BIT22	(1 * GPIO_BANK_SIZE + 22)
#define GPIO1_BIT23	(1 * GPIO_BANK_SIZE + 23)
#define GPIO1_BIT24	(1 * GPIO_BANK_SIZE + 24)
#define GPIO1_BIT25	(1 * GPIO_BANK_SIZE + 25)
#define GPIO1_BIT26	(1 * GPIO_BANK_SIZE + 26)
#define GPIO1_BIT27	(1 * GPIO_BANK_SIZE + 27)
#define GPIO1_BIT28	(1 * GPIO_BANK_SIZE + 28)
#define GPIO1_BIT29	(1 * GPIO_BANK_SIZE + 29)
#define GPIO1_BIT30	(1 * GPIO_BANK_SIZE + 30)
#define GPIO1_BIT31	(1 * GPIO_BANK_SIZE + 31)

#define GPIO2_BIT0	(2 * GPIO_BANK_SIZE + 0)
#define GPIO2_BIT1	(2 * GPIO_BANK_SIZE + 1)
#define GPIO2_BIT2	(2 * GPIO_BANK_SIZE + 2)
#define GPIO2_BIT3	(2 * GPIO_BANK_SIZE + 3)
#define GPIO2_BIT4	(2 * GPIO_BANK_SIZE + 4)
#define GPIO2_BIT5	(2 * GPIO_BANK_SIZE + 5)
#define GPIO2_BIT6	(2 * GPIO_BANK_SIZE + 6)
#define GPIO2_BIT7	(2 * GPIO_BANK_SIZE + 7)
#define GPIO2_BIT8	(2 * GPIO_BANK_SIZE + 8)
#define GPIO2_BIT9	(2 * GPIO_BANK_SIZE + 9)
#define GPIO2_BIT10	(2 * GPIO_BANK_SIZE + 10)
#define GPIO2_BIT11	(2 * GPIO_BANK_SIZE + 11)
#define GPIO2_BIT12	(2 * GPIO_BANK_SIZE + 12)
#define GPIO2_BIT13	(2 * GPIO_BANK_SIZE + 13)
#define GPIO2_BIT14	(2 * GPIO_BANK_SIZE + 14)
#define GPIO2_BIT15	(2 * GPIO_BANK_SIZE + 15)
#define GPIO2_BIT16	(2 * GPIO_BANK_SIZE + 16)
#define GPIO2_BIT17	(2 * GPIO_BANK_SIZE + 17)
#define GPIO2_BIT18	(2 * GPIO_BANK_SIZE + 18)
#define GPIO2_BIT19	(2 * GPIO_BANK_SIZE + 19)
#define GPIO2_BIT20	(2 * GPIO_BANK_SIZE + 20)
#define GPIO2_BIT21	(2 * GPIO_BANK_SIZE + 21)
#define GPIO2_BIT22	(2 * GPIO_BANK_SIZE + 22)
#define GPIO2_BIT23	(2 * GPIO_BANK_SIZE + 23)
#define GPIO2_BIT24	(2 * GPIO_BANK_SIZE + 24)
#define GPIO2_BIT25	(2 * GPIO_BANK_SIZE + 25)
#define GPIO2_BIT26	(2 * GPIO_BANK_SIZE + 26)
#define GPIO2_BIT27	(2 * GPIO_BANK_SIZE + 27)
#define GPIO2_BIT28	(2 * GPIO_BANK_SIZE + 28)
#define GPIO2_BIT29	(2 * GPIO_BANK_SIZE + 29)
#define GPIO2_BIT30	(2 * GPIO_BANK_SIZE + 30)
#define GPIO2_BIT31	(2 * GPIO_BANK_SIZE + 31)

#define GPIO3_BIT0	(3 * GPIO_BANK_SIZE + 0)
#define GPIO3_BIT1	(3 * GPIO_BANK_SIZE + 1)
#define GPIO3_BIT2	(3 * GPIO_BANK_SIZE + 2)
#define GPIO3_BIT3	(3 * GPIO_BANK_SIZE + 3)
#define GPIO3_BIT4	(3 * GPIO_BANK_SIZE + 4)
#define GPIO3_BIT5	(3 * GPIO_BANK_SIZE + 5)
#define GPIO3_BIT6	(3 * GPIO_BANK_SIZE + 6)
#define GPIO3_BIT7	(3 * GPIO_BANK_SIZE + 7)
#define GPIO3_BIT8	(3 * GPIO_BANK_SIZE + 8)
#define GPIO3_BIT9	(3 * GPIO_BANK_SIZE + 9)
#define GPIO3_BIT10	(3 * GPIO_BANK_SIZE + 10)
#define GPIO3_BIT11	(3 * GPIO_BANK_SIZE + 11)
#define GPIO3_BIT12	(3 * GPIO_BANK_SIZE + 12)
#define GPIO3_BIT13	(3 * GPIO_BANK_SIZE + 13)
#define GPIO3_BIT14	(3 * GPIO_BANK_SIZE + 14)
#define GPIO3_BIT15	(3 * GPIO_BANK_SIZE + 15)
#define GPIO3_BIT16	(3 * GPIO_BANK_SIZE + 16)
#define GPIO3_BIT17	(3 * GPIO_BANK_SIZE + 17)
#define GPIO3_BIT18	(3 * GPIO_BANK_SIZE + 18)
#define GPIO3_BIT19	(3 * GPIO_BANK_SIZE + 19)
#define GPIO3_BIT20	(3 * GPIO_BANK_SIZE + 20)
#define GPIO3_BIT21	(3 * GPIO_BANK_SIZE + 21)
#define GPIO3_BIT22	(3 * GPIO_BANK_SIZE + 22)
#define GPIO3_BIT23	(3 * GPIO_BANK_SIZE + 23)
#define GPIO3_BIT24	(3 * GPIO_BANK_SIZE + 24)
#define GPIO3_BIT25	(3 * GPIO_BANK_SIZE + 25)
#define GPIO3_BIT26	(3 * GPIO_BANK_SIZE + 26)
#define GPIO3_BIT27	(3 * GPIO_BANK_SIZE + 27)
#define GPIO3_BIT28	(3 * GPIO_BANK_SIZE + 28)
#define GPIO3_BIT29	(3 * GPIO_BANK_SIZE + 29)
#define GPIO3_BIT30	(3 * GPIO_BANK_SIZE + 30)
#define GPIO3_BIT31	(3 * GPIO_BANK_SIZE + 31)

#define GPIO4_BIT0	(4 * GPIO_BANK_SIZE + 0)
#define GPIO4_BIT1	(4 * GPIO_BANK_SIZE + 1)
#define GPIO4_BIT2	(4 * GPIO_BANK_SIZE + 2)
#define GPIO4_BIT3	(4 * GPIO_BANK_SIZE + 3)
#define GPIO4_BIT4	(4 * GPIO_BANK_SIZE + 4)
#define GPIO4_BIT5	(4 * GPIO_BANK_SIZE + 5)
#define GPIO4_BIT6	(4 * GPIO_BANK_SIZE + 6)
#define GPIO4_BIT7	(4 * GPIO_BANK_SIZE + 7)
#define GPIO4_BIT8	(4 * GPIO_BANK_SIZE + 8)
#define GPIO4_BIT9	(4 * GPIO_BANK_SIZE + 9)
#define GPIO4_BIT10	(4 * GPIO_BANK_SIZE + 10)
#define GPIO4_BIT11	(4 * GPIO_BANK_SIZE + 11)
#define GPIO4_BIT12	(4 * GPIO_BANK_SIZE + 12)
#define GPIO4_BIT13	(4 * GPIO_BANK_SIZE + 13)
#define GPIO4_BIT14	(4 * GPIO_BANK_SIZE + 14)
#define GPIO4_BIT15	(4 * GPIO_BANK_SIZE + 15)
#define GPIO4_BIT16	(4 * GPIO_BANK_SIZE + 16)
#define GPIO4_BIT17	(4 * GPIO_BANK_SIZE + 17)
#define GPIO4_BIT18	(4 * GPIO_BANK_SIZE + 18)
#define GPIO4_BIT19	(4 * GPIO_BANK_SIZE + 19)
#define GPIO4_BIT20	(4 * GPIO_BANK_SIZE + 20)
#define GPIO4_BIT21	(4 * GPIO_BANK_SIZE + 21)
#define GPIO4_BIT22	(4 * GPIO_BANK_SIZE + 22)
#define GPIO4_BIT23	(4 * GPIO_BANK_SIZE + 23)
#define GPIO4_BIT24	(4 * GPIO_BANK_SIZE + 24)
#define GPIO4_BIT25	(4 * GPIO_BANK_SIZE + 25)
#define GPIO4_BIT26	(4 * GPIO_BANK_SIZE + 26)
#define GPIO4_BIT27	(4 * GPIO_BANK_SIZE + 27)
#define GPIO4_BIT28	(4 * GPIO_BANK_SIZE + 28)
#define GPIO4_BIT29	(4 * GPIO_BANK_SIZE + 29)
#define GPIO4_BIT30	(4 * GPIO_BANK_SIZE + 30)
#define GPIO4_BIT31	(4 * GPIO_BANK_SIZE + 31)

#endif /* __MACH_GPIO_H__ */