This target is an extension of the QUEUE target. As opposed to QUEUE, it allows
you to put a packet into any specific queue, identified by its 16-bit queue
number.
It can only be used with Kernel versions 2.6.14 or later, since it requires
the
.B
nfnetlink_queue
kernel support. The \fBqueue-balance\fP option was added in Linux 2.6.31,
\fBqueue-bypass\fP in 2.6.39.
.TP
\fB\-\-queue\-num\fP \fIvalue\fP
This specifies the QUEUE number to use. Valid queue numbers are 0 to 65535. The default value is 0.
.PP
.TP
\fB\-\-queue\-balance\fP \fIvalue\fP\fB:\fP\fIvalue\fP
This specifies a range of queues to use. Packets are then balanced across the given queues.
This is useful for multicore systems: start multiple instances of the userspace program on
queues x, x+1, .. x+n and use "\-\-queue\-balance \fIx\fP\fB:\fP\fIx+n\fP".
Packets belonging to the same connection are put into the same nfqueue.
.PP
.TP
\fB\-\-queue\-bypass\fP
By default, if no userspace program is listening on an NFQUEUE, then all packets that are to be queued
are dropped.  When this option is used, the NFQUEUE rule is silently bypassed instead. The packet
will move on to the next rule.
