#include <sys/types.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "netinet/in.h"
#include "unistd.h"
#include "netdb.h"
#include "http.h"

static char *get_line(char *data, char **next)
{
	char *ptr = data;
	*next = NULL;
	ptr = strchr(data, '\n');
	if (ptr != NULL)
		*next = ptr+1;
	return data;
}

int read_chunkdata(char *orgdata, int bytes)
{
	char *next, *line, *data;
	int len = 0;
	unsigned int chunksize;
	char *buf = (char *)malloc(bytes);

	if (buf)
	{
		data = orgdata;
		line = get_line(data, &next);
		while(line)
		{
			chunksize = 0;
			sscanf(line, "%x", &chunksize);
			if (len+chunksize > bytes)
			{
				printf("chunksize = %d is bigger than buffer %d\n", len+chunksize, bytes);
				free(buf);
				return 0;
			}
			if (chunksize > 0 && next != NULL)
			{
				memcpy(&buf[len], next, chunksize);
				len += chunksize;
				data = next + chunksize + 2; //+CRLF
				line = get_line(data, &next);
			}
			else
				break;
		}
		memcpy(orgdata, buf, len);
		free(buf);
	}
	return len;
}

int senddata(struct request_rec *rec, char *buf, int buflen, int flag)
{
	int w = 0, o;
	if (rec->useSSL == 0)
		w = send(rec->sd, buf, buflen, flag);
	else
	{
		while(buflen && (o = SSL_write(rec->ssl, buf+w, buflen)) > 0)
		{
			w += o;
			buflen -= o;
		}
	}
	return w;
}

int recvdatapayload(struct request_rec *rec, char **data)
{
	char *buf = NULL;
	int used, bytes;
	char peek;
	fd_set readfds;
	struct timeval timeouts;
	int r = 0;

	FD_ZERO(&readfds);
	timeouts.tv_sec = 6;
	timeouts.tv_usec = 0;
	FD_SET(rec->sd, &readfds);
	buf = (char *)malloc(1024);
	used = 0;
	if (rec->useSSL == 0)
	{
		r = select(rec->sd+1, &readfds, NULL, NULL, &timeouts);
		while (r > 0 && FD_ISSET(rec->sd, &readfds)) 
		{
			if (recv(rec->sd, &peek, 1, MSG_PEEK|MSG_DONTWAIT) <= 0) //peer close
				break;
			if ((bytes = recv(rec->sd, &buf[used], 1024, 0)) > 0)
			{
				used += bytes;
				buf = (char *)realloc(buf, used+1024);
				//printf("%d\n", used);
			}
			else
				break;
			r = select(rec->sd+1, &readfds, NULL, NULL, &timeouts);
		}
	}
	else
	{
		int nRetry = 0;
		while(nRetry < 3)
		{
			bytes = SSL_read(rec->ssl, &buf[used], 1024);
			if (bytes <= 0)
			{
				int err = SSL_get_error(rec->ssl, bytes);
				if (err == SSL_ERROR_WANT_READ)
				{
					nRetry++;
					continue;
				}
				else 
					break;
			}
			else
			{
				used += bytes;
				buf = (char *)realloc(buf, used+1024);
				//printf("%d\n", used);
				if (SSL_pending(rec->ssl) == 0)
				{
					r = select(rec->sd+1, &readfds, NULL, NULL, &timeouts);
					if (r > 0 && FD_ISSET(rec->sd, &readfds))
					{
						if (recv(rec->sd, &peek, 1, MSG_PEEK|MSG_DONTWAIT) <= 0) //peer close.
							break;
					}
					else
						break;
				}
			}
		}
	}

	buf[used] = '\0';
	*data = buf;
	return used;
}

int getHeader(struct request_rec *rec, int timeout)
{
	int ret, n, size = MAX_HEADER_SIZE -1;
	char *ptr, *endp = NULL;
	char end_str[5]={0xd, 0xa, 0xd, 0xa, 0};
	fd_set readfds;
	struct timeval timeouts;
	int r;

	rec->in_header_lens = 0;

	FD_ZERO(&readfds);
	/* wait for data */
	timeouts.tv_sec = timeout;
	timeouts.tv_usec = 0;
	FD_SET(rec->sd, &readfds);

	r = select(rec->sd+1, &readfds, NULL, NULL, &timeouts);
	if (r == -1)
	{
		printf("getHeader select error!\n");
		return -1;
	}
	if (r == 0) /* timeout */
	{
		printf("getHeader timeout!\n");
		return -1;
	}

	ptr = rec->szIn_buf;

	if (rec->useSSL == 0)
	{
		ret = recv(rec->sd, ptr, size, MSG_PEEK);
		if (ret <= 0) 
		{
			printf("Read error!!\n");
			return -1;
		}

		ptr[ret] = '\0'; // add ending zero for strstr()
		endp = strstr(ptr, end_str);
		if (endp) 
		{
			n = endp - ptr + strlen(end_str);
		} else
			return -1;

		/* read that many bytes */
		ptr = rec->szIn_buf;
		ret = recv(rec->sd, ptr, n, 0);
		rec->in_header_lens = ret;
		ptr[ret] = '\0';
		rec->in_buf_used = 0;
	}
	else
	{
		char c; 
		int len = 0;
		ptr = rec->szIn_buf;
		while(SSL_read(rec->ssl, &c, 1) > 0 && len < size)
		{
#if HTTP_DEBUG > 1
			putchar(c);
#endif
			if (len > 3 && c == 0xa)
			{
				if (*(ptr -1) == 0xd && *(ptr -2) == 0xa && *(ptr -3) == 0xd)
				{
					*ptr = c;
					len++;
					ptr++;					
					break;
				}
			}
			*ptr = c;
			ptr ++;
			len ++;
		}

		*ptr = '\0';
		rec->in_header_lens = len;
		rec->in_buf_used = 0;
	}

#if HTTP_DEBUG > 0
	printf("End of getHeader.\n");
#endif
	return 0;
}

int ht_getline(struct request_rec *rec, char *linebuf, int buflen) 
{
	int len;
	char ending[3] = {'\015', '\012', '\0'};
	char *ptr, *end;

	if (rec->in_buf_used < rec->in_header_lens)
	{
		ptr = rec->szIn_buf + rec->in_buf_used;
		if ((end=strstr(ptr, ending)) != NULL)
		{
			len = end - ptr;
			rec->in_buf_used += (len +2);
			if (len >= buflen)
				len = buflen -1;
			memcpy(linebuf, ptr, len);
			linebuf[len] = '\0';
			return 1;
		}
	}
	return 0;
}

SSL_CTX* InitSSLClient()
{
	const SSL_METHOD *meth;
	SSL_CTX* ctx = NULL;

	SSL_load_error_strings();
	SSLeay_add_ssl_algorithms();

	meth = TLSv1_2_client_method();
	ctx = SSL_CTX_new (meth);
	if (!ctx) 
	{
		ERR_print_errors_fp(stderr);
		return NULL;
	}

	SSL_CTX_set_options(ctx, SSL_OP_NO_SSLv2 |SSL_OP_NO_SSLv3);
	SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);
	return ctx;
}

void CloseSSLClient(SSL *ssl)
{
	SSL_shutdown (ssl);
	SSL_free(ssl);
	ERR_remove_state(0);
}


